/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.atomic.AtomicInteger;

public class FloatArrays {
    public static final float[] EMPTY_ARRAY = new float[0];
    private static final int QUICKSORT_NO_REC = 16;
    private static final int PARALLEL_QUICKSORT_NO_FORK = 8192;
    private static final int QUICKSORT_MEDIAN_OF_9 = 128;
    private static final int MERGESORT_NO_REC = 16;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 4;
    private static final int RADIXSORT_NO_REC = 1024;
    private static final int PARALLEL_RADIXSORT_NO_FORK = 1024;
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<float[]> HASH_STRATEGY = new ArrayHashStrategy();

    private FloatArrays() {
    }

    public static float[] ensureCapacity(float[] array, int length) {
        if (length > array.length) {
            float[] t2 = new float[length];
            System.arraycopy(array, 0, t2, 0, array.length);
            return t2;
        }
        return array;
    }

    public static float[] ensureCapacity(float[] array, int length, int preserve) {
        if (length > array.length) {
            float[] t2 = new float[length];
            System.arraycopy(array, 0, t2, 0, preserve);
            return t2;
        }
        return array;
    }

    public static float[] grow(float[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.max(Math.min(2L * (long)array.length, 0x7FFFFFF7L), (long)length);
            float[] t2 = new float[newLength];
            System.arraycopy(array, 0, t2, 0, array.length);
            return t2;
        }
        return array;
    }

    public static float[] grow(float[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.max(Math.min(2L * (long)array.length, 0x7FFFFFF7L), (long)length);
            float[] t2 = new float[newLength];
            System.arraycopy(array, 0, t2, 0, preserve);
            return t2;
        }
        return array;
    }

    public static float[] trim(float[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        float[] t2 = length == 0 ? EMPTY_ARRAY : new float[length];
        System.arraycopy(array, 0, t2, 0, length);
        return t2;
    }

    public static float[] setLength(float[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return FloatArrays.trim(array, length);
        }
        return FloatArrays.ensureCapacity(array, length);
    }

    public static float[] copy(float[] array, int offset, int length) {
        FloatArrays.ensureOffsetLength(array, offset, length);
        float[] a = length == 0 ? EMPTY_ARRAY : new float[length];
        System.arraycopy(array, offset, a, 0, length);
        return a;
    }

    public static float[] copy(float[] array) {
        return (float[])array.clone();
    }

    @Deprecated
    public static void fill(float[] array, float value2) {
        int i = array.length;
        while (i-- != 0) {
            array[i] = value2;
        }
    }

    @Deprecated
    public static void fill(float[] array, int from2, int to, float value2) {
        FloatArrays.ensureFromTo(array, from2, to);
        if (from2 == 0) {
            while (to-- != 0) {
                array[to] = value2;
            }
        } else {
            for (int i = from2; i < to; ++i) {
                array[i] = value2;
            }
        }
    }

    @Deprecated
    public static boolean equals(float[] a1, float[] a2) {
        int i = a1.length;
        if (i != a2.length) {
            return false;
        }
        while (i-- != 0) {
            if (Float.floatToIntBits(a1[i]) == Float.floatToIntBits(a2[i])) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(float[] a, int from2, int to) {
        Arrays.ensureFromTo(a.length, from2, to);
    }

    public static void ensureOffsetLength(float[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    public static void ensureSameLength(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Array size mismatch: " + a.length + " != " + b.length);
        }
    }

    public static void swap(float[] x, int a, int b) {
        float t2 = x[a];
        x[a] = x[b];
        x[b] = t2;
    }

    public static void swap(float[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            FloatArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(float[] x, int a, int b, int c, FloatComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(float[] a, int from2, int to, FloatComparator comp) {
        for (int i = from2; i < to - 1; ++i) {
            int m3 = i;
            for (int j = i + 1; j < to; ++j) {
                if (comp.compare(a[j], a[m3]) >= 0) continue;
                m3 = j;
            }
            if (m3 == i) continue;
            float u = a[i];
            a[i] = a[m3];
            a[m3] = u;
        }
    }

    private static void insertionSort(float[] a, int from2, int to, FloatComparator comp) {
        int i = from2;
        while (++i < to) {
            float t2 = a[i];
            int j = i;
            float u = a[j - 1];
            while (comp.compare(t2, u) < 0) {
                a[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t2;
        }
    }

    public static void quickSort(float[] x, int from2, int to, FloatComparator comp) {
        int c;
        int a;
        int len2 = to - from2;
        if (len2 < 16) {
            FloatArrays.selectionSort(x, from2, to, comp);
            return;
        }
        int m3 = from2 + len2 / 2;
        int l = from2;
        int n = to - 1;
        if (len2 > 128) {
            int s2 = len2 / 8;
            l = FloatArrays.med3(x, l, l + s2, l + 2 * s2, comp);
            m3 = FloatArrays.med3(x, m3 - s2, m3, m3 + s2, comp);
            n = FloatArrays.med3(x, n - 2 * s2, n - s2, n, comp);
        }
        m3 = FloatArrays.med3(x, l, m3, n, comp);
        float v = x[m3];
        int b = a = from2;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    FloatArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    FloatArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            FloatArrays.swap(x, b++, c--);
        }
        int s3 = Math.min(a - from2, b - a);
        FloatArrays.swap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, to - d - 1);
        FloatArrays.swap(x, b, to - s3, s3);
        s3 = b - a;
        if (s3 > 1) {
            FloatArrays.quickSort(x, from2, from2 + s3, comp);
        }
        if ((s3 = d - c) > 1) {
            FloatArrays.quickSort(x, to - s3, to, comp);
        }
    }

    public static void quickSort(float[] x, FloatComparator comp) {
        FloatArrays.quickSort(x, 0, x.length, comp);
    }

    public static void parallelQuickSort(float[] x, int from2, int to, FloatComparator comp) {
        ForkJoinPool pool = new ForkJoinPool(Runtime.getRuntime().availableProcessors());
        pool.invoke(new ForkJoinQuickSortComp(x, from2, to, comp));
        pool.shutdown();
    }

    public static void parallelQuickSort(float[] x, FloatComparator comp) {
        FloatArrays.parallelQuickSort(x, 0, x.length, comp);
    }

    private static int med3(float[] x, int a, int b, int c) {
        int ab = Float.compare(x[a], x[b]);
        int ac = Float.compare(x[a], x[c]);
        int bc = Float.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(float[] a, int from2, int to) {
        for (int i = from2; i < to - 1; ++i) {
            int m3 = i;
            for (int j = i + 1; j < to; ++j) {
                if (Float.compare(a[j], a[m3]) >= 0) continue;
                m3 = j;
            }
            if (m3 == i) continue;
            float u = a[i];
            a[i] = a[m3];
            a[m3] = u;
        }
    }

    private static void insertionSort(float[] a, int from2, int to) {
        int i = from2;
        while (++i < to) {
            float t2 = a[i];
            int j = i;
            float u = a[j - 1];
            while (Float.compare(t2, u) < 0) {
                a[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t2;
        }
    }

    public static void quickSort(float[] x, int from2, int to) {
        int c;
        int a;
        int len2 = to - from2;
        if (len2 < 16) {
            FloatArrays.selectionSort(x, from2, to);
            return;
        }
        int m3 = from2 + len2 / 2;
        int l = from2;
        int n = to - 1;
        if (len2 > 128) {
            int s2 = len2 / 8;
            l = FloatArrays.med3(x, l, l + s2, l + 2 * s2);
            m3 = FloatArrays.med3(x, m3 - s2, m3, m3 + s2);
            n = FloatArrays.med3(x, n - 2 * s2, n - s2, n);
        }
        m3 = FloatArrays.med3(x, l, m3, n);
        float v = x[m3];
        int b = a = from2;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Float.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    FloatArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Float.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    FloatArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            FloatArrays.swap(x, b++, c--);
        }
        int s3 = Math.min(a - from2, b - a);
        FloatArrays.swap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, to - d - 1);
        FloatArrays.swap(x, b, to - s3, s3);
        s3 = b - a;
        if (s3 > 1) {
            FloatArrays.quickSort(x, from2, from2 + s3);
        }
        if ((s3 = d - c) > 1) {
            FloatArrays.quickSort(x, to - s3, to);
        }
    }

    public static void quickSort(float[] x) {
        FloatArrays.quickSort(x, 0, x.length);
    }

    public static void parallelQuickSort(float[] x, int from2, int to) {
        ForkJoinPool pool = new ForkJoinPool(Runtime.getRuntime().availableProcessors());
        pool.invoke(new ForkJoinQuickSort(x, from2, to));
        pool.shutdown();
    }

    public static void parallelQuickSort(float[] x) {
        FloatArrays.parallelQuickSort(x, 0, x.length);
    }

    private static int med3Indirect(int[] perm, float[] x, int a, int b, int c) {
        float aa = x[perm[a]];
        float bb = x[perm[b]];
        float cc = x[perm[c]];
        int ab = Float.compare(aa, bb);
        int ac = Float.compare(aa, cc);
        int bc = Float.compare(bb, cc);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void insertionSortIndirect(int[] perm, float[] a, int from2, int to) {
        int i = from2;
        while (++i < to) {
            int t2 = perm[i];
            int j = i;
            int u = perm[j - 1];
            while (Float.compare(a[t2], a[u]) < 0) {
                perm[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t2;
        }
    }

    public static void quickSortIndirect(int[] perm, float[] x, int from2, int to) {
        int c;
        int a;
        int len2 = to - from2;
        if (len2 < 16) {
            FloatArrays.insertionSortIndirect(perm, x, from2, to);
            return;
        }
        int m3 = from2 + len2 / 2;
        int l = from2;
        int n = to - 1;
        if (len2 > 128) {
            int s2 = len2 / 8;
            l = FloatArrays.med3Indirect(perm, x, l, l + s2, l + 2 * s2);
            m3 = FloatArrays.med3Indirect(perm, x, m3 - s2, m3, m3 + s2);
            n = FloatArrays.med3Indirect(perm, x, n - 2 * s2, n - s2, n);
        }
        m3 = FloatArrays.med3Indirect(perm, x, l, m3, n);
        float v = x[perm[m3]];
        int b = a = from2;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Float.compare(x[perm[b]], v)) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(perm, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Float.compare(x[perm[c]], v)) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(perm, c, d--);
                }
                --c;
            }
            if (b > c) break;
            IntArrays.swap(perm, b++, c--);
        }
        int s3 = Math.min(a - from2, b - a);
        IntArrays.swap(perm, from2, b - s3, s3);
        s3 = Math.min(d - c, to - d - 1);
        IntArrays.swap(perm, b, to - s3, s3);
        s3 = b - a;
        if (s3 > 1) {
            FloatArrays.quickSortIndirect(perm, x, from2, from2 + s3);
        }
        if ((s3 = d - c) > 1) {
            FloatArrays.quickSortIndirect(perm, x, to - s3, to);
        }
    }

    public static void quickSortIndirect(int[] perm, float[] x) {
        FloatArrays.quickSortIndirect(perm, x, 0, x.length);
    }

    public static void parallelQuickSortIndirect(int[] perm, float[] x, int from2, int to) {
        ForkJoinPool pool = new ForkJoinPool(Runtime.getRuntime().availableProcessors());
        pool.invoke(new ForkJoinQuickSortIndirect(perm, x, from2, to));
        pool.shutdown();
    }

    public static void parallelQuickSortIndirect(int[] perm, float[] x) {
        FloatArrays.parallelQuickSortIndirect(perm, x, 0, x.length);
    }

    public static void stabilize(int[] perm, float[] x, int from2, int to) {
        int curr = from2;
        for (int i = from2 + 1; i < to; ++i) {
            if (x[perm[i]] == x[perm[curr]]) continue;
            if (i - curr > 1) {
                IntArrays.parallelQuickSort(perm, curr, i);
            }
            curr = i;
        }
        if (to - curr > 1) {
            IntArrays.parallelQuickSort(perm, curr, to);
        }
    }

    public static void stabilize(int[] perm, float[] x) {
        FloatArrays.stabilize(perm, x, 0, perm.length);
    }

    private static int med3(float[] x, float[] y, int a, int b, int c) {
        int bc;
        int t2 = Float.compare(x[a], x[b]);
        int ab = t2 == 0 ? Float.compare(y[a], y[b]) : t2;
        t2 = Float.compare(x[a], x[c]);
        int ac = t2 == 0 ? Float.compare(y[a], y[c]) : t2;
        t2 = Float.compare(x[b], x[c]);
        int n = bc = t2 == 0 ? Float.compare(y[b], y[c]) : t2;
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void swap(float[] x, float[] y, int a, int b) {
        float t2 = x[a];
        float u = y[a];
        x[a] = x[b];
        y[a] = y[b];
        x[b] = t2;
        y[b] = u;
    }

    private static void swap(float[] x, float[] y, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            FloatArrays.swap(x, y, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void selectionSort(float[] a, float[] b, int from2, int to) {
        for (int i = from2; i < to - 1; ++i) {
            int m3 = i;
            for (int j = i + 1; j < to; ++j) {
                int u = Float.compare(a[j], a[m3]);
                if (u >= 0 && (u != 0 || Float.compare(b[j], b[m3]) >= 0)) continue;
                m3 = j;
            }
            if (m3 == i) continue;
            float t2 = a[i];
            a[i] = a[m3];
            a[m3] = t2;
            t2 = b[i];
            b[i] = b[m3];
            b[m3] = t2;
        }
    }

    public static void quickSort(float[] x, float[] y, int from2, int to) {
        int c;
        int a;
        int len2 = to - from2;
        if (len2 < 16) {
            FloatArrays.selectionSort(x, y, from2, to);
            return;
        }
        int m3 = from2 + len2 / 2;
        int l = from2;
        int n = to - 1;
        if (len2 > 128) {
            int s2 = len2 / 8;
            l = FloatArrays.med3(x, y, l, l + s2, l + 2 * s2);
            m3 = FloatArrays.med3(x, y, m3 - s2, m3, m3 + s2);
            n = FloatArrays.med3(x, y, n - 2 * s2, n - s2, n);
        }
        m3 = FloatArrays.med3(x, y, l, m3, n);
        float v = x[m3];
        float w = y[m3];
        int b = a = from2;
        int d = c = to - 1;
        while (true) {
            int t2;
            int comparison;
            if (b <= c && (comparison = (t2 = Float.compare(x[b], v)) == 0 ? Float.compare(y[b], w) : t2) <= 0) {
                if (comparison == 0) {
                    FloatArrays.swap(x, y, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = (t2 = Float.compare(x[c], v)) == 0 ? Float.compare(y[c], w) : t2) >= 0) {
                if (comparison == 0) {
                    FloatArrays.swap(x, y, c, d--);
                }
                --c;
            }
            if (b > c) break;
            FloatArrays.swap(x, y, b++, c--);
        }
        int s3 = Math.min(a - from2, b - a);
        FloatArrays.swap(x, y, from2, b - s3, s3);
        s3 = Math.min(d - c, to - d - 1);
        FloatArrays.swap(x, y, b, to - s3, s3);
        s3 = b - a;
        if (s3 > 1) {
            FloatArrays.quickSort(x, y, from2, from2 + s3);
        }
        if ((s3 = d - c) > 1) {
            FloatArrays.quickSort(x, y, to - s3, to);
        }
    }

    public static void quickSort(float[] x, float[] y) {
        FloatArrays.ensureSameLength(x, y);
        FloatArrays.quickSort(x, y, 0, x.length);
    }

    public static void parallelQuickSort(float[] x, float[] y, int from2, int to) {
        ForkJoinPool pool = new ForkJoinPool(Runtime.getRuntime().availableProcessors());
        pool.invoke(new ForkJoinQuickSort2(x, y, from2, to));
        pool.shutdown();
    }

    public static void parallelQuickSort(float[] x, float[] y) {
        FloatArrays.ensureSameLength(x, y);
        FloatArrays.parallelQuickSort(x, y, 0, x.length);
    }

    public static void mergeSort(float[] a, int from2, int to, float[] supp) {
        int len2 = to - from2;
        if (len2 < 16) {
            FloatArrays.insertionSort(a, from2, to);
            return;
        }
        int mid = from2 + to >>> 1;
        FloatArrays.mergeSort(supp, from2, mid, a);
        FloatArrays.mergeSort(supp, mid, to, a);
        if (Float.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a, from2, len2);
            return;
        }
        int p = from2;
        int q = mid;
        for (int i = from2; i < to; ++i) {
            a[i] = q >= to || p < mid && Float.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(float[] a, int from2, int to) {
        FloatArrays.mergeSort(a, from2, to, (float[])a.clone());
    }

    public static void mergeSort(float[] a) {
        FloatArrays.mergeSort(a, 0, a.length);
    }

    public static void mergeSort(float[] a, int from2, int to, FloatComparator comp, float[] supp) {
        int len2 = to - from2;
        if (len2 < 16) {
            FloatArrays.insertionSort(a, from2, to, comp);
            return;
        }
        int mid = from2 + to >>> 1;
        FloatArrays.mergeSort(supp, from2, mid, comp, a);
        FloatArrays.mergeSort(supp, mid, to, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a, from2, len2);
            return;
        }
        int p = from2;
        int q = mid;
        for (int i = from2; i < to; ++i) {
            a[i] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(float[] a, int from2, int to, FloatComparator comp) {
        FloatArrays.mergeSort(a, from2, to, comp, (float[])a.clone());
    }

    public static void mergeSort(float[] a, FloatComparator comp) {
        FloatArrays.mergeSort(a, 0, a.length, comp);
    }

    public static int binarySearch(float[] a, int from2, int to, float key) {
        --to;
        while (from2 <= to) {
            int mid = from2 + to >>> 1;
            float midVal = a[mid];
            if (midVal < key) {
                from2 = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from2 + 1);
    }

    public static int binarySearch(float[] a, float key) {
        return FloatArrays.binarySearch(a, 0, a.length, key);
    }

    public static int binarySearch(float[] a, int from2, int to, float key, FloatComparator c) {
        --to;
        while (from2 <= to) {
            int mid = from2 + to >>> 1;
            float midVal = a[mid];
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from2 = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from2 + 1);
    }

    public static int binarySearch(float[] a, float key, FloatComparator c) {
        return FloatArrays.binarySearch(a, 0, a.length, key, c);
    }

    private static final int fixFloat(float f) {
        int i = Float.floatToIntBits(f);
        return i >= 0 ? i : i ^ Integer.MAX_VALUE;
    }

    public static void radixSort(float[] a) {
        FloatArrays.radixSort(a, 0, a.length);
    }

    public static void radixSort(float[] a, int from2, int to) {
        if (to - from2 < 1024) {
            FloatArrays.quickSort(a, from2, to);
            return;
        }
        int maxLevel = 3;
        int stackSize = 766;
        int[] offsetStack = new int[766];
        int offsetPos = 0;
        int[] lengthStack = new int[766];
        int lengthPos = 0;
        int[] levelStack = new int[766];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to - from2;
        levelStack[levelPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        while (offsetPos > 0) {
            int level;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            int shift = (3 - level % 4) * 8;
            int i = first + length;
            while (i-- != first) {
                int n = FloatArrays.fixFloat(a[i]) >>> shift & 0xFF ^ signMask;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int p = first;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0) {
                    lastUsed = i2;
                }
                pos[i2] = p += count2[i2];
            }
            int end = first + length - count2[lastUsed];
            int c = -1;
            for (int i3 = first; i3 <= end; i3 += count2[c]) {
                float t2 = a[i3];
                c = FloatArrays.fixFloat(t2) >>> shift & 0xFF ^ signMask;
                if (i3 < end) {
                    while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i3) break;
                        float z = t2;
                        t2 = a[d];
                        a[d] = z;
                        c = FloatArrays.fixFloat(t2) >>> shift & 0xFF ^ signMask;
                    }
                    a[i3] = t2;
                }
                if (level < 3 && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        FloatArrays.quickSort(a, i3, i3 + count2[c]);
                    } else {
                        offsetStack[offsetPos++] = i3;
                        lengthStack[lengthPos++] = count2[c];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    public static void parallelRadixSort(final float[] a, int from2, int to) {
        if (to - from2 < 1024) {
            FloatArrays.quickSort(a, from2, to);
            return;
        }
        int maxLevel = 3;
        final LinkedBlockingQueue<Segment> queue = new LinkedBlockingQueue<Segment>();
        queue.add(new Segment(from2, to - from2, 0));
        final AtomicInteger queueSize = new AtomicInteger(1);
        final int numberOfThreads = Runtime.getRuntime().availableProcessors();
        ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads, Executors.defaultThreadFactory());
        ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(executorService);
        int i = numberOfThreads;
        while (i-- != 0) {
            executorCompletionService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    int[] count2 = new int[256];
                    int[] pos = new int[256];
                    while (true) {
                        Segment segment;
                        if (queueSize.get() == 0) {
                            int i = numberOfThreads;
                            while (i-- != 0) {
                                queue.add(POISON_PILL);
                            }
                        }
                        if ((segment = (Segment)queue.take()) == POISON_PILL) {
                            return null;
                        }
                        int first = segment.offset;
                        int length = segment.length;
                        int level = segment.level;
                        int signMask = level % 4 == 0 ? 128 : 0;
                        int shift = (3 - level % 4) * 8;
                        int i = first + length;
                        while (i-- != first) {
                            int n = FloatArrays.fixFloat(a[i]) >>> shift & 0xFF ^ signMask;
                            count2[n] = count2[n] + 1;
                        }
                        int lastUsed = -1;
                        int p = first;
                        for (int i2 = 0; i2 < 256; ++i2) {
                            if (count2[i2] != 0) {
                                lastUsed = i2;
                            }
                            pos[i2] = p += count2[i2];
                        }
                        int end = first + length - count2[lastUsed];
                        int c = -1;
                        for (int i3 = first; i3 <= end; i3 += count2[c]) {
                            float t2 = a[i3];
                            c = FloatArrays.fixFloat(t2) >>> shift & 0xFF ^ signMask;
                            if (i3 < end) {
                                while (true) {
                                    int n = c;
                                    int n2 = pos[n] - 1;
                                    pos[n] = n2;
                                    int d = n2;
                                    if (n2 <= i3) break;
                                    float z = t2;
                                    t2 = a[d];
                                    a[d] = z;
                                    c = FloatArrays.fixFloat(t2) >>> shift & 0xFF ^ signMask;
                                }
                                a[i3] = t2;
                            }
                            if (level < 3 && count2[c] > 1) {
                                if (count2[c] < 1024) {
                                    FloatArrays.quickSort(a, i3, i3 + count2[c]);
                                } else {
                                    queueSize.incrementAndGet();
                                    queue.add(new Segment(i3, count2[c], level + 1));
                                }
                            }
                            count2[c] = 0;
                        }
                        queueSize.decrementAndGet();
                    }
                }
            });
        }
        Throwable problem = null;
        int i2 = numberOfThreads;
        while (i2-- != 0) {
            try {
                executorCompletionService.take().get();
            }
            catch (Exception e) {
                problem = e.getCause();
            }
        }
        executorService.shutdown();
        if (problem != null) {
            throw problem instanceof RuntimeException ? (RuntimeException)problem : new RuntimeException(problem);
        }
    }

    public static void parallelRadixSort(float[] a) {
        FloatArrays.parallelRadixSort(a, 0, a.length);
    }

    public static void radixSortIndirect(int[] perm, float[] a, boolean stable) {
        FloatArrays.radixSortIndirect(perm, a, 0, perm.length, stable);
    }

    public static void radixSortIndirect(int[] perm, float[] a, int from2, int to, boolean stable) {
        int[] support;
        if (to - from2 < 1024) {
            FloatArrays.insertionSortIndirect(perm, a, from2, to);
            return;
        }
        int maxLevel = 3;
        int stackSize = 766;
        int[] offsetStack = new int[766];
        int offsetPos = 0;
        int[] lengthStack = new int[766];
        int lengthPos = 0;
        int[] levelStack = new int[766];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to - from2;
        levelStack[levelPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        int[] nArray = support = stable ? new int[perm.length] : null;
        while (offsetPos > 0) {
            int i;
            int p;
            int level;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            int shift = (3 - level % 4) * 8;
            int i2 = first + length;
            while (i2-- != first) {
                int n = FloatArrays.fixFloat(a[perm[i2]]) >>> shift & 0xFF ^ signMask;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int n = p = stable ? 0 : first;
            for (i = 0; i < 256; ++i) {
                if (count2[i] != 0) {
                    lastUsed = i;
                }
                pos[i] = p += count2[i];
            }
            if (stable) {
                i = first + length;
                while (i-- != first) {
                    int n2 = FloatArrays.fixFloat(a[perm[i]]) >>> shift & 0xFF ^ signMask;
                    int n3 = pos[n2] - 1;
                    pos[n2] = n3;
                    support[n3] = perm[i];
                }
                System.arraycopy(support, 0, perm, first, length);
                p = first;
                for (i = 0; i <= lastUsed; ++i) {
                    if (level < 3 && count2[i] > 1) {
                        if (count2[i] < 1024) {
                            FloatArrays.insertionSortIndirect(perm, a, p, p + count2[i]);
                        } else {
                            offsetStack[offsetPos++] = p;
                            lengthStack[lengthPos++] = count2[i];
                            levelStack[levelPos++] = level + 1;
                        }
                    }
                    p += count2[i];
                }
                java.util.Arrays.fill(count2, 0);
                continue;
            }
            int end = first + length - count2[lastUsed];
            int c = -1;
            for (int i3 = first; i3 <= end; i3 += count2[c]) {
                int t2 = perm[i3];
                c = FloatArrays.fixFloat(a[t2]) >>> shift & 0xFF ^ signMask;
                if (i3 < end) {
                    while (true) {
                        int n4 = c;
                        int n5 = pos[n4] - 1;
                        pos[n4] = n5;
                        int d = n5;
                        if (n5 <= i3) break;
                        int z = t2;
                        t2 = perm[d];
                        perm[d] = z;
                        c = FloatArrays.fixFloat(a[t2]) >>> shift & 0xFF ^ signMask;
                    }
                    perm[i3] = t2;
                }
                if (level < 3 && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        FloatArrays.insertionSortIndirect(perm, a, i3, i3 + count2[c]);
                    } else {
                        offsetStack[offsetPos++] = i3;
                        lengthStack[lengthPos++] = count2[c];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    public static void parallelRadixSortIndirect(final int[] perm, final float[] a, int from2, int to, final boolean stable) {
        if (to - from2 < 1024) {
            FloatArrays.radixSortIndirect(perm, a, from2, to, stable);
            return;
        }
        int maxLevel = 3;
        final LinkedBlockingQueue<Segment> queue = new LinkedBlockingQueue<Segment>();
        queue.add(new Segment(from2, to - from2, 0));
        final AtomicInteger queueSize = new AtomicInteger(1);
        final int numberOfThreads = Runtime.getRuntime().availableProcessors();
        ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads, Executors.defaultThreadFactory());
        ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(executorService);
        final int[] support = stable ? new int[perm.length] : null;
        int i = numberOfThreads;
        while (i-- != 0) {
            executorCompletionService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    int[] count2 = new int[256];
                    int[] pos = new int[256];
                    while (true) {
                        int i;
                        Segment segment;
                        if (queueSize.get() == 0) {
                            int i2 = numberOfThreads;
                            while (i2-- != 0) {
                                queue.add(POISON_PILL);
                            }
                        }
                        if ((segment = (Segment)queue.take()) == POISON_PILL) {
                            return null;
                        }
                        int first = segment.offset;
                        int length = segment.length;
                        int level = segment.level;
                        int signMask = level % 4 == 0 ? 128 : 0;
                        int shift = (3 - level % 4) * 8;
                        int i3 = first + length;
                        while (i3-- != first) {
                            int n = FloatArrays.fixFloat(a[perm[i3]]) >>> shift & 0xFF ^ signMask;
                            count2[n] = count2[n] + 1;
                        }
                        int lastUsed = -1;
                        int p = first;
                        for (i = 0; i < 256; ++i) {
                            if (count2[i] != 0) {
                                lastUsed = i;
                            }
                            pos[i] = p += count2[i];
                        }
                        if (stable) {
                            i = first + length;
                            while (i-- != first) {
                                int n = FloatArrays.fixFloat(a[perm[i]]) >>> shift & 0xFF ^ signMask;
                                int n2 = pos[n] - 1;
                                pos[n] = n2;
                                support[n2] = perm[i];
                            }
                            System.arraycopy(support, first, perm, first, length);
                            p = first;
                            for (i = 0; i <= lastUsed; ++i) {
                                if (level < 3 && count2[i] > 1) {
                                    if (count2[i] < 1024) {
                                        FloatArrays.radixSortIndirect(perm, a, p, p + count2[i], stable);
                                    } else {
                                        queueSize.incrementAndGet();
                                        queue.add(new Segment(p, count2[i], level + 1));
                                    }
                                }
                                p += count2[i];
                            }
                            java.util.Arrays.fill(count2, 0);
                        } else {
                            int end = first + length - count2[lastUsed];
                            int c = -1;
                            for (int i4 = first; i4 <= end; i4 += count2[c]) {
                                int t2 = perm[i4];
                                c = FloatArrays.fixFloat(a[t2]) >>> shift & 0xFF ^ signMask;
                                if (i4 < end) {
                                    while (true) {
                                        int n = c;
                                        int n3 = pos[n] - 1;
                                        pos[n] = n3;
                                        int d = n3;
                                        if (n3 <= i4) break;
                                        int z = t2;
                                        t2 = perm[d];
                                        perm[d] = z;
                                        c = FloatArrays.fixFloat(a[t2]) >>> shift & 0xFF ^ signMask;
                                    }
                                    perm[i4] = t2;
                                }
                                if (level < 3 && count2[c] > 1) {
                                    if (count2[c] < 1024) {
                                        FloatArrays.radixSortIndirect(perm, a, i4, i4 + count2[c], stable);
                                    } else {
                                        queueSize.incrementAndGet();
                                        queue.add(new Segment(i4, count2[c], level + 1));
                                    }
                                }
                                count2[c] = 0;
                            }
                        }
                        queueSize.decrementAndGet();
                    }
                }
            });
        }
        Throwable problem = null;
        int i2 = numberOfThreads;
        while (i2-- != 0) {
            try {
                executorCompletionService.take().get();
            }
            catch (Exception e) {
                problem = e.getCause();
            }
        }
        executorService.shutdown();
        if (problem != null) {
            throw problem instanceof RuntimeException ? (RuntimeException)problem : new RuntimeException(problem);
        }
    }

    public static void parallelRadixSortIndirect(int[] perm, float[] a, boolean stable) {
        FloatArrays.parallelRadixSortIndirect(perm, a, 0, a.length, stable);
    }

    public static void radixSort(float[] a, float[] b) {
        FloatArrays.ensureSameLength(a, b);
        FloatArrays.radixSort(a, b, 0, a.length);
    }

    public static void radixSort(float[] a, float[] b, int from2, int to) {
        if (to - from2 < 1024) {
            FloatArrays.selectionSort(a, b, from2, to);
            return;
        }
        int layers = 2;
        int maxLevel = 7;
        int stackSize = 1786;
        int[] offsetStack = new int[1786];
        int offsetPos = 0;
        int[] lengthStack = new int[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to - from2;
        levelStack[levelPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        while (offsetPos > 0) {
            int level;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            float[] k = level < 4 ? a : b;
            int shift = (3 - level % 4) * 8;
            int i = first + length;
            while (i-- != first) {
                int n = FloatArrays.fixFloat(k[i]) >>> shift & 0xFF ^ signMask;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int p = first;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0) {
                    lastUsed = i2;
                }
                pos[i2] = p += count2[i2];
            }
            int end = first + length - count2[lastUsed];
            int c = -1;
            for (int i3 = first; i3 <= end; i3 += count2[c]) {
                float t2 = a[i3];
                float u = b[i3];
                c = FloatArrays.fixFloat(k[i3]) >>> shift & 0xFF ^ signMask;
                if (i3 < end) {
                    while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i3) break;
                        c = FloatArrays.fixFloat(k[d]) >>> shift & 0xFF ^ signMask;
                        float z = t2;
                        t2 = a[d];
                        a[d] = z;
                        z = u;
                        u = b[d];
                        b[d] = z;
                    }
                    a[i3] = t2;
                    b[i3] = u;
                }
                if (level < 7 && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        FloatArrays.selectionSort(a, b, i3, i3 + count2[c]);
                    } else {
                        offsetStack[offsetPos++] = i3;
                        lengthStack[lengthPos++] = count2[c];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    public static void parallelRadixSort(final float[] a, final float[] b, int from2, int to) {
        if (to - from2 < 1024) {
            FloatArrays.quickSort(a, b, from2, to);
            return;
        }
        int layers = 2;
        if (a.length != b.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 7;
        final LinkedBlockingQueue<Segment> queue = new LinkedBlockingQueue<Segment>();
        queue.add(new Segment(from2, to - from2, 0));
        final AtomicInteger queueSize = new AtomicInteger(1);
        final int numberOfThreads = Runtime.getRuntime().availableProcessors();
        ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads, Executors.defaultThreadFactory());
        ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(executorService);
        int i = numberOfThreads;
        while (i-- != 0) {
            executorCompletionService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    int[] count2 = new int[256];
                    int[] pos = new int[256];
                    while (true) {
                        Segment segment;
                        if (queueSize.get() == 0) {
                            int i = numberOfThreads;
                            while (i-- != 0) {
                                queue.add(POISON_PILL);
                            }
                        }
                        if ((segment = (Segment)queue.take()) == POISON_PILL) {
                            return null;
                        }
                        int first = segment.offset;
                        int length = segment.length;
                        int level = segment.level;
                        int signMask = level % 4 == 0 ? 128 : 0;
                        float[] k = level < 4 ? a : b;
                        int shift = (3 - level % 4) * 8;
                        int i = first + length;
                        while (i-- != first) {
                            int n = FloatArrays.fixFloat(k[i]) >>> shift & 0xFF ^ signMask;
                            count2[n] = count2[n] + 1;
                        }
                        int lastUsed = -1;
                        int p = first;
                        for (int i2 = 0; i2 < 256; ++i2) {
                            if (count2[i2] != 0) {
                                lastUsed = i2;
                            }
                            pos[i2] = p += count2[i2];
                        }
                        int end = first + length - count2[lastUsed];
                        int c = -1;
                        for (int i3 = first; i3 <= end; i3 += count2[c]) {
                            float t2 = a[i3];
                            float u = b[i3];
                            c = FloatArrays.fixFloat(k[i3]) >>> shift & 0xFF ^ signMask;
                            if (i3 < end) {
                                while (true) {
                                    int n = c;
                                    int n2 = pos[n] - 1;
                                    pos[n] = n2;
                                    int d = n2;
                                    if (n2 <= i3) break;
                                    c = FloatArrays.fixFloat(k[d]) >>> shift & 0xFF ^ signMask;
                                    float z = t2;
                                    float w = u;
                                    t2 = a[d];
                                    u = b[d];
                                    a[d] = z;
                                    b[d] = w;
                                }
                                a[i3] = t2;
                                b[i3] = u;
                            }
                            if (level < 7 && count2[c] > 1) {
                                if (count2[c] < 1024) {
                                    FloatArrays.quickSort(a, b, i3, i3 + count2[c]);
                                } else {
                                    queueSize.incrementAndGet();
                                    queue.add(new Segment(i3, count2[c], level + 1));
                                }
                            }
                            count2[c] = 0;
                        }
                        queueSize.decrementAndGet();
                    }
                }
            });
        }
        Throwable problem = null;
        int i2 = numberOfThreads;
        while (i2-- != 0) {
            try {
                executorCompletionService.take().get();
            }
            catch (Exception e) {
                problem = e.getCause();
            }
        }
        executorService.shutdown();
        if (problem != null) {
            throw problem instanceof RuntimeException ? (RuntimeException)problem : new RuntimeException(problem);
        }
    }

    public static void parallelRadixSort(float[] a, float[] b) {
        FloatArrays.ensureSameLength(a, b);
        FloatArrays.parallelRadixSort(a, b, 0, a.length);
    }

    private static void insertionSortIndirect(int[] perm, float[] a, float[] b, int from2, int to) {
        int i = from2;
        while (++i < to) {
            int t2 = perm[i];
            int j = i;
            int u = perm[j - 1];
            while (Float.compare(a[t2], a[u]) < 0 || Float.compare(a[t2], a[u]) == 0 && Float.compare(b[t2], b[u]) < 0) {
                perm[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t2;
        }
    }

    public static void radixSortIndirect(int[] perm, float[] a, float[] b, boolean stable) {
        FloatArrays.ensureSameLength(a, b);
        FloatArrays.radixSortIndirect(perm, a, b, 0, a.length, stable);
    }

    public static void radixSortIndirect(int[] perm, float[] a, float[] b, int from2, int to, boolean stable) {
        int[] support;
        if (to - from2 < 1024) {
            FloatArrays.insertionSortIndirect(perm, a, b, from2, to);
            return;
        }
        int layers = 2;
        int maxLevel = 7;
        int stackSize = 1786;
        int[] offsetStack = new int[1786];
        int offsetPos = 0;
        int[] lengthStack = new int[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to - from2;
        levelStack[levelPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        int[] nArray = support = stable ? new int[perm.length] : null;
        while (offsetPos > 0) {
            int i;
            int p;
            int level;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            float[] k = level < 4 ? a : b;
            int shift = (3 - level % 4) * 8;
            int i2 = first + length;
            while (i2-- != first) {
                int n = FloatArrays.fixFloat(k[perm[i2]]) >>> shift & 0xFF ^ signMask;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int n = p = stable ? 0 : first;
            for (i = 0; i < 256; ++i) {
                if (count2[i] != 0) {
                    lastUsed = i;
                }
                pos[i] = p += count2[i];
            }
            if (stable) {
                i = first + length;
                while (i-- != first) {
                    int n2 = FloatArrays.fixFloat(k[perm[i]]) >>> shift & 0xFF ^ signMask;
                    int n3 = pos[n2] - 1;
                    pos[n2] = n3;
                    support[n3] = perm[i];
                }
                System.arraycopy(support, 0, perm, first, length);
                p = first;
                for (i = 0; i < 256; ++i) {
                    if (level < 7 && count2[i] > 1) {
                        if (count2[i] < 1024) {
                            FloatArrays.insertionSortIndirect(perm, a, b, p, p + count2[i]);
                        } else {
                            offsetStack[offsetPos++] = p;
                            lengthStack[lengthPos++] = count2[i];
                            levelStack[levelPos++] = level + 1;
                        }
                    }
                    p += count2[i];
                }
                java.util.Arrays.fill(count2, 0);
                continue;
            }
            int end = first + length - count2[lastUsed];
            int c = -1;
            for (int i3 = first; i3 <= end; i3 += count2[c]) {
                int t2 = perm[i3];
                c = FloatArrays.fixFloat(k[t2]) >>> shift & 0xFF ^ signMask;
                if (i3 < end) {
                    while (true) {
                        int n4 = c;
                        int n5 = pos[n4] - 1;
                        pos[n4] = n5;
                        int d = n5;
                        if (n5 <= i3) break;
                        int z = t2;
                        t2 = perm[d];
                        perm[d] = z;
                        c = FloatArrays.fixFloat(k[t2]) >>> shift & 0xFF ^ signMask;
                    }
                    perm[i3] = t2;
                }
                if (level < 7 && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        FloatArrays.insertionSortIndirect(perm, a, b, i3, i3 + count2[c]);
                    } else {
                        offsetStack[offsetPos++] = i3;
                        lengthStack[lengthPos++] = count2[c];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    private static void selectionSort(float[][] a, int from2, int to, int level) {
        int layers = a.length;
        int firstLayer = level / 4;
        for (int i = from2; i < to - 1; ++i) {
            int m3 = i;
            block1: for (int j = i + 1; j < to; ++j) {
                for (int p = firstLayer; p < layers; ++p) {
                    if (a[p][j] < a[p][m3]) {
                        m3 = j;
                        continue block1;
                    }
                    if (a[p][j] > a[p][m3]) continue block1;
                }
            }
            if (m3 == i) continue;
            int p = layers;
            while (p-- != 0) {
                float u = a[p][i];
                a[p][i] = a[p][m3];
                a[p][m3] = u;
            }
        }
    }

    public static void radixSort(float[][] a) {
        FloatArrays.radixSort(a, 0, a[0].length);
    }

    public static void radixSort(float[][] a, int from2, int to) {
        if (to - from2 < 1024) {
            FloatArrays.selectionSort(a, from2, to, 0);
            return;
        }
        int layers = a.length;
        int maxLevel = 4 * layers - 1;
        int p = layers;
        int l = a[0].length;
        while (p-- != 0) {
            if (a[p].length == l) continue;
            throw new IllegalArgumentException("The array of index " + p + " has not the same length of the array of index 0.");
        }
        int stackSize = 255 * (layers * 4 - 1) + 1;
        int[] offsetStack = new int[stackSize];
        int offsetPos = 0;
        int[] lengthStack = new int[stackSize];
        int lengthPos = 0;
        int[] levelStack = new int[stackSize];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to - from2;
        levelStack[levelPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        float[] t2 = new float[layers];
        while (offsetPos > 0) {
            int level;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            float[] k = a[level / 4];
            int shift = (3 - level % 4) * 8;
            int i = first + length;
            while (i-- != first) {
                int n = FloatArrays.fixFloat(k[i]) >>> shift & 0xFF ^ signMask;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int p2 = first;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0) {
                    lastUsed = i2;
                }
                pos[i2] = p2 += count2[i2];
            }
            int end = first + length - count2[lastUsed];
            int c = -1;
            for (int i3 = first; i3 <= end; i3 += count2[c]) {
                int p3 = layers;
                while (p3-- != 0) {
                    t2[p3] = a[p3][i3];
                }
                c = FloatArrays.fixFloat(k[i3]) >>> shift & 0xFF ^ signMask;
                if (i3 < end) {
                    block6: while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i3) break;
                        c = FloatArrays.fixFloat(k[d]) >>> shift & 0xFF ^ signMask;
                        p3 = layers;
                        while (true) {
                            if (p3-- == 0) continue block6;
                            float u = t2[p3];
                            t2[p3] = a[p3][d];
                            a[p3][d] = u;
                        }
                        break;
                    }
                    p3 = layers;
                    while (p3-- != 0) {
                        a[p3][i3] = t2[p3];
                    }
                }
                if (level < maxLevel && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        FloatArrays.selectionSort(a, i3, i3 + count2[c], level + 1);
                    } else {
                        offsetStack[offsetPos++] = i3;
                        lengthStack[lengthPos++] = count2[c];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    public static float[] shuffle(float[] a, int from2, int to, Random random) {
        int i = to - from2;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            float t2 = a[from2 + i];
            a[from2 + i] = a[from2 + p];
            a[from2 + p] = t2;
        }
        return a;
    }

    public static float[] shuffle(float[] a, Random random) {
        int i = a.length;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            float t2 = a[i];
            a[i] = a[p];
            a[p] = t2;
        }
        return a;
    }

    public static float[] reverse(float[] a) {
        int length = a.length;
        int i = length / 2;
        while (i-- != 0) {
            float t2 = a[length - i - 1];
            a[length - i - 1] = a[i];
            a[i] = t2;
        }
        return a;
    }

    public static float[] reverse(float[] a, int from2, int to) {
        int length = to - from2;
        int i = length / 2;
        while (i-- != 0) {
            float t2 = a[from2 + length - i - 1];
            a[from2 + length - i - 1] = a[from2 + i];
            a[from2 + i] = t2;
        }
        return a;
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<float[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(float[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(float[] a, float[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset, int length, int level) {
            this.offset = offset;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    protected static class ForkJoinQuickSort2
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final float[] x;
        private final float[] y;

        public ForkJoinQuickSort2(float[] x, float[] y, int from2, int to) {
            this.from = from2;
            this.to = to;
            this.x = x;
            this.y = y;
        }

        @Override
        protected void compute() {
            int c;
            int a;
            float[] x = this.x;
            float[] y = this.y;
            int len2 = this.to - this.from;
            if (len2 < 8192) {
                FloatArrays.quickSort(x, y, this.from, this.to);
                return;
            }
            int m3 = this.from + len2 / 2;
            int l = this.from;
            int n = this.to - 1;
            int s2 = len2 / 8;
            l = FloatArrays.med3(x, y, l, l + s2, l + 2 * s2);
            m3 = FloatArrays.med3(x, y, m3 - s2, m3, m3 + s2);
            n = FloatArrays.med3(x, y, n - 2 * s2, n - s2, n);
            m3 = FloatArrays.med3(x, y, l, m3, n);
            float v = x[m3];
            float w = y[m3];
            int b = a = this.from;
            int d = c = this.to - 1;
            while (true) {
                int t2;
                int comparison;
                if (b <= c && (comparison = (t2 = Float.compare(x[b], v)) == 0 ? Float.compare(y[b], w) : t2) <= 0) {
                    if (comparison == 0) {
                        FloatArrays.swap(x, y, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (comparison = (t2 = Float.compare(x[c], v)) == 0 ? Float.compare(y[c], w) : t2) >= 0) {
                    if (comparison == 0) {
                        FloatArrays.swap(x, y, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                FloatArrays.swap(x, y, b++, c--);
            }
            s2 = Math.min(a - this.from, b - a);
            FloatArrays.swap(x, y, this.from, b - s2, s2);
            s2 = Math.min(d - c, this.to - d - 1);
            FloatArrays.swap(x, y, b, this.to - s2, s2);
            s2 = b - a;
            int t3 = d - c;
            if (s2 > 1 && t3 > 1) {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2(x, y, this.from, this.from + s2), new ForkJoinQuickSort2(x, y, this.to - t3, this.to));
            } else if (s2 > 1) {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2(x, y, this.from, this.from + s2));
            } else {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2(x, y, this.to - t3, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSortIndirect
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final int[] perm;
        private final float[] x;

        public ForkJoinQuickSortIndirect(int[] perm, float[] x, int from2, int to) {
            this.from = from2;
            this.to = to;
            this.x = x;
            this.perm = perm;
        }

        @Override
        protected void compute() {
            int c;
            int a;
            float[] x = this.x;
            int len2 = this.to - this.from;
            if (len2 < 8192) {
                FloatArrays.quickSortIndirect(this.perm, x, this.from, this.to);
                return;
            }
            int m3 = this.from + len2 / 2;
            int l = this.from;
            int n = this.to - 1;
            int s2 = len2 / 8;
            l = FloatArrays.med3Indirect(this.perm, x, l, l + s2, l + 2 * s2);
            m3 = FloatArrays.med3Indirect(this.perm, x, m3 - s2, m3, m3 + s2);
            n = FloatArrays.med3Indirect(this.perm, x, n - 2 * s2, n - s2, n);
            m3 = FloatArrays.med3Indirect(this.perm, x, l, m3, n);
            float v = x[this.perm[m3]];
            int b = a = this.from;
            int d = c = this.to - 1;
            while (true) {
                int comparison;
                if (b <= c && (comparison = Float.compare(x[this.perm[b]], v)) <= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(this.perm, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (comparison = Float.compare(x[this.perm[c]], v)) >= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(this.perm, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                IntArrays.swap(this.perm, b++, c--);
            }
            s2 = Math.min(a - this.from, b - a);
            IntArrays.swap(this.perm, this.from, b - s2, s2);
            s2 = Math.min(d - c, this.to - d - 1);
            IntArrays.swap(this.perm, b, this.to - s2, s2);
            s2 = b - a;
            int t2 = d - c;
            if (s2 > 1 && t2 > 1) {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect(this.perm, x, this.from, this.from + s2), new ForkJoinQuickSortIndirect(this.perm, x, this.to - t2, this.to));
            } else if (s2 > 1) {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect(this.perm, x, this.from, this.from + s2));
            } else {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect(this.perm, x, this.to - t2, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSort
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final float[] x;

        public ForkJoinQuickSort(float[] x, int from2, int to) {
            this.from = from2;
            this.to = to;
            this.x = x;
        }

        @Override
        protected void compute() {
            int c;
            int a;
            float[] x = this.x;
            int len2 = this.to - this.from;
            if (len2 < 8192) {
                FloatArrays.quickSort(x, this.from, this.to);
                return;
            }
            int m3 = this.from + len2 / 2;
            int l = this.from;
            int n = this.to - 1;
            int s2 = len2 / 8;
            l = FloatArrays.med3(x, l, l + s2, l + 2 * s2);
            m3 = FloatArrays.med3(x, m3 - s2, m3, m3 + s2);
            n = FloatArrays.med3(x, n - 2 * s2, n - s2, n);
            m3 = FloatArrays.med3(x, l, m3, n);
            float v = x[m3];
            int b = a = this.from;
            int d = c = this.to - 1;
            while (true) {
                int comparison;
                if (b <= c && (comparison = Float.compare(x[b], v)) <= 0) {
                    if (comparison == 0) {
                        FloatArrays.swap(x, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (comparison = Float.compare(x[c], v)) >= 0) {
                    if (comparison == 0) {
                        FloatArrays.swap(x, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                FloatArrays.swap(x, b++, c--);
            }
            s2 = Math.min(a - this.from, b - a);
            FloatArrays.swap(x, this.from, b - s2, s2);
            s2 = Math.min(d - c, this.to - d - 1);
            FloatArrays.swap(x, b, this.to - s2, s2);
            s2 = b - a;
            int t2 = d - c;
            if (s2 > 1 && t2 > 1) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s2), new ForkJoinQuickSort(x, this.to - t2, this.to));
            } else if (s2 > 1) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s2));
            } else {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.to - t2, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSortComp
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final float[] x;
        private final FloatComparator comp;

        public ForkJoinQuickSortComp(float[] x, int from2, int to, FloatComparator comp) {
            this.from = from2;
            this.to = to;
            this.x = x;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            int c;
            int a;
            float[] x = this.x;
            int len2 = this.to - this.from;
            if (len2 < 8192) {
                FloatArrays.quickSort(x, this.from, this.to, this.comp);
                return;
            }
            int m3 = this.from + len2 / 2;
            int l = this.from;
            int n = this.to - 1;
            int s2 = len2 / 8;
            l = FloatArrays.med3(x, l, l + s2, l + 2 * s2);
            m3 = FloatArrays.med3(x, m3 - s2, m3, m3 + s2);
            n = FloatArrays.med3(x, n - 2 * s2, n - s2, n);
            m3 = FloatArrays.med3(x, l, m3, n);
            float v = x[m3];
            int b = a = this.from;
            int d = c = this.to - 1;
            while (true) {
                int comparison;
                if (b <= c && (comparison = this.comp.compare(x[b], v)) <= 0) {
                    if (comparison == 0) {
                        FloatArrays.swap(x, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (comparison = this.comp.compare(x[c], v)) >= 0) {
                    if (comparison == 0) {
                        FloatArrays.swap(x, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                FloatArrays.swap(x, b++, c--);
            }
            s2 = Math.min(a - this.from, b - a);
            FloatArrays.swap(x, this.from, b - s2, s2);
            s2 = Math.min(d - c, this.to - d - 1);
            FloatArrays.swap(x, b, this.to - s2, s2);
            s2 = b - a;
            int t2 = d - c;
            if (s2 > 1 && t2 > 1) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s2, this.comp), new ForkJoinQuickSortComp(x, this.to - t2, this.to, this.comp));
            } else if (s2 > 1) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s2, this.comp));
            } else {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.to - t2, this.to, this.comp));
            }
        }
    }
}

