/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.Float2LongMap;
import it.unimi.dsi.fastutil.floats.Float2LongMaps;
import it.unimi.dsi.fastutil.floats.Float2LongSortedMap;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.floats.FloatSortedSet;
import it.unimi.dsi.fastutil.floats.FloatSortedSets;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Float2LongSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Float2LongSortedMaps() {
    }

    public static Comparator<? super Map.Entry<Float, ?>> entryComparator(final FloatComparator comparator) {
        return new Comparator<Map.Entry<Float, ?>>(){

            @Override
            public int compare(Map.Entry<Float, ?> x, Map.Entry<Float, ?> y) {
                return comparator.compare(x.getKey(), y.getKey());
            }
        };
    }

    public static Float2LongSortedMap singleton(Float key, Long value2) {
        return new Singleton(key.floatValue(), value2);
    }

    public static Float2LongSortedMap singleton(Float key, Long value2, FloatComparator comparator) {
        return new Singleton(key.floatValue(), value2, comparator);
    }

    public static Float2LongSortedMap singleton(float key, long value2) {
        return new Singleton(key, value2);
    }

    public static Float2LongSortedMap singleton(float key, long value2, FloatComparator comparator) {
        return new Singleton(key, value2, comparator);
    }

    public static Float2LongSortedMap synchronize(Float2LongSortedMap m3) {
        return new SynchronizedSortedMap(m3);
    }

    public static Float2LongSortedMap synchronize(Float2LongSortedMap m3, Object sync2) {
        return new SynchronizedSortedMap(m3, sync2);
    }

    public static Float2LongSortedMap unmodifiable(Float2LongSortedMap m3) {
        return new UnmodifiableSortedMap(m3);
    }

    public static class UnmodifiableSortedMap
    extends Float2LongMaps.UnmodifiableMap
    implements Float2LongSortedMap,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Float2LongSortedMap sortedMap;

        protected UnmodifiableSortedMap(Float2LongSortedMap m3) {
            super(m3);
            this.sortedMap = m3;
        }

        @Override
        public FloatComparator comparator() {
            return this.sortedMap.comparator();
        }

        @Override
        public ObjectSortedSet<Float2LongMap.Entry> float2LongEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.unmodifiable(this.sortedMap.float2LongEntrySet());
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        public ObjectSortedSet<Map.Entry<Float, Long>> entrySet() {
            return this.float2LongEntrySet();
        }

        @Override
        public FloatSortedSet keySet() {
            if (this.keys == null) {
                this.keys = FloatSortedSets.unmodifiable(this.sortedMap.keySet());
            }
            return (FloatSortedSet)this.keys;
        }

        @Override
        public Float2LongSortedMap subMap(float from2, float to) {
            return new UnmodifiableSortedMap(this.sortedMap.subMap(from2, to));
        }

        @Override
        public Float2LongSortedMap headMap(float to) {
            return new UnmodifiableSortedMap(this.sortedMap.headMap(to));
        }

        @Override
        public Float2LongSortedMap tailMap(float from2) {
            return new UnmodifiableSortedMap(this.sortedMap.tailMap(from2));
        }

        @Override
        public float firstFloatKey() {
            return this.sortedMap.firstFloatKey();
        }

        @Override
        public float lastFloatKey() {
            return this.sortedMap.lastFloatKey();
        }

        @Override
        public Float firstKey() {
            return (Float)this.sortedMap.firstKey();
        }

        @Override
        public Float lastKey() {
            return (Float)this.sortedMap.lastKey();
        }

        @Override
        public Float2LongSortedMap subMap(Float from2, Float to) {
            return new UnmodifiableSortedMap(this.sortedMap.subMap(from2, to));
        }

        @Override
        public Float2LongSortedMap headMap(Float to) {
            return new UnmodifiableSortedMap(this.sortedMap.headMap(to));
        }

        @Override
        public Float2LongSortedMap tailMap(Float from2) {
            return new UnmodifiableSortedMap(this.sortedMap.tailMap(from2));
        }
    }

    public static class SynchronizedSortedMap
    extends Float2LongMaps.SynchronizedMap
    implements Float2LongSortedMap,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Float2LongSortedMap sortedMap;

        protected SynchronizedSortedMap(Float2LongSortedMap m3, Object sync2) {
            super(m3, sync2);
            this.sortedMap = m3;
        }

        protected SynchronizedSortedMap(Float2LongSortedMap m3) {
            super(m3);
            this.sortedMap = m3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FloatComparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        @Override
        public ObjectSortedSet<Float2LongMap.Entry> float2LongEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.synchronize(this.sortedMap.float2LongEntrySet(), this.sync);
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        public ObjectSortedSet<Map.Entry<Float, Long>> entrySet() {
            return this.float2LongEntrySet();
        }

        @Override
        public FloatSortedSet keySet() {
            if (this.keys == null) {
                this.keys = FloatSortedSets.synchronize(this.sortedMap.keySet(), this.sync);
            }
            return (FloatSortedSet)this.keys;
        }

        @Override
        public Float2LongSortedMap subMap(float from2, float to) {
            return new SynchronizedSortedMap(this.sortedMap.subMap(from2, to), this.sync);
        }

        @Override
        public Float2LongSortedMap headMap(float to) {
            return new SynchronizedSortedMap(this.sortedMap.headMap(to), this.sync);
        }

        @Override
        public Float2LongSortedMap tailMap(float from2) {
            return new SynchronizedSortedMap(this.sortedMap.tailMap(from2), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public float firstFloatKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstFloatKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public float lastFloatKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastFloatKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Float firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return (Float)this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Float lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return (Float)this.sortedMap.lastKey();
            }
        }

        @Override
        public Float2LongSortedMap subMap(Float from2, Float to) {
            return new SynchronizedSortedMap(this.sortedMap.subMap(from2, to), this.sync);
        }

        @Override
        public Float2LongSortedMap headMap(Float to) {
            return new SynchronizedSortedMap(this.sortedMap.headMap(to), this.sync);
        }

        @Override
        public Float2LongSortedMap tailMap(Float from2) {
            return new SynchronizedSortedMap(this.sortedMap.tailMap(from2), this.sync);
        }
    }

    public static class Singleton
    extends Float2LongMaps.Singleton
    implements Float2LongSortedMap,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final FloatComparator comparator;

        protected Singleton(float key, long value2, FloatComparator comparator) {
            super(key, value2);
            this.comparator = comparator;
        }

        protected Singleton(float key, long value2) {
            this(key, value2, null);
        }

        final int compare(float k1, float k2) {
            return this.comparator == null ? Float.compare(k1, k2) : this.comparator.compare(k1, k2);
        }

        @Override
        public FloatComparator comparator() {
            return this.comparator;
        }

        @Override
        public ObjectSortedSet<Float2LongMap.Entry> float2LongEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.singleton(new Float2LongMaps.Singleton.SingletonEntry(), Float2LongSortedMaps.entryComparator(this.comparator));
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        public ObjectSortedSet<Map.Entry<Float, Long>> entrySet() {
            return this.float2LongEntrySet();
        }

        @Override
        public FloatSortedSet keySet() {
            if (this.keys == null) {
                this.keys = FloatSortedSets.singleton(this.key, this.comparator);
            }
            return (FloatSortedSet)this.keys;
        }

        @Override
        public Float2LongSortedMap subMap(float from2, float to) {
            if (this.compare(from2, this.key) <= 0 && this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Float2LongSortedMap headMap(float to) {
            if (this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Float2LongSortedMap tailMap(float from2) {
            if (this.compare(from2, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public float firstFloatKey() {
            return this.key;
        }

        @Override
        public float lastFloatKey() {
            return this.key;
        }

        @Override
        public Float2LongSortedMap headMap(Float oto) {
            return this.headMap(oto.floatValue());
        }

        @Override
        public Float2LongSortedMap tailMap(Float ofrom) {
            return this.tailMap(ofrom.floatValue());
        }

        @Override
        public Float2LongSortedMap subMap(Float ofrom, Float oto) {
            return this.subMap(ofrom.floatValue(), oto.floatValue());
        }

        @Override
        public Float firstKey() {
            return Float.valueOf(this.firstFloatKey());
        }

        @Override
        public Float lastKey() {
            return Float.valueOf(this.lastFloatKey());
        }
    }

    public static class EmptySortedMap
    extends Float2LongMaps.EmptyMap
    implements Float2LongSortedMap,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        @Override
        public FloatComparator comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Float2LongMap.Entry> float2LongEntrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        public ObjectSortedSet<Map.Entry<Float, Long>> entrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        public FloatSortedSet keySet() {
            return FloatSortedSets.EMPTY_SET;
        }

        @Override
        public Float2LongSortedMap subMap(float from2, float to) {
            return EMPTY_MAP;
        }

        @Override
        public Float2LongSortedMap headMap(float to) {
            return EMPTY_MAP;
        }

        @Override
        public Float2LongSortedMap tailMap(float from2) {
            return EMPTY_MAP;
        }

        @Override
        public float firstFloatKey() {
            throw new NoSuchElementException();
        }

        @Override
        public float lastFloatKey() {
            throw new NoSuchElementException();
        }

        @Override
        public Float2LongSortedMap headMap(Float oto) {
            return this.headMap(oto.floatValue());
        }

        @Override
        public Float2LongSortedMap tailMap(Float ofrom) {
            return this.tailMap(ofrom.floatValue());
        }

        @Override
        public Float2LongSortedMap subMap(Float ofrom, Float oto) {
            return this.subMap(ofrom.floatValue(), oto.floatValue());
        }

        @Override
        public Float firstKey() {
            return Float.valueOf(this.firstFloatKey());
        }

        @Override
        public Float lastKey() {
            return Float.valueOf(this.lastFloatKey());
        }
    }
}

