/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import java.util.Arrays;

public class DoubleIndirectHeaps {
    private DoubleIndirectHeaps() {
    }

    public static int downHeap(double[] refArray, int[] heap, int[] inv2, int size, int i, DoubleComparator c) {
        if (i >= size) {
            throw new IllegalArgumentException("Heap position (" + i + ") is larger than or equal to heap size (" + size + ")");
        }
        int e = heap[i];
        double E = refArray[e];
        if (c == null) {
            int child;
            while ((child = 2 * i + 1) < size) {
                if (child + 1 < size && Double.compare(refArray[heap[child + 1]], refArray[heap[child]]) < 0) {
                    ++child;
                }
                if (Double.compare(E, refArray[heap[child]]) > 0) {
                    heap[i] = heap[child];
                    inv2[heap[i]] = i;
                    i = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = 2 * i + 1) < size) {
                if (child + 1 < size && c.compare(refArray[heap[child + 1]], refArray[heap[child]]) < 0) {
                    ++child;
                }
                if (c.compare(E, refArray[heap[child]]) > 0) {
                    heap[i] = heap[child];
                    inv2[heap[i]] = i;
                    i = child;
                    continue;
                }
                break;
            }
        }
        heap[i] = e;
        inv2[e] = i;
        return i;
    }

    public static int upHeap(double[] refArray, int[] heap, int[] inv2, int size, int i, DoubleComparator c) {
        if (i >= size) {
            throw new IllegalArgumentException("Heap position (" + i + ") is larger than or equal to heap size (" + size + ")");
        }
        int e = heap[i];
        double E = refArray[e];
        if (c == null) {
            int parent;
            while (i != 0 && (parent = (i - 1) / 2) >= 0 && Double.compare(refArray[heap[parent]], E) > 0) {
                heap[i] = heap[parent];
                inv2[heap[i]] = i;
                i = parent;
            }
        } else {
            int parent;
            while (i != 0 && (parent = (i - 1) / 2) >= 0 && c.compare(refArray[heap[parent]], E) > 0) {
                heap[i] = heap[parent];
                inv2[heap[i]] = i;
                i = parent;
            }
        }
        heap[i] = e;
        inv2[e] = i;
        return i;
    }

    public static void makeHeap(double[] refArray, int offset, int length, int[] heap, int[] inv2, DoubleComparator c) {
        DoubleArrays.ensureOffsetLength(refArray, offset, length);
        if (heap.length < length) {
            throw new IllegalArgumentException("The heap length (" + heap.length + ") is smaller than the number of elements (" + length + ")");
        }
        if (inv2.length < refArray.length) {
            throw new IllegalArgumentException("The inversion array length (" + heap.length + ") is smaller than the length of the reference array (" + refArray.length + ")");
        }
        Arrays.fill(inv2, 0, refArray.length, -1);
        int i = length;
        while (i-- != 0) {
            heap[i] = offset + i;
            inv2[heap[i]] = i;
        }
        i = length / 2;
        while (i-- != 0) {
            DoubleIndirectHeaps.downHeap(refArray, heap, inv2, length, i, c);
        }
    }

    public static void makeHeap(double[] refArray, int[] heap, int[] inv2, int size, DoubleComparator c) {
        int i = size / 2;
        while (i-- != 0) {
            DoubleIndirectHeaps.downHeap(refArray, heap, inv2, size, i, c);
        }
    }
}

