/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.BigList;
import it.unimi.dsi.fastutil.BigListIterator;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleBigListIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleBigArrays;
import it.unimi.dsi.fastutil.doubles.DoubleBigList;
import it.unimi.dsi.fastutil.doubles.DoubleBigListIterator;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleStack;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractDoubleBigList
extends AbstractDoubleCollection
implements DoubleBigList,
DoubleStack {
    protected AbstractDoubleBigList() {
    }

    protected void ensureIndex(long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size64()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size64() + ")");
        }
    }

    protected void ensureRestrictedIndex(long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index >= this.size64()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size64() + ")");
        }
    }

    @Override
    public void add(long index, double k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(double k) {
        this.add(this.size64(), k);
        return true;
    }

    @Override
    public double removeDouble(long i) {
        throw new UnsupportedOperationException();
    }

    public double removeDouble(int i) {
        return this.removeDouble((long)i);
    }

    @Override
    public double set(long index, double k) {
        throw new UnsupportedOperationException();
    }

    public double set(int index, double k) {
        return this.set((long)index, k);
    }

    @Override
    public boolean addAll(long index, Collection<? extends Double> c) {
        this.ensureIndex(index);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        Iterator<? extends Double> i = c.iterator();
        while (n-- != 0) {
            this.add(index++, i.next());
        }
        return true;
    }

    public boolean addAll(int index, Collection<? extends Double> c) {
        return this.addAll((long)index, c);
    }

    @Override
    public boolean addAll(Collection<? extends Double> c) {
        return this.addAll(this.size64(), c);
    }

    @Override
    public DoubleBigListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public DoubleBigListIterator listIterator() {
        return this.listIterator(0L);
    }

    @Override
    public DoubleBigListIterator listIterator(final long index) {
        return new AbstractDoubleBigListIterator(){
            long pos;
            long last;
            {
                this.pos = index;
                this.last = -1L;
            }

            @Override
            public boolean hasNext() {
                return this.pos < AbstractDoubleBigList.this.size64();
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0L;
            }

            @Override
            public double nextDouble() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractDoubleBigList.this.getDouble(this.last);
            }

            @Override
            public double previousDouble() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractDoubleBigList.this.getDouble(this.pos);
            }

            @Override
            public long nextIndex() {
                return this.pos;
            }

            @Override
            public long previousIndex() {
                return this.pos - 1L;
            }

            @Override
            public void add(double k) {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                AbstractDoubleBigList.this.add(this.pos++, k);
                this.last = -1L;
            }

            @Override
            public void set(double k) {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                AbstractDoubleBigList.this.set(this.last, k);
            }

            @Override
            public void remove() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                AbstractDoubleBigList.this.removeDouble(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1L;
            }
        };
    }

    public DoubleBigListIterator listIterator(int index) {
        return this.listIterator((long)index);
    }

    @Override
    public boolean contains(double k) {
        return this.indexOf(k) >= 0L;
    }

    @Override
    public long indexOf(double k) {
        DoubleBigListIterator i = this.listIterator();
        while (i.hasNext()) {
            double e = i.nextDouble();
            if (Double.doubleToLongBits(k) != Double.doubleToLongBits(e)) continue;
            return i.previousIndex();
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(double k) {
        DoubleBigListIterator i = this.listIterator(this.size64());
        while (i.hasPrevious()) {
            double e = i.previousDouble();
            if (Double.doubleToLongBits(k) != Double.doubleToLongBits(e)) continue;
            return i.nextIndex();
        }
        return -1L;
    }

    @Override
    public void size(long size) {
        long i = this.size64();
        if (size > i) {
            while (i++ < size) {
                this.add(0.0);
            }
        } else {
            while (i-- != size) {
                this.remove(i);
            }
        }
    }

    public void size(int size) {
        this.size((long)size);
    }

    @Override
    public DoubleBigList subList(long from2, long to) {
        this.ensureIndex(from2);
        this.ensureIndex(to);
        if (from2 > to) {
            throw new IndexOutOfBoundsException("Start index (" + from2 + ") is greater than end index (" + to + ")");
        }
        return new DoubleSubList(this, from2, to);
    }

    @Override
    public void removeElements(long from2, long to) {
        this.ensureIndex(to);
        DoubleBigListIterator i = this.listIterator(from2);
        long n = to - from2;
        if (n < 0L) {
            throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to + ")");
        }
        while (n-- != 0L) {
            i.nextDouble();
            i.remove();
        }
    }

    @Override
    public void addElements(long index, double[][] a, long offset, long length) {
        this.ensureIndex(index);
        DoubleBigArrays.ensureOffsetLength(a, offset, length);
        while (length-- != 0L) {
            this.add(index++, DoubleBigArrays.get(a, offset++));
        }
    }

    @Override
    public void addElements(long index, double[][] a) {
        this.addElements(index, a, 0L, DoubleBigArrays.length(a));
    }

    @Override
    public void getElements(long from2, double[][] a, long offset, long length) {
        DoubleBigListIterator i = this.listIterator(from2);
        DoubleBigArrays.ensureOffsetLength(a, offset, length);
        if (from2 + length > this.size64()) {
            throw new IndexOutOfBoundsException("End index (" + (from2 + length) + ") is greater than list size (" + this.size64() + ")");
        }
        while (length-- != 0L) {
            DoubleBigArrays.set(a, offset++, i.nextDouble());
        }
    }

    @Override
    @Deprecated
    public int size() {
        return (int)Math.min(Integer.MAX_VALUE, this.size64());
    }

    private boolean valEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BigList)) {
            return false;
        }
        BigList l = (BigList)o;
        long s2 = this.size64();
        if (s2 != l.size64()) {
            return false;
        }
        if (l instanceof DoubleBigList) {
            DoubleBigListIterator i1 = this.listIterator();
            DoubleBigListIterator i2 = ((DoubleBigList)l).listIterator();
            while (s2-- != 0L) {
                if (i1.nextDouble() == i2.nextDouble()) continue;
                return false;
            }
            return true;
        }
        DoubleBigListIterator i1 = this.listIterator();
        BigListIterator i2 = l.listIterator();
        while (s2-- != 0L) {
            if (this.valEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(BigList<? extends Double> l) {
        if (l == this) {
            return 0;
        }
        if (l instanceof DoubleBigList) {
            DoubleBigListIterator i1 = this.listIterator();
            DoubleBigListIterator i2 = ((DoubleBigList)l).listIterator();
            while (i1.hasNext() && i2.hasNext()) {
                double e2;
                double e1 = i1.nextDouble();
                int r = Double.compare(e1, e2 = i2.nextDouble());
                if (r == 0) continue;
                return r;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        DoubleBigListIterator i1 = this.listIterator();
        BigListIterator<? extends Double> i2 = l.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r = ((Comparable)i1.next()).compareTo(i2.next());
            if (r == 0) continue;
            return r;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    @Override
    public int hashCode() {
        DoubleBigListIterator i = this.iterator();
        int h2 = 1;
        long s2 = this.size64();
        while (s2-- != 0L) {
            double k = i.nextDouble();
            h2 = 31 * h2 + HashCommon.double2int(k);
        }
        return h2;
    }

    @Override
    public void push(double o) {
        this.add(o);
    }

    @Override
    public double popDouble() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeDouble(this.size64() - 1L);
    }

    @Override
    public double topDouble() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getDouble(this.size64() - 1L);
    }

    @Override
    public double peekDouble(int i) {
        return this.getDouble(this.size64() - 1L - (long)i);
    }

    public double getDouble(int index) {
        return this.getDouble((long)index);
    }

    @Override
    public boolean rem(double k) {
        long index = this.indexOf(k);
        if (index == -1L) {
            return false;
        }
        this.removeDouble(index);
        return true;
    }

    @Override
    public boolean addAll(long index, DoubleCollection c) {
        return this.addAll(index, (Collection<? extends Double>)c);
    }

    @Override
    public boolean addAll(long index, DoubleBigList l) {
        return this.addAll(index, (DoubleCollection)l);
    }

    @Override
    public boolean addAll(DoubleCollection c) {
        return this.addAll(this.size64(), c);
    }

    @Override
    public boolean addAll(DoubleBigList l) {
        return this.addAll(this.size64(), l);
    }

    @Override
    public void add(long index, Double ok) {
        this.add(index, (double)ok);
    }

    @Override
    public Double set(long index, Double ok) {
        return this.set(index, (double)ok);
    }

    @Override
    public Double get(long index) {
        return this.getDouble(index);
    }

    @Override
    public long indexOf(Object ok) {
        return this.indexOf((Double)ok);
    }

    @Override
    public long lastIndexOf(Object ok) {
        return this.lastIndexOf((Double)ok);
    }

    public Double remove(int index) {
        return this.removeDouble(index);
    }

    @Override
    public Double remove(long index) {
        return this.removeDouble(index);
    }

    @Override
    public void push(Double o) {
        this.push((double)o);
    }

    @Override
    public Double pop() {
        return this.popDouble();
    }

    @Override
    public Double top() {
        return this.topDouble();
    }

    @Override
    public Double peek(int i) {
        return this.peekDouble(i);
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        DoubleBigListIterator i = this.iterator();
        long n = this.size64();
        boolean first = true;
        s2.append("[");
        while (n-- != 0L) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            double k = i.nextDouble();
            s2.append(String.valueOf(k));
        }
        s2.append("]");
        return s2.toString();
    }

    public static class DoubleSubList
    extends AbstractDoubleBigList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final DoubleBigList l;
        protected final long from;
        protected long to;
        private static final boolean ASSERTS = false;

        public DoubleSubList(DoubleBigList l, long from2, long to) {
            this.l = l;
            this.from = from2;
            this.to = to;
        }

        private void assertRange() {
        }

        @Override
        public boolean add(double k) {
            this.l.add(this.to, k);
            ++this.to;
            return true;
        }

        @Override
        public void add(long index, double k) {
            this.ensureIndex(index);
            this.l.add(this.from + index, k);
            ++this.to;
        }

        @Override
        public boolean addAll(long index, Collection<? extends Double> c) {
            this.ensureIndex(index);
            this.to += (long)c.size();
            return this.l.addAll(this.from + index, c);
        }

        @Override
        public double getDouble(long index) {
            this.ensureRestrictedIndex(index);
            return this.l.getDouble(this.from + index);
        }

        @Override
        public double removeDouble(long index) {
            this.ensureRestrictedIndex(index);
            --this.to;
            return this.l.removeDouble(this.from + index);
        }

        @Override
        public double set(long index, double k) {
            this.ensureRestrictedIndex(index);
            return this.l.set(this.from + index, k);
        }

        @Override
        public void clear() {
            this.removeElements(0L, this.size64());
        }

        @Override
        public long size64() {
            return this.to - this.from;
        }

        @Override
        public void getElements(long from2, double[][] a, long offset, long length) {
            this.ensureIndex(from2);
            if (from2 + length > this.size64()) {
                throw new IndexOutOfBoundsException("End index (" + from2 + length + ") is greater than list size (" + this.size64() + ")");
            }
            this.l.getElements(this.from + from2, a, offset, length);
        }

        @Override
        public void removeElements(long from2, long to) {
            this.ensureIndex(from2);
            this.ensureIndex(to);
            this.l.removeElements(this.from + from2, this.from + to);
            this.to -= to - from2;
        }

        @Override
        public void addElements(long index, double[][] a, long offset, long length) {
            this.ensureIndex(index);
            this.l.addElements(this.from + index, a, offset, length);
            this.to += length;
        }

        @Override
        public DoubleBigListIterator listIterator(final long index) {
            this.ensureIndex(index);
            return new AbstractDoubleBigListIterator(){
                long pos;
                long last;
                {
                    this.pos = index;
                    this.last = -1L;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < DoubleSubList.this.size64();
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos > 0L;
                }

                @Override
                public double nextDouble() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return DoubleSubList.this.l.getDouble(DoubleSubList.this.from + this.last);
                }

                @Override
                public double previousDouble() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return DoubleSubList.this.l.getDouble(DoubleSubList.this.from + this.pos);
                }

                @Override
                public long nextIndex() {
                    return this.pos;
                }

                @Override
                public long previousIndex() {
                    return this.pos - 1L;
                }

                @Override
                public void add(double k) {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    DoubleSubList.this.add(this.pos++, k);
                    this.last = -1L;
                }

                @Override
                public void set(double k) {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    DoubleSubList.this.set(this.last, k);
                }

                @Override
                public void remove() {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    DoubleSubList.this.removeDouble(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1L;
                }
            };
        }

        @Override
        public DoubleBigList subList(long from2, long to) {
            this.ensureIndex(from2);
            this.ensureIndex(to);
            if (from2 > to) {
                throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to + ")");
            }
            return new DoubleSubList(this, from2, to);
        }

        @Override
        public boolean rem(double k) {
            long index = this.indexOf(k);
            if (index == -1L) {
                return false;
            }
            --this.to;
            this.l.removeDouble(this.from + index);
            return true;
        }

        @Override
        public boolean remove(Object o) {
            return this.rem((Double)o);
        }

        @Override
        public boolean addAll(long index, DoubleCollection c) {
            this.ensureIndex(index);
            this.to += (long)c.size();
            return this.l.addAll(this.from + index, c);
        }

        public boolean addAll(long index, DoubleList l) {
            this.ensureIndex(index);
            this.to += (long)l.size();
            return this.l.addAll(this.from + index, l);
        }
    }
}

