/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.AbstractCharPriorityQueue;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharComparator;
import java.util.NoSuchElementException;

public class CharArrayPriorityQueue
extends AbstractCharPriorityQueue {
    protected char[] array = CharArrays.EMPTY_ARRAY;
    protected int size;
    protected CharComparator c;
    protected int firstIndex;
    protected boolean firstIndexValid;

    public CharArrayPriorityQueue(int capacity, CharComparator c) {
        if (capacity > 0) {
            this.array = new char[capacity];
        }
        this.c = c;
    }

    public CharArrayPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public CharArrayPriorityQueue(CharComparator c) {
        this(0, c);
    }

    public CharArrayPriorityQueue() {
        this(0, null);
    }

    public CharArrayPriorityQueue(char[] a, int size, CharComparator c) {
        this(c);
        this.array = a;
        this.size = size;
    }

    public CharArrayPriorityQueue(char[] a, CharComparator c) {
        this(a, a.length, c);
    }

    public CharArrayPriorityQueue(char[] a, int size) {
        this(a, size, null);
    }

    public CharArrayPriorityQueue(char[] a) {
        this(a, a.length);
    }

    private int findFirst() {
        if (this.firstIndexValid) {
            return this.firstIndex;
        }
        this.firstIndexValid = true;
        int i = this.size;
        int firstIndex = --i;
        char first = this.array[firstIndex];
        if (this.c == null) {
            while (i-- != 0) {
                if (this.array[i] >= first) continue;
                firstIndex = i;
                first = this.array[firstIndex];
            }
        } else {
            while (i-- != 0) {
                if (this.c.compare(this.array[i], first) >= 0) continue;
                firstIndex = i;
                first = this.array[firstIndex];
            }
        }
        this.firstIndex = firstIndex;
        return this.firstIndex;
    }

    private void ensureNonEmpty() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void enqueue(char x) {
        if (this.size == this.array.length) {
            this.array = CharArrays.grow(this.array, this.size + 1);
        }
        if (this.firstIndexValid) {
            if (this.c == null) {
                if (x < this.array[this.firstIndex]) {
                    this.firstIndex = this.size;
                }
            } else if (this.c.compare(x, this.array[this.firstIndex]) < 0) {
                this.firstIndex = this.size;
            }
        } else {
            this.firstIndexValid = false;
        }
        this.array[this.size++] = x;
    }

    @Override
    public char dequeueChar() {
        this.ensureNonEmpty();
        int first = this.findFirst();
        char result2 = this.array[first];
        System.arraycopy(this.array, first + 1, this.array, first, --this.size - first);
        this.firstIndexValid = false;
        return result2;
    }

    @Override
    public char firstChar() {
        this.ensureNonEmpty();
        return this.array[this.findFirst()];
    }

    @Override
    public void changed() {
        this.ensureNonEmpty();
        this.firstIndexValid = false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.firstIndexValid = false;
    }

    public void trim() {
        this.array = CharArrays.trim(this.array, this.size);
    }

    @Override
    public CharComparator comparator() {
        return this.c;
    }
}

