/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.Char2ReferenceMap;
import it.unimi.dsi.fastutil.chars.Char2ReferenceMaps;
import it.unimi.dsi.fastutil.chars.Char2ReferenceSortedMap;
import it.unimi.dsi.fastutil.chars.CharComparator;
import it.unimi.dsi.fastutil.chars.CharSortedSet;
import it.unimi.dsi.fastutil.chars.CharSortedSets;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Char2ReferenceSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Char2ReferenceSortedMaps() {
    }

    public static Comparator<? super Map.Entry<Character, ?>> entryComparator(final CharComparator comparator) {
        return new Comparator<Map.Entry<Character, ?>>(){

            @Override
            public int compare(Map.Entry<Character, ?> x, Map.Entry<Character, ?> y) {
                return comparator.compare(x.getKey(), y.getKey());
            }
        };
    }

    public static <V> Char2ReferenceSortedMap<V> singleton(Character key, V value2) {
        return new Singleton<V>(key.charValue(), value2);
    }

    public static <V> Char2ReferenceSortedMap<V> singleton(Character key, V value2, CharComparator comparator) {
        return new Singleton<V>(key.charValue(), value2, comparator);
    }

    public static <V> Char2ReferenceSortedMap<V> singleton(char key, V value2) {
        return new Singleton<V>(key, value2);
    }

    public static <V> Char2ReferenceSortedMap<V> singleton(char key, V value2, CharComparator comparator) {
        return new Singleton<V>(key, value2, comparator);
    }

    public static <V> Char2ReferenceSortedMap<V> synchronize(Char2ReferenceSortedMap<V> m3) {
        return new SynchronizedSortedMap<V>(m3);
    }

    public static <V> Char2ReferenceSortedMap<V> synchronize(Char2ReferenceSortedMap<V> m3, Object sync2) {
        return new SynchronizedSortedMap<V>(m3, sync2);
    }

    public static <V> Char2ReferenceSortedMap<V> unmodifiable(Char2ReferenceSortedMap<V> m3) {
        return new UnmodifiableSortedMap<V>(m3);
    }

    public static class UnmodifiableSortedMap<V>
    extends Char2ReferenceMaps.UnmodifiableMap<V>
    implements Char2ReferenceSortedMap<V>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Char2ReferenceSortedMap<V> sortedMap;

        protected UnmodifiableSortedMap(Char2ReferenceSortedMap<V> m3) {
            super(m3);
            this.sortedMap = m3;
        }

        @Override
        public CharComparator comparator() {
            return this.sortedMap.comparator();
        }

        @Override
        public ObjectSortedSet<Char2ReferenceMap.Entry<V>> char2ReferenceEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.unmodifiable(this.sortedMap.char2ReferenceEntrySet());
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        public ObjectSortedSet<Map.Entry<Character, V>> entrySet() {
            return this.char2ReferenceEntrySet();
        }

        @Override
        public CharSortedSet keySet() {
            if (this.keys == null) {
                this.keys = CharSortedSets.unmodifiable(this.sortedMap.keySet());
            }
            return (CharSortedSet)this.keys;
        }

        @Override
        public Char2ReferenceSortedMap<V> subMap(char from2, char to) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.subMap(from2, to));
        }

        @Override
        public Char2ReferenceSortedMap<V> headMap(char to) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.headMap(to));
        }

        @Override
        public Char2ReferenceSortedMap<V> tailMap(char from2) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.tailMap(from2));
        }

        @Override
        public char firstCharKey() {
            return this.sortedMap.firstCharKey();
        }

        @Override
        public char lastCharKey() {
            return this.sortedMap.lastCharKey();
        }

        @Override
        public Character firstKey() {
            return (Character)this.sortedMap.firstKey();
        }

        @Override
        public Character lastKey() {
            return (Character)this.sortedMap.lastKey();
        }

        @Override
        public Char2ReferenceSortedMap<V> subMap(Character from2, Character to) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.subMap(from2, to));
        }

        @Override
        public Char2ReferenceSortedMap<V> headMap(Character to) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.headMap(to));
        }

        @Override
        public Char2ReferenceSortedMap<V> tailMap(Character from2) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.tailMap(from2));
        }
    }

    public static class SynchronizedSortedMap<V>
    extends Char2ReferenceMaps.SynchronizedMap<V>
    implements Char2ReferenceSortedMap<V>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Char2ReferenceSortedMap<V> sortedMap;

        protected SynchronizedSortedMap(Char2ReferenceSortedMap<V> m3, Object sync2) {
            super(m3, sync2);
            this.sortedMap = m3;
        }

        protected SynchronizedSortedMap(Char2ReferenceSortedMap<V> m3) {
            super(m3);
            this.sortedMap = m3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharComparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        @Override
        public ObjectSortedSet<Char2ReferenceMap.Entry<V>> char2ReferenceEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.synchronize(this.sortedMap.char2ReferenceEntrySet(), this.sync);
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        public ObjectSortedSet<Map.Entry<Character, V>> entrySet() {
            return this.char2ReferenceEntrySet();
        }

        @Override
        public CharSortedSet keySet() {
            if (this.keys == null) {
                this.keys = CharSortedSets.synchronize(this.sortedMap.keySet(), this.sync);
            }
            return (CharSortedSet)this.keys;
        }

        @Override
        public Char2ReferenceSortedMap<V> subMap(char from2, char to) {
            return new SynchronizedSortedMap<V>(this.sortedMap.subMap(from2, to), this.sync);
        }

        @Override
        public Char2ReferenceSortedMap<V> headMap(char to) {
            return new SynchronizedSortedMap<V>(this.sortedMap.headMap(to), this.sync);
        }

        @Override
        public Char2ReferenceSortedMap<V> tailMap(char from2) {
            return new SynchronizedSortedMap<V>(this.sortedMap.tailMap(from2), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public char firstCharKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstCharKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public char lastCharKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastCharKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Character firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return (Character)this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Character lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return (Character)this.sortedMap.lastKey();
            }
        }

        @Override
        public Char2ReferenceSortedMap<V> subMap(Character from2, Character to) {
            return new SynchronizedSortedMap<V>(this.sortedMap.subMap(from2, to), this.sync);
        }

        @Override
        public Char2ReferenceSortedMap<V> headMap(Character to) {
            return new SynchronizedSortedMap<V>(this.sortedMap.headMap(to), this.sync);
        }

        @Override
        public Char2ReferenceSortedMap<V> tailMap(Character from2) {
            return new SynchronizedSortedMap<V>(this.sortedMap.tailMap(from2), this.sync);
        }
    }

    public static class Singleton<V>
    extends Char2ReferenceMaps.Singleton<V>
    implements Char2ReferenceSortedMap<V>,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final CharComparator comparator;

        protected Singleton(char key, V value2, CharComparator comparator) {
            super(key, value2);
            this.comparator = comparator;
        }

        protected Singleton(char key, V value2) {
            this(key, value2, null);
        }

        final int compare(char k1, char k2) {
            return this.comparator == null ? Character.compare(k1, k2) : this.comparator.compare(k1, k2);
        }

        @Override
        public CharComparator comparator() {
            return this.comparator;
        }

        @Override
        public ObjectSortedSet<Char2ReferenceMap.Entry<V>> char2ReferenceEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.singleton(new Char2ReferenceMaps.Singleton.SingletonEntry(), Char2ReferenceSortedMaps.entryComparator(this.comparator));
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        public ObjectSortedSet<Map.Entry<Character, V>> entrySet() {
            return this.char2ReferenceEntrySet();
        }

        @Override
        public CharSortedSet keySet() {
            if (this.keys == null) {
                this.keys = CharSortedSets.singleton(this.key, this.comparator);
            }
            return (CharSortedSet)this.keys;
        }

        @Override
        public Char2ReferenceSortedMap<V> subMap(char from2, char to) {
            if (this.compare(from2, this.key) <= 0 && this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Char2ReferenceSortedMap<V> headMap(char to) {
            if (this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Char2ReferenceSortedMap<V> tailMap(char from2) {
            if (this.compare(from2, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public char firstCharKey() {
            return this.key;
        }

        @Override
        public char lastCharKey() {
            return this.key;
        }

        @Override
        public Char2ReferenceSortedMap<V> headMap(Character oto) {
            return this.headMap(oto.charValue());
        }

        @Override
        public Char2ReferenceSortedMap<V> tailMap(Character ofrom) {
            return this.tailMap(ofrom.charValue());
        }

        @Override
        public Char2ReferenceSortedMap<V> subMap(Character ofrom, Character oto) {
            return this.subMap(ofrom.charValue(), oto.charValue());
        }

        @Override
        public Character firstKey() {
            return Character.valueOf(this.firstCharKey());
        }

        @Override
        public Character lastKey() {
            return Character.valueOf(this.lastCharKey());
        }
    }

    public static class EmptySortedMap<V>
    extends Char2ReferenceMaps.EmptyMap<V>
    implements Char2ReferenceSortedMap<V>,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        @Override
        public CharComparator comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Char2ReferenceMap.Entry<V>> char2ReferenceEntrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        public ObjectSortedSet<Map.Entry<Character, V>> entrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        public CharSortedSet keySet() {
            return CharSortedSets.EMPTY_SET;
        }

        @Override
        public Char2ReferenceSortedMap<V> subMap(char from2, char to) {
            return EMPTY_MAP;
        }

        @Override
        public Char2ReferenceSortedMap<V> headMap(char to) {
            return EMPTY_MAP;
        }

        @Override
        public Char2ReferenceSortedMap<V> tailMap(char from2) {
            return EMPTY_MAP;
        }

        @Override
        public char firstCharKey() {
            throw new NoSuchElementException();
        }

        @Override
        public char lastCharKey() {
            throw new NoSuchElementException();
        }

        @Override
        public Char2ReferenceSortedMap<V> headMap(Character oto) {
            return this.headMap(oto.charValue());
        }

        @Override
        public Char2ReferenceSortedMap<V> tailMap(Character ofrom) {
            return this.tailMap(ofrom.charValue());
        }

        @Override
        public Char2ReferenceSortedMap<V> subMap(Character ofrom, Character oto) {
            return this.subMap(ofrom.charValue(), oto.charValue());
        }

        @Override
        public Character firstKey() {
            return Character.valueOf(this.firstCharKey());
        }

        @Override
        public Character lastKey() {
            return Character.valueOf(this.lastCharKey());
        }
    }
}

