/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.AbstractChar2IntFunction;
import it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import it.unimi.dsi.fastutil.chars.AbstractCharSet;
import it.unimi.dsi.fastutil.chars.Char2IntMap;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractChar2IntMap
extends AbstractChar2IntFunction
implements Char2IntMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractChar2IntMap() {
    }

    @Override
    public boolean containsValue(Object ov) {
        return this.containsValue((Integer)ov);
    }

    @Override
    public boolean containsValue(int v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(char k) {
        return this.keySet().contains(k);
    }

    @Override
    public void putAll(Map<? extends Character, ? extends Integer> m3) {
        int n = m3.size();
        Iterator<Map.Entry<? extends Character, ? extends Integer>> i = m3.entrySet().iterator();
        if (m3 instanceof Char2IntMap) {
            while (n-- != 0) {
                Char2IntMap.Entry e = (Char2IntMap.Entry)i.next();
                this.put(e.getCharKey(), e.getIntValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<? extends Character, ? extends Integer> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public CharSet keySet() {
        return new AbstractCharSet(){

            @Override
            public boolean contains(char k) {
                return AbstractChar2IntMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractChar2IntMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2IntMap.this.clear();
            }

            @Override
            public CharIterator iterator() {
                return new AbstractCharIterator(){
                    final ObjectIterator<Map.Entry<Character, Integer>> i;
                    {
                        this.i = AbstractChar2IntMap.this.entrySet().iterator();
                    }

                    @Override
                    public char nextChar() {
                        return ((Char2IntMap.Entry)this.i.next()).getCharKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public IntCollection values() {
        return new AbstractIntCollection(){

            @Override
            public boolean contains(int k) {
                return AbstractChar2IntMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractChar2IntMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2IntMap.this.clear();
            }

            @Override
            public IntIterator iterator() {
                return new AbstractIntIterator(){
                    final ObjectIterator<Map.Entry<Character, Integer>> i;
                    {
                        this.i = AbstractChar2IntMap.this.entrySet().iterator();
                    }

                    @Override
                    public int nextInt() {
                        return ((Char2IntMap.Entry)this.i.next()).getIntValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public ObjectSet<Map.Entry<Character, Integer>> entrySet() {
        return this.char2IntEntrySet();
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n = this.size();
        ObjectIterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h2 += ((Map.Entry)i.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m3 = (Map)o;
        if (m3.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m3.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s2.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Char2IntMap.Entry e = (Char2IntMap.Entry)i.next();
            s2.append(String.valueOf(e.getCharKey()));
            s2.append("=>");
            s2.append(String.valueOf(e.getIntValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static class BasicEntry
    implements Char2IntMap.Entry {
        protected char key;
        protected int value;

        public BasicEntry(Character key, Integer value2) {
            this.key = key.charValue();
            this.value = value2;
        }

        public BasicEntry(char key, int value2) {
            this.key = key;
            this.value = value2;
        }

        @Override
        public Character getKey() {
            return Character.valueOf(this.key);
        }

        @Override
        public char getCharKey() {
            return this.key;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public int getIntValue() {
            return this.value;
        }

        @Override
        public int setValue(int value2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer setValue(Integer value2) {
            return this.setValue((int)value2);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == ((Character)e.getKey()).charValue() && this.value == (Integer)e.getValue();
        }

        @Override
        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

