/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.bytes.Byte2ReferenceMap;
import it.unimi.dsi.fastutil.bytes.Byte2ReferenceMaps;
import it.unimi.dsi.fastutil.bytes.Byte2ReferenceSortedMap;
import it.unimi.dsi.fastutil.bytes.ByteComparator;
import it.unimi.dsi.fastutil.bytes.ByteSortedSet;
import it.unimi.dsi.fastutil.bytes.ByteSortedSets;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Byte2ReferenceSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Byte2ReferenceSortedMaps() {
    }

    public static Comparator<? super Map.Entry<Byte, ?>> entryComparator(final ByteComparator comparator) {
        return new Comparator<Map.Entry<Byte, ?>>(){

            @Override
            public int compare(Map.Entry<Byte, ?> x, Map.Entry<Byte, ?> y) {
                return comparator.compare(x.getKey(), y.getKey());
            }
        };
    }

    public static <V> Byte2ReferenceSortedMap<V> singleton(Byte key, V value2) {
        return new Singleton<V>(key, value2);
    }

    public static <V> Byte2ReferenceSortedMap<V> singleton(Byte key, V value2, ByteComparator comparator) {
        return new Singleton<V>(key, value2, comparator);
    }

    public static <V> Byte2ReferenceSortedMap<V> singleton(byte key, V value2) {
        return new Singleton<V>(key, value2);
    }

    public static <V> Byte2ReferenceSortedMap<V> singleton(byte key, V value2, ByteComparator comparator) {
        return new Singleton<V>(key, value2, comparator);
    }

    public static <V> Byte2ReferenceSortedMap<V> synchronize(Byte2ReferenceSortedMap<V> m3) {
        return new SynchronizedSortedMap<V>(m3);
    }

    public static <V> Byte2ReferenceSortedMap<V> synchronize(Byte2ReferenceSortedMap<V> m3, Object sync2) {
        return new SynchronizedSortedMap<V>(m3, sync2);
    }

    public static <V> Byte2ReferenceSortedMap<V> unmodifiable(Byte2ReferenceSortedMap<V> m3) {
        return new UnmodifiableSortedMap<V>(m3);
    }

    public static class UnmodifiableSortedMap<V>
    extends Byte2ReferenceMaps.UnmodifiableMap<V>
    implements Byte2ReferenceSortedMap<V>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Byte2ReferenceSortedMap<V> sortedMap;

        protected UnmodifiableSortedMap(Byte2ReferenceSortedMap<V> m3) {
            super(m3);
            this.sortedMap = m3;
        }

        @Override
        public ByteComparator comparator() {
            return this.sortedMap.comparator();
        }

        @Override
        public ObjectSortedSet<Byte2ReferenceMap.Entry<V>> byte2ReferenceEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.unmodifiable(this.sortedMap.byte2ReferenceEntrySet());
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        public ObjectSortedSet<Map.Entry<Byte, V>> entrySet() {
            return this.byte2ReferenceEntrySet();
        }

        @Override
        public ByteSortedSet keySet() {
            if (this.keys == null) {
                this.keys = ByteSortedSets.unmodifiable(this.sortedMap.keySet());
            }
            return (ByteSortedSet)this.keys;
        }

        @Override
        public Byte2ReferenceSortedMap<V> subMap(byte from2, byte to) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.subMap(from2, to));
        }

        @Override
        public Byte2ReferenceSortedMap<V> headMap(byte to) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.headMap(to));
        }

        @Override
        public Byte2ReferenceSortedMap<V> tailMap(byte from2) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.tailMap(from2));
        }

        @Override
        public byte firstByteKey() {
            return this.sortedMap.firstByteKey();
        }

        @Override
        public byte lastByteKey() {
            return this.sortedMap.lastByteKey();
        }

        @Override
        public Byte firstKey() {
            return (Byte)this.sortedMap.firstKey();
        }

        @Override
        public Byte lastKey() {
            return (Byte)this.sortedMap.lastKey();
        }

        @Override
        public Byte2ReferenceSortedMap<V> subMap(Byte from2, Byte to) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.subMap(from2, to));
        }

        @Override
        public Byte2ReferenceSortedMap<V> headMap(Byte to) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.headMap(to));
        }

        @Override
        public Byte2ReferenceSortedMap<V> tailMap(Byte from2) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.tailMap(from2));
        }
    }

    public static class SynchronizedSortedMap<V>
    extends Byte2ReferenceMaps.SynchronizedMap<V>
    implements Byte2ReferenceSortedMap<V>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Byte2ReferenceSortedMap<V> sortedMap;

        protected SynchronizedSortedMap(Byte2ReferenceSortedMap<V> m3, Object sync2) {
            super(m3, sync2);
            this.sortedMap = m3;
        }

        protected SynchronizedSortedMap(Byte2ReferenceSortedMap<V> m3) {
            super(m3);
            this.sortedMap = m3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteComparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        @Override
        public ObjectSortedSet<Byte2ReferenceMap.Entry<V>> byte2ReferenceEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.synchronize(this.sortedMap.byte2ReferenceEntrySet(), this.sync);
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        public ObjectSortedSet<Map.Entry<Byte, V>> entrySet() {
            return this.byte2ReferenceEntrySet();
        }

        @Override
        public ByteSortedSet keySet() {
            if (this.keys == null) {
                this.keys = ByteSortedSets.synchronize(this.sortedMap.keySet(), this.sync);
            }
            return (ByteSortedSet)this.keys;
        }

        @Override
        public Byte2ReferenceSortedMap<V> subMap(byte from2, byte to) {
            return new SynchronizedSortedMap<V>(this.sortedMap.subMap(from2, to), this.sync);
        }

        @Override
        public Byte2ReferenceSortedMap<V> headMap(byte to) {
            return new SynchronizedSortedMap<V>(this.sortedMap.headMap(to), this.sync);
        }

        @Override
        public Byte2ReferenceSortedMap<V> tailMap(byte from2) {
            return new SynchronizedSortedMap<V>(this.sortedMap.tailMap(from2), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte firstByteKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstByteKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte lastByteKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastByteKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Byte firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return (Byte)this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Byte lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return (Byte)this.sortedMap.lastKey();
            }
        }

        @Override
        public Byte2ReferenceSortedMap<V> subMap(Byte from2, Byte to) {
            return new SynchronizedSortedMap<V>(this.sortedMap.subMap(from2, to), this.sync);
        }

        @Override
        public Byte2ReferenceSortedMap<V> headMap(Byte to) {
            return new SynchronizedSortedMap<V>(this.sortedMap.headMap(to), this.sync);
        }

        @Override
        public Byte2ReferenceSortedMap<V> tailMap(Byte from2) {
            return new SynchronizedSortedMap<V>(this.sortedMap.tailMap(from2), this.sync);
        }
    }

    public static class Singleton<V>
    extends Byte2ReferenceMaps.Singleton<V>
    implements Byte2ReferenceSortedMap<V>,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final ByteComparator comparator;

        protected Singleton(byte key, V value2, ByteComparator comparator) {
            super(key, value2);
            this.comparator = comparator;
        }

        protected Singleton(byte key, V value2) {
            this(key, value2, null);
        }

        final int compare(byte k1, byte k2) {
            return this.comparator == null ? Byte.compare(k1, k2) : this.comparator.compare(k1, k2);
        }

        @Override
        public ByteComparator comparator() {
            return this.comparator;
        }

        @Override
        public ObjectSortedSet<Byte2ReferenceMap.Entry<V>> byte2ReferenceEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.singleton(new Byte2ReferenceMaps.Singleton.SingletonEntry(), Byte2ReferenceSortedMaps.entryComparator(this.comparator));
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        public ObjectSortedSet<Map.Entry<Byte, V>> entrySet() {
            return this.byte2ReferenceEntrySet();
        }

        @Override
        public ByteSortedSet keySet() {
            if (this.keys == null) {
                this.keys = ByteSortedSets.singleton(this.key, this.comparator);
            }
            return (ByteSortedSet)this.keys;
        }

        @Override
        public Byte2ReferenceSortedMap<V> subMap(byte from2, byte to) {
            if (this.compare(from2, this.key) <= 0 && this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Byte2ReferenceSortedMap<V> headMap(byte to) {
            if (this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Byte2ReferenceSortedMap<V> tailMap(byte from2) {
            if (this.compare(from2, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public byte firstByteKey() {
            return this.key;
        }

        @Override
        public byte lastByteKey() {
            return this.key;
        }

        @Override
        public Byte2ReferenceSortedMap<V> headMap(Byte oto) {
            return this.headMap((byte)oto);
        }

        @Override
        public Byte2ReferenceSortedMap<V> tailMap(Byte ofrom) {
            return this.tailMap((byte)ofrom);
        }

        @Override
        public Byte2ReferenceSortedMap<V> subMap(Byte ofrom, Byte oto) {
            return this.subMap((byte)ofrom, (byte)oto);
        }

        @Override
        public Byte firstKey() {
            return this.firstByteKey();
        }

        @Override
        public Byte lastKey() {
            return this.lastByteKey();
        }
    }

    public static class EmptySortedMap<V>
    extends Byte2ReferenceMaps.EmptyMap<V>
    implements Byte2ReferenceSortedMap<V>,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        @Override
        public ByteComparator comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Byte2ReferenceMap.Entry<V>> byte2ReferenceEntrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        public ObjectSortedSet<Map.Entry<Byte, V>> entrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        public ByteSortedSet keySet() {
            return ByteSortedSets.EMPTY_SET;
        }

        @Override
        public Byte2ReferenceSortedMap<V> subMap(byte from2, byte to) {
            return EMPTY_MAP;
        }

        @Override
        public Byte2ReferenceSortedMap<V> headMap(byte to) {
            return EMPTY_MAP;
        }

        @Override
        public Byte2ReferenceSortedMap<V> tailMap(byte from2) {
            return EMPTY_MAP;
        }

        @Override
        public byte firstByteKey() {
            throw new NoSuchElementException();
        }

        @Override
        public byte lastByteKey() {
            throw new NoSuchElementException();
        }

        @Override
        public Byte2ReferenceSortedMap<V> headMap(Byte oto) {
            return this.headMap((byte)oto);
        }

        @Override
        public Byte2ReferenceSortedMap<V> tailMap(Byte ofrom) {
            return this.tailMap((byte)ofrom);
        }

        @Override
        public Byte2ReferenceSortedMap<V> subMap(Byte ofrom, Byte oto) {
            return this.subMap((byte)ofrom, (byte)oto);
        }

        @Override
        public Byte firstKey() {
            return this.firstByteKey();
        }

        @Override
        public Byte lastKey() {
            return this.lastByteKey();
        }
    }
}

