/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil;

import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.ints.IntComparator;

public class Arrays {
    public static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    private Arrays() {
    }

    public static void ensureFromTo(int arrayLength, int from2, int to) {
        if (from2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Start index (" + from2 + ") is negative");
        }
        if (from2 > to) {
            throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to + ")");
        }
        if (to > arrayLength) {
            throw new ArrayIndexOutOfBoundsException("End index (" + to + ") is greater than array length (" + arrayLength + ")");
        }
    }

    public static void ensureOffsetLength(int arrayLength, int offset, int length) {
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length (" + length + ") is negative");
        }
        if (offset + length > arrayLength) {
            throw new ArrayIndexOutOfBoundsException("Last index (" + (offset + length) + ") is greater than array length (" + arrayLength + ")");
        }
    }

    private static void inPlaceMerge(int from2, int mid, int to, IntComparator comp, Swapper swapper) {
        int secondCut;
        int firstCut;
        if (from2 >= mid || mid >= to) {
            return;
        }
        if (to - from2 == 2) {
            if (comp.compare(mid, from2) < 0) {
                swapper.swap(from2, mid);
            }
            return;
        }
        if (mid - from2 > to - mid) {
            firstCut = from2 + (mid - from2) / 2;
            secondCut = Arrays.lowerBound(mid, to, firstCut, comp);
        } else {
            secondCut = mid + (to - mid) / 2;
            firstCut = Arrays.upperBound(from2, mid, secondCut, comp);
        }
        int first2 = firstCut;
        int middle2 = mid;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
        }
        mid = firstCut + (secondCut - mid);
        Arrays.inPlaceMerge(from2, firstCut, mid, comp, swapper);
        Arrays.inPlaceMerge(mid, secondCut, to, comp, swapper);
    }

    private static int lowerBound(int from2, int to, int pos, IntComparator comp) {
        int len2 = to - from2;
        while (len2 > 0) {
            int half = len2 / 2;
            int middle = from2 + half;
            if (comp.compare(middle, pos) < 0) {
                from2 = middle + 1;
                len2 -= half + 1;
                continue;
            }
            len2 = half;
        }
        return from2;
    }

    private static int upperBound(int from2, int mid, int pos, IntComparator comp) {
        int len2 = mid - from2;
        while (len2 > 0) {
            int half = len2 / 2;
            int middle = from2 + half;
            if (comp.compare(pos, middle) < 0) {
                len2 = half;
                continue;
            }
            from2 = middle + 1;
            len2 -= half + 1;
        }
        return from2;
    }

    private static int med3(int a, int b, int c, IntComparator comp) {
        int ab = comp.compare(a, b);
        int ac = comp.compare(a, c);
        int bc = comp.compare(b, c);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    public static void mergeSort(int from2, int to, IntComparator c, Swapper swapper) {
        int length = to - from2;
        if (length < 7) {
            for (int i = from2; i < to; ++i) {
                for (int j = i; j > from2 && c.compare(j - 1, j) > 0; --j) {
                    swapper.swap(j, j - 1);
                }
            }
            return;
        }
        int mid = from2 + to >>> 1;
        Arrays.mergeSort(from2, mid, c, swapper);
        Arrays.mergeSort(mid, to, c, swapper);
        if (c.compare(mid - 1, mid) <= 0) {
            return;
        }
        Arrays.inPlaceMerge(from2, mid, to, c, swapper);
    }

    public static void quickSort(int from2, int to, IntComparator comp, Swapper swapper) {
        int c;
        int a;
        int len2 = to - from2;
        if (len2 < 7) {
            for (int i = from2; i < to; ++i) {
                for (int j = i; j > from2 && comp.compare(j - 1, j) > 0; --j) {
                    swapper.swap(j, j - 1);
                }
            }
            return;
        }
        int m3 = from2 + len2 / 2;
        if (len2 > 7) {
            int l = from2;
            int n = to - 1;
            if (len2 > 40) {
                int s2 = len2 / 8;
                l = Arrays.med3(l, l + s2, l + 2 * s2, comp);
                m3 = Arrays.med3(m3 - s2, m3, m3 + s2, comp);
                n = Arrays.med3(n - 2 * s2, n - s2, n, comp);
            }
            m3 = Arrays.med3(l, m3, n, comp);
        }
        int b = a = from2;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(b, m3)) <= 0) {
                if (comparison == 0) {
                    if (a == m3) {
                        m3 = b;
                    } else if (b == m3) {
                        m3 = a;
                    }
                    swapper.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(c, m3)) >= 0) {
                if (comparison == 0) {
                    if (c == m3) {
                        m3 = d;
                    } else if (d == m3) {
                        m3 = c;
                    }
                    swapper.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            if (b == m3) {
                m3 = d;
            } else if (c == m3) {
                m3 = c;
            }
            swapper.swap(b++, c--);
        }
        int n = to;
        int s3 = Math.min(a - from2, b - a);
        Arrays.vecSwap(swapper, from2, b - s3, s3);
        s3 = Math.min(d - c, n - d - 1);
        Arrays.vecSwap(swapper, b, n - s3, s3);
        s3 = b - a;
        if (s3 > 1) {
            Arrays.quickSort(from2, from2 + s3, comp, swapper);
        }
        if ((s3 = d - c) > 1) {
            Arrays.quickSort(n - s3, n, comp, swapper);
        }
    }

    private static void vecSwap(Swapper swapper, int from2, int l, int s2) {
        int i = 0;
        while (i < s2) {
            swapper.swap(from2, l);
            ++i;
            ++from2;
            ++l;
        }
    }
}

