/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.color;

import com.twelvemonkeys.imageio.color.CMYKColorSpace;
import com.twelvemonkeys.imageio.color.ICCProfileSanitizer;
import com.twelvemonkeys.imageio.color.ProfileDeferralActivator;
import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.lang.Platform;
import com.twelvemonkeys.lang.SystemUtil;
import com.twelvemonkeys.lang.Validate;
import com.twelvemonkeys.util.LRUHashMap;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;

public final class ColorSpaces {
    static final boolean DEBUG = "true".equalsIgnoreCase(System.getProperty("com.twelvemonkeys.imageio.color.debug"));
    private static final ICCProfileSanitizer profileCleaner = ICCProfileSanitizer.Factory.get();
    public static final int CS_ADOBE_RGB_1998 = 5000;
    public static final int CS_GENERIC_CMYK = 5001;
    static final int ICC_PROFILE_HEADER_SIZE = 128;
    private static WeakReference<ICC_Profile> adobeRGB1998 = new WeakReference<Object>(null);
    private static WeakReference<ICC_Profile> genericCMYK = new WeakReference<Object>(null);
    private static final Map<Key, ICC_ColorSpace> cache = new LRUHashMap<Key, ICC_ColorSpace>(10);

    private ColorSpaces() {
    }

    public static ICC_ColorSpace createColorSpace(ICC_Profile iCC_Profile) {
        Validate.notNull(iCC_Profile, "profile");
        profileCleaner.fixProfile(iCC_Profile);
        byte[] byArray = ColorSpaces.getProfileHeaderWithProfileId(iCC_Profile);
        ICC_ColorSpace iCC_ColorSpace = ColorSpaces.getInternalCS(iCC_Profile.getColorSpaceType(), byArray);
        if (iCC_ColorSpace != null) {
            return iCC_ColorSpace;
        }
        return ColorSpaces.getCachedOrCreateCS(iCC_Profile, byArray);
    }

    private static byte[] getProfileHeaderWithProfileId(ICC_Profile iCC_Profile) {
        return ColorSpaces.getProfileHeaderWithProfileId(iCC_Profile.getData());
    }

    private static byte[] getProfileHeaderWithProfileId(byte[] byArray) {
        Arrays.fill(byArray, 4, 8, (byte)0);
        Arrays.fill(byArray, 40, 44, (byte)0);
        Arrays.fill(byArray, 64, 68, (byte)0);
        Arrays.fill(byArray, 80, 84, (byte)0);
        Arrays.fill(byArray, 84, 100, (byte)0);
        byte[] byArray2 = ColorSpaces.computeMD5(byArray);
        System.arraycopy(byArray2, 0, byArray, 84, byArray2.length);
        return Arrays.copyOf(byArray, 128);
    }

    private static byte[] computeMD5(byte[] byArray) {
        try {
            return MessageDigest.getInstance("MD5").digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Missing MD5 MessageDigest");
        }
    }

    private static ICC_ColorSpace getInternalCS(int n, byte[] byArray) {
        if (n == 5 && Arrays.equals(byArray, sRGB.header)) {
            return (ICC_ColorSpace)ColorSpace.getInstance(1000);
        }
        if (n == 6 && Arrays.equals(byArray, GRAY.header)) {
            return (ICC_ColorSpace)ColorSpace.getInstance(1003);
        }
        if (n == 13 && Arrays.equals(byArray, PYCC.header)) {
            return (ICC_ColorSpace)ColorSpace.getInstance(1002);
        }
        if (n == 5 && Arrays.equals(byArray, LINEAR_RGB.header)) {
            return (ICC_ColorSpace)ColorSpace.getInstance(1004);
        }
        if (n == 0 && Arrays.equals(byArray, CIEXYZ.header)) {
            return (ICC_ColorSpace)ColorSpace.getInstance(1001);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ICC_ColorSpace getCachedOrCreateCS(ICC_Profile iCC_Profile, byte[] byArray) {
        Key key = new Key(byArray);
        Map<Key, ICC_ColorSpace> map = cache;
        synchronized (map) {
            ICC_ColorSpace iCC_ColorSpace = ColorSpaces.getCachedCS(key);
            if (iCC_ColorSpace == null) {
                iCC_ColorSpace = new ICC_ColorSpace(iCC_Profile);
                ColorSpaces.validateColorSpace(iCC_ColorSpace);
                cache.put(key, iCC_ColorSpace);
                if (profileCleaner.validationAltersProfileHeader()) {
                    cache.put(new Key(ColorSpaces.getProfileHeaderWithProfileId(iCC_ColorSpace.getProfile())), iCC_ColorSpace);
                }
            }
            return iCC_ColorSpace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ICC_ColorSpace getCachedCS(Key key) {
        Map<Key, ICC_ColorSpace> map = cache;
        synchronized (map) {
            return cache.get(key);
        }
    }

    private static ICC_ColorSpace getCachedCS(byte[] byArray) {
        return ColorSpaces.getCachedCS(new Key(byArray));
    }

    private static void validateColorSpace(ICC_ColorSpace iCC_ColorSpace) {
        iCC_ColorSpace.fromRGB(new float[]{0.999f, 0.5f, 0.001f});
        iCC_ColorSpace.getProfile().getData();
    }

    public static boolean isCS_sRGB(ICC_Profile iCC_Profile) {
        Validate.notNull(iCC_Profile, "profile");
        return iCC_Profile.getColorSpaceType() == 5 && Arrays.equals(ColorSpaces.getProfileHeaderWithProfileId(iCC_Profile), sRGB.header);
    }

    public static boolean isCS_GRAY(ICC_Profile iCC_Profile) {
        Validate.notNull(iCC_Profile, "profile");
        return iCC_Profile.getColorSpaceType() == 6 && Arrays.equals(ColorSpaces.getProfileHeaderWithProfileId(iCC_Profile), GRAY.header);
    }

    static boolean isOffendingColorProfile(ICC_Profile iCC_Profile) {
        Validate.notNull(iCC_Profile, "profile");
        byte[] byArray = iCC_Profile.getData(1751474532);
        return byArray[64] != 0 || byArray[65] != 0 || byArray[66] != 0 || byArray[67] > 3;
    }

    public static ICC_Profile validateProfile(ICC_Profile iCC_Profile) {
        profileCleaner.fixProfile(iCC_Profile);
        ColorSpaces.validateColorSpace(new ICC_ColorSpace(iCC_Profile));
        return iCC_Profile;
    }

    public static ICC_Profile readProfileRaw(InputStream inputStream) throws IOException {
        return ICC_Profile.getInstance(inputStream);
    }

    public static ICC_Profile readProfile(InputStream inputStream) throws IOException {
        ICC_Profile iCC_Profile = ICC_Profile.getInstance(inputStream);
        if (iCC_Profile == null) {
            throw new IllegalArgumentException("Invalid ICC Profile Data");
        }
        return ColorSpaces.createProfile(iCC_Profile.getData());
    }

    public static ICC_Profile createProfileRaw(byte[] byArray) {
        try {
            return ColorSpaces.readProfileRaw(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Invalid ICC Profile Data", iOException);
        }
    }

    public static ICC_Profile createProfile(byte[] byArray) {
        Validate.notNull(byArray, "input");
        if (byArray.length < 128) {
            throw new IllegalArgumentException("Truncated ICC profile, length < 128: " + byArray.length);
        }
        int n = ColorSpaces.intBigEndian(byArray, 0);
        if (n < 0 || n > byArray.length) {
            throw new IllegalArgumentException("Truncated ICC profile, length < " + n + ": " + byArray.length);
        }
        if (byArray[36] != 97 || byArray[37] != 99 || byArray[38] != 115 || byArray[39] != 112) {
            throw new IllegalArgumentException("Not an ICC profile, missing file signature");
        }
        byte[] byArray2 = ColorSpaces.getProfileHeaderWithProfileId(byArray);
        int n2 = ColorSpaces.getCsType(byArray2);
        ICC_ColorSpace iCC_ColorSpace = ColorSpaces.getInternalCS(n2, byArray2);
        if (iCC_ColorSpace != null) {
            return iCC_ColorSpace.getProfile();
        }
        ICC_ColorSpace iCC_ColorSpace2 = ColorSpaces.getCachedCS(byArray2);
        if (iCC_ColorSpace2 != null) {
            return iCC_ColorSpace2.getProfile();
        }
        byte[] byArray3 = byArray.length == n ? byArray : Arrays.copyOf(byArray, n);
        ICC_Profile iCC_Profile = ICC_Profile.getInstance(byArray3);
        return ColorSpaces.createColorSpace(iCC_Profile).getProfile();
    }

    private static int intBigEndian(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private static int getCsType(byte[] byArray) {
        int n = ColorSpaces.intBigEndian(byArray, 16);
        switch (n) {
            case 1482250784: {
                return 0;
            }
            case 1281450528: {
                return 1;
            }
            case 1282766368: {
                return 2;
            }
            case 1497588338: {
                return 3;
            }
            case 1501067552: {
                return 4;
            }
            case 1380401696: {
                return 5;
            }
            case 1196573017: {
                return 6;
            }
            case 1213421088: {
                return 7;
            }
            case 1212961568: {
                return 8;
            }
            case 1129142603: {
                return 9;
            }
            case 1129142560: {
                return 11;
            }
            case 843271250: {
                return 12;
            }
            case 860048466: {
                return 13;
            }
            case 876825682: {
                return 14;
            }
            case 893602898: {
                return 15;
            }
            case 910380114: {
                return 16;
            }
            case 927157330: {
                return 17;
            }
            case 943934546: {
                return 18;
            }
            case 960711762: {
                return 19;
            }
            case 1094929490: {
                return 20;
            }
            case 1111706706: {
                return 21;
            }
            case 1128483922: {
                return 22;
            }
            case 1145261138: {
                return 23;
            }
            case 1162038354: {
                return 24;
            }
            case 1178815570: {
                return 25;
            }
        }
        throw new IllegalArgumentException("Invalid ICC color space signature: " + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorSpace getColorSpace(int n) {
        switch (n) {
            case 5000: {
                Class<ColorSpaces> clazz = ColorSpaces.class;
                synchronized (ColorSpaces.class) {
                    ICC_Profile iCC_Profile = (ICC_Profile)adobeRGB1998.get();
                    if (iCC_Profile == null) {
                        iCC_Profile = ColorSpaces.readProfileFromPath(Profiles.getPath("ADOBE_RGB_1998"));
                        if (iCC_Profile == null && (iCC_Profile = ColorSpaces.readProfileFromClasspathResource("/profiles/ClayRGB1998.icc")) == null) {
                            throw new IllegalStateException("Could not read AdobeRGB1998 profile");
                        }
                        if (iCC_Profile.getColorSpaceType() != 5) {
                            throw new IllegalStateException("Configured AdobeRGB1998 profile is not TYPE_RGB");
                        }
                        adobeRGB1998 = new WeakReference<ICC_Profile>(iCC_Profile);
                    }
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    return ColorSpaces.createColorSpace(iCC_Profile);
                }
            }
            case 5001: {
                Class<ColorSpaces> clazz = ColorSpaces.class;
                synchronized (ColorSpaces.class) {
                    ICC_Profile iCC_Profile = (ICC_Profile)genericCMYK.get();
                    if (iCC_Profile == null) {
                        iCC_Profile = ColorSpaces.readProfileFromPath(Profiles.getPath("GENERIC_CMYK"));
                        if (iCC_Profile == null) {
                            if (DEBUG) {
                                System.out.println("Using fallback profile");
                            }
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return CMYKColorSpace.getInstance();
                        }
                        if (iCC_Profile.getColorSpaceType() != 9) {
                            throw new IllegalStateException("Configured Generic CMYK profile is not TYPE_CMYK");
                        }
                        genericCMYK = new WeakReference<ICC_Profile>(iCC_Profile);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return ColorSpaces.createColorSpace(iCC_Profile);
                }
            }
        }
        return ColorSpace.getInstance(n);
    }

    private static ICC_Profile readProfileFromClasspathResource(String string) {
        InputStream inputStream = ColorSpaces.class.getResourceAsStream(string);
        if (inputStream != null) {
            if (DEBUG) {
                System.out.println("Loading profile from classpath resource: " + string);
            }
            try {
                ICC_Profile iCC_Profile = ICC_Profile.getInstance(inputStream);
                return iCC_Profile;
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    iOException.printStackTrace();
                }
            }
            finally {
                FileUtil.close(inputStream);
            }
        }
        return null;
    }

    private static ICC_Profile readProfileFromPath(String string) {
        block4: {
            if (string != null) {
                if (DEBUG) {
                    System.out.println("Loading profile from: " + string);
                }
                try {
                    return ICC_Profile.getInstance(string);
                }
                catch (IOException | SecurityException exception) {
                    if (!DEBUG) break block4;
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    static /* synthetic */ byte[] access$500(ICC_Profile iCC_Profile) {
        return ColorSpaces.getProfileHeaderWithProfileId(iCC_Profile);
    }

    static {
        ProfileDeferralActivator.activateProfiles();
    }

    private static class Profiles {
        private static final Properties PROFILES = Profiles.loadProfiles();

        private Profiles() {
        }

        private static Properties loadProfiles() {
            Properties properties;
            try {
                properties = SystemUtil.loadProperties(ColorSpaces.class, "com/twelvemonkeys/imageio/color/icc_profiles_" + Platform.os().id());
            }
            catch (IOException | SecurityException exception) {
                System.err.printf("Warning: Could not load system default ICC profile locations from %s, will use bundled fallback profiles.\n", exception.getMessage());
                if (DEBUG) {
                    exception.printStackTrace();
                }
                properties = null;
            }
            Properties properties2 = new Properties(properties);
            try {
                Properties properties3 = SystemUtil.loadProperties(ColorSpaces.class, "com/twelvemonkeys/imageio/color/icc_profiles");
                properties2.putAll((Map<?, ?>)properties3);
            }
            catch (IOException | SecurityException exception) {
                // empty catch block
            }
            if (DEBUG) {
                System.out.println("User ICC profiles: " + properties2);
                System.out.println("System ICC profiles : " + properties);
            }
            return properties2;
        }

        static String getPath(String string) {
            return PROFILES.getProperty(string);
        }
    }

    private static class LINEAR_RGB {
        private static final byte[] header = ColorSpaces.access$500(ICC_Profile.getInstance(1004));

        private LINEAR_RGB() {
        }
    }

    private static class GRAY {
        private static final byte[] header = ColorSpaces.access$500(ICC_Profile.getInstance(1003));

        private GRAY() {
        }
    }

    private static class PYCC {
        private static final byte[] header = ColorSpaces.access$500(ICC_Profile.getInstance(1002));

        private PYCC() {
        }
    }

    private static class CIEXYZ {
        private static final byte[] header = ColorSpaces.access$500(ICC_Profile.getInstance(1001));

        private CIEXYZ() {
        }
    }

    private static class sRGB {
        private static final byte[] header = ColorSpaces.access$500(ICC_Profile.getInstance(1000));

        private sRGB() {
        }
    }

    private static final class Key {
        private final byte[] data;

        Key(byte[] byArray) {
            this.data = byArray;
        }

        public boolean equals(Object object) {
            return object instanceof Key && Arrays.equals(this.data, ((Key)object).data);
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
        }
    }
}

