/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.shaded.protobuf_v_3_5_1;

import com.intel.analytics.shaded.protobuf_v_3_5_1.ByteString;
import com.intel.analytics.shaded.protobuf_v_3_5_1.CodedInputStream;
import com.intel.analytics.shaded.protobuf_v_3_5_1.CodedOutputStream;
import com.intel.analytics.shaded.protobuf_v_3_5_1.GeneratedMessageLite;
import com.intel.analytics.shaded.protobuf_v_3_5_1.Internal;
import com.intel.analytics.shaded.protobuf_v_3_5_1.LazyField;
import com.intel.analytics.shaded.protobuf_v_3_5_1.MessageLite;
import com.intel.analytics.shaded.protobuf_v_3_5_1.SmallSortedMap;
import com.intel.analytics.shaded.protobuf_v_3_5_1.WireFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class FieldSet<T extends FieldDescriptorLite<T>> {
    private static final int DEFAULT_FIELD_MAP_ARRAY_SIZE = 16;
    private final SmallSortedMap<T, Object> fields;
    private boolean isImmutable;
    private boolean hasLazyField;
    private static final FieldSet DEFAULT_INSTANCE = new FieldSet(true);

    private FieldSet() {
        this.fields = SmallSortedMap.newFieldMap(16);
    }

    private FieldSet(boolean dummy) {
        this(SmallSortedMap.newFieldMap(0));
        this.makeImmutable();
    }

    private FieldSet(SmallSortedMap<T, Object> fields) {
        this.fields = fields;
        this.makeImmutable();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> newFieldSet() {
        return new FieldSet<T>();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> emptySet() {
        return DEFAULT_INSTANCE;
    }

    public static <T extends FieldDescriptorLite<T>> Builder<T> newBuilder() {
        return new Builder();
    }

    boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public void makeImmutable() {
        if (this.isImmutable) {
            return;
        }
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            if (!(entry.getValue() instanceof GeneratedMessageLite)) continue;
            ((GeneratedMessageLite)entry.getValue()).makeImmutable();
        }
        this.fields.makeImmutable();
        this.isImmutable = true;
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldSet)) {
            return false;
        }
        FieldSet other = (FieldSet)o;
        return this.fields.equals(other.fields);
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public FieldSet<T> clone() {
        FieldSet<FieldDescriptorLite> clone2 = FieldSet.newFieldSet();
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            clone2.setField((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            clone2.setField((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        clone2.hasLazyField = this.hasLazyField;
        return clone2;
    }

    public void clear() {
        this.fields.clear();
        this.hasLazyField = false;
    }

    public Map<T, Object> getAllFields() {
        if (this.hasLazyField) {
            SmallSortedMap<T, Object> result2 = FieldSet.cloneAllFieldsMap(this.fields, false);
            if (this.fields.isImmutable()) {
                result2.makeImmutable();
            }
            return result2;
        }
        return this.fields.isImmutable() ? this.fields : Collections.unmodifiableMap(this.fields);
    }

    private static <T extends FieldDescriptorLite<T>> SmallSortedMap<T, Object> cloneAllFieldsMap(SmallSortedMap<T, Object> fields, boolean copyList) {
        SmallSortedMap result2 = SmallSortedMap.newFieldMap(16);
        for (int i = 0; i < fields.getNumArrayEntries(); ++i) {
            FieldSet.cloneFieldEntry(result2, fields.getArrayEntryAt(i), copyList);
        }
        for (Map.Entry<T, Object> entry : fields.getOverflowEntries()) {
            FieldSet.cloneFieldEntry(result2, entry, copyList);
        }
        return result2;
    }

    private static <T extends FieldDescriptorLite<T>> void cloneFieldEntry(Map<T, Object> map, Map.Entry<T, Object> entry, boolean copyList) {
        FieldDescriptorLite key = (FieldDescriptorLite)entry.getKey();
        Object value2 = entry.getValue();
        if (value2 instanceof LazyField) {
            map.put(key, ((LazyField)value2).getValue());
        } else if (copyList && value2 instanceof List) {
            map.put(key, new ArrayList((List)value2));
        } else {
            map.put(key, value2);
        }
    }

    public Iterator<Map.Entry<T, Object>> iterator() {
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.entrySet().iterator());
        }
        return this.fields.entrySet().iterator();
    }

    Iterator<Map.Entry<T, Object>> descendingIterator() {
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.descendingEntrySet().iterator());
        }
        return this.fields.descendingEntrySet().iterator();
    }

    public boolean hasField(T descriptor) {
        if (descriptor.isRepeated()) {
            throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
        }
        return this.fields.get(descriptor) != null;
    }

    public Object getField(T descriptor) {
        Object o = this.fields.get(descriptor);
        if (o instanceof LazyField) {
            return ((LazyField)o).getValue();
        }
        return o;
    }

    public void setField(T descriptor, Object value2) {
        if (descriptor.isRepeated()) {
            if (!(value2 instanceof List)) {
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
            ArrayList newList = new ArrayList();
            newList.addAll(value2);
            for (Object element : newList) {
                this.verifyType(descriptor, element);
            }
            value2 = newList;
        } else {
            this.verifyType(descriptor, value2);
        }
        if (value2 instanceof LazyField) {
            this.hasLazyField = true;
        }
        this.fields.put(descriptor, (Object)value2);
    }

    public void clearField(T descriptor) {
        this.fields.remove(descriptor);
        if (this.fields.isEmpty()) {
            this.hasLazyField = false;
        }
    }

    public int getRepeatedFieldCount(T descriptor) {
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object value2 = this.getField(descriptor);
        if (value2 == null) {
            return 0;
        }
        return ((List)value2).size();
    }

    public Object getRepeatedField(T descriptor, int index) {
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object value2 = this.getField(descriptor);
        if (value2 == null) {
            throw new IndexOutOfBoundsException();
        }
        return ((List)value2).get(index);
    }

    public void setRepeatedField(T descriptor, int index, Object value2) {
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object list2 = this.getField(descriptor);
        if (list2 == null) {
            throw new IndexOutOfBoundsException();
        }
        this.verifyType(descriptor, value2);
        ((List)list2).set(index, value2);
    }

    public void addRepeatedField(T descriptor, Object value2) {
        ArrayList<Object> list2;
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
        }
        this.verifyType(descriptor, value2);
        Object existingValue = this.getField(descriptor);
        if (existingValue == null) {
            list2 = new ArrayList<Object>();
            this.fields.put(descriptor, (Object)list2);
        } else {
            list2 = (ArrayList<Object>)existingValue;
        }
        list2.add(value2);
    }

    private void verifyType(T descriptor, Object value2) {
        if (!FieldSet.isValidType(descriptor.getLiteType(), value2)) {
            throw new IllegalArgumentException(String.format("Wrong object type used with protocol message reflection.\nField number: %d, field java type: %s, value type: %s\n", new Object[]{descriptor.getNumber(), descriptor.getLiteType().getJavaType(), value2.getClass().getName()}));
        }
    }

    private static boolean isValidType(WireFormat.FieldType type, Object value2) {
        Internal.checkNotNull(value2);
        switch (type.getJavaType()) {
            case INT: {
                return value2 instanceof Integer;
            }
            case LONG: {
                return value2 instanceof Long;
            }
            case FLOAT: {
                return value2 instanceof Float;
            }
            case DOUBLE: {
                return value2 instanceof Double;
            }
            case BOOLEAN: {
                return value2 instanceof Boolean;
            }
            case STRING: {
                return value2 instanceof String;
            }
            case BYTE_STRING: {
                return value2 instanceof ByteString || value2 instanceof byte[];
            }
            case ENUM: {
                return value2 instanceof Integer || value2 instanceof Internal.EnumLite;
            }
            case MESSAGE: {
                return value2 instanceof MessageLite || value2 instanceof LazyField;
            }
        }
        return false;
    }

    public boolean isInitialized() {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            if (FieldSet.isInitialized(this.fields.getArrayEntryAt(i))) continue;
            return false;
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            if (FieldSet.isInitialized(entry)) continue;
            return false;
        }
        return true;
    }

    private static <T extends FieldDescriptorLite<T>> boolean isInitialized(Map.Entry<T, Object> entry) {
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            if (descriptor.isRepeated()) {
                for (MessageLite element : (List)entry.getValue()) {
                    if (element.isInitialized()) continue;
                    return false;
                }
            } else {
                Object value2 = entry.getValue();
                if (value2 instanceof MessageLite) {
                    if (!((MessageLite)value2).isInitialized()) {
                        return false;
                    }
                } else {
                    if (value2 instanceof LazyField) {
                        return true;
                    }
                    throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
                }
            }
        }
        return true;
    }

    static int getWireFormatForFieldType(WireFormat.FieldType type, boolean isPacked) {
        if (isPacked) {
            return 2;
        }
        return type.getWireType();
    }

    public void mergeFrom(FieldSet<T> other) {
        for (int i = 0; i < other.fields.getNumArrayEntries(); ++i) {
            this.mergeFromField(other.fields.getArrayEntryAt(i));
        }
        for (Map.Entry<T, Object> entry : other.fields.getOverflowEntries()) {
            this.mergeFromField(entry);
        }
    }

    private static Object cloneIfMutable(Object value2) {
        if (value2 instanceof byte[]) {
            byte[] bytes = (byte[])value2;
            byte[] copy = new byte[bytes.length];
            System.arraycopy(bytes, 0, copy, 0, bytes.length);
            return copy;
        }
        return value2;
    }

    private void mergeFromField(Map.Entry<T, Object> entry) {
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        Object otherValue = entry.getValue();
        if (otherValue instanceof LazyField) {
            otherValue = ((LazyField)otherValue).getValue();
        }
        if (descriptor.isRepeated()) {
            ArrayList value2 = this.getField(descriptor);
            if (value2 == null) {
                value2 = new ArrayList();
            }
            for (Object element : (List)otherValue) {
                ((List)value2).add(FieldSet.cloneIfMutable(element));
            }
            this.fields.put((T)descriptor, (Object)value2);
        } else if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            Object value3 = this.getField(descriptor);
            if (value3 == null) {
                this.fields.put((T)descriptor, FieldSet.cloneIfMutable(otherValue));
            } else {
                value3 = descriptor.internalMergeFrom(((MessageLite)value3).toBuilder(), (MessageLite)otherValue).build();
                this.fields.put((T)descriptor, value3);
            }
        } else {
            this.fields.put((T)descriptor, FieldSet.cloneIfMutable(otherValue));
        }
    }

    public static Object readPrimitiveField(CodedInputStream input, WireFormat.FieldType type, boolean checkUtf8) throws IOException {
        if (checkUtf8) {
            return WireFormat.readPrimitiveField(input, type, WireFormat.Utf8Validation.STRICT);
        }
        return WireFormat.readPrimitiveField(input, type, WireFormat.Utf8Validation.LOOSE);
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), output);
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), output);
        }
    }

    public void writeMessageSetTo(CodedOutputStream output) throws IOException {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            this.writeMessageSetTo(this.fields.getArrayEntryAt(i), output);
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            this.writeMessageSetTo(entry, output);
        }
    }

    private void writeMessageSetTo(Map.Entry<T, Object> entry, CodedOutputStream output) throws IOException {
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !descriptor.isRepeated() && !descriptor.isPacked()) {
            Object value2 = entry.getValue();
            if (value2 instanceof LazyField) {
                value2 = ((LazyField)value2).getValue();
            }
            output.writeMessageSetExtension(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)value2);
        } else {
            FieldSet.writeField(descriptor, entry.getValue(), output);
        }
    }

    static void writeElement(CodedOutputStream output, WireFormat.FieldType type, int number, Object value2) throws IOException {
        if (type == WireFormat.FieldType.GROUP) {
            output.writeGroup(number, (MessageLite)value2);
        } else {
            output.writeTag(number, FieldSet.getWireFormatForFieldType(type, false));
            FieldSet.writeElementNoTag(output, type, value2);
        }
    }

    static void writeElementNoTag(CodedOutputStream output, WireFormat.FieldType type, Object value2) throws IOException {
        switch (type) {
            case DOUBLE: {
                output.writeDoubleNoTag((Double)value2);
                break;
            }
            case FLOAT: {
                output.writeFloatNoTag(((Float)value2).floatValue());
                break;
            }
            case INT64: {
                output.writeInt64NoTag((Long)value2);
                break;
            }
            case UINT64: {
                output.writeUInt64NoTag((Long)value2);
                break;
            }
            case INT32: {
                output.writeInt32NoTag((Integer)value2);
                break;
            }
            case FIXED64: {
                output.writeFixed64NoTag((Long)value2);
                break;
            }
            case FIXED32: {
                output.writeFixed32NoTag((Integer)value2);
                break;
            }
            case BOOL: {
                output.writeBoolNoTag((Boolean)value2);
                break;
            }
            case GROUP: {
                output.writeGroupNoTag((MessageLite)value2);
                break;
            }
            case MESSAGE: {
                output.writeMessageNoTag((MessageLite)value2);
                break;
            }
            case STRING: {
                if (value2 instanceof ByteString) {
                    output.writeBytesNoTag((ByteString)value2);
                    break;
                }
                output.writeStringNoTag((String)value2);
                break;
            }
            case BYTES: {
                if (value2 instanceof ByteString) {
                    output.writeBytesNoTag((ByteString)value2);
                    break;
                }
                output.writeByteArrayNoTag((byte[])value2);
                break;
            }
            case UINT32: {
                output.writeUInt32NoTag((Integer)value2);
                break;
            }
            case SFIXED32: {
                output.writeSFixed32NoTag((Integer)value2);
                break;
            }
            case SFIXED64: {
                output.writeSFixed64NoTag((Long)value2);
                break;
            }
            case SINT32: {
                output.writeSInt32NoTag((Integer)value2);
                break;
            }
            case SINT64: {
                output.writeSInt64NoTag((Long)value2);
                break;
            }
            case ENUM: {
                if (value2 instanceof Internal.EnumLite) {
                    output.writeEnumNoTag(((Internal.EnumLite)value2).getNumber());
                    break;
                }
                output.writeEnumNoTag((Integer)value2);
            }
        }
    }

    public static void writeField(FieldDescriptorLite<?> descriptor, Object value2, CodedOutputStream output) throws IOException {
        WireFormat.FieldType type = descriptor.getLiteType();
        int number = descriptor.getNumber();
        if (descriptor.isRepeated()) {
            List valueList = (List)value2;
            if (descriptor.isPacked()) {
                output.writeTag(number, 2);
                int dataSize = 0;
                for (Object element : valueList) {
                    dataSize += FieldSet.computeElementSizeNoTag(type, element);
                }
                output.writeRawVarint32(dataSize);
                for (Object element : valueList) {
                    FieldSet.writeElementNoTag(output, type, element);
                }
            } else {
                for (Object element : valueList) {
                    FieldSet.writeElement(output, type, number, element);
                }
            }
        } else if (value2 instanceof LazyField) {
            FieldSet.writeElement(output, type, number, ((LazyField)value2).getValue());
        } else {
            FieldSet.writeElement(output, type, number, value2);
        }
    }

    public int getSerializedSize() {
        int size = 0;
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            size += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            size += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        return size;
    }

    public int getMessageSetSerializedSize() {
        int size = 0;
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            size += this.getMessageSetSerializedSize(this.fields.getArrayEntryAt(i));
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            size += this.getMessageSetSerializedSize(entry);
        }
        return size;
    }

    private int getMessageSetSerializedSize(Map.Entry<T, Object> entry) {
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        Object value2 = entry.getValue();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !descriptor.isRepeated() && !descriptor.isPacked()) {
            if (value2 instanceof LazyField) {
                return CodedOutputStream.computeLazyFieldMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (LazyField)value2);
            }
            return CodedOutputStream.computeMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)value2);
        }
        return FieldSet.computeFieldSize(descriptor, value2);
    }

    static int computeElementSize(WireFormat.FieldType type, int number, Object value2) {
        int tagSize = CodedOutputStream.computeTagSize(number);
        if (type == WireFormat.FieldType.GROUP) {
            tagSize *= 2;
        }
        return tagSize + FieldSet.computeElementSizeNoTag(type, value2);
    }

    static int computeElementSizeNoTag(WireFormat.FieldType type, Object value2) {
        switch (type) {
            case DOUBLE: {
                return CodedOutputStream.computeDoubleSizeNoTag((Double)value2);
            }
            case FLOAT: {
                return CodedOutputStream.computeFloatSizeNoTag(((Float)value2).floatValue());
            }
            case INT64: {
                return CodedOutputStream.computeInt64SizeNoTag((Long)value2);
            }
            case UINT64: {
                return CodedOutputStream.computeUInt64SizeNoTag((Long)value2);
            }
            case INT32: {
                return CodedOutputStream.computeInt32SizeNoTag((Integer)value2);
            }
            case FIXED64: {
                return CodedOutputStream.computeFixed64SizeNoTag((Long)value2);
            }
            case FIXED32: {
                return CodedOutputStream.computeFixed32SizeNoTag((Integer)value2);
            }
            case BOOL: {
                return CodedOutputStream.computeBoolSizeNoTag((Boolean)value2);
            }
            case GROUP: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)value2);
            }
            case BYTES: {
                if (value2 instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value2);
                }
                return CodedOutputStream.computeByteArraySizeNoTag((byte[])value2);
            }
            case STRING: {
                if (value2 instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value2);
                }
                return CodedOutputStream.computeStringSizeNoTag((String)value2);
            }
            case UINT32: {
                return CodedOutputStream.computeUInt32SizeNoTag((Integer)value2);
            }
            case SFIXED32: {
                return CodedOutputStream.computeSFixed32SizeNoTag((Integer)value2);
            }
            case SFIXED64: {
                return CodedOutputStream.computeSFixed64SizeNoTag((Long)value2);
            }
            case SINT32: {
                return CodedOutputStream.computeSInt32SizeNoTag((Integer)value2);
            }
            case SINT64: {
                return CodedOutputStream.computeSInt64SizeNoTag((Long)value2);
            }
            case MESSAGE: {
                if (value2 instanceof LazyField) {
                    return CodedOutputStream.computeLazyFieldSizeNoTag((LazyField)value2);
                }
                return CodedOutputStream.computeMessageSizeNoTag((MessageLite)value2);
            }
            case ENUM: {
                if (value2 instanceof Internal.EnumLite) {
                    return CodedOutputStream.computeEnumSizeNoTag(((Internal.EnumLite)value2).getNumber());
                }
                return CodedOutputStream.computeEnumSizeNoTag((Integer)value2);
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    public static int computeFieldSize(FieldDescriptorLite<?> descriptor, Object value2) {
        WireFormat.FieldType type = descriptor.getLiteType();
        int number = descriptor.getNumber();
        if (descriptor.isRepeated()) {
            if (descriptor.isPacked()) {
                int dataSize = 0;
                for (Object element : (List)value2) {
                    dataSize += FieldSet.computeElementSizeNoTag(type, element);
                }
                return dataSize + CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeRawVarint32Size(dataSize);
            }
            int size = 0;
            for (Object element : (List)value2) {
                size += FieldSet.computeElementSize(type, number, element);
            }
            return size;
        }
        return FieldSet.computeElementSize(type, number, value2);
    }

    static final class Builder<T extends FieldDescriptorLite<T>> {
        private SmallSortedMap<T, Object> fields;
        private boolean hasLazyField;
        private boolean isMutable;
        private boolean hasNestedBuilders;

        private Builder() {
            this(SmallSortedMap.newFieldMap(16));
        }

        private Builder(SmallSortedMap<T, Object> fields) {
            this.fields = fields;
            this.isMutable = true;
        }

        public FieldSet<T> build() {
            return this.buildImpl(false);
        }

        public FieldSet<T> buildPartial() {
            return this.buildImpl(true);
        }

        private FieldSet<T> buildImpl(boolean partial) {
            if (this.fields.isEmpty()) {
                return FieldSet.emptySet();
            }
            this.isMutable = false;
            SmallSortedMap fieldsForBuild = this.fields;
            if (this.hasNestedBuilders) {
                fieldsForBuild = FieldSet.cloneAllFieldsMap(this.fields, false);
                Builder.replaceBuilders(fieldsForBuild, partial);
            }
            FieldSet fieldSet = new FieldSet(fieldsForBuild);
            fieldSet.hasLazyField = this.hasLazyField;
            return fieldSet;
        }

        private static <T extends FieldDescriptorLite<T>> void replaceBuilders(SmallSortedMap<T, Object> fieldMap, boolean partial) {
            for (int i = 0; i < fieldMap.getNumArrayEntries(); ++i) {
                Builder.replaceBuilders(fieldMap.getArrayEntryAt(i), partial);
            }
            for (Map.Entry<T, Object> entry : fieldMap.getOverflowEntries()) {
                Builder.replaceBuilders(entry, partial);
            }
        }

        private static <T extends FieldDescriptorLite<T>> void replaceBuilders(Map.Entry<T, Object> entry, boolean partial) {
            entry.setValue(Builder.replaceBuilders((FieldDescriptorLite)entry.getKey(), entry.getValue(), partial));
        }

        private static <T extends FieldDescriptorLite<T>> Object replaceBuilders(T descriptor, Object value2, boolean partial) {
            if (value2 == null) {
                return value2;
            }
            if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
                if (descriptor.isRepeated()) {
                    if (!(value2 instanceof List)) {
                        throw new IllegalStateException("Repeated field should contains a List but actually contains type: " + value2.getClass());
                    }
                    ArrayList<Object> list2 = (ArrayList<Object>)value2;
                    for (int i = 0; i < list2.size(); ++i) {
                        Object oldElement = list2.get(i);
                        Object newElement = Builder.replaceBuilder(oldElement, partial);
                        if (newElement == oldElement) continue;
                        if (list2 == value2) {
                            list2 = new ArrayList<Object>(list2);
                        }
                        list2.set(i, newElement);
                    }
                    return list2;
                }
                return Builder.replaceBuilder(value2, partial);
            }
            return value2;
        }

        private static Object replaceBuilder(Object value2, boolean partial) {
            if (!(value2 instanceof MessageLite.Builder)) {
                return value2;
            }
            MessageLite.Builder builder = (MessageLite.Builder)value2;
            if (partial) {
                return builder.buildPartial();
            }
            return builder.build();
        }

        public static <T extends FieldDescriptorLite<T>> Builder<T> fromFieldSet(FieldSet<T> fieldSet) {
            Builder<T> builder = new Builder<T>(FieldSet.cloneAllFieldsMap(((FieldSet)fieldSet).fields, true));
            builder.hasLazyField = ((FieldSet)fieldSet).hasLazyField;
            return builder;
        }

        public Map<T, Object> getAllFields() {
            if (this.hasLazyField) {
                SmallSortedMap result2 = FieldSet.cloneAllFieldsMap(this.fields, false);
                if (this.fields.isImmutable()) {
                    result2.makeImmutable();
                } else {
                    Builder.replaceBuilders(result2, true);
                }
                return result2;
            }
            return this.fields.isImmutable() ? this.fields : Collections.unmodifiableMap(this.fields);
        }

        public boolean hasField(T descriptor) {
            if (descriptor.isRepeated()) {
                throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
            }
            return this.fields.get(descriptor) != null;
        }

        public Object getField(T descriptor) {
            Object value2 = this.getFieldAllowBuilders(descriptor);
            return Builder.replaceBuilders(descriptor, value2, true);
        }

        Object getFieldAllowBuilders(T descriptor) {
            Object o = this.fields.get(descriptor);
            if (o instanceof LazyField) {
                return ((LazyField)o).getValue();
            }
            return o;
        }

        private void ensureIsMutable() {
            if (!this.isMutable) {
                this.fields = FieldSet.cloneAllFieldsMap(this.fields, true);
                this.isMutable = true;
            }
        }

        public void setField(T descriptor, Object value2) {
            this.ensureIsMutable();
            if (descriptor.isRepeated()) {
                if (!(value2 instanceof List)) {
                    throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
                }
                ArrayList newList = new ArrayList(value2);
                for (Object element : newList) {
                    this.verifyType(descriptor, element);
                    this.hasNestedBuilders = this.hasNestedBuilders || element instanceof MessageLite.Builder;
                }
                value2 = newList;
            } else {
                this.verifyType(descriptor, value2);
            }
            if (value2 instanceof LazyField) {
                this.hasLazyField = true;
            }
            this.hasNestedBuilders = this.hasNestedBuilders || value2 instanceof MessageLite.Builder;
            this.fields.put(descriptor, (Object)value2);
        }

        public void clearField(T descriptor) {
            this.ensureIsMutable();
            this.fields.remove(descriptor);
            if (this.fields.isEmpty()) {
                this.hasLazyField = false;
            }
        }

        public int getRepeatedFieldCount(T descriptor) {
            if (!descriptor.isRepeated()) {
                throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
            }
            Object value2 = this.getField(descriptor);
            if (value2 == null) {
                return 0;
            }
            return ((List)value2).size();
        }

        public Object getRepeatedField(T descriptor, int index) {
            if (this.hasNestedBuilders) {
                this.ensureIsMutable();
            }
            Object value2 = this.getRepeatedFieldAllowBuilders(descriptor, index);
            return Builder.replaceBuilder(value2, true);
        }

        Object getRepeatedFieldAllowBuilders(T descriptor, int index) {
            if (!descriptor.isRepeated()) {
                throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
            }
            Object value2 = this.getFieldAllowBuilders(descriptor);
            if (value2 == null) {
                throw new IndexOutOfBoundsException();
            }
            return ((List)value2).get(index);
        }

        public void setRepeatedField(T descriptor, int index, Object value2) {
            this.ensureIsMutable();
            if (!descriptor.isRepeated()) {
                throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
            }
            this.hasNestedBuilders = this.hasNestedBuilders || value2 instanceof MessageLite.Builder;
            Object list2 = this.getField(descriptor);
            if (list2 == null) {
                throw new IndexOutOfBoundsException();
            }
            this.verifyType(descriptor, value2);
            ((List)list2).set(index, value2);
        }

        public void addRepeatedField(T descriptor, Object value2) {
            ArrayList<Object> list2;
            this.ensureIsMutable();
            if (!descriptor.isRepeated()) {
                throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
            }
            this.hasNestedBuilders = this.hasNestedBuilders || value2 instanceof MessageLite.Builder;
            this.verifyType(descriptor, value2);
            Object existingValue = this.getField(descriptor);
            if (existingValue == null) {
                list2 = new ArrayList<Object>();
                this.fields.put(descriptor, (Object)list2);
            } else {
                list2 = (ArrayList<Object>)existingValue;
            }
            list2.add(value2);
        }

        private void verifyType(T descriptor, Object value2) {
            if (!FieldSet.isValidType(descriptor.getLiteType(), value2)) {
                if (descriptor.getLiteType().getJavaType() == WireFormat.JavaType.MESSAGE && value2 instanceof MessageLite.Builder) {
                    return;
                }
                throw new IllegalArgumentException(String.format("Wrong object type used with protocol message reflection.\nField number: %d, field java type: %s, value type: %s\n", new Object[]{descriptor.getNumber(), descriptor.getLiteType().getJavaType(), value2.getClass().getName()}));
            }
        }

        public boolean isInitialized() {
            for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
                if (FieldSet.isInitialized(this.fields.getArrayEntryAt(i))) continue;
                return false;
            }
            for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
                if (FieldSet.isInitialized(entry)) continue;
                return false;
            }
            return true;
        }

        public void mergeFrom(FieldSet<T> other) {
            this.ensureIsMutable();
            for (int i = 0; i < ((FieldSet)other).fields.getNumArrayEntries(); ++i) {
                this.mergeFromField(((FieldSet)other).fields.getArrayEntryAt(i));
            }
            for (Map.Entry entry : ((FieldSet)other).fields.getOverflowEntries()) {
                this.mergeFromField(entry);
            }
        }

        private void mergeFromField(Map.Entry<T, Object> entry) {
            FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
            Object otherValue = entry.getValue();
            if (otherValue instanceof LazyField) {
                otherValue = ((LazyField)otherValue).getValue();
            }
            if (descriptor.isRepeated()) {
                ArrayList value2 = this.getField(descriptor);
                if (value2 == null) {
                    value2 = new ArrayList();
                }
                for (Object element : (List)otherValue) {
                    ((List)value2).add(FieldSet.cloneIfMutable(element));
                }
                this.fields.put((T)descriptor, (Object)value2);
            } else if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
                Object value3 = this.getField(descriptor);
                if (value3 == null) {
                    this.fields.put((T)descriptor, FieldSet.cloneIfMutable(otherValue));
                } else if (value3 instanceof MessageLite.Builder) {
                    descriptor.internalMergeFrom((MessageLite.Builder)value3, (MessageLite)otherValue);
                } else {
                    value3 = descriptor.internalMergeFrom(((MessageLite)value3).toBuilder(), (MessageLite)otherValue).build();
                    this.fields.put((T)descriptor, value3);
                }
            } else {
                this.fields.put((T)descriptor, FieldSet.cloneIfMutable(otherValue));
            }
        }
    }

    public static interface FieldDescriptorLite<T extends FieldDescriptorLite<T>>
    extends Comparable<T> {
        public int getNumber();

        public WireFormat.FieldType getLiteType();

        public WireFormat.JavaType getLiteJavaType();

        public boolean isRepeated();

        public boolean isPacked();

        public Internal.EnumLiteMap<?> getEnumType();

        public MessageLite.Builder internalMergeFrom(MessageLite.Builder var1, MessageLite var2);
    }
}

