/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.shaded.protobuf_v_3_5_1;

import com.intel.analytics.shaded.protobuf_v_3_5_1.AbstractMessageLite;
import com.intel.analytics.shaded.protobuf_v_3_5_1.Android;
import com.intel.analytics.shaded.protobuf_v_3_5_1.ByteOutput;
import com.intel.analytics.shaded.protobuf_v_3_5_1.ByteString;
import com.intel.analytics.shaded.protobuf_v_3_5_1.CodedOutputStreamWriter;
import com.intel.analytics.shaded.protobuf_v_3_5_1.Internal;
import com.intel.analytics.shaded.protobuf_v_3_5_1.LazyFieldLite;
import com.intel.analytics.shaded.protobuf_v_3_5_1.MessageLite;
import com.intel.analytics.shaded.protobuf_v_3_5_1.Schema;
import com.intel.analytics.shaded.protobuf_v_3_5_1.UnsafeUtil;
import com.intel.analytics.shaded.protobuf_v_3_5_1.Utf8;
import com.intel.analytics.shaded.protobuf_v_3_5_1.WireFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CodedOutputStream
extends ByteOutput {
    private static final Logger logger = Logger.getLogger(CodedOutputStream.class.getName());
    private static final boolean HAS_UNSAFE_ARRAY_OPERATIONS = UnsafeUtil.hasUnsafeArrayOperations();
    CodedOutputStreamWriter wrapper;
    @Deprecated
    public static final int LITTLE_ENDIAN_32_SIZE = 4;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private boolean serializationDeterministic;

    static int computePreferredBufferSize(int dataLength) {
        if (dataLength > 4096) {
            return 4096;
        }
        return dataLength;
    }

    public static CodedOutputStream newInstance(OutputStream output) {
        return CodedOutputStream.newInstance(output, 4096);
    }

    public static CodedOutputStream newInstance(OutputStream output, int bufferSize) {
        return new OutputStreamEncoder(output, bufferSize);
    }

    public static CodedOutputStream newInstance(byte[] flatArray) {
        return CodedOutputStream.newInstance(flatArray, 0, flatArray.length);
    }

    public static CodedOutputStream newInstance(byte[] flatArray, int offset, int length) {
        return new ArrayEncoder(flatArray, offset, length);
    }

    public static CodedOutputStream newInstance(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            return new HeapNioEncoder(buffer);
        }
        if (buffer.isDirect() && !buffer.isReadOnly()) {
            return UnsafeDirectNioEncoder.isSupported() ? CodedOutputStream.newUnsafeInstance(buffer) : CodedOutputStream.newSafeInstance(buffer);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    static CodedOutputStream newUnsafeInstance(ByteBuffer buffer) {
        return new UnsafeDirectNioEncoder(buffer);
    }

    static CodedOutputStream newSafeInstance(ByteBuffer buffer) {
        return new SafeDirectNioEncoder(buffer);
    }

    public void useDeterministicSerialization() {
        this.serializationDeterministic = true;
    }

    boolean isSerializationDeterministic() {
        return this.serializationDeterministic;
    }

    @Deprecated
    public static CodedOutputStream newInstance(ByteBuffer byteBuffer, int unused2) {
        return CodedOutputStream.newInstance(byteBuffer);
    }

    static CodedOutputStream newInstance(ByteOutput byteOutput, int bufferSize) {
        if (bufferSize < 0) {
            throw new IllegalArgumentException("bufferSize must be positive");
        }
        return new ByteOutputEncoder(byteOutput, bufferSize);
    }

    private CodedOutputStream() {
    }

    public abstract void writeTag(int var1, int var2) throws IOException;

    public abstract void writeInt32(int var1, int var2) throws IOException;

    public abstract void writeUInt32(int var1, int var2) throws IOException;

    public final void writeSInt32(int fieldNumber, int value2) throws IOException {
        this.writeUInt32(fieldNumber, CodedOutputStream.encodeZigZag32(value2));
    }

    public abstract void writeFixed32(int var1, int var2) throws IOException;

    public final void writeSFixed32(int fieldNumber, int value2) throws IOException {
        this.writeFixed32(fieldNumber, value2);
    }

    public final void writeInt64(int fieldNumber, long value2) throws IOException {
        this.writeUInt64(fieldNumber, value2);
    }

    public abstract void writeUInt64(int var1, long var2) throws IOException;

    public final void writeSInt64(int fieldNumber, long value2) throws IOException {
        this.writeUInt64(fieldNumber, CodedOutputStream.encodeZigZag64(value2));
    }

    public abstract void writeFixed64(int var1, long var2) throws IOException;

    public final void writeSFixed64(int fieldNumber, long value2) throws IOException {
        this.writeFixed64(fieldNumber, value2);
    }

    public final void writeFloat(int fieldNumber, float value2) throws IOException {
        this.writeFixed32(fieldNumber, Float.floatToRawIntBits(value2));
    }

    public final void writeDouble(int fieldNumber, double value2) throws IOException {
        this.writeFixed64(fieldNumber, Double.doubleToRawLongBits(value2));
    }

    public abstract void writeBool(int var1, boolean var2) throws IOException;

    public final void writeEnum(int fieldNumber, int value2) throws IOException {
        this.writeInt32(fieldNumber, value2);
    }

    public abstract void writeString(int var1, String var2) throws IOException;

    public abstract void writeBytes(int var1, ByteString var2) throws IOException;

    public abstract void writeByteArray(int var1, byte[] var2) throws IOException;

    public abstract void writeByteArray(int var1, byte[] var2, int var3, int var4) throws IOException;

    public abstract void writeByteBuffer(int var1, ByteBuffer var2) throws IOException;

    public final void writeRawByte(byte value2) throws IOException {
        this.write(value2);
    }

    public final void writeRawByte(int value2) throws IOException {
        this.write((byte)value2);
    }

    public final void writeRawBytes(byte[] value2) throws IOException {
        this.write(value2, 0, value2.length);
    }

    public final void writeRawBytes(byte[] value2, int offset, int length) throws IOException {
        this.write(value2, offset, length);
    }

    public final void writeRawBytes(ByteString value2) throws IOException {
        value2.writeTo(this);
    }

    public abstract void writeRawBytes(ByteBuffer var1) throws IOException;

    public abstract void writeMessage(int var1, MessageLite var2) throws IOException;

    abstract void writeMessage(int var1, MessageLite var2, Schema var3) throws IOException;

    public abstract void writeMessageSetExtension(int var1, MessageLite var2) throws IOException;

    public abstract void writeRawMessageSetExtension(int var1, ByteString var2) throws IOException;

    public abstract void writeInt32NoTag(int var1) throws IOException;

    public abstract void writeUInt32NoTag(int var1) throws IOException;

    public final void writeSInt32NoTag(int value2) throws IOException {
        this.writeUInt32NoTag(CodedOutputStream.encodeZigZag32(value2));
    }

    public abstract void writeFixed32NoTag(int var1) throws IOException;

    public final void writeSFixed32NoTag(int value2) throws IOException {
        this.writeFixed32NoTag(value2);
    }

    public final void writeInt64NoTag(long value2) throws IOException {
        this.writeUInt64NoTag(value2);
    }

    public abstract void writeUInt64NoTag(long var1) throws IOException;

    public final void writeSInt64NoTag(long value2) throws IOException {
        this.writeUInt64NoTag(CodedOutputStream.encodeZigZag64(value2));
    }

    public abstract void writeFixed64NoTag(long var1) throws IOException;

    public final void writeSFixed64NoTag(long value2) throws IOException {
        this.writeFixed64NoTag(value2);
    }

    public final void writeFloatNoTag(float value2) throws IOException {
        this.writeFixed32NoTag(Float.floatToRawIntBits(value2));
    }

    public final void writeDoubleNoTag(double value2) throws IOException {
        this.writeFixed64NoTag(Double.doubleToRawLongBits(value2));
    }

    public final void writeBoolNoTag(boolean value2) throws IOException {
        this.write((byte)(value2 ? 1 : 0));
    }

    public final void writeEnumNoTag(int value2) throws IOException {
        this.writeInt32NoTag(value2);
    }

    public abstract void writeStringNoTag(String var1) throws IOException;

    public abstract void writeBytesNoTag(ByteString var1) throws IOException;

    public final void writeByteArrayNoTag(byte[] value2) throws IOException {
        this.writeByteArrayNoTag(value2, 0, value2.length);
    }

    public abstract void writeMessageNoTag(MessageLite var1) throws IOException;

    abstract void writeMessageNoTag(MessageLite var1, Schema var2) throws IOException;

    @Override
    public abstract void write(byte var1) throws IOException;

    @Override
    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract void writeLazy(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract void write(ByteBuffer var1) throws IOException;

    @Override
    public abstract void writeLazy(ByteBuffer var1) throws IOException;

    public static int computeInt32Size(int fieldNumber, int value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeInt32SizeNoTag(value2);
    }

    public static int computeUInt32Size(int fieldNumber, int value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeUInt32SizeNoTag(value2);
    }

    public static int computeSInt32Size(int fieldNumber, int value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeSInt32SizeNoTag(value2);
    }

    public static int computeFixed32Size(int fieldNumber, int value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeFixed32SizeNoTag(value2);
    }

    public static int computeSFixed32Size(int fieldNumber, int value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeSFixed32SizeNoTag(value2);
    }

    public static int computeInt64Size(int fieldNumber, long value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeInt64SizeNoTag(value2);
    }

    public static int computeUInt64Size(int fieldNumber, long value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeUInt64SizeNoTag(value2);
    }

    public static int computeSInt64Size(int fieldNumber, long value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeSInt64SizeNoTag(value2);
    }

    public static int computeFixed64Size(int fieldNumber, long value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeFixed64SizeNoTag(value2);
    }

    public static int computeSFixed64Size(int fieldNumber, long value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeSFixed64SizeNoTag(value2);
    }

    public static int computeFloatSize(int fieldNumber, float value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeFloatSizeNoTag(value2);
    }

    public static int computeDoubleSize(int fieldNumber, double value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeDoubleSizeNoTag(value2);
    }

    public static int computeBoolSize(int fieldNumber, boolean value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeBoolSizeNoTag(value2);
    }

    public static int computeEnumSize(int fieldNumber, int value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeEnumSizeNoTag(value2);
    }

    public static int computeStringSize(int fieldNumber, String value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeStringSizeNoTag(value2);
    }

    public static int computeBytesSize(int fieldNumber, ByteString value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeBytesSizeNoTag(value2);
    }

    public static int computeByteArraySize(int fieldNumber, byte[] value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeByteArraySizeNoTag(value2);
    }

    public static int computeByteBufferSize(int fieldNumber, ByteBuffer value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeByteBufferSizeNoTag(value2);
    }

    public static int computeLazyFieldSize(int fieldNumber, LazyFieldLite value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLazyFieldSizeNoTag(value2);
    }

    public static int computeMessageSize(int fieldNumber, MessageLite value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeMessageSizeNoTag(value2);
    }

    static int computeMessageSize(int fieldNumber, MessageLite value2, Schema schema) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeMessageSizeNoTag(value2, schema);
    }

    public static int computeMessageSetExtensionSize(int fieldNumber, MessageLite value2) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, fieldNumber) + CodedOutputStream.computeMessageSize(3, value2);
    }

    public static int computeRawMessageSetExtensionSize(int fieldNumber, ByteString value2) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, fieldNumber) + CodedOutputStream.computeBytesSize(3, value2);
    }

    public static int computeLazyFieldMessageSetExtensionSize(int fieldNumber, LazyFieldLite value2) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, fieldNumber) + CodedOutputStream.computeLazyFieldSize(3, value2);
    }

    public static int computeTagSize(int fieldNumber) {
        return CodedOutputStream.computeUInt32SizeNoTag(WireFormat.makeTag(fieldNumber, 0));
    }

    public static int computeInt32SizeNoTag(int value2) {
        if (value2 >= 0) {
            return CodedOutputStream.computeUInt32SizeNoTag(value2);
        }
        return 10;
    }

    public static int computeUInt32SizeNoTag(int value2) {
        if ((value2 & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value2 & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value2 & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value2 & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int computeSInt32SizeNoTag(int value2) {
        return CodedOutputStream.computeUInt32SizeNoTag(CodedOutputStream.encodeZigZag32(value2));
    }

    public static int computeFixed32SizeNoTag(int unused2) {
        return 4;
    }

    public static int computeSFixed32SizeNoTag(int unused2) {
        return 4;
    }

    public static int computeInt64SizeNoTag(long value2) {
        return CodedOutputStream.computeUInt64SizeNoTag(value2);
    }

    public static int computeUInt64SizeNoTag(long value2) {
        if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (value2 < 0L) {
            return 10;
        }
        int n = 2;
        if ((value2 & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            value2 >>>= 28;
        }
        if ((value2 & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            value2 >>>= 14;
        }
        if ((value2 & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int computeSInt64SizeNoTag(long value2) {
        return CodedOutputStream.computeUInt64SizeNoTag(CodedOutputStream.encodeZigZag64(value2));
    }

    public static int computeFixed64SizeNoTag(long unused2) {
        return 8;
    }

    public static int computeSFixed64SizeNoTag(long unused2) {
        return 8;
    }

    public static int computeFloatSizeNoTag(float unused2) {
        return 4;
    }

    public static int computeDoubleSizeNoTag(double unused2) {
        return 8;
    }

    public static int computeBoolSizeNoTag(boolean unused2) {
        return 1;
    }

    public static int computeEnumSizeNoTag(int value2) {
        return CodedOutputStream.computeInt32SizeNoTag(value2);
    }

    public static int computeStringSizeNoTag(String value2) {
        int length;
        try {
            length = Utf8.encodedLength(value2);
        }
        catch (Utf8.UnpairedSurrogateException e) {
            byte[] bytes = value2.getBytes(Internal.UTF_8);
            length = bytes.length;
        }
        return CodedOutputStream.computeLengthDelimitedFieldSize(length);
    }

    public static int computeLazyFieldSizeNoTag(LazyFieldLite value2) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(value2.getSerializedSize());
    }

    public static int computeBytesSizeNoTag(ByteString value2) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(value2.size());
    }

    public static int computeByteArraySizeNoTag(byte[] value2) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(value2.length);
    }

    public static int computeByteBufferSizeNoTag(ByteBuffer value2) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(value2.capacity());
    }

    public static int computeMessageSizeNoTag(MessageLite value2) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(value2.getSerializedSize());
    }

    static int computeMessageSizeNoTag(MessageLite value2, Schema schema) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(((AbstractMessageLite)value2).getSerializedSize(schema));
    }

    static int computeLengthDelimitedFieldSize(int fieldLength) {
        return CodedOutputStream.computeUInt32SizeNoTag(fieldLength) + fieldLength;
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int spaceLeft();

    public final void checkNoSpaceLeft() {
        if (this.spaceLeft() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public abstract int getTotalBytesWritten();

    abstract void writeByteArrayNoTag(byte[] var1, int var2, int var3) throws IOException;

    final void inefficientWriteStringNoTag(String value2, Utf8.UnpairedSurrogateException cause) throws IOException {
        logger.log(Level.WARNING, "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", cause);
        byte[] bytes = value2.getBytes(Internal.UTF_8);
        try {
            this.writeUInt32NoTag(bytes.length);
            this.writeLazy(bytes, 0, bytes.length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new OutOfSpaceException(e);
        }
        catch (OutOfSpaceException e) {
            throw e;
        }
    }

    @Deprecated
    public final void writeGroup(int fieldNumber, MessageLite value2) throws IOException {
        this.writeTag(fieldNumber, 3);
        this.writeGroupNoTag(value2);
        this.writeTag(fieldNumber, 4);
    }

    @Deprecated
    final void writeGroup(int fieldNumber, MessageLite value2, Schema schema) throws IOException {
        this.writeTag(fieldNumber, 3);
        this.writeGroupNoTag(value2, schema);
        this.writeTag(fieldNumber, 4);
    }

    @Deprecated
    public final void writeGroupNoTag(MessageLite value2) throws IOException {
        value2.writeTo(this);
    }

    @Deprecated
    final void writeGroupNoTag(MessageLite value2, Schema schema) throws IOException {
        schema.writeTo(value2, this.wrapper);
    }

    @Deprecated
    public static int computeGroupSize(int fieldNumber, MessageLite value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) * 2 + CodedOutputStream.computeGroupSizeNoTag(value2);
    }

    @Deprecated
    static int computeGroupSize(int fieldNumber, MessageLite value2, Schema schema) {
        return CodedOutputStream.computeTagSize(fieldNumber) * 2 + CodedOutputStream.computeGroupSizeNoTag(value2, schema);
    }

    @Deprecated
    public static int computeGroupSizeNoTag(MessageLite value2) {
        return value2.getSerializedSize();
    }

    @Deprecated
    static int computeGroupSizeNoTag(MessageLite value2, Schema schema) {
        return ((AbstractMessageLite)value2).getSerializedSize(schema);
    }

    @Deprecated
    public final void writeRawVarint32(int value2) throws IOException {
        this.writeUInt32NoTag(value2);
    }

    @Deprecated
    public final void writeRawVarint64(long value2) throws IOException {
        this.writeUInt64NoTag(value2);
    }

    @Deprecated
    public static int computeRawVarint32Size(int value2) {
        return CodedOutputStream.computeUInt32SizeNoTag(value2);
    }

    @Deprecated
    public static int computeRawVarint64Size(long value2) {
        return CodedOutputStream.computeUInt64SizeNoTag(value2);
    }

    @Deprecated
    public final void writeRawLittleEndian32(int value2) throws IOException {
        this.writeFixed32NoTag(value2);
    }

    @Deprecated
    public final void writeRawLittleEndian64(long value2) throws IOException {
        this.writeFixed64NoTag(value2);
    }

    private static final class OutputStreamEncoder
    extends AbstractBufferedEncoder {
        private final OutputStream out;

        OutputStreamEncoder(OutputStream out, int bufferSize) {
            super(bufferSize);
            if (out == null) {
                throw new NullPointerException("out");
            }
            this.out = out;
        }

        @Override
        public void writeTag(int fieldNumber, int wireType) throws IOException {
            this.writeUInt32NoTag(WireFormat.makeTag(fieldNumber, wireType));
        }

        @Override
        public void writeInt32(int fieldNumber, int value2) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(fieldNumber, 0);
            this.bufferInt32NoTag(value2);
        }

        @Override
        public void writeUInt32(int fieldNumber, int value2) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(fieldNumber, 0);
            this.bufferUInt32NoTag(value2);
        }

        @Override
        public void writeFixed32(int fieldNumber, int value2) throws IOException {
            this.flushIfNotAvailable(14);
            this.bufferTag(fieldNumber, 5);
            this.bufferFixed32NoTag(value2);
        }

        @Override
        public void writeUInt64(int fieldNumber, long value2) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(fieldNumber, 0);
            this.bufferUInt64NoTag(value2);
        }

        @Override
        public void writeFixed64(int fieldNumber, long value2) throws IOException {
            this.flushIfNotAvailable(18);
            this.bufferTag(fieldNumber, 1);
            this.bufferFixed64NoTag(value2);
        }

        @Override
        public void writeBool(int fieldNumber, boolean value2) throws IOException {
            this.flushIfNotAvailable(11);
            this.bufferTag(fieldNumber, 0);
            this.buffer((byte)(value2 ? 1 : 0));
        }

        @Override
        public void writeString(int fieldNumber, String value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeStringNoTag(value2);
        }

        @Override
        public void writeBytes(int fieldNumber, ByteString value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeBytesNoTag(value2);
        }

        @Override
        public void writeByteArray(int fieldNumber, byte[] value2) throws IOException {
            this.writeByteArray(fieldNumber, value2, 0, value2.length);
        }

        @Override
        public void writeByteArray(int fieldNumber, byte[] value2, int offset, int length) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeByteArrayNoTag(value2, offset, length);
        }

        @Override
        public void writeByteBuffer(int fieldNumber, ByteBuffer value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeUInt32NoTag(value2.capacity());
            this.writeRawBytes(value2);
        }

        @Override
        public void writeBytesNoTag(ByteString value2) throws IOException {
            this.writeUInt32NoTag(value2.size());
            value2.writeTo(this);
        }

        @Override
        public void writeByteArrayNoTag(byte[] value2, int offset, int length) throws IOException {
            this.writeUInt32NoTag(length);
            this.write(value2, offset, length);
        }

        @Override
        public void writeRawBytes(ByteBuffer value2) throws IOException {
            if (value2.hasArray()) {
                this.write(value2.array(), value2.arrayOffset(), value2.capacity());
            } else {
                ByteBuffer duplicated = value2.duplicate();
                duplicated.clear();
                this.write(duplicated);
            }
        }

        @Override
        public void writeMessage(int fieldNumber, MessageLite value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeMessageNoTag(value2);
        }

        @Override
        void writeMessage(int fieldNumber, MessageLite value2, Schema schema) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeMessageNoTag(value2, schema);
        }

        @Override
        public void writeMessageSetExtension(int fieldNumber, MessageLite value2) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, fieldNumber);
            this.writeMessage(3, value2);
            this.writeTag(1, 4);
        }

        @Override
        public void writeRawMessageSetExtension(int fieldNumber, ByteString value2) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, fieldNumber);
            this.writeBytes(3, value2);
            this.writeTag(1, 4);
        }

        @Override
        public void writeMessageNoTag(MessageLite value2) throws IOException {
            this.writeUInt32NoTag(value2.getSerializedSize());
            value2.writeTo(this);
        }

        @Override
        void writeMessageNoTag(MessageLite value2, Schema schema) throws IOException {
            this.writeUInt32NoTag(((AbstractMessageLite)value2).getSerializedSize(schema));
            schema.writeTo(value2, this.wrapper);
        }

        @Override
        public void write(byte value2) throws IOException {
            if (this.position == this.limit) {
                this.doFlush();
            }
            this.buffer(value2);
        }

        @Override
        public void writeInt32NoTag(int value2) throws IOException {
            if (value2 >= 0) {
                this.writeUInt32NoTag(value2);
            } else {
                this.writeUInt64NoTag(value2);
            }
        }

        @Override
        public void writeUInt32NoTag(int value2) throws IOException {
            this.flushIfNotAvailable(5);
            this.bufferUInt32NoTag(value2);
        }

        @Override
        public void writeFixed32NoTag(int value2) throws IOException {
            this.flushIfNotAvailable(4);
            this.bufferFixed32NoTag(value2);
        }

        @Override
        public void writeUInt64NoTag(long value2) throws IOException {
            this.flushIfNotAvailable(10);
            this.bufferUInt64NoTag(value2);
        }

        @Override
        public void writeFixed64NoTag(long value2) throws IOException {
            this.flushIfNotAvailable(8);
            this.bufferFixed64NoTag(value2);
        }

        @Override
        public void writeStringNoTag(String value2) throws IOException {
            try {
                int maxLength = value2.length() * 3;
                int maxLengthVarIntSize = OutputStreamEncoder.computeUInt32SizeNoTag(maxLength);
                if (maxLengthVarIntSize + maxLength > this.limit) {
                    byte[] encodedBytes = new byte[maxLength];
                    int actualLength = Utf8.encode(value2, encodedBytes, 0, maxLength);
                    this.writeUInt32NoTag(actualLength);
                    this.writeLazy(encodedBytes, 0, actualLength);
                    return;
                }
                if (maxLengthVarIntSize + maxLength > this.limit - this.position) {
                    this.doFlush();
                }
                int minLengthVarIntSize = OutputStreamEncoder.computeUInt32SizeNoTag(value2.length());
                int oldPosition = this.position;
                try {
                    int length;
                    if (minLengthVarIntSize == maxLengthVarIntSize) {
                        this.position = oldPosition + minLengthVarIntSize;
                        int newPosition = Utf8.encode(value2, this.buffer, this.position, this.limit - this.position);
                        this.position = oldPosition;
                        length = newPosition - oldPosition - minLengthVarIntSize;
                        this.bufferUInt32NoTag(length);
                        this.position = newPosition;
                    } else {
                        length = Utf8.encodedLength(value2);
                        this.bufferUInt32NoTag(length);
                        this.position = Utf8.encode(value2, this.buffer, this.position, length);
                    }
                    this.totalBytesWritten += length;
                }
                catch (Utf8.UnpairedSurrogateException e) {
                    this.totalBytesWritten -= this.position - oldPosition;
                    this.position = oldPosition;
                    throw e;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new OutOfSpaceException(e);
                }
            }
            catch (Utf8.UnpairedSurrogateException e) {
                this.inefficientWriteStringNoTag(value2, e);
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.position > 0) {
                this.doFlush();
            }
        }

        @Override
        public void write(byte[] value2, int offset, int length) throws IOException {
            if (this.limit - this.position >= length) {
                System.arraycopy(value2, offset, this.buffer, this.position, length);
                this.position += length;
                this.totalBytesWritten += length;
            } else {
                int bytesWritten = this.limit - this.position;
                System.arraycopy(value2, offset, this.buffer, this.position, bytesWritten);
                offset += bytesWritten;
                this.position = this.limit;
                this.totalBytesWritten += bytesWritten;
                this.doFlush();
                if ((length -= bytesWritten) <= this.limit) {
                    System.arraycopy(value2, offset, this.buffer, 0, length);
                    this.position = length;
                } else {
                    this.out.write(value2, offset, length);
                }
                this.totalBytesWritten += length;
            }
        }

        @Override
        public void writeLazy(byte[] value2, int offset, int length) throws IOException {
            this.write(value2, offset, length);
        }

        @Override
        public void write(ByteBuffer value2) throws IOException {
            int length = value2.remaining();
            if (this.limit - this.position >= length) {
                value2.get(this.buffer, this.position, length);
                this.position += length;
                this.totalBytesWritten += length;
            } else {
                int bytesWritten = this.limit - this.position;
                value2.get(this.buffer, this.position, bytesWritten);
                length -= bytesWritten;
                this.position = this.limit;
                this.totalBytesWritten += bytesWritten;
                this.doFlush();
                while (length > this.limit) {
                    value2.get(this.buffer, 0, this.limit);
                    this.out.write(this.buffer, 0, this.limit);
                    length -= this.limit;
                    this.totalBytesWritten += this.limit;
                }
                value2.get(this.buffer, 0, length);
                this.position = length;
                this.totalBytesWritten += length;
            }
        }

        @Override
        public void writeLazy(ByteBuffer value2) throws IOException {
            this.write(value2);
        }

        private void flushIfNotAvailable(int requiredSize) throws IOException {
            if (this.limit - this.position < requiredSize) {
                this.doFlush();
            }
        }

        private void doFlush() throws IOException {
            this.out.write(this.buffer, 0, this.position);
            this.position = 0;
        }
    }

    private static final class ByteOutputEncoder
    extends AbstractBufferedEncoder {
        private final ByteOutput out;

        ByteOutputEncoder(ByteOutput out, int bufferSize) {
            super(bufferSize);
            if (out == null) {
                throw new NullPointerException("out");
            }
            this.out = out;
        }

        @Override
        public void writeTag(int fieldNumber, int wireType) throws IOException {
            this.writeUInt32NoTag(WireFormat.makeTag(fieldNumber, wireType));
        }

        @Override
        public void writeInt32(int fieldNumber, int value2) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(fieldNumber, 0);
            this.bufferInt32NoTag(value2);
        }

        @Override
        public void writeUInt32(int fieldNumber, int value2) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(fieldNumber, 0);
            this.bufferUInt32NoTag(value2);
        }

        @Override
        public void writeFixed32(int fieldNumber, int value2) throws IOException {
            this.flushIfNotAvailable(14);
            this.bufferTag(fieldNumber, 5);
            this.bufferFixed32NoTag(value2);
        }

        @Override
        public void writeUInt64(int fieldNumber, long value2) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(fieldNumber, 0);
            this.bufferUInt64NoTag(value2);
        }

        @Override
        public void writeFixed64(int fieldNumber, long value2) throws IOException {
            this.flushIfNotAvailable(18);
            this.bufferTag(fieldNumber, 1);
            this.bufferFixed64NoTag(value2);
        }

        @Override
        public void writeBool(int fieldNumber, boolean value2) throws IOException {
            this.flushIfNotAvailable(11);
            this.bufferTag(fieldNumber, 0);
            this.buffer((byte)(value2 ? 1 : 0));
        }

        @Override
        public void writeString(int fieldNumber, String value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeStringNoTag(value2);
        }

        @Override
        public void writeBytes(int fieldNumber, ByteString value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeBytesNoTag(value2);
        }

        @Override
        public void writeByteArray(int fieldNumber, byte[] value2) throws IOException {
            this.writeByteArray(fieldNumber, value2, 0, value2.length);
        }

        @Override
        public void writeByteArray(int fieldNumber, byte[] value2, int offset, int length) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeByteArrayNoTag(value2, offset, length);
        }

        @Override
        public void writeByteBuffer(int fieldNumber, ByteBuffer value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeUInt32NoTag(value2.capacity());
            this.writeRawBytes(value2);
        }

        @Override
        public void writeBytesNoTag(ByteString value2) throws IOException {
            this.writeUInt32NoTag(value2.size());
            value2.writeTo(this);
        }

        @Override
        public void writeByteArrayNoTag(byte[] value2, int offset, int length) throws IOException {
            this.writeUInt32NoTag(length);
            this.write(value2, offset, length);
        }

        @Override
        public void writeRawBytes(ByteBuffer value2) throws IOException {
            if (value2.hasArray()) {
                this.write(value2.array(), value2.arrayOffset(), value2.capacity());
            } else {
                ByteBuffer duplicated = value2.duplicate();
                duplicated.clear();
                this.write(duplicated);
            }
        }

        @Override
        public void writeMessage(int fieldNumber, MessageLite value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeMessageNoTag(value2);
        }

        @Override
        void writeMessage(int fieldNumber, MessageLite value2, Schema schema) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeMessageNoTag(value2, schema);
        }

        @Override
        public void writeMessageSetExtension(int fieldNumber, MessageLite value2) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, fieldNumber);
            this.writeMessage(3, value2);
            this.writeTag(1, 4);
        }

        @Override
        public void writeRawMessageSetExtension(int fieldNumber, ByteString value2) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, fieldNumber);
            this.writeBytes(3, value2);
            this.writeTag(1, 4);
        }

        @Override
        public void writeMessageNoTag(MessageLite value2) throws IOException {
            this.writeUInt32NoTag(value2.getSerializedSize());
            value2.writeTo(this);
        }

        @Override
        void writeMessageNoTag(MessageLite value2, Schema schema) throws IOException {
            this.writeUInt32NoTag(((AbstractMessageLite)value2).getSerializedSize(schema));
            schema.writeTo(value2, this.wrapper);
        }

        @Override
        public void write(byte value2) throws IOException {
            if (this.position == this.limit) {
                this.doFlush();
            }
            this.buffer(value2);
        }

        @Override
        public void writeInt32NoTag(int value2) throws IOException {
            if (value2 >= 0) {
                this.writeUInt32NoTag(value2);
            } else {
                this.writeUInt64NoTag(value2);
            }
        }

        @Override
        public void writeUInt32NoTag(int value2) throws IOException {
            this.flushIfNotAvailable(5);
            this.bufferUInt32NoTag(value2);
        }

        @Override
        public void writeFixed32NoTag(int value2) throws IOException {
            this.flushIfNotAvailable(4);
            this.bufferFixed32NoTag(value2);
        }

        @Override
        public void writeUInt64NoTag(long value2) throws IOException {
            this.flushIfNotAvailable(10);
            this.bufferUInt64NoTag(value2);
        }

        @Override
        public void writeFixed64NoTag(long value2) throws IOException {
            this.flushIfNotAvailable(8);
            this.bufferFixed64NoTag(value2);
        }

        @Override
        public void writeStringNoTag(String value2) throws IOException {
            int maxLength = value2.length() * 3;
            int maxLengthVarIntSize = ByteOutputEncoder.computeUInt32SizeNoTag(maxLength);
            if (maxLengthVarIntSize + maxLength > this.limit) {
                byte[] encodedBytes = new byte[maxLength];
                int actualLength = Utf8.encode(value2, encodedBytes, 0, maxLength);
                this.writeUInt32NoTag(actualLength);
                this.writeLazy(encodedBytes, 0, actualLength);
                return;
            }
            if (maxLengthVarIntSize + maxLength > this.limit - this.position) {
                this.doFlush();
            }
            int oldPosition = this.position;
            try {
                int minLengthVarIntSize = ByteOutputEncoder.computeUInt32SizeNoTag(value2.length());
                if (minLengthVarIntSize == maxLengthVarIntSize) {
                    this.position = oldPosition + minLengthVarIntSize;
                    int newPosition = Utf8.encode(value2, this.buffer, this.position, this.limit - this.position);
                    this.position = oldPosition;
                    int length = newPosition - oldPosition - minLengthVarIntSize;
                    this.bufferUInt32NoTag(length);
                    this.position = newPosition;
                    this.totalBytesWritten += length;
                } else {
                    int length = Utf8.encodedLength(value2);
                    this.bufferUInt32NoTag(length);
                    this.position = Utf8.encode(value2, this.buffer, this.position, length);
                    this.totalBytesWritten += length;
                }
            }
            catch (Utf8.UnpairedSurrogateException e) {
                this.totalBytesWritten -= this.position - oldPosition;
                this.position = oldPosition;
                this.inefficientWriteStringNoTag(value2, e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(e);
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.position > 0) {
                this.doFlush();
            }
        }

        @Override
        public void write(byte[] value2, int offset, int length) throws IOException {
            this.flush();
            this.out.write(value2, offset, length);
            this.totalBytesWritten += length;
        }

        @Override
        public void writeLazy(byte[] value2, int offset, int length) throws IOException {
            this.flush();
            this.out.writeLazy(value2, offset, length);
            this.totalBytesWritten += length;
        }

        @Override
        public void write(ByteBuffer value2) throws IOException {
            this.flush();
            int length = value2.remaining();
            this.out.write(value2);
            this.totalBytesWritten += length;
        }

        @Override
        public void writeLazy(ByteBuffer value2) throws IOException {
            this.flush();
            int length = value2.remaining();
            this.out.writeLazy(value2);
            this.totalBytesWritten += length;
        }

        private void flushIfNotAvailable(int requiredSize) throws IOException {
            if (this.limit - this.position < requiredSize) {
                this.doFlush();
            }
        }

        private void doFlush() throws IOException {
            this.out.write(this.buffer, 0, this.position);
            this.position = 0;
        }
    }

    private static abstract class AbstractBufferedEncoder
    extends CodedOutputStream {
        final byte[] buffer;
        final int limit;
        int position;
        int totalBytesWritten;

        AbstractBufferedEncoder(int bufferSize) {
            if (bufferSize < 0) {
                throw new IllegalArgumentException("bufferSize must be >= 0");
            }
            this.buffer = new byte[Math.max(bufferSize, 20)];
            this.limit = this.buffer.length;
        }

        @Override
        public final int spaceLeft() {
            throw new UnsupportedOperationException("spaceLeft() can only be called on CodedOutputStreams that are writing to a flat array or ByteBuffer.");
        }

        @Override
        public final int getTotalBytesWritten() {
            return this.totalBytesWritten;
        }

        final void buffer(byte value2) {
            this.buffer[this.position++] = value2;
            ++this.totalBytesWritten;
        }

        final void bufferTag(int fieldNumber, int wireType) {
            this.bufferUInt32NoTag(WireFormat.makeTag(fieldNumber, wireType));
        }

        final void bufferInt32NoTag(int value2) {
            if (value2 >= 0) {
                this.bufferUInt32NoTag(value2);
            } else {
                this.bufferUInt64NoTag(value2);
            }
        }

        final void bufferUInt32NoTag(int value2) {
            if (HAS_UNSAFE_ARRAY_OPERATIONS) {
                long originalPos = this.position;
                while (true) {
                    if ((value2 & 0xFFFFFF80) == 0) break;
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(value2 & 0x7F | 0x80));
                    value2 >>>= 7;
                }
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)value2);
                int delta = (int)((long)this.position - originalPos);
                this.totalBytesWritten += delta;
            } else {
                while (true) {
                    if ((value2 & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)value2;
                        ++this.totalBytesWritten;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(value2 & 0x7F | 0x80);
                    ++this.totalBytesWritten;
                    value2 >>>= 7;
                }
            }
        }

        final void bufferUInt64NoTag(long value2) {
            if (HAS_UNSAFE_ARRAY_OPERATIONS) {
                long originalPos = this.position;
                while (true) {
                    if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) break;
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)((int)value2 & 0x7F | 0x80));
                    value2 >>>= 7;
                }
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)value2);
                int delta = (int)((long)this.position - originalPos);
                this.totalBytesWritten += delta;
            } else {
                while (true) {
                    if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)value2;
                        ++this.totalBytesWritten;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)value2 & 0x7F | 0x80);
                    ++this.totalBytesWritten;
                    value2 >>>= 7;
                }
            }
        }

        final void bufferFixed32NoTag(int value2) {
            this.buffer[this.position++] = (byte)(value2 & 0xFF);
            this.buffer[this.position++] = (byte)(value2 >> 8 & 0xFF);
            this.buffer[this.position++] = (byte)(value2 >> 16 & 0xFF);
            this.buffer[this.position++] = (byte)(value2 >> 24 & 0xFF);
            this.totalBytesWritten += 4;
        }

        final void bufferFixed64NoTag(long value2) {
            this.buffer[this.position++] = (byte)(value2 & 0xFFL);
            this.buffer[this.position++] = (byte)(value2 >> 8 & 0xFFL);
            this.buffer[this.position++] = (byte)(value2 >> 16 & 0xFFL);
            this.buffer[this.position++] = (byte)(value2 >> 24 & 0xFFL);
            this.buffer[this.position++] = (byte)((int)(value2 >> 32) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(value2 >> 40) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(value2 >> 48) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(value2 >> 56) & 0xFF);
            this.totalBytesWritten += 8;
        }
    }

    private static final class UnsafeDirectNioEncoder
    extends CodedOutputStream {
        private final ByteBuffer originalBuffer;
        private final ByteBuffer buffer;
        private final long address;
        private final long initialPosition;
        private final long limit;
        private final long oneVarintLimit;
        private long position;

        UnsafeDirectNioEncoder(ByteBuffer buffer) {
            this.originalBuffer = buffer;
            this.buffer = buffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.address = UnsafeUtil.addressOffset(buffer);
            this.initialPosition = this.address + (long)buffer.position();
            this.limit = this.address + (long)buffer.limit();
            this.oneVarintLimit = this.limit - 10L;
            this.position = this.initialPosition;
        }

        static boolean isSupported() {
            return UnsafeUtil.hasUnsafeByteBufferOperations();
        }

        @Override
        public void writeTag(int fieldNumber, int wireType) throws IOException {
            this.writeUInt32NoTag(WireFormat.makeTag(fieldNumber, wireType));
        }

        @Override
        public void writeInt32(int fieldNumber, int value2) throws IOException {
            this.writeTag(fieldNumber, 0);
            this.writeInt32NoTag(value2);
        }

        @Override
        public void writeUInt32(int fieldNumber, int value2) throws IOException {
            this.writeTag(fieldNumber, 0);
            this.writeUInt32NoTag(value2);
        }

        @Override
        public void writeFixed32(int fieldNumber, int value2) throws IOException {
            this.writeTag(fieldNumber, 5);
            this.writeFixed32NoTag(value2);
        }

        @Override
        public void writeUInt64(int fieldNumber, long value2) throws IOException {
            this.writeTag(fieldNumber, 0);
            this.writeUInt64NoTag(value2);
        }

        @Override
        public void writeFixed64(int fieldNumber, long value2) throws IOException {
            this.writeTag(fieldNumber, 1);
            this.writeFixed64NoTag(value2);
        }

        @Override
        public void writeBool(int fieldNumber, boolean value2) throws IOException {
            this.writeTag(fieldNumber, 0);
            this.write((byte)(value2 ? 1 : 0));
        }

        @Override
        public void writeString(int fieldNumber, String value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeStringNoTag(value2);
        }

        @Override
        public void writeBytes(int fieldNumber, ByteString value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeBytesNoTag(value2);
        }

        @Override
        public void writeByteArray(int fieldNumber, byte[] value2) throws IOException {
            this.writeByteArray(fieldNumber, value2, 0, value2.length);
        }

        @Override
        public void writeByteArray(int fieldNumber, byte[] value2, int offset, int length) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeByteArrayNoTag(value2, offset, length);
        }

        @Override
        public void writeByteBuffer(int fieldNumber, ByteBuffer value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeUInt32NoTag(value2.capacity());
            this.writeRawBytes(value2);
        }

        @Override
        public void writeMessage(int fieldNumber, MessageLite value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeMessageNoTag(value2);
        }

        @Override
        void writeMessage(int fieldNumber, MessageLite value2, Schema schema) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeMessageNoTag(value2, schema);
        }

        @Override
        public void writeMessageSetExtension(int fieldNumber, MessageLite value2) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, fieldNumber);
            this.writeMessage(3, value2);
            this.writeTag(1, 4);
        }

        @Override
        public void writeRawMessageSetExtension(int fieldNumber, ByteString value2) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, fieldNumber);
            this.writeBytes(3, value2);
            this.writeTag(1, 4);
        }

        @Override
        public void writeMessageNoTag(MessageLite value2) throws IOException {
            this.writeUInt32NoTag(value2.getSerializedSize());
            value2.writeTo(this);
        }

        @Override
        void writeMessageNoTag(MessageLite value2, Schema schema) throws IOException {
            this.writeUInt32NoTag(((AbstractMessageLite)value2).getSerializedSize(schema));
            schema.writeTo(value2, this.wrapper);
        }

        @Override
        public void write(byte value2) throws IOException {
            if (this.position >= this.limit) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1));
            }
            UnsafeUtil.putByte(this.position++, value2);
        }

        @Override
        public void writeBytesNoTag(ByteString value2) throws IOException {
            this.writeUInt32NoTag(value2.size());
            value2.writeTo(this);
        }

        @Override
        public void writeByteArrayNoTag(byte[] value2, int offset, int length) throws IOException {
            this.writeUInt32NoTag(length);
            this.write(value2, offset, length);
        }

        @Override
        public void writeRawBytes(ByteBuffer value2) throws IOException {
            if (value2.hasArray()) {
                this.write(value2.array(), value2.arrayOffset(), value2.capacity());
            } else {
                ByteBuffer duplicated = value2.duplicate();
                duplicated.clear();
                this.write(duplicated);
            }
        }

        @Override
        public void writeInt32NoTag(int value2) throws IOException {
            if (value2 >= 0) {
                this.writeUInt32NoTag(value2);
            } else {
                this.writeUInt64NoTag(value2);
            }
        }

        @Override
        public void writeUInt32NoTag(int value2) throws IOException {
            if (this.position <= this.oneVarintLimit) {
                while (true) {
                    if ((value2 & 0xFFFFFF80) == 0) {
                        UnsafeUtil.putByte(this.position++, (byte)value2);
                        return;
                    }
                    UnsafeUtil.putByte(this.position++, (byte)(value2 & 0x7F | 0x80));
                    value2 >>>= 7;
                }
            }
            while (this.position < this.limit) {
                if ((value2 & 0xFFFFFF80) == 0) {
                    UnsafeUtil.putByte(this.position++, (byte)value2);
                    return;
                }
                UnsafeUtil.putByte(this.position++, (byte)(value2 & 0x7F | 0x80));
                value2 >>>= 7;
            }
            throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1));
        }

        @Override
        public void writeFixed32NoTag(int value2) throws IOException {
            this.buffer.putInt(this.bufferPos(this.position), value2);
            this.position += 4L;
        }

        @Override
        public void writeUInt64NoTag(long value2) throws IOException {
            if (this.position <= this.oneVarintLimit) {
                while (true) {
                    if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        UnsafeUtil.putByte(this.position++, (byte)value2);
                        return;
                    }
                    UnsafeUtil.putByte(this.position++, (byte)((int)value2 & 0x7F | 0x80));
                    value2 >>>= 7;
                }
            }
            while (this.position < this.limit) {
                if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    UnsafeUtil.putByte(this.position++, (byte)value2);
                    return;
                }
                UnsafeUtil.putByte(this.position++, (byte)((int)value2 & 0x7F | 0x80));
                value2 >>>= 7;
            }
            throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1));
        }

        @Override
        public void writeFixed64NoTag(long value2) throws IOException {
            this.buffer.putLong(this.bufferPos(this.position), value2);
            this.position += 8L;
        }

        @Override
        public void write(byte[] value2, int offset, int length) throws IOException {
            if (value2 == null || offset < 0 || length < 0 || value2.length - length < offset || this.limit - (long)length < this.position) {
                if (value2 == null) {
                    throw new NullPointerException("value");
                }
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, length));
            }
            UnsafeUtil.copyMemory(value2, offset, this.position, (long)length);
            this.position += (long)length;
        }

        @Override
        public void writeLazy(byte[] value2, int offset, int length) throws IOException {
            this.write(value2, offset, length);
        }

        @Override
        public void write(ByteBuffer value2) throws IOException {
            try {
                int length = value2.remaining();
                this.repositionBuffer(this.position);
                this.buffer.put(value2);
                this.position += (long)length;
            }
            catch (BufferOverflowException e) {
                throw new OutOfSpaceException(e);
            }
        }

        @Override
        public void writeLazy(ByteBuffer value2) throws IOException {
            this.write(value2);
        }

        @Override
        public void writeStringNoTag(String value2) throws IOException {
            long prevPos = this.position;
            try {
                int maxEncodedSize = value2.length() * 3;
                int maxLengthVarIntSize = UnsafeDirectNioEncoder.computeUInt32SizeNoTag(maxEncodedSize);
                int minLengthVarIntSize = UnsafeDirectNioEncoder.computeUInt32SizeNoTag(value2.length());
                if (minLengthVarIntSize == maxLengthVarIntSize) {
                    int stringStart = this.bufferPos(this.position) + minLengthVarIntSize;
                    this.buffer.position(stringStart);
                    Utf8.encodeUtf8(value2, this.buffer);
                    int length = this.buffer.position() - stringStart;
                    this.writeUInt32NoTag(length);
                    this.position += (long)length;
                } else {
                    int length = Utf8.encodedLength(value2);
                    this.writeUInt32NoTag(length);
                    this.repositionBuffer(this.position);
                    Utf8.encodeUtf8(value2, this.buffer);
                    this.position += (long)length;
                }
            }
            catch (Utf8.UnpairedSurrogateException e) {
                this.position = prevPos;
                this.repositionBuffer(this.position);
                this.inefficientWriteStringNoTag(value2, e);
            }
            catch (IllegalArgumentException e) {
                throw new OutOfSpaceException(e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(e);
            }
        }

        @Override
        public void flush() {
            this.originalBuffer.position(this.bufferPos(this.position));
        }

        @Override
        public int spaceLeft() {
            return (int)(this.limit - this.position);
        }

        @Override
        public int getTotalBytesWritten() {
            return (int)(this.position - this.initialPosition);
        }

        private void repositionBuffer(long pos) {
            this.buffer.position(this.bufferPos(pos));
        }

        private int bufferPos(long pos) {
            return (int)(pos - this.address);
        }
    }

    private static final class SafeDirectNioEncoder
    extends CodedOutputStream {
        private final ByteBuffer originalBuffer;
        private final ByteBuffer buffer;
        private final int initialPosition;

        SafeDirectNioEncoder(ByteBuffer buffer) {
            this.originalBuffer = buffer;
            this.buffer = buffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.initialPosition = buffer.position();
        }

        @Override
        public void writeTag(int fieldNumber, int wireType) throws IOException {
            this.writeUInt32NoTag(WireFormat.makeTag(fieldNumber, wireType));
        }

        @Override
        public void writeInt32(int fieldNumber, int value2) throws IOException {
            this.writeTag(fieldNumber, 0);
            this.writeInt32NoTag(value2);
        }

        @Override
        public void writeUInt32(int fieldNumber, int value2) throws IOException {
            this.writeTag(fieldNumber, 0);
            this.writeUInt32NoTag(value2);
        }

        @Override
        public void writeFixed32(int fieldNumber, int value2) throws IOException {
            this.writeTag(fieldNumber, 5);
            this.writeFixed32NoTag(value2);
        }

        @Override
        public void writeUInt64(int fieldNumber, long value2) throws IOException {
            this.writeTag(fieldNumber, 0);
            this.writeUInt64NoTag(value2);
        }

        @Override
        public void writeFixed64(int fieldNumber, long value2) throws IOException {
            this.writeTag(fieldNumber, 1);
            this.writeFixed64NoTag(value2);
        }

        @Override
        public void writeBool(int fieldNumber, boolean value2) throws IOException {
            this.writeTag(fieldNumber, 0);
            this.write((byte)(value2 ? 1 : 0));
        }

        @Override
        public void writeString(int fieldNumber, String value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeStringNoTag(value2);
        }

        @Override
        public void writeBytes(int fieldNumber, ByteString value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeBytesNoTag(value2);
        }

        @Override
        public void writeByteArray(int fieldNumber, byte[] value2) throws IOException {
            this.writeByteArray(fieldNumber, value2, 0, value2.length);
        }

        @Override
        public void writeByteArray(int fieldNumber, byte[] value2, int offset, int length) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeByteArrayNoTag(value2, offset, length);
        }

        @Override
        public void writeByteBuffer(int fieldNumber, ByteBuffer value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeUInt32NoTag(value2.capacity());
            this.writeRawBytes(value2);
        }

        @Override
        public void writeMessage(int fieldNumber, MessageLite value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeMessageNoTag(value2);
        }

        @Override
        void writeMessage(int fieldNumber, MessageLite value2, Schema schema) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeMessageNoTag(value2, schema);
        }

        @Override
        public void writeMessageSetExtension(int fieldNumber, MessageLite value2) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, fieldNumber);
            this.writeMessage(3, value2);
            this.writeTag(1, 4);
        }

        @Override
        public void writeRawMessageSetExtension(int fieldNumber, ByteString value2) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, fieldNumber);
            this.writeBytes(3, value2);
            this.writeTag(1, 4);
        }

        @Override
        public void writeMessageNoTag(MessageLite value2) throws IOException {
            this.writeUInt32NoTag(value2.getSerializedSize());
            value2.writeTo(this);
        }

        @Override
        void writeMessageNoTag(MessageLite value2, Schema schema) throws IOException {
            this.writeUInt32NoTag(((AbstractMessageLite)value2).getSerializedSize(schema));
            schema.writeTo(value2, this.wrapper);
        }

        @Override
        public void write(byte value2) throws IOException {
            try {
                this.buffer.put(value2);
            }
            catch (BufferOverflowException e) {
                throw new OutOfSpaceException(e);
            }
        }

        @Override
        public void writeBytesNoTag(ByteString value2) throws IOException {
            this.writeUInt32NoTag(value2.size());
            value2.writeTo(this);
        }

        @Override
        public void writeByteArrayNoTag(byte[] value2, int offset, int length) throws IOException {
            this.writeUInt32NoTag(length);
            this.write(value2, offset, length);
        }

        @Override
        public void writeRawBytes(ByteBuffer value2) throws IOException {
            if (value2.hasArray()) {
                this.write(value2.array(), value2.arrayOffset(), value2.capacity());
            } else {
                ByteBuffer duplicated = value2.duplicate();
                duplicated.clear();
                this.write(duplicated);
            }
        }

        @Override
        public void writeInt32NoTag(int value2) throws IOException {
            if (value2 >= 0) {
                this.writeUInt32NoTag(value2);
            } else {
                this.writeUInt64NoTag(value2);
            }
        }

        @Override
        public void writeUInt32NoTag(int value2) throws IOException {
            try {
                while (true) {
                    if ((value2 & 0xFFFFFF80) == 0) {
                        this.buffer.put((byte)value2);
                        return;
                    }
                    this.buffer.put((byte)(value2 & 0x7F | 0x80));
                    value2 >>>= 7;
                }
            }
            catch (BufferOverflowException e) {
                throw new OutOfSpaceException(e);
            }
        }

        @Override
        public void writeFixed32NoTag(int value2) throws IOException {
            try {
                this.buffer.putInt(value2);
            }
            catch (BufferOverflowException e) {
                throw new OutOfSpaceException(e);
            }
        }

        @Override
        public void writeUInt64NoTag(long value2) throws IOException {
            try {
                while (true) {
                    if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer.put((byte)value2);
                        return;
                    }
                    this.buffer.put((byte)((int)value2 & 0x7F | 0x80));
                    value2 >>>= 7;
                }
            }
            catch (BufferOverflowException e) {
                throw new OutOfSpaceException(e);
            }
        }

        @Override
        public void writeFixed64NoTag(long value2) throws IOException {
            try {
                this.buffer.putLong(value2);
            }
            catch (BufferOverflowException e) {
                throw new OutOfSpaceException(e);
            }
        }

        @Override
        public void write(byte[] value2, int offset, int length) throws IOException {
            try {
                this.buffer.put(value2, offset, length);
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(e);
            }
            catch (BufferOverflowException e) {
                throw new OutOfSpaceException(e);
            }
        }

        @Override
        public void writeLazy(byte[] value2, int offset, int length) throws IOException {
            this.write(value2, offset, length);
        }

        @Override
        public void write(ByteBuffer value2) throws IOException {
            try {
                this.buffer.put(value2);
            }
            catch (BufferOverflowException e) {
                throw new OutOfSpaceException(e);
            }
        }

        @Override
        public void writeLazy(ByteBuffer value2) throws IOException {
            this.write(value2);
        }

        @Override
        public void writeStringNoTag(String value2) throws IOException {
            int startPos = this.buffer.position();
            try {
                int maxEncodedSize = value2.length() * 3;
                int maxLengthVarIntSize = SafeDirectNioEncoder.computeUInt32SizeNoTag(maxEncodedSize);
                int minLengthVarIntSize = SafeDirectNioEncoder.computeUInt32SizeNoTag(value2.length());
                if (minLengthVarIntSize == maxLengthVarIntSize) {
                    int startOfBytes = this.buffer.position() + minLengthVarIntSize;
                    this.buffer.position(startOfBytes);
                    this.encode(value2);
                    int endOfBytes = this.buffer.position();
                    this.buffer.position(startPos);
                    this.writeUInt32NoTag(endOfBytes - startOfBytes);
                    this.buffer.position(endOfBytes);
                } else {
                    int length = Utf8.encodedLength(value2);
                    this.writeUInt32NoTag(length);
                    this.encode(value2);
                }
            }
            catch (Utf8.UnpairedSurrogateException e) {
                this.buffer.position(startPos);
                this.inefficientWriteStringNoTag(value2, e);
            }
            catch (IllegalArgumentException e) {
                throw new OutOfSpaceException(e);
            }
        }

        @Override
        public void flush() {
            this.originalBuffer.position(this.buffer.position());
        }

        @Override
        public int spaceLeft() {
            return this.buffer.remaining();
        }

        @Override
        public int getTotalBytesWritten() {
            return this.buffer.position() - this.initialPosition;
        }

        private void encode(String value2) throws IOException {
            try {
                Utf8.encodeUtf8(value2, this.buffer);
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(e);
            }
        }
    }

    private static final class HeapNioEncoder
    extends ArrayEncoder {
        private final ByteBuffer byteBuffer;
        private int initialPosition;

        HeapNioEncoder(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.byteBuffer = byteBuffer;
            this.initialPosition = byteBuffer.position();
        }

        @Override
        public void flush() {
            this.byteBuffer.position(this.initialPosition + this.getTotalBytesWritten());
        }
    }

    private static class ArrayEncoder
    extends CodedOutputStream {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        ArrayEncoder(byte[] buffer, int offset, int length) {
            if (buffer == null) {
                throw new NullPointerException("buffer");
            }
            if ((offset | length | buffer.length - (offset + length)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", buffer.length, offset, length));
            }
            this.buffer = buffer;
            this.offset = offset;
            this.position = offset;
            this.limit = offset + length;
        }

        @Override
        public final void writeTag(int fieldNumber, int wireType) throws IOException {
            this.writeUInt32NoTag(WireFormat.makeTag(fieldNumber, wireType));
        }

        @Override
        public final void writeInt32(int fieldNumber, int value2) throws IOException {
            this.writeTag(fieldNumber, 0);
            this.writeInt32NoTag(value2);
        }

        @Override
        public final void writeUInt32(int fieldNumber, int value2) throws IOException {
            this.writeTag(fieldNumber, 0);
            this.writeUInt32NoTag(value2);
        }

        @Override
        public final void writeFixed32(int fieldNumber, int value2) throws IOException {
            this.writeTag(fieldNumber, 5);
            this.writeFixed32NoTag(value2);
        }

        @Override
        public final void writeUInt64(int fieldNumber, long value2) throws IOException {
            this.writeTag(fieldNumber, 0);
            this.writeUInt64NoTag(value2);
        }

        @Override
        public final void writeFixed64(int fieldNumber, long value2) throws IOException {
            this.writeTag(fieldNumber, 1);
            this.writeFixed64NoTag(value2);
        }

        @Override
        public final void writeBool(int fieldNumber, boolean value2) throws IOException {
            this.writeTag(fieldNumber, 0);
            this.write((byte)(value2 ? 1 : 0));
        }

        @Override
        public final void writeString(int fieldNumber, String value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeStringNoTag(value2);
        }

        @Override
        public final void writeBytes(int fieldNumber, ByteString value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeBytesNoTag(value2);
        }

        @Override
        public final void writeByteArray(int fieldNumber, byte[] value2) throws IOException {
            this.writeByteArray(fieldNumber, value2, 0, value2.length);
        }

        @Override
        public final void writeByteArray(int fieldNumber, byte[] value2, int offset, int length) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeByteArrayNoTag(value2, offset, length);
        }

        @Override
        public final void writeByteBuffer(int fieldNumber, ByteBuffer value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeUInt32NoTag(value2.capacity());
            this.writeRawBytes(value2);
        }

        @Override
        public final void writeBytesNoTag(ByteString value2) throws IOException {
            this.writeUInt32NoTag(value2.size());
            value2.writeTo(this);
        }

        @Override
        public final void writeByteArrayNoTag(byte[] value2, int offset, int length) throws IOException {
            this.writeUInt32NoTag(length);
            this.write(value2, offset, length);
        }

        @Override
        public final void writeRawBytes(ByteBuffer value2) throws IOException {
            if (value2.hasArray()) {
                this.write(value2.array(), value2.arrayOffset(), value2.capacity());
            } else {
                ByteBuffer duplicated = value2.duplicate();
                duplicated.clear();
                this.write(duplicated);
            }
        }

        @Override
        public final void writeMessage(int fieldNumber, MessageLite value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeMessageNoTag(value2);
        }

        @Override
        final void writeMessage(int fieldNumber, MessageLite value2, Schema schema) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeUInt32NoTag(((AbstractMessageLite)value2).getSerializedSize(schema));
            schema.writeTo(value2, this.wrapper);
        }

        @Override
        public final void writeMessageSetExtension(int fieldNumber, MessageLite value2) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, fieldNumber);
            this.writeMessage(3, value2);
            this.writeTag(1, 4);
        }

        @Override
        public final void writeRawMessageSetExtension(int fieldNumber, ByteString value2) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, fieldNumber);
            this.writeBytes(3, value2);
            this.writeTag(1, 4);
        }

        @Override
        public final void writeMessageNoTag(MessageLite value2) throws IOException {
            this.writeUInt32NoTag(value2.getSerializedSize());
            value2.writeTo(this);
        }

        @Override
        final void writeMessageNoTag(MessageLite value2, Schema schema) throws IOException {
            this.writeUInt32NoTag(((AbstractMessageLite)value2).getSerializedSize(schema));
            schema.writeTo(value2, this.wrapper);
        }

        @Override
        public final void write(byte value2) throws IOException {
            try {
                this.buffer[this.position++] = value2;
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), e);
            }
        }

        @Override
        public final void writeInt32NoTag(int value2) throws IOException {
            if (value2 >= 0) {
                this.writeUInt32NoTag(value2);
            } else {
                this.writeUInt64NoTag(value2);
            }
        }

        @Override
        public final void writeUInt32NoTag(int value2) throws IOException {
            if (HAS_UNSAFE_ARRAY_OPERATIONS && !Android.isOnAndroidDevice() && this.spaceLeft() >= 5) {
                if ((value2 & 0xFFFFFF80) == 0) {
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)value2);
                    return;
                }
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(value2 | 0x80));
                if (((value2 >>>= 7) & 0xFFFFFF80) == 0) {
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)value2);
                    return;
                }
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(value2 | 0x80));
                if (((value2 >>>= 7) & 0xFFFFFF80) == 0) {
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)value2);
                    return;
                }
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(value2 | 0x80));
                if (((value2 >>>= 7) & 0xFFFFFF80) == 0) {
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)value2);
                    return;
                }
            } else {
                try {
                    while (true) {
                        if ((value2 & 0xFFFFFF80) == 0) {
                            this.buffer[this.position++] = (byte)value2;
                            return;
                        }
                        this.buffer[this.position++] = (byte)(value2 & 0x7F | 0x80);
                        value2 >>>= 7;
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), e);
                }
            }
            UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(value2 | 0x80));
            UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(value2 >>>= 7));
        }

        @Override
        public final void writeFixed32NoTag(int value2) throws IOException {
            try {
                this.buffer[this.position++] = (byte)(value2 & 0xFF);
                this.buffer[this.position++] = (byte)(value2 >> 8 & 0xFF);
                this.buffer[this.position++] = (byte)(value2 >> 16 & 0xFF);
                this.buffer[this.position++] = (byte)(value2 >> 24 & 0xFF);
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), e);
            }
        }

        @Override
        public final void writeUInt64NoTag(long value2) throws IOException {
            if (HAS_UNSAFE_ARRAY_OPERATIONS && this.spaceLeft() >= 10) {
                while (true) {
                    if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)value2);
                        return;
                    }
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)((int)value2 & 0x7F | 0x80));
                    value2 >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)value2;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)value2 & 0x7F | 0x80);
                    value2 >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), e);
            }
        }

        @Override
        public final void writeFixed64NoTag(long value2) throws IOException {
            try {
                this.buffer[this.position++] = (byte)((int)value2 & 0xFF);
                this.buffer[this.position++] = (byte)((int)(value2 >> 8) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(value2 >> 16) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(value2 >> 24) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(value2 >> 32) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(value2 >> 40) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(value2 >> 48) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(value2 >> 56) & 0xFF);
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), e);
            }
        }

        @Override
        public final void write(byte[] value2, int offset, int length) throws IOException {
            try {
                System.arraycopy(value2, offset, this.buffer, this.position, length);
                this.position += length;
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, length), e);
            }
        }

        @Override
        public final void writeLazy(byte[] value2, int offset, int length) throws IOException {
            this.write(value2, offset, length);
        }

        @Override
        public final void write(ByteBuffer value2) throws IOException {
            int length = value2.remaining();
            try {
                value2.get(this.buffer, this.position, length);
                this.position += length;
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, length), e);
            }
        }

        @Override
        public final void writeLazy(ByteBuffer value2) throws IOException {
            this.write(value2);
        }

        @Override
        public final void writeStringNoTag(String value2) throws IOException {
            int oldPosition = this.position;
            try {
                int maxLength = value2.length() * 3;
                int maxLengthVarIntSize = ArrayEncoder.computeUInt32SizeNoTag(maxLength);
                int minLengthVarIntSize = ArrayEncoder.computeUInt32SizeNoTag(value2.length());
                if (minLengthVarIntSize == maxLengthVarIntSize) {
                    this.position = oldPosition + minLengthVarIntSize;
                    int newPosition = Utf8.encode(value2, this.buffer, this.position, this.spaceLeft());
                    this.position = oldPosition;
                    int length = newPosition - oldPosition - minLengthVarIntSize;
                    this.writeUInt32NoTag(length);
                    this.position = newPosition;
                } else {
                    int length = Utf8.encodedLength(value2);
                    this.writeUInt32NoTag(length);
                    this.position = Utf8.encode(value2, this.buffer, this.position, this.spaceLeft());
                }
            }
            catch (Utf8.UnpairedSurrogateException e) {
                this.position = oldPosition;
                this.inefficientWriteStringNoTag(value2, e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(e);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int spaceLeft() {
            return this.limit - this.position;
        }

        @Override
        public final int getTotalBytesWritten() {
            return this.position - this.offset;
        }
    }

    public static class OutOfSpaceException
    extends IOException {
        private static final long serialVersionUID = -6947486886997889499L;
        private static final String MESSAGE = "CodedOutputStream was writing to a flat byte array and ran out of space.";

        OutOfSpaceException() {
            super(MESSAGE);
        }

        OutOfSpaceException(String explanationMessage) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.: " + explanationMessage);
        }

        OutOfSpaceException(Throwable cause) {
            super(MESSAGE, cause);
        }

        OutOfSpaceException(String explanationMessage, Throwable cause) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.: " + explanationMessage, cause);
        }
    }
}

