/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.visualization.tensorboard;

import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.tensorflow.util.Event;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class FileReader$ {
    public static final FileReader$ MODULE$;
    private final Regex fileNameRegex;

    static {
        new FileReader$();
    }

    public Regex fileNameRegex() {
        return this.fileNameRegex;
    }

    private Path[] recursiveListFiles(Path f, Regex r, FileSystem fs) {
        ArrayBuffer buffer = new ArrayBuffer();
        RemoteIterator files = fs.listFiles(f, true);
        while (files.hasNext()) {
            Path file = ((FileStatus)files.next()).getPath();
            if (!r.findFirstIn((CharSequence)file.getName()).isDefined()) continue;
            buffer.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{file}));
        }
        return (Path[])buffer.toArray(ClassTag$.MODULE$.apply(Path.class));
    }

    public Path[] listFiles(String path) {
        Path logPath = new Path(path);
        FileSystem fs = logPath.getFileSystem(new Configuration(false));
        Log4Error$.MODULE$.invalidInputError(fs.isDirectory(logPath), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FileReader: ", " should be a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), Log4Error$.MODULE$.invalidInputError$default$3());
        return this.recursiveListFiles(logPath, this.fileNameRegex(), fs);
    }

    public String[] list(String path) {
        Path logPath = new Path(path);
        FileSystem fs = logPath.getFileSystem(new Configuration(false));
        Log4Error$.MODULE$.invalidInputError(fs.isDirectory(logPath), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FileReader: ", " should be a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), Log4Error$.MODULE$.invalidInputError$default$3());
        return (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.recursiveListFiles(logPath, this.fileNameRegex(), fs)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Path x$1) {
                return x$1.getParent().toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).distinct();
    }

    public Tuple3<Object, Object, Object>[] readScalar(String path, String tag) {
        Path logPath = new Path(path);
        FileSystem fs = logPath.getFileSystem(new Configuration(false));
        Log4Error$.MODULE$.invalidInputError(fs.isDirectory(logPath), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FileReader: ", " should be a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), Log4Error$.MODULE$.invalidInputError$default$3());
        Path[] files = this.recursiveListFiles(logPath, this.fileNameRegex(), fs);
        return (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])files).map((Function1)new Serializable(tag, fs){
            public static final long serialVersionUID = 0L;
            private final String tag$1;
            private final FileSystem fs$1;

            public final Tuple3<Object, Object, Object>[] apply(Path file) {
                return FileReader$.MODULE$.readScalar(file, this.tag$1, this.fs$1);
            }
            {
                this.tag$1 = tag$1;
                this.fs$1 = fs$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple3.class))))).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<Tuple3<Object, Object, Object>> apply(Tuple3<Object, Object, Object>[] x$2) {
                return Predef$.MODULE$.refArrayOps((Object[])x$2).toIterator();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)))).sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple3<Object, Object, Object> x$3, Tuple3<Object, Object, Object> x$4) {
                return BoxesRunTime.unboxToLong((Object)x$3._1()) < BoxesRunTime.unboxToLong((Object)x$4._1());
            }
        });
    }

    public Tuple3<Object, Object, Object>[] readScalar(Path file, String tag, FileSystem fs) {
        Log4Error$.MODULE$.invalidInputError(fs.isFile(file), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FileReader: ", " should be a file"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})), Log4Error$.MODULE$.invalidInputError$default$3());
        BufferedInputStream bis = new BufferedInputStream((InputStream)fs.open(file));
        byte[] longBuffer = new byte[8];
        byte[] crcBuffer = new byte[4];
        ArrayBuffer bf = new ArrayBuffer();
        while (bis.read(longBuffer) > 0) {
            long l = ByteBuffer.wrap((byte[])Predef$.MODULE$.byteArrayOps(longBuffer).reverse()).getLong();
            bis.read(crcBuffer);
            byte[] eventBuffer = new byte[(int)l];
            bis.read(eventBuffer);
            Event e = Event.parseFrom(eventBuffer);
            if (e.getSummary().getValueCount() == 1 && tag.equals(e.getSummary().getValue(0).getTag())) {
                bf.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToLong((long)e.getStep()), (Object)BoxesRunTime.boxToFloat((float)e.getSummary().getValue(0).getSimpleValue()), (Object)BoxesRunTime.boxToDouble((double)e.getWallTime()))}));
            }
            bis.read(crcBuffer);
        }
        bis.close();
        return (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])bf.toArray(ClassTag$.MODULE$.apply(Tuple3.class))).sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple3<Object, Object, Object> x$5, Tuple3<Object, Object, Object> x$6) {
                return BoxesRunTime.unboxToLong((Object)x$5._1()) < BoxesRunTime.unboxToLong((Object)x$6._1());
            }
        });
    }

    private FileReader$() {
        MODULE$ = this;
        this.fileNameRegex = new StringOps(Predef$.MODULE$.augmentString("bigdl.tfevents.*")).r();
    }
}

