/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.utils.tf;

import com.intel.analytics.bigdl.dllib.tensor.Storage$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericDouble$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericFloat$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericInt$;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.Node;
import com.intel.analytics.bigdl.dllib.utils.tf.BatchNormTF$;
import com.intel.analytics.bigdl.dllib.utils.tf.BatchNormV2NCHWTF$;
import com.intel.analytics.bigdl.dllib.utils.tf.BatchNormV2NHWCTF$;
import com.intel.analytics.bigdl.dllib.utils.tf.Conv1D$;
import com.intel.analytics.bigdl.dllib.utils.tf.Conv2D$;
import com.intel.analytics.bigdl.dllib.utils.tf.Conv2D2$;
import com.intel.analytics.bigdl.dllib.utils.tf.Conv2DWithoutBias$;
import com.intel.analytics.bigdl.dllib.utils.tf.DropoutTF$;
import com.intel.analytics.bigdl.dllib.utils.tf.FullConnectionTF$;
import com.intel.analytics.bigdl.dllib.utils.tf.FullConnectionWithoutBiasTF$;
import com.intel.analytics.bigdl.dllib.utils.tf.TensorflowToBigDL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.tensorflow.framework.DataType;
import org.tensorflow.framework.TensorProto;
import org.tensorflow.framework.TensorShapeProto;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class TensorflowToBigDL$ {
    public static final TensorflowToBigDL$ MODULE$;
    private final String INPUT_PLACEHOLDER;
    private final String N_INPUT_PLACEHOLDER;
    private final String TENSOR_SEPARATOR;
    private ArrayBuffer<TensorflowToBigDL> patternList;

    static {
        new TensorflowToBigDL$();
    }

    public String INPUT_PLACEHOLDER() {
        return this.INPUT_PLACEHOLDER;
    }

    public String N_INPUT_PLACEHOLDER() {
        return this.N_INPUT_PLACEHOLDER;
    }

    public String TENSOR_SEPARATOR() {
        return this.TENSOR_SEPARATOR;
    }

    public TensorflowToBigDL[] patterns() {
        return (TensorflowToBigDL[])this.patternList().toArray(ClassTag$.MODULE$.apply(TensorflowToBigDL.class));
    }

    public void registerPattern(TensorflowToBigDL pattern) {
        Log4Error$.MODULE$.invalidInputError(pattern.topology().reverse(), "the topology should be a reversed graph", Log4Error$.MODULE$.invalidInputError$default$3());
        this.patternList().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TensorflowToBigDL[]{pattern}));
        this.sortPattern();
    }

    public Tensor<?> toTensor(TensorProto tfTensor, ByteOrder endian) {
        int[] shape = (int[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tfTensor.getTensorShape().getDimList()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(TensorShapeProto.Dim x$3) {
                return (int)x$3.getSize();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        if (BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(shape).product((Numeric)Numeric.IntIsIntegral$.MODULE$)) == 1) {
            DataType dataType = tfTensor.getDtype();
            DataType dataType2 = DataType.DT_FLOAT;
            if (!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null)) {
                return Tensor$.MODULE$.apply(Storage$.MODULE$.apply$mFc$sp(new float[]{tfTensor.getFloatVal(0)}, (ClassTag<Object>)ClassTag$.MODULE$.Float()), 1, shape, Tensor$.MODULE$.apply$default$4(), ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
            }
            DataType dataType3 = tfTensor.getDtype();
            DataType dataType4 = DataType.DT_INT32;
            if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
                return Tensor$.MODULE$.apply(Storage$.MODULE$.apply(new int[]{tfTensor.getIntVal(0)}, ClassTag$.MODULE$.Int()), 1, shape, Tensor$.MODULE$.apply$default$4(), ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$);
            }
            DataType dataType5 = tfTensor.getDtype();
            DataType dataType6 = DataType.DT_DOUBLE;
            if (!(dataType5 != null ? !dataType5.equals(dataType6) : dataType6 != null)) {
                return Tensor$.MODULE$.apply(Storage$.MODULE$.apply$mDc$sp(new double[]{tfTensor.getDoubleVal(0)}, (ClassTag<Object>)ClassTag$.MODULE$.Double()), 1, shape, Tensor$.MODULE$.apply$default$4(), ClassTag$.MODULE$.Double(), TensorNumericMath$TensorNumeric$NumericDouble$.MODULE$);
            }
        }
        ByteBuffer buffer = ByteBuffer.wrap(tfTensor.getTensorContent().toByteArray());
        buffer.order(endian);
        DataType dataType = tfTensor.getDtype();
        DataType dataType7 = DataType.DT_FLOAT;
        if (!(dataType != null ? !dataType.equals(dataType7) : dataType7 != null)) {
            FloatBuffer params = buffer.asFloatBuffer();
            float[] tmp = new float[params.capacity()];
            for (int j = 0; j < params.capacity(); ++j) {
                tmp[j] = params.get(j);
            }
            return Tensor$.MODULE$.apply$mFc$sp(Storage$.MODULE$.apply$mFc$sp(tmp, (ClassTag<Object>)ClassTag$.MODULE$.Float()), 1, shape, Tensor$.MODULE$.apply$default$4(), (ClassTag<Object>)ClassTag$.MODULE$.Float(), (TensorNumericMath.TensorNumeric<Object>)TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
        }
        DataType dataType8 = tfTensor.getDtype();
        DataType dataType9 = DataType.DT_INT32;
        if (!(dataType8 != null ? !dataType8.equals(dataType9) : dataType9 != null)) {
            IntBuffer params = buffer.asIntBuffer();
            int[] tmp = new int[params.capacity()];
            for (int j = 0; j < params.capacity(); ++j) {
                tmp[j] = params.get(j);
            }
            return Tensor$.MODULE$.apply(Storage$.MODULE$.apply(tmp, ClassTag$.MODULE$.Int()), 1, shape, Tensor$.MODULE$.apply$default$4(), ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$);
        }
        DataType dataType10 = tfTensor.getDtype();
        DataType dataType11 = DataType.DT_DOUBLE;
        if (!(dataType10 != null ? !dataType10.equals(dataType11) : dataType11 != null)) {
            DoubleBuffer params = buffer.asDoubleBuffer();
            double[] tmp = new double[params.capacity()];
            for (int j = 0; j < params.capacity(); ++j) {
                tmp[j] = params.get(j);
            }
            return Tensor$.MODULE$.apply$mDc$sp(Storage$.MODULE$.apply$mDc$sp(tmp, (ClassTag<Object>)ClassTag$.MODULE$.Double()), 1, shape, Tensor$.MODULE$.apply$default$4(), (ClassTag<Object>)ClassTag$.MODULE$.Double(), (TensorNumericMath.TensorNumeric<Object>)TensorNumericMath$TensorNumeric$NumericDouble$.MODULE$);
        }
        Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not support load tensorflow tensor when type is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tfTensor.getDtype()})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        return null;
    }

    private ArrayBuffer<TensorflowToBigDL> patternList() {
        return this.patternList;
    }

    private void patternList_$eq(ArrayBuffer<TensorflowToBigDL> x$1) {
        this.patternList = x$1;
    }

    private void sortPattern() {
        Map topToNNodes = ((TraversableOnce)this.patternList().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TensorflowToBigDL, Object> apply(TensorflowToBigDL g2) {
                int nodeSize = g2.topology().BFS().count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Node<String> n) {
                        String string = n.element();
                        String string2 = TensorflowToBigDL$.MODULE$.INPUT_PLACEHOLDER();
                        if (string == null) {
                            if (string2 == null) return false;
                        } else if (string.equals(string2)) return false;
                        String string3 = n.element();
                        String string4 = TensorflowToBigDL$.MODULE$.N_INPUT_PLACEHOLDER();
                        if (string3 != null) {
                            if (!string3.equals(string4)) return true;
                            return false;
                        }
                        if (string4 == null) return false;
                        return true;
                    }
                });
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)g2), (Object)BoxesRunTime.boxToInteger((int)nodeSize));
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map topToNEdges = ((TraversableOnce)this.patternList().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TensorflowToBigDL, Object> apply(TensorflowToBigDL g2) {
                int edgeSize = BoxesRunTime.unboxToInt((Object)g2.topology().BFS().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Node<String> n) {
                        String string = n.element();
                        String string2 = TensorflowToBigDL$.MODULE$.INPUT_PLACEHOLDER();
                        if (string == null) {
                            if (string2 == null) return false;
                        } else if (string.equals(string2)) return false;
                        String string3 = n.element();
                        String string4 = TensorflowToBigDL$.MODULE$.N_INPUT_PLACEHOLDER();
                        if (string3 != null) {
                            if (!string3.equals(string4)) return true;
                            return false;
                        }
                        if (string4 == null) return false;
                        return true;
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Node<String> x$4) {
                        return x$4.nextNodes().length();
                    }
                }).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int x$5, int x$6) {
                        return this.apply$mcIII$sp(x$5, x$6);
                    }

                    public int apply$mcIII$sp(int x$5, int x$6) {
                        return x$5 + x$6;
                    }
                }));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)g2), (Object)BoxesRunTime.boxToInteger((int)edgeSize));
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.patternList_$eq((ArrayBuffer<TensorflowToBigDL>)((ArrayBuffer)this.patternList().sortWith((Function2)new Serializable(topToNNodes, topToNEdges){
            public static final long serialVersionUID = 0L;
            private final Map topToNNodes$1;
            private final Map topToNEdges$1;

            public final boolean apply(TensorflowToBigDL l, TensorflowToBigDL r) {
                return BoxesRunTime.unboxToInt((Object)this.topToNNodes$1.apply((Object)l)) != BoxesRunTime.unboxToInt((Object)this.topToNNodes$1.apply((Object)r)) ? BoxesRunTime.unboxToInt((Object)this.topToNNodes$1.apply((Object)l)) > BoxesRunTime.unboxToInt((Object)this.topToNNodes$1.apply((Object)r)) : BoxesRunTime.unboxToInt((Object)this.topToNEdges$1.apply((Object)l)) > BoxesRunTime.unboxToInt((Object)this.topToNEdges$1.apply((Object)r));
            }
            {
                this.topToNNodes$1 = topToNNodes$1;
                this.topToNEdges$1 = topToNEdges$1;
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    private TensorflowToBigDL$() {
        void var1_1;
        MODULE$ = this;
        this.INPUT_PLACEHOLDER = "*";
        this.N_INPUT_PLACEHOLDER = "...";
        this.TENSOR_SEPARATOR = ":";
        ArrayBuffer res = new ArrayBuffer();
        res.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TensorflowToBigDL[]{FullConnectionTF$.MODULE$, DropoutTF$.MODULE$, Conv2D$.MODULE$, BatchNormTF$.MODULE$, Conv1D$.MODULE$, BatchNormV2NHWCTF$.MODULE$, BatchNormV2NCHWTF$.MODULE$, FullConnectionWithoutBiasTF$.MODULE$, Conv2D2$.MODULE$, Conv2DWithoutBias$.MODULE$}));
        this.patternList = var1_1;
        this.sortPattern();
    }
}

