/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.utils.tf;

import com.intel.analytics.bigdl.dllib.nn.abstractnn.AbstractModule;
import com.intel.analytics.bigdl.dllib.tensor.BooleanType$;
import com.intel.analytics.bigdl.dllib.tensor.DoubleType$;
import com.intel.analytics.bigdl.dllib.tensor.FloatType$;
import com.intel.analytics.bigdl.dllib.tensor.IntType$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.TensorDataType;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.tf.PaddingType;
import com.intel.analytics.bigdl.dllib.utils.tf.PaddingType$PADDING_SAME$;
import com.intel.analytics.bigdl.dllib.utils.tf.PaddingType$PADDING_VALID$;
import com.intel.analytics.bigdl.dllib.utils.tf.TensorflowDataFormat;
import com.intel.analytics.bigdl.dllib.utils.tf.TensorflowDataFormat$NHWC$;
import com.intel.analytics.shaded.protobuf_v_3_5_1.ByteString;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.DataType;
import org.tensorflow.framework.NodeDef;
import org.tensorflow.framework.TensorProto;
import org.tensorflow.framework.TensorShapeProto;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Tensorflow$ {
    public static final Tensorflow$ MODULE$;

    static {
        new Tensorflow$();
    }

    public NodeDef bigdlModule(AbstractModule<?, ?, ?> module, Iterable<String> inputs2) {
        return NodeDef.newBuilder().setName(module.getName()).setOp(module.getClass().getName()).addAllInput(inputs2).build();
    }

    public NodeDef placeholder(TensorDataType dtype, Seq<Object> shape, String name) {
        return NodeDef.newBuilder().setName(name).setOp("Placeholder").putAttr("dtype", this.typeAttr(dtype)).putAttr("shape", this.shapeAttr(shape)).build();
    }

    public NodeDef const(Tensor<?> value2, String name, ByteOrder byteOrder) {
        DataType dataType;
        TensorDataType tensorDataType = value2.getType();
        DoubleType$ doubleType$ = DoubleType$.MODULE$;
        if (!(tensorDataType != null ? !tensorDataType.equals(doubleType$) : doubleType$ != null)) {
            dataType = DataType.DT_DOUBLE;
        } else {
            TensorDataType tensorDataType2 = value2.getType();
            FloatType$ floatType$ = FloatType$.MODULE$;
            if (!(tensorDataType2 != null ? !tensorDataType2.equals(floatType$) : floatType$ != null)) {
                dataType = DataType.DT_FLOAT;
            } else {
                TensorDataType tensorDataType3 = value2.getType();
                IntType$ intType$ = IntType$.MODULE$;
                if (!(tensorDataType3 != null ? !tensorDataType3.equals(intType$) : intType$ != null)) {
                    dataType = DataType.DT_INT32;
                } else {
                    TensorDataType tensorDataType4 = value2.getType();
                    BooleanType$ booleanType$ = BooleanType$.MODULE$;
                    if (!(tensorDataType4 != null ? !tensorDataType4.equals(booleanType$) : booleanType$ != null)) {
                        dataType = DataType.DT_BOOL;
                    } else {
                        Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"data type ", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value2.getType()})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                        dataType = null;
                    }
                }
            }
        }
        DataType dtype = dataType;
        return NodeDef.newBuilder().setName(name).setOp("Const").putAttr("dtype", AttrValue.newBuilder().setType(dtype).build()).putAttr("value", this.tensorAttr(value2, byteOrder)).build();
    }

    public NodeDef identity(NodeDef input, String name) {
        return NodeDef.newBuilder().setName(name).setOp("Identity").addInput(input.getName()).putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(input)).build();
    }

    public NodeDef matmul(NodeDef a, NodeDef b, String name, boolean transposeA, boolean transposeB) {
        return NodeDef.newBuilder().setName(name).setOp("MatMul").addInput(a.getName()).addInput(b.getName()).putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(a)).putAttr("transpose_a", this.booleanAttr(transposeA)).putAttr("transpose_b", this.booleanAttr(transposeB)).build();
    }

    public boolean matmul$default$4() {
        return false;
    }

    public boolean matmul$default$5() {
        return false;
    }

    public NodeDef transpose(NodeDef x, NodeDef perm, String name) {
        return NodeDef.newBuilder().setName(name).setOp("Transpose").addInput(x.getName()).addInput(perm.getName()).putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(x)).putAttr("Tperm", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(perm)).build();
    }

    public NodeDef biasAdd(NodeDef value2, NodeDef bias, TensorflowDataFormat dataFormat, String name) {
        return NodeDef.newBuilder().setName(name).setOp("BiasAdd").addInput(value2.getName()).addInput(bias.getName()).putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(value2)).putAttr("data_format", dataFormat.value()).build();
    }

    public NodeDef expandDims(NodeDef input, NodeDef dim, String name) {
        return NodeDef.newBuilder().setName(name).setOp("ExpandDims").addInput(input.getName()).addInput(dim.getName()).putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(input)).putAttr("Tdim", AttrValue.newBuilder().setType(DataType.DT_INT32).build()).build();
    }

    public NodeDef relu(NodeDef features2, String name) {
        return NodeDef.newBuilder().setName(name).setOp("Relu").addInput(features2.getName()).putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(features2)).build();
    }

    public NodeDef conv2D(NodeDef input, NodeDef filter, int sW, int sH, int kW, int kH, int pW, int pH, TensorflowDataFormat dataFormat, String name) {
        return NodeDef.newBuilder().setName(name).setOp("Conv2D").addInput(input.getName()).addInput(filter.getName()).putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(input)).putAttr("data_format", dataFormat.value()).putAttr("padding", this.getPaddingType(pW, pH, kW, kH, sW, sH).value()).putAttr("strides", this.strideAttr(sW, sH, dataFormat)).build();
    }

    public NodeDef squeeze(NodeDef input, Seq<Object> axis, String name) {
        return NodeDef.newBuilder().setName(name).setOp("Squeeze").addInput(input.getName()).putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(input)).putAttr("squeeze_dims", this.listIntAttr(axis)).build();
    }

    public NodeDef tanh(NodeDef input, String name) {
        return NodeDef.newBuilder().setName(name).setOp("Tanh").addInput(input.getName()).putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(input)).build();
    }

    public NodeDef reshape(NodeDef tensor, NodeDef shape, String name) {
        return NodeDef.newBuilder().setName(name).setOp("Reshape").addInput(tensor.getName()).addInput(shape.getName()).putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(tensor)).putAttr("Tshape", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(shape)).build();
    }

    public NodeDef maxPool(NodeDef value2, int kW, int kH, int pW, int pH, int sW, int sH, TensorflowDataFormat dataFormat, String name, boolean ceilMode) {
        AttrValue paddingType = ceilMode ? PaddingType$PADDING_SAME$.MODULE$.value() : this.getPaddingType(pW, pH, kW, kH, sW, sH).value();
        return NodeDef.newBuilder().setName(name).setOp("MaxPool").addInput(value2.getName()).putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(value2)).putAttr("data_format", dataFormat.value()).putAttr("ksize", this.kernelAttr(kW, kH, dataFormat)).putAttr("padding", paddingType).putAttr("strides", this.strideAttr(sW, sH, dataFormat)).build();
    }

    public boolean maxPool$default$10() {
        return false;
    }

    public NodeDef avgPool(NodeDef value2, int kW, int kH, int pW, int pH, int sW, int sH, TensorflowDataFormat dataFormat, String name, boolean ceilMode) {
        AttrValue paddingType = ceilMode ? PaddingType$PADDING_SAME$.MODULE$.value() : this.getPaddingType(pW, pH, kW, kH, sW, sH).value();
        return NodeDef.newBuilder().setName(name).setOp("AvgPool").putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(value2)).addInput(value2.getName()).putAttr("data_format", dataFormat.value()).putAttr("ksize", this.kernelAttr(kW, kH, dataFormat)).putAttr("padding", paddingType).putAttr("strides", this.strideAttr(sW, sH, dataFormat)).build();
    }

    public NodeDef sigmoid(NodeDef x, String name) {
        return NodeDef.newBuilder().setName(name).setOp("Sigmoid").putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(x)).addInput(x.getName()).build();
    }

    public NodeDef multiply(NodeDef x, NodeDef y, String name) {
        return NodeDef.newBuilder().setName(name).setOp("Mul").putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(x)).addInput(x.getName()).addInput(y.getName()).build();
    }

    public NodeDef floor(NodeDef x, String name) {
        return NodeDef.newBuilder().setName(name).setOp("Floor").putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(x)).addInput(x.getName()).build();
    }

    public NodeDef add(NodeDef x, NodeDef y, String name) {
        return NodeDef.newBuilder().setName(name).setOp("Add").putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(x)).addInput(x.getName()).addInput(y.getName()).build();
    }

    public NodeDef realdiv(NodeDef x, NodeDef y, String name) {
        return NodeDef.newBuilder().setName(name).setOp("RealDiv").putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(x)).addInput(x.getName()).addInput(y.getName()).build();
    }

    public NodeDef subtract(NodeDef x, NodeDef y, String name) {
        return NodeDef.newBuilder().setName(name).setOp("Sub").putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(x)).addInput(x.getName()).addInput(y.getName()).build();
    }

    public NodeDef shape(NodeDef input, String name, DataType outType) {
        return NodeDef.newBuilder().setName(name).setOp("Shape").putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(input)).putAttr("out_type", AttrValue.newBuilder().setType(outType).build()).build();
    }

    public DataType shape$default$3() {
        return DataType.DT_INT32;
    }

    public NodeDef randomUniform(NodeDef shape, String name, DataType dtype, int seed) {
        return NodeDef.newBuilder().setName(name).setOp("RandomUniform").putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(shape)).putAttr("dtype", AttrValue.newBuilder().setType(dtype).build()).putAttr("seed", this.intAttr(seed)).putAttr("seed2", this.intAttr(seed)).addInput(shape.getName()).build();
    }

    public DataType randomUniform$default$3() {
        return DataType.DT_FLOAT;
    }

    public int randomUniform$default$4() {
        return 0;
    }

    public NodeDef addN(Seq<NodeDef> inputs2, String name) {
        Log4Error$.MODULE$.invalidInputError(inputs2.length() >= 2, "at least two inputs for addN", Log4Error$.MODULE$.invalidInputError$default$3());
        NodeDef.Builder node = NodeDef.newBuilder().setName(name).putAttr("N", this.intAttr(inputs2.length())).putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType((NodeDef)inputs2.apply(0))).setOp("AddN");
        inputs2.foreach((Function1)new Serializable(node){
            public static final long serialVersionUID = 0L;
            private final NodeDef.Builder node$1;

            public final NodeDef.Builder apply(NodeDef i) {
                return this.node$1.addInput(i.getName());
            }
            {
                this.node$1 = node$1;
            }
        });
        return node.build();
    }

    public NodeDef concat(Seq<NodeDef> inputs2, String name) {
        Log4Error$.MODULE$.invalidInputError(inputs2.length() >= 1, "at least one inputs for addN", Log4Error$.MODULE$.invalidInputError$default$3());
        NodeDef.Builder node = NodeDef.newBuilder().setName(name).setOp("ConcatV2").putAttr("N", this.intAttr(inputs2.length() - 1)).putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType((NodeDef)inputs2.apply(0))).putAttr("Tidx", AttrValue.newBuilder().setType(DataType.DT_INT32).build());
        inputs2.foreach((Function1)new Serializable(node){
            public static final long serialVersionUID = 0L;
            private final NodeDef.Builder node$2;

            public final NodeDef.Builder apply(NodeDef i) {
                return this.node$2.addInput(i.getName());
            }
            {
                this.node$2 = node$2;
            }
        });
        return node.build();
    }

    public NodeDef pad(NodeDef tensor, NodeDef paddings, String name) {
        return NodeDef.newBuilder().setName(name).setOp("Pad").putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(tensor)).putAttr("Tpaddings", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(paddings)).addInput(tensor.getName()).addInput(paddings.getName()).build();
    }

    public NodeDef reduceMean(NodeDef inputTensor, NodeDef axis, boolean keepDim, String name) {
        return NodeDef.newBuilder().setName(name).setOp("Mean").putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(inputTensor)).putAttr("Tidx", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(axis)).putAttr("keep_dims", this.booleanAttr(keepDim)).addInput(inputTensor.getName()).addInput(axis.getName()).build();
    }

    public Seq<NodeDef> split(NodeDef splitDim, NodeDef value2, int numSplit, String name) {
        NodeDef splitNode = NodeDef.newBuilder().setName(new StringBuilder().append((Object)name).append((Object)"/split").toString()).setOp("Split").putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(value2)).putAttr("num_split", this.intAttr(numSplit)).addInput(splitDim.getName()).addInput(value2.getName()).build();
        return (Seq)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSplit).map((Function1)new Serializable(value2, name){
            public static final long serialVersionUID = 0L;
            private final NodeDef value$1;
            private final String name$1;

            public final NodeDef apply(int i) {
                return NodeDef.newBuilder().setName(new StringBuilder().append((Object)this.name$1).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/reader", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))).toString()).setOp("Identity").addInput(new StringBuilder().append((Object)this.name$1).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/split:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))).toString()).putAttr("T", Tensorflow$.MODULE$.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(this.value$1)).build();
            }
            {
                this.value$1 = value$1;
                this.name$1 = name$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NodeDef[]{splitNode})), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public NodeDef softmax(NodeDef logits, String name) {
        return NodeDef.newBuilder().setName(name).setOp("Softmax").putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(logits)).addInput(logits.getName()).build();
    }

    public NodeDef logSoftmax(NodeDef logits, String name) {
        return NodeDef.newBuilder().setName(name).setOp("LogSoftmax").putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(logits)).addInput(logits.getName()).build();
    }

    public NodeDef lrn(NodeDef input, int depthRadius, float bias, float alpha, float beta, String name) {
        return NodeDef.newBuilder().setName(name).setOp("LRN").putAttr("depth_radius", this.intAttr(depthRadius)).putAttr("bias", this.floatAttr(bias)).putAttr("beta", this.floatAttr(beta)).putAttr("alpha", this.floatAttr(alpha)).putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(input)).addInput(input.getName()).build();
    }

    public NodeDef rsqrt(NodeDef x, String name) {
        return NodeDef.newBuilder().setName(name).setOp("Rsqrt").putAttr("T", this.com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(x)).addInput(x.getName()).build();
    }

    public AttrValue booleanAttr(boolean value2) {
        return AttrValue.newBuilder().setB(value2).build();
    }

    public AttrValue intAttr(int value2) {
        return AttrValue.newBuilder().setI(value2).build();
    }

    public AttrValue floatAttr(float value2) {
        return AttrValue.newBuilder().setF(value2).build();
    }

    public AttrValue listIntAttr(Seq<Object> value2) {
        AttrValue.ListValue.Builder list2 = AttrValue.ListValue.newBuilder();
        value2.foreach((Function1)new Serializable(list2){
            public static final long serialVersionUID = 0L;
            private final AttrValue.ListValue.Builder list$1;

            public final AttrValue.ListValue.Builder apply(int x$1) {
                return this.list$1.addI(x$1);
            }
            {
                this.list$1 = list$1;
            }
        });
        return AttrValue.newBuilder().setList(list2).build();
    }

    private AttrValue tensorAttr(Tensor<?> value2, ByteOrder byteOrder) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        TensorShapeProto.Builder shape = TensorShapeProto.newBuilder();
        if (!value2.isScalar()) {
            Predef$.MODULE$.intArrayOps(value2.size()).foreach((Function1)new Serializable(shape){
                public static final long serialVersionUID = 0L;
                private final TensorShapeProto.Builder shape$1;

                public final TensorShapeProto.Builder apply(int dim) {
                    return this.shape$1.addDim(TensorShapeProto.Dim.newBuilder().setSize(dim));
                }
                {
                    this.shape$1 = shape$1;
                }
            });
        }
        Log4Error$.MODULE$.invalidInputError(value2.isContiguous(), "only support save a contiguous tensor", Log4Error$.MODULE$.invalidInputError$default$3());
        TensorDataType tensorDataType = value2.getType();
        DoubleType$ doubleType$ = DoubleType$.MODULE$;
        if (!(tensorDataType != null ? !tensorDataType.equals(doubleType$) : doubleType$ != null)) {
            double[] array = (double[])value2.storage().array();
            int offset = value2.storageOffset() - 1;
            ByteBuffer buffer = ByteBuffer.allocate(value2.nElement() * 8);
            buffer.order(byteOrder);
            for (int i = 0; i < value2.nElement(); ++i) {
                buffer.putDouble(array[i + offset]);
            }
            tuple22 = new Tuple2((Object)buffer, (Object)DataType.DT_DOUBLE);
        } else {
            TensorDataType tensorDataType2 = value2.getType();
            FloatType$ floatType$ = FloatType$.MODULE$;
            if (!(tensorDataType2 != null ? !tensorDataType2.equals(floatType$) : floatType$ != null)) {
                float[] array = (float[])value2.storage().array();
                int offset = value2.storageOffset() - 1;
                ByteBuffer buffer = ByteBuffer.allocate(value2.nElement() * 4);
                buffer.order(byteOrder);
                for (int i = 0; i < value2.nElement(); ++i) {
                    buffer.putFloat(array[i + offset]);
                }
                tuple22 = new Tuple2((Object)buffer, (Object)DataType.DT_FLOAT);
            } else {
                TensorDataType tensorDataType3 = value2.getType();
                IntType$ intType$ = IntType$.MODULE$;
                if (!(tensorDataType3 != null ? !tensorDataType3.equals(intType$) : intType$ != null)) {
                    int[] array = (int[])value2.storage().array();
                    int offset = value2.storageOffset() - 1;
                    ByteBuffer buffer = ByteBuffer.allocate(value2.nElement() * 4);
                    buffer.order(byteOrder);
                    for (int i = 0; i < value2.nElement(); ++i) {
                        buffer.putInt(array[i + offset]);
                    }
                    tuple22 = new Tuple2((Object)buffer, (Object)DataType.DT_INT32);
                } else {
                    TensorDataType tensorDataType4 = value2.getType();
                    BooleanType$ booleanType$ = BooleanType$.MODULE$;
                    if (!(tensorDataType4 != null ? !tensorDataType4.equals(booleanType$) : booleanType$ != null)) {
                        boolean[] array = (boolean[])value2.storage().array();
                        int offset = value2.storageOffset() - 1;
                        ByteBuffer buffer = ByteBuffer.allocate(value2.nElement());
                        buffer.order(byteOrder);
                        byte t2 = 1;
                        byte f = 0;
                        for (int i = 0; i < value2.nElement(); ++i) {
                            buffer.put(array[i + offset] ? t2 : f);
                        }
                        tuple22 = new Tuple2((Object)buffer, (Object)DataType.DT_BOOL);
                    } else {
                        Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value2.getType()})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                        tuple22 = tuple2 = new Tuple2(null, (Object)DataType.DT_BOOL);
                    }
                }
            }
        }
        if (tuple2 != null) {
            Tuple2 tuple23;
            ByteBuffer content = (ByteBuffer)tuple2._1();
            DataType dtype = (DataType)tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)content, (Object)dtype);
            ByteBuffer content2 = (ByteBuffer)tuple24._1();
            DataType dtype2 = (DataType)tuple24._2();
            return AttrValue.newBuilder().setTensor(TensorProto.newBuilder().setTensorShape(shape).setDtype(dtype2).setTensorContent(ByteString.copyFrom(content2.array()))).build();
        }
        throw new MatchError((Object)tuple2);
    }

    private AttrValue tensorAttr(Seq<Object> value2) {
        TensorShapeProto.Builder shape = TensorShapeProto.newBuilder();
        shape.addDim(TensorShapeProto.Dim.newBuilder().setSize(value2.length()));
        DataType dtype = DataType.DT_INT32;
        return AttrValue.newBuilder().setTensor(TensorProto.newBuilder().setTensorShape(shape).setDtype(dtype)).build();
    }

    public AttrValue typeAttr(TensorDataType dtype) {
        AttrValue attrValue;
        TensorDataType tensorDataType = dtype;
        FloatType$ floatType$ = FloatType$.MODULE$;
        if (!(tensorDataType != null ? !tensorDataType.equals(floatType$) : floatType$ != null)) {
            attrValue = AttrValue.newBuilder().setType(DataType.DT_FLOAT).build();
        } else {
            TensorDataType tensorDataType2 = dtype;
            DoubleType$ doubleType$ = DoubleType$.MODULE$;
            if (!(tensorDataType2 != null ? !tensorDataType2.equals(doubleType$) : doubleType$ != null)) {
                attrValue = AttrValue.newBuilder().setType(DataType.DT_DOUBLE).build();
            } else {
                Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"type ", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dtype})), "only support FloatType, DoubleType", Log4Error$.MODULE$.invalidOperationError$default$4());
                attrValue = null;
            }
        }
        return attrValue;
    }

    public AttrValue typeAttr(DataType dtyp) {
        return AttrValue.newBuilder().setType(dtyp).build();
    }

    public String stringAttr(NodeDef node, String key) {
        return node.getAttrMap().get(key).getS().toStringUtf8();
    }

    private AttrValue shapeAttr(Seq<Object> shape) {
        TensorShapeProto.Builder attr = TensorShapeProto.newBuilder();
        shape.foreach((Function1)new Serializable(attr){
            public static final long serialVersionUID = 0L;
            private final TensorShapeProto.Builder attr$1;

            public final TensorShapeProto.Builder apply(int dim) {
                return this.attr$1.addDim(TensorShapeProto.Dim.newBuilder().setSize(dim));
            }
            {
                this.attr$1 = attr$1;
            }
        });
        return AttrValue.newBuilder().setShape(attr).build();
    }

    /*
     * WARNING - void declaration
     */
    public AttrValue com$intel$analytics$bigdl$dllib$utils$tf$Tensorflow$$getDataType(NodeDef node) {
        void var2_2;
        AttrValue attr = node.getAttrOrDefault("dtype", null);
        if (attr == null) {
            attr = node.getAttrOrDefault("out_type", null);
            if (attr == null) {
                attr = node.getAttrOrDefault("T", null);
                if (attr == null) {
                    Log4Error$.MODULE$.invalidOperationError(false, "TensorflowSaver: Can not find data type", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                    return var2_2;
                }
                return var2_2;
            }
            return var2_2;
        }
        return var2_2;
    }

    private PaddingType getPaddingType(int padW, int padH, int kW, int kH, int sW, int sH) {
        if (padW == 0 && padH == 0) {
            return PaddingType$PADDING_VALID$.MODULE$;
        }
        return PaddingType$PADDING_SAME$.MODULE$;
    }

    public AttrValue kernelAttr(int kW, int kH, TensorflowDataFormat dataFormat) {
        TensorflowDataFormat tensorflowDataFormat = dataFormat;
        TensorflowDataFormat$NHWC$ tensorflowDataFormat$NHWC$ = TensorflowDataFormat$NHWC$.MODULE$;
        Seq kSize = !(tensorflowDataFormat != null ? !tensorflowDataFormat.equals(tensorflowDataFormat$NHWC$) : tensorflowDataFormat$NHWC$ != null) ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, kH, kW, 1})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 1, kH, kW}));
        return this.listIntAttr((Seq<Object>)kSize);
    }

    public AttrValue strideAttr(int sW, int sH, TensorflowDataFormat dataFormat) {
        TensorflowDataFormat tensorflowDataFormat = dataFormat;
        TensorflowDataFormat$NHWC$ tensorflowDataFormat$NHWC$ = TensorflowDataFormat$NHWC$.MODULE$;
        Seq sSize = !(tensorflowDataFormat != null ? !tensorflowDataFormat.equals(tensorflowDataFormat$NHWC$) : tensorflowDataFormat$NHWC$ != null) ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, sH, sW, 1})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 1, sH, sW}));
        return this.listIntAttr((Seq<Object>)sSize);
    }

    private Tensorflow$() {
        MODULE$ = this;
    }
}

