/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.utils.tf;

import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericBoolean$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericDouble$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericFloat$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericInt$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericLong$;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.tf.TFRecordIterator;
import com.intel.analytics.bigdl.dllib.utils.tf.TFRecordIterator$;
import com.intel.analytics.bigdl.dllib.utils.tf.TFRecordOutputFormat;
import com.intel.analytics.bigdl.dllib.utils.tf.TFTensorNumeric$NumericByteString$;
import com.intel.analytics.shaded.protobuf_v_3_5_1.ByteString;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.tensorflow.framework.DataType;
import org.tensorflow.framework.TensorProto;
import org.tensorflow.framework.TensorShapeProto;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class TFUtils$ {
    public static final TFUtils$ MODULE$;

    static {
        new TFUtils$();
    }

    public void saveToHDFS(Seq<String> localFiles, String outputPath, int numPartitions, SparkContext sc) {
        Seq result2 = (Seq)localFiles.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final TFRecordIterator apply(String file) {
                void var2_2;
                TFRecordIterator iter = TFRecordIterator$.MODULE$.apply(new File(file));
                return var2_2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        RDD x$11 = sc.parallelize(result2, numPartitions, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<BytesWritable, NullWritable> apply(byte[] bytes) {
                return new Tuple2((Object)new BytesWritable(bytes), (Object)NullWritable.get());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag x$12 = ClassTag$.MODULE$.apply(BytesWritable.class);
        ClassTag x$13 = ClassTag$.MODULE$.apply(NullWritable.class);
        RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$11);
        Object x$14 = null;
        RDD$.MODULE$.rddToPairRDDFunctions(x$11, x$12, x$13, null).saveAsNewAPIHadoopFile(outputPath, ClassTag$.MODULE$.apply(TFRecordOutputFormat.class));
    }

    private Tensor<? extends Object> parseTensorFromContent(DataType dataType, byte[] content, int[] shape, ByteOrder endian) {
        Tensor<Object> tensor;
        DataType dataType2 = dataType;
        if (DataType.DT_FLOAT.equals(dataType2)) {
            ByteBuffer buffer = ByteBuffer.wrap(content);
            buffer.order(endian);
            FloatBuffer params = buffer.asFloatBuffer();
            float[] tmp = new float[params.capacity()];
            for (int j = 0; j < params.capacity(); ++j) {
                tmp[j] = params.get(j);
            }
            tensor = Tensor$.MODULE$.apply(tmp, shape, ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
        } else if (DataType.DT_DOUBLE.equals(dataType2)) {
            ByteBuffer buffer = ByteBuffer.wrap(content);
            buffer.order(endian);
            DoubleBuffer params = buffer.asDoubleBuffer();
            double[] tmp = new double[params.capacity()];
            for (int j = 0; j < params.capacity(); ++j) {
                tmp[j] = params.get(j);
            }
            tensor = Tensor$.MODULE$.apply(tmp, shape, ClassTag$.MODULE$.Double(), TensorNumericMath$TensorNumeric$NumericDouble$.MODULE$);
        } else if (DataType.DT_INT32.equals(dataType2)) {
            ByteBuffer buffer = ByteBuffer.wrap(content);
            buffer.order(endian);
            IntBuffer params = buffer.asIntBuffer();
            int[] tmp = new int[params.capacity()];
            for (int j = 0; j < params.capacity(); ++j) {
                tmp[j] = params.get(j);
            }
            tensor = Tensor$.MODULE$.apply(tmp, shape, ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$);
        } else if (DataType.DT_INT64.equals(dataType2)) {
            ByteBuffer buffer = ByteBuffer.wrap(content);
            buffer.order(endian);
            LongBuffer params = buffer.asLongBuffer();
            long[] tmp = new long[params.capacity()];
            for (int j = 0; j < params.capacity(); ++j) {
                tmp[j] = params.get(j);
            }
            tensor = Tensor$.MODULE$.apply(tmp, shape, ClassTag$.MODULE$.Long(), TensorNumericMath$TensorNumeric$NumericLong$.MODULE$);
        } else if (DataType.DT_INT8.equals(dataType2)) {
            ByteBuffer buffer = ByteBuffer.wrap(content);
            buffer.order(endian);
            ByteBuffer params = buffer;
            int[] tmp = new int[params.capacity()];
            for (int j = 0; j < params.capacity(); ++j) {
                tmp[j] = params.get(j);
            }
            tensor = Tensor$.MODULE$.apply(tmp, shape, ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$);
        } else if (DataType.DT_UINT8.equals(dataType2)) {
            ByteBuffer buffer = ByteBuffer.wrap(content);
            buffer.order(endian);
            ByteBuffer params = buffer;
            int[] tmp = new int[params.capacity()];
            for (int j = 0; j < params.capacity(); ++j) {
                tmp[j] = params.get(j) & 0xFF;
            }
            tensor = Tensor$.MODULE$.apply(tmp, shape, ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$);
        } else if (DataType.DT_INT16.equals(dataType2)) {
            ByteBuffer buffer = ByteBuffer.wrap(content);
            buffer.order(endian);
            ShortBuffer params = buffer.asShortBuffer();
            int[] tmp = new int[params.capacity()];
            for (int j = 0; j < params.capacity(); ++j) {
                tmp[j] = params.get(j);
            }
            tensor = Tensor$.MODULE$.apply(tmp, shape, ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$);
        } else if (DataType.DT_UINT16.equals(dataType2)) {
            ByteBuffer buffer = ByteBuffer.wrap(content);
            buffer.order(endian);
            ShortBuffer params = buffer.asShortBuffer();
            int[] tmp = new int[params.capacity()];
            for (int j = 0; j < params.capacity(); ++j) {
                tmp[j] = params.get(j) & 0xFFFF;
            }
            tensor = Tensor$.MODULE$.apply(tmp, shape, ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$);
        } else if (DataType.DT_BOOL.equals(dataType2)) {
            ByteBuffer buffer = ByteBuffer.wrap(content);
            buffer.order(endian);
            ByteBuffer params = buffer;
            boolean[] tmp = new boolean[params.capacity()];
            for (int j = 0; j < params.capacity(); ++j) {
                tmp[j] = params.get(j) != 0;
            }
            tensor = Tensor$.MODULE$.apply(tmp, shape, ClassTag$.MODULE$.Boolean(), TensorNumericMath$TensorNumeric$NumericBoolean$.MODULE$);
        } else {
            Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DataType: ", " not supported yet"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType2})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            tensor = null;
        }
        return tensor;
    }

    private Tensor<? super Object> parseTensorFromField(TensorProto tfTensor, int[] shape, ByteOrder endian) {
        Tensor<Object> tensor;
        DataType dataType = tfTensor.getDtype();
        if (DataType.DT_FLOAT.equals(dataType)) {
            float[] tmp = (float[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tfTensor.getFloatValList()).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final float apply(Float x$1) {
                    return Predef$.MODULE$.Float2float(x$1);
                }
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Float());
            tensor = Tensor$.MODULE$.apply(tmp, shape, ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
        } else if (DataType.DT_DOUBLE.equals(dataType)) {
            double[] tmp = (double[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tfTensor.getDoubleValList()).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(Double x$2) {
                    return Predef$.MODULE$.Double2double(x$2);
                }
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            tensor = Tensor$.MODULE$.apply(tmp, shape, ClassTag$.MODULE$.Double(), TensorNumericMath$TensorNumeric$NumericDouble$.MODULE$);
        } else if (DataType.DT_INT32.equals(dataType)) {
            int[] tmp = (int[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tfTensor.getIntValList()).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Integer x$3) {
                    return Predef$.MODULE$.Integer2int(x$3);
                }
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
            tensor = Tensor$.MODULE$.apply(tmp, shape, ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$);
        } else if (DataType.DT_INT64.equals(dataType)) {
            long[] tmp = (long[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tfTensor.getInt64ValList()).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(Long x$4) {
                    return Predef$.MODULE$.Long2long(x$4);
                }
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long());
            tensor = Tensor$.MODULE$.apply(tmp, shape, ClassTag$.MODULE$.Long(), TensorNumericMath$TensorNumeric$NumericLong$.MODULE$);
        } else if (DataType.DT_BOOL.equals(dataType)) {
            boolean[] tmp = (boolean[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tfTensor.getBoolValList()).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Boolean x$5) {
                    return x$5;
                }
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
            tensor = Tensor$.MODULE$.apply(tmp, shape, ClassTag$.MODULE$.Boolean(), TensorNumericMath$TensorNumeric$NumericBoolean$.MODULE$);
        } else if (DataType.DT_STRING.equals(dataType)) {
            ByteString[] tmp = (ByteString[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(tfTensor.getStringValList()).asScala()).toArray(ClassTag$.MODULE$.apply(ByteString.class));
            tensor = Tensor$.MODULE$.apply(tmp, shape, ClassTag$.MODULE$.apply(ByteString.class), TFTensorNumeric$NumericByteString$.MODULE$);
        } else if (DataType.DT_INT8.equals(dataType)) {
            int[] tmp = (int[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tfTensor.getIntValList()).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Integer x$6) {
                    return Predef$.MODULE$.Integer2int(x$6);
                }
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
            tensor = Tensor$.MODULE$.apply(tmp, shape, ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$);
        } else if (DataType.DT_UINT8.equals(dataType)) {
            int[] tmp = (int[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tfTensor.getIntValList()).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Integer x$7) {
                    return Predef$.MODULE$.Integer2int(x$7);
                }
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
            tensor = Tensor$.MODULE$.apply(tmp, shape, ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$);
        } else if (DataType.DT_INT16.equals(dataType)) {
            int[] tmp = (int[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tfTensor.getIntValList()).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Integer x$8) {
                    return Predef$.MODULE$.Integer2int(x$8);
                }
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
            tensor = Tensor$.MODULE$.apply(tmp, shape, ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$);
        } else if (DataType.DT_UINT16.equals(dataType)) {
            int[] tmp = (int[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tfTensor.getIntValList()).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Integer x$9) {
                    return Predef$.MODULE$.Integer2int(x$9);
                }
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
            tensor = Tensor$.MODULE$.apply(tmp, shape, ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$);
        } else {
            Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DataType: ", " not supported yet"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            tensor = null;
        }
        return tensor;
    }

    public Tensor<?> parseTensor(TensorProto tfTensor, ByteOrder endian) {
        int[] shape = (int[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tfTensor.getTensorShape().getDimList()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(TensorShapeProto.Dim x$10) {
                return (int)x$10.getSize();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        return tfTensor.getTensorContent().isEmpty() ? this.parseTensorFromField(tfTensor, shape, endian) : this.parseTensorFromContent(tfTensor.getDtype(), tfTensor.getTensorContent().toByteArray(), shape, endian);
    }

    private TFUtils$() {
        MODULE$ = this;
    }
}

