/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.utils.serializer.converters;

import com.intel.analytics.bigdl.dllib.nn.quantized.ConvDataParams$;
import com.intel.analytics.bigdl.dllib.nn.quantized.ConvWeightParams$;
import com.intel.analytics.bigdl.dllib.nn.quantized.DescParams;
import com.intel.analytics.bigdl.dllib.nn.quantized.LinearDataParams$;
import com.intel.analytics.bigdl.dllib.nn.quantized.LinearWeightParams$;
import com.intel.analytics.bigdl.dllib.tensor.ConvertableFrom$ConvertableFromFloat$;
import com.intel.analytics.bigdl.dllib.tensor.DenseType$;
import com.intel.analytics.bigdl.dllib.tensor.QuantizedTensor;
import com.intel.analytics.bigdl.dllib.tensor.QuantizedTensor$;
import com.intel.analytics.bigdl.dllib.tensor.QuantizedType$;
import com.intel.analytics.bigdl.dllib.tensor.Storage;
import com.intel.analytics.bigdl.dllib.tensor.Storage$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericBoolean$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericChar$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericDouble$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericFloat$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericInt$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericLong$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericShort$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericString$;
import com.intel.analytics.bigdl.dllib.tensor.TensorType;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.serializer.BigDLStorage$;
import com.intel.analytics.bigdl.dllib.utils.serializer.DeserializeContext;
import com.intel.analytics.bigdl.dllib.utils.serializer.ProtoStorageType$;
import com.intel.analytics.bigdl.dllib.utils.serializer.SerializeContext;
import com.intel.analytics.bigdl.dllib.utils.serializer.StorageType;
import com.intel.analytics.bigdl.dllib.utils.serializer.converters.BigDLTensorStorageManager$;
import com.intel.analytics.bigdl.dllib.utils.serializer.converters.DataConverter;
import com.intel.analytics.bigdl.dllib.utils.serializer.converters.DataConverter$class;
import com.intel.analytics.bigdl.dllib.utils.serializer.converters.ProtoTensorStorageManager$;
import com.intel.analytics.bigdl.dllib.utils.tf.TFTensorNumeric$NumericByteString$;
import com.intel.analytics.bigdl.serialization.Bigdl;
import com.intel.analytics.shaded.protobuf_v_3_5_1.ByteString;
import java.util.List;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.Types;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class TensorConverter$
implements DataConverter {
    public static final TensorConverter$ MODULE$;

    static {
        new TensorConverter$();
    }

    @Override
    public Object getLock() {
        return DataConverter$class.getLock(this);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isEmptyTensor(Tensor<?> tensor) {
        void var2_4;
        boolean bl;
        TensorType tensorType = tensor.getTensorType();
        if (DenseType$.MODULE$.equals(tensorType)) {
            bl = tensor.storage() == null;
        } else if (QuantizedType$.MODULE$.equals(tensorType)) {
            bl = ((QuantizedTensor)tensor).getStorage() == null;
        } else {
            Log4Error$.MODULE$.invalidInputError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tensor.getTensorType()})), "only support DenseType and QuantizedType");
            bl = false;
        }
        boolean emptyTensor = bl;
        return (boolean)var2_4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> Object getAttributeValue(DeserializeContext context, Bigdl.AttrValue attribute, ClassTag<T> evidence$1, TensorNumericMath.TensorNumeric<T> ev) {
        Tensor<Object> tensor;
        int tensorId;
        Bigdl.BigDLTensor serializedTensor = attribute.getTensorValue();
        if (!serializedTensor.hasStorage()) return null;
        HashMap<Object, Object> storages = context.storages();
        if (storages.contains((Object)BoxesRunTime.boxToInteger((int)(tensorId = serializedTensor.getId())))) {
            return storages.get((Object)BoxesRunTime.boxToInteger((int)tensorId)).get();
        }
        Bigdl.DataType dataType = serializedTensor.getDatatype();
        Bigdl.TensorType tensorType = serializedTensor.getTensorType();
        int[] sizes = (int[])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(serializedTensor.getSizeList()).asScala()).toArray(ClassTag$.MODULE$.apply(Integer.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$1) {
                return x$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        int[] strides = (int[])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(serializedTensor.getStrideList()).asScala()).toArray(ClassTag$.MODULE$.apply(Integer.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$2) {
                return x$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        int offSet = serializedTensor.getOffset();
        boolean isScalr = serializedTensor.getIsScalar();
        Bigdl.TensorStorage serializedStorage = serializedTensor.getStorage();
        int storageId = serializedStorage.getId();
        Object created = storages.contains((Object)BoxesRunTime.boxToInteger((int)storageId)) ? storages.get((Object)BoxesRunTime.boxToInteger((int)storageId)).get() : null;
        Bigdl.DataType dataType2 = dataType;
        if (Bigdl.DataType.FLOAT.equals(dataType2)) {
            Tensor<Object> tensor2;
            Bigdl.TensorType tensorType2 = tensorType;
            if (Bigdl.TensorType.DENSE.equals(tensorType2)) {
                Storage storage;
                if (created == null) {
                    if (storageId == -1) {
                        storage = null;
                    } else {
                        float[] data2 = (float[])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(serializedStorage.getFloatDataList()).asScala()).toArray(ClassTag$.MODULE$.apply(Float.class))).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final float apply(Float x$5) {
                                return x$5.floatValue();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                        Storage newStorage = Storage$.MODULE$.apply(data2, ClassTag$.MODULE$.Float());
                        storages.update((Object)BoxesRunTime.boxToInteger((int)storageId), newStorage);
                        storage = newStorage;
                    }
                } else {
                    storage = (Storage)created;
                }
                Storage storage2 = storage;
                tensor2 = Tensor$.MODULE$.apply(storage2, offSet, sizes, strides, ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
            } else {
                if (!Bigdl.TensorType.QUANT.equals(tensorType2)) throw new MatchError((Object)tensorType2);
                tensor2 = this.quant$1(context, evidence$1, ev, dataType, sizes, serializedStorage, created);
            }
            tensor = tensor2;
        } else if (Bigdl.DataType.DOUBLE.equals(dataType2)) {
            Storage storage;
            if (created == null) {
                if (storageId == -1) {
                    storage = null;
                } else {
                    double[] data3 = (double[])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(serializedStorage.getDoubleDataList()).asScala()).toArray(ClassTag$.MODULE$.apply(Double.class))).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final double apply(Double x$6) {
                            return x$6;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                    Storage newStorage = Storage$.MODULE$.apply(data3, ClassTag$.MODULE$.Double());
                    storages.update((Object)BoxesRunTime.boxToInteger((int)storageId), newStorage);
                    storage = newStorage;
                }
            } else {
                storage = (Storage)created;
            }
            Storage storage3 = storage;
            tensor = Tensor$.MODULE$.apply(storage3, offSet, sizes, strides, ClassTag$.MODULE$.Double(), TensorNumericMath$TensorNumeric$NumericDouble$.MODULE$);
        } else if (Bigdl.DataType.BOOL.equals(dataType2)) {
            Storage storage;
            if (created == null) {
                if (storageId == -1) {
                    storage = null;
                } else {
                    boolean[] data4 = (boolean[])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(serializedStorage.getBoolDataList()).asScala()).toArray(ClassTag$.MODULE$.apply(Boolean.class))).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Boolean x$7) {
                            return x$7;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()));
                    Storage newStorage = Storage$.MODULE$.apply(data4, ClassTag$.MODULE$.Boolean());
                    storages.update((Object)BoxesRunTime.boxToInteger((int)storageId), newStorage);
                    storage = newStorage;
                }
            } else {
                storage = (Storage)created;
            }
            Storage storage4 = storage;
            tensor = Tensor$.MODULE$.apply(storage4, offSet, sizes, strides, ClassTag$.MODULE$.Boolean(), TensorNumericMath$TensorNumeric$NumericBoolean$.MODULE$);
        } else if (Bigdl.DataType.CHAR.equals(dataType2)) {
            Storage storage;
            if (created == null) {
                if (storageId == -1) {
                    storage = null;
                } else {
                    char[] data5 = (char[])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(serializedStorage.getIntDataList()).asScala()).toArray(ClassTag$.MODULE$.apply(Integer.class))).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final char apply(Integer x$8) {
                            return Predef$.MODULE$.char2Character((char)Predef$.MODULE$.Integer2int(x$8)).charValue();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Char()));
                    Storage newStorage = Storage$.MODULE$.apply(data5, ClassTag$.MODULE$.Char());
                    storages.update((Object)BoxesRunTime.boxToInteger((int)storageId), newStorage);
                    storage = newStorage;
                }
            } else {
                storage = (Storage)created;
            }
            Storage storage5 = storage;
            tensor = Tensor$.MODULE$.apply(storage5, offSet, sizes, strides, ClassTag$.MODULE$.Char(), TensorNumericMath$TensorNumeric$NumericChar$.MODULE$);
        } else if (Bigdl.DataType.STRING.equals(dataType2)) {
            Storage storage;
            if (created == null) {
                if (storageId == -1) {
                    storage = null;
                } else {
                    String[] data6 = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((List)serializedStorage.getStringDataList()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
                    Storage newStorage = Storage$.MODULE$.apply(data6, ClassTag$.MODULE$.apply(String.class));
                    storages.update((Object)BoxesRunTime.boxToInteger((int)storageId), newStorage);
                    storage = newStorage;
                }
            } else {
                storage = (Storage)created;
            }
            Storage storage6 = storage;
            tensor = Tensor$.MODULE$.apply(storage6, offSet, sizes, strides, ClassTag$.MODULE$.apply(String.class), TensorNumericMath$TensorNumeric$NumericString$.MODULE$);
        } else if (Bigdl.DataType.INT32.equals(dataType2)) {
            Storage storage;
            if (created == null) {
                if (storageId == -1) {
                    storage = null;
                } else {
                    int[] data7 = (int[])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(serializedStorage.getIntDataList()).asScala()).toArray(ClassTag$.MODULE$.apply(Integer.class))).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Integer x$9) {
                            return x$9;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                    Storage newStorage = Storage$.MODULE$.apply(data7, ClassTag$.MODULE$.Int());
                    storages.update((Object)BoxesRunTime.boxToInteger((int)storageId), newStorage);
                    storage = newStorage;
                }
            } else {
                storage = (Storage)created;
            }
            Storage storage7 = storage;
            tensor = Tensor$.MODULE$.apply(storage7, offSet, sizes, strides, ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$);
        } else if (Bigdl.DataType.SHORT.equals(dataType2)) {
            Storage storage;
            if (created == null) {
                if (storageId == -1) {
                    storage = null;
                } else {
                    short[] data8 = (short[])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(serializedStorage.getIntDataList()).asScala()).toArray(ClassTag$.MODULE$.apply(Integer.class))).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final short apply(Integer x$10) {
                            return x$10.shortValue();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Short()));
                    Storage newStorage = Storage$.MODULE$.apply(data8, ClassTag$.MODULE$.Short());
                    storages.update((Object)BoxesRunTime.boxToInteger((int)storageId), newStorage);
                    storage = newStorage;
                }
            } else {
                storage = (Storage)created;
            }
            Storage storage8 = storage;
            tensor = Tensor$.MODULE$.apply(storage8, offSet, sizes, strides, ClassTag$.MODULE$.Short(), TensorNumericMath$TensorNumeric$NumericShort$.MODULE$);
        } else if (Bigdl.DataType.INT64.equals(dataType2)) {
            Storage storage;
            if (created == null) {
                if (storageId == -1) {
                    storage = null;
                } else {
                    long[] data9 = (long[])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(serializedStorage.getLongDataList()).asScala()).toArray(ClassTag$.MODULE$.apply(Long.class))).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Long x$11) {
                            return x$11;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
                    Storage newStorage = Storage$.MODULE$.apply(data9, ClassTag$.MODULE$.Long());
                    storages.update((Object)BoxesRunTime.boxToInteger((int)storageId), newStorage);
                    storage = newStorage;
                }
            } else {
                storage = (Storage)created;
            }
            Storage storage9 = storage;
            tensor = Tensor$.MODULE$.apply(storage9, offSet, sizes, strides, ClassTag$.MODULE$.Long(), TensorNumericMath$TensorNumeric$NumericLong$.MODULE$);
        } else if (Bigdl.DataType.BYTES.equals(dataType2)) {
            Storage storage;
            if (created == null) {
                if (storageId == -1) {
                    storage = null;
                } else {
                    ByteString[] data10 = (ByteString[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(serializedStorage.getBytesDataList()).asScala()).toArray(ClassTag$.MODULE$.apply(ByteString.class));
                    Storage newStorage = Storage$.MODULE$.apply(data10, ClassTag$.MODULE$.apply(ByteString.class));
                    storages.update((Object)BoxesRunTime.boxToInteger((int)storageId), newStorage);
                    storage = newStorage;
                }
            } else {
                storage = (Storage)created;
            }
            Storage storage10 = storage;
            tensor = Tensor$.MODULE$.apply(storage10, offSet, sizes, strides, ClassTag$.MODULE$.apply(ByteString.class), TFTensorNumeric$NumericByteString$.MODULE$);
        } else {
            Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " not supported in tensor now !"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            tensor = null;
        }
        Tensor<Object> tensor3 = tensor;
        storages.update((Object)BoxesRunTime.boxToInteger((int)tensorId), tensor3);
        return tensor3;
    }

    private <T> void setStorage(SerializeContext<T> context, Bigdl.BigDLTensor.Builder tensorBuilder, Tensor<?> tensor, ClassTag<T> evidence$2) {
        StorageType storageType;
        StorageType storageType2 = storageType = context.storageType();
        ProtoStorageType$ protoStorageType$ = ProtoStorageType$.MODULE$;
        if (!(storageType2 != null ? !storageType2.equals(protoStorageType$) : protoStorageType$ != null)) {
            ProtoTensorStorageManager$.MODULE$.setStorage(context, tensorBuilder, tensor, evidence$2);
        } else {
            StorageType storageType3 = storageType;
            BigDLStorage$ bigDLStorage$ = BigDLStorage$.MODULE$;
            if (!(storageType3 != null ? !storageType3.equals(bigDLStorage$) : bigDLStorage$ != null)) {
                BigDLTensorStorageManager$.MODULE$.setStorage(context, tensorBuilder, tensor, evidence$2);
            } else {
                Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{storageType})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            }
        }
    }

    @Override
    public <T> void setAttributeValue(SerializeContext<T> context, Bigdl.AttrValue.Builder attributeBuilder, Object value2, Types.TypeApi valueType, ClassTag<T> evidence$3, TensorNumericMath.TensorNumeric<T> ev) {
        attributeBuilder.setDataType(Bigdl.DataType.TENSOR);
        if (value2 != null) {
            Tensor tensor = (Tensor)value2;
            int tensorId = System.identityHashCode(tensor);
            HashMap<Object, Object> storages = context.storages();
            if (storages.contains((Object)BoxesRunTime.boxToInteger((int)tensorId))) {
                attributeBuilder.setTensorValue(this.resetTensor((Bigdl.BigDLTensor)storages.get((Object)BoxesRunTime.boxToInteger((int)tensorId)).get()));
            } else {
                Bigdl.BigDLTensor.Builder builder;
                int totalElement = tensor.nElement();
                int dimension = tensor.dim();
                Bigdl.BigDLTensor.Builder tensorBuilder = Bigdl.BigDLTensor.newBuilder();
                tensorBuilder.setId(tensorId);
                tensorBuilder.setDimension(dimension);
                tensorBuilder.setNElements(totalElement);
                TensorType tensorType = tensor.getTensorType();
                if (DenseType$.MODULE$.equals(tensorType)) {
                    tensorBuilder.setOffset(tensor.storageOffset());
                    tensorBuilder.setIsScalar(tensor.isScalar());
                    builder = tensorBuilder.setTensorType(Bigdl.TensorType.DENSE);
                } else if (QuantizedType$.MODULE$.equals(tensorType)) {
                    builder = tensorBuilder.setTensorType(Bigdl.TensorType.QUANT);
                } else {
                    Log4Error$.MODULE$.invalidInputError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tensor.getTensorType()})), "only support DenseType and QuantizedType");
                    builder = BoxedUnit.UNIT;
                }
                boolean tensorEmpty = this.isEmptyTensor(tensor);
                if (!tensorEmpty) {
                    Predef$.MODULE$.intArrayOps(tensor.size()).foreach((Function1)new Serializable(tensorBuilder){
                        public static final long serialVersionUID = 0L;
                        private final Bigdl.BigDLTensor.Builder tensorBuilder$1;

                        public final Bigdl.BigDLTensor.Builder apply(int size) {
                            return this.tensorBuilder$1.addSize(size);
                        }
                        {
                            this.tensorBuilder$1 = tensorBuilder$1;
                        }
                    });
                    Predef$.MODULE$.intArrayOps(tensor.stride()).foreach((Function1)new Serializable(tensorBuilder){
                        public static final long serialVersionUID = 0L;
                        private final Bigdl.BigDLTensor.Builder tensorBuilder$1;

                        public final Bigdl.BigDLTensor.Builder apply(int stride) {
                            return this.tensorBuilder$1.addStride(stride);
                        }
                        {
                            this.tensorBuilder$1 = tensorBuilder$1;
                        }
                    });
                }
                this.setStorage(context, tensorBuilder, tensor, evidence$3);
                Bigdl.BigDLTensor tensorBuild = tensorBuilder.build();
                attributeBuilder.setTensorValue(this.resetTensor(tensorBuild));
                storages.update((Object)BoxesRunTime.boxToInteger((int)tensorId), (Object)tensorBuild);
            }
        }
    }

    @Override
    public <T> Types.TypeApi setAttributeValue$default$4() {
        return null;
    }

    private Bigdl.TensorStorage resetStorage(Bigdl.TensorStorage originStorage) {
        Bigdl.TensorStorage.Builder storageBuilder = Bigdl.TensorStorage.newBuilder();
        storageBuilder.setDatatype(originStorage.getDatatype());
        storageBuilder.setId(originStorage.getId());
        return storageBuilder.build();
    }

    private Bigdl.BigDLTensor resetTensor(Bigdl.BigDLTensor originTensor) {
        Bigdl.BigDLTensor.Builder tensorBuilder = Bigdl.BigDLTensor.newBuilder(originTensor);
        tensorBuilder.clearStorage();
        tensorBuilder.setDatatype(originTensor.getDatatype());
        tensorBuilder.setId(originTensor.getId());
        Object object = originTensor.hasStorage() ? tensorBuilder.setStorage(this.resetStorage(originTensor.getStorage())) : BoxedUnit.UNIT;
        return tensorBuilder.build();
    }

    private final Tensor quant$1(DeserializeContext context$1, ClassTag evidence$1$1, TensorNumericMath.TensorNumeric ev$1, Bigdl.DataType dataType$1, int[] sizes$1, Bigdl.TensorStorage serializedStorage$1, Object created$1) {
        Object object;
        byte[] bytes = null;
        StorageType storageType = context$1.storageType();
        ProtoStorageType$ protoStorageType$ = ProtoStorageType$.MODULE$;
        if (!(storageType != null ? !storageType.equals(protoStorageType$) : protoStorageType$ != null)) {
            bytes = ((ByteString)Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(serializedStorage$1.getBytesDataList()).asScala()).toArray(ClassTag$.MODULE$.apply(ByteString.class))).head()).toByteArray();
            object = BoxedUnit.UNIT;
        } else {
            object = created$1;
        }
        int[] serializedParams = (int[])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(serializedStorage$1.getIntDataList()).asScala()).toArray(ClassTag$.MODULE$.apply(Integer.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$3) {
                return x$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        int paramsNum = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(serializedParams).head());
        int[] paramsArray = (int[])Predef$.MODULE$.intArrayOps(serializedParams).slice(1, paramsNum + 1);
        int descTypeEnum = serializedParams[1 + paramsNum];
        int start2 = paramsNum + 2;
        int length = sizes$1.length == 1 ? 1 : sizes$1[0];
        Object max2 = evidence$1$1.newArray(length);
        Object min2 = evidence$1$1.newArray(length);
        Object sum2 = evidence$1$1.newArray(length);
        Bigdl.DataType dataType = dataType$1;
        if (Bigdl.DataType.FLOAT.equals(dataType)) {
            float[] data2 = (float[])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(serializedStorage$1.getFloatDataList()).asScala()).toArray(ClassTag$.MODULE$.apply(Float.class))).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final float apply(Float x$4) {
                    return x$4.floatValue();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
            for (int i = 0; i < length; ++i) {
                ScalaRunTime$.MODULE$.array_update(max2, i, ev$1.fromType(BoxesRunTime.boxToFloat((float)data2[i]), ConvertableFrom$ConvertableFromFloat$.MODULE$));
                ScalaRunTime$.MODULE$.array_update(min2, i, ev$1.fromType(BoxesRunTime.boxToFloat((float)data2[i + length]), ConvertableFrom$ConvertableFromFloat$.MODULE$));
                ScalaRunTime$.MODULE$.array_update(sum2, i, ev$1.fromType(BoxesRunTime.boxToFloat((float)data2[i + 2 * length]), ConvertableFrom$ConvertableFromFloat$.MODULE$));
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            DescParams params = null;
            int n = descTypeEnum;
            switch (n) {
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
                case 3: {
                    params = LinearWeightParams$.MODULE$.apply(paramsArray);
                    break;
                }
                case 2: {
                    params = LinearDataParams$.MODULE$.apply(paramsArray);
                    break;
                }
                case 1: {
                    params = ConvWeightParams$.MODULE$.apply(paramsArray);
                    break;
                }
                case 0: {
                    params = ConvDataParams$.MODULE$.apply(paramsArray);
                }
            }
            return QuantizedTensor$.MODULE$.apply(bytes, max2, min2, sum2, sizes$1, params, evidence$1$1, ev$1);
        }
        throw new MatchError((Object)dataType);
    }

    private TensorConverter$() {
        MODULE$ = this;
        DataConverter$class.$init$(this);
    }
}

