/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.utils.intermediate;

import com.intel.analytics.bigdl.dllib.nn.Graph;
import com.intel.analytics.bigdl.dllib.nn.StaticGraph;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.AbstractModule;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.Activity;
import com.intel.analytics.bigdl.dllib.nn.mkldnn.DnnGraph;
import com.intel.analytics.bigdl.dllib.nn.mkldnn.MklDnnContainer;
import com.intel.analytics.bigdl.dllib.nn.mkldnn.MklDnnModule;
import com.intel.analytics.bigdl.dllib.nn.quantized.Quantization$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.utils.Engine$;
import com.intel.analytics.bigdl.dllib.utils.EngineType;
import com.intel.analytics.bigdl.dllib.utils.MklDnn$;
import com.intel.analytics.bigdl.dllib.utils.intermediate.IRGraph;
import org.apache.spark.rdd.RDD;
import scala.Option;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ClassTag;

public final class ConversionUtils$ {
    public static final ConversionUtils$ MODULE$;

    static {
        new ConversionUtils$();
    }

    /*
     * Enabled aggressive block sorting
     */
    public <T> AbstractModule<Activity, Activity, T> convert(AbstractModule<Activity, Activity, T> model, ClassTag<T> evidence$1) {
        IRGraph iRGraph;
        if (model instanceof IRGraph) {
            IRGraph g2 = model;
            if (g2.isBuild()) {
                iRGraph = g2;
                return iRGraph;
            }
            iRGraph = g2.build();
            return iRGraph;
        }
        if (!(model instanceof MklDnnModule)) {
            EngineType engineType = Engine$.MODULE$.getEngineType();
            MklDnn$ mklDnn$ = MklDnn$.MODULE$;
            if (!(engineType != null ? !engineType.equals(mklDnn$) : mklDnn$ != null)) {
                IRGraph m3 = model instanceof Graph ? model : model.toGraph(Nil$.MODULE$);
                if (!(m3 instanceof StaticGraph)) return model;
                IRGraph ir = ((StaticGraph)((Object)m3)).toIRgraph();
                AbstractModule abstractModule = model.isTraining() ? ((AbstractModule)ir).training() : ((AbstractModule)ir).evaluate();
                iRGraph = ir;
                return iRGraph;
            }
        }
        iRGraph = model;
        return iRGraph;
    }

    public <T> AbstractModule<Activity, Activity, T> convert(AbstractModule<Activity, Activity, T> model, boolean needQuantize, ClassTag<T> evidence$2, TensorNumericMath.TensorNumeric<T> ev) {
        AbstractModule<Activity, Activity, T> convertedModel = this.convert(model, evidence$2);
        return this.getInt8ModelIfNeeded(convertedModel, needQuantize, evidence$2, ev);
    }

    public <T> RDD<T> coalesce(RDD<T> dataset, ClassTag<T> evidence$3) {
        RDD rDD;
        if (dataset.partitions().length != Engine$.MODULE$.nodeNumber() && !Engine$.MODULE$.isMultiModels()) {
            int x$1 = Engine$.MODULE$.nodeNumber();
            boolean x$2 = false;
            Option x$3 = dataset.coalesce$default$3();
            Ordering x$4 = dataset.coalesce$default$4(x$1, x$2, x$3);
            rDD = dataset.coalesce(x$1, x$2, x$3, x$4);
        } else {
            rDD = dataset;
        }
        return rDD;
    }

    private <T> AbstractModule<Activity, Activity, T> getInt8ModelIfNeeded(AbstractModule<Activity, Activity, T> model, boolean needQuantize, ClassTag<T> evidence$4, TensorNumericMath.TensorNumeric<T> ev) {
        AbstractModule abstractModule;
        AbstractModule<Activity, Activity, T> abstractModule2 = model;
        if (abstractModule2 instanceof IRGraph) {
            IRGraph iRGraph = (IRGraph)abstractModule2;
            abstractModule = needQuantize ? iRGraph.setQuantize(true) : iRGraph;
        } else if (abstractModule2 instanceof DnnGraph) {
            DnnGraph dnnGraph = (DnnGraph)abstractModule2;
            abstractModule = needQuantize ? ((DnnGraph)dnnGraph.cloneModule()).setQuantize(true) : dnnGraph;
        } else if (abstractModule2 instanceof MklDnnContainer) {
            MklDnnContainer mklDnnContainer = (MklDnnContainer)((Object)abstractModule2);
            abstractModule = (AbstractModule)((Object)(needQuantize ? ((MklDnnContainer)((Object)((AbstractModule)((Object)mklDnnContainer)).cloneModule())).setQuantize(true) : mklDnnContainer));
        } else {
            abstractModule = needQuantize ? Quantization$.MODULE$.quantize(model, evidence$4, ev) : model;
        }
        return abstractModule;
    }

    private ConversionUtils$() {
        MODULE$ = this;
    }
}

