/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.utils;

import com.intel.analytics.bigdl.dllib.nn.BatchNormalization;
import com.intel.analytics.bigdl.dllib.nn.BatchNormalization$;
import com.intel.analytics.bigdl.dllib.nn.CAddTable$;
import com.intel.analytics.bigdl.dllib.nn.Concat;
import com.intel.analytics.bigdl.dllib.nn.Concat$;
import com.intel.analytics.bigdl.dllib.nn.ConcatTable;
import com.intel.analytics.bigdl.dllib.nn.Dropout;
import com.intel.analytics.bigdl.dllib.nn.Dropout$;
import com.intel.analytics.bigdl.dllib.nn.LeakyReLU;
import com.intel.analytics.bigdl.dllib.nn.LeakyReLU$;
import com.intel.analytics.bigdl.dllib.nn.Linear;
import com.intel.analytics.bigdl.dllib.nn.Linear$;
import com.intel.analytics.bigdl.dllib.nn.LogSoftMax;
import com.intel.analytics.bigdl.dllib.nn.ReLU;
import com.intel.analytics.bigdl.dllib.nn.ReLU$;
import com.intel.analytics.bigdl.dllib.nn.Reshape$;
import com.intel.analytics.bigdl.dllib.nn.Sequential;
import com.intel.analytics.bigdl.dllib.nn.Sequential$;
import com.intel.analytics.bigdl.dllib.nn.SpatialAveragePooling;
import com.intel.analytics.bigdl.dllib.nn.SpatialAveragePooling$;
import com.intel.analytics.bigdl.dllib.nn.SpatialBatchNormalization;
import com.intel.analytics.bigdl.dllib.nn.SpatialBatchNormalization$;
import com.intel.analytics.bigdl.dllib.nn.SpatialConvolution;
import com.intel.analytics.bigdl.dllib.nn.SpatialConvolution$;
import com.intel.analytics.bigdl.dllib.nn.SpatialConvolutionMap;
import com.intel.analytics.bigdl.dllib.nn.SpatialConvolutionMap$;
import com.intel.analytics.bigdl.dllib.nn.SpatialCrossMapLRN;
import com.intel.analytics.bigdl.dllib.nn.SpatialCrossMapLRN$;
import com.intel.analytics.bigdl.dllib.nn.SpatialMaxPooling;
import com.intel.analytics.bigdl.dllib.nn.SpatialMaxPooling$;
import com.intel.analytics.bigdl.dllib.nn.SpatialZeroPadding;
import com.intel.analytics.bigdl.dllib.nn.SpatialZeroPadding$;
import com.intel.analytics.bigdl.dllib.nn.Threshold;
import com.intel.analytics.bigdl.dllib.nn.Threshold$;
import com.intel.analytics.bigdl.dllib.nn.View;
import com.intel.analytics.bigdl.dllib.nn.View$;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.AbstractModule;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.DataFormat;
import com.intel.analytics.bigdl.dllib.tensor.DoubleType$;
import com.intel.analytics.bigdl.dllib.tensor.FloatType$;
import com.intel.analytics.bigdl.dllib.tensor.Storage;
import com.intel.analytics.bigdl.dllib.tensor.Storage$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorDataType;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericDouble$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericFloat$;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.T$;
import com.intel.analytics.bigdl.dllib.utils.Table;
import com.intel.analytics.bigdl.dllib.utils.TorchObject;
import com.intel.analytics.bigdl.dllib.utils.TorchObject$TYPE_BOOLEAN$;
import com.intel.analytics.bigdl.dllib.utils.TorchObject$TYPE_DOUBLE_STORAGE$;
import com.intel.analytics.bigdl.dllib.utils.TorchObject$TYPE_DOUBLE_TENSOR$;
import com.intel.analytics.bigdl.dllib.utils.TorchObject$TYPE_FLOAT_STORAGE$;
import com.intel.analytics.bigdl.dllib.utils.TorchObject$TYPE_FLOAT_TENSOR$;
import com.intel.analytics.bigdl.dllib.utils.TorchObject$TYPE_LONG_STORAGE$;
import com.intel.analytics.bigdl.dllib.utils.TorchObject$TYPE_MODULE$;
import com.intel.analytics.bigdl.dllib.utils.TorchObject$TYPE_NIL$;
import com.intel.analytics.bigdl.dllib.utils.TorchObject$TYPE_NUMBER$;
import com.intel.analytics.bigdl.dllib.utils.TorchObject$TYPE_STRING$;
import com.intel.analytics.bigdl.dllib.utils.TorchObject$TYPE_TABLE$;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

public final class TorchFile$ {
    public static final TorchFile$ MODULE$;
    private int i;

    static {
        new TorchFile$();
    }

    private int i() {
        return this.i;
    }

    private void i_$eq(int x$1) {
        this.i = x$1;
    }

    public <T> T load(String fileName) {
        Path path = Paths.get(fileName, new String[0]);
        ByteBuffer rawData = ByteBuffer.wrap(Files.readAllBytes(path));
        rawData.order(ByteOrder.LITTLE_ENDIAN);
        HashMap objects = new HashMap();
        return (T)this.readObject(rawData, (Map<Object, Object>)objects);
    }

    public void save(Object source, String fileName, TorchObject objectType, boolean overWrite) {
        Boolean bl;
        File file = new File(fileName);
        if (file.exists()) {
            Log4Error$.MODULE$.invalidInputError(file.isFile(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a file"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileName})), Log4Error$.MODULE$.invalidInputError$default$3());
            if (overWrite) {
                FileWriter fw = new FileWriter(file);
                fw.write("");
                fw.close();
            } else {
                Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileName})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            }
            bl = BoxedUnit.UNIT;
        } else {
            bl = BoxesRunTime.boxToBoolean((boolean)file.createNewFile());
        }
        int capacity = 300000;
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.i_$eq(0);
        this.writeObject(source, buffer, file.toPath(), objectType);
    }

    public boolean save$default$4() {
        return false;
    }

    private void flush(ByteBuffer rawData, Path path) {
        if (rawData.capacity() - rawData.position() < 8) {
            this.byteWrite(rawData, path);
        }
    }

    private void byteWrite(ByteBuffer rawData, Path path) {
        Files.write(path, (byte[])Predef$.MODULE$.byteArrayOps(rawData.array()).slice(0, rawData.position()), StandardOpenOption.APPEND);
        rawData.clear();
    }

    private Object createInstanceFor(String className, scala.collection.mutable.Seq<Tuple2<Class<?>, Object>> args) {
        Class[] types = (Class[])((TraversableOnce)args.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<?> apply(Tuple2<Class<?>, Object> x$1) {
                return (Class)x$1._1();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class));
        Object[] values2 = (Object[])((TraversableOnce)args.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Tuple2<Class<?>, Object> x$2) {
                return x$2._2();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.AnyRef());
        Constructor<?> constructor = Class.forName(className).getDeclaredConstructor(types);
        Object obj = constructor.newInstance(values2);
        return obj;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private <T> Object readModuleWithType(String moduleName, Table elements, ClassTag<T> evidence$1, TensorNumericMath.TensorNumeric<T> ev) {
        block5: {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                block15: {
                                                    block14: {
                                                        block13: {
                                                            block12: {
                                                                block11: {
                                                                    block10: {
                                                                        block9: {
                                                                            block8: {
                                                                                block7: {
                                                                                    block6: {
                                                                                        block4: {
                                                                                            bigdlName = moduleName.matches("cudnn.*") != false ? moduleName.replace("cudnn", "nn") : moduleName;
                                                                                            var7_6 = bigdlName;
                                                                                            if (!"nn.BatchNormalization".equals(var7_6)) break block4;
                                                                                            var8_7 = this.readBatchNormalizationWithType(elements, evidence$1, ev);
                                                                                            break block5;
                                                                                        }
                                                                                        if (!"nn.CAddTable".equals(var7_6)) break block6;
                                                                                        var8_7 = CAddTable$.MODULE$.apply(BoxesRunTime.unboxToBoolean((Object)elements.getOrElse("inplace", BoxesRunTime.boxToBoolean((boolean)false))), evidence$1, ev);
                                                                                        break block5;
                                                                                    }
                                                                                    if (!"nn.Concat".equals(var7_6)) break block7;
                                                                                    var8_7 = this.readConcatWithType(elements, evidence$1, ev);
                                                                                    break block5;
                                                                                }
                                                                                if (!"nn.ConcatTable".equals(var7_6)) break block8;
                                                                                var8_7 = this.readConcatTableWithType(elements, evidence$1, ev);
                                                                                break block5;
                                                                            }
                                                                            if (!"nn.Dropout".equals(var7_6)) break block9;
                                                                            var8_7 = this.readDropoutWithType(elements, evidence$1, ev);
                                                                            break block5;
                                                                        }
                                                                        if (!"nn.LeakyReLU".equals(var7_6)) break block10;
                                                                        var8_7 = this.readLeakyReLUWithType(elements, evidence$1, ev);
                                                                        break block5;
                                                                    }
                                                                    if (!"nn.Linear".equals(var7_6)) break block11;
                                                                    var8_7 = this.readLinearWithType(elements, evidence$1, ev);
                                                                    break block5;
                                                                }
                                                                if (!"nn.ReLU".equals(var7_6)) break block12;
                                                                var8_7 = ReLU$.MODULE$.apply(BoxesRunTime.unboxToBoolean(elements.apply("inplace")), evidence$1, ev);
                                                                break block5;
                                                            }
                                                            if (!"nn.Reshape".equals(var7_6)) break block13;
                                                            var8_7 = Reshape$.MODULE$.apply((int[])elements.apply("size"), Reshape$.MODULE$.apply$default$2(), evidence$1, ev);
                                                            break block5;
                                                        }
                                                        if (!"nn.Sequential".equals(var7_6)) break block14;
                                                        var8_7 = this.readSequentialModuleWithType(elements, evidence$1, ev);
                                                        break block5;
                                                    }
                                                    if (!"nn.SpatialMaxPooling".equals(var7_6)) break block15;
                                                    var8_7 = this.readSpatialMaxPoolingWithType(elements, evidence$1, ev);
                                                    break block5;
                                                }
                                                if (!"nn.SpatialAveragePooling".equals(var7_6)) break block16;
                                                var8_7 = this.readSpatialAveragePoolingWithType(elements, evidence$1, ev);
                                                break block5;
                                            }
                                            if (!"nn.SpatialBatchNormalization".equals(var7_6)) break block17;
                                            var8_7 = this.readSpatialBatchNormalizationWithType(elements, evidence$1, ev);
                                            break block5;
                                        }
                                        if (!"nn.SpatialConvolution".equals(var7_6)) break block18;
                                        var8_7 = this.readSpatialConvolutionWithType(elements, evidence$1, ev);
                                        break block5;
                                    }
                                    if (!"nn.SpatialConvolutionMap".equals(var7_6)) break block19;
                                    var8_7 = this.readSpatialConvolutionMapWithType(elements, evidence$1, ev);
                                    break block5;
                                }
                                if (!"nn.SpatialConvolutionMM".equals(var7_6)) break block20;
                                var8_7 = this.readSpatialConvolutionWithType(elements, evidence$1, ev);
                                break block5;
                            }
                            if (!"nn.SpatialCrossMapLRN".equals(var7_6)) break block21;
                            var8_7 = this.readSpatialCrossMapLRNWithType(elements, evidence$1, ev);
                            break block5;
                        }
                        if (!"nn.SpatialZeroPadding".equals(var7_6)) break block22;
                        var8_7 = this.readSpatialZeroPaddingWithType(elements, evidence$1, ev);
                        break block5;
                    }
                    if (!"nn.Threshold".equals(var7_6)) break block23;
                    var8_7 = this.readThresholdWithType(elements, evidence$1, ev);
                    break block5;
                }
                if (!"nn.View".equals(var7_6)) break block24;
                var8_7 = this.readViewWithType(elements, evidence$1, ev);
                break block5;
            }
            try {
                v0 = elements.apply("_type");
                var10_8 = "torch.FloatTensor";
                if (!(v0 == null ? var10_8 != null : v0.equals(var10_8) == false)) ** GOTO lbl-1000
                v1 = elements.apply("_type");
                var11_9 = "torch.CudaTensor";
                if (!(v1 != null ? v1.equals(var11_9) == false : var11_9 != null)) lbl-1000:
                // 2 sources

                {
                    v2 = ClassTag$.MODULE$.Float();
                } else {
                    v2 = ClassTag$.MODULE$.Double();
                }
                classTag = v2;
                bigDlName = new StringBuilder().append((Object)"com.intel.analytics.bigdl.dllib.").append((Object)moduleName).toString();
                args = (Tuple2[])((Object[])new Tuple2[]{new Tuple2(ClassTag.class, (Object)classTag), new Tuple2(TensorNumericMath.TensorNumeric.class, ev)});
                v3 /* !! */  = this.createInstanceFor(bigDlName, (scala.collection.mutable.Seq<Tuple2<Class<?>, Object>>)Predef$.MODULE$.wrapRefArray((Object[])args));
            }
            catch (Throwable v4) {
                Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported module ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{moduleName})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                v3 /* !! */  = BoxedUnit.UNIT;
            }
            var8_7 = v3 /* !! */ ;
        }
        module = var8_7;
        return module;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object readModule(String moduleName, ByteBuffer rawData, Map<Object, Object> objects) {
        Object object;
        String moduleType;
        block7: {
            Table elements;
            block6: {
                block5: {
                    block4: {
                        elements = (Table)this.readObject(rawData, objects);
                        String string = moduleType = elements.getOrElse("_type", "");
                        String string2 = "torch.FloatTensor";
                        if (!(string == null ? string2 != null : !string.equals(string2))) break block4;
                        String string3 = moduleType;
                        String string4 = "torch.CudaTensor";
                        if (string3 != null ? !string3.equals(string4) : string4 != null) break block5;
                    }
                    object = this.readModuleWithType(moduleName, elements, ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
                    return object;
                }
                String string = moduleType;
                String string5 = "torch.DoubleTensor";
                if (!(string == null ? string5 != null : !string.equals(string5))) break block6;
                String string6 = moduleType;
                String string7 = "torch.CudaDoubleTensor";
                if (string6 != null ? !string6.equals(string7) : string7 != null) break block7;
            }
            object = this.readModuleWithType(moduleName, elements, ClassTag$.MODULE$.Double(), TensorNumericMath$TensorNumeric$NumericDouble$.MODULE$);
            return object;
        }
        Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unkown module type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{moduleType})), "only support FloatTensor, DoubleTensor, CudaTensor, CudaDoubleTensor", Log4Error$.MODULE$.invalidOperationError$default$4());
        object = BoxedUnit.UNIT;
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object readObject(ByteBuffer rawData, Map<Object, Object> objects) {
        int TYPE_NIL = 0;
        int TYPE_NUMBER = 1;
        int TYPE_STRING = 2;
        int TYPE_TABLE = 3;
        int TYPE_TORCH = 4;
        int TYPE_BOOLEAN = 5;
        int TYPE_FUNCTION = 6;
        int TYPE_RECUR_FUNCTION = 8;
        int LEGACY_TYPE_RECUR_FUNCTION = 7;
        int typeId = rawData.getInt();
        int n = typeId;
        if (TYPE_NIL == n) {
            return null;
        }
        if (TYPE_TORCH == n) {
            Tensor<Object> tensor;
            int indexId = rawData.getInt();
            if (objects.contains((Object)BoxesRunTime.boxToInteger((int)indexId))) {
                tensor = objects.apply((Object)BoxesRunTime.boxToInteger((int)indexId));
                return tensor;
            } else {
                Tuple2 tuple2;
                Tuple2<Object, String> tuple22 = this.readVersionAndClass(rawData);
                if (tuple22 == null) throw new MatchError(tuple22);
                int versionNumber = tuple22._1$mcI$sp();
                String className = (String)tuple22._2();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)versionNumber), (Object)className);
                int versionNumber2 = tuple23._1$mcI$sp();
                String className2 = (String)tuple23._2();
                String string = className2;
                Object object = "torch.FloatTensor".equals(string) ? this.readFloatTensor(rawData, objects) : ("torch.DoubleTensor".equals(string) ? this.readDoubleTensor(rawData, objects) : ("torch.LongTensor".equals(string) ? this.readLongTensor(rawData, objects) : ("torch.FloatStorage".equals(string) ? this.readFloatStorage(rawData) : ("torch.DoubleStorage".equals(string) ? this.readDoubleStorage(rawData) : ("torch.LongStorage".equals(string) ? (Object)this.readLongStorage(rawData) : ("torch.CudaTensor".equals(string) ? this.readFloatTensor(rawData, objects) : ("torch.CudaDoubleTensor".equals(string) ? this.readDoubleTensor(rawData, objects) : ("torch.CudaLongTensor".equals(string) ? this.readLongTensor(rawData, objects) : ("torch.CudaStorage".equals(string) ? this.readFloatStorage(rawData) : ("torch.CudaDoubleStorage".equals(string) ? this.readDoubleStorage(rawData) : ("torch.CudaLongStorage".equals(string) ? (Object)this.readLongStorage(rawData) : this.readModule(className2, rawData, objects))))))))))));
                Tensor<Object> result2 = object;
                objects.put((Object)BoxesRunTime.boxToInteger((int)indexId), result2);
                tensor = result2;
            }
            return tensor;
        }
        if (TYPE_TABLE == n) {
            Object object;
            int indexId = rawData.getInt();
            if (objects.contains((Object)BoxesRunTime.boxToInteger((int)indexId))) {
                object = objects.apply((Object)BoxesRunTime.boxToInteger((int)indexId));
                return object;
            } else {
                Table result3 = this.readTable(rawData, objects);
                objects.put((Object)BoxesRunTime.boxToInteger((int)indexId), (Object)result3);
                object = result3;
            }
            return object;
        }
        if (TYPE_NUMBER == n) {
            return BoxesRunTime.boxToDouble((double)this.readNumber(rawData));
        }
        if (TYPE_STRING == n) {
            return this.readString(rawData);
        }
        if (TYPE_BOOLEAN == n) {
            return BoxesRunTime.boxToBoolean((rawData.getInt() == 1 ? 1 : 0) != 0);
        }
        Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Object)BoxesRunTime.boxToInteger((int)typeId)).toString()})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        return BoxedUnit.UNIT;
    }

    private void writeModule(AbstractModule<?, ?, ?> module, ByteBuffer rawData, Path path) {
        AbstractModule<?, ?, ?> abstractModule = module;
        if (abstractModule instanceof Linear) {
            Linear linear = (Linear)abstractModule;
            this.writeVersionAndClass("V 1", "nn.Linear", rawData, path);
            this.writeLinear(linear, rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (abstractModule instanceof SpatialConvolution) {
            SpatialConvolution spatialConvolution = (SpatialConvolution)abstractModule;
            this.writeVersionAndClass("V 1", "nn.SpatialConvolutionMM", rawData, path);
            this.writeSpatialConvolution(spatialConvolution, rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (abstractModule instanceof SpatialMaxPooling) {
            SpatialMaxPooling spatialMaxPooling = (SpatialMaxPooling)abstractModule;
            this.writeVersionAndClass("V 1", "nn.SpatialMaxPooling", rawData, path);
            this.writeSpatialMaxPooling(spatialMaxPooling, rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (abstractModule instanceof ReLU) {
            ReLU reLU = (ReLU)abstractModule;
            this.writeVersionAndClass("V 1", "nn.ReLU", rawData, path);
            this.writeReLU(reLU, rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (abstractModule instanceof Threshold) {
            Threshold threshold = (Threshold)abstractModule;
            this.writeVersionAndClass("V 1", "nn.Threshold", rawData, path);
            this.writeThreshold(threshold, rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (abstractModule instanceof Concat) {
            Concat concat2 = (Concat)abstractModule;
            this.writeVersionAndClass("V 1", "nn.Concat", rawData, path);
            this.writeConcat(concat2, rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (abstractModule instanceof Sequential) {
            Sequential sequential = (Sequential)abstractModule;
            this.writeVersionAndClass("V 1", "nn.Sequential", rawData, path);
            this.writeSequential(sequential, rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (abstractModule instanceof Dropout) {
            Dropout dropout = (Dropout)abstractModule;
            this.writeVersionAndClass("V 1", "nn.Dropout", rawData, path);
            this.writeDropout(dropout, rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (abstractModule instanceof View) {
            View view = (View)abstractModule;
            this.writeVersionAndClass("V 1", "nn.View", rawData, path);
            this.writeView(view, rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (abstractModule instanceof LogSoftMax) {
            LogSoftMax logSoftMax = (LogSoftMax)abstractModule;
            this.writeVersionAndClass("V 1", "nn.LogSoftMax", rawData, path);
            this.writeLogSoftMax(logSoftMax, rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (abstractModule instanceof SpatialCrossMapLRN) {
            SpatialCrossMapLRN spatialCrossMapLRN = (SpatialCrossMapLRN)abstractModule;
            this.writeVersionAndClass("V 1", "nn.SpatialCrossMapLRN", rawData, path);
            this.writeSpatialCrossMapLRN(spatialCrossMapLRN, rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported module ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{module})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void writeObject(Object source, ByteBuffer rawData, Path path, TorchObject objectType) {
        this.flush(rawData, path);
        rawData.putInt(objectType.typeId());
        TorchObject torchObject = objectType;
        if (TorchObject$TYPE_NIL$.MODULE$.equals(torchObject)) {
            return;
        }
        if (TorchObject$TYPE_FLOAT_TENSOR$.MODULE$.equals(torchObject)) {
            this.i_$eq(this.i() + 1);
            rawData.putInt(this.i());
            this.writeVersionAndClass("V 1", "torch.FloatTensor", rawData, path);
            this.writeFloatTensor((Tensor)source, rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TorchObject$TYPE_DOUBLE_TENSOR$.MODULE$.equals(torchObject)) {
            this.i_$eq(this.i() + 1);
            rawData.putInt(this.i());
            this.writeVersionAndClass("V 1", "torch.DoubleTensor", rawData, path);
            this.writeDoubleTensor((Tensor)source, rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TorchObject$TYPE_FLOAT_STORAGE$.MODULE$.equals(torchObject)) {
            this.i_$eq(this.i() + 1);
            rawData.putInt(this.i());
            this.writeVersionAndClass("V 1", "torch.FloatStorage", rawData, path);
            this.writeFloatStorage((Tensor)source, rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TorchObject$TYPE_DOUBLE_STORAGE$.MODULE$.equals(torchObject)) {
            this.i_$eq(this.i() + 1);
            rawData.putInt(this.i());
            this.writeVersionAndClass("V 1", "torch.DoubleStorage", rawData, path);
            this.writeDoubleStorage((Tensor)source, rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TorchObject$TYPE_LONG_STORAGE$.MODULE$.equals(torchObject)) {
            this.i_$eq(this.i() + 1);
            rawData.putInt(this.i());
            this.writeVersionAndClass("V 1", "torch.LongStorage", rawData, path);
            this.writeLongStorage((int[])source, rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TorchObject$TYPE_NUMBER$.MODULE$.equals(torchObject)) {
            this.writeNumber(BoxesRunTime.unboxToDouble((Object)source), rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TorchObject$TYPE_STRING$.MODULE$.equals(torchObject)) {
            this.writeString((String)source, rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TorchObject$TYPE_BOOLEAN$.MODULE$.equals(torchObject)) {
            this.writeBoolean(BoxesRunTime.unboxToBoolean((Object)source), rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TorchObject$TYPE_MODULE$.MODULE$.equals(torchObject)) {
            this.i_$eq(this.i() + 1);
            rawData.putInt(this.i());
            this.writeModule((AbstractModule)source, rawData, path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TorchObject$TYPE_TABLE$.MODULE$.equals(torchObject)) {
            this.i_$eq(this.i() + 1);
            rawData.putInt(this.i());
            Object object = source;
            if (object instanceof Table) {
                this.writeTable((Table)source, rawData, path);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{source})), "only support Table", Log4Error$.MODULE$.invalidOperationError$default$4());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Log4Error$.MODULE$.invalidOperationError(false, objectType.toString(), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.byteWrite(rawData, path);
    }

    private void writeNumber(double source, ByteBuffer rawData, Path path) {
        this.flush(rawData, path);
        rawData.putDouble(source);
        this.byteWrite(rawData, path);
    }

    private void writeVersionAndClass(String version2, String className, ByteBuffer rawData, Path path) {
        this.writeString(version2, rawData, path);
        this.writeString(className, rawData, path);
    }

    private void writeString(String string, ByteBuffer rawData, Path path) {
        int length = string.length();
        this.flush(rawData, path);
        rawData.putInt(length);
        for (int i = 0; i < length; ++i) {
            this.flush(rawData, path);
            rawData.put((byte)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(string), i));
        }
        this.byteWrite(rawData, path);
    }

    private void writeBoolean(boolean source, ByteBuffer rawData, Path path) {
        int tmp = source ? 1 : 0;
        this.flush(rawData, path);
        rawData.putInt(tmp);
        this.byteWrite(rawData, path);
    }

    private void writeDoubleTensor(Tensor<Object> source, ByteBuffer rawData, Path path) {
        int i;
        int ndimension = source.dim();
        this.flush(rawData, path);
        rawData.putInt(ndimension);
        for (i = 0; i < ndimension; ++i) {
            this.flush(rawData, path);
            rawData.putLong(source.size(i + 1));
        }
        for (i = 0; i < ndimension; ++i) {
            this.flush(rawData, path);
            rawData.putLong(source.stride(i + 1));
        }
        this.flush(rawData, path);
        rawData.putLong(source.storageOffset());
        if (ndimension == 0) {
            this.writeObject(source, rawData, path, TorchObject$TYPE_NIL$.MODULE$);
        } else {
            this.writeObject(source, rawData, path, TorchObject$TYPE_DOUBLE_STORAGE$.MODULE$);
        }
        this.byteWrite(rawData, path);
    }

    private void writeFloatTensor(Tensor<Object> source, ByteBuffer rawData, Path path) {
        int i;
        int ndimension = source.dim();
        this.flush(rawData, path);
        rawData.putInt(ndimension);
        for (i = 0; i < ndimension; ++i) {
            this.flush(rawData, path);
            rawData.putLong(source.size(i + 1));
        }
        for (i = 0; i < ndimension; ++i) {
            this.flush(rawData, path);
            rawData.putLong(source.stride(i + 1));
        }
        this.flush(rawData, path);
        rawData.putLong(source.storageOffset());
        if (ndimension == 0) {
            this.writeObject(source, rawData, path, TorchObject$TYPE_NIL$.MODULE$);
        } else {
            this.writeObject(source, rawData, path, TorchObject$TYPE_FLOAT_STORAGE$.MODULE$);
        }
        this.byteWrite(rawData, path);
    }

    private Table writeGeneralParameters(AbstractModule<?, ?, ?> source, Table table) {
        String string;
        table.update("gradInput", source.gradInput());
        table.update("output", source.output());
        TensorDataType tensorDataType = source.getNumericType();
        if (DoubleType$.MODULE$.equals(tensorDataType)) {
            string = "torch.DoubleTensor";
        } else if (FloatType$.MODULE$.equals(tensorDataType)) {
            string = "torch.FloatTensor";
        } else {
            Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{source.getNumericType()})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            string = BoxedUnit.UNIT;
        }
        table.update("_type", string);
        return table;
    }

    private void writeSpatialConvolution(SpatialConvolution<?> source, ByteBuffer rawData, Path path) {
        Log4Error$.MODULE$.invalidInputError(source.nGroup() == 1, "nGroup is not supported in torch", Log4Error$.MODULE$.invalidInputError$default$3());
        Table table = T$.MODULE$.apply();
        this.writeGeneralParameters(source, table);
        table.update("nInputPlane", BoxesRunTime.boxToInteger((int)source.nInputPlane()));
        table.update("nOutputPlane", BoxesRunTime.boxToInteger((int)source.nOutputPlane()));
        table.update("kW", BoxesRunTime.boxToInteger((int)source.kernelW()));
        table.update("kH", BoxesRunTime.boxToInteger((int)source.kernelH()));
        table.update("dW", BoxesRunTime.boxToInteger((int)source.strideW()));
        table.update("dH", BoxesRunTime.boxToInteger((int)source.strideH()));
        table.update("padW", BoxesRunTime.boxToInteger((int)source.padW()));
        table.update("padH", BoxesRunTime.boxToInteger((int)source.padH()));
        table.update("fGradInput", source.fGradInput());
        table.update("fInput", source.fInput());
        table.update("gradBias", source.gradBias());
        table.update("bias", source.bias());
        table.update("weight", source.weight().view((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{source.nOutputPlane(), source.nInputPlane() * source.kernelH() * source.kernelW()})));
        table.update("gradWeight", source.gradWeight().view((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{source.nOutputPlane(), source.nInputPlane() * source.kernelH() * source.kernelW()})));
        Object object = source.propagateBack() ? BoxedUnit.UNIT : table.update("gradInput", null);
        this.writeObject(table, rawData, path, TorchObject$TYPE_TABLE$.MODULE$);
        this.byteWrite(rawData, path);
    }

    private void writeSpatialMaxPooling(SpatialMaxPooling<?> source, ByteBuffer rawData, Path path) {
        Table table = T$.MODULE$.apply();
        this.writeGeneralParameters(source, table);
        table.update("kW", BoxesRunTime.boxToInteger((int)source.kW()));
        table.update("kH", BoxesRunTime.boxToInteger((int)source.kH()));
        table.update("dW", BoxesRunTime.boxToInteger((int)source.dW()));
        table.update("dH", BoxesRunTime.boxToInteger((int)source.dH()));
        table.update("padW", BoxesRunTime.boxToInteger((int)source.padW()));
        table.update("padH", BoxesRunTime.boxToInteger((int)source.padH()));
        table.update("indices", source.indices());
        table.update("ceil_mode", BoxesRunTime.boxToBoolean((boolean)source.ceilMode()));
        this.writeObject(table, rawData, path, TorchObject$TYPE_TABLE$.MODULE$);
        this.byteWrite(rawData, path);
    }

    private void writeSpatialCrossMapLRN(SpatialCrossMapLRN<?> source, ByteBuffer rawData, Path path) {
        Table table = T$.MODULE$.apply();
        this.writeGeneralParameters(source, table);
        table.update("prePad", BoxesRunTime.boxToInteger((int)source.prePad()));
        table.update("size", BoxesRunTime.boxToInteger((int)source.size()));
        table.update("alpha", BoxesRunTime.boxToDouble((double)source.alpha()));
        table.update("beta", BoxesRunTime.boxToDouble((double)source.beta()));
        table.update("k", BoxesRunTime.boxToDouble((double)source.k()));
        this.writeObject(table, rawData, path, TorchObject$TYPE_TABLE$.MODULE$);
        this.byteWrite(rawData, path);
    }

    private void writeThreshold(Threshold<?> source, ByteBuffer rawData, Path path) {
        Table table = T$.MODULE$.apply();
        this.writeGeneralParameters(source, table);
        table.update("val", BoxesRunTime.boxToDouble((double)source.value()));
        table.update("inplace", BoxesRunTime.boxToBoolean((boolean)source.inPlace()));
        table.update("threshold", BoxesRunTime.boxToDouble((double)source.threshold()));
        this.writeObject(table, rawData, path, TorchObject$TYPE_TABLE$.MODULE$);
        this.byteWrite(rawData, path);
    }

    private void writeConcat(Concat<?> source, ByteBuffer rawData, Path path) {
        Table table = T$.MODULE$.apply();
        this.writeGeneralParameters(source, table);
        Table modules = T$.MODULE$.apply();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), source.modules().length()).foreach((Function1)new Serializable(source, modules){
            public static final long serialVersionUID = 0L;
            private final Concat source$1;
            private final Table modules$1;

            public final Table apply(int i) {
                return this.modules$1.update(BoxesRunTime.boxToInteger((int)i), this.source$1.modules().apply(i - 1));
            }
            {
                this.source$1 = source$1;
                this.modules$1 = modules$1;
            }
        });
        table.update("dimension", BoxesRunTime.boxToInteger((int)source.dimension()));
        table.update("modules", modules);
        this.writeObject(table, rawData, path, TorchObject$TYPE_TABLE$.MODULE$);
        this.byteWrite(rawData, path);
    }

    private void writeSequential(Sequential<?> source, ByteBuffer rawData, Path path) {
        Table table = T$.MODULE$.apply();
        this.writeGeneralParameters(source, table);
        Table modules = T$.MODULE$.apply();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), source.modules().length()).foreach((Function1)new Serializable(source, modules){
            public static final long serialVersionUID = 0L;
            private final Sequential source$2;
            private final Table modules$2;

            public final Table apply(int i) {
                return this.modules$2.update(BoxesRunTime.boxToInteger((int)i), this.source$2.modules().apply(i - 1));
            }
            {
                this.source$2 = source$2;
                this.modules$2 = modules$2;
            }
        });
        table.update("modules", modules);
        this.writeObject(table, rawData, path, TorchObject$TYPE_TABLE$.MODULE$);
        this.byteWrite(rawData, path);
    }

    private void writeDropout(Dropout<?> source, ByteBuffer rawData, Path path) {
        Table table = T$.MODULE$.apply();
        this.writeGeneralParameters(source, table);
        table.update("noise", source.noise());
        table.update("p", source.getP());
        this.writeObject(table, rawData, path, TorchObject$TYPE_TABLE$.MODULE$);
        this.byteWrite(rawData, path);
    }

    private void writeView(View<?> source, ByteBuffer rawData, Path path) {
        Table table = T$.MODULE$.apply();
        this.writeGeneralParameters(source, table);
        table.update("numElements", BoxesRunTime.boxToInteger((int)source.numElements()));
        table.update("size", source.getSize());
        this.writeObject(table, rawData, path, TorchObject$TYPE_TABLE$.MODULE$);
        this.byteWrite(rawData, path);
    }

    private void writeReLU(ReLU<?> source, ByteBuffer rawData, Path path) {
        Table table = T$.MODULE$.apply();
        this.writeGeneralParameters(source, table);
        table.update("val", BoxesRunTime.boxToDouble((double)source.value()));
        table.update("threshold", BoxesRunTime.boxToDouble((double)source.threshold()));
        table.update("inplace", BoxesRunTime.boxToBoolean((boolean)source.inPlace()));
        this.writeObject(table, rawData, path, TorchObject$TYPE_TABLE$.MODULE$);
        this.byteWrite(rawData, path);
    }

    private void writeLogSoftMax(LogSoftMax<?> source, ByteBuffer rawData, Path path) {
        Table table = T$.MODULE$.apply();
        this.writeGeneralParameters(source, table);
        this.writeObject(table, rawData, path, TorchObject$TYPE_TABLE$.MODULE$);
        this.byteWrite(rawData, path);
    }

    private void writeLinear(Linear<?> source, ByteBuffer rawData, Path path) {
        Table table = T$.MODULE$.apply();
        this.writeGeneralParameters(source, table);
        table.update("gradBias", source.gradBias());
        table.update("bias", source.bias());
        table.update("weight", source.weight());
        table.update("gradWeight", source.gradWeight());
        this.writeObject(table, rawData, path, TorchObject$TYPE_TABLE$.MODULE$);
        this.byteWrite(rawData, path);
    }

    private boolean isDoubleTensor(Tensor<?> tensor) {
        boolean bl;
        TensorDataType tensorDataType = tensor.getType();
        if (FloatType$.MODULE$.equals(tensorDataType)) {
            bl = false;
        } else if (DoubleType$.MODULE$.equals(tensorDataType)) {
            bl = true;
        } else {
            Log4Error$.MODULE$.invalidInputError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tensor.getType()})), "only support FloatType and DoubleType");
            bl = false;
        }
        return bl;
    }

    private void writeTable(Table source, ByteBuffer rawData, Path path) {
        int size = source.length();
        this.flush(rawData, path);
        rawData.putInt(size);
        Iterator it = source.keySet().toIterator();
        while (it.hasNext()) {
            Object object;
            Object sourceKey;
            Object object2;
            Object key = it.next();
            Object object3 = key;
            if (object3 instanceof String) {
                String string = (String)object3;
                this.writeObject(string, rawData, path, TorchObject$TYPE_STRING$.MODULE$);
                object2 = BoxedUnit.UNIT;
            } else if (object3 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object3);
                this.writeObject(BoxesRunTime.boxToDouble((double)d), rawData, path, TorchObject$TYPE_NUMBER$.MODULE$);
                object2 = BoxedUnit.UNIT;
            } else if (object3 instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object3);
                this.writeObject(BoxesRunTime.boxToDouble((double)f), rawData, path, TorchObject$TYPE_NUMBER$.MODULE$);
                object2 = BoxedUnit.UNIT;
            } else if (object3 instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object3);
                this.writeObject(BoxesRunTime.boxToDouble((double)n), rawData, path, TorchObject$TYPE_NUMBER$.MODULE$);
                object2 = BoxedUnit.UNIT;
            } else {
                object2 = new Error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported key type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
            }
            Object var15_14 = sourceKey = source.getOrElse(key, null);
            if (var15_14 instanceof Tensor) {
                BoxedUnit boxedUnit;
                Tensor tensor = var15_14;
                if (this.isDoubleTensor(tensor)) {
                    this.writeObject(tensor, rawData, path, TorchObject$TYPE_DOUBLE_TENSOR$.MODULE$);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.writeObject(tensor, rawData, path, TorchObject$TYPE_FLOAT_TENSOR$.MODULE$);
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = boxedUnit;
                continue;
            }
            if (var15_14 instanceof Table) {
                Table table = var15_14;
                this.writeObject(table, rawData, path, TorchObject$TYPE_TABLE$.MODULE$);
                object = BoxedUnit.UNIT;
                continue;
            }
            if (var15_14 instanceof Integer) {
                int n = BoxesRunTime.unboxToInt(var15_14);
                this.writeObject(BoxesRunTime.boxToDouble((double)n), rawData, path, TorchObject$TYPE_NUMBER$.MODULE$);
                object = BoxedUnit.UNIT;
                continue;
            }
            if (var15_14 instanceof Float) {
                float f = BoxesRunTime.unboxToFloat(var15_14);
                this.writeObject(BoxesRunTime.boxToDouble((double)f), rawData, path, TorchObject$TYPE_NUMBER$.MODULE$);
                object = BoxedUnit.UNIT;
                continue;
            }
            if (var15_14 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble(var15_14);
                this.writeObject(BoxesRunTime.boxToDouble((double)d), rawData, path, TorchObject$TYPE_NUMBER$.MODULE$);
                object = BoxedUnit.UNIT;
                continue;
            }
            if (var15_14 instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean(var15_14);
                this.writeObject(BoxesRunTime.boxToBoolean((boolean)bl), rawData, path, TorchObject$TYPE_BOOLEAN$.MODULE$);
                object = BoxedUnit.UNIT;
                continue;
            }
            if (var15_14 instanceof String) {
                String string = var15_14;
                this.writeObject(string, rawData, path, TorchObject$TYPE_STRING$.MODULE$);
                object = BoxedUnit.UNIT;
                continue;
            }
            if (var15_14 instanceof Map) {
                Map map = var15_14;
                this.writeObject(map, rawData, path, TorchObject$TYPE_TABLE$.MODULE$);
                object = BoxedUnit.UNIT;
                continue;
            }
            if (var15_14 instanceof int[]) {
                int[] nArray = var15_14;
                this.writeObject(nArray, rawData, path, TorchObject$TYPE_LONG_STORAGE$.MODULE$);
                object = BoxedUnit.UNIT;
                continue;
            }
            if (var15_14 instanceof AbstractModule) {
                AbstractModule abstractModule = var15_14;
                this.writeObject(abstractModule, rawData, path, TorchObject$TYPE_MODULE$.MODULE$);
                object = BoxedUnit.UNIT;
                continue;
            }
            if (var15_14 == null) {
                this.writeObject(sourceKey, rawData, path, TorchObject$TYPE_NIL$.MODULE$);
                object = BoxedUnit.UNIT;
                continue;
            }
            object = new Error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported value type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
        }
        this.byteWrite(rawData, path);
    }

    private void writeFloatStorage(Tensor<Object> source, ByteBuffer rawData, Path path) {
        int storageLength = source.storage().length();
        this.flush(rawData, path);
        rawData.putLong(storageLength);
        for (int i = 0; i < storageLength; ++i) {
            this.flush(rawData, path);
            rawData.putFloat(BoxesRunTime.unboxToFloat((Object)source.storage().apply(i)));
        }
        this.byteWrite(rawData, path);
    }

    private void writeDoubleStorage(Tensor<Object> source, ByteBuffer rawData, Path path) {
        int storageLength = source.storage().length();
        this.flush(rawData, path);
        rawData.putLong(storageLength);
        for (int i = 0; i < storageLength; ++i) {
            this.flush(rawData, path);
            rawData.putDouble(BoxesRunTime.unboxToDouble((Object)source.storage().apply(i)));
        }
        this.byteWrite(rawData, path);
    }

    private void writeLongStorage(int[] source, ByteBuffer rawData, Path path) {
        int storageLength = source.length;
        this.flush(rawData, path);
        rawData.putLong(storageLength);
        for (int i = 0; i < storageLength; ++i) {
            this.flush(rawData, path);
            rawData.putLong(source[i]);
        }
        this.byteWrite(rawData, path);
    }

    private Storage<Object> readDoubleStorage(ByteBuffer rawData) {
        int storageLength = (int)rawData.getLong();
        double[] data2 = new double[storageLength];
        for (int i = 0; i < storageLength; ++i) {
            data2[i] = rawData.getDouble();
        }
        return Storage$.MODULE$.apply$mDc$sp(data2, (ClassTag<Object>)ClassTag$.MODULE$.Double());
    }

    private Storage<Object> readFloatStorage(ByteBuffer rawData) {
        int storageLength = (int)rawData.getLong();
        float[] data2 = new float[storageLength];
        for (int i = 0; i < storageLength; ++i) {
            data2[i] = rawData.getFloat();
        }
        return Storage$.MODULE$.apply$mFc$sp(data2, (ClassTag<Object>)ClassTag$.MODULE$.Float());
    }

    /*
     * WARNING - void declaration
     */
    private int[] readLongStorage(ByteBuffer rawData) {
        void var3_3;
        int storageLength = (int)rawData.getLong();
        int[] data2 = new int[storageLength];
        for (int i = 0; i < storageLength; ++i) {
            data2[i] = (int)rawData.getLong();
        }
        return var3_3;
    }

    private Tuple2<Object, String> readVersionAndClass(ByteBuffer rawData) {
        Tuple2 tuple2;
        String string;
        String version2 = this.readString(rawData);
        Regex pattern = new StringOps(Predef$.MODULE$.augmentString("^V (.*)$")).r();
        Option option = pattern.unapplySeq((CharSequence)(string = version2));
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String v = (String)((LinearSeqOptimized)option.get()).apply(0);
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(v)).toInt()), (Object)this.readString(rawData));
        } else {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)version2);
        }
        return tuple2;
    }

    private String readString(ByteBuffer rawData) {
        int length = rawData.getInt();
        char[] string = new char[length];
        for (int i = 0; i < string.length; ++i) {
            string[i] = (char)rawData.get();
        }
        return new String(string);
    }

    private double readNumber(ByteBuffer rawData) {
        return rawData.getDouble();
    }

    private boolean readBoolean(ByteBuffer rawData) {
        return rawData.getInt() == 1;
    }

    private Table readTable(ByteBuffer rawData, Map<Object, Object> objects) {
        int size = rawData.getInt();
        Table result2 = T$.MODULE$.apply();
        for (int i = 0; i < size; ++i) {
            double d;
            Object key = this.readObject(rawData, objects);
            Object value2 = this.readObject(rawData, objects);
            Object object = key;
            Table table = object instanceof Double && (d = BoxesRunTime.unboxToDouble((Object)object)) % 1.0 == 0.0 ? result2.update(BoxesRunTime.boxToInteger((int)((int)d)), value2) : result2.update(key, value2);
        }
        return result2;
    }

    private Tensor<Object> readDoubleTensor(ByteBuffer rawData, Map<Object, Object> objects) {
        int i;
        int nDimension = rawData.getInt();
        int[] sizes = new int[nDimension];
        int[] strides = new int[nDimension];
        for (i = 0; i < nDimension; ++i) {
            sizes[i] = (int)rawData.getLong();
        }
        for (i = 0; i < nDimension; ++i) {
            strides[i] = (int)rawData.getLong();
        }
        int offset = (int)rawData.getLong();
        Storage storage = (Storage)this.readObject(rawData, objects);
        return Tensor$.MODULE$.apply$mDc$sp(storage, offset, sizes, strides, (ClassTag<Object>)ClassTag$.MODULE$.Double(), (TensorNumericMath.TensorNumeric<Object>)TensorNumericMath$TensorNumeric$NumericDouble$.MODULE$);
    }

    private Tensor<Object> readFloatTensor(ByteBuffer rawData, Map<Object, Object> objects) {
        int i;
        int nDimension = rawData.getInt();
        int[] sizes = new int[nDimension];
        int[] strides = new int[nDimension];
        for (i = 0; i < nDimension; ++i) {
            sizes[i] = (int)rawData.getLong();
        }
        for (i = 0; i < nDimension; ++i) {
            strides[i] = (int)rawData.getLong();
        }
        int offset = (int)rawData.getLong();
        Storage storage = (Storage)this.readObject(rawData, objects);
        return Tensor$.MODULE$.apply$mFc$sp(storage, offset, sizes, strides, (ClassTag<Object>)ClassTag$.MODULE$.Float(), (TensorNumericMath.TensorNumeric<Object>)TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
    }

    private Tensor<Object> readLongTensor(ByteBuffer rawData, Map<Object, Object> objects) {
        Tensor<Object> tensor;
        int i;
        int nDimension = rawData.getInt();
        int[] sizes = new int[nDimension];
        int[] strides = new int[nDimension];
        for (i = 0; i < nDimension; ++i) {
            sizes[i] = (int)rawData.getLong();
        }
        for (i = 0; i < nDimension; ++i) {
            strides[i] = (int)rawData.getLong();
        }
        int offset = (int)rawData.getLong();
        int[] longStorage = (int[])this.readObject(rawData, objects);
        if (longStorage == null) {
            tensor = Tensor$.MODULE$.apply(null, offset, sizes, strides, ClassTag$.MODULE$.Double(), TensorNumericMath$TensorNumeric$NumericDouble$.MODULE$);
        } else {
            double[] storageData = new double[longStorage.length];
            for (i = 0; i < storageData.length; ++i) {
                storageData[i] = longStorage[i];
            }
            Storage<Object> storage = Storage$.MODULE$.apply(storageData, ClassTag$.MODULE$.Double());
            tensor = Tensor$.MODULE$.apply$mDc$sp(storage, offset, sizes, strides, (ClassTag<Object>)ClassTag$.MODULE$.Double(), (TensorNumericMath.TensorNumeric<Object>)TensorNumericMath$TensorNumeric$NumericDouble$.MODULE$);
        }
        return tensor;
    }

    private <T> SpatialMaxPooling<T> readSpatialMaxPoolingWithType(Table elements, ClassTag<T> evidence$2, TensorNumericMath.TensorNumeric<T> ev) {
        SpatialMaxPooling<T> result2 = SpatialMaxPooling$.MODULE$.apply((int)BoxesRunTime.unboxToDouble(elements.apply("kW")), (int)BoxesRunTime.unboxToDouble(elements.apply("kH")), (int)BoxesRunTime.unboxToDouble(elements.apply("dW")), (int)BoxesRunTime.unboxToDouble(elements.apply("dH")), (int)BoxesRunTime.unboxToDouble((Object)elements.getOrElse("padW", BoxesRunTime.boxToDouble((double)0.0))), (int)BoxesRunTime.unboxToDouble((Object)elements.getOrElse("padH", BoxesRunTime.boxToDouble((double)0.0))), SpatialMaxPooling$.MODULE$.apply$default$7(), evidence$2, ev);
        boolean ceilMode = BoxesRunTime.unboxToBoolean(elements.apply("ceil_mode"));
        SpatialMaxPooling<T> spatialMaxPooling = ceilMode ? result2.ceil() : result2.floor();
        return result2;
    }

    private <T> SpatialAveragePooling<T> readSpatialAveragePoolingWithType(Table elements, ClassTag<T> evidence$3, TensorNumericMath.TensorNumeric<T> ev) {
        int x$4 = (int)BoxesRunTime.unboxToDouble(elements.apply("kW"));
        int x$5 = (int)BoxesRunTime.unboxToDouble(elements.apply("kH"));
        int x$6 = (int)BoxesRunTime.unboxToDouble((Object)elements.getOrElse("dW", BoxesRunTime.boxToDouble((double)1.0)));
        int x$7 = (int)BoxesRunTime.unboxToDouble((Object)elements.getOrElse("dH", BoxesRunTime.boxToDouble((double)1.0)));
        int x$8 = (int)BoxesRunTime.unboxToDouble((Object)elements.getOrElse("padW", BoxesRunTime.boxToDouble((double)0.0)));
        int x$9 = (int)BoxesRunTime.unboxToDouble((Object)elements.getOrElse("padH", BoxesRunTime.boxToDouble((double)0.0)));
        boolean x$10 = BoxesRunTime.unboxToBoolean((Object)elements.getOrElse("ceil_mode", BoxesRunTime.boxToBoolean((boolean)false)));
        boolean x$11 = BoxesRunTime.unboxToBoolean((Object)elements.getOrElse("count_include_pad", BoxesRunTime.boxToBoolean((boolean)true)));
        boolean x$12 = BoxesRunTime.unboxToBoolean((Object)elements.getOrElse("divide", BoxesRunTime.boxToBoolean((boolean)true)));
        boolean x$13 = SpatialAveragePooling$.MODULE$.apply$default$7();
        DataFormat x$14 = SpatialAveragePooling$.MODULE$.apply$default$11();
        SpatialAveragePooling<T> result2 = SpatialAveragePooling$.MODULE$.apply(x$4, x$5, x$6, x$7, x$8, x$9, x$13, x$10, x$11, x$12, x$14, evidence$3, ev);
        return result2;
    }

    private <T> Concat<T> readConcatWithType(Table elements, ClassTag<T> evidence$4, TensorNumericMath.TensorNumeric<T> ev) {
        Table modules = (Table)elements.apply("modules");
        Concat<T> result2 = Concat$.MODULE$.apply((int)BoxesRunTime.unboxToDouble(elements.apply("dimension")), evidence$4, ev);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), modules.length()).foreach((Function1)new Serializable(modules, result2){
            public static final long serialVersionUID = 0L;
            private final Table modules$3;
            private final Concat result$1;

            public final Concat<T> apply(int i) {
                return (Concat)this.result$1.add((AbstractModule)this.modules$3.apply(BoxesRunTime.boxToInteger((int)i)));
            }
            {
                this.modules$3 = modules$3;
                this.result$1 = result$1;
            }
        });
        return result2;
    }

    private <T> Dropout<T> readDropoutWithType(Table elements, ClassTag<T> evidence$5, TensorNumericMath.TensorNumeric<T> ev) {
        Dropout<T> result2 = Dropout$.MODULE$.apply(BoxesRunTime.unboxToDouble((Object)elements.getOrElse("p", BoxesRunTime.boxToDouble((double)0.5))), BoxesRunTime.unboxToBoolean((Object)elements.getOrElse("inplace", BoxesRunTime.boxToBoolean((boolean)false))), BoxesRunTime.unboxToBoolean((Object)elements.getOrElse("", BoxesRunTime.boxToBoolean((boolean)true))), evidence$5, ev);
        return result2;
    }

    private <T> LeakyReLU<T> readLeakyReLUWithType(Table elements, ClassTag<T> evidence$6, TensorNumericMath.TensorNumeric<T> ev) {
        LeakyReLU<T> result2 = LeakyReLU$.MODULE$.apply(BoxesRunTime.unboxToDouble((Object)elements.getOrElse("negval", BoxesRunTime.boxToDouble((double)0.01))), BoxesRunTime.unboxToBoolean((Object)elements.getOrElse("inplace", BoxesRunTime.boxToBoolean((boolean)false))), evidence$6, ev);
        return result2;
    }

    private <T> Linear<T> readLinearWithType(Table elements, ClassTag<T> evidence$7, TensorNumericMath.TensorNumeric<T> ev) {
        Linear<T> linear;
        Tensor weight = (Tensor)elements.apply("weight");
        if (elements.contains("bias")) {
            int n = weight.size(2);
            int n2 = weight.size(1);
            boolean bl = Linear$.MODULE$.apply$default$3();
            Linear$.MODULE$.apply$default$4();
            Linear$.MODULE$.apply$default$5();
            Linear$.MODULE$.apply$default$6();
            Linear$.MODULE$.apply$default$7();
            Linear$.MODULE$.apply$default$8();
            Linear$.MODULE$.apply$default$9();
            Linear<T> result2 = Linear$.MODULE$.apply(n, n2, bl, null, null, null, null, null, null, evidence$7, ev);
            result2.weight().copy(weight);
            result2.bias().copy((Tensor)elements.apply("bias"));
            linear = result2;
        } else {
            int n = weight.size(2);
            int n3 = weight.size(1);
            Linear$.MODULE$.apply$default$4();
            Linear$.MODULE$.apply$default$5();
            Linear$.MODULE$.apply$default$6();
            Linear$.MODULE$.apply$default$7();
            Linear$.MODULE$.apply$default$8();
            Linear$.MODULE$.apply$default$9();
            Linear<T> result3 = Linear$.MODULE$.apply(n, n3, false, null, null, null, null, null, null, evidence$7, ev);
            result3.weight().copy(weight);
            linear = result3;
        }
        return linear;
    }

    private <T> SpatialConvolutionMap<T> readSpatialConvolutionMapWithType(Table elements, ClassTag<T> evidence$8, TensorNumericMath.TensorNumeric<T> ev) {
        Tensor weight = elements.getOrElse("weight", null);
        Tensor bias = elements.getOrElse("bias", null);
        Tensor tensor = (Tensor)elements.apply("connTable");
        int n = (int)BoxesRunTime.unboxToDouble(elements.apply("kW"));
        int n2 = (int)BoxesRunTime.unboxToDouble(elements.apply("kH"));
        int n3 = (int)BoxesRunTime.unboxToDouble((Object)elements.getOrElse("dW", BoxesRunTime.boxToDouble((double)1.0)));
        int n4 = (int)BoxesRunTime.unboxToDouble((Object)elements.getOrElse("dH", BoxesRunTime.boxToDouble((double)1.0)));
        int n5 = (int)BoxesRunTime.unboxToDouble((Object)elements.getOrElse("padW", BoxesRunTime.boxToDouble((double)0.0)));
        int n6 = (int)BoxesRunTime.unboxToDouble((Object)elements.getOrElse("padH", BoxesRunTime.boxToDouble((double)0.0)));
        SpatialConvolutionMap$.MODULE$.apply$default$8();
        SpatialConvolutionMap$.MODULE$.apply$default$9();
        SpatialConvolutionMap<T> result2 = SpatialConvolutionMap$.MODULE$.apply(tensor, n, n2, n3, n4, n5, n6, null, null, evidence$8, ev);
        result2.weight().copy(weight);
        result2.bias().copy(bias);
        return result2;
    }

    private <T> SpatialCrossMapLRN<T> readSpatialCrossMapLRNWithType(Table elements, ClassTag<T> evidence$9, TensorNumericMath.TensorNumeric<T> ev) {
        Tensor weight = elements.getOrElse("weight", null);
        Tensor bias = elements.getOrElse("bias", null);
        SpatialCrossMapLRN<T> result2 = SpatialCrossMapLRN$.MODULE$.apply((int)BoxesRunTime.unboxToDouble((Object)elements.getOrElse("size", BoxesRunTime.boxToDouble((double)5.0))), BoxesRunTime.unboxToDouble((Object)elements.getOrElse("alpha", BoxesRunTime.boxToDouble((double)1.0))), BoxesRunTime.unboxToDouble((Object)elements.getOrElse("beta", BoxesRunTime.boxToDouble((double)0.75))), BoxesRunTime.unboxToDouble((Object)elements.getOrElse("k", BoxesRunTime.boxToDouble((double)1.0))), SpatialCrossMapLRN$.MODULE$.apply$default$5(), evidence$9, ev);
        return result2;
    }

    private <T> BatchNormalization<T> readBatchNormalizationWithType(Table elements, ClassTag<T> evidence$10, TensorNumericMath.TensorNumeric<T> ev) {
        Tensor weight = (Tensor)elements.apply("weight");
        Tensor runningMean = (Tensor)elements.apply("running_mean");
        Tensor runningVar = (Tensor)elements.apply("running_var");
        Tensor bias = (Tensor)elements.apply("bias");
        int n = runningMean.size(1);
        double d = BoxesRunTime.unboxToDouble((Object)elements.getOrElse("eps", BoxesRunTime.boxToDouble((double)1.0E-5)));
        double d2 = BoxesRunTime.unboxToDouble((Object)elements.getOrElse("momentum", BoxesRunTime.boxToDouble((double)0.1)));
        boolean bl = BoxesRunTime.unboxToBoolean((Object)elements.getOrElse("affine", BoxesRunTime.boxToBoolean((boolean)true)));
        BatchNormalization$.MODULE$.$lessinit$greater$default$5();
        BatchNormalization$.MODULE$.$lessinit$greater$default$6();
        BatchNormalization$.MODULE$.$lessinit$greater$default$7();
        BatchNormalization$.MODULE$.$lessinit$greater$default$8();
        BatchNormalization<T> result2 = new BatchNormalization<T>(n, d, d2, bl, null, null, null, null, evidence$10, ev);
        result2.weight().copy(weight);
        result2.bias().copy(bias);
        result2.runningMean().copy(runningMean);
        result2.runningVar().copy(runningVar);
        return result2;
    }

    private <T> SpatialBatchNormalization<T> readSpatialBatchNormalizationWithType(Table elements, ClassTag<T> evidence$11, TensorNumericMath.TensorNumeric<T> ev) {
        Tensor weight = (Tensor)elements.apply("weight");
        Tensor runningMean = (Tensor)elements.apply("running_mean");
        Tensor runningVar = (Tensor)elements.apply("running_var");
        Tensor bias = (Tensor)elements.apply("bias");
        int n = runningMean.size(1);
        double d = BoxesRunTime.unboxToDouble((Object)elements.getOrElse("eps", BoxesRunTime.boxToDouble((double)1.0E-5)));
        double d2 = BoxesRunTime.unboxToDouble((Object)elements.getOrElse("momentum", BoxesRunTime.boxToDouble((double)0.1)));
        boolean bl = BoxesRunTime.unboxToBoolean((Object)elements.getOrElse("affine", BoxesRunTime.boxToBoolean((boolean)true)));
        SpatialBatchNormalization$.MODULE$.$lessinit$greater$default$5();
        SpatialBatchNormalization$.MODULE$.$lessinit$greater$default$6();
        SpatialBatchNormalization$.MODULE$.$lessinit$greater$default$7();
        SpatialBatchNormalization$.MODULE$.$lessinit$greater$default$8();
        SpatialBatchNormalization<T> result2 = new SpatialBatchNormalization<T>(n, d, d2, bl, null, null, null, null, SpatialBatchNormalization$.MODULE$.$lessinit$greater$default$9(), evidence$11, ev);
        result2.weight().copy(weight);
        result2.bias().copy(bias);
        result2.runningMean().copy(runningMean);
        result2.runningVar().copy(runningVar);
        return result2;
    }

    private <T> ConcatTable<T> readConcatTableWithType(Table elements, ClassTag<T> evidence$12, TensorNumericMath.TensorNumeric<T> ev) {
        ConcatTable<T> result2 = new ConcatTable<T>(evidence$12, ev);
        Table modules = (Table)elements.apply("modules");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), modules.length()).foreach((Function1)new Serializable(result2, modules){
            public static final long serialVersionUID = 0L;
            private final ConcatTable result$2;
            private final Table modules$4;

            public final ConcatTable<T> apply(int i) {
                return (ConcatTable)this.result$2.add((AbstractModule)this.modules$4.apply(BoxesRunTime.boxToInteger((int)i)));
            }
            {
                this.result$2 = result$2;
                this.modules$4 = modules$4;
            }
        });
        return result2;
    }

    private <T> Threshold<T> readThresholdWithType(Table elements, ClassTag<T> evidence$13, TensorNumericMath.TensorNumeric<T> ev) {
        return Threshold$.MODULE$.apply(BoxesRunTime.unboxToDouble((Object)elements.getOrElse("threshold", BoxesRunTime.boxToDouble((double)1.0E-6))), BoxesRunTime.unboxToDouble((Object)elements.getOrElse("val", BoxesRunTime.boxToDouble((double)0.0))), BoxesRunTime.unboxToBoolean((Object)elements.getOrElse("inplace", BoxesRunTime.boxToBoolean((boolean)false))), evidence$13, ev);
    }

    private <T> View<T> readViewWithType(Table elements, ClassTag<T> evidence$14, TensorNumericMath.TensorNumeric<T> ev) {
        View<T> result2 = View$.MODULE$.apply((int[])elements.apply("size"), evidence$14, ev);
        result2.setNumInputDims((int)BoxesRunTime.unboxToDouble((Object)elements.getOrElse("numInputDims", BoxesRunTime.boxToDouble((double)0.0))));
        int numElements = (int)BoxesRunTime.unboxToDouble((Object)elements.getOrElse("numElements", BoxesRunTime.boxToDouble((double)-1.0)));
        Log4Error$.MODULE$.invalidInputError(result2.numElements() == numElements, "Invalid view file", Log4Error$.MODULE$.invalidInputError$default$3());
        return result2;
    }

    private <T> SpatialZeroPadding<T> readSpatialZeroPaddingWithType(Table elements, ClassTag<T> evidence$15, TensorNumericMath.TensorNumeric<T> ev) {
        SpatialZeroPadding<T> result2 = SpatialZeroPadding$.MODULE$.apply((int)BoxesRunTime.unboxToDouble(elements.apply("pad_l")), (int)BoxesRunTime.unboxToDouble(elements.apply("pad_r")), (int)BoxesRunTime.unboxToDouble(elements.apply("pad_t")), (int)BoxesRunTime.unboxToDouble(elements.apply("pad_b")), evidence$15, ev);
        return result2;
    }

    private <T> SpatialConvolution<T> readSpatialConvolutionWithType(Table elements, ClassTag<T> evidence$16, TensorNumericMath.TensorNumeric<T> ev) {
        boolean propagateBack = elements.apply("gradInput") != null;
        boolean withBias = elements.contains("bias");
        int x$15 = (int)BoxesRunTime.unboxToDouble(elements.apply("nInputPlane"));
        int x$16 = (int)BoxesRunTime.unboxToDouble(elements.apply("nOutputPlane"));
        int x$17 = (int)BoxesRunTime.unboxToDouble(elements.apply("kW"));
        int x$18 = (int)BoxesRunTime.unboxToDouble(elements.apply("kH"));
        int x$19 = (int)BoxesRunTime.unboxToDouble((Object)elements.getOrElse("dW", BoxesRunTime.boxToDouble((double)1.0)));
        int x$20 = (int)BoxesRunTime.unboxToDouble((Object)elements.getOrElse("dH", BoxesRunTime.boxToDouble((double)1.0)));
        int x$21 = (int)BoxesRunTime.unboxToDouble((Object)elements.getOrElse("padW", BoxesRunTime.boxToDouble((double)0.0)));
        int x$22 = (int)BoxesRunTime.unboxToDouble((Object)elements.getOrElse("padH", BoxesRunTime.boxToDouble((double)0.0)));
        int x$23 = 1;
        boolean x$24 = propagateBack;
        boolean x$25 = withBias;
        SpatialConvolution$.MODULE$.apply$default$11();
        Object x$26 = null;
        SpatialConvolution$.MODULE$.apply$default$12();
        Object x$27 = null;
        SpatialConvolution$.MODULE$.apply$default$13();
        Object x$28 = null;
        SpatialConvolution$.MODULE$.apply$default$14();
        Object x$29 = null;
        SpatialConvolution$.MODULE$.apply$default$15();
        Object x$30 = null;
        SpatialConvolution$.MODULE$.apply$default$16();
        Object x$31 = null;
        DataFormat x$32 = SpatialConvolution$.MODULE$.apply$default$18();
        SpatialConvolution<T> result2 = SpatialConvolution$.MODULE$.apply(x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, null, null, null, null, null, null, x$25, x$32, evidence$16, ev);
        result2.weight().copy((Tensor)elements.apply("weight"));
        Object object = withBias ? result2.bias().copy((Tensor)elements.apply("bias")) : BoxedUnit.UNIT;
        return result2;
    }

    private <T> Sequential<T> readSequentialModuleWithType(Table elements, ClassTag<T> evidence$17, TensorNumericMath.TensorNumeric<T> ev) {
        Table modules = (Table)elements.apply("modules");
        Sequential<T> result2 = Sequential$.MODULE$.apply(evidence$17, ev);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), modules.length()).foreach((Function1)new Serializable(modules, result2){
            public static final long serialVersionUID = 0L;
            private final Table modules$5;
            private final Sequential result$3;

            public final Sequential<T> apply(int i) {
                return (Sequential)this.result$3.add((AbstractModule)this.modules$5.apply(BoxesRunTime.boxToInteger((int)i)));
            }
            {
                this.modules$5 = modules$5;
                this.result$3 = result$3;
            }
        });
        return result2;
    }

    private TorchFile$() {
        MODULE$ = this;
        this.i = 0;
    }
}

