/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.utils;

import com.intel.analytics.bigdl.dllib.common.CheckedObjectInputStream;
import com.intel.analytics.bigdl.dllib.utils.FileReader;
import com.intel.analytics.bigdl.dllib.utils.FileReader$;
import com.intel.analytics.bigdl.dllib.utils.FileWriter;
import com.intel.analytics.bigdl.dllib.utils.FileWriter$;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.TorchFile$;
import com.intel.analytics.bigdl.dllib.utils.TorchObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.commons.io.serialization.ValidatingObjectInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class File$ {
    public static final File$ MODULE$;
    private final String hdfsPrefix;
    private final String s3aPrefix;

    static {
        new File$();
    }

    public String hdfsPrefix() {
        return this.hdfsPrefix;
    }

    public String s3aPrefix() {
        return this.s3aPrefix;
    }

    public <T> T loadTorch(String fileName) {
        return TorchFile$.MODULE$.load(fileName);
    }

    public void saveTorch(Object source, String fileName, TorchObject objectType, boolean overWrite) {
        TorchFile$.MODULE$.save(source, fileName, objectType, overWrite);
    }

    public void save(Serializable obj, String fileName, boolean isOverwrite) {
        FileWriter fw = null;
        OutputStream out = null;
        ObjectOutputStream objFile = null;
        try {
            fw = FileWriter$.MODULE$.apply(fileName);
            out = fw.create(isOverwrite);
            objFile = new ObjectOutputStream(new BufferedOutputStream(out));
            objFile.writeObject(obj);
            return;
        }
        finally {
            if (objFile != null) {
                objFile.close();
            }
            if (out != null) {
                out.close();
            }
            if (fw != null) {
                fw.close();
            }
        }
    }

    public boolean save$default$3() {
        return false;
    }

    public boolean saveTorch$default$4() {
        return false;
    }

    public void saveBytes(byte[] bytes, String fileName, boolean isOverwrite) {
        FileWriter fw = null;
        OutputStream out = null;
        ObjectOutputStream objFile = null;
        try {
            fw = FileWriter$.MODULE$.apply(fileName);
            out = fw.create(isOverwrite);
            IOUtils.copyBytes((InputStream)new ByteArrayInputStream(bytes), (OutputStream)out, (int)1024, (boolean)true);
            return;
        }
        finally {
            if (objFile != null) {
                objFile.close();
            }
            if (out != null) {
                out.close();
            }
            if (fw != null) {
                fw.close();
            }
        }
    }

    public boolean saveBytes$default$3() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public FileSystem getFileSystem(String fileName) {
        void var3_3;
        Path src = new Path(fileName);
        FileSystem fs = src.getFileSystem(this.getConfiguration(fileName));
        Log4Error$.MODULE$.invalidInputError(fs.exists(src), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)src), " does not exists"), Log4Error$.MODULE$.invalidInputError$default$3());
        return var3_3;
    }

    public Configuration getConfiguration(String fileName) {
        return fileName.startsWith(this.hdfsPrefix()) || fileName.startsWith(this.s3aPrefix()) ? new Configuration() : new Configuration(false);
    }

    public void saveToHdfs(Serializable obj, String fileName, boolean overwrite) {
        Log4Error$.MODULE$.invalidInputError(fileName.startsWith(this.hdfsPrefix()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs path ", " should have prefix 'hdfs:'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileName})), Log4Error$.MODULE$.invalidInputError$default$3());
        Path dest = new Path(fileName);
        FileSystem fs = null;
        FSDataOutputStream out = null;
        ObjectOutputStream objFile = null;
        try {
            Object object;
            fs = dest.getFileSystem(new Configuration());
            if (fs.exists(dest)) {
                if (overwrite) {
                    object = BoxesRunTime.boxToBoolean((boolean)fs.delete(dest, true));
                } else {
                    Log4Error$.MODULE$.invalidInputError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file ", " already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileName})), Log4Error$.MODULE$.invalidInputError$default$3());
                    object = BoxedUnit.UNIT;
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            out = fs.create(dest);
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            objFile = new ObjectOutputStream(byteArrayOut);
            objFile.writeObject(obj);
            IOUtils.copyBytes((InputStream)new ByteArrayInputStream(byteArrayOut.toByteArray()), (OutputStream)out, (int)1024, (boolean)true);
            return;
        }
        finally {
            if (objFile != null) {
                objFile.close();
            }
            if (out != null) {
                out.close();
            }
            if (fs != null) {
                fs.close();
            }
        }
    }

    public <T> T loadFromHdfs(String fileName, ClassTag<T> evidence$1) {
        byte[] byteArrayOut = this.readHdfsByte(fileName);
        ObjectInputStream objFile = null;
        try {
            objFile = new ValidatingObjectInputStream(new ByteArrayInputStream(byteArrayOut));
            ((ValidatingObjectInputStream)objFile).accept(package$.MODULE$.classTag(evidence$1).runtimeClass());
            Object result2 = objFile.readObject();
            objFile.close();
            return (T)result2;
        }
        finally {
            if (objFile != null) {
                objFile.close();
            }
        }
    }

    public <T> T load(String fileName, ClassTag<T> evidence$2) {
        FileReader fr = null;
        InputStream in = null;
        ObjectInputStream objFile = null;
        try {
            fr = FileReader$.MODULE$.apply(fileName);
            in = fr.open();
            BufferedInputStream bis = new BufferedInputStream(in);
            objFile = new CheckedObjectInputStream(package$.MODULE$.classTag(evidence$2).runtimeClass(), bis);
            return (T)objFile.readObject();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fr != null) {
                fr.close();
            }
            if (objFile != null) {
                objFile.close();
            }
        }
    }

    public <T> byte[] readBytes(String fileName) {
        FileReader fr = null;
        InputStream in = null;
        ObjectInputStream objFile = null;
        try {
            fr = FileReader$.MODULE$.apply(fileName);
            in = fr.open();
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            IOUtils.copyBytes((InputStream)in, (OutputStream)byteArrayOut, (int)1024, (boolean)true);
            return byteArrayOut.toByteArray();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fr != null) {
                fr.close();
            }
            if (objFile != null) {
                objFile.close();
            }
        }
    }

    public byte[] readHdfsByte(String fileName) {
        Path src = new Path(fileName);
        FileSystem fs = null;
        FSDataInputStream in = null;
        try {
            fs = FileSystem.newInstance((URI)new URI(fileName), (Configuration)new Configuration());
            in = fs.open(src);
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            IOUtils.copyBytes((InputStream)in, (OutputStream)byteArrayOut, (int)1024, (boolean)true);
            return byteArrayOut.toByteArray();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fs != null) {
                fs.close();
            }
        }
    }

    private File$() {
        MODULE$ = this;
        this.hdfsPrefix = "hdfs:";
        this.s3aPrefix = "s3a:";
    }
}

