/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.utils;

import com.intel.analytics.bigdl.dllib.utils.EngineType;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.MklBlas$;
import com.intel.analytics.bigdl.dllib.utils.MklDnn$;
import com.intel.analytics.bigdl.dllib.utils.NoneMkl$;
import com.intel.analytics.bigdl.dllib.utils.OptimizerV1$;
import com.intel.analytics.bigdl.dllib.utils.OptimizerV2$;
import com.intel.analytics.bigdl.dllib.utils.OptimizerVersion;
import com.intel.analytics.bigdl.dllib.utils.ThreadPool;
import com.intel.analytics.bigdl.mkl.MKL;
import com.intel.analytics.bigdl.mkl.hardware.Affinity;
import com.intel.analytics.bigdl.mkl.hardware.CpuInfo;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFiles$;
import py4j.GatewayServer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Engine$ {
    public static final Engine$ MODULE$;
    private final Logger logger;
    private final AtomicBoolean singletonCounter;
    private int physicalCoreNumber;
    private int nodeNum;
    private final String NOT_INIT_ERROR;
    private final String SPARK_CONF_WARN;
    private EngineType engineType;
    private OptimizerVersion optimizerVersion;
    private ThreadPool wrapperComputing;
    private final ThreadPool dnnComputing;
    private volatile GatewayServer com$intel$analytics$bigdl$dllib$utils$Engine$$gatewayServer;
    private volatile ThreadPool _default;
    private volatile ThreadPool _model;

    static {
        new Engine$();
    }

    public Option<SparkConf> init(int nExecutor, int executorCores, boolean onSpark) {
        None$ none$;
        this.logger().warn("Engine.init(nExecutor, executorCores, onSpark) is deprecated. Please refer to https://bigdl-project.github.io/master/#APIGuide/Engine/");
        this.setNodeAndCore(nExecutor, executorCores);
        if (onSpark) {
            Log4Error$.MODULE$.invalidInputError(!this.localMode(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Engine.init: bigdl.localMode should not be set while onSpark is "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"true. Please set correct java property."})).s((Seq)Nil$.MODULE$)).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
            none$ = new Some((Object)this.createSparkConf(this.createSparkConf$default$1()));
        } else {
            Log4Error$.MODULE$.invalidInputError(this.localMode(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Engine.init: bigdl.localMode should be set while onSpark is "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"false. Please set correct java property."})).s((Seq)Nil$.MODULE$)).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
            none$ = None$.MODULE$;
        }
        None$ res = none$;
        return res;
    }

    public SparkConf createSparkConf(SparkConf exisitingConf) {
        ObjectRef _conf = ObjectRef.create((Object)exisitingConf);
        if ((SparkConf)_conf.elem == null) {
            _conf.elem = new SparkConf();
        }
        this.readConf().foreach((Function1)new Serializable(_conf){
            public static final long serialVersionUID = 0L;
            private final ObjectRef _conf$1;

            public final SparkConf apply(Tuple2<String, String> c) {
                return ((SparkConf)this._conf$1.elem).set((String)c._1(), (String)c._2());
            }
            {
                this._conf$1 = _conf$1;
            }
        });
        return (SparkConf)_conf.elem;
    }

    public SparkConf createSparkConf$default$1() {
        return null;
    }

    public synchronized void init() {
        Tuple2 tuple2;
        block4: {
            block3: {
                Tuple2.mcII.sp sp2;
                block2: {
                    if (!this.localMode()) break block2;
                    this.logger().info("Detect bigdl.localMode is set. Run workload without spark");
                    this.setNodeAndCore(1, this.getCoreNumberFromProperty());
                    break block3;
                }
                this.logger().info("Auto detect executor number and executor cores number");
                tuple2 = (Tuple2)this.sparkExecutorAndCore().get();
                if (tuple2 == null) break block4;
                int nExecutor = tuple2._1$mcI$sp();
                int executorCores = tuple2._2$mcI$sp();
                Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(nExecutor, executorCores);
                int nExecutor2 = sp3._1$mcI$sp();
                int executorCores2 = sp3._2$mcI$sp();
                this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executor number is ", " and executor cores number is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nExecutor2), BoxesRunTime.boxToInteger((int)executorCores2)})));
                this.setNodeAndCore(nExecutor2, executorCores2);
                this.checkSparkContext();
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private Logger logger() {
        return this.logger;
    }

    private AtomicBoolean singletonCounter() {
        return this.singletonCounter;
    }

    private int physicalCoreNumber() {
        return this.physicalCoreNumber;
    }

    private void physicalCoreNumber_$eq(int x$1) {
        this.physicalCoreNumber = x$1;
    }

    private int nodeNum() {
        return this.nodeNum;
    }

    private void nodeNum_$eq(int x$1) {
        this.nodeNum = x$1;
    }

    public GatewayServer com$intel$analytics$bigdl$dllib$utils$Engine$$gatewayServer() {
        return this.com$intel$analytics$bigdl$dllib$utils$Engine$$gatewayServer;
    }

    private void com$intel$analytics$bigdl$dllib$utils$Engine$$gatewayServer_$eq(GatewayServer x$1) {
        this.com$intel$analytics$bigdl$dllib$utils$Engine$$gatewayServer = x$1;
    }

    /*
     * WARNING - void declaration
     */
    private void createGatewayPortFile(int port) {
        File file = new File(SparkFiles$.MODULE$.getRootDirectory(), "gateway_port");
        this.logger().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating JavaGatewayServer port file"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" on executor-", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SparkEnv$.MODULE$.get().executorId(), file.getAbsolutePath()}))).toString());
        Object object = file.exists() ? BoxesRunTime.boxToBoolean((boolean)file.delete()) : BoxedUnit.UNIT;
        file.createNewFile();
        PrintWriter out = new PrintWriter(file);
        try {
            out.print(port);
            out.flush();
            out.close();
            return;
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    public void createJavaGateway(int driverPort) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 2[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean localMode() {
        boolean bl;
        String string = System.getProperty("bigdl.localMode", "false").toLowerCase(Locale.ROOT);
        if ("true".equals(string)) {
            bl = true;
        } else if ("false".equals(string)) {
            bl = false;
        } else {
            Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown bigdl.localMode ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            bl = false;
        }
        return bl;
    }

    private String NOT_INIT_ERROR() {
        return this.NOT_INIT_ERROR;
    }

    private String SPARK_CONF_WARN() {
        return this.SPARK_CONF_WARN;
    }

    private EngineType engineType() {
        return this.engineType;
    }

    private void engineType_$eq(EngineType x$1) {
        this.engineType = x$1;
    }

    private OptimizerVersion optimizerVersion() {
        return this.optimizerVersion;
    }

    private void optimizerVersion_$eq(OptimizerVersion x$1) {
        this.optimizerVersion = x$1;
    }

    private ThreadPool _default() {
        return this._default;
    }

    private void _default_$eq(ThreadPool x$1) {
        this._default = x$1;
    }

    private ThreadPool _model() {
        return this._model;
    }

    private void _model_$eq(ThreadPool x$1) {
        this._model = x$1;
    }

    public ThreadPool wrapperComputing() {
        return this.wrapperComputing;
    }

    public void wrapperComputing_$eq(ThreadPool x$1) {
        this.wrapperComputing = x$1;
    }

    public ThreadPool dnnComputing() {
        return this.dnnComputing;
    }

    private int getCoreNumberFromProperty() {
        return new StringOps(Predef$.MODULE$.augmentString(System.getProperty("bigdl.coreNumber", ((Object)BoxesRunTime.boxToInteger((int)this.getNumMachineCores())).toString()))).toInt();
    }

    private int getNumMachineCores() {
        int coreNum = Runtime.getRuntime().availableProcessors();
        Log4Error$.MODULE$.invalidInputError(coreNum > 0, "Get a non-positive core number", Log4Error$.MODULE$.invalidInputError$default$3());
        return coreNum > 1 ? coreNum / 2 : 1;
    }

    public boolean checkSingleton() {
        return this.singletonCounter().compareAndSet(false, true);
    }

    public void resetSingletonFlag() {
        this.singletonCounter().set(false);
    }

    public int coreNumber() {
        Log4Error$.MODULE$.invalidInputError(this.physicalCoreNumber() != -1, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Engine.init: Core number is "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not initialized. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.NOT_INIT_ERROR()}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
        return this.physicalCoreNumber();
    }

    public void setCoreNumber(int n) {
        Log4Error$.MODULE$.invalidInputError(n > 0, "Engine.init: core number is smaller than zero", Log4Error$.MODULE$.invalidInputError$default$3());
        this.physicalCoreNumber_$eq(n);
        EngineType engineType = this.getEngineType();
        NoneMkl$ noneMkl$ = NoneMkl$.MODULE$;
        if (engineType == null ? noneMkl$ != null : !engineType.equals(noneMkl$)) {
            this.initThreadPool(n);
        }
    }

    public int nodeNumber() {
        Log4Error$.MODULE$.invalidInputError(this.nodeNum() != -1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Engine.init: Node number is not initialized. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.NOT_INIT_ERROR()})), Log4Error$.MODULE$.invalidInputError$default$3());
        return this.nodeNum();
    }

    public void setNodeNumber(int n) {
        Log4Error$.MODULE$.invalidInputError(n > 0, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n should greater than 0, but is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})), Log4Error$.MODULE$.invalidInputError$default$3());
        this.nodeNum_$eq(n);
    }

    public void setOptimizerVersion(OptimizerVersion optimizerVersion) {
        this.optimizerVersion_$eq(optimizerVersion);
    }

    public OptimizerVersion getOptimizerVersion() {
        return this.optimizerVersion();
    }

    public void setEngineType(EngineType engineType) {
        this.engineType_$eq(engineType);
    }

    public EngineType getEngineType() {
        return this.engineType();
    }

    public boolean isMultiModels() {
        EngineType engineType;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    engineType = this.getEngineType();
                    if (!MklBlas$.MODULE$.equals(engineType)) break block2;
                    bl = true;
                    break block3;
                }
                if (!MklDnn$.MODULE$.equals(engineType)) break block4;
                bl = new StringOps(Predef$.MODULE$.augmentString(System.getProperty("bigdl.multiModels", "false"))).toBoolean();
            }
            return bl;
        }
        throw new MatchError((Object)engineType);
    }

    public ThreadPool model() {
        return this._model();
    }

    public ThreadPool default() {
        if (this._default() == null) {
            Log4Error$.MODULE$.invalidOperationError(false, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Engine.init: Thread engine is not "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"initialized. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.NOT_INIT_ERROR()}))).toString(), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        }
        return this._default();
    }

    private void initThreadPool(int core) {
        Object object;
        int defaultPoolSize = new StringOps(Predef$.MODULE$.augmentString(System.getProperty("bigdl.utils.Engine.defaultPoolSize", ((Object)BoxesRunTime.boxToInteger((int)(core * 50))).toString()))).toInt();
        if (this._default() == null || this._default().getPoolSize() != defaultPoolSize) {
            this._default_$eq(new ThreadPool(defaultPoolSize));
        }
        if (this.wrapperComputing() == null || this.wrapperComputing().getPoolSize() != defaultPoolSize) {
            this.wrapperComputing_$eq(new ThreadPool(defaultPoolSize));
        }
        int modelPoolSize = 1;
        if (this._model() == null || this._model().getPoolSize() != modelPoolSize) {
            this._model_$eq(new ThreadPool(modelPoolSize));
        }
        this._model().setMKLThread(MKL.getMklNumThreads());
        EngineType engineType = this.engineType();
        MklDnn$ mklDnn$ = MklDnn$.MODULE$;
        if (!(engineType != null ? !engineType.equals(mklDnn$) : mklDnn$ != null)) {
            this.dnnComputing().setMKLThreadOfMklDnnBackend(MKL.getMklNumThreads());
            object = this._model().setMKLThreadOfMklDnnBackend(MKL.getMklNumThreads());
        } else {
            object = BoxedUnit.UNIT;
        }
        if (new StringOps(Predef$.MODULE$.augmentString(System.getProperty("multiThread", "false"))).toBoolean()) {
            this.wrapperComputing().setMKLThread(1);
        }
    }

    public Seq<Tuple2<String, String>> readConf() {
        InputStream stream = this.getClass().getResourceAsStream("/spark-bigdl.conf");
        String[] lines = (String[])Source$.MODULE$.fromInputStream(stream, Codec$.MODULE$.fallbackSystemCodec()).getLines().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.startsWith("spark");
            }
        }).toArray(ClassTag$.MODULE$.apply(String.class));
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])lines).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$3) {
                return x$3.split("\\s+");
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String[] d) {
                return new Tuple2((Object)d[0], (Object)d[1]);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toSeq().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x$4) {
                Object object = x$4._1();
                String string = "spark.shuffle.blockTransferService";
                return (object != null ? !object.equals(string) : string != null) || new StringOps(Predef$.MODULE$.augmentString(System.getProperty("bigdl.network.nio", "true"))).toBoolean();
            }
        });
    }

    private void checkSparkContext() {
        boolean existingSparkContext;
        SparkContext tmpContext = SparkContext$.MODULE$.getOrCreate(new SparkConf().set("bigdl.temp.context", "true").setAppName("tmp context for Engine check"));
        boolean bl = existingSparkContext = !tmpContext.getConf().contains("bigdl.temp.context");
        if (!existingSparkContext) {
            tmpContext.stop();
            Log4Error$.MODULE$.invalidOperationError(false, "Engine.init: Cannot find an existing spark context. Do you call this method after create spark context?", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        }
        this.logger().info("Find existing spark context. Checking the spark conf...");
        SparkConf sparkConf = tmpContext.getConf();
        this.readConf().foreach((Function1)new Serializable(sparkConf){
            public static final long serialVersionUID = 0L;
            private final SparkConf sparkConf$1;

            public final void apply(Tuple2<String, String> c) {
                Engine$.MODULE$.com$intel$analytics$bigdl$dllib$utils$Engine$$verify$1((String)c._1(), (String)c._2(), this.sparkConf$1);
            }
            {
                this.sparkConf$1 = sparkConf$1;
            }
        });
    }

    public void setNodeAndCore(int nodeNum, int coreNum) {
        this.setNodeNumber(nodeNum);
        this.setCoreNumber(coreNum);
    }

    public void reset() {
        this.nodeNum_$eq(1);
        this.physicalCoreNumber_$eq(1);
    }

    private Option<Object> dynamicAllocationExecutor(SparkConf conf) {
        None$ none$;
        String string = conf.get("spark.dynamicAllocation.enabled", null);
        String string2 = "true";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            int minExecutors;
            int maxExecutors = new StringOps(Predef$.MODULE$.augmentString(conf.get("spark.dynamicAllocation.maxExecutors", "1"))).toInt();
            Log4Error$.MODULE$.invalidInputError(maxExecutors == (minExecutors = new StringOps(Predef$.MODULE$.augmentString(conf.get("spark.dynamicAllocation.minExecutors", "1"))).toInt()), "Engine.init: spark.dynamicAllocation.maxExecutors and spark.dynamicAllocation.minExecutors must be identical in dynamic allocation for BigDL", Log4Error$.MODULE$.invalidInputError$default$3());
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)minExecutors));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Tuple2<Object, Object>> sparkExecutorAndCore() {
        Option<Tuple2<Object, Object>> option;
        try {
            option = this.parseExecutorAndCore(SparkContext$.MODULE$.getOrCreate().getConf());
        }
        catch (SparkException sparkException) {
            if (sparkException.getMessage().contains("A master URL must be set in your configuration")) {
                Log4Error$.MODULE$.invalidOperationError(false, "A master URL must be set in your configuration. Or if you want to run BigDL in a local JVM environment, you should set Java property bigdl.localMode=true", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            }
            boolean x$17 = false;
            String x$18 = sparkException.getMessage();
            SparkException x$19 = sparkException;
            String x$20 = Log4Error$.MODULE$.unKnowExceptionError$default$3();
            Log4Error$.MODULE$.unKnowExceptionError(x$17, x$18, x$20, x$19);
            option = null;
        }
        return option;
    }

    public Option<Tuple2<Object, Object>> parseExecutorAndCore(SparkConf conf) {
        Some some;
        String master = conf.get("spark.master", null);
        if (master.toLowerCase().startsWith("local")) {
            Some some2;
            Regex patternLocalN = new StringOps(Predef$.MODULE$.augmentString("local\\[(\\d+)\\]")).r();
            Regex patternLocalNF = new StringOps(Predef$.MODULE$.augmentString("local\\[(\\d+),\\s*(\\d+)\\]")).r();
            Regex patternLocalStar = new StringOps(Predef$.MODULE$.augmentString("local\\[\\*\\]")).r();
            Regex patternLocalStarF = new StringOps(Predef$.MODULE$.augmentString("local\\[\\*,\\s*(\\d+)\\]")).r();
            String string = master;
            Option option = patternLocalN.unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String n = (String)((LinearSeqOptimized)option.get()).apply(0);
                some2 = new Some((Object)new Tuple2.mcII.sp(1, new StringOps(Predef$.MODULE$.augmentString(n)).toInt()));
            } else {
                Option option2 = patternLocalNF.unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                    String n = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    some2 = new Some((Object)new Tuple2.mcII.sp(1, new StringOps(Predef$.MODULE$.augmentString(n)).toInt()));
                } else {
                    Option option3 = patternLocalStar.unapplySeq((CharSequence)string);
                    if (option3.isEmpty()) {
                        Option option4 = patternLocalStarF.unapplySeq((CharSequence)string);
                        if (option4.isEmpty()) {
                            Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't parse master ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{master})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                            some2 = new Some((Object)new Tuple2.mcII.sp(1, 0));
                        } else {
                            some2 = new Some((Object)new Tuple2.mcII.sp(1, this.getNumMachineCores()));
                        }
                    } else {
                        some2 = new Some((Object)new Tuple2.mcII.sp(1, this.getNumMachineCores()));
                    }
                }
            }
            some = some2;
        } else if (master.toLowerCase().startsWith("spark")) {
            String coreString = conf.get("spark.executor.cores", null);
            String maxString = conf.get("spark.cores.max", null);
            Log4Error$.MODULE$.invalidInputError(coreString != null, "Engine.init: Can't find executor core number, do you submit with --executor-cores option", Log4Error$.MODULE$.invalidInputError$default$3());
            Log4Error$.MODULE$.invalidInputError(maxString != null, "Engine.init: Can't find total core number. Do you submit with --total-executor-cores", Log4Error$.MODULE$.invalidInputError$default$3());
            int core = new StringOps(Predef$.MODULE$.augmentString(coreString)).toInt();
            int nodeNum = BoxesRunTime.unboxToInt((Object)this.dynamicAllocationExecutor(conf).getOrElse((Function0)new Serializable(maxString, core){
                public static final long serialVersionUID = 0L;
                private final String maxString$1;
                private final int core$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    int total = new StringOps(Predef$.MODULE$.augmentString(this.maxString$1)).toInt();
                    Log4Error$.MODULE$.invalidInputError(total >= this.core$1 && total % this.core$1 == 0, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Engine.init: total core "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number(", ") can't be divided "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)total)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"by single core number(", ") provided to spark-submit"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.core$1)}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
                    return total / this.core$1;
                }
                {
                    this.maxString$1 = maxString$1;
                    this.core$1 = core$1;
                }
            }));
            some = new Some((Object)new Tuple2.mcII.sp(nodeNum, core));
        } else if (master.toLowerCase().startsWith("yarn")) {
            String coreString = conf.get("spark.executor.cores", null);
            Log4Error$.MODULE$.invalidInputError(coreString != null, "Engine.init: Can't find executor core number, do you submit with --executor-cores option", Log4Error$.MODULE$.invalidInputError$default$3());
            int core = new StringOps(Predef$.MODULE$.augmentString(coreString)).toInt();
            int node = BoxesRunTime.unboxToInt((Object)this.dynamicAllocationExecutor(conf).getOrElse((Function0)new Serializable(conf){
                public static final long serialVersionUID = 0L;
                private final SparkConf conf$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    String numExecutorString = this.conf$1.get("spark.executor.instances", null);
                    Log4Error$.MODULE$.invalidInputError(numExecutorString != null, "Engine.init: Can't find executor number, do you submit with --num-executors option", Log4Error$.MODULE$.invalidInputError$default$3());
                    return new StringOps(Predef$.MODULE$.augmentString(numExecutorString)).toInt();
                }
                {
                    this.conf$1 = conf$1;
                }
            }));
            some = new Some((Object)new Tuple2.mcII.sp(node, core));
        } else if (master.toLowerCase().startsWith("mesos")) {
            String string = conf.get("spark.mesos.coarse", null);
            String string2 = "false";
            Log4Error$.MODULE$.invalidInputError(string != null ? !string.equals(string2) : string2 != null, "Engine.init: Don't support mesos fine-grained mode", Log4Error$.MODULE$.invalidInputError$default$3());
            String coreString = conf.get("spark.executor.cores", null);
            Log4Error$.MODULE$.invalidInputError(coreString != null, "Engine.init: Can't find executor core number, do you submit with --executor-cores option", Log4Error$.MODULE$.invalidInputError$default$3());
            int core = new StringOps(Predef$.MODULE$.augmentString(coreString)).toInt();
            int nodeNum = BoxesRunTime.unboxToInt((Object)this.dynamicAllocationExecutor(conf).getOrElse((Function0)new Serializable(conf, core){
                public static final long serialVersionUID = 0L;
                private final SparkConf conf$1;
                private final int core$2;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    String maxString = this.conf$1.get("spark.cores.max", null);
                    Log4Error$.MODULE$.invalidInputError(maxString != null, "Engine.init: Can't find total core number. Do you submit with --total-executor-cores", Log4Error$.MODULE$.invalidInputError$default$3());
                    int total = new StringOps(Predef$.MODULE$.augmentString(maxString)).toInt();
                    Log4Error$.MODULE$.invalidInputError(total >= this.core$2 && total % this.core$2 == 0, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Engine.init: total core "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number(", ") can't be divided "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)total)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"by single core number(", ") provided to spark-submit"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.core$2)}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
                    return total / this.core$2;
                }
                {
                    this.conf$1 = conf$1;
                    this.core$2 = core$2;
                }
            }));
            some = new Some((Object)new Tuple2.mcII.sp(nodeNum, core));
        } else if (master.toLowerCase().startsWith("k8s")) {
            String coreString = conf.get("spark.executor.cores", null);
            String maxString = conf.get("spark.cores.max", null);
            Log4Error$.MODULE$.invalidInputError(coreString != null, "Engine.init: Can't find executor core number, do you submit with --conf spark.executor.cores option", Log4Error$.MODULE$.invalidInputError$default$3());
            Log4Error$.MODULE$.invalidInputError(maxString != null, "Engine.init: Can't find total core number. Do you submit with --conf spark.cores.max option", Log4Error$.MODULE$.invalidInputError$default$3());
            int core = new StringOps(Predef$.MODULE$.augmentString(coreString)).toInt();
            int nodeNum = BoxesRunTime.unboxToInt((Object)this.dynamicAllocationExecutor(conf).getOrElse((Function0)new Serializable(maxString, core){
                public static final long serialVersionUID = 0L;
                private final String maxString$2;
                private final int core$3;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    int total = new StringOps(Predef$.MODULE$.augmentString(this.maxString$2)).toInt();
                    Log4Error$.MODULE$.invalidInputError(total >= this.core$3 && total % this.core$3 == 0, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Engine.init: total core "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number(", ") can't be divided "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)total)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"by single core number(", ") provided to spark-submit"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.core$3)}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
                    return total / this.core$3;
                }
                {
                    this.maxString$2 = maxString$2;
                    this.core$3 = core$3;
                }
            }));
            some = new Some((Object)new Tuple2.mcII.sp(nodeNum, core));
        } else {
            Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Engine.init: Unsupported master format ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{master})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            some = new Some((Object)new Tuple2.mcII.sp(1, 0));
        }
        return some;
    }

    private void setMklDnnEnvironments() {
        int[] affinityCores = Affinity.getAffinity();
        int physicalCoreNum = CpuInfo.getPhysicalProcessorCount();
        int affinityCoreNum = affinityCores.length;
        int n = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(affinityCores).min((Ordering)Ordering.Int$.MODULE$)) > 0 && BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(affinityCores).max((Ordering)Ordering.Int$.MODULE$)) >= this.physicalCoreNumber() ? affinityCoreNum : (physicalCoreNum > affinityCoreNum ? affinityCoreNum : physicalCoreNum);
        String threadsNumber = System.getProperty("bigdl.mklNumThreads", ((Object)BoxesRunTime.boxToInteger((int)n)).toString());
        System.setProperty("bigdl.mklNumThreads", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{threadsNumber})));
        System.setProperty("bigdl.disable.mklBlockTime", "true");
        System.setProperty("bigdl.coreNumber", "1");
    }

    private void initDnnThread() {
        EngineType engineType = this.engineType();
        MklDnn$ mklDnn$ = MklDnn$.MODULE$;
        if (!(engineType != null ? !engineType.equals(mklDnn$) : mklDnn$ != null)) {
            this.dnnComputing().setMKLThreadOfMklDnnBackend(MKL.getMklNumThreads());
        }
    }

    public final void com$intel$analytics$bigdl$dllib$utils$Engine$$verify$1(String key, String value2, SparkConf sparkConf$1) {
        Option v = sparkConf$1.getOption(key);
        if (v.isDefined()) {
            Object object = v.get();
            String string = value2;
            if (object == null ? string != null : !object.equals(string)) {
                this.logger().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Engine.init: ", " should be ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, value2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but it is ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v.get()}))).append((Object)this.SPARK_CONF_WARN()).toString());
            }
        } else {
            this.logger().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Engine.init: Can not find ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key}))).append((Object)this.SPARK_CONF_WARN()).toString());
        }
    }

    private Engine$() {
        OptimizerVersion optimizerVersion;
        Product product;
        MODULE$ = this;
        String string = System.getProperty("bigdl.engineType");
        String string2 = "mkldnn";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = System.getProperty("bigdl.multiModels", "false");
            String string4 = "false";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                this.setMklDnnEnvironments();
            }
        }
        this.logger = LogManager.getLogger(this.getClass());
        this.singletonCounter = new AtomicBoolean();
        this.physicalCoreNumber = -1;
        this.nodeNum = -1;
        this.com$intel$analytics$bigdl$dllib$utils$Engine$$gatewayServer = null;
        this.NOT_INIT_ERROR = "Do you call Engine.init? See more at https://bigdl-project.github.io/master/#APIGuide/Engine/";
        this.SPARK_CONF_WARN = "For details please check https://bigdl-project.github.io/master/#APIGuide/Engine/";
        String string5 = System.getProperty("bigdl.engineType", "mklblas").toLowerCase(Locale.ROOT);
        if ("mklblas".equals(string5)) {
            product = MklBlas$.MODULE$;
        } else if ("mkldnn".equals(string5)) {
            product = MklDnn$.MODULE$;
        } else if ("nonemkl".equals(string5)) {
            product = NoneMkl$.MODULE$;
        } else {
            Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown engine type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string5})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            product = MklDnn$.MODULE$;
        }
        this.engineType = product;
        String string6 = System.getProperty("bigdl.optimizerVersion", "optimizerv1").toLowerCase(Locale.ROOT);
        if ("optimizerv1".equals(string6)) {
            optimizerVersion = OptimizerV1$.MODULE$;
        } else if ("optimizerv2".equals(string6)) {
            optimizerVersion = OptimizerV2$.MODULE$;
        } else {
            Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string6})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            optimizerVersion = OptimizerV2$.MODULE$;
        }
        this.optimizerVersion = optimizerVersion;
        this._default = null;
        this._model = new ThreadPool(1);
        this.wrapperComputing = null;
        this.dnnComputing = new ThreadPool(1);
        this.initDnnThread();
    }
}

