/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.tensor;

import com.intel.analytics.bigdl.dllib.tensor.DenseTensor;
import com.intel.analytics.bigdl.dllib.tensor.DoubleType$;
import com.intel.analytics.bigdl.dllib.tensor.FloatType$;
import com.intel.analytics.bigdl.dllib.tensor.SparseTensor;
import com.intel.analytics.bigdl.dllib.tensor.Storage;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.TensorDataType;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SparseTensorBLAS$ {
    public static final SparseTensorBLAS$ MODULE$;

    static {
        new SparseTensorBLAS$();
    }

    public <T> T vdot(DenseTensor<T> vec1, SparseTensor<T> vec2) {
        Number number;
        TensorDataType tensorDataType = vec1.getType();
        if (FloatType$.MODULE$.equals(tensorDataType)) {
            number = BoxesRunTime.boxToFloat((float)this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$vdotFloat(vec1, vec2));
        } else if (DoubleType$.MODULE$.equals(tensorDataType)) {
            number = BoxesRunTime.boxToDouble((double)this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$vdotDouble(vec1, vec2));
        } else {
            Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sparse vdot doesn't support ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tensorDataType})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            number = BoxesRunTime.boxToInteger((int)0);
        }
        return (T)number;
    }

    public float com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$vdotFloat(DenseTensor<Object> vec1, SparseTensor<Object> vec2) {
        Log4Error$.MODULE$.unKnowExceptionError(vec1.isContiguous(), "The DenseTensor must be contiguous", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        float[] vec1Values = (float[])vec1.storage().array();
        int vec1StorageOffset = vec1.storageOffset() - 1;
        int[] vect1Strides = vec1.stride();
        float[] vec2Values = (float[])vec2._values().array();
        int vec2storageOffset = vec2.storageOffset() - 1;
        float sum2 = 0.0f;
        for (int valueCounter = 0; valueCounter < vec2.nElement(); ++valueCounter) {
            int vec1Index = 0;
            for (int dim = 0; dim < vec2.nDimension(); ++dim) {
                vec1Index += (BoxesRunTime.unboxToInt((Object)vec2._indices()[dim].apply(valueCounter + vec2storageOffset)) - vec2._indicesOffset()[dim]) * vect1Strides[dim];
            }
            sum2 += vec2Values[vec2storageOffset + valueCounter] * vec1Values[vec1Index + vec1StorageOffset];
        }
        return sum2;
    }

    public double com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$vdotDouble(DenseTensor<Object> vec1, SparseTensor<Object> vec2) {
        Log4Error$.MODULE$.unKnowExceptionError(vec1.isContiguous(), "The DenseTensor must be contiguous", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        double[] vec1Values = (double[])vec1.storage().array();
        int vec1StorageOffset = vec1.storageOffset() - 1;
        int[] vect1Strides = vec1.stride();
        double[] vec2Values = (double[])vec2._values().array();
        int vec2storageOffset = vec2.storageOffset() - 1;
        double sum2 = 0.0;
        for (int valueCounter = 0; valueCounter < vec2.nElement(); ++valueCounter) {
            int vec1Index = 0;
            for (int dim = 0; dim < vec2.nDimension(); ++dim) {
                vec1Index += (BoxesRunTime.unboxToInt((Object)vec2._indices()[dim].apply(valueCounter + vec2storageOffset)) - vec2._indicesOffset()[dim]) * vect1Strides[dim];
            }
            sum2 += vec2Values[vec2storageOffset + valueCounter] * vec1Values[vec1Index + vec1StorageOffset];
        }
        return sum2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public <T> void coomv(T alpha, Tensor<T> mat, Tensor<T> vec, T beta, Tensor<T> r, TensorNumericMath.TensorNumeric<T> ev) {
        Tuple5 tuple5 = new Tuple5(alpha, mat, vec, beta, r);
        if (tuple5 != null) {
            Object alpha2 = tuple5._1();
            Tensor a = (Tensor)tuple5._2();
            Tensor x = (Tensor)tuple5._3();
            Object beta2 = tuple5._4();
            Tensor y = (Tensor)tuple5._5();
            if (alpha2 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)alpha2);
                if (a instanceof SparseTensor) {
                    SparseTensor sparseTensor = (SparseTensor)a;
                    if (x instanceof DenseTensor) {
                        DenseTensor denseTensor = (DenseTensor)x;
                        if (beta2 instanceof Double) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)beta2);
                            if (y instanceof DenseTensor) {
                                DenseTensor denseTensor2 = (DenseTensor)y;
                                this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$dcoomv(d, sparseTensor, denseTensor, d2, denseTensor2);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
            }
        }
        if (tuple5 != null) {
            Object alpha3 = tuple5._1();
            Tensor a = (Tensor)tuple5._2();
            Tensor x = (Tensor)tuple5._3();
            Object beta3 = tuple5._4();
            Tensor y = (Tensor)tuple5._5();
            if (alpha3 instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)alpha3);
                if (a instanceof SparseTensor) {
                    SparseTensor sparseTensor = (SparseTensor)a;
                    if (x instanceof DenseTensor) {
                        DenseTensor denseTensor = (DenseTensor)x;
                        if (beta3 instanceof Float) {
                            float f2 = BoxesRunTime.unboxToFloat((Object)beta3);
                            if (y instanceof DenseTensor) {
                                DenseTensor denseTensor3 = (DenseTensor)y;
                                this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$scoomv(f, sparseTensor, denseTensor, f2, denseTensor3);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
            }
        }
        Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sparse addmv doesn't support"})).s((Seq)Nil$.MODULE$), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$scoomv(float alpha, SparseTensor<Object> A2, DenseTensor<Object> x, float beta, DenseTensor<Object> y) {
        float[] xValues = (float[])x.storage().array();
        int xOffset = x.storageOffset() - 1;
        float[] yValues = (float[])y.storage().array();
        int yOffset = y.storageOffset() - 1;
        int mA = A2._shape()[0];
        int nA = A2._shape()[1];
        float[] Avals = (float[])A2._values().array();
        int AstorageOffset = A2.storageOffset() - 1;
        Storage<Object> Arows = A2._indices()[0];
        int ArowOffset = A2._indicesOffset()[0];
        Storage<Object> Acols = A2._indices()[1];
        int AcolOffset = A2._indicesOffset()[1];
        Object object = (double)beta != 1.0 ? y.mul$mcF$sp(beta) : BoxedUnit.UNIT;
        for (int valueCounter = 0; valueCounter < A2.nElement(); ++valueCounter) {
            int Arow = BoxesRunTime.unboxToInt((Object)Arows.apply(valueCounter + AstorageOffset)) - ArowOffset;
            int Acol = BoxesRunTime.unboxToInt((Object)Acols.apply(valueCounter + AstorageOffset)) - AcolOffset;
            float Aval = Avals[valueCounter + AstorageOffset];
            int n = Arow + yOffset;
            yValues[n] = yValues[n] + Aval * alpha * xValues[Acol + xOffset];
        }
    }

    public void com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$dcoomv(double alpha, SparseTensor<Object> A2, DenseTensor<Object> x, double beta, DenseTensor<Object> y) {
        double[] xValues = (double[])x.storage().array();
        int xOffset = x.storageOffset() - 1;
        double[] yValues = (double[])y.storage().array();
        int yOffset = y.storageOffset() - 1;
        int mA = A2._shape()[0];
        int nA = A2._shape()[1];
        double[] Avals = (double[])A2._values().array();
        int AstorageOffset = A2.storageOffset() - 1;
        Storage<Object> Arows = A2._indices()[0];
        int ArowOffset = A2._indicesOffset()[0];
        Storage<Object> Acols = A2._indices()[1];
        int AcolOffset = A2._indicesOffset()[1];
        Object object = beta != 1.0 ? y.mul$mcD$sp(beta) : BoxedUnit.UNIT;
        for (int valueCounter = 0; valueCounter < A2.nElement(); ++valueCounter) {
            int Arow = BoxesRunTime.unboxToInt((Object)Arows.apply(valueCounter + AstorageOffset)) - ArowOffset;
            int Acol = BoxesRunTime.unboxToInt((Object)Acols.apply(valueCounter + AstorageOffset)) - AcolOffset;
            double Aval = Avals[valueCounter + AstorageOffset];
            int n = Arow + yOffset;
            yValues[n] = yValues[n] + Aval * alpha * xValues[Acol + xOffset];
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public <T> void coomm(T alpha, Tensor<T> mat1, Tensor<T> mat2, T beta, Tensor<T> r, TensorNumericMath.TensorNumeric<T> ev) {
        Tuple5 tuple5 = new Tuple5(alpha, mat1, mat2, beta, r);
        if (tuple5 != null) {
            Object alpha2 = tuple5._1();
            Tensor a = (Tensor)tuple5._2();
            Tensor x = (Tensor)tuple5._3();
            Object beta2 = tuple5._4();
            Tensor y = (Tensor)tuple5._5();
            if (alpha2 instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)alpha2);
                if (a instanceof SparseTensor) {
                    SparseTensor sparseTensor = (SparseTensor)a;
                    if (x instanceof DenseTensor) {
                        DenseTensor denseTensor = (DenseTensor)x;
                        if (beta2 instanceof Float) {
                            float f2 = BoxesRunTime.unboxToFloat((Object)beta2);
                            if (y instanceof DenseTensor) {
                                DenseTensor denseTensor2 = (DenseTensor)y;
                                this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$scoomm(f, sparseTensor, denseTensor, f2, (DenseTensor<Object>)denseTensor2);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
            }
        }
        if (tuple5 != null) {
            Object alpha3 = tuple5._1();
            Tensor a = (Tensor)tuple5._2();
            Tensor x = (Tensor)tuple5._3();
            Object beta3 = tuple5._4();
            Tensor y = (Tensor)tuple5._5();
            if (alpha3 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)alpha3);
                if (a instanceof SparseTensor) {
                    SparseTensor sparseTensor = (SparseTensor)a;
                    if (x instanceof DenseTensor) {
                        DenseTensor denseTensor = (DenseTensor)x;
                        if (beta3 instanceof Double) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)beta3);
                            if (y instanceof DenseTensor) {
                                DenseTensor denseTensor3 = (DenseTensor)y;
                                this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$dcoomm(d, sparseTensor, denseTensor, d2, (DenseTensor<Object>)denseTensor3);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
            }
        }
        if (tuple5 != null) {
            Object alpha4 = tuple5._1();
            Tensor a = (Tensor)tuple5._2();
            Tensor x = (Tensor)tuple5._3();
            Object beta4 = tuple5._4();
            Tensor y = (Tensor)tuple5._5();
            if (alpha4 instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)alpha4);
                if (a instanceof DenseTensor) {
                    DenseTensor denseTensor = (DenseTensor)a;
                    if (x instanceof SparseTensor) {
                        SparseTensor sparseTensor = (SparseTensor)x;
                        if (beta4 instanceof Float) {
                            float f3 = BoxesRunTime.unboxToFloat((Object)beta4);
                            if (y instanceof DenseTensor) {
                                DenseTensor denseTensor4 = (DenseTensor)y;
                                this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$scoomm(f, denseTensor, sparseTensor, f3, (DenseTensor<Object>)denseTensor4);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
            }
        }
        if (tuple5 != null) {
            Object alpha5 = tuple5._1();
            Tensor a = (Tensor)tuple5._2();
            Tensor x = (Tensor)tuple5._3();
            Object beta5 = tuple5._4();
            Tensor y = (Tensor)tuple5._5();
            if (alpha5 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)alpha5);
                if (a instanceof DenseTensor) {
                    DenseTensor denseTensor = (DenseTensor)a;
                    if (x instanceof SparseTensor) {
                        SparseTensor sparseTensor = (SparseTensor)x;
                        if (beta5 instanceof Double) {
                            double d3 = BoxesRunTime.unboxToDouble((Object)beta5);
                            if (y instanceof DenseTensor) {
                                DenseTensor denseTensor5 = (DenseTensor)y;
                                this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$dcoomm(d, denseTensor, sparseTensor, d3, (DenseTensor<Object>)denseTensor5);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
            }
        }
        Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sparse addmm doesn't support"})).s((Seq)Nil$.MODULE$), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$scoomm(float alpha, SparseTensor<Object> A2, DenseTensor<Object> B, float beta, DenseTensor<Object> C2) {
        int index;
        int mA = A2._shape()[0];
        int nB = B.size(2);
        int kA = A2._shape()[1];
        int kB = B.size(1);
        float[] Avals = (float[])A2._values().array();
        int AstorageOffset = A2.storageOffset() - 1;
        Storage<Object> ArowIndices = A2._indices()[0];
        int ArowOffset = A2._indicesOffset()[0];
        Storage<Object> AcolIndices = A2._indices()[1];
        int AcolOffset = A2._indicesOffset()[1];
        float[] Bvals = (float[])B.storage().array();
        int bOffset = B.storageOffset() - 1;
        float[] Cvals = (float[])C2.storage().array();
        int cOffset = C2.storageOffset() - 1;
        Object object = (double)beta != 1.0 ? C2.mul$mcF$sp(beta) : BoxedUnit.UNIT;
        if (B.stride(2) == 1 && B.size(2) == B.stride(1)) {
            for (index = 0; index < A2.nElement(); ++index) {
                int curMA = BoxesRunTime.unboxToInt((Object)ArowIndices.apply(index + AstorageOffset)) - ArowOffset;
                int curKA = BoxesRunTime.unboxToInt((Object)AcolIndices.apply(index + AstorageOffset)) - AcolOffset;
                for (int n = 0; n < nB; ++n) {
                    int n2 = curMA * nB + n;
                    Cvals[n2] = Cvals[n2] + alpha * Avals[index + AstorageOffset] * Bvals[curKA * nB + n + bOffset];
                }
            }
        } else {
            while (index < A2.nElement()) {
                int curMA = BoxesRunTime.unboxToInt((Object)ArowIndices.apply(index + AstorageOffset)) - ArowOffset;
                int curKA = BoxesRunTime.unboxToInt((Object)AcolIndices.apply(index + AstorageOffset)) - AcolOffset;
                for (int n = 0; n < nB; ++n) {
                    int n3 = curMA * nB + n + cOffset;
                    Cvals[n3] = Cvals[n3] + alpha * Avals[index + AstorageOffset] * Bvals[curKA + n * kB + bOffset];
                }
                ++index;
            }
        }
    }

    public void com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$dcoomm(double alpha, SparseTensor<Object> A2, DenseTensor<Object> B, double beta, DenseTensor<Object> C2) {
        int index;
        int mA = A2._shape()[0];
        int nB = B.size(2);
        int kA = A2._shape()[1];
        int kB = B.size(1);
        double[] Avals = (double[])A2._values().array();
        int AstorageOffset = A2.storageOffset() - 1;
        Storage<Object> ArowIndices = A2._indices()[0];
        int ArowOffset = A2._indicesOffset()[0];
        Storage<Object> AcolIndices = A2._indices()[1];
        int AcolOffset = A2._indicesOffset()[1];
        double[] Bvals = (double[])B.storage().array();
        int bOffset = B.storageOffset() - 1;
        double[] Cvals = (double[])C2.storage().array();
        int cOffset = C2.storageOffset() - 1;
        Object object = beta != 1.0 ? C2.mul$mcD$sp(beta) : BoxedUnit.UNIT;
        if (B.stride(2) == 1 && B.size(2) == B.stride(1)) {
            for (index = 0; index < A2.nElement(); ++index) {
                int curMA = BoxesRunTime.unboxToInt((Object)ArowIndices.apply(index + AstorageOffset)) - ArowOffset;
                int curKA = BoxesRunTime.unboxToInt((Object)AcolIndices.apply(index + AstorageOffset)) - AcolOffset;
                for (int n = 0; n < nB; ++n) {
                    int n2 = curMA * nB + n;
                    Cvals[n2] = Cvals[n2] + alpha * Avals[index + AstorageOffset] * Bvals[curKA * nB + n + bOffset];
                }
            }
        } else {
            while (index < A2.nElement()) {
                int curMA = BoxesRunTime.unboxToInt((Object)ArowIndices.apply(index + AstorageOffset)) - ArowOffset;
                int curKA = BoxesRunTime.unboxToInt((Object)AcolIndices.apply(index + AstorageOffset)) - AcolOffset;
                for (int n = 0; n < nB; ++n) {
                    int n3 = curMA * nB + n + cOffset;
                    Cvals[n3] = Cvals[n3] + alpha * Avals[index + AstorageOffset] * Bvals[curKA + n * kB + bOffset];
                }
                ++index;
            }
        }
    }

    public void com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$scoomm(float alpha, DenseTensor<Object> A2, SparseTensor<Object> B, float beta, DenseTensor<Object> C2) {
        int index;
        int kB = B.size(1);
        int nB = B.size(2);
        int mA = A2.size(1);
        int kA = A2.size(2);
        float[] Avals = (float[])A2.storage().array();
        int aOffset = A2.storageOffset() - 1;
        float[] Cvals = (float[])C2.storage().array();
        int cOffset = C2.storageOffset() - 1;
        float[] Bvals = (float[])B._values().array();
        int BstorageOffset = B.storageOffset() - 1;
        Storage<Object> BrowIndices = B._indices()[0];
        int BrowIndicesOffset = B._indicesOffset()[0];
        Storage<Object> BcolIndices = B._indices()[1];
        int BcolIndicesOffset = B._indicesOffset()[1];
        Object object = (double)beta != 1.0 ? C2.mul$mcF$sp(beta) : BoxedUnit.UNIT;
        if (A2.stride(2) == 1 && A2.size(2) == A2.stride(1)) {
            for (index = 0; index < B.nElement(); ++index) {
                int curKB = BoxesRunTime.unboxToInt((Object)BrowIndices.apply(index + BstorageOffset)) - BrowIndicesOffset;
                int curNB = BoxesRunTime.unboxToInt((Object)BcolIndices.apply(index + BstorageOffset)) - BcolIndicesOffset;
                for (int n = 0; n < mA; ++n) {
                    int n2 = n * nB + curNB + cOffset;
                    Cvals[n2] = Cvals[n2] + alpha * Bvals[index + BstorageOffset] * Avals[n * kA + curKB + aOffset];
                }
            }
        } else {
            while (index < B.nElement()) {
                int curKB = BoxesRunTime.unboxToInt((Object)BrowIndices.apply(index + BstorageOffset)) - BrowIndicesOffset;
                int curNB = BoxesRunTime.unboxToInt((Object)BcolIndices.apply(index + BstorageOffset)) - BcolIndicesOffset;
                for (int n = 0; n < mA; ++n) {
                    int n3 = n * nB + curNB + cOffset;
                    Cvals[n3] = Cvals[n3] + alpha * Bvals[index + BstorageOffset] * Avals[n + mA * curKB + aOffset];
                }
                ++index;
            }
        }
    }

    public void com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$dcoomm(double alpha, DenseTensor<Object> A2, SparseTensor<Object> B, double beta, DenseTensor<Object> C2) {
        int index;
        int kB = B.size(1);
        int nB = B.size(2);
        int mA = A2.size(1);
        int kA = A2.size(2);
        double[] Avals = (double[])A2.storage().array();
        int aOffset = A2.storageOffset() - 1;
        double[] Cvals = (double[])C2.storage().array();
        int cOffset = C2.storageOffset() - 1;
        double[] Bvals = (double[])B._values().array();
        int BstorageOffset = B.storageOffset() - 1;
        Storage<Object> BrowIndices = B._indices()[0];
        int BrowIndicesOffset = B._indicesOffset()[0];
        Storage<Object> BcolIndices = B._indices()[1];
        int BcolIndicesOffset = B._indicesOffset()[1];
        Object object = beta != 1.0 ? C2.mul$mcD$sp(beta) : BoxedUnit.UNIT;
        if (A2.stride(2) == 1 && A2.size(2) == A2.stride(1)) {
            for (index = 0; index < B.nElement(); ++index) {
                int curKB = BoxesRunTime.unboxToInt((Object)BrowIndices.apply(index + BstorageOffset)) - BrowIndicesOffset;
                int curNB = BoxesRunTime.unboxToInt((Object)BcolIndices.apply(index + BstorageOffset)) - BcolIndicesOffset;
                for (int n = 0; n < mA; ++n) {
                    int n2 = n * nB + curNB + cOffset;
                    Cvals[n2] = Cvals[n2] + alpha * Bvals[index + BstorageOffset] * Avals[n * kA + curKB + aOffset];
                }
            }
        } else {
            while (index < B.nElement()) {
                int curKB = BoxesRunTime.unboxToInt((Object)BrowIndices.apply(index + BstorageOffset)) - BrowIndicesOffset;
                int curNB = BoxesRunTime.unboxToInt((Object)BcolIndices.apply(index + BstorageOffset)) - BcolIndicesOffset;
                for (int n = 0; n < mA; ++n) {
                    int n3 = n * nB + curNB + cOffset;
                    Cvals[n3] = Cvals[n3] + alpha * Bvals[index + BstorageOffset] * Avals[n + mA * curKB + aOffset];
                }
                ++index;
            }
        }
    }

    public double vdot$mDc$sp(DenseTensor<Object> vec1, SparseTensor<Object> vec2) {
        double d;
        TensorDataType tensorDataType = vec1.getType();
        if (FloatType$.MODULE$.equals(tensorDataType)) {
            d = this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$vdotFloat(vec1, vec2);
        } else if (DoubleType$.MODULE$.equals(tensorDataType)) {
            d = this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$vdotDouble(vec1, vec2);
        } else {
            Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sparse vdot doesn't support ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tensorDataType})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            d = 0.0;
        }
        return d;
    }

    public float vdot$mFc$sp(DenseTensor<Object> vec1, SparseTensor<Object> vec2) {
        float f;
        TensorDataType tensorDataType = vec1.getType();
        if (FloatType$.MODULE$.equals(tensorDataType)) {
            f = this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$vdotFloat(vec1, vec2);
        } else if (DoubleType$.MODULE$.equals(tensorDataType)) {
            f = (float)this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$vdotDouble(vec1, vec2);
        } else {
            Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sparse vdot doesn't support ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tensorDataType})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            f = 0.0f;
        }
        return f;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void coomv$mDc$sp(double alpha, Tensor<Object> mat, Tensor<Object> vec, double beta, Tensor<Object> r, TensorNumericMath.TensorNumeric<Object> ev) {
        Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToDouble((double)alpha), mat, vec, (Object)BoxesRunTime.boxToDouble((double)beta), r);
        if (tuple5 != null) {
            double alpha2 = BoxesRunTime.unboxToDouble((Object)tuple5._1());
            Tensor a = (Tensor)tuple5._2();
            Tensor x = (Tensor)tuple5._3();
            double beta2 = BoxesRunTime.unboxToDouble((Object)tuple5._4());
            Tensor y = (Tensor)tuple5._5();
            if (BoxesRunTime.boxToDouble((double)alpha2) instanceof Double) {
                double d = alpha2;
                if (a instanceof SparseTensor) {
                    SparseTensor sparseTensor = (SparseTensor)a;
                    if (x instanceof DenseTensor) {
                        DenseTensor denseTensor = (DenseTensor)x;
                        if (BoxesRunTime.boxToDouble((double)beta2) instanceof Double) {
                            double d2 = beta2;
                            if (y instanceof DenseTensor) {
                                DenseTensor denseTensor2 = (DenseTensor)y;
                                this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$dcoomv(d, sparseTensor, denseTensor, d2, denseTensor2);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
            }
        }
        if (tuple5 != null) {
            double alpha3 = BoxesRunTime.unboxToDouble((Object)tuple5._1());
            Tensor a = (Tensor)tuple5._2();
            Tensor x = (Tensor)tuple5._3();
            double beta3 = BoxesRunTime.unboxToDouble((Object)tuple5._4());
            Tensor y = (Tensor)tuple5._5();
            if (BoxesRunTime.boxToDouble((double)alpha3) instanceof Float) {
                double d = BoxesRunTime.unboxToDouble((Object)BoxesRunTime.boxToDouble((double)alpha3));
                if (a instanceof SparseTensor) {
                    SparseTensor sparseTensor = (SparseTensor)a;
                    if (x instanceof DenseTensor) {
                        DenseTensor denseTensor = (DenseTensor)x;
                        if (BoxesRunTime.boxToDouble((double)beta3) instanceof Float) {
                            double d3 = BoxesRunTime.unboxToDouble((Object)BoxesRunTime.boxToDouble((double)beta3));
                            if (y instanceof DenseTensor) {
                                DenseTensor denseTensor3 = (DenseTensor)y;
                                this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$scoomv((float)d, sparseTensor, denseTensor, (float)d3, denseTensor3);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
            }
        }
        Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sparse addmv doesn't support"})).s((Seq)Nil$.MODULE$), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void coomv$mFc$sp(float alpha, Tensor<Object> mat, Tensor<Object> vec, float beta, Tensor<Object> r, TensorNumericMath.TensorNumeric<Object> ev) {
        Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToFloat((float)alpha), mat, vec, (Object)BoxesRunTime.boxToFloat((float)beta), r);
        if (tuple5 != null) {
            float alpha2 = BoxesRunTime.unboxToFloat((Object)tuple5._1());
            Tensor a = (Tensor)tuple5._2();
            Tensor x = (Tensor)tuple5._3();
            float beta2 = BoxesRunTime.unboxToFloat((Object)tuple5._4());
            Tensor y = (Tensor)tuple5._5();
            if (BoxesRunTime.boxToFloat((float)alpha2) instanceof Double) {
                float f = BoxesRunTime.unboxToFloat((Object)BoxesRunTime.boxToFloat((float)alpha2));
                if (a instanceof SparseTensor) {
                    SparseTensor sparseTensor = (SparseTensor)a;
                    if (x instanceof DenseTensor) {
                        DenseTensor denseTensor = (DenseTensor)x;
                        if (BoxesRunTime.boxToFloat((float)beta2) instanceof Double) {
                            float f2 = BoxesRunTime.unboxToFloat((Object)BoxesRunTime.boxToFloat((float)beta2));
                            if (y instanceof DenseTensor) {
                                DenseTensor denseTensor2 = (DenseTensor)y;
                                this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$dcoomv(f, sparseTensor, denseTensor, f2, denseTensor2);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
            }
        }
        if (tuple5 != null) {
            float alpha3 = BoxesRunTime.unboxToFloat((Object)tuple5._1());
            Tensor a = (Tensor)tuple5._2();
            Tensor x = (Tensor)tuple5._3();
            float beta3 = BoxesRunTime.unboxToFloat((Object)tuple5._4());
            Tensor y = (Tensor)tuple5._5();
            if (BoxesRunTime.boxToFloat((float)alpha3) instanceof Float) {
                float f = alpha3;
                if (a instanceof SparseTensor) {
                    SparseTensor sparseTensor = (SparseTensor)a;
                    if (x instanceof DenseTensor) {
                        DenseTensor denseTensor = (DenseTensor)x;
                        if (BoxesRunTime.boxToFloat((float)beta3) instanceof Float) {
                            float f3 = beta3;
                            if (y instanceof DenseTensor) {
                                DenseTensor denseTensor3 = (DenseTensor)y;
                                this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$scoomv(f, sparseTensor, denseTensor, f3, denseTensor3);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
            }
        }
        Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sparse addmv doesn't support"})).s((Seq)Nil$.MODULE$), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void coomm$mDc$sp(double alpha, Tensor<Object> mat1, Tensor<Object> mat2, double beta, Tensor<Object> r, TensorNumericMath.TensorNumeric<Object> ev) {
        Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToDouble((double)alpha), mat1, mat2, (Object)BoxesRunTime.boxToDouble((double)beta), r);
        if (tuple5 != null) {
            double alpha2 = BoxesRunTime.unboxToDouble((Object)tuple5._1());
            Tensor a = (Tensor)tuple5._2();
            Tensor x = (Tensor)tuple5._3();
            double beta2 = BoxesRunTime.unboxToDouble((Object)tuple5._4());
            Tensor y = (Tensor)tuple5._5();
            if (BoxesRunTime.boxToDouble((double)alpha2) instanceof Float) {
                double d = BoxesRunTime.unboxToDouble((Object)BoxesRunTime.boxToDouble((double)alpha2));
                if (a instanceof SparseTensor) {
                    SparseTensor sparseTensor = (SparseTensor)a;
                    if (x instanceof DenseTensor) {
                        DenseTensor denseTensor = (DenseTensor)x;
                        if (BoxesRunTime.boxToDouble((double)beta2) instanceof Float) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)BoxesRunTime.boxToDouble((double)beta2));
                            if (y instanceof DenseTensor) {
                                DenseTensor denseTensor2 = (DenseTensor)y;
                                this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$scoomm((float)d, sparseTensor, denseTensor, (float)d2, (DenseTensor<Object>)denseTensor2);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
            }
        }
        if (tuple5 != null) {
            double alpha3 = BoxesRunTime.unboxToDouble((Object)tuple5._1());
            Tensor a = (Tensor)tuple5._2();
            Tensor x = (Tensor)tuple5._3();
            double beta3 = BoxesRunTime.unboxToDouble((Object)tuple5._4());
            Tensor y = (Tensor)tuple5._5();
            if (BoxesRunTime.boxToDouble((double)alpha3) instanceof Double) {
                double d = alpha3;
                if (a instanceof SparseTensor) {
                    SparseTensor sparseTensor = (SparseTensor)a;
                    if (x instanceof DenseTensor) {
                        DenseTensor denseTensor = (DenseTensor)x;
                        if (BoxesRunTime.boxToDouble((double)beta3) instanceof Double) {
                            double d3 = beta3;
                            if (y instanceof DenseTensor) {
                                DenseTensor denseTensor3 = (DenseTensor)y;
                                this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$dcoomm(d, sparseTensor, denseTensor, d3, (DenseTensor<Object>)denseTensor3);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
            }
        }
        if (tuple5 != null) {
            double alpha4 = BoxesRunTime.unboxToDouble((Object)tuple5._1());
            Tensor a = (Tensor)tuple5._2();
            Tensor x = (Tensor)tuple5._3();
            double beta4 = BoxesRunTime.unboxToDouble((Object)tuple5._4());
            Tensor y = (Tensor)tuple5._5();
            if (BoxesRunTime.boxToDouble((double)alpha4) instanceof Float) {
                double d = BoxesRunTime.unboxToDouble((Object)BoxesRunTime.boxToDouble((double)alpha4));
                if (a instanceof DenseTensor) {
                    DenseTensor denseTensor = (DenseTensor)a;
                    if (x instanceof SparseTensor) {
                        SparseTensor sparseTensor = (SparseTensor)x;
                        if (BoxesRunTime.boxToDouble((double)beta4) instanceof Float) {
                            double d4 = BoxesRunTime.unboxToDouble((Object)BoxesRunTime.boxToDouble((double)beta4));
                            if (y instanceof DenseTensor) {
                                DenseTensor denseTensor4 = (DenseTensor)y;
                                this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$scoomm((float)d, denseTensor, sparseTensor, (float)d4, (DenseTensor<Object>)denseTensor4);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
            }
        }
        if (tuple5 != null) {
            double alpha5 = BoxesRunTime.unboxToDouble((Object)tuple5._1());
            Tensor a = (Tensor)tuple5._2();
            Tensor x = (Tensor)tuple5._3();
            double beta5 = BoxesRunTime.unboxToDouble((Object)tuple5._4());
            Tensor y = (Tensor)tuple5._5();
            if (BoxesRunTime.boxToDouble((double)alpha5) instanceof Double) {
                double d = alpha5;
                if (a instanceof DenseTensor) {
                    DenseTensor denseTensor = (DenseTensor)a;
                    if (x instanceof SparseTensor) {
                        SparseTensor sparseTensor = (SparseTensor)x;
                        if (BoxesRunTime.boxToDouble((double)beta5) instanceof Double) {
                            double d5 = beta5;
                            if (y instanceof DenseTensor) {
                                DenseTensor denseTensor5 = (DenseTensor)y;
                                this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$dcoomm(d, denseTensor, sparseTensor, d5, (DenseTensor<Object>)denseTensor5);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
            }
        }
        Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sparse addmm doesn't support"})).s((Seq)Nil$.MODULE$), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void coomm$mFc$sp(float alpha, Tensor<Object> mat1, Tensor<Object> mat2, float beta, Tensor<Object> r, TensorNumericMath.TensorNumeric<Object> ev) {
        Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToFloat((float)alpha), mat1, mat2, (Object)BoxesRunTime.boxToFloat((float)beta), r);
        if (tuple5 != null) {
            float alpha2 = BoxesRunTime.unboxToFloat((Object)tuple5._1());
            Tensor a = (Tensor)tuple5._2();
            Tensor x = (Tensor)tuple5._3();
            float beta2 = BoxesRunTime.unboxToFloat((Object)tuple5._4());
            Tensor y = (Tensor)tuple5._5();
            if (BoxesRunTime.boxToFloat((float)alpha2) instanceof Float) {
                float f = alpha2;
                if (a instanceof SparseTensor) {
                    SparseTensor sparseTensor = (SparseTensor)a;
                    if (x instanceof DenseTensor) {
                        DenseTensor denseTensor = (DenseTensor)x;
                        if (BoxesRunTime.boxToFloat((float)beta2) instanceof Float) {
                            float f2 = beta2;
                            if (y instanceof DenseTensor) {
                                DenseTensor denseTensor2 = (DenseTensor)y;
                                this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$scoomm(f, sparseTensor, denseTensor, f2, (DenseTensor<Object>)denseTensor2);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
            }
        }
        if (tuple5 != null) {
            float alpha3 = BoxesRunTime.unboxToFloat((Object)tuple5._1());
            Tensor a = (Tensor)tuple5._2();
            Tensor x = (Tensor)tuple5._3();
            float beta3 = BoxesRunTime.unboxToFloat((Object)tuple5._4());
            Tensor y = (Tensor)tuple5._5();
            if (BoxesRunTime.boxToFloat((float)alpha3) instanceof Double) {
                float f = BoxesRunTime.unboxToFloat((Object)BoxesRunTime.boxToFloat((float)alpha3));
                if (a instanceof SparseTensor) {
                    SparseTensor sparseTensor = (SparseTensor)a;
                    if (x instanceof DenseTensor) {
                        DenseTensor denseTensor = (DenseTensor)x;
                        if (BoxesRunTime.boxToFloat((float)beta3) instanceof Double) {
                            float f3 = BoxesRunTime.unboxToFloat((Object)BoxesRunTime.boxToFloat((float)beta3));
                            if (y instanceof DenseTensor) {
                                DenseTensor denseTensor3 = (DenseTensor)y;
                                this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$dcoomm((double)f, sparseTensor, denseTensor, (double)f3, (DenseTensor<Object>)denseTensor3);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
            }
        }
        if (tuple5 != null) {
            float alpha4 = BoxesRunTime.unboxToFloat((Object)tuple5._1());
            Tensor a = (Tensor)tuple5._2();
            Tensor x = (Tensor)tuple5._3();
            float beta4 = BoxesRunTime.unboxToFloat((Object)tuple5._4());
            Tensor y = (Tensor)tuple5._5();
            if (BoxesRunTime.boxToFloat((float)alpha4) instanceof Float) {
                float f = alpha4;
                if (a instanceof DenseTensor) {
                    DenseTensor denseTensor = (DenseTensor)a;
                    if (x instanceof SparseTensor) {
                        SparseTensor sparseTensor = (SparseTensor)x;
                        if (BoxesRunTime.boxToFloat((float)beta4) instanceof Float) {
                            float f4 = beta4;
                            if (y instanceof DenseTensor) {
                                DenseTensor denseTensor4 = (DenseTensor)y;
                                this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$scoomm(f, denseTensor, sparseTensor, f4, (DenseTensor<Object>)denseTensor4);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
            }
        }
        if (tuple5 != null) {
            float alpha5 = BoxesRunTime.unboxToFloat((Object)tuple5._1());
            Tensor a = (Tensor)tuple5._2();
            Tensor x = (Tensor)tuple5._3();
            float beta5 = BoxesRunTime.unboxToFloat((Object)tuple5._4());
            Tensor y = (Tensor)tuple5._5();
            if (BoxesRunTime.boxToFloat((float)alpha5) instanceof Double) {
                float f = BoxesRunTime.unboxToFloat((Object)BoxesRunTime.boxToFloat((float)alpha5));
                if (a instanceof DenseTensor) {
                    DenseTensor denseTensor = (DenseTensor)a;
                    if (x instanceof SparseTensor) {
                        SparseTensor sparseTensor = (SparseTensor)x;
                        if (BoxesRunTime.boxToFloat((float)beta5) instanceof Double) {
                            float f5 = BoxesRunTime.unboxToFloat((Object)BoxesRunTime.boxToFloat((float)beta5));
                            if (y instanceof DenseTensor) {
                                DenseTensor denseTensor5 = (DenseTensor)y;
                                this.com$intel$analytics$bigdl$dllib$tensor$SparseTensorBLAS$$dcoomm((double)f, denseTensor, sparseTensor, (double)f5, (DenseTensor<Object>)denseTensor5);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                }
            }
        }
        Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sparse addmm doesn't support"})).s((Seq)Nil$.MODULE$), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SparseTensorBLAS$() {
        MODULE$ = this;
    }
}

