/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.tensor;

import com.intel.analytics.bigdl.dllib.tensor.SparseTensor;
import com.intel.analytics.bigdl.dllib.tensor.Storage;
import com.intel.analytics.bigdl.dllib.tensor.Storage$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericInt$;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class SparseTensor$
implements Serializable {
    public static final SparseTensor$ MODULE$;

    static {
        new SparseTensor$();
    }

    public <T> Tensor<T> concat(int dim, Seq<Tensor<T>> tensors, Tensor<T> res, ClassTag<T> evidence$6, TensorNumericMath.TensorNumeric<T> ev) {
        boolean dim1Concat;
        Log4Error$.MODULE$.unKnowExceptionError(dim == 1 || dim == 2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dim should be 1 or 2, but is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dim)})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        ObjectRef size = ObjectRef.create((Object)((Tensor)tensors.head()).size());
        Log4Error$.MODULE$.unKnowExceptionError(((int[])size.elem).length <= 2, "Dimension larger than 2 are not supported yet!", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        tensors.foreach((Function1)new Serializable(size){
            public static final long serialVersionUID = 0L;
            private final ObjectRef size$2;

            public final void apply(Tensor<T> tensor) {
                Log4Error$.MODULE$.unKnowExceptionError(tensor instanceof SparseTensor, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"concat expect tensor is sparseTensor"})).s((Seq)Nil$.MODULE$), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
                Log4Error$.MODULE$.unKnowExceptionError(tensor.dim() == ((int[])this.size$2.elem).length, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tensor.dim() ", " doesn't match size.length ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)tensor.dim()), BoxesRunTime.boxToInteger((int)((int[])this.size$2.elem).length)})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            }
            {
                this.size$2 = size$2;
            }
        });
        boolean bl = dim1Concat = ((int[])size.elem).length == 1 && dim == 1;
        if (dim1Concat) {
            size.elem = (int[])Predef$.MODULE$.intArrayOps(new int[]{1}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps((int[])size.elem), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        }
        for (int i = 1; i < tensors.length(); ++i) {
            int[] nArray = (int[])size.elem;
            int n = dim - 1;
            nArray[n] = nArray[n] + (dim1Concat ? 1 : ((Tensor)tensors.apply(i)).size(dim));
        }
        int totalLength = BoxesRunTime.unboxToInt((Object)((TraversableOnce)tensors.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tensor<T> x$5) {
                return x$5.nElement();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        SparseTensor<T> result2 = res == null ? this.apply((int[])size.elem, totalLength, evidence$6, ev) : (SparseTensor<T>)res.resize((int[])size.elem, totalLength);
        return dim1Concat ? this.concat((Seq)tensors.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SparseTensor<T> apply(Tensor<T> x$6) {
                return (SparseTensor)x$6;
            }
        }, Seq$.MODULE$.canBuildFrom()), result2, evidence$6, ev) : this.concat(dim, (Seq)tensors.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SparseTensor<T> apply(Tensor<T> x$7) {
                return (SparseTensor)x$7;
            }
        }, Seq$.MODULE$.canBuildFrom()), result2, evidence$6, ev);
    }

    private <T> Tensor<T> concat(Seq<SparseTensor<T>> tensors, SparseTensor<T> res, ClassTag<T> evidence$7, TensorNumericMath.TensorNumeric<T> ev) {
        int numOfIndices = res.dim();
        Log4Error$.MODULE$.unKnowExceptionError(((SparseTensor)tensors.head()).dim() == 1, "Not suitable for this interface.", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        int offset = 0;
        IntRef dimOffset = IntRef.create((int)0);
        for (int i = 0; i < tensors.length(); ++i) {
            SparseTensor currentTensor = (SparseTensor)tensors.apply(i);
            int curLength = currentTensor.nElement();
            int curTensorOffset = currentTensor.storageOffset() - 1;
            System.arraycopy(currentTensor.storage().array(), curTensorOffset, res.storage().array(), offset, curLength);
            for (int indicesIndex = 0; indicesIndex < numOfIndices; ++indicesIndex) {
                if (indicesIndex == 0) {
                    Storage storage = Storage$.MODULE$.apply(curLength, ClassTag$.MODULE$.Int());
                    int[] storageArray = (int[])storage.array();
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), curLength).foreach$mVc$sp((Function1)new Serializable(dimOffset, storageArray){
                        public static final long serialVersionUID = 0L;
                        private final IntRef dimOffset$1;
                        private final int[] storageArray$1;

                        public final void apply(int j) {
                            this.apply$mcVI$sp(j);
                        }

                        public void apply$mcVI$sp(int j) {
                            this.storageArray$1[j] = this.dimOffset$1.elem;
                        }
                        {
                            this.dimOffset$1 = dimOffset$1;
                            this.storageArray$1 = storageArray$1;
                        }
                    });
                    System.arraycopy(storageArray, 0, res._indices()[indicesIndex].array(), offset, curLength);
                    continue;
                }
                System.arraycopy(currentTensor._indices()[indicesIndex - 1].array(), curTensorOffset, res._indices()[indicesIndex].array(), offset, curLength);
            }
            offset += curLength;
            ++dimOffset.elem;
        }
        return res;
    }

    private <T> int lastIndexOf(Object array, T value2, int start2, int end, ClassTag<T> evidence$8, TensorNumericMath.TensorNumeric<T> ev) {
        int i;
        if (start2 > end) {
            return -1;
        }
        Log4Error$.MODULE$.unKnowExceptionError(end <= ScalaRunTime$.MODULE$.array_length(array) - 1, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"indexOf end should't exceed array size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(ScalaRunTime$.MODULE$.array_length(array) - 1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)end)}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        for (i = start2; i < end && BoxesRunTime.equals((Object)ScalaRunTime$.MODULE$.array_apply(array, i), value2); ++i) {
        }
        return BoxesRunTime.equals((Object)ScalaRunTime$.MODULE$.array_apply(array, i), value2) ? i : i - 1;
    }

    private <T> int firstIndexOf(Object array, T value2, int start2, int end, ClassTag<T> evidence$9, TensorNumericMath.TensorNumeric<T> ev) {
        int i;
        if (start2 > end) {
            return -1;
        }
        Log4Error$.MODULE$.unKnowExceptionError(end <= ScalaRunTime$.MODULE$.array_length(array) - 1, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"indexOf end should't exceed array size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(ScalaRunTime$.MODULE$.array_length(array) - 1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)end)}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        for (i = start2; i <= end && !BoxesRunTime.equals((Object)ScalaRunTime$.MODULE$.array_apply(array, i), value2); ++i) {
        }
        return i > end ? -1 : i;
    }

    private <T> Tensor<T> concat(int dim, Seq<SparseTensor<T>> tensors, SparseTensor<T> res, ClassTag<T> evidence$10, TensorNumericMath.TensorNumeric<T> ev) {
        int numOfIndices = res.dim();
        int n = dim;
        switch (n) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            case 2: {
                int start2 = res._storageOffset();
                int end = res._storageOffset();
                int[] tensorsOffset = (int[])((TraversableOnce)tensors.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(SparseTensor<T> x$8) {
                        return x$8.storageOffset() - 1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
                int[] tensorsMaxIndex = (int[])((TraversableOnce)tensors.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(SparseTensor<T> v) {
                        return v.storageOffset() + v.nElement() - 2;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
                for (int j = 0; j < res.size(dim - 1); ++j) {
                    int offset = 0;
                    for (int index = 0; index < tensors.size(); ++index) {
                        int curLength;
                        SparseTensor currentTensor = (SparseTensor)tensors.apply(index);
                        int[] currentIndicesOffset = currentTensor._indicesOffset();
                        int findIndexStart = this.firstIndexOf(currentTensor._indices()[0].array(), BoxesRunTime.boxToInteger((int)(j + currentIndicesOffset[0])), tensorsOffset[index], tensorsMaxIndex[index], ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$);
                        int findIndexEnd = this.lastIndexOf(currentTensor._indices()[0].array(), BoxesRunTime.boxToInteger((int)(j + currentIndicesOffset[0])), tensorsOffset[index], tensorsMaxIndex[index], ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$);
                        int n2 = curLength = findIndexStart != -1 && findIndexEnd != -1 ? findIndexEnd - findIndexStart + 1 : 0;
                        if (0 != curLength) {
                            end += curLength;
                            ev.arraycopy(currentTensor.storage().array(), tensorsOffset[index], res.storage().array(), start2, curLength);
                            for (int indicesIndex = 0; indicesIndex < numOfIndices; ++indicesIndex) {
                                Object object;
                                int[] indicesIndexArray = (int[])currentTensor._indices()[indicesIndex].array();
                                int[] resultIndicesArray = (int[])res._indices()[indicesIndex].array();
                                if (indicesIndex == 0) {
                                    object = res._indices()[indicesIndex].fill(BoxesRunTime.boxToInteger((int)j), start2 + 1, curLength);
                                    continue;
                                }
                                if (index == 0) {
                                    System.arraycopy(currentTensor._indices()[indicesIndex].array(), tensorsOffset[index], res._indices()[indicesIndex].array(), start2, curLength);
                                } else {
                                    for (int i = 0; i < curLength; ++i) {
                                        resultIndicesArray[start2 + i] = indicesIndexArray[tensorsOffset[index] + i] + offset - currentIndicesOffset[indicesIndex];
                                    }
                                }
                                object = BoxedUnit.UNIT;
                            }
                            int n3 = index;
                            tensorsOffset[n3] = tensorsOffset[n3] + curLength;
                            start2 = end;
                        }
                        offset += currentTensor.size(dim);
                    }
                }
                break;
            }
            case 1: {
                int offset = 0;
                int dimOffset = 0;
                for (int i = 0; i < tensors.length(); ++i) {
                    SparseTensor currentTensor = (SparseTensor)tensors.apply(i);
                    int curLength = currentTensor.nElement();
                    int curTensorOffset = currentTensor.storageOffset() - 1;
                    ev.arraycopy(currentTensor.storage().array(), currentTensor.storageOffset() - 1, res.storage().array(), offset, currentTensor.nElement());
                    for (int indicesIndex = 0; indicesIndex < numOfIndices; ++indicesIndex) {
                        int[] indicesIndexArray = (int[])currentTensor._indices()[indicesIndex].array();
                        int[] resultIndicesArray = (int[])res._indices()[indicesIndex].array();
                        if (i == 0 || indicesIndex != dim - 1) {
                            System.arraycopy(currentTensor._indices()[indicesIndex].array(), curTensorOffset, res._indices()[indicesIndex].array(), offset, curLength);
                            continue;
                        }
                        for (int j = 0; j < curLength; ++j) {
                            resultIndicesArray[offset + j] = indicesIndexArray[curTensorOffset + j] + dimOffset;
                        }
                    }
                    offset += curLength;
                    dimOffset += currentTensor.size(dim);
                }
            }
        }
        return res;
    }

    public <T> SparseTensor<T> apply(int[] shape, int nElement, ClassTag<T> evidence$11, TensorNumericMath.TensorNumeric<T> ev) {
        return new SparseTensor<T>((Storage[])Predef$.MODULE$.intArrayOps(shape).map((Function1)new Serializable(nElement){
            public static final long serialVersionUID = 0L;
            private final int nElement$1;

            public final Storage<Object> apply(int x$9) {
                return Storage$.MODULE$.apply(this.nElement$1, ClassTag$.MODULE$.Int());
            }
            {
                this.nElement$1 = nElement$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Storage.class))), Storage$.MODULE$.apply(nElement, evidence$11), 0, nElement, shape, (int[])Predef$.MODULE$.intArrayOps(shape).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$10) {
                return this.apply$mcII$sp(x$10);
            }

            public int apply$mcII$sp(int x$10) {
                return 0;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), shape.length, evidence$11, ev);
    }

    public <T> SparseTensor<T> apply(int[][] indices, Storage<T> values2, int[] shape, ClassTag<T> evidence$12, TensorNumericMath.TensorNumeric<T> ev) {
        return new SparseTensor<T>((Storage[])Predef$.MODULE$.refArrayOps((Object[])indices).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Storage<Object> apply(int[] x$11) {
                return Storage$.MODULE$.apply(x$11, ClassTag$.MODULE$.Int());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Storage.class))), values2, 0, values2.length(), shape, (int[])Predef$.MODULE$.intArrayOps(shape).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$12) {
                return this.apply$mcII$sp(x$12);
            }

            public int apply$mcII$sp(int x$12) {
                return 0;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), shape.length, evidence$12, ev);
    }

    public <T> SparseTensor<T> apply(int[][] indices, Storage<T> values2, int[] shape, int dimension, ClassTag<T> evidence$13, TensorNumericMath.TensorNumeric<T> ev) {
        return new SparseTensor<T>((Storage[])Predef$.MODULE$.refArrayOps((Object[])indices).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Storage<Object> apply(int[] x$13) {
                return Storage$.MODULE$.apply(x$13, ClassTag$.MODULE$.Int());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Storage.class))), values2, 0, values2.length(), shape, (int[])Predef$.MODULE$.intArrayOps(shape).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$14) {
                return this.apply$mcII$sp(x$14);
            }

            public int apply$mcII$sp(int x$14) {
                return 0;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), dimension, evidence$13, ev);
    }

    public <T> SparseTensor<T> apply(Tensor<T> denseTensor, ClassTag<T> evidence$14, TensorNumericMath.TensorNumeric<T> ev) {
        IntRef nonZeroElement = IntRef.create((int)0);
        denseTensor.apply1((Function1<T, T>)new Serializable(ev, nonZeroElement){
            public static final long serialVersionUID = 0L;
            private final TensorNumericMath.TensorNumeric ev$7;
            private final IntRef nonZeroElement$1;

            public final T apply(T v) {
                if (!BoxesRunTime.equals(v, this.ev$7.zero())) {
                    ++this.nonZeroElement$1.elem;
                }
                return v;
            }
            {
                this.ev$7 = ev$7;
                this.nonZeroElement$1 = nonZeroElement$1;
            }
        });
        int[] shape = denseTensor.size();
        int[][] indices = (int[][])Predef$.MODULE$.intArrayOps(shape).map((Function1)new Serializable(nonZeroElement){
            public static final long serialVersionUID = 0L;
            private final IntRef nonZeroElement$1;

            public final int[] apply(int x$15) {
                return new int[this.nonZeroElement$1.elem];
            }
            {
                this.nonZeroElement$1 = nonZeroElement$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
        Storage<T> storage = Storage$.MODULE$.apply(nonZeroElement.elem, evidence$14);
        Object storageArray = storage.array();
        int n = denseTensor.dim();
        switch (n) {
            default: {
                Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)denseTensor.dim())})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                break;
            }
            case 2: {
                int sparseIndex = 0;
                for (int i = 1; i <= denseTensor.size(1); ++i) {
                    for (int j = 1; j <= denseTensor.size(2); ++j) {
                        if (BoxesRunTime.equals(denseTensor.valueAt(i, j), (Object)BoxesRunTime.boxToInteger((int)0))) continue;
                        indices[0][sparseIndex] = i - 1;
                        indices[1][sparseIndex] = j - 1;
                        ScalaRunTime$.MODULE$.array_update(storageArray, sparseIndex, denseTensor.valueAt(i, j));
                        ++sparseIndex;
                    }
                }
                break;
            }
            case 1: {
                int sparseIndex = 0;
                for (int i = 1; i <= denseTensor.nElement(); ++i) {
                    if (BoxesRunTime.equals(denseTensor.valueAt(i), (Object)BoxesRunTime.boxToInteger((int)0))) continue;
                    indices[0][sparseIndex] = i - 1;
                    ScalaRunTime$.MODULE$.array_update(storageArray, sparseIndex, denseTensor.valueAt(i));
                    ++sparseIndex;
                }
            }
        }
        return this.apply(indices, storage, shape, shape.length, evidence$14, ev);
    }

    public <T> int apply$default$2() {
        return 1;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SparseTensor$() {
        MODULE$ = this;
    }
}

