/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.tensor;

import com.intel.analytics.bigdl.dllib.tensor.ArrayStorage;
import com.intel.analytics.bigdl.dllib.tensor.ArrayStorage$mcD$sp;
import com.intel.analytics.bigdl.dllib.tensor.ArrayStorage$mcF$sp;
import com.intel.analytics.bigdl.dllib.tensor.ConvertableFrom$ConvertableFromDouble$;
import com.intel.analytics.bigdl.dllib.tensor.ConvertableFrom$ConvertableFromInt$;
import com.intel.analytics.bigdl.dllib.tensor.DenseTensor;
import com.intel.analytics.bigdl.dllib.tensor.DenseTensor$;
import com.intel.analytics.bigdl.dllib.tensor.DenseTensor$mcB$sp;
import com.intel.analytics.bigdl.dllib.tensor.DenseTensor$mcC$sp;
import com.intel.analytics.bigdl.dllib.tensor.DenseTensor$mcD$sp;
import com.intel.analytics.bigdl.dllib.tensor.DenseTensor$mcF$sp;
import com.intel.analytics.bigdl.dllib.tensor.DenseTensor$mcI$sp;
import com.intel.analytics.bigdl.dllib.tensor.DenseTensor$mcJ$sp;
import com.intel.analytics.bigdl.dllib.tensor.DenseTensor$mcS$sp;
import com.intel.analytics.bigdl.dllib.tensor.DenseTensor$mcV$sp;
import com.intel.analytics.bigdl.dllib.tensor.DenseTensor$mcZ$sp;
import com.intel.analytics.bigdl.dllib.tensor.DenseTensorApply$;
import com.intel.analytics.bigdl.dllib.tensor.DenseTensorBLAS$;
import com.intel.analytics.bigdl.dllib.tensor.DenseTensorDimApply$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc2;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc2$class;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc2$mcD$sp;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc2$mcD$sp$class;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc2$mcF$sp;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc2$mcF$sp$class;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc4;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc4$class;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc4$mcD$sp;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc4$mcD$sp$class;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc4$mcF$sp;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc4$mcF$sp$class;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc6;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc6$class;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc6$mcD$sp;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc6$mcD$sp$class;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc6$mcF$sp;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc6$mcF$sp$class;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.mkl.MKL;
import scala.Array$;
import scala.Function8;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.FloatRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class DenseTensorMath$ {
    public static final DenseTensorMath$ MODULE$;
    private final int taskSize;
    private final double doubleEpsilon;
    private final double floatEpsilon;

    static {
        new DenseTensorMath$();
    }

    public int taskSize() {
        return this.taskSize;
    }

    public <T> Tensor<T> mul(DenseTensor<T> self, Tensor<T> x, T value2, TensorNumericMath.TensorNumeric<T> ev) {
        Object object;
        if (x == null) {
            object = BoxedUnit.UNIT;
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mul expect two tensors has same size, but current tensor size is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" while x size is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            object = self.copy(x);
        }
        if (self.isContiguous()) {
            ev.scal(self.nElement(), value2, self.storage().array(), self.storageOffset() - 1, 1);
        } else {
            TensorFunc2 func = new TensorFunc2<T>(value2, ev){
                private final Object value$1;
                private final TensorNumericMath.TensorNumeric ev$9;

                public void apply$mcD$sp(double[] v1, int v2) {
                    TensorFunc2$class.apply$mcD$sp(this, v1, v2);
                }

                public void apply$mcF$sp(float[] v1, int v2) {
                    TensorFunc2$class.apply$mcF$sp(this, v1, v2);
                }

                public String toString() {
                    return TensorFunc2$class.toString(this);
                }

                public void apply(Object data2, int index) {
                    ScalaRunTime$.MODULE$.array_update(data2, index, this.ev$9.times(ScalaRunTime$.MODULE$.array_apply(data2, index), this.value$1));
                }
                {
                    this.value$1 = value$1;
                    this.ev$9 = ev$9;
                    TensorFunc2$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply1(self, func);
        }
        return self;
    }

    public <T> Tensor<T> cmul(DenseTensor<T> self, DenseTensor<T> x, DenseTensor<T> y, TensorNumericMath.TensorNumeric<T> ev) {
        BoxedUnit boxedUnit;
        if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(x, y)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as x").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < x.size(1); ++i) {
                this.cmul((DenseTensor)self.select(1, i + 1), (DenseTensor)x.select(1, i + 1), y, ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(y, x)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as y").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < y.size(1); ++i) {
                this.cmul((DenseTensor)self.select(1, i + 1), x, (DenseTensor)y.select(1, i + 1), ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement()) {
            self.resizeAs(x).copy(x);
            boxedUnit = self.cmul(self.expandTensor(y));
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"element number doesn't match "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            if (self.isContiguous() && x.isContiguous() && y.isContiguous() && MKL.isMKLLoaded()) {
                ev.vMul(self.nElement(), x.storage().array(), x.storageOffset() - 1, y.storage().array(), y.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1);
            } else {
                TensorFunc6 func6 = new TensorFunc6<T>(ev){
                    private final TensorNumericMath.TensorNumeric ev$20;

                    public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4, double[] v5, int v6) {
                        TensorFunc6$class.apply$mcD$sp(this, v1, v2, v3, v4, v5, v6);
                    }

                    public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4, float[] v5, int v6) {
                        TensorFunc6$class.apply$mcF$sp(this, v1, v2, v3, v4, v5, v6);
                    }

                    public String toString() {
                        return TensorFunc6$class.toString(this);
                    }

                    public void apply(Object data1, int offset1, Object data2, int offset2, Object data3, int offset3) {
                        ScalaRunTime$.MODULE$.array_update(data1, offset1, this.ev$20.times(ScalaRunTime$.MODULE$.array_apply(data2, offset2), ScalaRunTime$.MODULE$.array_apply(data3, offset3)));
                    }
                    {
                        this.ev$20 = ev$20;
                        TensorFunc6$class.$init$(this);
                    }
                };
                TensorFunc4 func4 = new TensorFunc4<T>(ev){
                    private final TensorNumericMath.TensorNumeric ev$20;

                    public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                        TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                    }

                    public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                        TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                    }

                    public String toString() {
                        return TensorFunc4$class.toString(this);
                    }

                    public void apply(Object data1, int offset1, Object data2, int offset2) {
                        ScalaRunTime$.MODULE$.array_update(data1, offset1, this.ev$20.times(ScalaRunTime$.MODULE$.array_apply(data1, offset1), ScalaRunTime$.MODULE$.array_apply(data2, offset2)));
                    }
                    {
                        this.ev$20 = ev$20;
                        TensorFunc4$class.$init$(this);
                    }
                };
                DenseTensor<T> denseTensor = self;
                DenseTensor<T> denseTensor2 = y;
                if (!(denseTensor != null ? !((Object)denseTensor).equals(denseTensor2) : denseTensor2 != null)) {
                    DenseTensorApply$.MODULE$.apply2(self, x, func4);
                } else {
                    DenseTensor<T> denseTensor3 = self;
                    DenseTensor<T> denseTensor4 = x;
                    if (!(denseTensor3 != null ? !((Object)denseTensor3).equals(denseTensor4) : denseTensor4 != null)) {
                        DenseTensorApply$.MODULE$.apply2(self, y, func4);
                    } else {
                        DenseTensorApply$.MODULE$.apply3(self, x, y, func6);
                    }
                }
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return self;
    }

    public <T> Tensor<T> cdiv(DenseTensor<T> self, Tensor<T> x, Tensor<T> y, TensorNumericMath.TensorNumeric<T> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement() && self.nElement() == x.nElement(), "element number doesn't match", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (self.isContiguous() && y.isContiguous() && x.isContiguous() && MKL.isMKLLoaded()) {
            ev.vDiv(self.nElement(), x.storage().array(), x.storageOffset() - 1, y.storage().array(), y.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc6 func = new TensorFunc6<T>(ev){
                private final TensorNumericMath.TensorNumeric ev$21;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4, double[] v5, int v6) {
                    TensorFunc6$class.apply$mcD$sp(this, v1, v2, v3, v4, v5, v6);
                }

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4, float[] v5, int v6) {
                    TensorFunc6$class.apply$mcF$sp(this, v1, v2, v3, v4, v5, v6);
                }

                public String toString() {
                    return TensorFunc6$class.toString(this);
                }

                public void apply(Object data1, int offset1, Object data2, int offset2, Object data3, int offset3) {
                    ScalaRunTime$.MODULE$.array_update(data1, offset1, this.ev$21.divide(ScalaRunTime$.MODULE$.array_apply(data2, offset2), ScalaRunTime$.MODULE$.array_apply(data3, offset3)));
                }
                {
                    this.ev$21 = ev$21;
                    TensorFunc6$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply3(self, x, y, func);
        }
        return self;
    }

    public <T> Tensor<T> cadd(DenseTensor<T> self, Tensor<T> x, T value2, Tensor<T> y, TensorNumericMath.TensorNumeric<T> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(x != null && y.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cadd expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while y has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)y.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Object object = self == x || self == y ? BoxedUnit.UNIT : self.resizeAs(x).copy(x);
        if (self == x && self.isContiguous() && y.isContiguous()) {
            ev.axpy(y.nElement(), value2, y.storage().array(), y.storageOffset() - 1, 1, self.storage().array(), self.storageOffset() - 1, 1);
        } else {
            TensorFunc6 func = new TensorFunc6<T>(value2, ev){
                private final Object value$2;
                private final TensorNumericMath.TensorNumeric ev$18;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4, double[] v5, int v6) {
                    TensorFunc6$class.apply$mcD$sp(this, v1, v2, v3, v4, v5, v6);
                }

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4, float[] v5, int v6) {
                    TensorFunc6$class.apply$mcF$sp(this, v1, v2, v3, v4, v5, v6);
                }

                public String toString() {
                    return TensorFunc6$class.toString(this);
                }

                public void apply(Object data1, int offset1, Object data2, int offset2, Object data3, int offset3) {
                    ScalaRunTime$.MODULE$.array_update(data1, offset1, this.ev$18.plus(ScalaRunTime$.MODULE$.array_apply(data2, offset2), this.ev$18.times(this.value$2, ScalaRunTime$.MODULE$.array_apply(data3, offset3))));
                }
                {
                    this.value$2 = value$2;
                    this.ev$18 = ev$18;
                    TensorFunc6$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply3(self, x, y, func);
        }
        return self;
    }

    public <T> Tensor<T> csub(DenseTensor<T> self, Tensor<T> x, T value2, Tensor<T> y, TensorNumericMath.TensorNumeric<T> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(x != null && x.nElement() == y.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"csub expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while y has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)y.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Object object = self == x ? BoxedUnit.UNIT : self.resizeAs(x).copy(x);
        if (self == x && self.isContiguous() && y.isContiguous()) {
            ev.axpy(y.nElement(), value2, y.storage().array(), y.storageOffset() - 1, 1, self.storage().array(), self.storageOffset() - 1, 1);
        } else {
            TensorFunc4 func2 = new TensorFunc4<T>(value2, ev){
                private final Object value$3;
                private final TensorNumericMath.TensorNumeric ev$19;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                    TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                }

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                    TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(Object data1, int offset1, Object data2, int offset2) {
                    ScalaRunTime$.MODULE$.array_update(data1, offset1, this.ev$19.minus(ScalaRunTime$.MODULE$.array_apply(data1, offset1), this.ev$19.times(this.value$3, ScalaRunTime$.MODULE$.array_apply(data2, offset2))));
                }
                {
                    this.value$3 = value$3;
                    this.ev$19 = ev$19;
                    TensorFunc4$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, y, func2);
        }
        return self;
    }

    public <T> Tensor<T> add(T s2, DenseTensor<T> t2, ClassTag<T> evidence$1, TensorNumericMath.TensorNumeric<T> ev) {
        DenseTensor<T> result2 = new DenseTensor<T>(evidence$1, ev);
        result2.resizeAs(t2);
        result2.copy(t2);
        TensorFunc2 func = new TensorFunc2<T>(s2, ev){
            private final Object s$1;
            private final TensorNumericMath.TensorNumeric ev$2;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(Object data2, int index) {
                ScalaRunTime$.MODULE$.array_update(data2, index, this.ev$2.plus(ScalaRunTime$.MODULE$.array_apply(data2, index), this.s$1));
            }
            {
                this.s$1 = s$1;
                this.ev$2 = ev$2;
                TensorFunc2$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1(result2, func);
        return result2;
    }

    public <T> Tensor<T> add(DenseTensor<T> self, Tensor<T> t2, ClassTag<T> evidence$2, TensorNumericMath.TensorNumeric<T> ev) {
        DenseTensor<T> denseTensor;
        DenseTensor<T> result2 = new DenseTensor<T>(evidence$2, ev);
        result2.resizeAs(self);
        result2.copy(self);
        int n = result2.nElement();
        if (result2.isContiguous() && t2.isContiguous() && n == t2.nElement()) {
            ev.axpy(n, ev.fromType(BoxesRunTime.boxToInteger((int)1), ConvertableFrom$ConvertableFromInt$.MODULE$), t2.storage().array(), t2.storageOffset() - 1, 1, result2.storage().array(), result2.storageOffset() - 1, 1);
            denseTensor = result2;
        } else {
            TensorFunc4 func2 = new TensorFunc4<T>(ev){
                private final TensorNumericMath.TensorNumeric ev$1;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                    TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                }

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                    TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(Object data1, int offset1, Object data2, int offset2) {
                    ScalaRunTime$.MODULE$.array_update(data1, offset1, this.ev$1.plus(ScalaRunTime$.MODULE$.array_apply(data1, offset1), ScalaRunTime$.MODULE$.array_apply(data2, offset2)));
                }
                {
                    this.ev$1 = ev$1;
                    TensorFunc4$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, t2, func2);
            denseTensor = result2;
        }
        return denseTensor;
    }

    public <T> Tensor<T> sub(T s2, DenseTensor<T> t2, ClassTag<T> evidence$3, TensorNumericMath.TensorNumeric<T> ev) {
        DenseTensor<T> result2 = new DenseTensor<T>(evidence$3, ev);
        result2.resizeAs(t2);
        result2.copy(t2);
        TensorFunc2 func = new TensorFunc2<T>(s2, ev){
            private final Object s$2;
            private final TensorNumericMath.TensorNumeric ev$4;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(Object data2, int index) {
                ScalaRunTime$.MODULE$.array_update(data2, index, this.ev$4.minus(ScalaRunTime$.MODULE$.array_apply(data2, index), this.s$2));
            }
            {
                this.s$2 = s$2;
                this.ev$4 = ev$4;
                TensorFunc2$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1(result2, func);
        return result2;
    }

    public <T> Tensor<T> sub(DenseTensor<T> self, Tensor<T> t2, ClassTag<T> evidence$4, TensorNumericMath.TensorNumeric<T> ev) {
        DenseTensor<T> result2 = new DenseTensor<T>(evidence$4, ev);
        result2.resizeAs(self);
        result2.copy(self);
        TensorFunc4 func2 = new TensorFunc4<T>(ev){
            private final TensorNumericMath.TensorNumeric ev$3;

            public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
            }

            public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
            }

            public String toString() {
                return TensorFunc4$class.toString(this);
            }

            public void apply(Object data1, int offset1, Object data2, int offset2) {
                ScalaRunTime$.MODULE$.array_update(data1, offset1, this.ev$3.minus(ScalaRunTime$.MODULE$.array_apply(data1, offset1), ScalaRunTime$.MODULE$.array_apply(data2, offset2)));
            }
            {
                this.ev$3 = ev$3;
                TensorFunc4$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply2(result2, t2, func2);
        return result2;
    }

    public <T> Tensor<T> neg(DenseTensor<T> self, ClassTag<T> evidence$5, TensorNumericMath.TensorNumeric<T> ev) {
        DenseTensor<T> result2 = new DenseTensor<T>(evidence$5, ev);
        result2.resizeAs(self);
        result2.copy(self);
        TensorFunc2 func = new TensorFunc2<T>(ev){
            private final TensorNumericMath.TensorNumeric ev$5;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(Object data2, int index) {
                ScalaRunTime$.MODULE$.array_update(data2, index, this.ev$5.negative(ScalaRunTime$.MODULE$.array_apply(data2, index)));
            }
            {
                this.ev$5 = ev$5;
                TensorFunc2$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1(result2, func);
        return result2;
    }

    public <T> Tensor<T> divide(T s2, DenseTensor<T> t2, ClassTag<T> evidence$6, TensorNumericMath.TensorNumeric<T> ev) {
        DenseTensor<T> result2 = new DenseTensor<T>(evidence$6, ev);
        result2.resizeAs(t2);
        result2.copy(t2);
        TensorFunc2 func = new TensorFunc2<T>(s2, ev){
            private final Object s$3;
            private final TensorNumericMath.TensorNumeric ev$7;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(Object data2, int index) {
                ScalaRunTime$.MODULE$.array_update(data2, index, this.ev$7.divide(ScalaRunTime$.MODULE$.array_apply(data2, index), this.s$3));
            }
            {
                this.s$3 = s$3;
                this.ev$7 = ev$7;
                TensorFunc2$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1(result2, func);
        return result2;
    }

    public <T> Tensor<T> divide(DenseTensor<T> self, Tensor<T> t2, ClassTag<T> evidence$7, TensorNumericMath.TensorNumeric<T> ev) {
        DenseTensor<T> result2 = new DenseTensor<T>(evidence$7, ev);
        result2.resizeAs(self);
        result2.copy(self);
        TensorFunc4 func2 = new TensorFunc4<T>(ev){
            private final TensorNumericMath.TensorNumeric ev$6;

            public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
            }

            public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
            }

            public String toString() {
                return TensorFunc4$class.toString(this);
            }

            public void apply(Object data1, int offset1, Object data2, int offset2) {
                ScalaRunTime$.MODULE$.array_update(data1, offset1, this.ev$6.divide(ScalaRunTime$.MODULE$.array_apply(data1, offset1), ScalaRunTime$.MODULE$.array_apply(data2, offset2)));
            }
            {
                this.ev$6 = ev$6;
                TensorFunc4$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply2(result2, t2, func2);
        return result2;
    }

    public <T> Tensor<T> mul(T s2, DenseTensor<T> t2, ClassTag<T> evidence$8, TensorNumericMath.TensorNumeric<T> ev) {
        DenseTensor<T> result2 = new DenseTensor<T>(evidence$8, ev);
        result2.resizeAs(t2);
        result2.copy(t2);
        TensorFunc2 func = new TensorFunc2<T>(s2, ev){
            private final Object s$4;
            private final TensorNumericMath.TensorNumeric ev$8;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(Object data2, int index) {
                ScalaRunTime$.MODULE$.array_update(data2, index, this.ev$8.times(ScalaRunTime$.MODULE$.array_apply(data2, index), this.s$4));
            }
            {
                this.s$4 = s$4;
                this.ev$8 = ev$8;
                TensorFunc2$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1(result2, func);
        return result2;
    }

    public <T> Tensor<T> mul(Tensor<T> self, Tensor<T> t2, ClassTag<T> evidence$9, TensorNumericMath.TensorNumeric<T> ev) {
        DenseTensor<T> denseTensor;
        if (self.nDimension() == 1 && t2.nDimension() == 1) {
            Log4Error$.MODULE$.unKnowExceptionError(self.size(1) == t2.size(1), "vector size not match", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            T result2 = ev.dot(self.nElement(), self.storage().array(), self.storageOffset() - 1, self.stride(1), t2.storage().array(), t2.storageOffset() - 1, t2.stride(1));
            denseTensor = new DenseTensor<T>(new ArrayStorage<T>(Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result2}), evidence$9), evidence$9), evidence$9, ev);
        } else if (self.nDimension() == 2 && t2.nDimension() == 1) {
            DenseTensor<T> result3 = new DenseTensor<T>(self.size(1), evidence$9, ev);
            DenseTensorBLAS$.MODULE$.gemv(ev.fromType(BoxesRunTime.boxToInteger((int)1), ConvertableFrom$ConvertableFromInt$.MODULE$), self, t2, ev.fromType(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$), result3, ev);
            denseTensor = result3;
        } else if (self.nDimension() == 2 && t2.nDimension() == 2) {
            Tensor<T> result4 = new DenseTensor<T>(t2.size(2), self.size(1), evidence$9, ev).t();
            this.addmm(result4, ev.fromType(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$), result4, ev.fromType(BoxesRunTime.boxToInteger((int)1), ConvertableFrom$ConvertableFromInt$.MODULE$), self, t2, evidence$9, ev);
            denseTensor = result4;
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(false, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"multiplication between ", "D and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nDimension())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "D not yet supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.nDimension())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            denseTensor = null;
        }
        return denseTensor;
    }

    public <T> Tensor<T> pow(DenseTensor<T> self, Tensor<T> x, T n, ClassTag<T> evidence$10, TensorNumericMath.TensorNumeric<T> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pow expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while current tensor has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)self.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (MKL.isMKLLoaded() && self.isContiguous() && x.isContiguous()) {
            ev.vPowx(self.nElement(), x.storage().array(), x.storageOffset() - 1, n, self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc4 func = new TensorFunc4<T>(n, ev){
                private final Object n$1;
                private final TensorNumericMath.TensorNumeric ev$24;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                    TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                }

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                    TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(Object data1, int offset1, Object data2, int offset2) {
                    ScalaRunTime$.MODULE$.array_update(data1, offset1, this.ev$24.pow(ScalaRunTime$.MODULE$.array_apply(data2, offset2), this.n$1));
                }
                {
                    this.n$1 = n$1;
                    this.ev$24 = ev$24;
                    TensorFunc4$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, x, func);
        }
        return self;
    }

    public <T> Tensor<T> exp(DenseTensor<T> self, Tensor<T> x, ClassTag<T> evidence$11, TensorNumericMath.TensorNumeric<T> ev) {
        Object object = self.nElement() != x.nElement() ? self.resizeAs(x) : BoxedUnit.UNIT;
        if (MKL.isMKLLoaded() && self.isContiguous() && x.isContiguous()) {
            ev.vExp(self.nElement(), x.storage().array(), x.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc4 func = new TensorFunc4<T>(ev){
                private final TensorNumericMath.TensorNumeric ev$26;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                    TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                }

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                    TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(Object data1, int offset1, Object data2, int offset2) {
                    ScalaRunTime$.MODULE$.array_update(data1, offset1, this.ev$26.exp(ScalaRunTime$.MODULE$.array_apply(data2, offset2)));
                }
                {
                    this.ev$26 = ev$26;
                    TensorFunc4$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, x, func);
        }
        return self;
    }

    public <T> Tensor<T> log(DenseTensor<T> self, Tensor<T> x, ClassTag<T> evidence$12, TensorNumericMath.TensorNumeric<T> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while current tensor has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)self.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (MKL.isMKLLoaded() && self.isContiguous() && x.isContiguous()) {
            ev.vLn(self.nElement(), x.storage().array(), x.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc4 func = new TensorFunc4<T>(ev){
                private final TensorNumericMath.TensorNumeric ev$25;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                    TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                }

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                    TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(Object data1, int offset1, Object data2, int offset2) {
                    ScalaRunTime$.MODULE$.array_update(data1, offset1, this.ev$25.log(ScalaRunTime$.MODULE$.array_apply(data2, offset2)));
                }
                {
                    this.ev$25 = ev$25;
                    TensorFunc4$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, x, func);
        }
        return self;
    }

    public <T> Tensor<T> sqrt(DenseTensor<T> self, Tensor<T> x, ClassTag<T> evidence$13, TensorNumericMath.TensorNumeric<T> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sqrt expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while current tensor has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)self.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (MKL.isMKLLoaded() && self.isContiguous() && x.isContiguous()) {
            ev.vSqrt(self.nElement(), x.storage().array(), x.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc4 func = new TensorFunc4<T>(ev){
                private final TensorNumericMath.TensorNumeric ev$27;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                    TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                }

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                    TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(Object data1, int offset1, Object data2, int offset2) {
                    ScalaRunTime$.MODULE$.array_update(data1, offset1, this.ev$27.sqrt(ScalaRunTime$.MODULE$.array_apply(data2, offset2)));
                }
                {
                    this.ev$27 = ev$27;
                    TensorFunc4$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, x, func);
        }
        return self;
    }

    public <T> Tensor<T> tanh(DenseTensor<T> self, Tensor<T> x, ClassTag<T> evidence$14, TensorNumericMath.TensorNumeric<T> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tanh expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while current tensor has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)self.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (MKL.isMKLLoaded() && self.isContiguous() && x.isContiguous()) {
            ev.vTanh(self.nElement(), x.storage().array(), x.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc4 func = new TensorFunc4<T>(ev){
                private final TensorNumericMath.TensorNumeric ev$28;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                    TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                }

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                    TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(Object data1, int offset1, Object data2, int offset2) {
                    ScalaRunTime$.MODULE$.array_update(data1, offset1, this.ev$28.tanh(ScalaRunTime$.MODULE$.array_apply(data2, offset2)));
                }
                {
                    this.ev$28 = ev$28;
                    TensorFunc4$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, x, func);
        }
        return self;
    }

    public <T> Tensor<T> log1p(DenseTensor<T> self, Tensor<T> x, ClassTag<T> evidence$15, TensorNumericMath.TensorNumeric<T> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log1p expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while current tensor has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)self.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (MKL.isMKLLoaded() && self.isContiguous() && x.isContiguous()) {
            ev.vLog1p(self.nElement(), x.storage().array(), x.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc4 func = new TensorFunc4<T>(ev){
                private final TensorNumericMath.TensorNumeric ev$29;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                    TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                }

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                    TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(Object data1, int offset1, Object data2, int offset2) {
                    ScalaRunTime$.MODULE$.array_update(data1, offset1, this.ev$29.log1p(ScalaRunTime$.MODULE$.array_apply(data2, offset2)));
                }
                {
                    this.ev$29 = ev$29;
                    TensorFunc4$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, x, func);
        }
        return self;
    }

    public <T> T prodAll(DenseTensor<T> self, TensorNumericMath.TensorNumeric<T> ev) {
        ObjectRef product = ObjectRef.create(ev.fromType(BoxesRunTime.boxToInteger((int)1), ConvertableFrom$ConvertableFromInt$.MODULE$));
        TensorFunc2 func = new TensorFunc2<T>(ev, product){
            private final TensorNumericMath.TensorNumeric ev$10;
            private final ObjectRef product$1;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(Object data2, int index) {
                this.product$1.elem = this.ev$10.times(ScalaRunTime$.MODULE$.array_apply(data2, index), this.product$1.elem);
            }
            {
                this.ev$10 = ev$10;
                this.product$1 = product$1;
                TensorFunc2$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1(self, func);
        return (T)product.elem;
    }

    public <T> T sumAll(DenseTensor<T> self, TensorNumericMath.TensorNumeric<T> ev) {
        ObjectRef sum2 = ObjectRef.create(ev.fromType(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$));
        TensorFunc2 func = new TensorFunc2<T>(ev, sum2){
            private final TensorNumericMath.TensorNumeric ev$12;
            private final ObjectRef sum$1;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(Object data2, int index) {
                this.sum$1.elem = this.ev$12.plus(ScalaRunTime$.MODULE$.array_apply(data2, index), this.sum$1.elem);
            }
            {
                this.ev$12 = ev$12;
                this.sum$1 = sum$1;
                TensorFunc2$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1(self, func);
        return (T)sum2.elem;
    }

    public <T> Tensor<T> prod(DenseTensor<T> self, Tensor<T> x, int _dim, ClassTag<T> evidence$16, TensorNumericMath.TensorNumeric<T> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < x.nDimension(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension ", " out of range"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(_dim + 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        DenseTensor<T> result2 = self == null ? new DenseTensor<T>(evidence$16, ev) : self;
        int[] sizes = x.size();
        sizes[_dim] = 1;
        result2.resize(sizes, result2.resize$default$2());
        DenseTensorDimApply$.MODULE$.dimApply2(result2, x, _dim, (Function8<Object, Object, Object, Object, Object, Object, Object, Object, BoxedUnit>)new Serializable(ev){
            public static final long serialVersionUID = 0L;
            private final TensorNumericMath.TensorNumeric ev$11;

            public final void apply(Object rData, int rOffset, int rStride, int rSize, Object tData, int tOffset, int tStride, int tSize) {
                ScalaRunTime$.MODULE$.array_update(rData, rOffset, this.ev$11.prod(tSize, tData, tOffset, tStride));
            }
            {
                this.ev$11 = ev$11;
            }
        });
        return result2;
    }

    public <T> Tensor<T> sum(DenseTensor<T> self, Tensor<T> x, int _dim, ClassTag<T> evidence$17, TensorNumericMath.TensorNumeric<T> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < x.nDimension(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension ", " out of range"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(_dim + 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        DenseTensor<T> result2 = self == null ? new DenseTensor<T>(evidence$17, ev) : self;
        int[] sizes = x.size();
        sizes[_dim] = 1;
        result2.resize(sizes, result2.resize$default$2());
        DenseTensorDimApply$.MODULE$.dimApply2(result2, x, _dim, (Function8<Object, Object, Object, Object, Object, Object, Object, Object, BoxedUnit>)new Serializable(ev){
            public static final long serialVersionUID = 0L;
            private final TensorNumericMath.TensorNumeric ev$13;

            public final void apply(Object rData, int rOffset, int rStride, int rSize, Object tData, int tOffset, int tStride, int tSize) {
                ScalaRunTime$.MODULE$.array_update(rData, rOffset, this.ev$13.sum(tSize, tData, tOffset, tStride));
            }
            {
                this.ev$13 = ev$13;
            }
        });
        return result2;
    }

    public <T> T maxAll(DenseTensor<T> self, TensorNumericMath.TensorNumeric<T> ev) {
        ObjectRef max2 = ObjectRef.create(ev.fromType(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$));
        BooleanRef first = BooleanRef.create((boolean)true);
        TensorFunc2 func = new TensorFunc2<T>(ev, max2, first){
            private final TensorNumericMath.TensorNumeric ev$16;
            private final ObjectRef max$1;
            private final BooleanRef first$1;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(Object data2, int index) {
                if (this.first$1.elem) {
                    this.first$1.elem = false;
                    this.max$1.elem = ScalaRunTime$.MODULE$.array_apply(data2, index);
                } else if (this.ev$16.isGreater(ScalaRunTime$.MODULE$.array_apply(data2, index), this.max$1.elem)) {
                    this.max$1.elem = ScalaRunTime$.MODULE$.array_apply(data2, index);
                }
            }
            {
                this.ev$16 = ev$16;
                this.max$1 = max$1;
                this.first$1 = first$1;
                TensorFunc2$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1(self, func);
        return (T)max2.elem;
    }

    public <T> T minAll(DenseTensor<T> self, TensorNumericMath.TensorNumeric<T> ev) {
        ObjectRef min2 = ObjectRef.create(ev.fromType(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), ConvertableFrom$ConvertableFromInt$.MODULE$));
        BooleanRef first = BooleanRef.create((boolean)true);
        TensorFunc2 func = new TensorFunc2<T>(ev, min2, first){
            private final TensorNumericMath.TensorNumeric ev$17;
            private final ObjectRef min$1;
            private final BooleanRef first$2;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(Object data2, int index) {
                if (this.first$2.elem) {
                    this.first$2.elem = false;
                    this.min$1.elem = ScalaRunTime$.MODULE$.array_apply(data2, index);
                } else if (this.ev$17.isGreater(this.min$1.elem, ScalaRunTime$.MODULE$.array_apply(data2, index))) {
                    this.min$1.elem = ScalaRunTime$.MODULE$.array_apply(data2, index);
                }
            }
            {
                this.ev$17 = ev$17;
                this.min$1 = min$1;
                this.first$2 = first$2;
                TensorFunc2$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1(self, func);
        return (T)min2.elem;
    }

    public <T> Tensor<T> addmm(Tensor<T> r, T beta, Tensor<T> t2, T alpha, Tensor<T> m1, Tensor<T> m22, ClassTag<T> evidence$18, TensorNumericMath.TensorNumeric<T> ev) {
        Object object;
        Log4Error$.MODULE$.unKnowExceptionError(m1.dim() == 2 && m22.dim() == 2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"matrices expected, got ", ", ", " tensors"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)m1.dim()), BoxesRunTime.boxToInteger((int)m22.dim())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(m1.size(2) == m22.size(1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size mismatch, m1:", " m2:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(m1.size()).mkString("x"), Predef$.MODULE$.intArrayOps(m22.size()).mkString("x")})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(t2.dim() == 2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"matrix expected, got ", " tensor for t"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.dim())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(t2.size(1) == m1.size(1) && t2.size(2) == m22.size(2), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size mismatch. t:", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(t2.size()).mkString("x")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"m1:", " + m2:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(m1.size()).mkString("x"), Predef$.MODULE$.intArrayOps(m22.size()).mkString("x")}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Tensor<T> tensor = r;
        Tensor<T> tensor2 = t2;
        if (!(tensor != null ? !tensor.equals(tensor2) : tensor2 != null)) {
            object = BoxedUnit.UNIT;
        } else {
            r.resizeAs(t2);
            object = r.copy(t2);
        }
        Tensor<T> _r = null;
        Tensor<T> _m1 = m1;
        Tensor<T> _m2 = m22;
        int transpose_r = 32;
        if (r.stride(1) == 1 && r.stride(2) != 0) {
            transpose_r = 110;
            _r = r;
        } else if (r.stride(2) == 1 && r.stride(1) != 0) {
            Tensor<T> swap = _m2;
            _m2 = _m1;
            _m1 = swap;
            transpose_r = 116;
            _r = r;
        } else {
            transpose_r = 110;
            _r = new DenseTensor<T>(r.size(2), r.size(1), evidence$18, ev);
            _r.copy(r);
            _r = _r.transpose(1, 2);
        }
        int index1 = transpose_r == 110 ? 1 : 2;
        int index2 = transpose_r == 110 ? 2 : 1;
        char transpose_m1 = ' ';
        Tensor<T> __m1 = null;
        if (_m1.stride(index1) == 1 && _m1.stride(index2) != 0) {
            transpose_m1 = 'n';
            __m1 = _m1;
        } else if (_m1.stride(index2) == 1 && _m1.stride(index1) != 0) {
            transpose_m1 = 't';
            __m1 = _m1;
        } else {
            transpose_m1 = transpose_r == 110 ? (char)'t' : 'n';
            __m1 = _m1.contiguous();
        }
        char transpose_m2 = ' ';
        Tensor<T> __m2 = null;
        if (_m2.stride(index1) == 1 && _m2.stride(index2) != 0) {
            transpose_m2 = 'n';
            __m2 = _m2;
        } else if (_m2.stride(index2) == 1 && _m2.stride(index1) != 0) {
            transpose_m2 = 't';
            __m2 = _m2;
        } else {
            transpose_m2 = transpose_r == 110 ? (char)'t' : 'n';
            __m2 = _m2.contiguous();
        }
        DenseTensorBLAS$.MODULE$.gemm(transpose_m1, transpose_m2, _r.size(index1), _r.size(index2), __m1.size(index2), alpha, __m1.storage().array(), __m1.storageOffset() - 1, transpose_m1 == 'n' ? __m1.stride(index2) : __m1.stride(index1), __m2.storage().array(), __m2.storageOffset() - 1, transpose_m2 == 'n' ? __m2.stride(index2) : __m2.stride(index1), beta, _r.storage().array(), _r.storageOffset() - 1, _r.stride(index2), ev);
        Tensor<T> tensor3 = _r;
        Tensor<T> tensor4 = r;
        Object object2 = !(tensor3 != null ? !tensor3.equals(tensor4) : tensor4 != null) ? BoxedUnit.UNIT : r.copy(_r);
        return r;
    }

    public <T> Tensor<T> addr(Tensor<T> r, T beta, Tensor<T> t2, T alpha, Tensor<T> vec1, Tensor<T> vec2, TensorNumericMath.TensorNumeric<T> ev) {
        Object object;
        Log4Error$.MODULE$.unKnowExceptionError(vec1.dim() == 1 && vec2.dim() == 1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"vec1.dim() ", " should be 1, vec2.dim() ", " should be 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)vec1.dim()), BoxesRunTime.boxToInteger((int)vec2.dim())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(t2.dim() == 2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t.dim() ", " should be 2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.dim())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(t2.size(1) == vec1.size(1) && t2.size(2) == vec2.size(1), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t.size(1) ", " should match vec1.size(1) ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.size(1)), BoxesRunTime.boxToInteger((int)vec1.size(1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" t.size(2) ", " should match vec2.size(1) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.size(2)), BoxesRunTime.boxToInteger((int)vec2.size(1))}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Object object2 = r == t2 ? BoxedUnit.UNIT : r.resizeAs(t2).copy(t2);
        Object object3 = BoxesRunTime.equals(beta, (Object)BoxesRunTime.boxToInteger((int)1)) ? BoxedUnit.UNIT : r.mul(beta);
        if (r.stride(1) == 1) {
            int lda = t2.stride(2) == 1 ? r.size(1) : r.stride(2);
            ev.ger(vec1.size(1), vec2.size(1), alpha, vec1.storage().array(), vec1.storageOffset() - 1, vec1.stride(1), vec2.storage().array(), vec2.storageOffset() - 1, vec2.stride(1), r.storage().array(), r.storageOffset() - 1, lda);
            object = BoxedUnit.UNIT;
        } else if (r.stride(2) == 1) {
            ev.ger(vec2.size(1), vec1.size(1), alpha, vec2.storage().array(), vec2.storageOffset() - 1, vec2.stride(1), vec1.storage().array(), vec1.storageOffset() - 1, vec1.stride(1), r.storage().array(), r.storageOffset() - 1, r.stride(1));
            object = BoxedUnit.UNIT;
        } else {
            Tensor<T> cr = r.contiguous();
            ev.ger(vec2.size(1), vec1.size(1), alpha, vec2.storage().array(), vec2.storageOffset() - 1, vec2.stride(1), vec1.storage().array(), vec1.storageOffset() - 1, vec1.stride(1), cr.storage().array(), cr.storageOffset() - 1, cr.stride(1));
            object = r.copy(cr);
        }
        return r;
    }

    public <T> Tensor<T> baddbmm(Tensor<T> result2, T beta, Tensor<T> M, T alpha, Tensor<T> batch1, Tensor<T> batch2, ClassTag<T> evidence$19, TensorNumericMath.TensorNumeric<T> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(batch1.dim() == 3, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected 3D tensor, got ", "D"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batch1.dim())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(batch2.dim() == 3, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected 3D tensor, got ", "D"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batch2.dim())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(batch1.size(1) == batch2.size(1), new StringBuilder().append((Object)"equal number of batches expected, got ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batch1.size(1)), BoxesRunTime.boxToInteger((int)batch2.size(1))}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(batch1.size(3) == batch2.size(2), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"wrong matrix size, batch1: "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ", batch2: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batch1.size(2)), BoxesRunTime.boxToInteger((int)batch1.size(3))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batch2.size(2)), BoxesRunTime.boxToInteger((int)batch2.size(3))}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        int bs = batch1.size(1);
        int dim1 = batch1.size(2);
        int dim2 = batch2.size(3);
        Log4Error$.MODULE$.unKnowExceptionError(M.size(1) == bs, "output tensor of incorrect size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(M.size(2) == dim1, "output tensor of incorrect size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(M.size(3) == dim2, "output tensor of incorrect size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Tensor<T> tensor = M;
        Tensor<T> tensor2 = result2;
        Object object = !(tensor != null ? !tensor.equals(tensor2) : tensor2 != null) ? BoxedUnit.UNIT : result2.resizeAs(M).copy(M);
        for (int batch = 1; batch <= batch1.size(1); ++batch) {
            Tensor<T> m1 = batch1.select(1, batch);
            Tensor<T> m22 = batch2.select(1, batch);
            Tensor<T> resultMatrix = result2.select(1, batch);
            this.addmm(resultMatrix, beta, resultMatrix, alpha, m1, m22, evidence$19, ev);
        }
        return result2;
    }

    public <T> Tensor<T> addmv(Tensor<T> r, T beta, Tensor<T> t2, T alpha, Tensor<T> mat, Tensor<T> vec, TensorNumericMath.TensorNumeric<T> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(mat.nDimension() == 2 && vec.nDimension() == 1, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mat.nDimension() ", " should be 2,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)mat.nDimension())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" vec.nDimension() ", " should be 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)vec.nDimension())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(mat.size(2) == vec.size(1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mat.size(2) ", " should match vec.size(1) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)mat.size(2)), BoxesRunTime.boxToInteger((int)vec.size(1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(t2.nDimension() == 1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t.nDimension() ", " should be 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.nDimension())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(t2.size(1) == mat.size(1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t.size(1) ", " should match mat.size(1) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.size(1)), BoxesRunTime.boxToInteger((int)mat.size(1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Object object = r == t2 ? BoxedUnit.UNIT : r.resizeAs(t2).copy(t2);
        if (mat.stride(1) == 1) {
            int lda = mat.size(2) == 1 ? mat.size(1) : mat.stride(2);
            ev.gemv('N', mat.size(1), mat.size(2), alpha, mat.storage().array(), mat.storageOffset() - 1, lda, vec.storage().array(), vec.storageOffset() - 1, vec.stride(1), beta, r.storage().array(), r.storageOffset() - 1, r.stride(1));
        } else if (mat.stride(2) == 1) {
            ev.gemv('T', mat.size(2), mat.size(1), alpha, mat.storage().array(), mat.storageOffset() - 1, mat.stride(1), vec.storage().array(), vec.storageOffset() - 1, vec.stride(1), beta, r.storage().array(), r.storageOffset() - 1, r.stride(1));
        } else {
            Tensor<T> cmat = mat.contiguous();
            ev.gemv('T', cmat.size(2), cmat.size(1), alpha, cmat.storage().array(), cmat.storageOffset() - 1, cmat.stride(1), vec.storage().array(), vec.storageOffset() - 1, vec.stride(1), beta, r.storage().array(), r.storageOffset() - 1, r.stride(1));
        }
        return r;
    }

    public <T> T meanAll(DenseTensor<T> self, TensorNumericMath.TensorNumeric<T> ev) {
        ObjectRef sum2 = ObjectRef.create(ev.fromType(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$));
        TensorFunc2 func = new TensorFunc2<T>(ev, sum2){
            private final TensorNumericMath.TensorNumeric ev$14;
            private final ObjectRef sum$2;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(Object data2, int index) {
                this.sum$2.elem = this.ev$14.plus(ScalaRunTime$.MODULE$.array_apply(data2, index), this.sum$2.elem);
            }
            {
                this.ev$14 = ev$14;
                this.sum$2 = sum$2;
                TensorFunc2$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1(self, func);
        return (T)ev.divide(sum2.elem, ev.fromType(BoxesRunTime.boxToInteger((int)self.nElement()), ConvertableFrom$ConvertableFromInt$.MODULE$));
    }

    public <T> Tensor<T> mean(DenseTensor<T> self, int _dim, ClassTag<T> evidence$20, TensorNumericMath.TensorNumeric<T> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < self.nDimension(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension ", " out of range"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(_dim + 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        DenseTensor<T> result2 = new DenseTensor<T>(evidence$20, ev);
        int[] sizes = self.size();
        sizes[_dim] = 1;
        DenseTensor$.MODULE$.resize(result2, sizes, DenseTensor$.MODULE$.resize$default$3(), evidence$20);
        DenseTensorDimApply$.MODULE$.dimApply2(result2, self, _dim, (Function8<Object, Object, Object, Object, Object, Object, Object, Object, BoxedUnit>)new Serializable(self, _dim, ev){
            public static final long serialVersionUID = 0L;
            private final DenseTensor self$1;
            private final int _dim$1;
            private final TensorNumericMath.TensorNumeric ev$15;

            public final void apply(Object rData, int rOffset, int rStride, int rSize, Object tData, int tOffset, int tStride, int tSize) {
                Object sum2 = this.ev$15.fromType(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$);
                for (int i = 0; i < tSize; ++i) {
                    sum2 = this.ev$15.plus(sum2, ScalaRunTime$.MODULE$.array_apply(tData, tOffset + i * tStride));
                }
                ScalaRunTime$.MODULE$.array_update(rData, rOffset, this.ev$15.divide(sum2, this.ev$15.fromType(BoxesRunTime.boxToInteger((int)this.self$1.size(this._dim$1 + 1)), ConvertableFrom$ConvertableFromInt$.MODULE$)));
            }
            {
                this.self$1 = self$1;
                this._dim$1 = _dim$1;
                this.ev$15 = ev$15;
            }
        });
        return result2;
    }

    public <T> Tensor<T> norm(DenseTensor<T> self, Tensor<T> result2, int value2, int _dim, ClassTag<T> evidence$21, TensorNumericMath.TensorNumeric<T> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < self.nDimension(), "invalid dimension", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        int[] sizes = self.size();
        sizes[_dim] = 1;
        result2.resize(sizes, result2.resize$default$2());
        if (value2 == 0) {
            DenseTensorDimApply$.MODULE$.dimApply2(self, result2, _dim, (Function8<Object, Object, Object, Object, Object, Object, Object, Object, BoxedUnit>)new Serializable(ev){
                public static final long serialVersionUID = 0L;
                private final TensorNumericMath.TensorNumeric ev$30;

                public final void apply(Object rData, int rOffset, int rStride, int rSize, Object tData, int tOffset, int tStride, int tSize) {
                    Object sum2 = this.ev$30.fromType(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$);
                    for (int i = 0; i < rSize; ++i) {
                        sum2 = this.ev$30.plus(sum2, ScalaRunTime$.MODULE$.array_apply(rData, rOffset + i * rStride));
                    }
                    ScalaRunTime$.MODULE$.array_update(tData, tOffset, sum2);
                }
                {
                    this.ev$30 = ev$30;
                }
            });
        } else {
            DenseTensorDimApply$.MODULE$.dimApply2(self, result2, _dim, (Function8<Object, Object, Object, Object, Object, Object, Object, Object, BoxedUnit>)new Serializable(value2, ev){
                public static final long serialVersionUID = 0L;
                private final int value$4;
                private final TensorNumericMath.TensorNumeric ev$30;

                public final void apply(Object rData, int rOffset, int rStride, int rSize, Object tData, int tOffset, int tStride, int tSize) {
                    Object sum2 = this.ev$30.fromType(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$);
                    for (int i = 0; i < rSize; ++i) {
                        sum2 = this.ev$30.plus(sum2, this.ev$30.pow(this.ev$30.abs(ScalaRunTime$.MODULE$.array_apply(rData, rOffset + i * rStride)), this.ev$30.fromType(BoxesRunTime.boxToInteger((int)this.value$4), ConvertableFrom$ConvertableFromInt$.MODULE$)));
                    }
                    ScalaRunTime$.MODULE$.array_update(tData, tOffset, this.ev$30.pow(sum2, this.ev$30.fromType(BoxesRunTime.boxToDouble((double)(1.0 / (double)this.value$4)), ConvertableFrom$ConvertableFromDouble$.MODULE$)));
                }
                {
                    this.value$4 = value$4;
                    this.ev$30 = ev$30;
                }
            });
        }
        return result2;
    }

    public <T> boolean nearlyEqual(T a, T b, double epsilon, TensorNumericMath.TensorNumeric<T> ev) {
        return ev.nearlyEqual(a, b, epsilon);
    }

    public <T> Tensor<T> cmax(DenseTensor<T> self, Tensor<T> x, Tensor<T> y, TensorNumericMath.TensorNumeric<T> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement() && self.nElement() == x.nElement(), "element number doesn't match", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        TensorFunc6 func = new TensorFunc6<T>(ev){
            private final TensorNumericMath.TensorNumeric ev$22;

            public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4, double[] v5, int v6) {
                TensorFunc6$class.apply$mcD$sp(this, v1, v2, v3, v4, v5, v6);
            }

            public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4, float[] v5, int v6) {
                TensorFunc6$class.apply$mcF$sp(this, v1, v2, v3, v4, v5, v6);
            }

            public String toString() {
                return TensorFunc6$class.toString(this);
            }

            public void apply(Object data1, int offset1, Object data2, int offset2, Object data3, int offset3) {
                ScalaRunTime$.MODULE$.array_update(data1, offset1, this.ev$22.max(ScalaRunTime$.MODULE$.array_apply(data2, offset2), ScalaRunTime$.MODULE$.array_apply(data3, offset3)));
            }
            {
                this.ev$22 = ev$22;
                TensorFunc6$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply3(self, x, y, func);
        return self;
    }

    public <T> Tensor<T> cmin(DenseTensor<T> self, Tensor<T> x, Tensor<T> y, TensorNumericMath.TensorNumeric<T> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement() && self.nElement() == x.nElement(), "element number doesn't match", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        TensorFunc6 func = new TensorFunc6<T>(ev){
            private final TensorNumericMath.TensorNumeric ev$23;

            public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4, double[] v5, int v6) {
                TensorFunc6$class.apply$mcD$sp(this, v1, v2, v3, v4, v5, v6);
            }

            public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4, float[] v5, int v6) {
                TensorFunc6$class.apply$mcF$sp(this, v1, v2, v3, v4, v5, v6);
            }

            public String toString() {
                return TensorFunc6$class.toString(this);
            }

            public void apply(Object data1, int offset1, Object data2, int offset2, Object data3, int offset3) {
                ScalaRunTime$.MODULE$.array_update(data1, offset1, this.ev$23.min(ScalaRunTime$.MODULE$.array_apply(data2, offset2), ScalaRunTime$.MODULE$.array_apply(data3, offset3)));
            }
            {
                this.ev$23 = ev$23;
                TensorFunc6$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply3(self, x, y, func);
        return self;
    }

    public double doubleEpsilon() {
        return this.doubleEpsilon;
    }

    public double floatEpsilon() {
        return this.floatEpsilon;
    }

    public Tensor<Object> mul$mDc$sp(DenseTensor<Object> self, Tensor<Object> x, double value2, TensorNumericMath.TensorNumeric<Object> ev) {
        Object object;
        if (x == null) {
            object = BoxedUnit.UNIT;
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mul expect two tensors has same size, but current tensor size is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" while x size is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            object = self.copy(x);
        }
        if (self.isContiguous()) {
            ev.scal$mcD$sp(self.nElement(), value2, (double[])self.storage().array(), self.storageOffset() - 1, 1);
        } else {
            TensorFunc2$mcD$sp func = new TensorFunc2$mcD$sp(value2, ev){
                private final double value$5;
                private final TensorNumericMath.TensorNumeric ev$31;

                public void apply$mcF$sp(float[] v1, int v2) {
                    TensorFunc2$class.apply$mcF$sp(this, v1, v2);
                }

                public String toString() {
                    return TensorFunc2$class.toString(this);
                }

                public void apply(double[] data2, int index) {
                    this.apply$mcD$sp(data2, index);
                }

                public void apply$mcD$sp(double[] data2, int index) {
                    data2[index] = this.ev$31.times$mcD$sp(data2[index], this.value$5);
                }
                {
                    this.value$5 = value$5;
                    this.ev$31 = ev$31;
                    TensorFunc2$class.$init$(this);
                    TensorFunc2$mcD$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply1$mDc$sp(self, func);
        }
        return self;
    }

    public Tensor<Object> mul$mFc$sp(DenseTensor<Object> self, Tensor<Object> x, float value2, TensorNumericMath.TensorNumeric<Object> ev) {
        Object object;
        if (x == null) {
            object = BoxedUnit.UNIT;
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mul expect two tensors has same size, but current tensor size is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" while x size is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            object = self.copy(x);
        }
        if (self.isContiguous()) {
            ev.scal$mcF$sp(self.nElement(), value2, (float[])self.storage().array(), self.storageOffset() - 1, 1);
        } else {
            TensorFunc2$mcF$sp func = new TensorFunc2$mcF$sp(value2, ev){
                private final float value$6;
                private final TensorNumericMath.TensorNumeric ev$32;

                public void apply$mcD$sp(double[] v1, int v2) {
                    TensorFunc2$class.apply$mcD$sp(this, v1, v2);
                }

                public String toString() {
                    return TensorFunc2$class.toString(this);
                }

                public void apply(float[] data2, int index) {
                    this.apply$mcF$sp(data2, index);
                }

                public void apply$mcF$sp(float[] data2, int index) {
                    data2[index] = this.ev$32.times$mcF$sp(data2[index], this.value$6);
                }
                {
                    this.value$6 = value$6;
                    this.ev$32 = ev$32;
                    TensorFunc2$class.$init$(this);
                    TensorFunc2$mcF$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply1$mFc$sp(self, func);
        }
        return self;
    }

    public Tensor<Object> cmul$mZc$sp(DenseTensor<Object> self, DenseTensor<Object> x, DenseTensor<Object> y, TensorNumericMath.TensorNumeric<Object> ev) {
        BoxedUnit boxedUnit;
        if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(x, y)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as x").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < x.size(1); ++i) {
                this.cmul$mZc$sp((DenseTensor)self.select(1, i + 1), (DenseTensor)x.select(1, i + 1), y, ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(y, x)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as y").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < y.size(1); ++i) {
                this.cmul$mZc$sp((DenseTensor)self.select(1, i + 1), x, (DenseTensor)y.select(1, i + 1), ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement()) {
            self.resizeAs(x).copy(x);
            boxedUnit = self.cmul(self.expandTensor$mcZ$sp(y));
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"element number doesn't match "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            if (self.isContiguous() && x.isContiguous() && y.isContiguous() && MKL.isMKLLoaded()) {
                ev.vMul(self.nElement(), x.storage().array(), x.storageOffset() - 1, y.storage().array(), y.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1);
            } else {
                TensorFunc6<Object> func6 = new TensorFunc6<Object>(ev){
                    private final TensorNumericMath.TensorNumeric ev$33;

                    public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4, double[] v5, int v6) {
                        TensorFunc6$class.apply$mcD$sp(this, v1, v2, v3, v4, v5, v6);
                    }

                    public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4, float[] v5, int v6) {
                        TensorFunc6$class.apply$mcF$sp(this, v1, v2, v3, v4, v5, v6);
                    }

                    public String toString() {
                        return TensorFunc6$class.toString(this);
                    }

                    public void apply(boolean[] data1, int offset1, boolean[] data2, int offset2, boolean[] data3, int offset3) {
                        data1[offset1] = BoxesRunTime.unboxToBoolean((Object)this.ev$33.times(BoxesRunTime.boxToBoolean((boolean)data2[offset2]), BoxesRunTime.boxToBoolean((boolean)data3[offset3])));
                    }
                    {
                        this.ev$33 = ev$33;
                        TensorFunc6$class.$init$(this);
                    }
                };
                TensorFunc4<Object> func4 = new TensorFunc4<Object>(ev){
                    private final TensorNumericMath.TensorNumeric ev$33;

                    public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                        TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                    }

                    public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                        TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                    }

                    public String toString() {
                        return TensorFunc4$class.toString(this);
                    }

                    public void apply(boolean[] data1, int offset1, boolean[] data2, int offset2) {
                        data1[offset1] = BoxesRunTime.unboxToBoolean((Object)this.ev$33.times(BoxesRunTime.boxToBoolean((boolean)data1[offset1]), BoxesRunTime.boxToBoolean((boolean)data2[offset2])));
                    }
                    {
                        this.ev$33 = ev$33;
                        TensorFunc4$class.$init$(this);
                    }
                };
                DenseTensor<Object> denseTensor = self;
                DenseTensor<Object> denseTensor2 = y;
                if (!(denseTensor != null ? !((Object)denseTensor).equals(denseTensor2) : denseTensor2 != null)) {
                    DenseTensorApply$.MODULE$.apply2(self, x, func4);
                } else {
                    DenseTensor<Object> denseTensor3 = self;
                    DenseTensor<Object> denseTensor4 = x;
                    if (!(denseTensor3 != null ? !((Object)denseTensor3).equals(denseTensor4) : denseTensor4 != null)) {
                        DenseTensorApply$.MODULE$.apply2(self, y, func4);
                    } else {
                        DenseTensorApply$.MODULE$.apply3(self, x, y, func6);
                    }
                }
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return self;
    }

    public Tensor<Object> cmul$mBc$sp(DenseTensor<Object> self, DenseTensor<Object> x, DenseTensor<Object> y, TensorNumericMath.TensorNumeric<Object> ev) {
        BoxedUnit boxedUnit;
        if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(x, y)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as x").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < x.size(1); ++i) {
                this.cmul$mBc$sp((DenseTensor)self.select(1, i + 1), (DenseTensor)x.select(1, i + 1), y, ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(y, x)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as y").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < y.size(1); ++i) {
                this.cmul$mBc$sp((DenseTensor)self.select(1, i + 1), x, (DenseTensor)y.select(1, i + 1), ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement()) {
            self.resizeAs(x).copy(x);
            boxedUnit = self.cmul(self.expandTensor$mcB$sp(y));
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"element number doesn't match "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            if (self.isContiguous() && x.isContiguous() && y.isContiguous() && MKL.isMKLLoaded()) {
                ev.vMul(self.nElement(), x.storage().array(), x.storageOffset() - 1, y.storage().array(), y.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1);
            } else {
                TensorFunc6<Object> func6 = new TensorFunc6<Object>(ev){
                    private final TensorNumericMath.TensorNumeric ev$34;

                    public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4, double[] v5, int v6) {
                        TensorFunc6$class.apply$mcD$sp(this, v1, v2, v3, v4, v5, v6);
                    }

                    public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4, float[] v5, int v6) {
                        TensorFunc6$class.apply$mcF$sp(this, v1, v2, v3, v4, v5, v6);
                    }

                    public String toString() {
                        return TensorFunc6$class.toString(this);
                    }

                    public void apply(byte[] data1, int offset1, byte[] data2, int offset2, byte[] data3, int offset3) {
                        data1[offset1] = BoxesRunTime.unboxToByte((Object)this.ev$34.times(BoxesRunTime.boxToByte((byte)data2[offset2]), BoxesRunTime.boxToByte((byte)data3[offset3])));
                    }
                    {
                        this.ev$34 = ev$34;
                        TensorFunc6$class.$init$(this);
                    }
                };
                TensorFunc4<Object> func4 = new TensorFunc4<Object>(ev){
                    private final TensorNumericMath.TensorNumeric ev$34;

                    public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                        TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                    }

                    public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                        TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                    }

                    public String toString() {
                        return TensorFunc4$class.toString(this);
                    }

                    public void apply(byte[] data1, int offset1, byte[] data2, int offset2) {
                        data1[offset1] = BoxesRunTime.unboxToByte((Object)this.ev$34.times(BoxesRunTime.boxToByte((byte)data1[offset1]), BoxesRunTime.boxToByte((byte)data2[offset2])));
                    }
                    {
                        this.ev$34 = ev$34;
                        TensorFunc4$class.$init$(this);
                    }
                };
                DenseTensor<Object> denseTensor = self;
                DenseTensor<Object> denseTensor2 = y;
                if (!(denseTensor != null ? !((Object)denseTensor).equals(denseTensor2) : denseTensor2 != null)) {
                    DenseTensorApply$.MODULE$.apply2(self, x, func4);
                } else {
                    DenseTensor<Object> denseTensor3 = self;
                    DenseTensor<Object> denseTensor4 = x;
                    if (!(denseTensor3 != null ? !((Object)denseTensor3).equals(denseTensor4) : denseTensor4 != null)) {
                        DenseTensorApply$.MODULE$.apply2(self, y, func4);
                    } else {
                        DenseTensorApply$.MODULE$.apply3(self, x, y, func6);
                    }
                }
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return self;
    }

    public Tensor<Object> cmul$mCc$sp(DenseTensor<Object> self, DenseTensor<Object> x, DenseTensor<Object> y, TensorNumericMath.TensorNumeric<Object> ev) {
        BoxedUnit boxedUnit;
        if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(x, y)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as x").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < x.size(1); ++i) {
                this.cmul$mCc$sp((DenseTensor)self.select(1, i + 1), (DenseTensor)x.select(1, i + 1), y, ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(y, x)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as y").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < y.size(1); ++i) {
                this.cmul$mCc$sp((DenseTensor)self.select(1, i + 1), x, (DenseTensor)y.select(1, i + 1), ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement()) {
            self.resizeAs(x).copy(x);
            boxedUnit = self.cmul(self.expandTensor$mcC$sp(y));
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"element number doesn't match "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            if (self.isContiguous() && x.isContiguous() && y.isContiguous() && MKL.isMKLLoaded()) {
                ev.vMul(self.nElement(), x.storage().array(), x.storageOffset() - 1, y.storage().array(), y.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1);
            } else {
                TensorFunc6<Object> func6 = new TensorFunc6<Object>(ev){
                    private final TensorNumericMath.TensorNumeric ev$35;

                    public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4, double[] v5, int v6) {
                        TensorFunc6$class.apply$mcD$sp(this, v1, v2, v3, v4, v5, v6);
                    }

                    public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4, float[] v5, int v6) {
                        TensorFunc6$class.apply$mcF$sp(this, v1, v2, v3, v4, v5, v6);
                    }

                    public String toString() {
                        return TensorFunc6$class.toString(this);
                    }

                    public void apply(char[] data1, int offset1, char[] data2, int offset2, char[] data3, int offset3) {
                        data1[offset1] = BoxesRunTime.unboxToChar((Object)this.ev$35.times(BoxesRunTime.boxToCharacter((char)data2[offset2]), BoxesRunTime.boxToCharacter((char)data3[offset3])));
                    }
                    {
                        this.ev$35 = ev$35;
                        TensorFunc6$class.$init$(this);
                    }
                };
                TensorFunc4<Object> func4 = new TensorFunc4<Object>(ev){
                    private final TensorNumericMath.TensorNumeric ev$35;

                    public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                        TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                    }

                    public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                        TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                    }

                    public String toString() {
                        return TensorFunc4$class.toString(this);
                    }

                    public void apply(char[] data1, int offset1, char[] data2, int offset2) {
                        data1[offset1] = BoxesRunTime.unboxToChar((Object)this.ev$35.times(BoxesRunTime.boxToCharacter((char)data1[offset1]), BoxesRunTime.boxToCharacter((char)data2[offset2])));
                    }
                    {
                        this.ev$35 = ev$35;
                        TensorFunc4$class.$init$(this);
                    }
                };
                DenseTensor<Object> denseTensor = self;
                DenseTensor<Object> denseTensor2 = y;
                if (!(denseTensor != null ? !((Object)denseTensor).equals(denseTensor2) : denseTensor2 != null)) {
                    DenseTensorApply$.MODULE$.apply2(self, x, func4);
                } else {
                    DenseTensor<Object> denseTensor3 = self;
                    DenseTensor<Object> denseTensor4 = x;
                    if (!(denseTensor3 != null ? !((Object)denseTensor3).equals(denseTensor4) : denseTensor4 != null)) {
                        DenseTensorApply$.MODULE$.apply2(self, y, func4);
                    } else {
                        DenseTensorApply$.MODULE$.apply3(self, x, y, func6);
                    }
                }
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return self;
    }

    public Tensor<Object> cmul$mDc$sp(DenseTensor<Object> self, DenseTensor<Object> x, DenseTensor<Object> y, TensorNumericMath.TensorNumeric<Object> ev) {
        BoxedUnit boxedUnit;
        if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(x, y)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as x").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < x.size(1); ++i) {
                this.cmul$mDc$sp((DenseTensor)self.select(1, i + 1), (DenseTensor)x.select(1, i + 1), y, ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(y, x)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as y").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < y.size(1); ++i) {
                this.cmul$mDc$sp((DenseTensor)self.select(1, i + 1), x, (DenseTensor)y.select(1, i + 1), ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement()) {
            self.resizeAs(x).copy(x);
            boxedUnit = self.cmul(self.expandTensor$mcD$sp(y));
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"element number doesn't match "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            if (self.isContiguous() && x.isContiguous() && y.isContiguous() && MKL.isMKLLoaded()) {
                ev.vMul$mcD$sp(self.nElement(), (double[])x.storage().array(), x.storageOffset() - 1, (double[])y.storage().array(), y.storageOffset() - 1, (double[])self.storage().array(), self.storageOffset() - 1);
            } else {
                TensorFunc6$mcD$sp func6 = new TensorFunc6$mcD$sp(ev){
                    private final TensorNumericMath.TensorNumeric ev$36;

                    public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4, float[] v5, int v6) {
                        TensorFunc6$class.apply$mcF$sp(this, v1, v2, v3, v4, v5, v6);
                    }

                    public String toString() {
                        return TensorFunc6$class.toString(this);
                    }

                    public void apply(double[] data1, int offset1, double[] data2, int offset2, double[] data3, int offset3) {
                        this.apply$mcD$sp(data1, offset1, data2, offset2, data3, offset3);
                    }

                    public void apply$mcD$sp(double[] data1, int offset1, double[] data2, int offset2, double[] data3, int offset3) {
                        data1[offset1] = this.ev$36.times$mcD$sp(data2[offset2], data3[offset3]);
                    }
                    {
                        this.ev$36 = ev$36;
                        TensorFunc6$class.$init$(this);
                        TensorFunc6$mcD$sp$class.$init$(this);
                    }
                };
                TensorFunc4$mcD$sp func4 = new TensorFunc4$mcD$sp(ev){
                    private final TensorNumericMath.TensorNumeric ev$36;

                    public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                        TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                    }

                    public String toString() {
                        return TensorFunc4$class.toString(this);
                    }

                    public void apply(double[] data1, int offset1, double[] data2, int offset2) {
                        this.apply$mcD$sp(data1, offset1, data2, offset2);
                    }

                    public void apply$mcD$sp(double[] data1, int offset1, double[] data2, int offset2) {
                        data1[offset1] = this.ev$36.times$mcD$sp(data1[offset1], data2[offset2]);
                    }
                    {
                        this.ev$36 = ev$36;
                        TensorFunc4$class.$init$(this);
                        TensorFunc4$mcD$sp$class.$init$(this);
                    }
                };
                DenseTensor<Object> denseTensor = self;
                DenseTensor<Object> denseTensor2 = y;
                if (!(denseTensor != null ? !((Object)denseTensor).equals(denseTensor2) : denseTensor2 != null)) {
                    DenseTensorApply$.MODULE$.apply2(self, x, func4);
                } else {
                    DenseTensor<Object> denseTensor3 = self;
                    DenseTensor<Object> denseTensor4 = x;
                    if (!(denseTensor3 != null ? !((Object)denseTensor3).equals(denseTensor4) : denseTensor4 != null)) {
                        DenseTensorApply$.MODULE$.apply2(self, y, func4);
                    } else {
                        DenseTensorApply$.MODULE$.apply3$mDc$sp(self, x, y, func6);
                    }
                }
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return self;
    }

    public Tensor<Object> cmul$mFc$sp(DenseTensor<Object> self, DenseTensor<Object> x, DenseTensor<Object> y, TensorNumericMath.TensorNumeric<Object> ev) {
        BoxedUnit boxedUnit;
        if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(x, y)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as x").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < x.size(1); ++i) {
                this.cmul$mFc$sp((DenseTensor)self.select(1, i + 1), (DenseTensor)x.select(1, i + 1), y, ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(y, x)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as y").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < y.size(1); ++i) {
                this.cmul$mFc$sp((DenseTensor)self.select(1, i + 1), x, (DenseTensor)y.select(1, i + 1), ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement()) {
            self.resizeAs(x).copy(x);
            boxedUnit = self.cmul(self.expandTensor$mcF$sp(y));
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"element number doesn't match "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            if (self.isContiguous() && x.isContiguous() && y.isContiguous() && MKL.isMKLLoaded()) {
                ev.vMul$mcF$sp(self.nElement(), (float[])x.storage().array(), x.storageOffset() - 1, (float[])y.storage().array(), y.storageOffset() - 1, (float[])self.storage().array(), self.storageOffset() - 1);
            } else {
                TensorFunc6$mcF$sp func6 = new TensorFunc6$mcF$sp(ev){
                    private final TensorNumericMath.TensorNumeric ev$37;

                    public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4, double[] v5, int v6) {
                        TensorFunc6$class.apply$mcD$sp(this, v1, v2, v3, v4, v5, v6);
                    }

                    public String toString() {
                        return TensorFunc6$class.toString(this);
                    }

                    public void apply(float[] data1, int offset1, float[] data2, int offset2, float[] data3, int offset3) {
                        this.apply$mcF$sp(data1, offset1, data2, offset2, data3, offset3);
                    }

                    public void apply$mcF$sp(float[] data1, int offset1, float[] data2, int offset2, float[] data3, int offset3) {
                        data1[offset1] = this.ev$37.times$mcF$sp(data2[offset2], data3[offset3]);
                    }
                    {
                        this.ev$37 = ev$37;
                        TensorFunc6$class.$init$(this);
                        TensorFunc6$mcF$sp$class.$init$(this);
                    }
                };
                TensorFunc4$mcF$sp func4 = new TensorFunc4$mcF$sp(ev){
                    private final TensorNumericMath.TensorNumeric ev$37;

                    public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                        TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                    }

                    public String toString() {
                        return TensorFunc4$class.toString(this);
                    }

                    public void apply(float[] data1, int offset1, float[] data2, int offset2) {
                        this.apply$mcF$sp(data1, offset1, data2, offset2);
                    }

                    public void apply$mcF$sp(float[] data1, int offset1, float[] data2, int offset2) {
                        data1[offset1] = this.ev$37.times$mcF$sp(data1[offset1], data2[offset2]);
                    }
                    {
                        this.ev$37 = ev$37;
                        TensorFunc4$class.$init$(this);
                        TensorFunc4$mcF$sp$class.$init$(this);
                    }
                };
                DenseTensor<Object> denseTensor = self;
                DenseTensor<Object> denseTensor2 = y;
                if (!(denseTensor != null ? !((Object)denseTensor).equals(denseTensor2) : denseTensor2 != null)) {
                    DenseTensorApply$.MODULE$.apply2(self, x, func4);
                } else {
                    DenseTensor<Object> denseTensor3 = self;
                    DenseTensor<Object> denseTensor4 = x;
                    if (!(denseTensor3 != null ? !((Object)denseTensor3).equals(denseTensor4) : denseTensor4 != null)) {
                        DenseTensorApply$.MODULE$.apply2(self, y, func4);
                    } else {
                        DenseTensorApply$.MODULE$.apply3$mFc$sp(self, x, y, func6);
                    }
                }
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return self;
    }

    public Tensor<Object> cmul$mIc$sp(DenseTensor<Object> self, DenseTensor<Object> x, DenseTensor<Object> y, TensorNumericMath.TensorNumeric<Object> ev) {
        BoxedUnit boxedUnit;
        if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(x, y)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as x").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < x.size(1); ++i) {
                this.cmul$mIc$sp((DenseTensor)self.select(1, i + 1), (DenseTensor)x.select(1, i + 1), y, ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(y, x)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as y").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < y.size(1); ++i) {
                this.cmul$mIc$sp((DenseTensor)self.select(1, i + 1), x, (DenseTensor)y.select(1, i + 1), ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement()) {
            self.resizeAs(x).copy(x);
            boxedUnit = self.cmul(self.expandTensor$mcI$sp(y));
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"element number doesn't match "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            if (self.isContiguous() && x.isContiguous() && y.isContiguous() && MKL.isMKLLoaded()) {
                ev.vMul(self.nElement(), x.storage().array(), x.storageOffset() - 1, y.storage().array(), y.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1);
            } else {
                TensorFunc6<Object> func6 = new TensorFunc6<Object>(ev){
                    private final TensorNumericMath.TensorNumeric ev$38;

                    public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4, double[] v5, int v6) {
                        TensorFunc6$class.apply$mcD$sp(this, v1, v2, v3, v4, v5, v6);
                    }

                    public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4, float[] v5, int v6) {
                        TensorFunc6$class.apply$mcF$sp(this, v1, v2, v3, v4, v5, v6);
                    }

                    public String toString() {
                        return TensorFunc6$class.toString(this);
                    }

                    public void apply(int[] data1, int offset1, int[] data2, int offset2, int[] data3, int offset3) {
                        data1[offset1] = BoxesRunTime.unboxToInt((Object)this.ev$38.times(BoxesRunTime.boxToInteger((int)data2[offset2]), BoxesRunTime.boxToInteger((int)data3[offset3])));
                    }
                    {
                        this.ev$38 = ev$38;
                        TensorFunc6$class.$init$(this);
                    }
                };
                TensorFunc4<Object> func4 = new TensorFunc4<Object>(ev){
                    private final TensorNumericMath.TensorNumeric ev$38;

                    public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                        TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                    }

                    public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                        TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                    }

                    public String toString() {
                        return TensorFunc4$class.toString(this);
                    }

                    public void apply(int[] data1, int offset1, int[] data2, int offset2) {
                        data1[offset1] = BoxesRunTime.unboxToInt((Object)this.ev$38.times(BoxesRunTime.boxToInteger((int)data1[offset1]), BoxesRunTime.boxToInteger((int)data2[offset2])));
                    }
                    {
                        this.ev$38 = ev$38;
                        TensorFunc4$class.$init$(this);
                    }
                };
                DenseTensor<Object> denseTensor = self;
                DenseTensor<Object> denseTensor2 = y;
                if (!(denseTensor != null ? !((Object)denseTensor).equals(denseTensor2) : denseTensor2 != null)) {
                    DenseTensorApply$.MODULE$.apply2(self, x, func4);
                } else {
                    DenseTensor<Object> denseTensor3 = self;
                    DenseTensor<Object> denseTensor4 = x;
                    if (!(denseTensor3 != null ? !((Object)denseTensor3).equals(denseTensor4) : denseTensor4 != null)) {
                        DenseTensorApply$.MODULE$.apply2(self, y, func4);
                    } else {
                        DenseTensorApply$.MODULE$.apply3(self, x, y, func6);
                    }
                }
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return self;
    }

    public Tensor<Object> cmul$mJc$sp(DenseTensor<Object> self, DenseTensor<Object> x, DenseTensor<Object> y, TensorNumericMath.TensorNumeric<Object> ev) {
        BoxedUnit boxedUnit;
        if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(x, y)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as x").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < x.size(1); ++i) {
                this.cmul$mJc$sp((DenseTensor)self.select(1, i + 1), (DenseTensor)x.select(1, i + 1), y, ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(y, x)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as y").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < y.size(1); ++i) {
                this.cmul$mJc$sp((DenseTensor)self.select(1, i + 1), x, (DenseTensor)y.select(1, i + 1), ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement()) {
            self.resizeAs(x).copy(x);
            boxedUnit = self.cmul(self.expandTensor$mcJ$sp(y));
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"element number doesn't match "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            if (self.isContiguous() && x.isContiguous() && y.isContiguous() && MKL.isMKLLoaded()) {
                ev.vMul(self.nElement(), x.storage().array(), x.storageOffset() - 1, y.storage().array(), y.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1);
            } else {
                TensorFunc6<Object> func6 = new TensorFunc6<Object>(ev){
                    private final TensorNumericMath.TensorNumeric ev$39;

                    public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4, double[] v5, int v6) {
                        TensorFunc6$class.apply$mcD$sp(this, v1, v2, v3, v4, v5, v6);
                    }

                    public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4, float[] v5, int v6) {
                        TensorFunc6$class.apply$mcF$sp(this, v1, v2, v3, v4, v5, v6);
                    }

                    public String toString() {
                        return TensorFunc6$class.toString(this);
                    }

                    public void apply(long[] data1, int offset1, long[] data2, int offset2, long[] data3, int offset3) {
                        data1[offset1] = BoxesRunTime.unboxToLong((Object)this.ev$39.times(BoxesRunTime.boxToLong((long)data2[offset2]), BoxesRunTime.boxToLong((long)data3[offset3])));
                    }
                    {
                        this.ev$39 = ev$39;
                        TensorFunc6$class.$init$(this);
                    }
                };
                TensorFunc4<Object> func4 = new TensorFunc4<Object>(ev){
                    private final TensorNumericMath.TensorNumeric ev$39;

                    public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                        TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                    }

                    public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                        TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                    }

                    public String toString() {
                        return TensorFunc4$class.toString(this);
                    }

                    public void apply(long[] data1, int offset1, long[] data2, int offset2) {
                        data1[offset1] = BoxesRunTime.unboxToLong((Object)this.ev$39.times(BoxesRunTime.boxToLong((long)data1[offset1]), BoxesRunTime.boxToLong((long)data2[offset2])));
                    }
                    {
                        this.ev$39 = ev$39;
                        TensorFunc4$class.$init$(this);
                    }
                };
                DenseTensor<Object> denseTensor = self;
                DenseTensor<Object> denseTensor2 = y;
                if (!(denseTensor != null ? !((Object)denseTensor).equals(denseTensor2) : denseTensor2 != null)) {
                    DenseTensorApply$.MODULE$.apply2(self, x, func4);
                } else {
                    DenseTensor<Object> denseTensor3 = self;
                    DenseTensor<Object> denseTensor4 = x;
                    if (!(denseTensor3 != null ? !((Object)denseTensor3).equals(denseTensor4) : denseTensor4 != null)) {
                        DenseTensorApply$.MODULE$.apply2(self, y, func4);
                    } else {
                        DenseTensorApply$.MODULE$.apply3(self, x, y, func6);
                    }
                }
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return self;
    }

    public Tensor<Object> cmul$mSc$sp(DenseTensor<Object> self, DenseTensor<Object> x, DenseTensor<Object> y, TensorNumericMath.TensorNumeric<Object> ev) {
        BoxedUnit boxedUnit;
        if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(x, y)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as x").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < x.size(1); ++i) {
                this.cmul$mSc$sp((DenseTensor)self.select(1, i + 1), (DenseTensor)x.select(1, i + 1), y, ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(y, x)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as y").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < y.size(1); ++i) {
                this.cmul$mSc$sp((DenseTensor)self.select(1, i + 1), x, (DenseTensor)y.select(1, i + 1), ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement()) {
            self.resizeAs(x).copy(x);
            boxedUnit = self.cmul(self.expandTensor$mcS$sp(y));
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"element number doesn't match "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            if (self.isContiguous() && x.isContiguous() && y.isContiguous() && MKL.isMKLLoaded()) {
                ev.vMul(self.nElement(), x.storage().array(), x.storageOffset() - 1, y.storage().array(), y.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1);
            } else {
                TensorFunc6<Object> func6 = new TensorFunc6<Object>(ev){
                    private final TensorNumericMath.TensorNumeric ev$40;

                    public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4, double[] v5, int v6) {
                        TensorFunc6$class.apply$mcD$sp(this, v1, v2, v3, v4, v5, v6);
                    }

                    public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4, float[] v5, int v6) {
                        TensorFunc6$class.apply$mcF$sp(this, v1, v2, v3, v4, v5, v6);
                    }

                    public String toString() {
                        return TensorFunc6$class.toString(this);
                    }

                    public void apply(short[] data1, int offset1, short[] data2, int offset2, short[] data3, int offset3) {
                        data1[offset1] = BoxesRunTime.unboxToShort((Object)this.ev$40.times(BoxesRunTime.boxToShort((short)data2[offset2]), BoxesRunTime.boxToShort((short)data3[offset3])));
                    }
                    {
                        this.ev$40 = ev$40;
                        TensorFunc6$class.$init$(this);
                    }
                };
                TensorFunc4<Object> func4 = new TensorFunc4<Object>(ev){
                    private final TensorNumericMath.TensorNumeric ev$40;

                    public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                        TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                    }

                    public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                        TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                    }

                    public String toString() {
                        return TensorFunc4$class.toString(this);
                    }

                    public void apply(short[] data1, int offset1, short[] data2, int offset2) {
                        data1[offset1] = BoxesRunTime.unboxToShort((Object)this.ev$40.times(BoxesRunTime.boxToShort((short)data1[offset1]), BoxesRunTime.boxToShort((short)data2[offset2])));
                    }
                    {
                        this.ev$40 = ev$40;
                        TensorFunc4$class.$init$(this);
                    }
                };
                DenseTensor<Object> denseTensor = self;
                DenseTensor<Object> denseTensor2 = y;
                if (!(denseTensor != null ? !((Object)denseTensor).equals(denseTensor2) : denseTensor2 != null)) {
                    DenseTensorApply$.MODULE$.apply2(self, x, func4);
                } else {
                    DenseTensor<Object> denseTensor3 = self;
                    DenseTensor<Object> denseTensor4 = x;
                    if (!(denseTensor3 != null ? !((Object)denseTensor3).equals(denseTensor4) : denseTensor4 != null)) {
                        DenseTensorApply$.MODULE$.apply2(self, y, func4);
                    } else {
                        DenseTensorApply$.MODULE$.apply3(self, x, y, func6);
                    }
                }
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return self;
    }

    public Tensor<BoxedUnit> cmul$mVc$sp(DenseTensor<BoxedUnit> self, DenseTensor<BoxedUnit> x, DenseTensor<BoxedUnit> y, TensorNumericMath.TensorNumeric<BoxedUnit> ev) {
        BoxedUnit boxedUnit;
        if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(x, y)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as x").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < x.size(1); ++i) {
                this.cmul$mVc$sp((DenseTensor)self.select(1, i + 1), (DenseTensor)x.select(1, i + 1), y, ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement() && DenseTensor$.MODULE$.canFastBroadcast(y, x)) {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)"the self tensor nElement is not same as y").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            for (int i = 0; i < y.size(1); ++i) {
                this.cmul$mVc$sp((DenseTensor)self.select(1, i + 1), x, (DenseTensor)y.select(1, i + 1), ev);
            }
            boxedUnit = BoxedUnit.UNIT;
        } else if (x.nElement() != y.nElement()) {
            self.resizeAs(x).copy(x);
            boxedUnit = self.cmul(self.expandTensor$mcV$sp(y));
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"element number doesn't match "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self(", ") y(", ") x(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement()), BoxesRunTime.boxToInteger((int)y.nElement()), BoxesRunTime.boxToInteger((int)x.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            if (self.isContiguous() && x.isContiguous() && y.isContiguous() && MKL.isMKLLoaded()) {
                ev.vMul(self.nElement(), x.storage().array(), x.storageOffset() - 1, y.storage().array(), y.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1);
            } else {
                TensorFunc6<BoxedUnit> func6 = new TensorFunc6<BoxedUnit>(ev){
                    private final TensorNumericMath.TensorNumeric ev$41;

                    public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4, double[] v5, int v6) {
                        TensorFunc6$class.apply$mcD$sp(this, v1, v2, v3, v4, v5, v6);
                    }

                    public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4, float[] v5, int v6) {
                        TensorFunc6$class.apply$mcF$sp(this, v1, v2, v3, v4, v5, v6);
                    }

                    public String toString() {
                        return TensorFunc6$class.toString(this);
                    }

                    public void apply(BoxedUnit[] data1, int offset1, BoxedUnit[] data2, int offset2, BoxedUnit[] data3, int offset3) {
                        data1[offset1] = this.ev$41.times(data2[offset2], data3[offset3]);
                    }
                    {
                        this.ev$41 = ev$41;
                        TensorFunc6$class.$init$(this);
                    }
                };
                TensorFunc4<BoxedUnit> func4 = new TensorFunc4<BoxedUnit>(ev){
                    private final TensorNumericMath.TensorNumeric ev$41;

                    public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                        TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                    }

                    public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                        TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                    }

                    public String toString() {
                        return TensorFunc4$class.toString(this);
                    }

                    public void apply(BoxedUnit[] data1, int offset1, BoxedUnit[] data2, int offset2) {
                        data1[offset1] = this.ev$41.times(data1[offset1], data2[offset2]);
                    }
                    {
                        this.ev$41 = ev$41;
                        TensorFunc4$class.$init$(this);
                    }
                };
                DenseTensor<BoxedUnit> denseTensor = self;
                DenseTensor<BoxedUnit> denseTensor2 = y;
                if (!(denseTensor != null ? !((Object)denseTensor).equals(denseTensor2) : denseTensor2 != null)) {
                    DenseTensorApply$.MODULE$.apply2(self, x, func4);
                } else {
                    DenseTensor<BoxedUnit> denseTensor3 = self;
                    DenseTensor<BoxedUnit> denseTensor4 = x;
                    if (!(denseTensor3 != null ? !((Object)denseTensor3).equals(denseTensor4) : denseTensor4 != null)) {
                        DenseTensorApply$.MODULE$.apply2(self, y, func4);
                    } else {
                        DenseTensorApply$.MODULE$.apply3(self, x, y, func6);
                    }
                }
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return self;
    }

    public Tensor<Object> cdiv$mDc$sp(DenseTensor<Object> self, Tensor<Object> x, Tensor<Object> y, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement() && self.nElement() == x.nElement(), "element number doesn't match", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (self.isContiguous() && y.isContiguous() && x.isContiguous() && MKL.isMKLLoaded()) {
            ev.vDiv$mcD$sp(self.nElement(), (double[])x.storage().array(), x.storageOffset() - 1, (double[])y.storage().array(), y.storageOffset() - 1, (double[])self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc6$mcD$sp func = new TensorFunc6$mcD$sp(ev){
                private final TensorNumericMath.TensorNumeric ev$42;

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4, float[] v5, int v6) {
                    TensorFunc6$class.apply$mcF$sp(this, v1, v2, v3, v4, v5, v6);
                }

                public String toString() {
                    return TensorFunc6$class.toString(this);
                }

                public void apply(double[] data1, int offset1, double[] data2, int offset2, double[] data3, int offset3) {
                    this.apply$mcD$sp(data1, offset1, data2, offset2, data3, offset3);
                }

                public void apply$mcD$sp(double[] data1, int offset1, double[] data2, int offset2, double[] data3, int offset3) {
                    data1[offset1] = this.ev$42.divide$mcD$sp(data2[offset2], data3[offset3]);
                }
                {
                    this.ev$42 = ev$42;
                    TensorFunc6$class.$init$(this);
                    TensorFunc6$mcD$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply3$mDc$sp(self, x, y, func);
        }
        return self;
    }

    public Tensor<Object> cdiv$mFc$sp(DenseTensor<Object> self, Tensor<Object> x, Tensor<Object> y, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement() && self.nElement() == x.nElement(), "element number doesn't match", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (self.isContiguous() && y.isContiguous() && x.isContiguous() && MKL.isMKLLoaded()) {
            ev.vDiv$mcF$sp(self.nElement(), (float[])x.storage().array(), x.storageOffset() - 1, (float[])y.storage().array(), y.storageOffset() - 1, (float[])self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc6$mcF$sp func = new TensorFunc6$mcF$sp(ev){
                private final TensorNumericMath.TensorNumeric ev$43;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4, double[] v5, int v6) {
                    TensorFunc6$class.apply$mcD$sp(this, v1, v2, v3, v4, v5, v6);
                }

                public String toString() {
                    return TensorFunc6$class.toString(this);
                }

                public void apply(float[] data1, int offset1, float[] data2, int offset2, float[] data3, int offset3) {
                    this.apply$mcF$sp(data1, offset1, data2, offset2, data3, offset3);
                }

                public void apply$mcF$sp(float[] data1, int offset1, float[] data2, int offset2, float[] data3, int offset3) {
                    data1[offset1] = this.ev$43.divide$mcF$sp(data2[offset2], data3[offset3]);
                }
                {
                    this.ev$43 = ev$43;
                    TensorFunc6$class.$init$(this);
                    TensorFunc6$mcF$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply3$mFc$sp(self, x, y, func);
        }
        return self;
    }

    public Tensor<Object> cadd$mDc$sp(DenseTensor<Object> self, Tensor<Object> x, double value2, Tensor<Object> y, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(x != null && y.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cadd expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while y has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)y.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Object object = self == x || self == y ? BoxedUnit.UNIT : self.resizeAs(x).copy(x);
        if (self == x && self.isContiguous() && y.isContiguous()) {
            ev.axpy$mcD$sp(y.nElement(), value2, (double[])y.storage().array(), y.storageOffset() - 1, 1, (double[])self.storage().array(), self.storageOffset() - 1, 1);
        } else {
            TensorFunc6$mcD$sp func = new TensorFunc6$mcD$sp(value2, ev){
                private final double value$7;
                private final TensorNumericMath.TensorNumeric ev$44;

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4, float[] v5, int v6) {
                    TensorFunc6$class.apply$mcF$sp(this, v1, v2, v3, v4, v5, v6);
                }

                public String toString() {
                    return TensorFunc6$class.toString(this);
                }

                public void apply(double[] data1, int offset1, double[] data2, int offset2, double[] data3, int offset3) {
                    this.apply$mcD$sp(data1, offset1, data2, offset2, data3, offset3);
                }

                public void apply$mcD$sp(double[] data1, int offset1, double[] data2, int offset2, double[] data3, int offset3) {
                    data1[offset1] = this.ev$44.plus$mcD$sp(data2[offset2], this.ev$44.times$mcD$sp(this.value$7, data3[offset3]));
                }
                {
                    this.value$7 = value$7;
                    this.ev$44 = ev$44;
                    TensorFunc6$class.$init$(this);
                    TensorFunc6$mcD$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply3$mDc$sp(self, x, y, func);
        }
        return self;
    }

    public Tensor<Object> cadd$mFc$sp(DenseTensor<Object> self, Tensor<Object> x, float value2, Tensor<Object> y, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(x != null && y.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cadd expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while y has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)y.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Object object = self == x || self == y ? BoxedUnit.UNIT : self.resizeAs(x).copy(x);
        if (self == x && self.isContiguous() && y.isContiguous()) {
            ev.axpy$mcF$sp(y.nElement(), value2, (float[])y.storage().array(), y.storageOffset() - 1, 1, (float[])self.storage().array(), self.storageOffset() - 1, 1);
        } else {
            TensorFunc6$mcF$sp func = new TensorFunc6$mcF$sp(value2, ev){
                private final float value$8;
                private final TensorNumericMath.TensorNumeric ev$45;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4, double[] v5, int v6) {
                    TensorFunc6$class.apply$mcD$sp(this, v1, v2, v3, v4, v5, v6);
                }

                public String toString() {
                    return TensorFunc6$class.toString(this);
                }

                public void apply(float[] data1, int offset1, float[] data2, int offset2, float[] data3, int offset3) {
                    this.apply$mcF$sp(data1, offset1, data2, offset2, data3, offset3);
                }

                public void apply$mcF$sp(float[] data1, int offset1, float[] data2, int offset2, float[] data3, int offset3) {
                    data1[offset1] = this.ev$45.plus$mcF$sp(data2[offset2], this.ev$45.times$mcF$sp(this.value$8, data3[offset3]));
                }
                {
                    this.value$8 = value$8;
                    this.ev$45 = ev$45;
                    TensorFunc6$class.$init$(this);
                    TensorFunc6$mcF$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply3$mFc$sp(self, x, y, func);
        }
        return self;
    }

    public Tensor<Object> csub$mDc$sp(DenseTensor<Object> self, Tensor<Object> x, double value2, Tensor<Object> y, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(x != null && x.nElement() == y.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"csub expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while y has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)y.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Object object = self == x ? BoxedUnit.UNIT : self.resizeAs(x).copy(x);
        if (self == x && self.isContiguous() && y.isContiguous()) {
            ev.axpy$mcD$sp(y.nElement(), value2, (double[])y.storage().array(), y.storageOffset() - 1, 1, (double[])self.storage().array(), self.storageOffset() - 1, 1);
        } else {
            TensorFunc4$mcD$sp func2 = new TensorFunc4$mcD$sp(value2, ev){
                private final double value$9;
                private final TensorNumericMath.TensorNumeric ev$46;

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                    TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(double[] data1, int offset1, double[] data2, int offset2) {
                    this.apply$mcD$sp(data1, offset1, data2, offset2);
                }

                public void apply$mcD$sp(double[] data1, int offset1, double[] data2, int offset2) {
                    data1[offset1] = this.ev$46.minus$mcD$sp(data1[offset1], this.ev$46.times$mcD$sp(this.value$9, data2[offset2]));
                }
                {
                    this.value$9 = value$9;
                    this.ev$46 = ev$46;
                    TensorFunc4$class.$init$(this);
                    TensorFunc4$mcD$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, y, func2);
        }
        return self;
    }

    public Tensor<Object> csub$mFc$sp(DenseTensor<Object> self, Tensor<Object> x, float value2, Tensor<Object> y, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(x != null && x.nElement() == y.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"csub expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while y has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)y.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Object object = self == x ? BoxedUnit.UNIT : self.resizeAs(x).copy(x);
        if (self == x && self.isContiguous() && y.isContiguous()) {
            ev.axpy$mcF$sp(y.nElement(), value2, (float[])y.storage().array(), y.storageOffset() - 1, 1, (float[])self.storage().array(), self.storageOffset() - 1, 1);
        } else {
            TensorFunc4$mcF$sp func2 = new TensorFunc4$mcF$sp(value2, ev){
                private final float value$10;
                private final TensorNumericMath.TensorNumeric ev$47;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                    TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(float[] data1, int offset1, float[] data2, int offset2) {
                    this.apply$mcF$sp(data1, offset1, data2, offset2);
                }

                public void apply$mcF$sp(float[] data1, int offset1, float[] data2, int offset2) {
                    data1[offset1] = this.ev$47.minus$mcF$sp(data1[offset1], this.ev$47.times$mcF$sp(this.value$10, data2[offset2]));
                }
                {
                    this.value$10 = value$10;
                    this.ev$47 = ev$47;
                    TensorFunc4$class.$init$(this);
                    TensorFunc4$mcF$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, y, func2);
        }
        return self;
    }

    public Tensor<Object> add$mDc$sp(double s2, DenseTensor<Object> t2, ClassTag<Object> evidence$1, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcD$sp result2 = new DenseTensor$mcD$sp(evidence$1, ev);
        result2.resizeAs(t2);
        result2.copy(t2);
        TensorFunc2$mcD$sp func = new TensorFunc2$mcD$sp(s2, ev){
            private final double s$5;
            private final TensorNumericMath.TensorNumeric ev$48;

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(double[] data2, int index) {
                this.apply$mcD$sp(data2, index);
            }

            public void apply$mcD$sp(double[] data2, int index) {
                data2[index] = this.ev$48.plus$mcD$sp(data2[index], this.s$5);
            }
            {
                this.s$5 = s$5;
                this.ev$48 = ev$48;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcD$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mDc$sp(result2, func);
        return result2;
    }

    public Tensor<Object> add$mFc$sp(float s2, DenseTensor<Object> t2, ClassTag<Object> evidence$1, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcF$sp result2 = new DenseTensor$mcF$sp(evidence$1, ev);
        result2.resizeAs(t2);
        result2.copy(t2);
        TensorFunc2$mcF$sp func = new TensorFunc2$mcF$sp(s2, ev){
            private final float s$6;
            private final TensorNumericMath.TensorNumeric ev$49;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(float[] data2, int index) {
                this.apply$mcF$sp(data2, index);
            }

            public void apply$mcF$sp(float[] data2, int index) {
                data2[index] = this.ev$49.plus$mcF$sp(data2[index], this.s$6);
            }
            {
                this.s$6 = s$6;
                this.ev$49 = ev$49;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcF$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mFc$sp(result2, func);
        return result2;
    }

    public Tensor<Object> add$mDc$sp(DenseTensor<Object> self, Tensor<Object> t2, ClassTag<Object> evidence$2, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcD$sp denseTensor$mcD$sp;
        DenseTensor$mcD$sp result2 = new DenseTensor$mcD$sp(evidence$2, ev);
        result2.resizeAs(self);
        result2.copy(self);
        int n = result2.nElement();
        if (result2.isContiguous() && t2.isContiguous() && n == t2.nElement()) {
            ev.axpy$mcD$sp(n, ev.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)1), ConvertableFrom$ConvertableFromInt$.MODULE$), (double[])t2.storage().array(), t2.storageOffset() - 1, 1, (double[])result2.storage().array(), result2.storageOffset() - 1, 1);
            denseTensor$mcD$sp = result2;
        } else {
            TensorFunc4$mcD$sp func2 = new TensorFunc4$mcD$sp(ev){
                private final TensorNumericMath.TensorNumeric ev$50;

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                    TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(double[] data1, int offset1, double[] data2, int offset2) {
                    this.apply$mcD$sp(data1, offset1, data2, offset2);
                }

                public void apply$mcD$sp(double[] data1, int offset1, double[] data2, int offset2) {
                    data1[offset1] = this.ev$50.plus$mcD$sp(data1[offset1], data2[offset2]);
                }
                {
                    this.ev$50 = ev$50;
                    TensorFunc4$class.$init$(this);
                    TensorFunc4$mcD$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, t2, func2);
            denseTensor$mcD$sp = result2;
        }
        return denseTensor$mcD$sp;
    }

    public Tensor<Object> add$mFc$sp(DenseTensor<Object> self, Tensor<Object> t2, ClassTag<Object> evidence$2, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcF$sp denseTensor$mcF$sp;
        DenseTensor$mcF$sp result2 = new DenseTensor$mcF$sp(evidence$2, ev);
        result2.resizeAs(self);
        result2.copy(self);
        int n = result2.nElement();
        if (result2.isContiguous() && t2.isContiguous() && n == t2.nElement()) {
            ev.axpy$mcF$sp(n, ev.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)1), ConvertableFrom$ConvertableFromInt$.MODULE$), (float[])t2.storage().array(), t2.storageOffset() - 1, 1, (float[])result2.storage().array(), result2.storageOffset() - 1, 1);
            denseTensor$mcF$sp = result2;
        } else {
            TensorFunc4$mcF$sp func2 = new TensorFunc4$mcF$sp(ev){
                private final TensorNumericMath.TensorNumeric ev$51;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                    TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(float[] data1, int offset1, float[] data2, int offset2) {
                    this.apply$mcF$sp(data1, offset1, data2, offset2);
                }

                public void apply$mcF$sp(float[] data1, int offset1, float[] data2, int offset2) {
                    data1[offset1] = this.ev$51.plus$mcF$sp(data1[offset1], data2[offset2]);
                }
                {
                    this.ev$51 = ev$51;
                    TensorFunc4$class.$init$(this);
                    TensorFunc4$mcF$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, t2, func2);
            denseTensor$mcF$sp = result2;
        }
        return denseTensor$mcF$sp;
    }

    public Tensor<Object> sub$mDc$sp(double s2, DenseTensor<Object> t2, ClassTag<Object> evidence$3, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcD$sp result2 = new DenseTensor$mcD$sp(evidence$3, ev);
        result2.resizeAs(t2);
        result2.copy(t2);
        TensorFunc2$mcD$sp func = new TensorFunc2$mcD$sp(s2, ev){
            private final double s$7;
            private final TensorNumericMath.TensorNumeric ev$52;

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(double[] data2, int index) {
                this.apply$mcD$sp(data2, index);
            }

            public void apply$mcD$sp(double[] data2, int index) {
                data2[index] = this.ev$52.minus$mcD$sp(data2[index], this.s$7);
            }
            {
                this.s$7 = s$7;
                this.ev$52 = ev$52;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcD$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mDc$sp(result2, func);
        return result2;
    }

    public Tensor<Object> sub$mFc$sp(float s2, DenseTensor<Object> t2, ClassTag<Object> evidence$3, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcF$sp result2 = new DenseTensor$mcF$sp(evidence$3, ev);
        result2.resizeAs(t2);
        result2.copy(t2);
        TensorFunc2$mcF$sp func = new TensorFunc2$mcF$sp(s2, ev){
            private final float s$8;
            private final TensorNumericMath.TensorNumeric ev$53;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(float[] data2, int index) {
                this.apply$mcF$sp(data2, index);
            }

            public void apply$mcF$sp(float[] data2, int index) {
                data2[index] = this.ev$53.minus$mcF$sp(data2[index], this.s$8);
            }
            {
                this.s$8 = s$8;
                this.ev$53 = ev$53;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcF$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mFc$sp(result2, func);
        return result2;
    }

    public Tensor<Object> sub$mDc$sp(DenseTensor<Object> self, Tensor<Object> t2, ClassTag<Object> evidence$4, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcD$sp result2 = new DenseTensor$mcD$sp(evidence$4, ev);
        result2.resizeAs(self);
        result2.copy(self);
        TensorFunc4$mcD$sp func2 = new TensorFunc4$mcD$sp(ev){
            private final TensorNumericMath.TensorNumeric ev$54;

            public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
            }

            public String toString() {
                return TensorFunc4$class.toString(this);
            }

            public void apply(double[] data1, int offset1, double[] data2, int offset2) {
                this.apply$mcD$sp(data1, offset1, data2, offset2);
            }

            public void apply$mcD$sp(double[] data1, int offset1, double[] data2, int offset2) {
                data1[offset1] = this.ev$54.minus$mcD$sp(data1[offset1], data2[offset2]);
            }
            {
                this.ev$54 = ev$54;
                TensorFunc4$class.$init$(this);
                TensorFunc4$mcD$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply2(result2, t2, func2);
        return result2;
    }

    public Tensor<Object> sub$mFc$sp(DenseTensor<Object> self, Tensor<Object> t2, ClassTag<Object> evidence$4, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcF$sp result2 = new DenseTensor$mcF$sp(evidence$4, ev);
        result2.resizeAs(self);
        result2.copy(self);
        TensorFunc4$mcF$sp func2 = new TensorFunc4$mcF$sp(ev){
            private final TensorNumericMath.TensorNumeric ev$55;

            public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
            }

            public String toString() {
                return TensorFunc4$class.toString(this);
            }

            public void apply(float[] data1, int offset1, float[] data2, int offset2) {
                this.apply$mcF$sp(data1, offset1, data2, offset2);
            }

            public void apply$mcF$sp(float[] data1, int offset1, float[] data2, int offset2) {
                data1[offset1] = this.ev$55.minus$mcF$sp(data1[offset1], data2[offset2]);
            }
            {
                this.ev$55 = ev$55;
                TensorFunc4$class.$init$(this);
                TensorFunc4$mcF$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply2(result2, t2, func2);
        return result2;
    }

    public Tensor<Object> neg$mDc$sp(DenseTensor<Object> self, ClassTag<Object> evidence$5, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcD$sp result2 = new DenseTensor$mcD$sp(evidence$5, ev);
        result2.resizeAs(self);
        result2.copy(self);
        TensorFunc2$mcD$sp func = new TensorFunc2$mcD$sp(ev){
            private final TensorNumericMath.TensorNumeric ev$56;

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(double[] data2, int index) {
                this.apply$mcD$sp(data2, index);
            }

            public void apply$mcD$sp(double[] data2, int index) {
                data2[index] = this.ev$56.negative$mcD$sp(data2[index]);
            }
            {
                this.ev$56 = ev$56;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcD$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mDc$sp(result2, func);
        return result2;
    }

    public Tensor<Object> neg$mFc$sp(DenseTensor<Object> self, ClassTag<Object> evidence$5, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcF$sp result2 = new DenseTensor$mcF$sp(evidence$5, ev);
        result2.resizeAs(self);
        result2.copy(self);
        TensorFunc2$mcF$sp func = new TensorFunc2$mcF$sp(ev){
            private final TensorNumericMath.TensorNumeric ev$57;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(float[] data2, int index) {
                this.apply$mcF$sp(data2, index);
            }

            public void apply$mcF$sp(float[] data2, int index) {
                data2[index] = this.ev$57.negative$mcF$sp(data2[index]);
            }
            {
                this.ev$57 = ev$57;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcF$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mFc$sp(result2, func);
        return result2;
    }

    public Tensor<Object> divide$mDc$sp(double s2, DenseTensor<Object> t2, ClassTag<Object> evidence$6, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcD$sp result2 = new DenseTensor$mcD$sp(evidence$6, ev);
        result2.resizeAs(t2);
        result2.copy(t2);
        TensorFunc2$mcD$sp func = new TensorFunc2$mcD$sp(s2, ev){
            private final double s$9;
            private final TensorNumericMath.TensorNumeric ev$58;

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(double[] data2, int index) {
                this.apply$mcD$sp(data2, index);
            }

            public void apply$mcD$sp(double[] data2, int index) {
                data2[index] = this.ev$58.divide$mcD$sp(data2[index], this.s$9);
            }
            {
                this.s$9 = s$9;
                this.ev$58 = ev$58;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcD$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mDc$sp(result2, func);
        return result2;
    }

    public Tensor<Object> divide$mFc$sp(float s2, DenseTensor<Object> t2, ClassTag<Object> evidence$6, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcF$sp result2 = new DenseTensor$mcF$sp(evidence$6, ev);
        result2.resizeAs(t2);
        result2.copy(t2);
        TensorFunc2$mcF$sp func = new TensorFunc2$mcF$sp(s2, ev){
            private final float s$10;
            private final TensorNumericMath.TensorNumeric ev$59;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(float[] data2, int index) {
                this.apply$mcF$sp(data2, index);
            }

            public void apply$mcF$sp(float[] data2, int index) {
                data2[index] = this.ev$59.divide$mcF$sp(data2[index], this.s$10);
            }
            {
                this.s$10 = s$10;
                this.ev$59 = ev$59;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcF$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mFc$sp(result2, func);
        return result2;
    }

    public Tensor<Object> divide$mDc$sp(DenseTensor<Object> self, Tensor<Object> t2, ClassTag<Object> evidence$7, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcD$sp result2 = new DenseTensor$mcD$sp(evidence$7, ev);
        result2.resizeAs(self);
        result2.copy(self);
        TensorFunc4$mcD$sp func2 = new TensorFunc4$mcD$sp(ev){
            private final TensorNumericMath.TensorNumeric ev$60;

            public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
            }

            public String toString() {
                return TensorFunc4$class.toString(this);
            }

            public void apply(double[] data1, int offset1, double[] data2, int offset2) {
                this.apply$mcD$sp(data1, offset1, data2, offset2);
            }

            public void apply$mcD$sp(double[] data1, int offset1, double[] data2, int offset2) {
                data1[offset1] = this.ev$60.divide$mcD$sp(data1[offset1], data2[offset2]);
            }
            {
                this.ev$60 = ev$60;
                TensorFunc4$class.$init$(this);
                TensorFunc4$mcD$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply2(result2, t2, func2);
        return result2;
    }

    public Tensor<Object> divide$mFc$sp(DenseTensor<Object> self, Tensor<Object> t2, ClassTag<Object> evidence$7, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcF$sp result2 = new DenseTensor$mcF$sp(evidence$7, ev);
        result2.resizeAs(self);
        result2.copy(self);
        TensorFunc4$mcF$sp func2 = new TensorFunc4$mcF$sp(ev){
            private final TensorNumericMath.TensorNumeric ev$61;

            public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
            }

            public String toString() {
                return TensorFunc4$class.toString(this);
            }

            public void apply(float[] data1, int offset1, float[] data2, int offset2) {
                this.apply$mcF$sp(data1, offset1, data2, offset2);
            }

            public void apply$mcF$sp(float[] data1, int offset1, float[] data2, int offset2) {
                data1[offset1] = this.ev$61.divide$mcF$sp(data1[offset1], data2[offset2]);
            }
            {
                this.ev$61 = ev$61;
                TensorFunc4$class.$init$(this);
                TensorFunc4$mcF$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply2(result2, t2, func2);
        return result2;
    }

    public Tensor<Object> mul$mDc$sp(double s2, DenseTensor<Object> t2, ClassTag<Object> evidence$8, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcD$sp result2 = new DenseTensor$mcD$sp(evidence$8, ev);
        result2.resizeAs(t2);
        result2.copy(t2);
        TensorFunc2$mcD$sp func = new TensorFunc2$mcD$sp(s2, ev){
            private final double s$11;
            private final TensorNumericMath.TensorNumeric ev$62;

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(double[] data2, int index) {
                this.apply$mcD$sp(data2, index);
            }

            public void apply$mcD$sp(double[] data2, int index) {
                data2[index] = this.ev$62.times$mcD$sp(data2[index], this.s$11);
            }
            {
                this.s$11 = s$11;
                this.ev$62 = ev$62;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcD$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mDc$sp(result2, func);
        return result2;
    }

    public Tensor<Object> mul$mFc$sp(float s2, DenseTensor<Object> t2, ClassTag<Object> evidence$8, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcF$sp result2 = new DenseTensor$mcF$sp(evidence$8, ev);
        result2.resizeAs(t2);
        result2.copy(t2);
        TensorFunc2$mcF$sp func = new TensorFunc2$mcF$sp(s2, ev){
            private final float s$12;
            private final TensorNumericMath.TensorNumeric ev$63;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(float[] data2, int index) {
                this.apply$mcF$sp(data2, index);
            }

            public void apply$mcF$sp(float[] data2, int index) {
                data2[index] = this.ev$63.times$mcF$sp(data2[index], this.s$12);
            }
            {
                this.s$12 = s$12;
                this.ev$63 = ev$63;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcF$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mFc$sp(result2, func);
        return result2;
    }

    public Tensor<Object> mul$mDc$sp(Tensor<Object> self, Tensor<Object> t2, ClassTag<Object> evidence$9, TensorNumericMath.TensorNumeric<Object> ev) {
        Tensor<Object> tensor;
        if (self.nDimension() == 1 && t2.nDimension() == 1) {
            Log4Error$.MODULE$.unKnowExceptionError(self.size(1) == t2.size(1), "vector size not match", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            double result2 = ev.dot$mcD$sp(self.nElement(), (double[])self.storage().array(), self.storageOffset() - 1, self.stride(1), (double[])t2.storage().array(), t2.storageOffset() - 1, t2.stride(1));
            tensor = new DenseTensor$mcD$sp(new ArrayStorage$mcD$sp((double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new double[]{result2}), evidence$9), evidence$9), evidence$9, ev);
        } else if (self.nDimension() == 2 && t2.nDimension() == 1) {
            DenseTensor$mcD$sp result3 = new DenseTensor$mcD$sp(self.size(1), evidence$9, ev);
            DenseTensorBLAS$.MODULE$.gemv$mDc$sp(ev.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)1), ConvertableFrom$ConvertableFromInt$.MODULE$), self, t2, ev.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$), result3, ev);
            tensor = result3;
        } else if (self.nDimension() == 2 && t2.nDimension() == 2) {
            Tensor<Object> result4 = new DenseTensor$mcD$sp(t2.size(2), self.size(1), evidence$9, ev).t();
            this.addmm$mDc$sp(result4, ev.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$), result4, ev.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)1), ConvertableFrom$ConvertableFromInt$.MODULE$), self, t2, evidence$9, ev);
            tensor = result4;
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(false, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"multiplication between ", "D and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nDimension())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "D not yet supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.nDimension())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            tensor = null;
        }
        return tensor;
    }

    public Tensor<Object> mul$mFc$sp(Tensor<Object> self, Tensor<Object> t2, ClassTag<Object> evidence$9, TensorNumericMath.TensorNumeric<Object> ev) {
        Tensor<Object> tensor;
        if (self.nDimension() == 1 && t2.nDimension() == 1) {
            Log4Error$.MODULE$.unKnowExceptionError(self.size(1) == t2.size(1), "vector size not match", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            float result2 = ev.dot$mcF$sp(self.nElement(), (float[])self.storage().array(), self.storageOffset() - 1, self.stride(1), (float[])t2.storage().array(), t2.storageOffset() - 1, t2.stride(1));
            tensor = new DenseTensor$mcF$sp(new ArrayStorage$mcF$sp((float[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new float[]{result2}), evidence$9), evidence$9), evidence$9, ev);
        } else if (self.nDimension() == 2 && t2.nDimension() == 1) {
            DenseTensor$mcF$sp result3 = new DenseTensor$mcF$sp(self.size(1), evidence$9, ev);
            DenseTensorBLAS$.MODULE$.gemv$mFc$sp(ev.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)1), ConvertableFrom$ConvertableFromInt$.MODULE$), self, t2, ev.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$), result3, ev);
            tensor = result3;
        } else if (self.nDimension() == 2 && t2.nDimension() == 2) {
            Tensor<Object> result4 = new DenseTensor$mcF$sp(t2.size(2), self.size(1), evidence$9, ev).t();
            this.addmm$mFc$sp(result4, ev.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$), result4, ev.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)1), ConvertableFrom$ConvertableFromInt$.MODULE$), self, t2, evidence$9, ev);
            tensor = result4;
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(false, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"multiplication between ", "D and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nDimension())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "D not yet supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.nDimension())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            tensor = null;
        }
        return tensor;
    }

    public Tensor<Object> pow$mDc$sp(DenseTensor<Object> self, Tensor<Object> x, double n, ClassTag<Object> evidence$10, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pow expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while current tensor has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)self.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (MKL.isMKLLoaded() && self.isContiguous() && x.isContiguous()) {
            ev.vPowx$mcD$sp(self.nElement(), (double[])x.storage().array(), x.storageOffset() - 1, n, (double[])self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc4$mcD$sp func = new TensorFunc4$mcD$sp(n, ev){
                private final double n$2;
                private final TensorNumericMath.TensorNumeric ev$64;

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                    TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(double[] data1, int offset1, double[] data2, int offset2) {
                    this.apply$mcD$sp(data1, offset1, data2, offset2);
                }

                public void apply$mcD$sp(double[] data1, int offset1, double[] data2, int offset2) {
                    data1[offset1] = this.ev$64.pow$mcD$sp(data2[offset2], this.n$2);
                }
                {
                    this.n$2 = n$2;
                    this.ev$64 = ev$64;
                    TensorFunc4$class.$init$(this);
                    TensorFunc4$mcD$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, x, func);
        }
        return self;
    }

    public Tensor<Object> pow$mFc$sp(DenseTensor<Object> self, Tensor<Object> x, float n, ClassTag<Object> evidence$10, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pow expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while current tensor has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)self.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (MKL.isMKLLoaded() && self.isContiguous() && x.isContiguous()) {
            ev.vPowx$mcF$sp(self.nElement(), (float[])x.storage().array(), x.storageOffset() - 1, n, (float[])self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc4$mcF$sp func = new TensorFunc4$mcF$sp(n, ev){
                private final float n$3;
                private final TensorNumericMath.TensorNumeric ev$65;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                    TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(float[] data1, int offset1, float[] data2, int offset2) {
                    this.apply$mcF$sp(data1, offset1, data2, offset2);
                }

                public void apply$mcF$sp(float[] data1, int offset1, float[] data2, int offset2) {
                    data1[offset1] = this.ev$65.pow$mcF$sp(data2[offset2], this.n$3);
                }
                {
                    this.n$3 = n$3;
                    this.ev$65 = ev$65;
                    TensorFunc4$class.$init$(this);
                    TensorFunc4$mcF$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, x, func);
        }
        return self;
    }

    public Tensor<Object> exp$mDc$sp(DenseTensor<Object> self, Tensor<Object> x, ClassTag<Object> evidence$11, TensorNumericMath.TensorNumeric<Object> ev) {
        Object object = self.nElement() != x.nElement() ? self.resizeAs(x) : BoxedUnit.UNIT;
        if (MKL.isMKLLoaded() && self.isContiguous() && x.isContiguous()) {
            ev.vExp$mcD$sp(self.nElement(), (double[])x.storage().array(), x.storageOffset() - 1, (double[])self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc4$mcD$sp func = new TensorFunc4$mcD$sp(ev){
                private final TensorNumericMath.TensorNumeric ev$66;

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                    TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(double[] data1, int offset1, double[] data2, int offset2) {
                    this.apply$mcD$sp(data1, offset1, data2, offset2);
                }

                public void apply$mcD$sp(double[] data1, int offset1, double[] data2, int offset2) {
                    data1[offset1] = this.ev$66.exp$mcD$sp(data2[offset2]);
                }
                {
                    this.ev$66 = ev$66;
                    TensorFunc4$class.$init$(this);
                    TensorFunc4$mcD$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, x, func);
        }
        return self;
    }

    public Tensor<Object> exp$mFc$sp(DenseTensor<Object> self, Tensor<Object> x, ClassTag<Object> evidence$11, TensorNumericMath.TensorNumeric<Object> ev) {
        Object object = self.nElement() != x.nElement() ? self.resizeAs(x) : BoxedUnit.UNIT;
        if (MKL.isMKLLoaded() && self.isContiguous() && x.isContiguous()) {
            ev.vExp$mcF$sp(self.nElement(), (float[])x.storage().array(), x.storageOffset() - 1, (float[])self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc4$mcF$sp func = new TensorFunc4$mcF$sp(ev){
                private final TensorNumericMath.TensorNumeric ev$67;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                    TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(float[] data1, int offset1, float[] data2, int offset2) {
                    this.apply$mcF$sp(data1, offset1, data2, offset2);
                }

                public void apply$mcF$sp(float[] data1, int offset1, float[] data2, int offset2) {
                    data1[offset1] = this.ev$67.exp$mcF$sp(data2[offset2]);
                }
                {
                    this.ev$67 = ev$67;
                    TensorFunc4$class.$init$(this);
                    TensorFunc4$mcF$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, x, func);
        }
        return self;
    }

    public Tensor<Object> log$mDc$sp(DenseTensor<Object> self, Tensor<Object> x, ClassTag<Object> evidence$12, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while current tensor has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)self.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (MKL.isMKLLoaded() && self.isContiguous() && x.isContiguous()) {
            ev.vLn$mcD$sp(self.nElement(), (double[])x.storage().array(), x.storageOffset() - 1, (double[])self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc4$mcD$sp func = new TensorFunc4$mcD$sp(ev){
                private final TensorNumericMath.TensorNumeric ev$68;

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                    TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(double[] data1, int offset1, double[] data2, int offset2) {
                    this.apply$mcD$sp(data1, offset1, data2, offset2);
                }

                public void apply$mcD$sp(double[] data1, int offset1, double[] data2, int offset2) {
                    data1[offset1] = this.ev$68.log$mcD$sp(data2[offset2]);
                }
                {
                    this.ev$68 = ev$68;
                    TensorFunc4$class.$init$(this);
                    TensorFunc4$mcD$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, x, func);
        }
        return self;
    }

    public Tensor<Object> log$mFc$sp(DenseTensor<Object> self, Tensor<Object> x, ClassTag<Object> evidence$12, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while current tensor has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)self.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (MKL.isMKLLoaded() && self.isContiguous() && x.isContiguous()) {
            ev.vLn$mcF$sp(self.nElement(), (float[])x.storage().array(), x.storageOffset() - 1, (float[])self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc4$mcF$sp func = new TensorFunc4$mcF$sp(ev){
                private final TensorNumericMath.TensorNumeric ev$69;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                    TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(float[] data1, int offset1, float[] data2, int offset2) {
                    this.apply$mcF$sp(data1, offset1, data2, offset2);
                }

                public void apply$mcF$sp(float[] data1, int offset1, float[] data2, int offset2) {
                    data1[offset1] = this.ev$69.log$mcF$sp(data2[offset2]);
                }
                {
                    this.ev$69 = ev$69;
                    TensorFunc4$class.$init$(this);
                    TensorFunc4$mcF$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, x, func);
        }
        return self;
    }

    public Tensor<Object> sqrt$mDc$sp(DenseTensor<Object> self, Tensor<Object> x, ClassTag<Object> evidence$13, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sqrt expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while current tensor has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)self.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (MKL.isMKLLoaded() && self.isContiguous() && x.isContiguous()) {
            ev.vSqrt$mcD$sp(self.nElement(), (double[])x.storage().array(), x.storageOffset() - 1, (double[])self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc4$mcD$sp func = new TensorFunc4$mcD$sp(ev){
                private final TensorNumericMath.TensorNumeric ev$70;

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                    TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(double[] data1, int offset1, double[] data2, int offset2) {
                    this.apply$mcD$sp(data1, offset1, data2, offset2);
                }

                public void apply$mcD$sp(double[] data1, int offset1, double[] data2, int offset2) {
                    data1[offset1] = this.ev$70.sqrt$mcD$sp(data2[offset2]);
                }
                {
                    this.ev$70 = ev$70;
                    TensorFunc4$class.$init$(this);
                    TensorFunc4$mcD$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, x, func);
        }
        return self;
    }

    public Tensor<Object> sqrt$mFc$sp(DenseTensor<Object> self, Tensor<Object> x, ClassTag<Object> evidence$13, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sqrt expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while current tensor has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)self.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (MKL.isMKLLoaded() && self.isContiguous() && x.isContiguous()) {
            ev.vSqrt$mcF$sp(self.nElement(), (float[])x.storage().array(), x.storageOffset() - 1, (float[])self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc4$mcF$sp func = new TensorFunc4$mcF$sp(ev){
                private final TensorNumericMath.TensorNumeric ev$71;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                    TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(float[] data1, int offset1, float[] data2, int offset2) {
                    this.apply$mcF$sp(data1, offset1, data2, offset2);
                }

                public void apply$mcF$sp(float[] data1, int offset1, float[] data2, int offset2) {
                    data1[offset1] = this.ev$71.sqrt$mcF$sp(data2[offset2]);
                }
                {
                    this.ev$71 = ev$71;
                    TensorFunc4$class.$init$(this);
                    TensorFunc4$mcF$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, x, func);
        }
        return self;
    }

    public Tensor<Object> tanh$mDc$sp(DenseTensor<Object> self, Tensor<Object> x, ClassTag<Object> evidence$14, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tanh expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while current tensor has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)self.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (MKL.isMKLLoaded() && self.isContiguous() && x.isContiguous()) {
            ev.vTanh$mcD$sp(self.nElement(), (double[])x.storage().array(), x.storageOffset() - 1, (double[])self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc4$mcD$sp func = new TensorFunc4$mcD$sp(ev){
                private final TensorNumericMath.TensorNumeric ev$72;

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                    TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(double[] data1, int offset1, double[] data2, int offset2) {
                    this.apply$mcD$sp(data1, offset1, data2, offset2);
                }

                public void apply$mcD$sp(double[] data1, int offset1, double[] data2, int offset2) {
                    data1[offset1] = this.ev$72.tanh$mcD$sp(data2[offset2]);
                }
                {
                    this.ev$72 = ev$72;
                    TensorFunc4$class.$init$(this);
                    TensorFunc4$mcD$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, x, func);
        }
        return self;
    }

    public Tensor<Object> tanh$mFc$sp(DenseTensor<Object> self, Tensor<Object> x, ClassTag<Object> evidence$14, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tanh expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while current tensor has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)self.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (MKL.isMKLLoaded() && self.isContiguous() && x.isContiguous()) {
            ev.vTanh$mcF$sp(self.nElement(), (float[])x.storage().array(), x.storageOffset() - 1, (float[])self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc4$mcF$sp func = new TensorFunc4$mcF$sp(ev){
                private final TensorNumericMath.TensorNumeric ev$73;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                    TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(float[] data1, int offset1, float[] data2, int offset2) {
                    this.apply$mcF$sp(data1, offset1, data2, offset2);
                }

                public void apply$mcF$sp(float[] data1, int offset1, float[] data2, int offset2) {
                    data1[offset1] = this.ev$73.tanh$mcF$sp(data2[offset2]);
                }
                {
                    this.ev$73 = ev$73;
                    TensorFunc4$class.$init$(this);
                    TensorFunc4$mcF$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, x, func);
        }
        return self;
    }

    public Tensor<Object> log1p$mDc$sp(DenseTensor<Object> self, Tensor<Object> x, ClassTag<Object> evidence$15, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log1p expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while current tensor has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)self.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (MKL.isMKLLoaded() && self.isContiguous() && x.isContiguous()) {
            ev.vLog1p$mcD$sp(self.nElement(), (double[])x.storage().array(), x.storageOffset() - 1, (double[])self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc4$mcD$sp func = new TensorFunc4$mcD$sp(ev){
                private final TensorNumericMath.TensorNumeric ev$74;

                public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                    TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(double[] data1, int offset1, double[] data2, int offset2) {
                    this.apply$mcD$sp(data1, offset1, data2, offset2);
                }

                public void apply$mcD$sp(double[] data1, int offset1, double[] data2, int offset2) {
                    data1[offset1] = this.ev$74.log1p$mcD$sp(data2[offset2]);
                }
                {
                    this.ev$74 = ev$74;
                    TensorFunc4$class.$init$(this);
                    TensorFunc4$mcD$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, x, func);
        }
        return self;
    }

    public Tensor<Object> log1p$mFc$sp(DenseTensor<Object> self, Tensor<Object> x, ClassTag<Object> evidence$15, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == x.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log1p expect two tensors has same number of elements. But x has"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " elements while current tensor has ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.nElement()), BoxesRunTime.boxToInteger((int)self.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (MKL.isMKLLoaded() && self.isContiguous() && x.isContiguous()) {
            ev.vLog1p$mcF$sp(self.nElement(), (float[])x.storage().array(), x.storageOffset() - 1, (float[])self.storage().array(), self.storageOffset() - 1);
        } else {
            TensorFunc4$mcF$sp func = new TensorFunc4$mcF$sp(ev){
                private final TensorNumericMath.TensorNumeric ev$75;

                public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                    TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
                }

                public String toString() {
                    return TensorFunc4$class.toString(this);
                }

                public void apply(float[] data1, int offset1, float[] data2, int offset2) {
                    this.apply$mcF$sp(data1, offset1, data2, offset2);
                }

                public void apply$mcF$sp(float[] data1, int offset1, float[] data2, int offset2) {
                    data1[offset1] = this.ev$75.log1p$mcF$sp(data2[offset2]);
                }
                {
                    this.ev$75 = ev$75;
                    TensorFunc4$class.$init$(this);
                    TensorFunc4$mcF$sp$class.$init$(this);
                }
            };
            DenseTensorApply$.MODULE$.apply2(self, x, func);
        }
        return self;
    }

    public double prodAll$mDc$sp(DenseTensor<Object> self, TensorNumericMath.TensorNumeric<Object> ev) {
        DoubleRef product = DoubleRef.create((double)ev.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)1), ConvertableFrom$ConvertableFromInt$.MODULE$));
        TensorFunc2$mcD$sp func = new TensorFunc2$mcD$sp(ev, product){
            private final TensorNumericMath.TensorNumeric ev$76;
            private final DoubleRef product$2;

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(double[] data2, int index) {
                this.apply$mcD$sp(data2, index);
            }

            public void apply$mcD$sp(double[] data2, int index) {
                this.product$2.elem = this.ev$76.times$mcD$sp(data2[index], this.product$2.elem);
            }
            {
                this.ev$76 = ev$76;
                this.product$2 = product$2;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcD$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mDc$sp(self, func);
        return product.elem;
    }

    public float prodAll$mFc$sp(DenseTensor<Object> self, TensorNumericMath.TensorNumeric<Object> ev) {
        FloatRef product = FloatRef.create((float)ev.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)1), ConvertableFrom$ConvertableFromInt$.MODULE$));
        TensorFunc2$mcF$sp func = new TensorFunc2$mcF$sp(ev, product){
            private final TensorNumericMath.TensorNumeric ev$77;
            private final FloatRef product$3;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(float[] data2, int index) {
                this.apply$mcF$sp(data2, index);
            }

            public void apply$mcF$sp(float[] data2, int index) {
                this.product$3.elem = this.ev$77.times$mcF$sp(data2[index], this.product$3.elem);
            }
            {
                this.ev$77 = ev$77;
                this.product$3 = product$3;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcF$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mFc$sp(self, func);
        return product.elem;
    }

    public double sumAll$mDc$sp(DenseTensor<Object> self, TensorNumericMath.TensorNumeric<Object> ev) {
        DoubleRef sum2 = DoubleRef.create((double)ev.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$));
        TensorFunc2$mcD$sp func = new TensorFunc2$mcD$sp(ev, sum2){
            private final TensorNumericMath.TensorNumeric ev$78;
            private final DoubleRef sum$3;

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(double[] data2, int index) {
                this.apply$mcD$sp(data2, index);
            }

            public void apply$mcD$sp(double[] data2, int index) {
                this.sum$3.elem = this.ev$78.plus$mcD$sp(data2[index], this.sum$3.elem);
            }
            {
                this.ev$78 = ev$78;
                this.sum$3 = sum$3;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcD$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mDc$sp(self, func);
        return sum2.elem;
    }

    public float sumAll$mFc$sp(DenseTensor<Object> self, TensorNumericMath.TensorNumeric<Object> ev) {
        FloatRef sum2 = FloatRef.create((float)ev.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$));
        TensorFunc2$mcF$sp func = new TensorFunc2$mcF$sp(ev, sum2){
            private final TensorNumericMath.TensorNumeric ev$79;
            private final FloatRef sum$4;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(float[] data2, int index) {
                this.apply$mcF$sp(data2, index);
            }

            public void apply$mcF$sp(float[] data2, int index) {
                this.sum$4.elem = this.ev$79.plus$mcF$sp(data2[index], this.sum$4.elem);
            }
            {
                this.ev$79 = ev$79;
                this.sum$4 = sum$4;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcF$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mFc$sp(self, func);
        return sum2.elem;
    }

    public Tensor<Object> prod$mDc$sp(DenseTensor<Object> self, Tensor<Object> x, int _dim, ClassTag<Object> evidence$16, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < x.nDimension(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension ", " out of range"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(_dim + 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        DenseTensor$mcD$sp result2 = self == null ? new DenseTensor$mcD$sp(evidence$16, ev) : self;
        int[] sizes = x.size();
        sizes[_dim] = 1;
        result2.resize(sizes, result2.resize$default$2());
        DenseTensorDimApply$.MODULE$.dimApply2$mDc$sp(result2, x, _dim, (Function8<double[], Object, Object, Object, double[], Object, Object, Object, BoxedUnit>)new Serializable(ev){
            private final TensorNumericMath.TensorNumeric ev$80;

            public final void apply(double[] rData, int rOffset, int rStride, int rSize, double[] tData, int tOffset, int tStride, int tSize) {
                rData[rOffset] = this.ev$80.prod$mcD$sp(tSize, tData, tOffset, tStride);
            }
            {
                this.ev$80 = ev$80;
            }
        });
        return result2;
    }

    public Tensor<Object> prod$mFc$sp(DenseTensor<Object> self, Tensor<Object> x, int _dim, ClassTag<Object> evidence$16, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < x.nDimension(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension ", " out of range"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(_dim + 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        DenseTensor$mcF$sp result2 = self == null ? new DenseTensor$mcF$sp(evidence$16, ev) : self;
        int[] sizes = x.size();
        sizes[_dim] = 1;
        result2.resize(sizes, result2.resize$default$2());
        DenseTensorDimApply$.MODULE$.dimApply2$mFc$sp(result2, x, _dim, (Function8<float[], Object, Object, Object, float[], Object, Object, Object, BoxedUnit>)new Serializable(ev){
            private final TensorNumericMath.TensorNumeric ev$81;

            public final void apply(float[] rData, int rOffset, int rStride, int rSize, float[] tData, int tOffset, int tStride, int tSize) {
                rData[rOffset] = this.ev$81.prod$mcF$sp(tSize, tData, tOffset, tStride);
            }
            {
                this.ev$81 = ev$81;
            }
        });
        return result2;
    }

    public Tensor<Object> sum$mZc$sp(DenseTensor<Object> self, Tensor<Object> x, int _dim, ClassTag<Object> evidence$17, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < x.nDimension(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension ", " out of range"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(_dim + 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        DenseTensor$mcZ$sp result2 = self == null ? new DenseTensor$mcZ$sp(evidence$17, ev) : self;
        int[] sizes = x.size();
        sizes[_dim] = 1;
        result2.resize(sizes, result2.resize$default$2());
        DenseTensorDimApply$.MODULE$.dimApply2(result2, x, _dim, (Function8<Object, Object, Object, Object, Object, Object, Object, Object, BoxedUnit>)new Serializable(ev){
            private final TensorNumericMath.TensorNumeric ev$82;

            public final void apply(boolean[] rData, int rOffset, int rStride, int rSize, boolean[] tData, int tOffset, int tStride, int tSize) {
                rData[rOffset] = BoxesRunTime.unboxToBoolean(this.ev$82.sum(tSize, tData, tOffset, tStride));
            }
            {
                this.ev$82 = ev$82;
            }
        });
        return result2;
    }

    public Tensor<Object> sum$mBc$sp(DenseTensor<Object> self, Tensor<Object> x, int _dim, ClassTag<Object> evidence$17, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < x.nDimension(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension ", " out of range"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(_dim + 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        DenseTensor$mcB$sp result2 = self == null ? new DenseTensor$mcB$sp(evidence$17, ev) : self;
        int[] sizes = x.size();
        sizes[_dim] = 1;
        result2.resize(sizes, result2.resize$default$2());
        DenseTensorDimApply$.MODULE$.dimApply2(result2, x, _dim, (Function8<Object, Object, Object, Object, Object, Object, Object, Object, BoxedUnit>)new Serializable(ev){
            private final TensorNumericMath.TensorNumeric ev$83;

            public final void apply(byte[] rData, int rOffset, int rStride, int rSize, byte[] tData, int tOffset, int tStride, int tSize) {
                rData[rOffset] = BoxesRunTime.unboxToByte(this.ev$83.sum(tSize, tData, tOffset, tStride));
            }
            {
                this.ev$83 = ev$83;
            }
        });
        return result2;
    }

    public Tensor<Object> sum$mCc$sp(DenseTensor<Object> self, Tensor<Object> x, int _dim, ClassTag<Object> evidence$17, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < x.nDimension(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension ", " out of range"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(_dim + 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        DenseTensor$mcC$sp result2 = self == null ? new DenseTensor$mcC$sp(evidence$17, ev) : self;
        int[] sizes = x.size();
        sizes[_dim] = 1;
        result2.resize(sizes, result2.resize$default$2());
        DenseTensorDimApply$.MODULE$.dimApply2(result2, x, _dim, (Function8<Object, Object, Object, Object, Object, Object, Object, Object, BoxedUnit>)new Serializable(ev){
            private final TensorNumericMath.TensorNumeric ev$84;

            public final void apply(char[] rData, int rOffset, int rStride, int rSize, char[] tData, int tOffset, int tStride, int tSize) {
                rData[rOffset] = BoxesRunTime.unboxToChar(this.ev$84.sum(tSize, tData, tOffset, tStride));
            }
            {
                this.ev$84 = ev$84;
            }
        });
        return result2;
    }

    public Tensor<Object> sum$mDc$sp(DenseTensor<Object> self, Tensor<Object> x, int _dim, ClassTag<Object> evidence$17, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < x.nDimension(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension ", " out of range"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(_dim + 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        DenseTensor$mcD$sp result2 = self == null ? new DenseTensor$mcD$sp(evidence$17, ev) : self;
        int[] sizes = x.size();
        sizes[_dim] = 1;
        result2.resize(sizes, result2.resize$default$2());
        DenseTensorDimApply$.MODULE$.dimApply2$mDc$sp(result2, x, _dim, (Function8<double[], Object, Object, Object, double[], Object, Object, Object, BoxedUnit>)new Serializable(ev){
            private final TensorNumericMath.TensorNumeric ev$85;

            public final void apply(double[] rData, int rOffset, int rStride, int rSize, double[] tData, int tOffset, int tStride, int tSize) {
                rData[rOffset] = this.ev$85.sum$mcD$sp(tSize, tData, tOffset, tStride);
            }
            {
                this.ev$85 = ev$85;
            }
        });
        return result2;
    }

    public Tensor<Object> sum$mFc$sp(DenseTensor<Object> self, Tensor<Object> x, int _dim, ClassTag<Object> evidence$17, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < x.nDimension(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension ", " out of range"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(_dim + 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        DenseTensor$mcF$sp result2 = self == null ? new DenseTensor$mcF$sp(evidence$17, ev) : self;
        int[] sizes = x.size();
        sizes[_dim] = 1;
        result2.resize(sizes, result2.resize$default$2());
        DenseTensorDimApply$.MODULE$.dimApply2$mFc$sp(result2, x, _dim, (Function8<float[], Object, Object, Object, float[], Object, Object, Object, BoxedUnit>)new Serializable(ev){
            private final TensorNumericMath.TensorNumeric ev$86;

            public final void apply(float[] rData, int rOffset, int rStride, int rSize, float[] tData, int tOffset, int tStride, int tSize) {
                rData[rOffset] = this.ev$86.sum$mcF$sp(tSize, tData, tOffset, tStride);
            }
            {
                this.ev$86 = ev$86;
            }
        });
        return result2;
    }

    public Tensor<Object> sum$mIc$sp(DenseTensor<Object> self, Tensor<Object> x, int _dim, ClassTag<Object> evidence$17, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < x.nDimension(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension ", " out of range"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(_dim + 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        DenseTensor$mcI$sp result2 = self == null ? new DenseTensor$mcI$sp(evidence$17, ev) : self;
        int[] sizes = x.size();
        sizes[_dim] = 1;
        result2.resize(sizes, result2.resize$default$2());
        DenseTensorDimApply$.MODULE$.dimApply2(result2, x, _dim, (Function8<Object, Object, Object, Object, Object, Object, Object, Object, BoxedUnit>)new Serializable(ev){
            private final TensorNumericMath.TensorNumeric ev$87;

            public final void apply(int[] rData, int rOffset, int rStride, int rSize, int[] tData, int tOffset, int tStride, int tSize) {
                rData[rOffset] = BoxesRunTime.unboxToInt(this.ev$87.sum(tSize, tData, tOffset, tStride));
            }
            {
                this.ev$87 = ev$87;
            }
        });
        return result2;
    }

    public Tensor<Object> sum$mJc$sp(DenseTensor<Object> self, Tensor<Object> x, int _dim, ClassTag<Object> evidence$17, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < x.nDimension(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension ", " out of range"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(_dim + 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        DenseTensor$mcJ$sp result2 = self == null ? new DenseTensor$mcJ$sp(evidence$17, ev) : self;
        int[] sizes = x.size();
        sizes[_dim] = 1;
        result2.resize(sizes, result2.resize$default$2());
        DenseTensorDimApply$.MODULE$.dimApply2(result2, x, _dim, (Function8<Object, Object, Object, Object, Object, Object, Object, Object, BoxedUnit>)new Serializable(ev){
            private final TensorNumericMath.TensorNumeric ev$88;

            public final void apply(long[] rData, int rOffset, int rStride, int rSize, long[] tData, int tOffset, int tStride, int tSize) {
                rData[rOffset] = BoxesRunTime.unboxToLong(this.ev$88.sum(tSize, tData, tOffset, tStride));
            }
            {
                this.ev$88 = ev$88;
            }
        });
        return result2;
    }

    public Tensor<Object> sum$mSc$sp(DenseTensor<Object> self, Tensor<Object> x, int _dim, ClassTag<Object> evidence$17, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < x.nDimension(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension ", " out of range"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(_dim + 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        DenseTensor$mcS$sp result2 = self == null ? new DenseTensor$mcS$sp(evidence$17, ev) : self;
        int[] sizes = x.size();
        sizes[_dim] = 1;
        result2.resize(sizes, result2.resize$default$2());
        DenseTensorDimApply$.MODULE$.dimApply2(result2, x, _dim, (Function8<Object, Object, Object, Object, Object, Object, Object, Object, BoxedUnit>)new Serializable(ev){
            private final TensorNumericMath.TensorNumeric ev$89;

            public final void apply(short[] rData, int rOffset, int rStride, int rSize, short[] tData, int tOffset, int tStride, int tSize) {
                rData[rOffset] = BoxesRunTime.unboxToShort(this.ev$89.sum(tSize, tData, tOffset, tStride));
            }
            {
                this.ev$89 = ev$89;
            }
        });
        return result2;
    }

    public Tensor<BoxedUnit> sum$mVc$sp(DenseTensor<BoxedUnit> self, Tensor<BoxedUnit> x, int _dim, ClassTag<BoxedUnit> evidence$17, TensorNumericMath.TensorNumeric<BoxedUnit> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < x.nDimension(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension ", " out of range"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(_dim + 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        DenseTensor$mcV$sp result2 = self == null ? new DenseTensor$mcV$sp(evidence$17, ev) : self;
        int[] sizes = x.size();
        sizes[_dim] = 1;
        result2.resize(sizes, result2.resize$default$2());
        DenseTensorDimApply$.MODULE$.dimApply2(result2, x, _dim, (Function8<Object, Object, Object, Object, Object, Object, Object, Object, BoxedUnit>)new Serializable(ev){
            private final TensorNumericMath.TensorNumeric ev$90;

            public final void apply(BoxedUnit[] rData, int rOffset, int rStride, int rSize, BoxedUnit[] tData, int tOffset, int tStride, int tSize) {
                rData[rOffset] = (BoxedUnit)this.ev$90.sum(tSize, tData, tOffset, tStride);
            }
            {
                this.ev$90 = ev$90;
            }
        });
        return result2;
    }

    public double maxAll$mDc$sp(DenseTensor<Object> self, TensorNumericMath.TensorNumeric<Object> ev) {
        DoubleRef max2 = DoubleRef.create((double)ev.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$));
        BooleanRef first = BooleanRef.create((boolean)true);
        TensorFunc2$mcD$sp func = new TensorFunc2$mcD$sp(ev, max2, first){
            private final TensorNumericMath.TensorNumeric ev$91;
            private final DoubleRef max$2;
            private final BooleanRef first$3;

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(double[] data2, int index) {
                this.apply$mcD$sp(data2, index);
            }

            public void apply$mcD$sp(double[] data2, int index) {
                if (this.first$3.elem) {
                    this.first$3.elem = false;
                    this.max$2.elem = data2[index];
                } else if (this.ev$91.isGreater$mcD$sp(data2[index], this.max$2.elem)) {
                    this.max$2.elem = data2[index];
                }
            }
            {
                this.ev$91 = ev$91;
                this.max$2 = max$2;
                this.first$3 = first$3;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcD$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mDc$sp(self, func);
        return max2.elem;
    }

    public float maxAll$mFc$sp(DenseTensor<Object> self, TensorNumericMath.TensorNumeric<Object> ev) {
        FloatRef max2 = FloatRef.create((float)ev.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$));
        BooleanRef first = BooleanRef.create((boolean)true);
        TensorFunc2$mcF$sp func = new TensorFunc2$mcF$sp(ev, max2, first){
            private final TensorNumericMath.TensorNumeric ev$92;
            private final FloatRef max$3;
            private final BooleanRef first$4;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(float[] data2, int index) {
                this.apply$mcF$sp(data2, index);
            }

            public void apply$mcF$sp(float[] data2, int index) {
                if (this.first$4.elem) {
                    this.first$4.elem = false;
                    this.max$3.elem = data2[index];
                } else if (this.ev$92.isGreater$mcF$sp(data2[index], this.max$3.elem)) {
                    this.max$3.elem = data2[index];
                }
            }
            {
                this.ev$92 = ev$92;
                this.max$3 = max$3;
                this.first$4 = first$4;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcF$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mFc$sp(self, func);
        return max2.elem;
    }

    public double minAll$mDc$sp(DenseTensor<Object> self, TensorNumericMath.TensorNumeric<Object> ev) {
        DoubleRef min2 = DoubleRef.create((double)ev.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), ConvertableFrom$ConvertableFromInt$.MODULE$));
        BooleanRef first = BooleanRef.create((boolean)true);
        TensorFunc2$mcD$sp func = new TensorFunc2$mcD$sp(ev, min2, first){
            private final TensorNumericMath.TensorNumeric ev$93;
            private final DoubleRef min$2;
            private final BooleanRef first$5;

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(double[] data2, int index) {
                this.apply$mcD$sp(data2, index);
            }

            public void apply$mcD$sp(double[] data2, int index) {
                if (this.first$5.elem) {
                    this.first$5.elem = false;
                    this.min$2.elem = data2[index];
                } else if (this.ev$93.isGreater$mcD$sp(this.min$2.elem, data2[index])) {
                    this.min$2.elem = data2[index];
                }
            }
            {
                this.ev$93 = ev$93;
                this.min$2 = min$2;
                this.first$5 = first$5;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcD$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mDc$sp(self, func);
        return min2.elem;
    }

    public float minAll$mFc$sp(DenseTensor<Object> self, TensorNumericMath.TensorNumeric<Object> ev) {
        FloatRef min2 = FloatRef.create((float)ev.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), ConvertableFrom$ConvertableFromInt$.MODULE$));
        BooleanRef first = BooleanRef.create((boolean)true);
        TensorFunc2$mcF$sp func = new TensorFunc2$mcF$sp(ev, min2, first){
            private final TensorNumericMath.TensorNumeric ev$94;
            private final FloatRef min$3;
            private final BooleanRef first$6;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(float[] data2, int index) {
                this.apply$mcF$sp(data2, index);
            }

            public void apply$mcF$sp(float[] data2, int index) {
                if (this.first$6.elem) {
                    this.first$6.elem = false;
                    this.min$3.elem = data2[index];
                } else if (this.ev$94.isGreater$mcF$sp(this.min$3.elem, data2[index])) {
                    this.min$3.elem = data2[index];
                }
            }
            {
                this.ev$94 = ev$94;
                this.min$3 = min$3;
                this.first$6 = first$6;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcF$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mFc$sp(self, func);
        return min2.elem;
    }

    public Tensor<Object> addmm$mDc$sp(Tensor<Object> r, double beta, Tensor<Object> t2, double alpha, Tensor<Object> m1, Tensor<Object> m22, ClassTag<Object> evidence$18, TensorNumericMath.TensorNumeric<Object> ev) {
        Object object;
        Log4Error$.MODULE$.unKnowExceptionError(m1.dim() == 2 && m22.dim() == 2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"matrices expected, got ", ", ", " tensors"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)m1.dim()), BoxesRunTime.boxToInteger((int)m22.dim())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(m1.size(2) == m22.size(1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size mismatch, m1:", " m2:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(m1.size()).mkString("x"), Predef$.MODULE$.intArrayOps(m22.size()).mkString("x")})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(t2.dim() == 2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"matrix expected, got ", " tensor for t"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.dim())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(t2.size(1) == m1.size(1) && t2.size(2) == m22.size(2), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size mismatch. t:", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(t2.size()).mkString("x")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"m1:", " + m2:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(m1.size()).mkString("x"), Predef$.MODULE$.intArrayOps(m22.size()).mkString("x")}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        DenseTensor$mcD$sp denseTensor$mcD$sp = r;
        Tensor<Object> tensor = t2;
        if (!(denseTensor$mcD$sp != null ? !((Object)denseTensor$mcD$sp).equals(tensor) : tensor != null)) {
            object = BoxedUnit.UNIT;
        } else {
            r.resizeAs(t2);
            object = r.copy(t2);
        }
        Tensor<Object> _r = null;
        Tensor<Object> _m1 = m1;
        Tensor<Object> _m2 = m22;
        int transpose_r = 32;
        if (r.stride(1) == 1 && r.stride(2) != 0) {
            transpose_r = 110;
            _r = r;
        } else if (r.stride(2) == 1 && r.stride(1) != 0) {
            Tensor<Object> swap = _m2;
            _m2 = _m1;
            _m1 = swap;
            transpose_r = 116;
            _r = r;
        } else {
            transpose_r = 110;
            _r = new DenseTensor$mcD$sp(r.size(2), r.size(1), evidence$18, ev);
            _r.copy(r);
            _r = _r.transpose(1, 2);
        }
        int index1 = transpose_r == 110 ? 1 : 2;
        int index2 = transpose_r == 110 ? 2 : 1;
        char transpose_m1 = ' ';
        Tensor<Object> __m1 = null;
        if (_m1.stride(index1) == 1 && _m1.stride(index2) != 0) {
            transpose_m1 = 'n';
            __m1 = _m1;
        } else if (_m1.stride(index2) == 1 && _m1.stride(index1) != 0) {
            transpose_m1 = 't';
            __m1 = _m1;
        } else {
            transpose_m1 = transpose_r == 110 ? (char)'t' : 'n';
            __m1 = _m1.contiguous();
        }
        char transpose_m2 = ' ';
        Tensor<Object> __m2 = null;
        if (_m2.stride(index1) == 1 && _m2.stride(index2) != 0) {
            transpose_m2 = 'n';
            __m2 = _m2;
        } else if (_m2.stride(index2) == 1 && _m2.stride(index1) != 0) {
            transpose_m2 = 't';
            __m2 = _m2;
        } else {
            transpose_m2 = transpose_r == 110 ? (char)'t' : 'n';
            __m2 = _m2.contiguous();
        }
        DenseTensorBLAS$.MODULE$.gemm$mDc$sp(transpose_m1, transpose_m2, _r.size(index1), _r.size(index2), __m1.size(index2), alpha, (double[])__m1.storage().array(), __m1.storageOffset() - 1, transpose_m1 == 'n' ? __m1.stride(index2) : __m1.stride(index1), (double[])__m2.storage().array(), __m2.storageOffset() - 1, transpose_m2 == 'n' ? __m2.stride(index2) : __m2.stride(index1), beta, (double[])_r.storage().array(), _r.storageOffset() - 1, _r.stride(index2), ev);
        Tensor<Object> tensor2 = _r;
        DenseTensor$mcD$sp denseTensor$mcD$sp2 = r;
        Object object2 = !(tensor2 != null ? !tensor2.equals(denseTensor$mcD$sp2) : denseTensor$mcD$sp2 != null) ? BoxedUnit.UNIT : r.copy(_r);
        return r;
    }

    public Tensor<Object> addmm$mFc$sp(Tensor<Object> r, float beta, Tensor<Object> t2, float alpha, Tensor<Object> m1, Tensor<Object> m22, ClassTag<Object> evidence$18, TensorNumericMath.TensorNumeric<Object> ev) {
        Object object;
        Log4Error$.MODULE$.unKnowExceptionError(m1.dim() == 2 && m22.dim() == 2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"matrices expected, got ", ", ", " tensors"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)m1.dim()), BoxesRunTime.boxToInteger((int)m22.dim())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(m1.size(2) == m22.size(1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size mismatch, m1:", " m2:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(m1.size()).mkString("x"), Predef$.MODULE$.intArrayOps(m22.size()).mkString("x")})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(t2.dim() == 2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"matrix expected, got ", " tensor for t"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.dim())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(t2.size(1) == m1.size(1) && t2.size(2) == m22.size(2), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size mismatch. t:", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(t2.size()).mkString("x")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"m1:", " + m2:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(m1.size()).mkString("x"), Predef$.MODULE$.intArrayOps(m22.size()).mkString("x")}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        DenseTensor$mcF$sp denseTensor$mcF$sp = r;
        Tensor<Object> tensor = t2;
        if (!(denseTensor$mcF$sp != null ? !((Object)denseTensor$mcF$sp).equals(tensor) : tensor != null)) {
            object = BoxedUnit.UNIT;
        } else {
            r.resizeAs(t2);
            object = r.copy(t2);
        }
        Tensor<Object> _r = null;
        Tensor<Object> _m1 = m1;
        Tensor<Object> _m2 = m22;
        int transpose_r = 32;
        if (r.stride(1) == 1 && r.stride(2) != 0) {
            transpose_r = 110;
            _r = r;
        } else if (r.stride(2) == 1 && r.stride(1) != 0) {
            Tensor<Object> swap = _m2;
            _m2 = _m1;
            _m1 = swap;
            transpose_r = 116;
            _r = r;
        } else {
            transpose_r = 110;
            _r = new DenseTensor$mcF$sp(r.size(2), r.size(1), evidence$18, ev);
            _r.copy(r);
            _r = _r.transpose(1, 2);
        }
        int index1 = transpose_r == 110 ? 1 : 2;
        int index2 = transpose_r == 110 ? 2 : 1;
        char transpose_m1 = ' ';
        Tensor<Object> __m1 = null;
        if (_m1.stride(index1) == 1 && _m1.stride(index2) != 0) {
            transpose_m1 = 'n';
            __m1 = _m1;
        } else if (_m1.stride(index2) == 1 && _m1.stride(index1) != 0) {
            transpose_m1 = 't';
            __m1 = _m1;
        } else {
            transpose_m1 = transpose_r == 110 ? (char)'t' : 'n';
            __m1 = _m1.contiguous();
        }
        char transpose_m2 = ' ';
        Tensor<Object> __m2 = null;
        if (_m2.stride(index1) == 1 && _m2.stride(index2) != 0) {
            transpose_m2 = 'n';
            __m2 = _m2;
        } else if (_m2.stride(index2) == 1 && _m2.stride(index1) != 0) {
            transpose_m2 = 't';
            __m2 = _m2;
        } else {
            transpose_m2 = transpose_r == 110 ? (char)'t' : 'n';
            __m2 = _m2.contiguous();
        }
        DenseTensorBLAS$.MODULE$.gemm$mFc$sp(transpose_m1, transpose_m2, _r.size(index1), _r.size(index2), __m1.size(index2), alpha, (float[])__m1.storage().array(), __m1.storageOffset() - 1, transpose_m1 == 'n' ? __m1.stride(index2) : __m1.stride(index1), (float[])__m2.storage().array(), __m2.storageOffset() - 1, transpose_m2 == 'n' ? __m2.stride(index2) : __m2.stride(index1), beta, (float[])_r.storage().array(), _r.storageOffset() - 1, _r.stride(index2), ev);
        Tensor<Object> tensor2 = _r;
        DenseTensor$mcF$sp denseTensor$mcF$sp2 = r;
        Object object2 = !(tensor2 != null ? !tensor2.equals(denseTensor$mcF$sp2) : denseTensor$mcF$sp2 != null) ? BoxedUnit.UNIT : r.copy(_r);
        return r;
    }

    public Tensor<Object> addr$mDc$sp(Tensor<Object> r, double beta, Tensor<Object> t2, double alpha, Tensor<Object> vec1, Tensor<Object> vec2, TensorNumericMath.TensorNumeric<Object> ev) {
        Object object;
        Log4Error$.MODULE$.unKnowExceptionError(vec1.dim() == 1 && vec2.dim() == 1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"vec1.dim() ", " should be 1, vec2.dim() ", " should be 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)vec1.dim()), BoxesRunTime.boxToInteger((int)vec2.dim())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(t2.dim() == 2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t.dim() ", " should be 2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.dim())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(t2.size(1) == vec1.size(1) && t2.size(2) == vec2.size(1), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t.size(1) ", " should match vec1.size(1) ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.size(1)), BoxesRunTime.boxToInteger((int)vec1.size(1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" t.size(2) ", " should match vec2.size(1) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.size(2)), BoxesRunTime.boxToInteger((int)vec2.size(1))}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Object object2 = r == t2 ? BoxedUnit.UNIT : r.resizeAs(t2).copy(t2);
        Object object3 = beta != 1.0 ? r.mul(BoxesRunTime.boxToDouble((double)beta)) : BoxedUnit.UNIT;
        if (r.stride(1) == 1) {
            int lda = t2.stride(2) == 1 ? r.size(1) : r.stride(2);
            ev.ger$mcD$sp(vec1.size(1), vec2.size(1), alpha, (double[])vec1.storage().array(), vec1.storageOffset() - 1, vec1.stride(1), (double[])vec2.storage().array(), vec2.storageOffset() - 1, vec2.stride(1), (double[])r.storage().array(), r.storageOffset() - 1, lda);
            object = BoxedUnit.UNIT;
        } else if (r.stride(2) == 1) {
            ev.ger$mcD$sp(vec2.size(1), vec1.size(1), alpha, (double[])vec2.storage().array(), vec2.storageOffset() - 1, vec2.stride(1), (double[])vec1.storage().array(), vec1.storageOffset() - 1, vec1.stride(1), (double[])r.storage().array(), r.storageOffset() - 1, r.stride(1));
            object = BoxedUnit.UNIT;
        } else {
            Tensor<Object> cr = r.contiguous();
            ev.ger$mcD$sp(vec2.size(1), vec1.size(1), alpha, (double[])vec2.storage().array(), vec2.storageOffset() - 1, vec2.stride(1), (double[])vec1.storage().array(), vec1.storageOffset() - 1, vec1.stride(1), (double[])cr.storage().array(), cr.storageOffset() - 1, cr.stride(1));
            object = r.copy(cr);
        }
        return r;
    }

    public Tensor<Object> addr$mFc$sp(Tensor<Object> r, float beta, Tensor<Object> t2, float alpha, Tensor<Object> vec1, Tensor<Object> vec2, TensorNumericMath.TensorNumeric<Object> ev) {
        Object object;
        Log4Error$.MODULE$.unKnowExceptionError(vec1.dim() == 1 && vec2.dim() == 1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"vec1.dim() ", " should be 1, vec2.dim() ", " should be 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)vec1.dim()), BoxesRunTime.boxToInteger((int)vec2.dim())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(t2.dim() == 2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t.dim() ", " should be 2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.dim())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(t2.size(1) == vec1.size(1) && t2.size(2) == vec2.size(1), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t.size(1) ", " should match vec1.size(1) ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.size(1)), BoxesRunTime.boxToInteger((int)vec1.size(1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" t.size(2) ", " should match vec2.size(1) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.size(2)), BoxesRunTime.boxToInteger((int)vec2.size(1))}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Object object2 = r == t2 ? BoxedUnit.UNIT : r.resizeAs(t2).copy(t2);
        Object object3 = beta != 1.0f ? r.mul(BoxesRunTime.boxToFloat((float)beta)) : BoxedUnit.UNIT;
        if (r.stride(1) == 1) {
            int lda = t2.stride(2) == 1 ? r.size(1) : r.stride(2);
            ev.ger$mcF$sp(vec1.size(1), vec2.size(1), alpha, (float[])vec1.storage().array(), vec1.storageOffset() - 1, vec1.stride(1), (float[])vec2.storage().array(), vec2.storageOffset() - 1, vec2.stride(1), (float[])r.storage().array(), r.storageOffset() - 1, lda);
            object = BoxedUnit.UNIT;
        } else if (r.stride(2) == 1) {
            ev.ger$mcF$sp(vec2.size(1), vec1.size(1), alpha, (float[])vec2.storage().array(), vec2.storageOffset() - 1, vec2.stride(1), (float[])vec1.storage().array(), vec1.storageOffset() - 1, vec1.stride(1), (float[])r.storage().array(), r.storageOffset() - 1, r.stride(1));
            object = BoxedUnit.UNIT;
        } else {
            Tensor<Object> cr = r.contiguous();
            ev.ger$mcF$sp(vec2.size(1), vec1.size(1), alpha, (float[])vec2.storage().array(), vec2.storageOffset() - 1, vec2.stride(1), (float[])vec1.storage().array(), vec1.storageOffset() - 1, vec1.stride(1), (float[])cr.storage().array(), cr.storageOffset() - 1, cr.stride(1));
            object = r.copy(cr);
        }
        return r;
    }

    public Tensor<Object> baddbmm$mDc$sp(Tensor<Object> result2, double beta, Tensor<Object> M, double alpha, Tensor<Object> batch1, Tensor<Object> batch2, ClassTag<Object> evidence$19, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(batch1.dim() == 3, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected 3D tensor, got ", "D"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batch1.dim())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(batch2.dim() == 3, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected 3D tensor, got ", "D"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batch2.dim())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(batch1.size(1) == batch2.size(1), new StringBuilder().append((Object)"equal number of batches expected, got ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batch1.size(1)), BoxesRunTime.boxToInteger((int)batch2.size(1))}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(batch1.size(3) == batch2.size(2), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"wrong matrix size, batch1: "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ", batch2: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batch1.size(2)), BoxesRunTime.boxToInteger((int)batch1.size(3))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batch2.size(2)), BoxesRunTime.boxToInteger((int)batch2.size(3))}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        int bs = batch1.size(1);
        int dim1 = batch1.size(2);
        int dim2 = batch2.size(3);
        Log4Error$.MODULE$.unKnowExceptionError(M.size(1) == bs, "output tensor of incorrect size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(M.size(2) == dim1, "output tensor of incorrect size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(M.size(3) == dim2, "output tensor of incorrect size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Tensor<Object> tensor = M;
        Tensor<Object> tensor2 = result2;
        Object object = !(tensor != null ? !tensor.equals(tensor2) : tensor2 != null) ? BoxedUnit.UNIT : result2.resizeAs(M).copy(M);
        for (int batch = 1; batch <= batch1.size(1); ++batch) {
            Tensor<Object> m1 = batch1.select(1, batch);
            Tensor<Object> m22 = batch2.select(1, batch);
            Tensor<Object> resultMatrix = result2.select(1, batch);
            this.addmm$mDc$sp(resultMatrix, beta, resultMatrix, alpha, m1, m22, evidence$19, ev);
        }
        return result2;
    }

    public Tensor<Object> baddbmm$mFc$sp(Tensor<Object> result2, float beta, Tensor<Object> M, float alpha, Tensor<Object> batch1, Tensor<Object> batch2, ClassTag<Object> evidence$19, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(batch1.dim() == 3, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected 3D tensor, got ", "D"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batch1.dim())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(batch2.dim() == 3, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected 3D tensor, got ", "D"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batch2.dim())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(batch1.size(1) == batch2.size(1), new StringBuilder().append((Object)"equal number of batches expected, got ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batch1.size(1)), BoxesRunTime.boxToInteger((int)batch2.size(1))}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(batch1.size(3) == batch2.size(2), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"wrong matrix size, batch1: "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ", batch2: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batch1.size(2)), BoxesRunTime.boxToInteger((int)batch1.size(3))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batch2.size(2)), BoxesRunTime.boxToInteger((int)batch2.size(3))}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        int bs = batch1.size(1);
        int dim1 = batch1.size(2);
        int dim2 = batch2.size(3);
        Log4Error$.MODULE$.unKnowExceptionError(M.size(1) == bs, "output tensor of incorrect size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(M.size(2) == dim1, "output tensor of incorrect size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(M.size(3) == dim2, "output tensor of incorrect size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Tensor<Object> tensor = M;
        Tensor<Object> tensor2 = result2;
        Object object = !(tensor != null ? !tensor.equals(tensor2) : tensor2 != null) ? BoxedUnit.UNIT : result2.resizeAs(M).copy(M);
        for (int batch = 1; batch <= batch1.size(1); ++batch) {
            Tensor<Object> m1 = batch1.select(1, batch);
            Tensor<Object> m22 = batch2.select(1, batch);
            Tensor<Object> resultMatrix = result2.select(1, batch);
            this.addmm$mFc$sp(resultMatrix, beta, resultMatrix, alpha, m1, m22, evidence$19, ev);
        }
        return result2;
    }

    public Tensor<Object> addmv$mDc$sp(Tensor<Object> r, double beta, Tensor<Object> t2, double alpha, Tensor<Object> mat, Tensor<Object> vec, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(mat.nDimension() == 2 && vec.nDimension() == 1, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mat.nDimension() ", " should be 2,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)mat.nDimension())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" vec.nDimension() ", " should be 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)vec.nDimension())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(mat.size(2) == vec.size(1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mat.size(2) ", " should match vec.size(1) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)mat.size(2)), BoxesRunTime.boxToInteger((int)vec.size(1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(t2.nDimension() == 1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t.nDimension() ", " should be 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.nDimension())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(t2.size(1) == mat.size(1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t.size(1) ", " should match mat.size(1) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.size(1)), BoxesRunTime.boxToInteger((int)mat.size(1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Object object = r == t2 ? BoxedUnit.UNIT : r.resizeAs(t2).copy(t2);
        if (mat.stride(1) == 1) {
            int lda = mat.size(2) == 1 ? mat.size(1) : mat.stride(2);
            ev.gemv$mcD$sp('N', mat.size(1), mat.size(2), alpha, (double[])mat.storage().array(), mat.storageOffset() - 1, lda, (double[])vec.storage().array(), vec.storageOffset() - 1, vec.stride(1), beta, (double[])r.storage().array(), r.storageOffset() - 1, r.stride(1));
        } else if (mat.stride(2) == 1) {
            ev.gemv$mcD$sp('T', mat.size(2), mat.size(1), alpha, (double[])mat.storage().array(), mat.storageOffset() - 1, mat.stride(1), (double[])vec.storage().array(), vec.storageOffset() - 1, vec.stride(1), beta, (double[])r.storage().array(), r.storageOffset() - 1, r.stride(1));
        } else {
            Tensor<Object> cmat = mat.contiguous();
            ev.gemv$mcD$sp('T', cmat.size(2), cmat.size(1), alpha, (double[])cmat.storage().array(), cmat.storageOffset() - 1, cmat.stride(1), (double[])vec.storage().array(), vec.storageOffset() - 1, vec.stride(1), beta, (double[])r.storage().array(), r.storageOffset() - 1, r.stride(1));
        }
        return r;
    }

    public Tensor<Object> addmv$mFc$sp(Tensor<Object> r, float beta, Tensor<Object> t2, float alpha, Tensor<Object> mat, Tensor<Object> vec, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(mat.nDimension() == 2 && vec.nDimension() == 1, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mat.nDimension() ", " should be 2,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)mat.nDimension())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" vec.nDimension() ", " should be 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)vec.nDimension())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(mat.size(2) == vec.size(1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mat.size(2) ", " should match vec.size(1) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)mat.size(2)), BoxesRunTime.boxToInteger((int)vec.size(1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(t2.nDimension() == 1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t.nDimension() ", " should be 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.nDimension())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(t2.size(1) == mat.size(1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t.size(1) ", " should match mat.size(1) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t2.size(1)), BoxesRunTime.boxToInteger((int)mat.size(1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Object object = r == t2 ? BoxedUnit.UNIT : r.resizeAs(t2).copy(t2);
        if (mat.stride(1) == 1) {
            int lda = mat.size(2) == 1 ? mat.size(1) : mat.stride(2);
            ev.gemv$mcF$sp('N', mat.size(1), mat.size(2), alpha, (float[])mat.storage().array(), mat.storageOffset() - 1, lda, (float[])vec.storage().array(), vec.storageOffset() - 1, vec.stride(1), beta, (float[])r.storage().array(), r.storageOffset() - 1, r.stride(1));
        } else if (mat.stride(2) == 1) {
            ev.gemv$mcF$sp('T', mat.size(2), mat.size(1), alpha, (float[])mat.storage().array(), mat.storageOffset() - 1, mat.stride(1), (float[])vec.storage().array(), vec.storageOffset() - 1, vec.stride(1), beta, (float[])r.storage().array(), r.storageOffset() - 1, r.stride(1));
        } else {
            Tensor<Object> cmat = mat.contiguous();
            ev.gemv$mcF$sp('T', cmat.size(2), cmat.size(1), alpha, (float[])cmat.storage().array(), cmat.storageOffset() - 1, cmat.stride(1), (float[])vec.storage().array(), vec.storageOffset() - 1, vec.stride(1), beta, (float[])r.storage().array(), r.storageOffset() - 1, r.stride(1));
        }
        return r;
    }

    public double meanAll$mDc$sp(DenseTensor<Object> self, TensorNumericMath.TensorNumeric<Object> ev) {
        DoubleRef sum2 = DoubleRef.create((double)ev.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$));
        TensorFunc2$mcD$sp func = new TensorFunc2$mcD$sp(ev, sum2){
            private final TensorNumericMath.TensorNumeric ev$95;
            private final DoubleRef sum$5;

            public void apply$mcF$sp(float[] v1, int v2) {
                TensorFunc2$class.apply$mcF$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(double[] data2, int index) {
                this.apply$mcD$sp(data2, index);
            }

            public void apply$mcD$sp(double[] data2, int index) {
                this.sum$5.elem = this.ev$95.plus$mcD$sp(data2[index], this.sum$5.elem);
            }
            {
                this.ev$95 = ev$95;
                this.sum$5 = sum$5;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcD$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mDc$sp(self, func);
        return ev.divide$mcD$sp(sum2.elem, ev.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)self.nElement()), ConvertableFrom$ConvertableFromInt$.MODULE$));
    }

    public float meanAll$mFc$sp(DenseTensor<Object> self, TensorNumericMath.TensorNumeric<Object> ev) {
        FloatRef sum2 = FloatRef.create((float)ev.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$));
        TensorFunc2$mcF$sp func = new TensorFunc2$mcF$sp(ev, sum2){
            private final TensorNumericMath.TensorNumeric ev$96;
            private final FloatRef sum$6;

            public void apply$mcD$sp(double[] v1, int v2) {
                TensorFunc2$class.apply$mcD$sp(this, v1, v2);
            }

            public String toString() {
                return TensorFunc2$class.toString(this);
            }

            public void apply(float[] data2, int index) {
                this.apply$mcF$sp(data2, index);
            }

            public void apply$mcF$sp(float[] data2, int index) {
                this.sum$6.elem = this.ev$96.plus$mcF$sp(data2[index], this.sum$6.elem);
            }
            {
                this.ev$96 = ev$96;
                this.sum$6 = sum$6;
                TensorFunc2$class.$init$(this);
                TensorFunc2$mcF$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply1$mFc$sp(self, func);
        return ev.divide$mcF$sp(sum2.elem, ev.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)self.nElement()), ConvertableFrom$ConvertableFromInt$.MODULE$));
    }

    public Tensor<Object> mean$mDc$sp(DenseTensor<Object> self, int _dim, ClassTag<Object> evidence$20, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < self.nDimension(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension ", " out of range"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(_dim + 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        DenseTensor$mcD$sp result2 = new DenseTensor$mcD$sp(evidence$20, ev);
        int[] sizes = self.size();
        sizes[_dim] = 1;
        DenseTensor$.MODULE$.resize$mDc$sp(result2, sizes, DenseTensor$.MODULE$.resize$default$3(), evidence$20);
        DenseTensorDimApply$.MODULE$.dimApply2$mDc$sp(result2, self, _dim, (Function8<double[], Object, Object, Object, double[], Object, Object, Object, BoxedUnit>)new Serializable(self, _dim, ev){
            private final DenseTensor self$2;
            private final int _dim$2;
            private final TensorNumericMath.TensorNumeric ev$97;

            public final void apply(double[] rData, int rOffset, int rStride, int rSize, double[] tData, int tOffset, int tStride, int tSize) {
                double sum2 = this.ev$97.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$);
                for (int i = 0; i < tSize; ++i) {
                    sum2 = this.ev$97.plus$mcD$sp(sum2, tData[tOffset + i * tStride]);
                }
                rData[rOffset] = this.ev$97.divide$mcD$sp(sum2, this.ev$97.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)this.self$2.size(this._dim$2 + 1)), ConvertableFrom$ConvertableFromInt$.MODULE$));
            }
            {
                this.self$2 = self$2;
                this._dim$2 = _dim$2;
                this.ev$97 = ev$97;
            }
        });
        return result2;
    }

    public Tensor<Object> mean$mFc$sp(DenseTensor<Object> self, int _dim, ClassTag<Object> evidence$20, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < self.nDimension(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension ", " out of range"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(_dim + 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        DenseTensor$mcF$sp result2 = new DenseTensor$mcF$sp(evidence$20, ev);
        int[] sizes = self.size();
        sizes[_dim] = 1;
        DenseTensor$.MODULE$.resize$mFc$sp(result2, sizes, DenseTensor$.MODULE$.resize$default$3(), evidence$20);
        DenseTensorDimApply$.MODULE$.dimApply2$mFc$sp(result2, self, _dim, (Function8<float[], Object, Object, Object, float[], Object, Object, Object, BoxedUnit>)new Serializable(self, _dim, ev){
            private final DenseTensor self$3;
            private final int _dim$3;
            private final TensorNumericMath.TensorNumeric ev$98;

            public final void apply(float[] rData, int rOffset, int rStride, int rSize, float[] tData, int tOffset, int tStride, int tSize) {
                float sum2 = this.ev$98.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$);
                for (int i = 0; i < tSize; ++i) {
                    sum2 = this.ev$98.plus$mcF$sp(sum2, tData[tOffset + i * tStride]);
                }
                rData[rOffset] = this.ev$98.divide$mcF$sp(sum2, this.ev$98.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)this.self$3.size(this._dim$3 + 1)), ConvertableFrom$ConvertableFromInt$.MODULE$));
            }
            {
                this.self$3 = self$3;
                this._dim$3 = _dim$3;
                this.ev$98 = ev$98;
            }
        });
        return result2;
    }

    public Tensor<Object> norm$mDc$sp(DenseTensor<Object> self, Tensor<Object> result2, int value2, int _dim, ClassTag<Object> evidence$21, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < self.nDimension(), "invalid dimension", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        int[] sizes = self.size();
        sizes[_dim] = 1;
        result2.resize(sizes, result2.resize$default$2());
        if (value2 == 0) {
            DenseTensorDimApply$.MODULE$.dimApply2$mDc$sp(self, result2, _dim, (Function8<double[], Object, Object, Object, double[], Object, Object, Object, BoxedUnit>)new Serializable(ev){
                private final TensorNumericMath.TensorNumeric ev$99;

                public final void apply(double[] rData, int rOffset, int rStride, int rSize, double[] tData, int tOffset, int tStride, int tSize) {
                    double sum2 = this.ev$99.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$);
                    for (int i = 0; i < rSize; ++i) {
                        sum2 = this.ev$99.plus$mcD$sp(sum2, rData[rOffset + i * rStride]);
                    }
                    tData[tOffset] = sum2;
                }
                {
                    this.ev$99 = ev$99;
                }
            });
        } else {
            DenseTensorDimApply$.MODULE$.dimApply2$mDc$sp(self, result2, _dim, (Function8<double[], Object, Object, Object, double[], Object, Object, Object, BoxedUnit>)new Serializable(value2, ev){
                private final int value$11;
                private final TensorNumericMath.TensorNumeric ev$99;

                public final void apply(double[] rData, int rOffset, int rStride, int rSize, double[] tData, int tOffset, int tStride, int tSize) {
                    double sum2 = this.ev$99.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$);
                    for (int i = 0; i < rSize; ++i) {
                        sum2 = this.ev$99.plus$mcD$sp(sum2, this.ev$99.pow$mcD$sp(this.ev$99.abs$mcD$sp(rData[rOffset + i * rStride]), this.ev$99.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)this.value$11), ConvertableFrom$ConvertableFromInt$.MODULE$)));
                    }
                    tData[tOffset] = this.ev$99.pow$mcD$sp(sum2, this.ev$99.fromType$mcD$sp(BoxesRunTime.boxToDouble((double)(1.0 / (double)this.value$11)), ConvertableFrom$ConvertableFromDouble$.MODULE$));
                }
                {
                    this.value$11 = value$11;
                    this.ev$99 = ev$99;
                }
            });
        }
        return result2;
    }

    public Tensor<Object> norm$mFc$sp(DenseTensor<Object> self, Tensor<Object> result2, int value2, int _dim, ClassTag<Object> evidence$21, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < self.nDimension(), "invalid dimension", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        int[] sizes = self.size();
        sizes[_dim] = 1;
        result2.resize(sizes, result2.resize$default$2());
        if (value2 == 0) {
            DenseTensorDimApply$.MODULE$.dimApply2$mFc$sp(self, result2, _dim, (Function8<float[], Object, Object, Object, float[], Object, Object, Object, BoxedUnit>)new Serializable(ev){
                private final TensorNumericMath.TensorNumeric ev$100;

                public final void apply(float[] rData, int rOffset, int rStride, int rSize, float[] tData, int tOffset, int tStride, int tSize) {
                    float sum2 = this.ev$100.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$);
                    for (int i = 0; i < rSize; ++i) {
                        sum2 = this.ev$100.plus$mcF$sp(sum2, rData[rOffset + i * rStride]);
                    }
                    tData[tOffset] = sum2;
                }
                {
                    this.ev$100 = ev$100;
                }
            });
        } else {
            DenseTensorDimApply$.MODULE$.dimApply2$mFc$sp(self, result2, _dim, (Function8<float[], Object, Object, Object, float[], Object, Object, Object, BoxedUnit>)new Serializable(value2, ev){
                private final int value$12;
                private final TensorNumericMath.TensorNumeric ev$100;

                public final void apply(float[] rData, int rOffset, int rStride, int rSize, float[] tData, int tOffset, int tStride, int tSize) {
                    float sum2 = this.ev$100.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$);
                    for (int i = 0; i < rSize; ++i) {
                        sum2 = this.ev$100.plus$mcF$sp(sum2, this.ev$100.pow$mcF$sp(this.ev$100.abs$mcF$sp(rData[rOffset + i * rStride]), this.ev$100.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)this.value$12), ConvertableFrom$ConvertableFromInt$.MODULE$)));
                    }
                    tData[tOffset] = this.ev$100.pow$mcF$sp(sum2, this.ev$100.fromType$mcF$sp(BoxesRunTime.boxToDouble((double)(1.0 / (double)this.value$12)), ConvertableFrom$ConvertableFromDouble$.MODULE$));
                }
                {
                    this.value$12 = value$12;
                    this.ev$100 = ev$100;
                }
            });
        }
        return result2;
    }

    public boolean nearlyEqual$mDc$sp(double a, double b, double epsilon, TensorNumericMath.TensorNumeric<Object> ev) {
        return ev.nearlyEqual$mcD$sp(a, b, epsilon);
    }

    public boolean nearlyEqual$mFc$sp(float a, float b, double epsilon, TensorNumericMath.TensorNumeric<Object> ev) {
        return ev.nearlyEqual$mcF$sp(a, b, epsilon);
    }

    public Tensor<Object> cmax$mDc$sp(DenseTensor<Object> self, Tensor<Object> x, Tensor<Object> y, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement() && self.nElement() == x.nElement(), "element number doesn't match", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        TensorFunc6$mcD$sp func = new TensorFunc6$mcD$sp(ev){
            private final TensorNumericMath.TensorNumeric ev$101;

            public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4, float[] v5, int v6) {
                TensorFunc6$class.apply$mcF$sp(this, v1, v2, v3, v4, v5, v6);
            }

            public String toString() {
                return TensorFunc6$class.toString(this);
            }

            public void apply(double[] data1, int offset1, double[] data2, int offset2, double[] data3, int offset3) {
                this.apply$mcD$sp(data1, offset1, data2, offset2, data3, offset3);
            }

            public void apply$mcD$sp(double[] data1, int offset1, double[] data2, int offset2, double[] data3, int offset3) {
                data1[offset1] = this.ev$101.max$mcD$sp(data2[offset2], data3[offset3]);
            }
            {
                this.ev$101 = ev$101;
                TensorFunc6$class.$init$(this);
                TensorFunc6$mcD$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply3$mDc$sp(self, x, y, func);
        return self;
    }

    public Tensor<Object> cmax$mFc$sp(DenseTensor<Object> self, Tensor<Object> x, Tensor<Object> y, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement() && self.nElement() == x.nElement(), "element number doesn't match", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        TensorFunc6$mcF$sp func = new TensorFunc6$mcF$sp(ev){
            private final TensorNumericMath.TensorNumeric ev$102;

            public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4, double[] v5, int v6) {
                TensorFunc6$class.apply$mcD$sp(this, v1, v2, v3, v4, v5, v6);
            }

            public String toString() {
                return TensorFunc6$class.toString(this);
            }

            public void apply(float[] data1, int offset1, float[] data2, int offset2, float[] data3, int offset3) {
                this.apply$mcF$sp(data1, offset1, data2, offset2, data3, offset3);
            }

            public void apply$mcF$sp(float[] data1, int offset1, float[] data2, int offset2, float[] data3, int offset3) {
                data1[offset1] = this.ev$102.max$mcF$sp(data2[offset2], data3[offset3]);
            }
            {
                this.ev$102 = ev$102;
                TensorFunc6$class.$init$(this);
                TensorFunc6$mcF$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply3$mFc$sp(self, x, y, func);
        return self;
    }

    public Tensor<Object> cmin$mDc$sp(DenseTensor<Object> self, Tensor<Object> x, Tensor<Object> y, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement() && self.nElement() == x.nElement(), "element number doesn't match", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        TensorFunc6$mcD$sp func = new TensorFunc6$mcD$sp(ev){
            private final TensorNumericMath.TensorNumeric ev$103;

            public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4, float[] v5, int v6) {
                TensorFunc6$class.apply$mcF$sp(this, v1, v2, v3, v4, v5, v6);
            }

            public String toString() {
                return TensorFunc6$class.toString(this);
            }

            public void apply(double[] data1, int offset1, double[] data2, int offset2, double[] data3, int offset3) {
                this.apply$mcD$sp(data1, offset1, data2, offset2, data3, offset3);
            }

            public void apply$mcD$sp(double[] data1, int offset1, double[] data2, int offset2, double[] data3, int offset3) {
                data1[offset1] = this.ev$103.min$mcD$sp(data2[offset2], data3[offset3]);
            }
            {
                this.ev$103 = ev$103;
                TensorFunc6$class.$init$(this);
                TensorFunc6$mcD$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply3$mDc$sp(self, x, y, func);
        return self;
    }

    public Tensor<Object> cmin$mFc$sp(DenseTensor<Object> self, Tensor<Object> x, Tensor<Object> y, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == y.nElement() && self.nElement() == x.nElement(), "element number doesn't match", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        TensorFunc6$mcF$sp func = new TensorFunc6$mcF$sp(ev){
            private final TensorNumericMath.TensorNumeric ev$104;

            public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4, double[] v5, int v6) {
                TensorFunc6$class.apply$mcD$sp(this, v1, v2, v3, v4, v5, v6);
            }

            public String toString() {
                return TensorFunc6$class.toString(this);
            }

            public void apply(float[] data1, int offset1, float[] data2, int offset2, float[] data3, int offset3) {
                this.apply$mcF$sp(data1, offset1, data2, offset2, data3, offset3);
            }

            public void apply$mcF$sp(float[] data1, int offset1, float[] data2, int offset2, float[] data3, int offset3) {
                data1[offset1] = this.ev$104.min$mcF$sp(data2[offset2], data3[offset3]);
            }
            {
                this.ev$104 = ev$104;
                TensorFunc6$class.$init$(this);
                TensorFunc6$mcF$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply3$mFc$sp(self, x, y, func);
        return self;
    }

    private DenseTensorMath$() {
        MODULE$ = this;
        this.taskSize = new StringOps(Predef$.MODULE$.augmentString(System.getProperty("cpu.task.size", "250000"))).toInt();
        this.doubleEpsilon = new StringOps(Predef$.MODULE$.augmentString(System.getProperty("DoubleTensorEpsilon", "0.0000001"))).toDouble();
        this.floatEpsilon = new StringOps(Predef$.MODULE$.augmentString(System.getProperty("FloatTensorEpsilon", "0.00001"))).toDouble();
    }
}

