/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.tensor;

import com.intel.analytics.bigdl.dllib.tensor.ConvertableFrom$ConvertableFromInt$;
import com.intel.analytics.bigdl.dllib.tensor.Storage;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;

public final class DenseTensorConv$ {
    public static final DenseTensorConv$ MODULE$;

    static {
        new DenseTensorConv$();
    }

    public <T> void fullXCorr2Dptr(Storage<T> output, int _outputOffset, T alpha, Storage<T> input, int _inputOffset, int nInputRows, int nInputCols, Storage<T> kernel, int _kernelOffset, int nKernelRows, int nKernelCols, int srow, int scol, TensorNumericMath.TensorNumeric<T> ev) {
        int nOuputCol = (nInputCols - 1) * scol + nKernelCols;
        int inputOffset = _inputOffset;
        for (int yy = 0; yy < nInputRows; ++yy) {
            for (int xx = 0; xx < nInputCols; ++xx) {
                int outputOffset = yy * srow * nOuputCol + xx * scol + _outputOffset;
                int kernelOffset = nKernelCols * nKernelRows - 1 + _kernelOffset;
                for (int ky = 0; ky < nKernelRows; ++ky) {
                    T z = input.apply(inputOffset);
                    for (int kx = 0; kx < nKernelCols; ++kx) {
                        output.update(outputOffset + kx, ev.plus(output.apply(outputOffset + kx), ev.times(z, kernel.apply(kernelOffset - kx))));
                    }
                    outputOffset += nOuputCol;
                    kernelOffset -= nKernelCols;
                }
                ++inputOffset;
            }
        }
    }

    public <T> void fullConv2Dptr(Storage<T> output, int _outputOffset, T alpha, Storage<T> input, int _inputOffset, int nInputRows, int nInputCols, Storage<T> kernel, int _kernelOffset, int nKernelRows, int nKernelCols, int srow, int scol, TensorNumericMath.TensorNumeric<T> ev) {
        int nOutputCol = (nInputCols - 1) * scol + nKernelCols;
        int inputOffset = _inputOffset;
        for (int yy = 0; yy < nInputRows; ++yy) {
            for (int xx = 0; xx < nInputCols; ++xx) {
                int outputOffset = yy * srow * nOutputCol + xx * scol + _outputOffset;
                int kernelOffset = _kernelOffset;
                for (int ky = 0; ky < nKernelRows; ++ky) {
                    T z = ev.times(input.apply(inputOffset), alpha);
                    for (int kx = 0; kx < nKernelCols; ++kx) {
                        output.update(outputOffset + kx, ev.plus(output.apply(outputOffset + kx), ev.times(z, kernel.apply(kernelOffset + kx))));
                    }
                    outputOffset += nOutputCol;
                    kernelOffset += nKernelCols;
                }
                ++inputOffset;
            }
        }
    }

    public <T> void validConv2Dptr(Storage<T> output, int _outputOffset, T alpha, Storage<T> input, int _inputOffset, int nInputRows, int nInputCols, Storage<T> kernel, int _kernelOffset, int nKernelRows, int nKernelCols, int srow, int scol, TensorNumericMath.TensorNumeric<T> ev) {
        int nOutputCol = (nInputCols - nKernelCols) / srow + 1;
        int nOutputRow = (nInputRows - nKernelRows) / scol + 1;
        int outputOffset = _outputOffset;
        for (int yy = 0; yy < nOutputRow; ++yy) {
            for (int xx = 0; xx < nOutputCol; ++xx) {
                int inputOffset = yy * srow * nInputCols + xx * scol + _inputOffset;
                int kernelOffset = nKernelRows * nKernelCols - 1 + _kernelOffset;
                T sum2 = ev.fromType(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$);
                for (int ky = 0; ky < nKernelRows; ++ky) {
                    for (int kx = 0; kx < nKernelCols; ++kx) {
                        sum2 = ev.plus(sum2, ev.times(input.apply(inputOffset + kx), kernel.apply(kernelOffset - kx)));
                    }
                    inputOffset += nInputCols;
                    kernelOffset -= nKernelCols;
                }
                output.update(outputOffset, ev.plus(output.apply(outputOffset), ev.times(alpha, sum2)));
                ++outputOffset;
            }
        }
    }

    public <T> void validXCorr2Dptr(Storage<T> output, int _outputOffset, T alpha, Storage<T> input, int _inputOffset, int nInputRows, int nInputCols, Storage<T> kernel, int _kernelOffset, int nKernelRows, int nKernelCols, int srow, int scol, TensorNumericMath.TensorNumeric<T> ev) {
        int nOutputCol = (nInputCols - nKernelCols) / srow + 1;
        int nOutputRow = (nInputRows - nKernelRows) / scol + 1;
        int outputOffset = _outputOffset;
        for (int yy = 0; yy < nOutputRow; ++yy) {
            for (int xx = 0; xx < nOutputCol; ++xx) {
                int inputOffset = yy * srow * nInputCols + xx * scol + _inputOffset;
                int kernelOffset = _kernelOffset;
                T sum2 = ev.fromType(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$);
                for (int ky = 0; ky < nKernelRows; ++ky) {
                    for (int kx = 0; kx < nKernelCols; ++kx) {
                        sum2 = ev.plus(sum2, ev.times(input.apply(inputOffset + kx), kernel.apply(kernelOffset + kx)));
                    }
                    inputOffset += nInputCols;
                    kernelOffset += nKernelCols;
                }
                output.update(outputOffset, ev.plus(output.apply(outputOffset), ev.times(alpha, sum2)));
                ++outputOffset;
            }
        }
    }

    public <T> void conv2d(Storage<T> output, int _outputOffset, T alpha, Storage<T> input, int _inputOffset, int nInputRows, int nInputCols, Storage<T> kernel, int _kernelOffset, int nKernelRows, int nKernelCols, int srow, int scol, char vf, char xc, TensorNumericMath.TensorNumeric<T> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(vf == 'F' || vf == 'V', "type of convolution can be 'V' or 'F'", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(xc == 'X' || xc == 'C', "type of convolution can be 'X' or 'C'", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (vf == 'F') {
            if (xc == 'X') {
                this.fullXCorr2Dptr(output, _outputOffset, alpha, input, _inputOffset, nInputRows, nInputCols, kernel, _kernelOffset, nKernelRows, nKernelCols, srow, scol, ev);
            } else {
                this.fullConv2Dptr(output, _outputOffset, alpha, input, _inputOffset, nInputRows, nInputCols, kernel, _kernelOffset, nKernelRows, nKernelCols, srow, scol, ev);
            }
        } else if (xc == 'X') {
            this.validXCorr2Dptr(output, _outputOffset, alpha, input, _inputOffset, nInputRows, nInputCols, kernel, _kernelOffset, nKernelRows, nKernelCols, srow, scol, ev);
        } else {
            this.validConv2Dptr(output, _outputOffset, alpha, input, _inputOffset, nInputRows, nInputCols, kernel, _kernelOffset, nKernelRows, nKernelCols, srow, scol, ev);
        }
    }

    public <T> void validXCorr2DRevptr(Storage<T> gradWeight, int _gradWeightOffset, T alpha, Storage<T> input, int _inputOffset, int ir, int ic, Storage<T> output, int _outputOffset, int kr, int kc, int sr, int sc, TensorNumericMath.TensorNumeric<T> ev) {
        int or = ir - (kr - 1) * sr;
        int oc = ic - (kc - 1) * sc;
        for (int yy = 0; yy < kr; ++yy) {
            for (int xx = 0; xx < kc; ++xx) {
                int gradWeightOffset = _gradWeightOffset;
                int inputOffset = _inputOffset + yy * sr * ic + xx * sc;
                T z = ev.times(output.apply(_outputOffset + yy * kc + xx), alpha);
                for (int ky = 0; ky < or; ++ky) {
                    for (int kx = 0; kx < oc; ++kx) {
                        gradWeight.update(kx + gradWeightOffset, ev.plus(gradWeight.apply(kx + gradWeightOffset), ev.times(z, input.apply(kx + inputOffset))));
                    }
                    gradWeightOffset += oc;
                    inputOffset += ic;
                }
            }
        }
    }

    public <T> Tensor<T> conv2Dmul(T alpha, Tensor<T> t2, Tensor<T> k, int srow, int scol, char vf, char xc, ClassTag<T> evidence$1, TensorNumericMath.TensorNumeric<T> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(t2.nDimension() == 2, "input: 2D Tensor expected", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(k.nDimension() == 2, "kernel: 2D Tensor expected", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(srow >= 1, "Stride should be a positive integer", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(scol >= 1, "Stride should be a positive integer", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Tensor<T> input = t2.contiguous();
        Tensor<T> kernel = k.contiguous();
        int nInputRows = input.size(1);
        int nInputCols = input.size(2);
        int nKernelRows = kernel.size(1);
        int nKernelCols = kernel.size(2);
        Log4Error$.MODULE$.unKnowExceptionError(nInputRows >= nKernelRows && nInputCols >= nKernelCols || vf == 'F', "conv2Dmul : Input image is smaller than kernel", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        int nOutputRows = this.convSize(nInputRows, nKernelRows, srow, vf);
        int nOutputCols = this.convSize(nInputCols, nKernelCols, scol, vf);
        Tensor<T> result2 = Tensor$.MODULE$.apply(nOutputRows, nOutputCols, evidence$1, ev);
        this.conv2d(result2.storage(), result2.storageOffset() - 1, alpha, input.storage(), input.storageOffset() - 1, nInputRows, nInputCols, kernel.storage(), kernel.storageOffset() - 1, nKernelRows, nKernelCols, srow, scol, vf, xc, ev);
        return result2;
    }

    public int convSize(int x, int k, int s2, char vf) {
        Log4Error$.MODULE$.unKnowExceptionError(vf == 'F' || vf == 'V', "type of convolution can be 'V' or 'F'", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        return vf == 'V' ? (x - k) / s2 + 1 : (x - 1) * s2 + k;
    }

    public void fullXCorr2Dptr$mDc$sp(Storage<Object> output, int _outputOffset, double alpha, Storage<Object> input, int _inputOffset, int nInputRows, int nInputCols, Storage<Object> kernel, int _kernelOffset, int nKernelRows, int nKernelCols, int srow, int scol, TensorNumericMath.TensorNumeric<Object> ev) {
        int nOuputCol = (nInputCols - 1) * scol + nKernelCols;
        int inputOffset = _inputOffset;
        for (int yy = 0; yy < nInputRows; ++yy) {
            for (int xx = 0; xx < nInputCols; ++xx) {
                int outputOffset = yy * srow * nOuputCol + xx * scol + _outputOffset;
                int kernelOffset = nKernelCols * nKernelRows - 1 + _kernelOffset;
                for (int ky = 0; ky < nKernelRows; ++ky) {
                    double z = BoxesRunTime.unboxToDouble((Object)input.apply(inputOffset));
                    for (int kx = 0; kx < nKernelCols; ++kx) {
                        output.update(outputOffset + kx, BoxesRunTime.boxToDouble((double)ev.plus$mcD$sp(BoxesRunTime.unboxToDouble((Object)output.apply(outputOffset + kx)), ev.times$mcD$sp(z, BoxesRunTime.unboxToDouble((Object)kernel.apply(kernelOffset - kx))))));
                    }
                    outputOffset += nOuputCol;
                    kernelOffset -= nKernelCols;
                }
                ++inputOffset;
            }
        }
    }

    public void fullXCorr2Dptr$mFc$sp(Storage<Object> output, int _outputOffset, float alpha, Storage<Object> input, int _inputOffset, int nInputRows, int nInputCols, Storage<Object> kernel, int _kernelOffset, int nKernelRows, int nKernelCols, int srow, int scol, TensorNumericMath.TensorNumeric<Object> ev) {
        int nOuputCol = (nInputCols - 1) * scol + nKernelCols;
        int inputOffset = _inputOffset;
        for (int yy = 0; yy < nInputRows; ++yy) {
            for (int xx = 0; xx < nInputCols; ++xx) {
                int outputOffset = yy * srow * nOuputCol + xx * scol + _outputOffset;
                int kernelOffset = nKernelCols * nKernelRows - 1 + _kernelOffset;
                for (int ky = 0; ky < nKernelRows; ++ky) {
                    float z = BoxesRunTime.unboxToFloat((Object)input.apply(inputOffset));
                    for (int kx = 0; kx < nKernelCols; ++kx) {
                        output.update(outputOffset + kx, BoxesRunTime.boxToFloat((float)ev.plus$mcF$sp(BoxesRunTime.unboxToFloat((Object)output.apply(outputOffset + kx)), ev.times$mcF$sp(z, BoxesRunTime.unboxToFloat((Object)kernel.apply(kernelOffset - kx))))));
                    }
                    outputOffset += nOuputCol;
                    kernelOffset -= nKernelCols;
                }
                ++inputOffset;
            }
        }
    }

    public void fullConv2Dptr$mDc$sp(Storage<Object> output, int _outputOffset, double alpha, Storage<Object> input, int _inputOffset, int nInputRows, int nInputCols, Storage<Object> kernel, int _kernelOffset, int nKernelRows, int nKernelCols, int srow, int scol, TensorNumericMath.TensorNumeric<Object> ev) {
        int nOutputCol = (nInputCols - 1) * scol + nKernelCols;
        int inputOffset = _inputOffset;
        for (int yy = 0; yy < nInputRows; ++yy) {
            for (int xx = 0; xx < nInputCols; ++xx) {
                int outputOffset = yy * srow * nOutputCol + xx * scol + _outputOffset;
                int kernelOffset = _kernelOffset;
                for (int ky = 0; ky < nKernelRows; ++ky) {
                    double z = ev.times$mcD$sp(BoxesRunTime.unboxToDouble((Object)input.apply(inputOffset)), alpha);
                    for (int kx = 0; kx < nKernelCols; ++kx) {
                        output.update(outputOffset + kx, BoxesRunTime.boxToDouble((double)ev.plus$mcD$sp(BoxesRunTime.unboxToDouble((Object)output.apply(outputOffset + kx)), ev.times$mcD$sp(z, BoxesRunTime.unboxToDouble((Object)kernel.apply(kernelOffset + kx))))));
                    }
                    outputOffset += nOutputCol;
                    kernelOffset += nKernelCols;
                }
                ++inputOffset;
            }
        }
    }

    public void fullConv2Dptr$mFc$sp(Storage<Object> output, int _outputOffset, float alpha, Storage<Object> input, int _inputOffset, int nInputRows, int nInputCols, Storage<Object> kernel, int _kernelOffset, int nKernelRows, int nKernelCols, int srow, int scol, TensorNumericMath.TensorNumeric<Object> ev) {
        int nOutputCol = (nInputCols - 1) * scol + nKernelCols;
        int inputOffset = _inputOffset;
        for (int yy = 0; yy < nInputRows; ++yy) {
            for (int xx = 0; xx < nInputCols; ++xx) {
                int outputOffset = yy * srow * nOutputCol + xx * scol + _outputOffset;
                int kernelOffset = _kernelOffset;
                for (int ky = 0; ky < nKernelRows; ++ky) {
                    float z = ev.times$mcF$sp(BoxesRunTime.unboxToFloat((Object)input.apply(inputOffset)), alpha);
                    for (int kx = 0; kx < nKernelCols; ++kx) {
                        output.update(outputOffset + kx, BoxesRunTime.boxToFloat((float)ev.plus$mcF$sp(BoxesRunTime.unboxToFloat((Object)output.apply(outputOffset + kx)), ev.times$mcF$sp(z, BoxesRunTime.unboxToFloat((Object)kernel.apply(kernelOffset + kx))))));
                    }
                    outputOffset += nOutputCol;
                    kernelOffset += nKernelCols;
                }
                ++inputOffset;
            }
        }
    }

    public void validConv2Dptr$mDc$sp(Storage<Object> output, int _outputOffset, double alpha, Storage<Object> input, int _inputOffset, int nInputRows, int nInputCols, Storage<Object> kernel, int _kernelOffset, int nKernelRows, int nKernelCols, int srow, int scol, TensorNumericMath.TensorNumeric<Object> ev) {
        int nOutputCol = (nInputCols - nKernelCols) / srow + 1;
        int nOutputRow = (nInputRows - nKernelRows) / scol + 1;
        int outputOffset = _outputOffset;
        for (int yy = 0; yy < nOutputRow; ++yy) {
            for (int xx = 0; xx < nOutputCol; ++xx) {
                int inputOffset = yy * srow * nInputCols + xx * scol + _inputOffset;
                int kernelOffset = nKernelRows * nKernelCols - 1 + _kernelOffset;
                double sum2 = ev.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$);
                for (int ky = 0; ky < nKernelRows; ++ky) {
                    for (int kx = 0; kx < nKernelCols; ++kx) {
                        sum2 = ev.plus$mcD$sp(sum2, ev.times$mcD$sp(BoxesRunTime.unboxToDouble((Object)input.apply(inputOffset + kx)), BoxesRunTime.unboxToDouble((Object)kernel.apply(kernelOffset - kx))));
                    }
                    inputOffset += nInputCols;
                    kernelOffset -= nKernelCols;
                }
                output.update(outputOffset, BoxesRunTime.boxToDouble((double)ev.plus$mcD$sp(BoxesRunTime.unboxToDouble((Object)output.apply(outputOffset)), ev.times$mcD$sp(alpha, sum2))));
                ++outputOffset;
            }
        }
    }

    public void validConv2Dptr$mFc$sp(Storage<Object> output, int _outputOffset, float alpha, Storage<Object> input, int _inputOffset, int nInputRows, int nInputCols, Storage<Object> kernel, int _kernelOffset, int nKernelRows, int nKernelCols, int srow, int scol, TensorNumericMath.TensorNumeric<Object> ev) {
        int nOutputCol = (nInputCols - nKernelCols) / srow + 1;
        int nOutputRow = (nInputRows - nKernelRows) / scol + 1;
        int outputOffset = _outputOffset;
        for (int yy = 0; yy < nOutputRow; ++yy) {
            for (int xx = 0; xx < nOutputCol; ++xx) {
                int inputOffset = yy * srow * nInputCols + xx * scol + _inputOffset;
                int kernelOffset = nKernelRows * nKernelCols - 1 + _kernelOffset;
                float sum2 = ev.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$);
                for (int ky = 0; ky < nKernelRows; ++ky) {
                    for (int kx = 0; kx < nKernelCols; ++kx) {
                        sum2 = ev.plus$mcF$sp(sum2, ev.times$mcF$sp(BoxesRunTime.unboxToFloat((Object)input.apply(inputOffset + kx)), BoxesRunTime.unboxToFloat((Object)kernel.apply(kernelOffset - kx))));
                    }
                    inputOffset += nInputCols;
                    kernelOffset -= nKernelCols;
                }
                output.update(outputOffset, BoxesRunTime.boxToFloat((float)ev.plus$mcF$sp(BoxesRunTime.unboxToFloat((Object)output.apply(outputOffset)), ev.times$mcF$sp(alpha, sum2))));
                ++outputOffset;
            }
        }
    }

    public void validXCorr2Dptr$mDc$sp(Storage<Object> output, int _outputOffset, double alpha, Storage<Object> input, int _inputOffset, int nInputRows, int nInputCols, Storage<Object> kernel, int _kernelOffset, int nKernelRows, int nKernelCols, int srow, int scol, TensorNumericMath.TensorNumeric<Object> ev) {
        int nOutputCol = (nInputCols - nKernelCols) / srow + 1;
        int nOutputRow = (nInputRows - nKernelRows) / scol + 1;
        int outputOffset = _outputOffset;
        for (int yy = 0; yy < nOutputRow; ++yy) {
            for (int xx = 0; xx < nOutputCol; ++xx) {
                int inputOffset = yy * srow * nInputCols + xx * scol + _inputOffset;
                int kernelOffset = _kernelOffset;
                double sum2 = ev.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$);
                for (int ky = 0; ky < nKernelRows; ++ky) {
                    for (int kx = 0; kx < nKernelCols; ++kx) {
                        sum2 = ev.plus$mcD$sp(sum2, ev.times$mcD$sp(BoxesRunTime.unboxToDouble((Object)input.apply(inputOffset + kx)), BoxesRunTime.unboxToDouble((Object)kernel.apply(kernelOffset + kx))));
                    }
                    inputOffset += nInputCols;
                    kernelOffset += nKernelCols;
                }
                output.update(outputOffset, BoxesRunTime.boxToDouble((double)ev.plus$mcD$sp(BoxesRunTime.unboxToDouble((Object)output.apply(outputOffset)), ev.times$mcD$sp(alpha, sum2))));
                ++outputOffset;
            }
        }
    }

    public void validXCorr2Dptr$mFc$sp(Storage<Object> output, int _outputOffset, float alpha, Storage<Object> input, int _inputOffset, int nInputRows, int nInputCols, Storage<Object> kernel, int _kernelOffset, int nKernelRows, int nKernelCols, int srow, int scol, TensorNumericMath.TensorNumeric<Object> ev) {
        int nOutputCol = (nInputCols - nKernelCols) / srow + 1;
        int nOutputRow = (nInputRows - nKernelRows) / scol + 1;
        int outputOffset = _outputOffset;
        for (int yy = 0; yy < nOutputRow; ++yy) {
            for (int xx = 0; xx < nOutputCol; ++xx) {
                int inputOffset = yy * srow * nInputCols + xx * scol + _inputOffset;
                int kernelOffset = _kernelOffset;
                float sum2 = ev.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)0), ConvertableFrom$ConvertableFromInt$.MODULE$);
                for (int ky = 0; ky < nKernelRows; ++ky) {
                    for (int kx = 0; kx < nKernelCols; ++kx) {
                        sum2 = ev.plus$mcF$sp(sum2, ev.times$mcF$sp(BoxesRunTime.unboxToFloat((Object)input.apply(inputOffset + kx)), BoxesRunTime.unboxToFloat((Object)kernel.apply(kernelOffset + kx))));
                    }
                    inputOffset += nInputCols;
                    kernelOffset += nKernelCols;
                }
                output.update(outputOffset, BoxesRunTime.boxToFloat((float)ev.plus$mcF$sp(BoxesRunTime.unboxToFloat((Object)output.apply(outputOffset)), ev.times$mcF$sp(alpha, sum2))));
                ++outputOffset;
            }
        }
    }

    public void conv2d$mDc$sp(Storage<Object> output, int _outputOffset, double alpha, Storage<Object> input, int _inputOffset, int nInputRows, int nInputCols, Storage<Object> kernel, int _kernelOffset, int nKernelRows, int nKernelCols, int srow, int scol, char vf, char xc, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(vf == 'F' || vf == 'V', "type of convolution can be 'V' or 'F'", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(xc == 'X' || xc == 'C', "type of convolution can be 'X' or 'C'", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (vf == 'F') {
            if (xc == 'X') {
                this.fullXCorr2Dptr$mDc$sp(output, _outputOffset, alpha, input, _inputOffset, nInputRows, nInputCols, kernel, _kernelOffset, nKernelRows, nKernelCols, srow, scol, ev);
            } else {
                this.fullConv2Dptr$mDc$sp(output, _outputOffset, alpha, input, _inputOffset, nInputRows, nInputCols, kernel, _kernelOffset, nKernelRows, nKernelCols, srow, scol, ev);
            }
        } else if (xc == 'X') {
            this.validXCorr2Dptr$mDc$sp(output, _outputOffset, alpha, input, _inputOffset, nInputRows, nInputCols, kernel, _kernelOffset, nKernelRows, nKernelCols, srow, scol, ev);
        } else {
            this.validConv2Dptr$mDc$sp(output, _outputOffset, alpha, input, _inputOffset, nInputRows, nInputCols, kernel, _kernelOffset, nKernelRows, nKernelCols, srow, scol, ev);
        }
    }

    public void conv2d$mFc$sp(Storage<Object> output, int _outputOffset, float alpha, Storage<Object> input, int _inputOffset, int nInputRows, int nInputCols, Storage<Object> kernel, int _kernelOffset, int nKernelRows, int nKernelCols, int srow, int scol, char vf, char xc, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(vf == 'F' || vf == 'V', "type of convolution can be 'V' or 'F'", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(xc == 'X' || xc == 'C', "type of convolution can be 'X' or 'C'", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (vf == 'F') {
            if (xc == 'X') {
                this.fullXCorr2Dptr$mFc$sp(output, _outputOffset, alpha, input, _inputOffset, nInputRows, nInputCols, kernel, _kernelOffset, nKernelRows, nKernelCols, srow, scol, ev);
            } else {
                this.fullConv2Dptr$mFc$sp(output, _outputOffset, alpha, input, _inputOffset, nInputRows, nInputCols, kernel, _kernelOffset, nKernelRows, nKernelCols, srow, scol, ev);
            }
        } else if (xc == 'X') {
            this.validXCorr2Dptr$mFc$sp(output, _outputOffset, alpha, input, _inputOffset, nInputRows, nInputCols, kernel, _kernelOffset, nKernelRows, nKernelCols, srow, scol, ev);
        } else {
            this.validConv2Dptr$mFc$sp(output, _outputOffset, alpha, input, _inputOffset, nInputRows, nInputCols, kernel, _kernelOffset, nKernelRows, nKernelCols, srow, scol, ev);
        }
    }

    public void validXCorr2DRevptr$mDc$sp(Storage<Object> gradWeight, int _gradWeightOffset, double alpha, Storage<Object> input, int _inputOffset, int ir, int ic, Storage<Object> output, int _outputOffset, int kr, int kc, int sr, int sc, TensorNumericMath.TensorNumeric<Object> ev) {
        int or = ir - (kr - 1) * sr;
        int oc = ic - (kc - 1) * sc;
        for (int yy = 0; yy < kr; ++yy) {
            for (int xx = 0; xx < kc; ++xx) {
                int gradWeightOffset = _gradWeightOffset;
                int inputOffset = _inputOffset + yy * sr * ic + xx * sc;
                double z = ev.times$mcD$sp(BoxesRunTime.unboxToDouble((Object)output.apply(_outputOffset + yy * kc + xx)), alpha);
                for (int ky = 0; ky < or; ++ky) {
                    for (int kx = 0; kx < oc; ++kx) {
                        gradWeight.update(kx + gradWeightOffset, BoxesRunTime.boxToDouble((double)ev.plus$mcD$sp(BoxesRunTime.unboxToDouble((Object)gradWeight.apply(kx + gradWeightOffset)), ev.times$mcD$sp(z, BoxesRunTime.unboxToDouble((Object)input.apply(kx + inputOffset))))));
                    }
                    gradWeightOffset += oc;
                    inputOffset += ic;
                }
            }
        }
    }

    public void validXCorr2DRevptr$mFc$sp(Storage<Object> gradWeight, int _gradWeightOffset, float alpha, Storage<Object> input, int _inputOffset, int ir, int ic, Storage<Object> output, int _outputOffset, int kr, int kc, int sr, int sc, TensorNumericMath.TensorNumeric<Object> ev) {
        int or = ir - (kr - 1) * sr;
        int oc = ic - (kc - 1) * sc;
        for (int yy = 0; yy < kr; ++yy) {
            for (int xx = 0; xx < kc; ++xx) {
                int gradWeightOffset = _gradWeightOffset;
                int inputOffset = _inputOffset + yy * sr * ic + xx * sc;
                float z = ev.times$mcF$sp(BoxesRunTime.unboxToFloat((Object)output.apply(_outputOffset + yy * kc + xx)), alpha);
                for (int ky = 0; ky < or; ++ky) {
                    for (int kx = 0; kx < oc; ++kx) {
                        gradWeight.update(kx + gradWeightOffset, BoxesRunTime.boxToFloat((float)ev.plus$mcF$sp(BoxesRunTime.unboxToFloat((Object)gradWeight.apply(kx + gradWeightOffset)), ev.times$mcF$sp(z, BoxesRunTime.unboxToFloat((Object)input.apply(kx + inputOffset))))));
                    }
                    gradWeightOffset += oc;
                    inputOffset += ic;
                }
            }
        }
    }

    public Tensor<Object> conv2Dmul$mDc$sp(double alpha, Tensor<Object> t2, Tensor<Object> k, int srow, int scol, char vf, char xc, ClassTag<Object> evidence$1, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(t2.nDimension() == 2, "input: 2D Tensor expected", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(k.nDimension() == 2, "kernel: 2D Tensor expected", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(srow >= 1, "Stride should be a positive integer", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(scol >= 1, "Stride should be a positive integer", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Tensor<Object> input = t2.contiguous();
        Tensor<Object> kernel = k.contiguous();
        int nInputRows = input.size(1);
        int nInputCols = input.size(2);
        int nKernelRows = kernel.size(1);
        int nKernelCols = kernel.size(2);
        Log4Error$.MODULE$.unKnowExceptionError(nInputRows >= nKernelRows && nInputCols >= nKernelCols || vf == 'F', "conv2Dmul : Input image is smaller than kernel", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        int nOutputRows = this.convSize(nInputRows, nKernelRows, srow, vf);
        int nOutputCols = this.convSize(nInputCols, nKernelCols, scol, vf);
        Tensor<Object> result2 = Tensor$.MODULE$.apply$mDc$sp(nOutputRows, nOutputCols, evidence$1, ev);
        this.conv2d$mDc$sp(result2.storage(), result2.storageOffset() - 1, alpha, input.storage(), input.storageOffset() - 1, nInputRows, nInputCols, kernel.storage(), kernel.storageOffset() - 1, nKernelRows, nKernelCols, srow, scol, vf, xc, ev);
        return result2;
    }

    public Tensor<Object> conv2Dmul$mFc$sp(float alpha, Tensor<Object> t2, Tensor<Object> k, int srow, int scol, char vf, char xc, ClassTag<Object> evidence$1, TensorNumericMath.TensorNumeric<Object> ev) {
        Log4Error$.MODULE$.unKnowExceptionError(t2.nDimension() == 2, "input: 2D Tensor expected", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(k.nDimension() == 2, "kernel: 2D Tensor expected", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(srow >= 1, "Stride should be a positive integer", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(scol >= 1, "Stride should be a positive integer", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Tensor<Object> input = t2.contiguous();
        Tensor<Object> kernel = k.contiguous();
        int nInputRows = input.size(1);
        int nInputCols = input.size(2);
        int nKernelRows = kernel.size(1);
        int nKernelCols = kernel.size(2);
        Log4Error$.MODULE$.unKnowExceptionError(nInputRows >= nKernelRows && nInputCols >= nKernelCols || vf == 'F', "conv2Dmul : Input image is smaller than kernel", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        int nOutputRows = this.convSize(nInputRows, nKernelRows, srow, vf);
        int nOutputCols = this.convSize(nInputCols, nKernelCols, scol, vf);
        Tensor<Object> result2 = Tensor$.MODULE$.apply$mFc$sp(nOutputRows, nOutputCols, evidence$1, ev);
        this.conv2d$mFc$sp(result2.storage(), result2.storageOffset() - 1, alpha, input.storage(), input.storageOffset() - 1, nInputRows, nInputCols, kernel.storage(), kernel.storageOffset() - 1, nKernelRows, nKernelCols, srow, scol, vf, xc, ev);
        return result2;
    }

    private DenseTensorConv$() {
        MODULE$ = this;
    }
}

