/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.tensor;

import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.TensorDiffTypeFunc4;
import com.intel.analytics.bigdl.dllib.tensor.TensorDiffTypeFunc6;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc2;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc4;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc6;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class DenseTensorApply$ {
    public static final DenseTensorApply$ MODULE$;

    static {
        new DenseTensorApply$();
    }

    public <A, B> void apply1(Tensor<A> tensor1, Tensor<B> tensor2, TensorDiffTypeFunc4<A, B> func) {
        if (tensor1.isEmpty()) {
            return;
        }
        if (tensor1.isScalar() && tensor2.isScalar()) {
            Object data1 = tensor1.storage().array();
            int index1 = tensor1.storageOffset() - 1;
            Object data2 = tensor2.storage().array();
            int index2 = tensor2.storageOffset() - 1;
            func.apply(data1, index1, data2, index2);
            return;
        }
        int stride1 = this.getStride(tensor1);
        int stride2 = this.getStride(tensor2);
        Tuple2<Object, Object> tuple2 = this.getLargestContiguousSize(tensor1);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int largestDim1 = tuple2._1$mcI$sp();
            int largestSize1 = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(largestDim1, largestSize1);
            int largestDim12 = sp3._1$mcI$sp();
            int largestSize12 = sp3._2$mcI$sp();
            Tuple2<Object, Object> tuple22 = this.getLargestContiguousSize(tensor2);
            if (tuple22 != null) {
                Tuple2.mcII.sp sp4;
                int largestDim2 = tuple22._1$mcI$sp();
                int largestSize2 = tuple22._2$mcI$sp();
                Tuple2.mcII.sp sp5 = sp4 = new Tuple2.mcII.sp(largestDim2, largestSize2);
                int largestDim22 = sp5._1$mcI$sp();
                int largestSize22 = sp5._2$mcI$sp();
                int[] counter1 = this.getCounter(largestDim12);
                int[] counter2 = this.getCounter(largestDim22);
                Object data1 = tensor1.storage().array();
                Object data2 = tensor2.storage().array();
                int offset1 = tensor1.storageOffset() - 1;
                int offset2 = tensor2.storageOffset() - 1;
                boolean hasFinished1 = false;
                boolean hasFinished2 = false;
                int i1 = 0;
                int i2 = 0;
                while (true) {
                    if (hasFinished1 || hasFinished2) {
                        return;
                    }
                    while (i1 < largestSize12 && i2 < largestSize22) {
                        int index1 = offset1 + i1 * stride1;
                        int index2 = offset2 + i2 * stride2;
                        func.apply(data1, index1, data2, index2);
                        ++i1;
                        ++i2;
                    }
                    Tuple2<Object, Object> r1 = this.updateCounter(tensor1, counter1, offset1, largestDim12);
                    Tuple2<Object, Object> r2 = this.updateCounter(tensor2, counter2, offset2, largestDim22);
                    hasFinished1 = r1._1$mcZ$sp();
                    hasFinished2 = r2._1$mcZ$sp();
                    offset1 = r1._2$mcI$sp();
                    offset2 = r2._2$mcI$sp();
                    i1 = 0;
                    i2 = 0;
                }
            }
            throw new MatchError(tuple22);
        }
        throw new MatchError(tuple2);
    }

    public <T> void apply1(Tensor<T> tensor, TensorFunc2<T> func) {
        if (tensor.isEmpty()) {
            return;
        }
        if (tensor.isScalar()) {
            Object data2 = tensor.storage().array();
            int index = tensor.storageOffset() - 1;
            func.apply(data2, index);
            return;
        }
        int stride = this.getStride(tensor);
        Tuple2<Object, Object> tuple2 = this.getLargestContiguousSize(tensor);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int largestDim = tuple2._1$mcI$sp();
            int largestSize = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(largestDim, largestSize);
            int largestDim2 = sp3._1$mcI$sp();
            int largestSize2 = sp3._2$mcI$sp();
            int[] counter = this.getCounter(largestDim2);
            Object data3 = tensor.storage().array();
            int offset = tensor.storageOffset() - 1;
            boolean hasFinished = false;
            int i = 0;
            while (true) {
                if (hasFinished) {
                    return;
                }
                while (i < largestSize2) {
                    int index = offset + i * stride;
                    func.apply(data3, index);
                    ++i;
                }
                Tuple2<Object, Object> r = this.updateCounter(tensor, counter, offset, largestDim2);
                hasFinished = r._1$mcZ$sp();
                offset = r._2$mcI$sp();
                i = 0;
            }
        }
        throw new MatchError(tuple2);
    }

    public <T> void apply2(Tensor<T> tensor1, Tensor<T> tensor2, TensorFunc4<T> func) {
        Log4Error$.MODULE$.unKnowExceptionError(tensor1.nElement() == tensor2.nElement(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"inconsistent tensor size: ", " == ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)tensor1.nElement()), BoxesRunTime.boxToInteger((int)tensor2.nElement())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (tensor1.isEmpty()) {
            return;
        }
        if (tensor1.isScalar() && tensor2.isScalar()) {
            Object tensor1Data = tensor1.storage().array();
            Object tensor2Data = tensor2.storage().array();
            int tensor1Index = tensor1.storageOffset() - 1;
            int tensor2Index = tensor2.storageOffset() - 1;
            func.apply(tensor1Data, tensor1Index, tensor2Data, tensor2Index);
            return;
        }
        Object tensor1Data = tensor1.storage().array();
        int tensor1Offset = tensor1.storageOffset() - 1;
        Object tensor2Data = tensor2.storage().array();
        int tensor2Offset = tensor2.storageOffset() - 1;
        boolean adjacent = false;
        if (tensor1.nDimension() == 1 && tensor2.nDimension() == 1 && tensor1.stride(1) == 1 && tensor2.stride(1) == 1) {
            adjacent = true;
        }
        if (tensor1.nDimension() == 2 && tensor2.nDimension() == 2) {
            if (tensor1.stride(2) == 1 && tensor2.stride(2) == 1 && tensor1.stride(1) == tensor1.size(2) && tensor2.stride(1) == tensor2.size(2)) {
                adjacent = true;
            }
            if (tensor1.stride(1) == 1 && tensor2.stride(1) == 1 && tensor1.stride(2) == tensor1.size(1) && tensor2.stride(2) == tensor2.size(1)) {
                adjacent = true;
            }
        }
        if (adjacent) {
            for (int i = 0; i < tensor1.nElement(); ++i) {
                func.apply(tensor1Data, tensor1Offset + i, tensor2Data, tensor2Offset + i);
            }
            return;
        }
        int tensor1Stride = this.getStride(tensor1);
        Tuple2<Object, Object> tuple2 = this.getLargestContiguousSize(tensor1);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int largestDim1 = tuple2._1$mcI$sp();
            int largestSize1 = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(largestDim1, largestSize1);
            int largestDim12 = sp3._1$mcI$sp();
            int largestSize12 = sp3._2$mcI$sp();
            int[] counter1 = this.getCounter(largestDim12);
            int tensor2Stride = this.getStride(tensor2);
            Tuple2<Object, Object> tuple22 = this.getLargestContiguousSize(tensor2);
            if (tuple22 != null) {
                Tuple2.mcII.sp sp4;
                int largestDim2 = tuple22._1$mcI$sp();
                int largestSize2 = tuple22._2$mcI$sp();
                Tuple2.mcII.sp sp5 = sp4 = new Tuple2.mcII.sp(largestDim2, largestSize2);
                int largestDim22 = sp5._1$mcI$sp();
                int largestSize22 = sp5._2$mcI$sp();
                int[] counter2 = this.getCounter(largestDim22);
                boolean hasFinished = false;
                int i1 = 0;
                int i2 = 0;
                while (true) {
                    if (hasFinished) {
                        return;
                    }
                    while (i1 < largestSize12 && i2 < largestSize22) {
                        func.apply(tensor1Data, tensor1Offset + i1 * tensor1Stride, tensor2Data, tensor2Offset + i2 * tensor2Stride);
                        ++i1;
                        ++i2;
                    }
                    if (i1 == largestSize12) {
                        Tuple2<Object, Object> r = this.updateCounter(tensor1, counter1, tensor1Offset, largestDim12);
                        hasFinished = r._1$mcZ$sp();
                        tensor1Offset = r._2$mcI$sp();
                        i1 = 0;
                    }
                    if (i2 != largestSize22) continue;
                    Tuple2<Object, Object> r = this.updateCounter(tensor2, counter2, tensor2Offset, largestDim22);
                    hasFinished = r._1$mcZ$sp();
                    tensor2Offset = r._2$mcI$sp();
                    i2 = 0;
                }
            }
            throw new MatchError(tuple22);
        }
        throw new MatchError(tuple2);
    }

    public <T> void apply3(Tensor<T> tensor1, Tensor<T> tensor2, Tensor<T> tensor3, TensorFunc6<T> func) {
        Log4Error$.MODULE$.unKnowExceptionError(tensor1.nElement() == tensor2.nElement() && tensor2.nElement() == tensor3.nElement(), "inconsistent tensor size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (tensor1.isEmpty()) {
            return;
        }
        if (tensor1.isScalar() && tensor2.isScalar() && tensor3.isScalar()) {
            Object tensor1Data = tensor1.storage().array();
            Object tensor2Data = tensor2.storage().array();
            Object tensor3Data = tensor3.storage().array();
            int tensor1Index = tensor1.storageOffset() - 1;
            int tensor2Index = tensor2.storageOffset() - 1;
            int tensor3Index = tensor3.storageOffset() - 1;
            func.apply(tensor1Data, tensor1Index, tensor2Data, tensor2Index, tensor3Data, tensor3Index);
            return;
        }
        Object tensor1Data = tensor1.storage().array();
        int tensor1Offset = tensor1.storageOffset() - 1;
        int tensor1Stride = this.getStride(tensor1);
        Tuple2<Object, Object> tuple2 = this.getLargestContiguousSize(tensor1);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int tensor1Dim = tuple2._1$mcI$sp();
            int tensor1Size = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(tensor1Dim, tensor1Size);
            int tensor1Dim2 = sp3._1$mcI$sp();
            int tensor1Size2 = sp3._2$mcI$sp();
            int[] tensor1Counter = this.getCounter(tensor1Dim2);
            Object tensor2Data = tensor2.storage().array();
            int tensor2Offset = tensor2.storageOffset() - 1;
            int tensor2Stride = this.getStride(tensor2);
            Tuple2<Object, Object> tuple22 = this.getLargestContiguousSize(tensor2);
            if (tuple22 != null) {
                Tuple2.mcII.sp sp4;
                int tensor2Dim = tuple22._1$mcI$sp();
                int tensor2Size = tuple22._2$mcI$sp();
                Tuple2.mcII.sp sp5 = sp4 = new Tuple2.mcII.sp(tensor2Dim, tensor2Size);
                int tensor2Dim2 = sp5._1$mcI$sp();
                int tensor2Size2 = sp5._2$mcI$sp();
                int[] tensor2Counter = this.getCounter(tensor2Dim2);
                Object tensor3Data = tensor3.storage().array();
                int tensor3Offset = tensor3.storageOffset() - 1;
                int tensor3Stride = this.getStride(tensor3);
                Tuple2<Object, Object> tuple23 = this.getLargestContiguousSize(tensor3);
                if (tuple23 != null) {
                    Tuple2.mcII.sp sp6;
                    int tensor3Dim = tuple23._1$mcI$sp();
                    int tensor3Size = tuple23._2$mcI$sp();
                    Tuple2.mcII.sp sp7 = sp6 = new Tuple2.mcII.sp(tensor3Dim, tensor3Size);
                    int tensor3Dim2 = sp7._1$mcI$sp();
                    int tensor3Size2 = sp7._2$mcI$sp();
                    int[] tensor3Counter = this.getCounter(tensor3Dim2);
                    boolean hasFinished = false;
                    int i1 = 0;
                    int i2 = 0;
                    int i3 = 0;
                    while (true) {
                        if (hasFinished) {
                            return;
                        }
                        while (i1 < tensor1Size2 && i2 < tensor2Size2 && i3 < tensor3Size2) {
                            func.apply(tensor1Data, tensor1Offset + i1 * tensor1Stride, tensor2Data, tensor2Offset + i2 * tensor2Stride, tensor3Data, tensor3Offset + i3 * tensor3Stride);
                            ++i1;
                            ++i2;
                            ++i3;
                        }
                        if (i1 == tensor1Size2) {
                            Tuple2<Object, Object> r = this.updateCounter(tensor1, tensor1Counter, tensor1Offset, tensor1Dim2);
                            hasFinished = r._1$mcZ$sp();
                            tensor1Offset = r._2$mcI$sp();
                            i1 = 0;
                        }
                        if (i2 == tensor2Size2) {
                            Tuple2<Object, Object> r = this.updateCounter(tensor2, tensor2Counter, tensor2Offset, tensor2Dim2);
                            hasFinished = r._1$mcZ$sp();
                            tensor2Offset = r._2$mcI$sp();
                            i2 = 0;
                        }
                        if (i3 != tensor3Size2) continue;
                        Tuple2<Object, Object> r = this.updateCounter(tensor3, tensor3Counter, tensor3Offset, tensor3Dim2);
                        hasFinished = r._1$mcZ$sp();
                        tensor3Offset = r._2$mcI$sp();
                        i3 = 0;
                    }
                }
                throw new MatchError(tuple23);
            }
            throw new MatchError(tuple22);
        }
        throw new MatchError(tuple2);
    }

    public <T> int getStride(Tensor<T> tensor) {
        for (int d = tensor.nDimension(); d > 0; --d) {
            if (tensor.size(d) == 1) continue;
            return tensor.stride(d);
        }
        return 0;
    }

    public <T> Tuple2<Object, Object> getLargestContiguousSize(Tensor<T> tensor) {
        int largestDim;
        int largestSize = 1;
        for (largestDim = tensor.nDimension(); largestDim > 0; --largestDim) {
            if (tensor.size(largestDim) == 1) continue;
            if (tensor.stride(largestDim) == largestSize) {
                largestSize *= tensor.size(largestDim);
                continue;
            }
            return new Tuple2.mcII.sp(largestDim, largestSize);
        }
        return new Tuple2.mcII.sp(largestDim, largestSize);
    }

    /*
     * WARNING - void declaration
     */
    public int[] getCounter(int largestDim) {
        void var2_2;
        int[] counter = new int[largestDim];
        for (int d = 0; d < largestDim; ++d) {
            counter[d] = 0;
        }
        return var2_2;
    }

    public <T> Tuple2<Object, Object> updateCounter(Tensor<T> tensor, int[] counter, int offset, int dim) {
        if (dim == 0) {
            return new Tuple2.mcZI.sp(true, offset);
        }
        int _offset = offset;
        for (int i = dim; i > 0; --i) {
            int n = i - 1;
            counter[n] = counter[n] + 1;
            _offset += tensor.stride(i);
            if (counter[i - 1] == tensor.size(i)) {
                if (i == 1) {
                    return new Tuple2.mcZI.sp(true, _offset);
                }
                _offset -= counter[i - 1] * tensor.stride(i);
                counter[i - 1] = 0;
                continue;
            }
            return new Tuple2.mcZI.sp(false, _offset);
        }
        return new Tuple2.mcZI.sp(false, _offset);
    }

    public <A, B, C> void apply2(Tensor<A> tensor1, Tensor<B> tensor2, Tensor<C> tensor3, TensorDiffTypeFunc6<A, B, C> func) {
        Log4Error$.MODULE$.unKnowExceptionError(tensor1.nElement() == tensor2.nElement(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"inconsistent tensor size: ", " == ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)tensor1.nElement()), BoxesRunTime.boxToInteger((int)tensor2.nElement())})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (tensor1.isEmpty()) {
            return;
        }
        if (tensor1.isScalar() && tensor2.isScalar()) {
            Object tensor1Data = tensor1.storage().array();
            Object tensor2Data = tensor2.storage().array();
            Object tensor3Data = tensor3.storage().array();
            int tensor1Index = tensor1.storageOffset() - 1;
            int tensor2Index = tensor2.storageOffset() - 1;
            int tensor3Index = tensor3.storageOffset() - 1;
            func.apply(tensor1Data, tensor1Index, tensor2Data, tensor2Index, tensor3Data, tensor3Index);
            return;
        }
        Object tensor1Data = tensor1.storage().array();
        int tensor1Offset = tensor1.storageOffset() - 1;
        Object tensor2Data = tensor2.storage().array();
        int tensor2Offset = tensor2.storageOffset() - 1;
        Object tensor3Data = tensor3.storage().array();
        int tensor3Offset = tensor3.storageOffset() - 1;
        boolean adjacent = false;
        if (tensor1.nDimension() == 1 && tensor2.nDimension() == 1 && tensor1.stride(1) == 1 && tensor2.stride(1) == 1) {
            adjacent = true;
        }
        if (tensor1.nDimension() == 2 && tensor2.nDimension() == 2) {
            if (tensor1.stride(2) == 1 && tensor2.stride(2) == 1 && tensor1.stride(1) == tensor1.size(2) && tensor2.stride(1) == tensor2.size(2)) {
                adjacent = true;
            }
            if (tensor1.stride(1) == 1 && tensor2.stride(1) == 1 && tensor1.stride(2) == tensor1.size(1) && tensor2.stride(2) == tensor2.size(1)) {
                adjacent = true;
            }
        }
        if (adjacent) {
            for (int i = 0; i < tensor1.nElement(); ++i) {
                func.apply(tensor1Data, tensor1Offset + i, tensor2Data, tensor2Offset + i, tensor3Data, tensor3Offset + i);
            }
            return;
        }
        int tensor1Stride = this.getStride(tensor1);
        Tuple2<Object, Object> tuple2 = this.getLargestContiguousSize(tensor1);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int largestDim1 = tuple2._1$mcI$sp();
            int largestSize1 = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(largestDim1, largestSize1);
            int largestDim12 = sp3._1$mcI$sp();
            int largestSize12 = sp3._2$mcI$sp();
            int[] counter1 = this.getCounter(largestDim12);
            int tensor2Stride = this.getStride(tensor2);
            Tuple2<Object, Object> tuple22 = this.getLargestContiguousSize(tensor2);
            if (tuple22 != null) {
                Tuple2.mcII.sp sp4;
                int largestDim2 = tuple22._1$mcI$sp();
                int largestSize2 = tuple22._2$mcI$sp();
                Tuple2.mcII.sp sp5 = sp4 = new Tuple2.mcII.sp(largestDim2, largestSize2);
                int largestDim22 = sp5._1$mcI$sp();
                int largestSize22 = sp5._2$mcI$sp();
                int[] counter2 = this.getCounter(largestDim22);
                int tensor3Stride = this.getStride(tensor3);
                Tuple2<Object, Object> tuple23 = this.getLargestContiguousSize(tensor3);
                if (tuple23 != null) {
                    Tuple2.mcII.sp sp6;
                    int largestDim3 = tuple23._1$mcI$sp();
                    int largestSize3 = tuple23._2$mcI$sp();
                    Tuple2.mcII.sp sp7 = sp6 = new Tuple2.mcII.sp(largestDim3, largestSize3);
                    int largestDim32 = sp7._1$mcI$sp();
                    int largestSize32 = sp7._2$mcI$sp();
                    int[] counter3 = this.getCounter(largestDim32);
                    boolean hasFinished = false;
                    int i1 = 0;
                    int i2 = 0;
                    int i3 = 0;
                    while (true) {
                        if (hasFinished) {
                            return;
                        }
                        while (i1 < largestSize12 && i2 < largestSize22) {
                            func.apply(tensor1Data, tensor1Offset + i1 * tensor1Stride, tensor2Data, tensor2Offset + i2 * tensor2Stride, tensor3Data, tensor3Offset + i3 * tensor3Stride);
                            ++i1;
                            ++i2;
                            ++i3;
                        }
                        if (i1 == largestSize12) {
                            Tuple2<Object, Object> r = this.updateCounter(tensor1, counter1, tensor1Offset, largestDim12);
                            hasFinished = r._1$mcZ$sp();
                            tensor1Offset = r._2$mcI$sp();
                            i1 = 0;
                        }
                        if (i2 == largestSize22) {
                            Tuple2<Object, Object> r = this.updateCounter(tensor2, counter2, tensor2Offset, largestDim22);
                            hasFinished = r._1$mcZ$sp();
                            tensor2Offset = r._2$mcI$sp();
                            i2 = 0;
                        }
                        if (i3 != largestSize32) continue;
                        Tuple2<Object, Object> r = this.updateCounter(tensor3, counter3, tensor3Offset, largestDim32);
                        hasFinished = r._1$mcZ$sp();
                        tensor2Offset = r._2$mcI$sp();
                        i3 = 0;
                    }
                }
                throw new MatchError(tuple23);
            }
            throw new MatchError(tuple22);
        }
        throw new MatchError(tuple2);
    }

    public void apply1$mDc$sp(Tensor<Object> tensor, TensorFunc2<Object> func) {
        if (tensor.isEmpty()) {
            return;
        }
        if (tensor.isScalar()) {
            double[] data2 = (double[])tensor.storage().array();
            int index = tensor.storageOffset() - 1;
            func.apply$mcD$sp(data2, index);
            return;
        }
        int stride = this.getStride(tensor);
        Tuple2<Object, Object> tuple2 = this.getLargestContiguousSize(tensor);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int largestDim = tuple2._1$mcI$sp();
            int largestSize = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(largestDim, largestSize);
            int largestDim2 = sp3._1$mcI$sp();
            int largestSize2 = sp3._2$mcI$sp();
            int[] counter = this.getCounter(largestDim2);
            double[] data3 = (double[])tensor.storage().array();
            int offset = tensor.storageOffset() - 1;
            boolean hasFinished = false;
            int i = 0;
            while (true) {
                if (hasFinished) {
                    return;
                }
                while (i < largestSize2) {
                    int index = offset + i * stride;
                    func.apply$mcD$sp(data3, index);
                    ++i;
                }
                Tuple2<Object, Object> r = this.updateCounter(tensor, counter, offset, largestDim2);
                hasFinished = r._1$mcZ$sp();
                offset = r._2$mcI$sp();
                i = 0;
            }
        }
        throw new MatchError(tuple2);
    }

    public void apply1$mFc$sp(Tensor<Object> tensor, TensorFunc2<Object> func) {
        if (tensor.isEmpty()) {
            return;
        }
        if (tensor.isScalar()) {
            float[] data2 = (float[])tensor.storage().array();
            int index = tensor.storageOffset() - 1;
            func.apply$mcF$sp(data2, index);
            return;
        }
        int stride = this.getStride(tensor);
        Tuple2<Object, Object> tuple2 = this.getLargestContiguousSize(tensor);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int largestDim = tuple2._1$mcI$sp();
            int largestSize = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(largestDim, largestSize);
            int largestDim2 = sp3._1$mcI$sp();
            int largestSize2 = sp3._2$mcI$sp();
            int[] counter = this.getCounter(largestDim2);
            float[] data3 = (float[])tensor.storage().array();
            int offset = tensor.storageOffset() - 1;
            boolean hasFinished = false;
            int i = 0;
            while (true) {
                if (hasFinished) {
                    return;
                }
                while (i < largestSize2) {
                    int index = offset + i * stride;
                    func.apply$mcF$sp(data3, index);
                    ++i;
                }
                Tuple2<Object, Object> r = this.updateCounter(tensor, counter, offset, largestDim2);
                hasFinished = r._1$mcZ$sp();
                offset = r._2$mcI$sp();
                i = 0;
            }
        }
        throw new MatchError(tuple2);
    }

    public void apply3$mDc$sp(Tensor<Object> tensor1, Tensor<Object> tensor2, Tensor<Object> tensor3, TensorFunc6<Object> func) {
        Log4Error$.MODULE$.unKnowExceptionError(tensor1.nElement() == tensor2.nElement() && tensor2.nElement() == tensor3.nElement(), "inconsistent tensor size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (tensor1.isEmpty()) {
            return;
        }
        if (tensor1.isScalar() && tensor2.isScalar() && tensor3.isScalar()) {
            double[] tensor1Data = (double[])tensor1.storage().array();
            double[] tensor2Data = (double[])tensor2.storage().array();
            double[] tensor3Data = (double[])tensor3.storage().array();
            int tensor1Index = tensor1.storageOffset() - 1;
            int tensor2Index = tensor2.storageOffset() - 1;
            int tensor3Index = tensor3.storageOffset() - 1;
            func.apply$mcD$sp(tensor1Data, tensor1Index, tensor2Data, tensor2Index, tensor3Data, tensor3Index);
            return;
        }
        double[] tensor1Data = (double[])tensor1.storage().array();
        int tensor1Offset = tensor1.storageOffset() - 1;
        int tensor1Stride = this.getStride(tensor1);
        Tuple2<Object, Object> tuple2 = this.getLargestContiguousSize(tensor1);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int tensor1Dim = tuple2._1$mcI$sp();
            int tensor1Size = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(tensor1Dim, tensor1Size);
            int tensor1Dim2 = sp3._1$mcI$sp();
            int tensor1Size2 = sp3._2$mcI$sp();
            int[] tensor1Counter = this.getCounter(tensor1Dim2);
            double[] tensor2Data = (double[])tensor2.storage().array();
            int tensor2Offset = tensor2.storageOffset() - 1;
            int tensor2Stride = this.getStride(tensor2);
            Tuple2<Object, Object> tuple22 = this.getLargestContiguousSize(tensor2);
            if (tuple22 != null) {
                Tuple2.mcII.sp sp4;
                int tensor2Dim = tuple22._1$mcI$sp();
                int tensor2Size = tuple22._2$mcI$sp();
                Tuple2.mcII.sp sp5 = sp4 = new Tuple2.mcII.sp(tensor2Dim, tensor2Size);
                int tensor2Dim2 = sp5._1$mcI$sp();
                int tensor2Size2 = sp5._2$mcI$sp();
                int[] tensor2Counter = this.getCounter(tensor2Dim2);
                double[] tensor3Data = (double[])tensor3.storage().array();
                int tensor3Offset = tensor3.storageOffset() - 1;
                int tensor3Stride = this.getStride(tensor3);
                Tuple2<Object, Object> tuple23 = this.getLargestContiguousSize(tensor3);
                if (tuple23 != null) {
                    Tuple2.mcII.sp sp6;
                    int tensor3Dim = tuple23._1$mcI$sp();
                    int tensor3Size = tuple23._2$mcI$sp();
                    Tuple2.mcII.sp sp7 = sp6 = new Tuple2.mcII.sp(tensor3Dim, tensor3Size);
                    int tensor3Dim2 = sp7._1$mcI$sp();
                    int tensor3Size2 = sp7._2$mcI$sp();
                    int[] tensor3Counter = this.getCounter(tensor3Dim2);
                    boolean hasFinished = false;
                    int i1 = 0;
                    int i2 = 0;
                    int i3 = 0;
                    while (true) {
                        if (hasFinished) {
                            return;
                        }
                        while (i1 < tensor1Size2 && i2 < tensor2Size2 && i3 < tensor3Size2) {
                            func.apply$mcD$sp(tensor1Data, tensor1Offset + i1 * tensor1Stride, tensor2Data, tensor2Offset + i2 * tensor2Stride, tensor3Data, tensor3Offset + i3 * tensor3Stride);
                            ++i1;
                            ++i2;
                            ++i3;
                        }
                        if (i1 == tensor1Size2) {
                            Tuple2<Object, Object> r = this.updateCounter(tensor1, tensor1Counter, tensor1Offset, tensor1Dim2);
                            hasFinished = r._1$mcZ$sp();
                            tensor1Offset = r._2$mcI$sp();
                            i1 = 0;
                        }
                        if (i2 == tensor2Size2) {
                            Tuple2<Object, Object> r = this.updateCounter(tensor2, tensor2Counter, tensor2Offset, tensor2Dim2);
                            hasFinished = r._1$mcZ$sp();
                            tensor2Offset = r._2$mcI$sp();
                            i2 = 0;
                        }
                        if (i3 != tensor3Size2) continue;
                        Tuple2<Object, Object> r = this.updateCounter(tensor3, tensor3Counter, tensor3Offset, tensor3Dim2);
                        hasFinished = r._1$mcZ$sp();
                        tensor3Offset = r._2$mcI$sp();
                        i3 = 0;
                    }
                }
                throw new MatchError(tuple23);
            }
            throw new MatchError(tuple22);
        }
        throw new MatchError(tuple2);
    }

    public void apply3$mFc$sp(Tensor<Object> tensor1, Tensor<Object> tensor2, Tensor<Object> tensor3, TensorFunc6<Object> func) {
        Log4Error$.MODULE$.unKnowExceptionError(tensor1.nElement() == tensor2.nElement() && tensor2.nElement() == tensor3.nElement(), "inconsistent tensor size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (tensor1.isEmpty()) {
            return;
        }
        if (tensor1.isScalar() && tensor2.isScalar() && tensor3.isScalar()) {
            float[] tensor1Data = (float[])tensor1.storage().array();
            float[] tensor2Data = (float[])tensor2.storage().array();
            float[] tensor3Data = (float[])tensor3.storage().array();
            int tensor1Index = tensor1.storageOffset() - 1;
            int tensor2Index = tensor2.storageOffset() - 1;
            int tensor3Index = tensor3.storageOffset() - 1;
            func.apply$mcF$sp(tensor1Data, tensor1Index, tensor2Data, tensor2Index, tensor3Data, tensor3Index);
            return;
        }
        float[] tensor1Data = (float[])tensor1.storage().array();
        int tensor1Offset = tensor1.storageOffset() - 1;
        int tensor1Stride = this.getStride(tensor1);
        Tuple2<Object, Object> tuple2 = this.getLargestContiguousSize(tensor1);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int tensor1Dim = tuple2._1$mcI$sp();
            int tensor1Size = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(tensor1Dim, tensor1Size);
            int tensor1Dim2 = sp3._1$mcI$sp();
            int tensor1Size2 = sp3._2$mcI$sp();
            int[] tensor1Counter = this.getCounter(tensor1Dim2);
            float[] tensor2Data = (float[])tensor2.storage().array();
            int tensor2Offset = tensor2.storageOffset() - 1;
            int tensor2Stride = this.getStride(tensor2);
            Tuple2<Object, Object> tuple22 = this.getLargestContiguousSize(tensor2);
            if (tuple22 != null) {
                Tuple2.mcII.sp sp4;
                int tensor2Dim = tuple22._1$mcI$sp();
                int tensor2Size = tuple22._2$mcI$sp();
                Tuple2.mcII.sp sp5 = sp4 = new Tuple2.mcII.sp(tensor2Dim, tensor2Size);
                int tensor2Dim2 = sp5._1$mcI$sp();
                int tensor2Size2 = sp5._2$mcI$sp();
                int[] tensor2Counter = this.getCounter(tensor2Dim2);
                float[] tensor3Data = (float[])tensor3.storage().array();
                int tensor3Offset = tensor3.storageOffset() - 1;
                int tensor3Stride = this.getStride(tensor3);
                Tuple2<Object, Object> tuple23 = this.getLargestContiguousSize(tensor3);
                if (tuple23 != null) {
                    Tuple2.mcII.sp sp6;
                    int tensor3Dim = tuple23._1$mcI$sp();
                    int tensor3Size = tuple23._2$mcI$sp();
                    Tuple2.mcII.sp sp7 = sp6 = new Tuple2.mcII.sp(tensor3Dim, tensor3Size);
                    int tensor3Dim2 = sp7._1$mcI$sp();
                    int tensor3Size2 = sp7._2$mcI$sp();
                    int[] tensor3Counter = this.getCounter(tensor3Dim2);
                    boolean hasFinished = false;
                    int i1 = 0;
                    int i2 = 0;
                    int i3 = 0;
                    while (true) {
                        if (hasFinished) {
                            return;
                        }
                        while (i1 < tensor1Size2 && i2 < tensor2Size2 && i3 < tensor3Size2) {
                            func.apply$mcF$sp(tensor1Data, tensor1Offset + i1 * tensor1Stride, tensor2Data, tensor2Offset + i2 * tensor2Stride, tensor3Data, tensor3Offset + i3 * tensor3Stride);
                            ++i1;
                            ++i2;
                            ++i3;
                        }
                        if (i1 == tensor1Size2) {
                            Tuple2<Object, Object> r = this.updateCounter(tensor1, tensor1Counter, tensor1Offset, tensor1Dim2);
                            hasFinished = r._1$mcZ$sp();
                            tensor1Offset = r._2$mcI$sp();
                            i1 = 0;
                        }
                        if (i2 == tensor2Size2) {
                            Tuple2<Object, Object> r = this.updateCounter(tensor2, tensor2Counter, tensor2Offset, tensor2Dim2);
                            hasFinished = r._1$mcZ$sp();
                            tensor2Offset = r._2$mcI$sp();
                            i2 = 0;
                        }
                        if (i3 != tensor3Size2) continue;
                        Tuple2<Object, Object> r = this.updateCounter(tensor3, tensor3Counter, tensor3Offset, tensor3Dim2);
                        hasFinished = r._1$mcZ$sp();
                        tensor3Offset = r._2$mcI$sp();
                        i3 = 0;
                    }
                }
                throw new MatchError(tuple23);
            }
            throw new MatchError(tuple22);
        }
        throw new MatchError(tuple2);
    }

    private DenseTensorApply$() {
        MODULE$ = this;
    }
}

