/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.tensor;

import com.intel.analytics.bigdl.dllib.tensor.ArrayStorage;
import com.intel.analytics.bigdl.dllib.tensor.ArrayStorage$mcD$sp;
import com.intel.analytics.bigdl.dllib.tensor.ArrayStorage$mcF$sp;
import com.intel.analytics.bigdl.dllib.tensor.ConvertableFrom$ConvertableFromDouble$;
import com.intel.analytics.bigdl.dllib.tensor.ConvertableFrom$ConvertableFromInt$;
import com.intel.analytics.bigdl.dllib.tensor.DenseTensor;
import com.intel.analytics.bigdl.dllib.tensor.DenseTensor$;
import com.intel.analytics.bigdl.dllib.tensor.DenseTensor$mcD$sp;
import com.intel.analytics.bigdl.dllib.tensor.DenseTensor$mcF$sp;
import com.intel.analytics.bigdl.dllib.tensor.DenseTensorApply$;
import com.intel.analytics.bigdl.dllib.tensor.SparseTensor;
import com.intel.analytics.bigdl.dllib.tensor.Storage$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc4;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc4$class;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc4$mcD$sp;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc4$mcD$sp$class;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc4$mcF$sp;
import com.intel.analytics.bigdl.dllib.tensor.TensorFunc4$mcF$sp$class;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.RandomGenerator$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class DenseTensor$
implements Serializable {
    public static final DenseTensor$ MODULE$;

    static {
        new DenseTensor$();
    }

    public <T> Tensor<T> apply(T value2, ClassTag<T> evidence$16, TensorNumericMath.TensorNumeric<T> ev) {
        return new DenseTensor<T>(new ArrayStorage<T>(Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value2}), evidence$16), evidence$16), 0, (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), 0, evidence$16, ev);
    }

    public <T> Tensor<T> squeeze(DenseTensor<T> self) {
        int ndim = 0;
        for (int d = 0; d < self.nDimension(); ++d) {
            if (self._size()[d] == 1) continue;
            if (d != ndim) {
                self._size()[ndim] = self._size()[d];
                self._stride()[ndim] = self._stride()[d];
            }
            ++ndim;
        }
        if (ndim == 0 && self.nDimension() > 0) {
            self._size()[0] = 1;
            self._stride()[0] = 1;
            ndim = 1;
        }
        self.nDimension_$eq(ndim);
        return self;
    }

    public <T> Tensor<T> squeeze(DenseTensor<T> self, int _dim) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < self.nDimension(), "dimension out of range", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (self._size()[_dim] == 1 && self.nDimension() > 1) {
            for (int d = _dim; d < self.nDimension() - 1; ++d) {
                self._size()[d] = self._size()[d + 1];
                self._stride()[d] = self._stride()[d + 1];
            }
            self.nDimension_$eq(self.nDimension() - 1);
        }
        return self;
    }

    public <T> DenseTensor<T> newWithStorage(DenseTensor<T> tensor, ArrayStorage<T> storage, int storageOffset, int[] size, int[] stride, TensorNumericMath.TensorNumeric<T> ev, ClassTag<T> evidence$17) {
        DenseTensor<T> self;
        if (size != null && stride != null) {
            Log4Error$.MODULE$.unKnowExceptionError(size.length == stride.length, "inconsistent size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        }
        TensorNumericMath.TensorNumeric<T> ev2 = ev;
        DenseTensor<T> denseTensor = self = tensor == null ? new DenseTensor<T>(evidence$17, ev2) : tensor;
        int nDimension = size != null ? size.length : (stride != null ? stride.length : 0);
        return this.rawSet(self, storage, storageOffset, nDimension, size, stride, evidence$17);
    }

    public <T> DenseTensor<T> newWithTensor(DenseTensor<T> other, ClassTag<T> evidence$18, TensorNumericMath.TensorNumeric<T> ev) {
        DenseTensor<T> self = new DenseTensor<T>(evidence$18, ev);
        return this.rawSet(self, other._storage(), other._storageOffset(), other.nDimension(), other._size(), other._stride(), evidence$18);
    }

    public <T> DenseTensor<T> rawSet(DenseTensor<T> self, ArrayStorage<T> storage, int storageOffset, int nDimension, int[] _size, int[] _stride, ClassTag<T> evidence$19) {
        self._storage_$eq(storage);
        Log4Error$.MODULE$.unKnowExceptionError(storageOffset >= 0, "Tensor: invalid storage offset", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        self._storageOffset_$eq(storageOffset);
        return this.rawResize(self, nDimension, _size, _stride, evidence$19);
    }

    public <T> DenseTensor<T> rawResize(DenseTensor<T> self, int nDim, int[] _size, int[] _stride, ClassTag<T> evidence$20) {
        Object object;
        if (nDim == 0 && Predef$.MODULE$.intArrayOps(_size).isEmpty()) {
            Object object2;
            self._size_$eq((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()));
            self._stride_$eq((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()));
            self.nDimension_$eq(nDim);
            int totalSize = 1;
            if (self._storage() == null) {
                self._storage_$eq(new ArrayStorage<T>(evidence$20.newArray(totalSize + self._storageOffset()), evidence$20));
                object2 = BoxedUnit.UNIT;
            } else {
                object2 = totalSize + self._storageOffset() > self._storage().length() ? self._storage().resize(totalSize + self._storageOffset()) : BoxedUnit.UNIT;
            }
            return self;
        }
        boolean hasCorrectSize = true;
        int nDim_ = 0;
        for (int d = 0; d < nDim; ++d) {
            ++nDim_;
            if (self.nDimension() > d && _size[d] != self._size()[d]) {
                hasCorrectSize = false;
            }
            if (self.nDimension() <= d || _stride == null || _stride[d] < 0 || _stride[d] == self._stride()[d]) continue;
            hasCorrectSize = false;
        }
        if (nDim_ != self.nDimension()) {
            hasCorrectSize = false;
        }
        if (hasCorrectSize) {
            return self;
        }
        if (nDim_ > 0) {
            if (nDim_ != self.nDimension()) {
                self._size_$eq(new int[nDim]);
                self._stride_$eq(new int[nDim]);
                self.nDimension_$eq(nDim);
            }
            int totalSize = 1;
            for (int d = self.nDimension() - 1; d >= 0; --d) {
                self._size()[d] = _size[d];
                self._stride()[d] = _stride != null && _stride[d] >= 0 ? _stride[d] : (d == self.nDimension() - 1 ? 1 : self._size()[d + 1] * self._stride()[d + 1]);
                totalSize += (self._size()[d] - 1) * self._stride()[d];
            }
            if (totalSize + self._storageOffset() > 0) {
                if (self._storage() == null) {
                    self._storage_$eq(new ArrayStorage<T>(evidence$20.newArray(totalSize + self._storageOffset()), evidence$20));
                    object = BoxedUnit.UNIT;
                } else {
                    object = totalSize + self._storageOffset() > self._storage().length() ? self._storage().resize(totalSize + self._storageOffset()) : BoxedUnit.UNIT;
                }
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            self.nDimension_$eq(0);
            object = BoxedUnit.UNIT;
        }
        return self;
    }

    public <T> DenseTensor<T> newClone(DenseTensor<T> self, ClassTag<T> evidence$21, TensorNumericMath.TensorNumeric<T> ev) {
        DenseTensor<T> tensor = new DenseTensor<T>(evidence$21, ev);
        this.resizeAs(tensor, self, evidence$21);
        this.copy(tensor, self);
        return tensor;
    }

    public <T> DenseTensor<T> newContiguous(DenseTensor<T> self, ClassTag<T> evidence$22, TensorNumericMath.TensorNumeric<T> ev) {
        return this.isContiguous(self) ? self : this.newClone(self, evidence$22, ev);
    }

    public <T> DenseTensor<T> newSelect(DenseTensor<T> self, int _dimension, int _sliceIndex, ClassTag<T> evidence$23, TensorNumericMath.TensorNumeric<T> ev) {
        DenseTensor<T> tensor = this.newWithTensor(self, evidence$23, ev);
        this.select(tensor, null, _dimension, _sliceIndex, evidence$23);
        return tensor;
    }

    public <T> DenseTensor<T> newNarrow(DenseTensor<T> self, int _dimension, int _firstIndex, int _size, ClassTag<T> evidence$24, TensorNumericMath.TensorNumeric<T> ev) {
        DenseTensor<T> tensor = this.newWithTensor(self, evidence$24, ev);
        this.narrow(tensor, null, _dimension, _firstIndex, _size, evidence$24);
        return tensor;
    }

    public <T> DenseTensor<T> newTranspose(DenseTensor<T> self, int _dimension1, int _dimension2, ClassTag<T> evidence$25, TensorNumericMath.TensorNumeric<T> ev) {
        DenseTensor<T> tensor = this.newWithTensor(self, evidence$25, ev);
        this.transpose(tensor, null, _dimension1, _dimension2, evidence$25);
        return tensor;
    }

    public <T> void resizeAs(DenseTensor<T> self, Tensor<?> src, ClassTag<T> evidence$26) {
        if (!this.isSameSizeAs(self, src)) {
            this.rawResize(self, src.nDimension(), src.size(), null, evidence$26);
        }
    }

    public <T> DenseTensor<T> resize(DenseTensor<T> self, int[] sizes, int[] strides, ClassTag<T> evidence$27) {
        Log4Error$.MODULE$.unKnowExceptionError(sizes != null, "invalid size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (strides != null) {
            Log4Error$.MODULE$.unKnowExceptionError(sizes.length == strides.length, "invalid stride", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        }
        return this.rawResize(self, sizes.length, sizes, strides, evidence$27);
    }

    public <T> int[] resize$default$3() {
        return null;
    }

    public <T> boolean isSameSizeAs(DenseTensor<T> self, Tensor<?> src) {
        if (self.nDimension() != src.nDimension()) {
            return false;
        }
        if (self.isEmpty() != src.isEmpty()) {
            return false;
        }
        for (int d = 0; d < self.nDimension(); ++d) {
            if (self.size(d + 1) == src.size(d + 1)) continue;
            return false;
        }
        return true;
    }

    public <T> boolean isContiguous(DenseTensor<T> self) {
        int s2 = 1;
        for (int d = self.nDimension() - 1; d >= 0; --d) {
            if (self._size()[d] == 1) continue;
            if (s2 != self._stride()[d]) {
                return false;
            }
            s2 *= self._size()[d];
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public int[] size2Stride(int[] sizes) {
        void var2_2;
        int[] strides = new int[sizes.length];
        int jump = 1;
        for (int i = strides.length - 1; i >= 0; --i) {
            strides[i] = jump;
            jump *= sizes[i];
        }
        return var2_2;
    }

    public <T> Tensor<T> set(DenseTensor<T> self, DenseTensor<T> other, ClassTag<T> evidence$28) {
        DenseTensor<T> denseTensor = self;
        DenseTensor<T> denseTensor2 = other;
        return !(denseTensor != null ? !((Object)denseTensor).equals(denseTensor2) : denseTensor2 != null) ? self : this.rawSet(self, (ArrayStorage)other.storage(), other.storageOffset(), other.nDimension(), other.size(), other.stride(), evidence$28);
    }

    /*
     * WARNING - void declaration
     */
    public <T> int offsetFromIndice(DenseTensor<T> self, int[] indexes) {
        void var3_3;
        int offset = self._storageOffset();
        for (int d = 0; d < indexes.length; ++d) {
            offset += (indexes[d] - 1) * self._stride()[d];
        }
        return (int)var3_3;
    }

    public <T> void select(DenseTensor<T> self, DenseTensor<T> source, int _dimension, int _sliceIndex, ClassTag<T> evidence$29) {
        DenseTensor<T> src = source;
        if (src == null) {
            src = self;
        }
        Log4Error$.MODULE$.unKnowExceptionError(src.nDimension() > 0, "cannot select on a scalar", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(_dimension >= 0 && _dimension < src.nDimension(), "out of range", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(_sliceIndex >= 0 && _sliceIndex < src.size(_dimension + 1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " out of range 0 to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)_sliceIndex), BoxesRunTime.boxToInteger((int)(src.size(_dimension + 1) - 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        this.set(self, src, evidence$29);
        this.narrow(self, null, _dimension, _sliceIndex, 1, evidence$29);
        for (int d = _dimension; d < self.nDimension() - 1; ++d) {
            self._size()[d] = self._size()[d + 1];
            self._stride()[d] = self._stride()[d + 1];
        }
        self.nDimension_$eq(self.nDimension() - 1);
    }

    public <T> void narrow(DenseTensor<T> self, DenseTensor<T> source, int _dimension, int _firstIndex, int size, ClassTag<T> evidence$30) {
        DenseTensor<T> src = source;
        if (src == null) {
            src = self;
        }
        Log4Error$.MODULE$.unKnowExceptionError(_dimension >= 0 && _dimension < src.nDimension(), "dimension out of range", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(_firstIndex >= 0 && _firstIndex < src.size(_dimension + 1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"firstIndex(", ") out of range [0, ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)_firstIndex), BoxesRunTime.boxToInteger((int)src.size(_dimension + 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(size > 0 && _firstIndex + size <= src.size(_dimension + 1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size out of range ", " (0, ", " - ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size), BoxesRunTime.boxToInteger((int)src.size(_dimension + 1)), BoxesRunTime.boxToInteger((int)_firstIndex)})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        this.set(self, src, evidence$30);
        if (_firstIndex > 0) {
            self._storageOffset_$eq(self._storageOffset() + _firstIndex * self._stride()[_dimension]);
        }
        self._size()[_dimension] = size;
    }

    public <T> void transpose(DenseTensor<T> self, DenseTensor<T> source, int _dimension1, int _dimension2, ClassTag<T> evidence$31) {
        DenseTensor<T> src = source;
        if (src == null) {
            src = self;
        }
        Log4Error$.MODULE$.unKnowExceptionError(_dimension1 >= 0 && _dimension1 < src.nDimension(), "out of range", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(_dimension2 >= 0 && _dimension2 < src.nDimension(), "out of range", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        this.set(self, src, evidence$31);
        if (_dimension1 == _dimension2) {
            return;
        }
        int z = self._stride()[_dimension1];
        self._stride()[_dimension1] = self._stride()[_dimension2];
        self._stride()[_dimension2] = z;
        z = self._size()[_dimension1];
        self._size()[_dimension1] = self._size()[_dimension2];
        self._size()[_dimension2] = z;
    }

    public <T> T get1d(DenseTensor<T> self, int x0) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nDimension() != 0, "tensor must have one dimension", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(x0 >= 0 && x0 < self._size()[0], "out of range", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        return self._storage().apply(self._storageOffset() + x0 * self._stride()[0]);
    }

    public <T> DenseTensor<T> get1dTensor(DenseTensor<T> self, int x0, ClassTag<T> evidence$32, TensorNumericMath.TensorNumeric<T> ev) {
        return new DenseTensor<T>(new ArrayStorage<T>(Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.get1d(self, x0)}), evidence$32), evidence$32), evidence$32, ev);
    }

    public <T> void copy(DenseTensor<T> self, Tensor<T> src) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == src.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self element number(", ") is not"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" equal to source element number(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)src.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (self.isEmpty()) {
            return;
        }
        if (self.isContiguous() && src.isContiguous() && this.sameStride(self.stride(), src.stride())) {
            System.arraycopy(src.storage().array(), src.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1, self.nElement());
            return;
        }
        TensorFunc4 func2 = new TensorFunc4<T>(){

            public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
            }

            public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
            }

            public String toString() {
                return TensorFunc4$class.toString(this);
            }

            public void apply(Object data1, int offset1, Object data2, int offset2) {
                ScalaRunTime$.MODULE$.array_update(data1, offset1, ScalaRunTime$.MODULE$.array_apply(data2, offset2));
            }
            {
                TensorFunc4$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply2(self, src, func2);
    }

    public <T> Tensor<T> randperm(int size, ClassTag<T> evidence$33, TensorNumericMath.TensorNumeric<T> ev) {
        int i;
        Log4Error$.MODULE$.unKnowExceptionError(size >= 1, "invalid size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Object array = evidence$33.newArray(size);
        for (i = 1; i <= size; ++i) {
            ScalaRunTime$.MODULE$.array_update(array, i - 1, ev.fromType(BoxesRunTime.boxToInteger((int)i), ConvertableFrom$ConvertableFromInt$.MODULE$));
        }
        for (i = 0; i < size - 1; ++i) {
            int rand = (int)Math.floor(RandomGenerator$.MODULE$.RNG().random() % (long)(size - i));
            Object tmp = ScalaRunTime$.MODULE$.array_apply(array, i);
            ScalaRunTime$.MODULE$.array_update(array, i, ScalaRunTime$.MODULE$.array_apply(array, rand + i));
            ScalaRunTime$.MODULE$.array_update(array, rand + i, tmp);
        }
        return Tensor$.MODULE$.apply(new ArrayStorage<T>(array, evidence$33), evidence$33, ev);
    }

    public boolean sameStride(int[] l, int[] r) {
        if (l.length != r.length) {
            return false;
        }
        for (int i = 0; i < l.length; ++i) {
            if (l[i] == r[i]) continue;
            return false;
        }
        return true;
    }

    public <T> Tensor<T> range(double xmin, double xmax, int step, ClassTag<T> evidence$34, TensorNumericMath.TensorNumeric<T> ev) {
        Tensor<T> newTensor = Tensor$.MODULE$.apply(evidence$34, ev);
        return newTensor.range(xmin, xmax, step);
    }

    public <T> int range$default$3() {
        return 1;
    }

    public <T> Tensor<T> ones(int[] sizes, ClassTag<T> evidence$35, TensorNumericMath.TensorNumeric<T> ev) {
        int length = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(sizes).product((Numeric)Numeric.IntIsIntegral$.MODULE$));
        return Tensor$.MODULE$.apply(Storage$.MODULE$.apply(evidence$35.newArray(length), evidence$35), 1, sizes, Tensor$.MODULE$.apply$default$4(), evidence$35, ev).fill(ev.fromType(BoxesRunTime.boxToInteger((int)1), ConvertableFrom$ConvertableFromInt$.MODULE$));
    }

    public <T> Tensor<T> gaussian1D(int size, double sigma, int amplitude, boolean normalize, double mean2, Tensor<T> tensor, ClassTag<T> evidence$36, TensorNumericMath.TensorNumeric<T> ev) {
        Tensor tensor2;
        if (tensor == null) {
            tensor2 = Tensor$.MODULE$.apply(size, evidence$36, ev);
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(tensor.dim() == 1, "expecting 1D tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            Log4Error$.MODULE$.unKnowExceptionError(tensor.nElement() > 0, "expecting non-empty tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            tensor2 = tensor;
        }
        Tensor gauss = tensor2;
        double center = mean2 * (double)gauss.nElement() + 0.5;
        for (int i = 1; i <= gauss.nElement(); ++i) {
            gauss.setValue(i, ev.fromType(BoxesRunTime.boxToDouble((double)((double)amplitude * package$.MODULE$.exp(-(package$.MODULE$.pow(((double)i - center) / (sigma * (double)size), 2.0) / (double)2)))), ConvertableFrom$ConvertableFromDouble$.MODULE$));
        }
        Object object = normalize ? gauss.div(gauss.sum()) : BoxedUnit.UNIT;
        return gauss;
    }

    public <T> int gaussian1D$default$1() {
        return 3;
    }

    public <T> double gaussian1D$default$2() {
        return 0.25;
    }

    public <T> int gaussian1D$default$3() {
        return 1;
    }

    public <T> boolean gaussian1D$default$4() {
        return false;
    }

    public <T> double gaussian1D$default$5() {
        return 0.5;
    }

    public <T> Null$ gaussian1D$default$6() {
        return null;
    }

    public <T> boolean canFastBroadcast(Tensor<T> tensor, Tensor<T> other) {
        if (tensor.nDimension() < other.nDimension()) {
            return false;
        }
        int delta = tensor.nDimension() - other.nDimension();
        boolean broadcasting = false;
        for (int d = other.nDimension(); d > 0; --d) {
            if (broadcasting) {
                if (other.size(d) == 1) continue;
                return false;
            }
            if (tensor.size(delta + d) == other.size(d)) continue;
            if (other.size(d) != 1) {
                return false;
            }
            broadcasting = true;
        }
        return true;
    }

    public <T> int[] expandSize(Tensor<T> tensor, Tensor<T> other, ClassTag<T> evidence$37) {
        int i;
        String errorMsg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tensor size not match ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(tensor.size()).mkString("x")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(other.size()).mkString("x")}))).toString();
        Tensor<T> longTensor = tensor.dim() > other.dim() ? tensor : other;
        Tensor<T> shortTensor = tensor.dim() > other.dim() ? other : tensor;
        int ndim = longTensor.nDimension();
        int delta = longTensor.nDimension() - shortTensor.nDimension();
        int[] size = new int[ndim];
        for (i = ndim - 1; i >= delta; --i) {
            Log4Error$.MODULE$.unKnowExceptionError(longTensor.size(i + 1) == shortTensor.size(i + 1 - delta) || longTensor.size(i + 1) == 1 || shortTensor.size(i + 1 - delta) == 1, errorMsg, Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            size[i] = package$.MODULE$.max(longTensor.size(i + 1), shortTensor.size(i + 1 - delta));
        }
        while (i >= 0) {
            size[i] = longTensor.size(i + 1);
            --i;
        }
        return size;
    }

    public <T> Tensor<T> apply(SparseTensor<T> sparseTensor, Tensor<T> res, ClassTag<T> evidence$38, TensorNumericMath.TensorNumeric<T> ev) {
        Tensor<T> dt = res == null ? Tensor$.MODULE$.apply(sparseTensor.size(), evidence$38, ev) : res;
        int[] srcIndex = new int[dt.dim()];
        int[] tgtIndex = new int[dt.dim()];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), sparseTensor._nElement()).foreach$mVc$sp((Function1)new Serializable(sparseTensor, dt, srcIndex, tgtIndex){
            public static final long serialVersionUID = 0L;
            public final SparseTensor sparseTensor$1;
            private final Tensor dt$1;
            public final int[] srcIndex$1;
            public final int[] tgtIndex$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Predef$.MODULE$.intArrayOps(this.srcIndex$1).indices().foreach$mVc$sp((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.apply.1 $outer;
                    private final int i$4;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        this.$outer.srcIndex$1[j] = BoxesRunTime.unboxToInt((Object)this.$outer.sparseTensor$1._indices()[j].apply(this.i$4 + this.$outer.sparseTensor$1._storageOffset())) + 1;
                        this.$outer.tgtIndex$1[j] = this.$outer.srcIndex$1[j] - this.$outer.sparseTensor$1._indicesOffset()[j];
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$4 = i$4;
                    }
                });
                this.dt$1.update(this.tgtIndex$1, this.sparseTensor$1.apply(this.srcIndex$1));
            }
            {
                this.sparseTensor$1 = sparseTensor$1;
                this.dt$1 = dt$1;
                this.srcIndex$1 = srcIndex$1;
                this.tgtIndex$1 = tgtIndex$1;
            }
        });
        return dt;
    }

    public <T> Null$ apply$default$2() {
        return null;
    }

    public <T> int[] $lessinit$greater$default$3() {
        return null;
    }

    public <T> int[] $lessinit$greater$default$4() {
        return null;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public Tensor<Object> apply$mDc$sp(double value2, ClassTag<Object> evidence$16, TensorNumericMath.TensorNumeric<Object> ev) {
        return new DenseTensor$mcD$sp(new ArrayStorage$mcD$sp((double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new double[]{value2}), evidence$16), evidence$16), 0, (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), 0, evidence$16, ev);
    }

    public Tensor<Object> apply$mFc$sp(float value2, ClassTag<Object> evidence$16, TensorNumericMath.TensorNumeric<Object> ev) {
        return new DenseTensor$mcF$sp(new ArrayStorage$mcF$sp((float[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new float[]{value2}), evidence$16), evidence$16), 0, (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), 0, evidence$16, ev);
    }

    public Tensor<Object> squeeze$mDc$sp(DenseTensor<Object> self) {
        int ndim = 0;
        for (int d = 0; d < self.nDimension(); ++d) {
            if (self._size()[d] == 1) continue;
            if (d != ndim) {
                self._size()[ndim] = self._size()[d];
                self._stride()[ndim] = self._stride()[d];
            }
            ++ndim;
        }
        if (ndim == 0 && self.nDimension() > 0) {
            self._size()[0] = 1;
            self._stride()[0] = 1;
            ndim = 1;
        }
        self.nDimension_$eq(ndim);
        return self;
    }

    public Tensor<Object> squeeze$mFc$sp(DenseTensor<Object> self) {
        int ndim = 0;
        for (int d = 0; d < self.nDimension(); ++d) {
            if (self._size()[d] == 1) continue;
            if (d != ndim) {
                self._size()[ndim] = self._size()[d];
                self._stride()[ndim] = self._stride()[d];
            }
            ++ndim;
        }
        if (ndim == 0 && self.nDimension() > 0) {
            self._size()[0] = 1;
            self._stride()[0] = 1;
            ndim = 1;
        }
        self.nDimension_$eq(ndim);
        return self;
    }

    public Tensor<Object> squeeze$mDc$sp(DenseTensor<Object> self, int _dim) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < self.nDimension(), "dimension out of range", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (self._size()[_dim] == 1 && self.nDimension() > 1) {
            for (int d = _dim; d < self.nDimension() - 1; ++d) {
                self._size()[d] = self._size()[d + 1];
                self._stride()[d] = self._stride()[d + 1];
            }
            self.nDimension_$eq(self.nDimension() - 1);
        }
        return self;
    }

    public Tensor<Object> squeeze$mFc$sp(DenseTensor<Object> self, int _dim) {
        Log4Error$.MODULE$.unKnowExceptionError(_dim >= 0 && _dim < self.nDimension(), "dimension out of range", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (self._size()[_dim] == 1 && self.nDimension() > 1) {
            for (int d = _dim; d < self.nDimension() - 1; ++d) {
                self._size()[d] = self._size()[d + 1];
                self._stride()[d] = self._stride()[d + 1];
            }
            self.nDimension_$eq(self.nDimension() - 1);
        }
        return self;
    }

    public DenseTensor<Object> newWithStorage$mDc$sp(DenseTensor<Object> tensor, ArrayStorage<Object> storage, int storageOffset, int[] size, int[] stride, TensorNumericMath.TensorNumeric<Object> ev, ClassTag<Object> evidence$17) {
        DenseTensor$mcD$sp self;
        if (size != null && stride != null) {
            Log4Error$.MODULE$.unKnowExceptionError(size.length == stride.length, "inconsistent size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        }
        TensorNumericMath.TensorNumeric<Object> ev2 = ev;
        DenseTensor$mcD$sp denseTensor$mcD$sp = self = tensor == null ? new DenseTensor$mcD$sp(evidence$17, ev2) : tensor;
        int nDimension = size != null ? size.length : (stride != null ? stride.length : 0);
        return this.rawSet$mDc$sp(self, storage, storageOffset, nDimension, size, stride, evidence$17);
    }

    public DenseTensor<Object> newWithStorage$mFc$sp(DenseTensor<Object> tensor, ArrayStorage<Object> storage, int storageOffset, int[] size, int[] stride, TensorNumericMath.TensorNumeric<Object> ev, ClassTag<Object> evidence$17) {
        DenseTensor$mcF$sp self;
        if (size != null && stride != null) {
            Log4Error$.MODULE$.unKnowExceptionError(size.length == stride.length, "inconsistent size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        }
        TensorNumericMath.TensorNumeric<Object> ev2 = ev;
        DenseTensor$mcF$sp denseTensor$mcF$sp = self = tensor == null ? new DenseTensor$mcF$sp(evidence$17, ev2) : tensor;
        int nDimension = size != null ? size.length : (stride != null ? stride.length : 0);
        return this.rawSet$mFc$sp(self, storage, storageOffset, nDimension, size, stride, evidence$17);
    }

    public DenseTensor<Object> newWithTensor$mDc$sp(DenseTensor<Object> other, ClassTag<Object> evidence$18, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcD$sp self = new DenseTensor$mcD$sp(evidence$18, ev);
        return this.rawSet$mDc$sp(self, other._storage$mcD$sp(), other._storageOffset(), other.nDimension(), other._size(), other._stride(), evidence$18);
    }

    public DenseTensor<Object> newWithTensor$mFc$sp(DenseTensor<Object> other, ClassTag<Object> evidence$18, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcF$sp self = new DenseTensor$mcF$sp(evidence$18, ev);
        return this.rawSet$mFc$sp(self, other._storage$mcF$sp(), other._storageOffset(), other.nDimension(), other._size(), other._stride(), evidence$18);
    }

    public DenseTensor<Object> rawSet$mDc$sp(DenseTensor<Object> self, ArrayStorage<Object> storage, int storageOffset, int nDimension, int[] _size, int[] _stride, ClassTag<Object> evidence$19) {
        self._storage$mcD$sp_$eq(storage);
        Log4Error$.MODULE$.unKnowExceptionError(storageOffset >= 0, "Tensor: invalid storage offset", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        self._storageOffset_$eq(storageOffset);
        return this.rawResize$mDc$sp(self, nDimension, _size, _stride, evidence$19);
    }

    public DenseTensor<Object> rawSet$mFc$sp(DenseTensor<Object> self, ArrayStorage<Object> storage, int storageOffset, int nDimension, int[] _size, int[] _stride, ClassTag<Object> evidence$19) {
        self._storage$mcF$sp_$eq(storage);
        Log4Error$.MODULE$.unKnowExceptionError(storageOffset >= 0, "Tensor: invalid storage offset", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        self._storageOffset_$eq(storageOffset);
        return this.rawResize$mFc$sp(self, nDimension, _size, _stride, evidence$19);
    }

    public DenseTensor<Object> rawResize$mDc$sp(DenseTensor<Object> self, int nDim, int[] _size, int[] _stride, ClassTag<Object> evidence$20) {
        Object object;
        if (nDim == 0 && Predef$.MODULE$.intArrayOps(_size).isEmpty()) {
            Object object2;
            self._size_$eq((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()));
            self._stride_$eq((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()));
            self.nDimension_$eq(nDim);
            int totalSize = 1;
            if (self._storage$mcD$sp() == null) {
                self._storage$mcD$sp_$eq(new ArrayStorage$mcD$sp((double[])evidence$20.newArray(totalSize + self._storageOffset()), evidence$20));
                object2 = BoxedUnit.UNIT;
            } else {
                object2 = totalSize + self._storageOffset() > self._storage$mcD$sp().length() ? self._storage$mcD$sp().resize(totalSize + self._storageOffset()) : BoxedUnit.UNIT;
            }
            return self;
        }
        boolean hasCorrectSize = true;
        int nDim_ = 0;
        for (int d = 0; d < nDim; ++d) {
            ++nDim_;
            if (self.nDimension() > d && _size[d] != self._size()[d]) {
                hasCorrectSize = false;
            }
            if (self.nDimension() <= d || _stride == null || _stride[d] < 0 || _stride[d] == self._stride()[d]) continue;
            hasCorrectSize = false;
        }
        if (nDim_ != self.nDimension()) {
            hasCorrectSize = false;
        }
        if (hasCorrectSize) {
            return self;
        }
        if (nDim_ > 0) {
            if (nDim_ != self.nDimension()) {
                self._size_$eq(new int[nDim]);
                self._stride_$eq(new int[nDim]);
                self.nDimension_$eq(nDim);
            }
            int totalSize = 1;
            for (int d = self.nDimension() - 1; d >= 0; --d) {
                self._size()[d] = _size[d];
                self._stride()[d] = _stride != null && _stride[d] >= 0 ? _stride[d] : (d == self.nDimension() - 1 ? 1 : self._size()[d + 1] * self._stride()[d + 1]);
                totalSize += (self._size()[d] - 1) * self._stride()[d];
            }
            if (totalSize + self._storageOffset() > 0) {
                if (self._storage$mcD$sp() == null) {
                    self._storage$mcD$sp_$eq(new ArrayStorage$mcD$sp((double[])evidence$20.newArray(totalSize + self._storageOffset()), evidence$20));
                    object = BoxedUnit.UNIT;
                } else {
                    object = totalSize + self._storageOffset() > self._storage$mcD$sp().length() ? self._storage$mcD$sp().resize(totalSize + self._storageOffset()) : BoxedUnit.UNIT;
                }
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            self.nDimension_$eq(0);
            object = BoxedUnit.UNIT;
        }
        return self;
    }

    public DenseTensor<Object> rawResize$mFc$sp(DenseTensor<Object> self, int nDim, int[] _size, int[] _stride, ClassTag<Object> evidence$20) {
        Object object;
        if (nDim == 0 && Predef$.MODULE$.intArrayOps(_size).isEmpty()) {
            Object object2;
            self._size_$eq((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()));
            self._stride_$eq((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()));
            self.nDimension_$eq(nDim);
            int totalSize = 1;
            if (self._storage$mcF$sp() == null) {
                self._storage$mcF$sp_$eq(new ArrayStorage$mcF$sp((float[])evidence$20.newArray(totalSize + self._storageOffset()), evidence$20));
                object2 = BoxedUnit.UNIT;
            } else {
                object2 = totalSize + self._storageOffset() > self._storage$mcF$sp().length() ? self._storage$mcF$sp().resize(totalSize + self._storageOffset()) : BoxedUnit.UNIT;
            }
            return self;
        }
        boolean hasCorrectSize = true;
        int nDim_ = 0;
        for (int d = 0; d < nDim; ++d) {
            ++nDim_;
            if (self.nDimension() > d && _size[d] != self._size()[d]) {
                hasCorrectSize = false;
            }
            if (self.nDimension() <= d || _stride == null || _stride[d] < 0 || _stride[d] == self._stride()[d]) continue;
            hasCorrectSize = false;
        }
        if (nDim_ != self.nDimension()) {
            hasCorrectSize = false;
        }
        if (hasCorrectSize) {
            return self;
        }
        if (nDim_ > 0) {
            if (nDim_ != self.nDimension()) {
                self._size_$eq(new int[nDim]);
                self._stride_$eq(new int[nDim]);
                self.nDimension_$eq(nDim);
            }
            int totalSize = 1;
            for (int d = self.nDimension() - 1; d >= 0; --d) {
                self._size()[d] = _size[d];
                self._stride()[d] = _stride != null && _stride[d] >= 0 ? _stride[d] : (d == self.nDimension() - 1 ? 1 : self._size()[d + 1] * self._stride()[d + 1]);
                totalSize += (self._size()[d] - 1) * self._stride()[d];
            }
            if (totalSize + self._storageOffset() > 0) {
                if (self._storage$mcF$sp() == null) {
                    self._storage$mcF$sp_$eq(new ArrayStorage$mcF$sp((float[])evidence$20.newArray(totalSize + self._storageOffset()), evidence$20));
                    object = BoxedUnit.UNIT;
                } else {
                    object = totalSize + self._storageOffset() > self._storage$mcF$sp().length() ? self._storage$mcF$sp().resize(totalSize + self._storageOffset()) : BoxedUnit.UNIT;
                }
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            self.nDimension_$eq(0);
            object = BoxedUnit.UNIT;
        }
        return self;
    }

    public DenseTensor<Object> newClone$mDc$sp(DenseTensor<Object> self, ClassTag<Object> evidence$21, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcD$sp tensor = new DenseTensor$mcD$sp(evidence$21, ev);
        this.resizeAs$mDc$sp(tensor, self, evidence$21);
        this.copy$mDc$sp(tensor, self);
        return tensor;
    }

    public DenseTensor<Object> newClone$mFc$sp(DenseTensor<Object> self, ClassTag<Object> evidence$21, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor$mcF$sp tensor = new DenseTensor$mcF$sp(evidence$21, ev);
        this.resizeAs$mFc$sp(tensor, self, evidence$21);
        this.copy$mFc$sp(tensor, self);
        return tensor;
    }

    public DenseTensor<Object> newContiguous$mDc$sp(DenseTensor<Object> self, ClassTag<Object> evidence$22, TensorNumericMath.TensorNumeric<Object> ev) {
        return this.isContiguous$mDc$sp(self) ? self : this.newClone$mDc$sp(self, evidence$22, ev);
    }

    public DenseTensor<Object> newContiguous$mFc$sp(DenseTensor<Object> self, ClassTag<Object> evidence$22, TensorNumericMath.TensorNumeric<Object> ev) {
        return this.isContiguous$mFc$sp(self) ? self : this.newClone$mFc$sp(self, evidence$22, ev);
    }

    public DenseTensor<Object> newSelect$mDc$sp(DenseTensor<Object> self, int _dimension, int _sliceIndex, ClassTag<Object> evidence$23, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor<Object> tensor = this.newWithTensor$mDc$sp(self, evidence$23, ev);
        this.select$mDc$sp(tensor, null, _dimension, _sliceIndex, evidence$23);
        return tensor;
    }

    public DenseTensor<Object> newSelect$mFc$sp(DenseTensor<Object> self, int _dimension, int _sliceIndex, ClassTag<Object> evidence$23, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor<Object> tensor = this.newWithTensor$mFc$sp(self, evidence$23, ev);
        this.select$mFc$sp(tensor, null, _dimension, _sliceIndex, evidence$23);
        return tensor;
    }

    public DenseTensor<Object> newNarrow$mDc$sp(DenseTensor<Object> self, int _dimension, int _firstIndex, int _size, ClassTag<Object> evidence$24, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor<Object> tensor = this.newWithTensor$mDc$sp(self, evidence$24, ev);
        this.narrow$mDc$sp(tensor, null, _dimension, _firstIndex, _size, evidence$24);
        return tensor;
    }

    public DenseTensor<Object> newNarrow$mFc$sp(DenseTensor<Object> self, int _dimension, int _firstIndex, int _size, ClassTag<Object> evidence$24, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor<Object> tensor = this.newWithTensor$mFc$sp(self, evidence$24, ev);
        this.narrow$mFc$sp(tensor, null, _dimension, _firstIndex, _size, evidence$24);
        return tensor;
    }

    public DenseTensor<Object> newTranspose$mDc$sp(DenseTensor<Object> self, int _dimension1, int _dimension2, ClassTag<Object> evidence$25, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor<Object> tensor = this.newWithTensor$mDc$sp(self, evidence$25, ev);
        this.transpose$mDc$sp(tensor, null, _dimension1, _dimension2, evidence$25);
        return tensor;
    }

    public DenseTensor<Object> newTranspose$mFc$sp(DenseTensor<Object> self, int _dimension1, int _dimension2, ClassTag<Object> evidence$25, TensorNumericMath.TensorNumeric<Object> ev) {
        DenseTensor<Object> tensor = this.newWithTensor$mFc$sp(self, evidence$25, ev);
        this.transpose$mFc$sp(tensor, null, _dimension1, _dimension2, evidence$25);
        return tensor;
    }

    public void resizeAs$mDc$sp(DenseTensor<Object> self, Tensor<?> src, ClassTag<Object> evidence$26) {
        if (!this.isSameSizeAs$mDc$sp(self, src)) {
            this.rawResize$mDc$sp(self, src.nDimension(), src.size(), null, evidence$26);
        }
    }

    public void resizeAs$mFc$sp(DenseTensor<Object> self, Tensor<?> src, ClassTag<Object> evidence$26) {
        if (!this.isSameSizeAs$mFc$sp(self, src)) {
            this.rawResize$mFc$sp(self, src.nDimension(), src.size(), null, evidence$26);
        }
    }

    public DenseTensor<Object> resize$mDc$sp(DenseTensor<Object> self, int[] sizes, int[] strides, ClassTag<Object> evidence$27) {
        Log4Error$.MODULE$.unKnowExceptionError(sizes != null, "invalid size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (strides != null) {
            Log4Error$.MODULE$.unKnowExceptionError(sizes.length == strides.length, "invalid stride", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        }
        return this.rawResize$mDc$sp(self, sizes.length, sizes, strides, evidence$27);
    }

    public DenseTensor<Object> resize$mFc$sp(DenseTensor<Object> self, int[] sizes, int[] strides, ClassTag<Object> evidence$27) {
        Log4Error$.MODULE$.unKnowExceptionError(sizes != null, "invalid size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (strides != null) {
            Log4Error$.MODULE$.unKnowExceptionError(sizes.length == strides.length, "invalid stride", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        }
        return this.rawResize$mFc$sp(self, sizes.length, sizes, strides, evidence$27);
    }

    public boolean isSameSizeAs$mZc$sp(DenseTensor<Object> self, Tensor<?> src) {
        if (self.nDimension() != src.nDimension()) {
            return false;
        }
        if (self.isEmpty() != src.isEmpty()) {
            return false;
        }
        for (int d = 0; d < self.nDimension(); ++d) {
            if (self.size(d + 1) == src.size(d + 1)) continue;
            return false;
        }
        return true;
    }

    public boolean isSameSizeAs$mBc$sp(DenseTensor<Object> self, Tensor<?> src) {
        if (self.nDimension() != src.nDimension()) {
            return false;
        }
        if (self.isEmpty() != src.isEmpty()) {
            return false;
        }
        for (int d = 0; d < self.nDimension(); ++d) {
            if (self.size(d + 1) == src.size(d + 1)) continue;
            return false;
        }
        return true;
    }

    public boolean isSameSizeAs$mCc$sp(DenseTensor<Object> self, Tensor<?> src) {
        if (self.nDimension() != src.nDimension()) {
            return false;
        }
        if (self.isEmpty() != src.isEmpty()) {
            return false;
        }
        for (int d = 0; d < self.nDimension(); ++d) {
            if (self.size(d + 1) == src.size(d + 1)) continue;
            return false;
        }
        return true;
    }

    public boolean isSameSizeAs$mDc$sp(DenseTensor<Object> self, Tensor<?> src) {
        if (self.nDimension() != src.nDimension()) {
            return false;
        }
        if (self.isEmpty() != src.isEmpty()) {
            return false;
        }
        for (int d = 0; d < self.nDimension(); ++d) {
            if (self.size(d + 1) == src.size(d + 1)) continue;
            return false;
        }
        return true;
    }

    public boolean isSameSizeAs$mFc$sp(DenseTensor<Object> self, Tensor<?> src) {
        if (self.nDimension() != src.nDimension()) {
            return false;
        }
        if (self.isEmpty() != src.isEmpty()) {
            return false;
        }
        for (int d = 0; d < self.nDimension(); ++d) {
            if (self.size(d + 1) == src.size(d + 1)) continue;
            return false;
        }
        return true;
    }

    public boolean isSameSizeAs$mIc$sp(DenseTensor<Object> self, Tensor<?> src) {
        if (self.nDimension() != src.nDimension()) {
            return false;
        }
        if (self.isEmpty() != src.isEmpty()) {
            return false;
        }
        for (int d = 0; d < self.nDimension(); ++d) {
            if (self.size(d + 1) == src.size(d + 1)) continue;
            return false;
        }
        return true;
    }

    public boolean isSameSizeAs$mJc$sp(DenseTensor<Object> self, Tensor<?> src) {
        if (self.nDimension() != src.nDimension()) {
            return false;
        }
        if (self.isEmpty() != src.isEmpty()) {
            return false;
        }
        for (int d = 0; d < self.nDimension(); ++d) {
            if (self.size(d + 1) == src.size(d + 1)) continue;
            return false;
        }
        return true;
    }

    public boolean isSameSizeAs$mSc$sp(DenseTensor<Object> self, Tensor<?> src) {
        if (self.nDimension() != src.nDimension()) {
            return false;
        }
        if (self.isEmpty() != src.isEmpty()) {
            return false;
        }
        for (int d = 0; d < self.nDimension(); ++d) {
            if (self.size(d + 1) == src.size(d + 1)) continue;
            return false;
        }
        return true;
    }

    public boolean isSameSizeAs$mVc$sp(DenseTensor<BoxedUnit> self, Tensor<?> src) {
        if (self.nDimension() != src.nDimension()) {
            return false;
        }
        if (self.isEmpty() != src.isEmpty()) {
            return false;
        }
        for (int d = 0; d < self.nDimension(); ++d) {
            if (self.size(d + 1) == src.size(d + 1)) continue;
            return false;
        }
        return true;
    }

    public boolean isContiguous$mDc$sp(DenseTensor<Object> self) {
        int s2 = 1;
        for (int d = self.nDimension() - 1; d >= 0; --d) {
            if (self._size()[d] == 1) continue;
            if (s2 != self._stride()[d]) {
                return false;
            }
            s2 *= self._size()[d];
        }
        return true;
    }

    public boolean isContiguous$mFc$sp(DenseTensor<Object> self) {
        int s2 = 1;
        for (int d = self.nDimension() - 1; d >= 0; --d) {
            if (self._size()[d] == 1) continue;
            if (s2 != self._stride()[d]) {
                return false;
            }
            s2 *= self._size()[d];
        }
        return true;
    }

    public Tensor<Object> set$mDc$sp(DenseTensor<Object> self, DenseTensor<Object> other, ClassTag<Object> evidence$28) {
        DenseTensor<Object> denseTensor = self;
        DenseTensor<Object> denseTensor2 = other;
        return !(denseTensor != null ? !((Object)denseTensor).equals(denseTensor2) : denseTensor2 != null) ? self : this.rawSet$mDc$sp(self, (ArrayStorage)other.storage(), other.storageOffset(), other.nDimension(), other.size(), other.stride(), evidence$28);
    }

    public Tensor<Object> set$mFc$sp(DenseTensor<Object> self, DenseTensor<Object> other, ClassTag<Object> evidence$28) {
        DenseTensor<Object> denseTensor = self;
        DenseTensor<Object> denseTensor2 = other;
        return !(denseTensor != null ? !((Object)denseTensor).equals(denseTensor2) : denseTensor2 != null) ? self : this.rawSet$mFc$sp(self, (ArrayStorage)other.storage(), other.storageOffset(), other.nDimension(), other.size(), other.stride(), evidence$28);
    }

    /*
     * WARNING - void declaration
     */
    public int offsetFromIndice$mDc$sp(DenseTensor<Object> self, int[] indexes) {
        void var3_3;
        int offset = self._storageOffset();
        for (int d = 0; d < indexes.length; ++d) {
            offset += (indexes[d] - 1) * self._stride()[d];
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public int offsetFromIndice$mFc$sp(DenseTensor<Object> self, int[] indexes) {
        void var3_3;
        int offset = self._storageOffset();
        for (int d = 0; d < indexes.length; ++d) {
            offset += (indexes[d] - 1) * self._stride()[d];
        }
        return (int)var3_3;
    }

    public void select$mDc$sp(DenseTensor<Object> self, DenseTensor<Object> source, int _dimension, int _sliceIndex, ClassTag<Object> evidence$29) {
        DenseTensor<Object> src = source;
        if (src == null) {
            src = self;
        }
        Log4Error$.MODULE$.unKnowExceptionError(src.nDimension() > 0, "cannot select on a scalar", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(_dimension >= 0 && _dimension < src.nDimension(), "out of range", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(_sliceIndex >= 0 && _sliceIndex < src.size(_dimension + 1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " out of range 0 to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)_sliceIndex), BoxesRunTime.boxToInteger((int)(src.size(_dimension + 1) - 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        this.set$mDc$sp(self, src, evidence$29);
        this.narrow$mDc$sp(self, null, _dimension, _sliceIndex, 1, evidence$29);
        for (int d = _dimension; d < self.nDimension() - 1; ++d) {
            self._size()[d] = self._size()[d + 1];
            self._stride()[d] = self._stride()[d + 1];
        }
        self.nDimension_$eq(self.nDimension() - 1);
    }

    public void select$mFc$sp(DenseTensor<Object> self, DenseTensor<Object> source, int _dimension, int _sliceIndex, ClassTag<Object> evidence$29) {
        DenseTensor<Object> src = source;
        if (src == null) {
            src = self;
        }
        Log4Error$.MODULE$.unKnowExceptionError(src.nDimension() > 0, "cannot select on a scalar", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(_dimension >= 0 && _dimension < src.nDimension(), "out of range", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(_sliceIndex >= 0 && _sliceIndex < src.size(_dimension + 1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " out of range 0 to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)_sliceIndex), BoxesRunTime.boxToInteger((int)(src.size(_dimension + 1) - 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        this.set$mFc$sp(self, src, evidence$29);
        this.narrow$mFc$sp(self, null, _dimension, _sliceIndex, 1, evidence$29);
        for (int d = _dimension; d < self.nDimension() - 1; ++d) {
            self._size()[d] = self._size()[d + 1];
            self._stride()[d] = self._stride()[d + 1];
        }
        self.nDimension_$eq(self.nDimension() - 1);
    }

    public void narrow$mDc$sp(DenseTensor<Object> self, DenseTensor<Object> source, int _dimension, int _firstIndex, int size, ClassTag<Object> evidence$30) {
        DenseTensor<Object> src = source;
        if (src == null) {
            src = self;
        }
        Log4Error$.MODULE$.unKnowExceptionError(_dimension >= 0 && _dimension < src.nDimension(), "dimension out of range", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(_firstIndex >= 0 && _firstIndex < src.size(_dimension + 1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"firstIndex(", ") out of range [0, ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)_firstIndex), BoxesRunTime.boxToInteger((int)src.size(_dimension + 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(size > 0 && _firstIndex + size <= src.size(_dimension + 1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size out of range ", " (0, ", " - ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size), BoxesRunTime.boxToInteger((int)src.size(_dimension + 1)), BoxesRunTime.boxToInteger((int)_firstIndex)})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        this.set$mDc$sp(self, src, evidence$30);
        if (_firstIndex > 0) {
            self._storageOffset_$eq(self._storageOffset() + _firstIndex * self._stride()[_dimension]);
        }
        self._size()[_dimension] = size;
    }

    public void narrow$mFc$sp(DenseTensor<Object> self, DenseTensor<Object> source, int _dimension, int _firstIndex, int size, ClassTag<Object> evidence$30) {
        DenseTensor<Object> src = source;
        if (src == null) {
            src = self;
        }
        Log4Error$.MODULE$.unKnowExceptionError(_dimension >= 0 && _dimension < src.nDimension(), "dimension out of range", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(_firstIndex >= 0 && _firstIndex < src.size(_dimension + 1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"firstIndex(", ") out of range [0, ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)_firstIndex), BoxesRunTime.boxToInteger((int)src.size(_dimension + 1))})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(size > 0 && _firstIndex + size <= src.size(_dimension + 1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size out of range ", " (0, ", " - ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size), BoxesRunTime.boxToInteger((int)src.size(_dimension + 1)), BoxesRunTime.boxToInteger((int)_firstIndex)})), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        this.set$mFc$sp(self, src, evidence$30);
        if (_firstIndex > 0) {
            self._storageOffset_$eq(self._storageOffset() + _firstIndex * self._stride()[_dimension]);
        }
        self._size()[_dimension] = size;
    }

    public void transpose$mDc$sp(DenseTensor<Object> self, DenseTensor<Object> source, int _dimension1, int _dimension2, ClassTag<Object> evidence$31) {
        DenseTensor<Object> src = source;
        if (src == null) {
            src = self;
        }
        Log4Error$.MODULE$.unKnowExceptionError(_dimension1 >= 0 && _dimension1 < src.nDimension(), "out of range", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(_dimension2 >= 0 && _dimension2 < src.nDimension(), "out of range", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        this.set$mDc$sp(self, src, evidence$31);
        if (_dimension1 == _dimension2) {
            return;
        }
        int z = self._stride()[_dimension1];
        self._stride()[_dimension1] = self._stride()[_dimension2];
        self._stride()[_dimension2] = z;
        z = self._size()[_dimension1];
        self._size()[_dimension1] = self._size()[_dimension2];
        self._size()[_dimension2] = z;
    }

    public void transpose$mFc$sp(DenseTensor<Object> self, DenseTensor<Object> source, int _dimension1, int _dimension2, ClassTag<Object> evidence$31) {
        DenseTensor<Object> src = source;
        if (src == null) {
            src = self;
        }
        Log4Error$.MODULE$.unKnowExceptionError(_dimension1 >= 0 && _dimension1 < src.nDimension(), "out of range", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(_dimension2 >= 0 && _dimension2 < src.nDimension(), "out of range", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        this.set$mFc$sp(self, src, evidence$31);
        if (_dimension1 == _dimension2) {
            return;
        }
        int z = self._stride()[_dimension1];
        self._stride()[_dimension1] = self._stride()[_dimension2];
        self._stride()[_dimension2] = z;
        z = self._size()[_dimension1];
        self._size()[_dimension1] = self._size()[_dimension2];
        self._size()[_dimension2] = z;
    }

    public double get1d$mDc$sp(DenseTensor<Object> self, int x0) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nDimension() != 0, "tensor must have one dimension", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(x0 >= 0 && x0 < self._size()[0], "out of range", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        return self._storage$mcD$sp().apply$mcD$sp(self._storageOffset() + x0 * self._stride()[0]);
    }

    public float get1d$mFc$sp(DenseTensor<Object> self, int x0) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nDimension() != 0, "tensor must have one dimension", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(x0 >= 0 && x0 < self._size()[0], "out of range", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        return self._storage$mcF$sp().apply$mcF$sp(self._storageOffset() + x0 * self._stride()[0]);
    }

    public DenseTensor<Object> get1dTensor$mDc$sp(DenseTensor<Object> self, int x0, ClassTag<Object> evidence$32, TensorNumericMath.TensorNumeric<Object> ev) {
        return new DenseTensor$mcD$sp(new ArrayStorage$mcD$sp((double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new double[]{this.get1d$mDc$sp(self, x0)}), evidence$32), evidence$32), evidence$32, ev);
    }

    public DenseTensor<Object> get1dTensor$mFc$sp(DenseTensor<Object> self, int x0, ClassTag<Object> evidence$32, TensorNumericMath.TensorNumeric<Object> ev) {
        return new DenseTensor$mcF$sp(new ArrayStorage$mcF$sp((float[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new float[]{this.get1d$mFc$sp(self, x0)}), evidence$32), evidence$32), evidence$32, ev);
    }

    public void copy$mZc$sp(DenseTensor<Object> self, Tensor<Object> src) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == src.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self element number(", ") is not"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" equal to source element number(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)src.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (self.isEmpty()) {
            return;
        }
        if (self.isContiguous() && src.isContiguous() && this.sameStride(self.stride(), src.stride())) {
            System.arraycopy(src.storage().array(), src.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1, self.nElement());
            return;
        }
        TensorFunc4<Object> func2 = new TensorFunc4<Object>(){

            public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
            }

            public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
            }

            public String toString() {
                return TensorFunc4$class.toString(this);
            }

            public void apply(boolean[] data1, int offset1, boolean[] data2, int offset2) {
                data1[offset1] = data2[offset2];
            }
            {
                TensorFunc4$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply2(self, src, func2);
    }

    public void copy$mBc$sp(DenseTensor<Object> self, Tensor<Object> src) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == src.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self element number(", ") is not"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" equal to source element number(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)src.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (self.isEmpty()) {
            return;
        }
        if (self.isContiguous() && src.isContiguous() && this.sameStride(self.stride(), src.stride())) {
            System.arraycopy(src.storage().array(), src.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1, self.nElement());
            return;
        }
        TensorFunc4<Object> func2 = new TensorFunc4<Object>(){

            public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
            }

            public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
            }

            public String toString() {
                return TensorFunc4$class.toString(this);
            }

            public void apply(byte[] data1, int offset1, byte[] data2, int offset2) {
                data1[offset1] = data2[offset2];
            }
            {
                TensorFunc4$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply2(self, src, func2);
    }

    public void copy$mCc$sp(DenseTensor<Object> self, Tensor<Object> src) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == src.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self element number(", ") is not"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" equal to source element number(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)src.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (self.isEmpty()) {
            return;
        }
        if (self.isContiguous() && src.isContiguous() && this.sameStride(self.stride(), src.stride())) {
            System.arraycopy(src.storage().array(), src.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1, self.nElement());
            return;
        }
        TensorFunc4<Object> func2 = new TensorFunc4<Object>(){

            public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
            }

            public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
            }

            public String toString() {
                return TensorFunc4$class.toString(this);
            }

            public void apply(char[] data1, int offset1, char[] data2, int offset2) {
                data1[offset1] = data2[offset2];
            }
            {
                TensorFunc4$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply2(self, src, func2);
    }

    public void copy$mDc$sp(DenseTensor<Object> self, Tensor<Object> src) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == src.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self element number(", ") is not"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" equal to source element number(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)src.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (self.isEmpty()) {
            return;
        }
        if (self.isContiguous() && src.isContiguous() && this.sameStride(self.stride(), src.stride())) {
            System.arraycopy(src.storage().array(), src.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1, self.nElement());
            return;
        }
        TensorFunc4$mcD$sp func2 = new TensorFunc4$mcD$sp(){

            public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
            }

            public String toString() {
                return TensorFunc4$class.toString(this);
            }

            public void apply(double[] data1, int offset1, double[] data2, int offset2) {
                this.apply$mcD$sp(data1, offset1, data2, offset2);
            }

            public void apply$mcD$sp(double[] data1, int offset1, double[] data2, int offset2) {
                data1[offset1] = data2[offset2];
            }
            {
                TensorFunc4$class.$init$(this);
                TensorFunc4$mcD$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply2(self, src, func2);
    }

    public void copy$mFc$sp(DenseTensor<Object> self, Tensor<Object> src) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == src.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self element number(", ") is not"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" equal to source element number(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)src.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (self.isEmpty()) {
            return;
        }
        if (self.isContiguous() && src.isContiguous() && this.sameStride(self.stride(), src.stride())) {
            System.arraycopy(src.storage().array(), src.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1, self.nElement());
            return;
        }
        TensorFunc4$mcF$sp func2 = new TensorFunc4$mcF$sp(){

            public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
            }

            public String toString() {
                return TensorFunc4$class.toString(this);
            }

            public void apply(float[] data1, int offset1, float[] data2, int offset2) {
                this.apply$mcF$sp(data1, offset1, data2, offset2);
            }

            public void apply$mcF$sp(float[] data1, int offset1, float[] data2, int offset2) {
                data1[offset1] = data2[offset2];
            }
            {
                TensorFunc4$class.$init$(this);
                TensorFunc4$mcF$sp$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply2(self, src, func2);
    }

    public void copy$mIc$sp(DenseTensor<Object> self, Tensor<Object> src) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == src.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self element number(", ") is not"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" equal to source element number(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)src.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (self.isEmpty()) {
            return;
        }
        if (self.isContiguous() && src.isContiguous() && this.sameStride(self.stride(), src.stride())) {
            System.arraycopy(src.storage().array(), src.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1, self.nElement());
            return;
        }
        TensorFunc4<Object> func2 = new TensorFunc4<Object>(){

            public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
            }

            public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
            }

            public String toString() {
                return TensorFunc4$class.toString(this);
            }

            public void apply(int[] data1, int offset1, int[] data2, int offset2) {
                data1[offset1] = data2[offset2];
            }
            {
                TensorFunc4$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply2(self, src, func2);
    }

    public void copy$mJc$sp(DenseTensor<Object> self, Tensor<Object> src) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == src.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self element number(", ") is not"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" equal to source element number(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)src.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (self.isEmpty()) {
            return;
        }
        if (self.isContiguous() && src.isContiguous() && this.sameStride(self.stride(), src.stride())) {
            System.arraycopy(src.storage().array(), src.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1, self.nElement());
            return;
        }
        TensorFunc4<Object> func2 = new TensorFunc4<Object>(){

            public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
            }

            public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
            }

            public String toString() {
                return TensorFunc4$class.toString(this);
            }

            public void apply(long[] data1, int offset1, long[] data2, int offset2) {
                data1[offset1] = data2[offset2];
            }
            {
                TensorFunc4$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply2(self, src, func2);
    }

    public void copy$mSc$sp(DenseTensor<Object> self, Tensor<Object> src) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == src.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self element number(", ") is not"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" equal to source element number(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)src.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (self.isEmpty()) {
            return;
        }
        if (self.isContiguous() && src.isContiguous() && this.sameStride(self.stride(), src.stride())) {
            System.arraycopy(src.storage().array(), src.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1, self.nElement());
            return;
        }
        TensorFunc4<Object> func2 = new TensorFunc4<Object>(){

            public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
            }

            public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
            }

            public String toString() {
                return TensorFunc4$class.toString(this);
            }

            public void apply(short[] data1, int offset1, short[] data2, int offset2) {
                data1[offset1] = data2[offset2];
            }
            {
                TensorFunc4$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply2(self, src, func2);
    }

    public void copy$mVc$sp(DenseTensor<BoxedUnit> self, Tensor<BoxedUnit> src) {
        Log4Error$.MODULE$.unKnowExceptionError(self.nElement() == src.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"self element number(", ") is not"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)self.nElement())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" equal to source element number(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)src.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        if (self.isEmpty()) {
            return;
        }
        if (self.isContiguous() && src.isContiguous() && this.sameStride(self.stride(), src.stride())) {
            System.arraycopy(src.storage().array(), src.storageOffset() - 1, self.storage().array(), self.storageOffset() - 1, self.nElement());
            return;
        }
        TensorFunc4<BoxedUnit> func2 = new TensorFunc4<BoxedUnit>(){

            public void apply$mcD$sp(double[] v1, int v2, double[] v3, int v4) {
                TensorFunc4$class.apply$mcD$sp(this, v1, v2, v3, v4);
            }

            public void apply$mcF$sp(float[] v1, int v2, float[] v3, int v4) {
                TensorFunc4$class.apply$mcF$sp(this, v1, v2, v3, v4);
            }

            public String toString() {
                return TensorFunc4$class.toString(this);
            }

            public void apply(BoxedUnit[] data1, int offset1, BoxedUnit[] data2, int offset2) {
                data1[offset1] = data2[offset2];
            }
            {
                TensorFunc4$class.$init$(this);
            }
        };
        DenseTensorApply$.MODULE$.apply2(self, src, func2);
    }

    public Tensor<Object> randperm$mDc$sp(int size, ClassTag<Object> evidence$33, TensorNumericMath.TensorNumeric<Object> ev) {
        int i;
        Log4Error$.MODULE$.unKnowExceptionError(size >= 1, "invalid size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        double[] array = (double[])evidence$33.newArray(size);
        for (i = 1; i <= size; ++i) {
            array[i - 1] = ev.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)i), ConvertableFrom$ConvertableFromInt$.MODULE$);
        }
        for (i = 0; i < size - 1; ++i) {
            int rand = (int)Math.floor(RandomGenerator$.MODULE$.RNG().random() % (long)(size - i));
            double tmp = array[i];
            array[i] = array[rand + i];
            array[rand + i] = tmp;
        }
        return Tensor$.MODULE$.apply$mDc$sp(new ArrayStorage$mcD$sp(array, evidence$33), evidence$33, ev);
    }

    public Tensor<Object> randperm$mFc$sp(int size, ClassTag<Object> evidence$33, TensorNumericMath.TensorNumeric<Object> ev) {
        int i;
        Log4Error$.MODULE$.unKnowExceptionError(size >= 1, "invalid size", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        float[] array = (float[])evidence$33.newArray(size);
        for (i = 1; i <= size; ++i) {
            array[i - 1] = ev.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)i), ConvertableFrom$ConvertableFromInt$.MODULE$);
        }
        for (i = 0; i < size - 1; ++i) {
            int rand = (int)Math.floor(RandomGenerator$.MODULE$.RNG().random() % (long)(size - i));
            float tmp = array[i];
            array[i] = array[rand + i];
            array[rand + i] = tmp;
        }
        return Tensor$.MODULE$.apply$mFc$sp(new ArrayStorage$mcF$sp(array, evidence$33), evidence$33, ev);
    }

    public Tensor<Object> range$mDc$sp(double xmin, double xmax, int step, ClassTag<Object> evidence$34, TensorNumericMath.TensorNumeric<Object> ev) {
        Tensor<Object> newTensor = Tensor$.MODULE$.apply$mDc$sp(evidence$34, ev);
        return newTensor.range(xmin, xmax, step);
    }

    public Tensor<Object> range$mFc$sp(double xmin, double xmax, int step, ClassTag<Object> evidence$34, TensorNumericMath.TensorNumeric<Object> ev) {
        Tensor<Object> newTensor = Tensor$.MODULE$.apply$mFc$sp(evidence$34, ev);
        return newTensor.range(xmin, xmax, step);
    }

    public Tensor<Object> ones$mDc$sp(int[] sizes, ClassTag<Object> evidence$35, TensorNumericMath.TensorNumeric<Object> ev) {
        int length = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(sizes).product((Numeric)Numeric.IntIsIntegral$.MODULE$));
        return Tensor$.MODULE$.apply$mDc$sp(Storage$.MODULE$.apply$mDc$sp((double[])evidence$35.newArray(length), evidence$35), 1, sizes, Tensor$.MODULE$.apply$default$4(), evidence$35, ev).fill(BoxesRunTime.boxToDouble((double)ev.fromType$mcD$sp(BoxesRunTime.boxToInteger((int)1), ConvertableFrom$ConvertableFromInt$.MODULE$)));
    }

    public Tensor<Object> ones$mFc$sp(int[] sizes, ClassTag<Object> evidence$35, TensorNumericMath.TensorNumeric<Object> ev) {
        int length = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(sizes).product((Numeric)Numeric.IntIsIntegral$.MODULE$));
        return Tensor$.MODULE$.apply$mFc$sp(Storage$.MODULE$.apply$mFc$sp((float[])evidence$35.newArray(length), evidence$35), 1, sizes, Tensor$.MODULE$.apply$default$4(), evidence$35, ev).fill(BoxesRunTime.boxToFloat((float)ev.fromType$mcF$sp(BoxesRunTime.boxToInteger((int)1), ConvertableFrom$ConvertableFromInt$.MODULE$)));
    }

    public Tensor<Object> gaussian1D$mZc$sp(int size, double sigma, int amplitude, boolean normalize, double mean2, Tensor<Object> tensor, ClassTag<Object> evidence$36, TensorNumericMath.TensorNumeric<Object> ev) {
        Tensor<Object> tensor2;
        if (tensor == null) {
            tensor2 = Tensor$.MODULE$.apply(size, evidence$36, ev);
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(tensor.dim() == 1, "expecting 1D tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            Log4Error$.MODULE$.unKnowExceptionError(tensor.nElement() > 0, "expecting non-empty tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            tensor2 = tensor;
        }
        Tensor<Object> gauss = tensor2;
        double center = mean2 * (double)gauss.nElement() + 0.5;
        for (int i = 1; i <= gauss.nElement(); ++i) {
            gauss.setValue(i, ev.fromType(BoxesRunTime.boxToDouble((double)((double)amplitude * package$.MODULE$.exp(-(package$.MODULE$.pow(((double)i - center) / (sigma * (double)size), 2.0) / (double)2)))), ConvertableFrom$ConvertableFromDouble$.MODULE$));
        }
        Object object = normalize ? gauss.div(gauss.sum()) : BoxedUnit.UNIT;
        return gauss;
    }

    public Tensor<Object> gaussian1D$mBc$sp(int size, double sigma, int amplitude, boolean normalize, double mean2, Tensor<Object> tensor, ClassTag<Object> evidence$36, TensorNumericMath.TensorNumeric<Object> ev) {
        Tensor<Object> tensor2;
        if (tensor == null) {
            tensor2 = Tensor$.MODULE$.apply(size, evidence$36, ev);
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(tensor.dim() == 1, "expecting 1D tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            Log4Error$.MODULE$.unKnowExceptionError(tensor.nElement() > 0, "expecting non-empty tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            tensor2 = tensor;
        }
        Tensor<Object> gauss = tensor2;
        double center = mean2 * (double)gauss.nElement() + 0.5;
        for (int i = 1; i <= gauss.nElement(); ++i) {
            gauss.setValue(i, ev.fromType(BoxesRunTime.boxToDouble((double)((double)amplitude * package$.MODULE$.exp(-(package$.MODULE$.pow(((double)i - center) / (sigma * (double)size), 2.0) / (double)2)))), ConvertableFrom$ConvertableFromDouble$.MODULE$));
        }
        Object object = normalize ? gauss.div(gauss.sum()) : BoxedUnit.UNIT;
        return gauss;
    }

    public Tensor<Object> gaussian1D$mCc$sp(int size, double sigma, int amplitude, boolean normalize, double mean2, Tensor<Object> tensor, ClassTag<Object> evidence$36, TensorNumericMath.TensorNumeric<Object> ev) {
        Tensor<Object> tensor2;
        if (tensor == null) {
            tensor2 = Tensor$.MODULE$.apply(size, evidence$36, ev);
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(tensor.dim() == 1, "expecting 1D tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            Log4Error$.MODULE$.unKnowExceptionError(tensor.nElement() > 0, "expecting non-empty tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            tensor2 = tensor;
        }
        Tensor<Object> gauss = tensor2;
        double center = mean2 * (double)gauss.nElement() + 0.5;
        for (int i = 1; i <= gauss.nElement(); ++i) {
            gauss.setValue(i, ev.fromType(BoxesRunTime.boxToDouble((double)((double)amplitude * package$.MODULE$.exp(-(package$.MODULE$.pow(((double)i - center) / (sigma * (double)size), 2.0) / (double)2)))), ConvertableFrom$ConvertableFromDouble$.MODULE$));
        }
        Object object = normalize ? gauss.div(gauss.sum()) : BoxedUnit.UNIT;
        return gauss;
    }

    public Tensor<Object> gaussian1D$mDc$sp(int size, double sigma, int amplitude, boolean normalize, double mean2, Tensor<Object> tensor, ClassTag<Object> evidence$36, TensorNumericMath.TensorNumeric<Object> ev) {
        Tensor<Object> tensor2;
        if (tensor == null) {
            tensor2 = Tensor$.MODULE$.apply$mDc$sp(size, evidence$36, ev);
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(tensor.dim() == 1, "expecting 1D tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            Log4Error$.MODULE$.unKnowExceptionError(tensor.nElement() > 0, "expecting non-empty tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            tensor2 = tensor;
        }
        Tensor<Object> gauss = tensor2;
        double center = mean2 * (double)gauss.nElement() + 0.5;
        for (int i = 1; i <= gauss.nElement(); ++i) {
            gauss.setValue(i, BoxesRunTime.boxToDouble((double)ev.fromType$mcD$sp(BoxesRunTime.boxToDouble((double)((double)amplitude * package$.MODULE$.exp(-(package$.MODULE$.pow(((double)i - center) / (sigma * (double)size), 2.0) / (double)2)))), ConvertableFrom$ConvertableFromDouble$.MODULE$)));
        }
        Object object = normalize ? gauss.div(gauss.sum()) : BoxedUnit.UNIT;
        return gauss;
    }

    public Tensor<Object> gaussian1D$mFc$sp(int size, double sigma, int amplitude, boolean normalize, double mean2, Tensor<Object> tensor, ClassTag<Object> evidence$36, TensorNumericMath.TensorNumeric<Object> ev) {
        Tensor<Object> tensor2;
        if (tensor == null) {
            tensor2 = Tensor$.MODULE$.apply$mFc$sp(size, evidence$36, ev);
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(tensor.dim() == 1, "expecting 1D tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            Log4Error$.MODULE$.unKnowExceptionError(tensor.nElement() > 0, "expecting non-empty tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            tensor2 = tensor;
        }
        Tensor<Object> gauss = tensor2;
        double center = mean2 * (double)gauss.nElement() + 0.5;
        for (int i = 1; i <= gauss.nElement(); ++i) {
            gauss.setValue(i, BoxesRunTime.boxToFloat((float)ev.fromType$mcF$sp(BoxesRunTime.boxToDouble((double)((double)amplitude * package$.MODULE$.exp(-(package$.MODULE$.pow(((double)i - center) / (sigma * (double)size), 2.0) / (double)2)))), ConvertableFrom$ConvertableFromDouble$.MODULE$)));
        }
        Object object = normalize ? gauss.div(gauss.sum()) : BoxedUnit.UNIT;
        return gauss;
    }

    public Tensor<Object> gaussian1D$mIc$sp(int size, double sigma, int amplitude, boolean normalize, double mean2, Tensor<Object> tensor, ClassTag<Object> evidence$36, TensorNumericMath.TensorNumeric<Object> ev) {
        Tensor<Object> tensor2;
        if (tensor == null) {
            tensor2 = Tensor$.MODULE$.apply(size, evidence$36, ev);
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(tensor.dim() == 1, "expecting 1D tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            Log4Error$.MODULE$.unKnowExceptionError(tensor.nElement() > 0, "expecting non-empty tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            tensor2 = tensor;
        }
        Tensor<Object> gauss = tensor2;
        double center = mean2 * (double)gauss.nElement() + 0.5;
        for (int i = 1; i <= gauss.nElement(); ++i) {
            gauss.setValue(i, ev.fromType(BoxesRunTime.boxToDouble((double)((double)amplitude * package$.MODULE$.exp(-(package$.MODULE$.pow(((double)i - center) / (sigma * (double)size), 2.0) / (double)2)))), ConvertableFrom$ConvertableFromDouble$.MODULE$));
        }
        Object object = normalize ? gauss.div(gauss.sum()) : BoxedUnit.UNIT;
        return gauss;
    }

    public Tensor<Object> gaussian1D$mJc$sp(int size, double sigma, int amplitude, boolean normalize, double mean2, Tensor<Object> tensor, ClassTag<Object> evidence$36, TensorNumericMath.TensorNumeric<Object> ev) {
        Tensor<Object> tensor2;
        if (tensor == null) {
            tensor2 = Tensor$.MODULE$.apply(size, evidence$36, ev);
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(tensor.dim() == 1, "expecting 1D tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            Log4Error$.MODULE$.unKnowExceptionError(tensor.nElement() > 0, "expecting non-empty tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            tensor2 = tensor;
        }
        Tensor<Object> gauss = tensor2;
        double center = mean2 * (double)gauss.nElement() + 0.5;
        for (int i = 1; i <= gauss.nElement(); ++i) {
            gauss.setValue(i, ev.fromType(BoxesRunTime.boxToDouble((double)((double)amplitude * package$.MODULE$.exp(-(package$.MODULE$.pow(((double)i - center) / (sigma * (double)size), 2.0) / (double)2)))), ConvertableFrom$ConvertableFromDouble$.MODULE$));
        }
        Object object = normalize ? gauss.div(gauss.sum()) : BoxedUnit.UNIT;
        return gauss;
    }

    public Tensor<Object> gaussian1D$mSc$sp(int size, double sigma, int amplitude, boolean normalize, double mean2, Tensor<Object> tensor, ClassTag<Object> evidence$36, TensorNumericMath.TensorNumeric<Object> ev) {
        Tensor<Object> tensor2;
        if (tensor == null) {
            tensor2 = Tensor$.MODULE$.apply(size, evidence$36, ev);
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(tensor.dim() == 1, "expecting 1D tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            Log4Error$.MODULE$.unKnowExceptionError(tensor.nElement() > 0, "expecting non-empty tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            tensor2 = tensor;
        }
        Tensor<Object> gauss = tensor2;
        double center = mean2 * (double)gauss.nElement() + 0.5;
        for (int i = 1; i <= gauss.nElement(); ++i) {
            gauss.setValue(i, ev.fromType(BoxesRunTime.boxToDouble((double)((double)amplitude * package$.MODULE$.exp(-(package$.MODULE$.pow(((double)i - center) / (sigma * (double)size), 2.0) / (double)2)))), ConvertableFrom$ConvertableFromDouble$.MODULE$));
        }
        Object object = normalize ? gauss.div(gauss.sum()) : BoxedUnit.UNIT;
        return gauss;
    }

    public Tensor<BoxedUnit> gaussian1D$mVc$sp(int size, double sigma, int amplitude, boolean normalize, double mean2, Tensor<BoxedUnit> tensor, ClassTag<BoxedUnit> evidence$36, TensorNumericMath.TensorNumeric<BoxedUnit> ev) {
        Tensor<BoxedUnit> tensor2;
        if (tensor == null) {
            tensor2 = Tensor$.MODULE$.apply(size, evidence$36, ev);
        } else {
            Log4Error$.MODULE$.unKnowExceptionError(tensor.dim() == 1, "expecting 1D tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            Log4Error$.MODULE$.unKnowExceptionError(tensor.nElement() > 0, "expecting non-empty tensor", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            tensor2 = tensor;
        }
        Tensor<BoxedUnit> gauss = tensor2;
        double center = mean2 * (double)gauss.nElement() + 0.5;
        for (int i = 1; i <= gauss.nElement(); ++i) {
            gauss.setValue(i, ev.fromType(BoxesRunTime.boxToDouble((double)((double)amplitude * package$.MODULE$.exp(-(package$.MODULE$.pow(((double)i - center) / (sigma * (double)size), 2.0) / (double)2)))), ConvertableFrom$ConvertableFromDouble$.MODULE$));
        }
        Object object = normalize ? gauss.div((BoxedUnit)gauss.sum()) : BoxedUnit.UNIT;
        return gauss;
    }

    private DenseTensor$() {
        MODULE$ = this;
    }
}

