/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.optim.parameters;

import com.intel.analytics.bigdl.dllib.optim.parameters.CompressedTensor;
import com.intel.analytics.bigdl.dllib.optim.parameters.FP16CompressedTensor$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import java.nio.ByteBuffer;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\u0001\u0003\u0001E\u0011!D\u0012)2mM\u0003H.\u001b;t\u0007>l\u0007O]3tg\u0016$G+\u001a8t_JT!a\u0001\u0003\u0002\u0015A\f'/Y7fi\u0016\u00148O\u0003\u0002\u0006\r\u0005)q\u000e\u001d;j[*\u0011q\u0001C\u0001\u0006I2d\u0017N\u0019\u0006\u0003\u0013)\tQAY5hI2T!a\u0003\u0007\u0002\u0013\u0005t\u0017\r\\=uS\u000e\u001c(BA\u0007\u000f\u0003\u0015Ig\u000e^3m\u0015\u0005y\u0011aA2p[\u000e\u0001QC\u0001\n '\r\u00011#\u0007\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0007iYR$D\u0001\u0003\u0013\ta\"A\u0001\tD_6\u0004(/Z:tK\u0012$VM\\:peB\u0011ad\b\u0007\u0001\t\u0015\u0001\u0003A1\u0001\"\u0005\u0005!\u0016C\u0001\u0012&!\t!2%\u0003\u0002%+\t9aj\u001c;iS:<\u0007C\u0001\u000b'\u0013\t9SCA\u0002B]fD\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\bEV4g-\u001a:t!\r!2&L\u0005\u0003YU\u0011Q!\u0011:sCf\u00042\u0001F\u0016/!\t!r&\u0003\u00021+\t!!)\u001f;f\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0014\u0001B:ju\u0016\u0004\"\u0001\u0006\u001b\n\u0005U*\"aA%oi\"Aq\u0007\u0001B\u0002B\u0003-\u0001(\u0001\u0006fm&$WM\\2fIE\u00022!\u000f\u001f\u001e\u001b\u0005Q$BA\u001e\u0016\u0003\u001d\u0011XM\u001a7fGRL!!\u0010\u001e\u0003\u0011\rc\u0017m]:UC\u001eDQa\u0010\u0001\u0005\u0002\u0001\u000ba\u0001P5oSRtDcA!E\u000bR\u0011!i\u0011\t\u00045\u0001i\u0002\"B\u001c?\u0001\bA\u0004\"B\u0015?\u0001\u0004Q\u0003\"\u0002\u001a?\u0001\u0004\u0019\u0004\"B \u0001\t\u00039Ec\u0001%L%R\u0011!)\u0013\u0005\b\u0015\u001a\u000b\t\u0011q\u00019\u0003))g/\u001b3f]\u000e,GE\r\u0005\u0006\u0019\u001a\u0003\r!T\u0001\u0007i\u0016t7o\u001c:\u0011\u00079\u0003V$D\u0001P\u0015\tae!\u0003\u0002R\u001f\n1A+\u001a8t_JDQa\u0015$A\u0002M\n\u0011b\u001d9mSR\u001ch*^7\t\u000b}\u0002A\u0011A+\u0015\u0007YK6\f\u0006\u0002C/\"9\u0001\fVA\u0001\u0002\bA\u0014AC3wS\u0012,gnY3%g!)!\f\u0016a\u0001g\u00051A.\u001a8hi\"DQa\u0015+A\u0002MBQ!\u0018\u0001\u0005\ny\u000bqa\u001c<fe2\f\u0007\u000fF\u0003`K\u001eL7\u000eE\u0002\u0015A\nL!!Y\u000b\u0003\r=\u0003H/[8o!\u0011!2mM\u001a\n\u0005\u0011,\"A\u0002+va2,'\u0007C\u0003g9\u0002\u00071'A\u0006ta2LGo\u00144gg\u0016$\b\"\u00025]\u0001\u0004\u0019\u0014aC:qY&$H*\u001a8hi\"DQA\u001b/A\u0002M\naa\u001c4gg\u0016$\b\"\u0002.]\u0001\u0004\u0019\u0004F\u0001/n!\t!b.\u0003\u0002p+\t1\u0011N\u001c7j]\u0016DQ!\u001d\u0001\u0005BI\f\u0001bY8naJ,7o\u001d\u000b\u0006gR,x/_\u0007\u0002\u0001!)!\u000e\u001da\u0001g!)a\u000f\u001da\u0001\u001b\u0006\u00191O]2\t\u000ba\u0004\b\u0019A\u001a\u0002\u0013M\u00148m\u00144gg\u0016$\b\"\u0002.q\u0001\u0004\u0019\u0004\"B9\u0001\t\u0003ZHCA:}\u0011\u0015a%\u00101\u0001N\u0011\u0015q\b\u0001\"\u0011\u0000\u0003)!WmQ8naJ,7o\u001d\u000b\u000b\u0003\u0003\t9!!\u0003\u0002\f\u0005=\u0001c\u0001\u000b\u0002\u0004%\u0019\u0011QA\u000b\u0003\tUs\u0017\u000e\u001e\u0005\u0006qv\u0004\ra\r\u0005\u0006\u0019v\u0004\r!\u0014\u0005\u0007\u0003\u001bi\b\u0019A\u001a\u0002\u0013Q<Go\u00144gg\u0016$\b\"\u0002.~\u0001\u0004\u0019\u0004B\u0002@\u0001\t\u0003\n\u0019\u0002\u0006\u0003\u0002\u0002\u0005U\u0001B\u0002'\u0002\u0012\u0001\u0007Q\nC\u0004\u0002\u001a\u0001!\t%a\u0007\u0002\u000b\tLH/Z:\u0015\r\u0005u\u0011QFA\u0018!\u0011\ty\"!\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\t1A\\5p\u0015\t\t9#\u0001\u0003kCZ\f\u0017\u0002BA\u0016\u0003C\u0011!BQ=uK\n+hMZ3s\u0011\u0019Q\u0017q\u0003a\u0001g!1!,a\u0006A\u0002MBq!!\u0007\u0001\t\u0003\n\u0019\u0004\u0006\u0002\u0002\u001e!9\u0011q\u0007\u0001\u0005B\u0005e\u0012aA1eIR91/a\u000f\u0002@\u0005\u0005\u0003\u0002CA\u001f\u0003k\u0001\r!!\b\u0002\t\u0011\fG/\u0019\u0005\u0007U\u0006U\u0002\u0019A\u001a\t\ri\u000b)\u00041\u00014\u0011\u001d\t9\u0004\u0001C!\u0003\u000b\"2a]A$\u0011!\ti$a\u0011A\u0002\u0005u\u0001bBA&\u0001\u0011\u0005\u0013QJ\u0001\u0007a\u0006\u0014\u0018\t\u001a3\u0015\u000fM\fy%!\u0015\u0002T!A\u0011QHA%\u0001\u0004\ti\u0002\u0003\u0004k\u0003\u0013\u0002\ra\r\u0005\u00075\u0006%\u0003\u0019A\u001a\t\u000f\u0005-\u0003\u0001\"\u0011\u0002XQ\u00191/!\u0017\t\u0011\u0005u\u0012Q\u000ba\u0001\u0003;\u0001")
public class FP16SplitsCompressedTensor<T>
implements CompressedTensor<T> {
    private final byte[][] buffers;
    private final int size;
    private final ClassTag<T> evidence$1;

    private Option<Tuple2<Object, Object>> overlap(int splitOffset, int splitLength, int offset, int length) {
        return splitOffset > offset + length || splitOffset + splitLength < offset ? None$.MODULE$ : new Some((Object)new Tuple2.mcII.sp(package$.MODULE$.max(offset - splitOffset, 0), package$.MODULE$.min(splitOffset + splitLength, offset + length) - package$.MODULE$.max(splitOffset, offset)));
    }

    @Override
    public FP16SplitsCompressedTensor<T> compress(int offset, Tensor<T> src, int srcOffset, int length) {
        Log4Error$.MODULE$.unKnowExceptionError(src.isContiguous(), "src is expected to be contiguous", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(offset >= 0 && srcOffset >= 0 && srcOffset + length <= src.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset ", " cannot be negative, srcOffset ", " cannot be negative,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset), BoxesRunTime.boxToInteger((int)srcOffset)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" srcOffset ", " + length ", " <= src.nElement() ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)srcOffset), BoxesRunTime.boxToInteger((int)length), BoxesRunTime.boxToInteger((int)src.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(offset + length <= this.size, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset ", " + length ", " should not"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset), BoxesRunTime.boxToInteger((int)length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" greater than size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.size)}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        int tOffset = src.storageOffset() - 1 + srcOffset;
        int splitSize = this.size / this.buffers.length;
        int extraSize = this.size % this.buffers.length;
        for (int i = 0; i < this.buffers.length; ++i) {
            Object object;
            Some some;
            Tuple2 tuple2;
            int curLength;
            int start2 = splitSize * i + package$.MODULE$.min(extraSize, i);
            Option<Tuple2<Object, Object>> option = this.overlap(start2, curLength = splitSize + (i < extraSize ? 1 : 0), offset, length);
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).x()) != null) {
                Object object2;
                int splitOffset = tuple2._1$mcI$sp();
                int overlapLength = tuple2._2$mcI$sp();
                if (this.buffers[i] == null) {
                    this.buffers[i] = new byte[curLength * 2];
                }
                ClassTag classTag = scala.reflect.package$.MODULE$.classTag(this.evidence$1);
                ClassTag classTag2 = scala.reflect.package$.MODULE$.classTag(ClassTag$.MODULE$.Double());
                if (!(classTag != null ? !classTag.equals(classTag2) : classTag2 != null)) {
                    object2 = FP16CompressedTensor$.MODULE$.toFP16((double[])src.storage().array(), tOffset + start2, this.buffers[i], splitOffset, overlapLength);
                } else {
                    ClassTag classTag3 = scala.reflect.package$.MODULE$.classTag(this.evidence$1);
                    ClassTag classTag4 = scala.reflect.package$.MODULE$.classTag(ClassTag$.MODULE$.Float());
                    if (!(classTag3 != null ? !classTag3.equals(classTag4) : classTag4 != null)) {
                        object2 = FP16CompressedTensor$.MODULE$.toFP16((float[])src.storage().array(), tOffset + start2, this.buffers[i], splitOffset, overlapLength);
                    } else {
                        Log4Error$.MODULE$.invalidInputError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scala.reflect.package$.MODULE$.classTag(this.evidence$1)})), "only support Float and Double");
                        object2 = BoxedUnit.UNIT;
                    }
                }
                object = object2;
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        return this;
    }

    @Override
    public FP16SplitsCompressedTensor<T> compress(Tensor<T> tensor) {
        return this.compress(0, (Tensor)tensor, 0, tensor.nElement());
    }

    @Override
    public void deCompress(int srcOffset, Tensor<T> tensor, int tgtOffset, int length) {
        Log4Error$.MODULE$.unKnowExceptionError(tensor.isContiguous(), "tensor is expected to be contiguous", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(srcOffset >= 0 && length > 0 && srcOffset + length <= this.size, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"srcOffset ", " cannot be negative, length ", " should be positive,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)srcOffset), BoxesRunTime.boxToInteger((int)length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" srcOffset ", " + length ", " should not greater than size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)srcOffset), BoxesRunTime.boxToInteger((int)length), BoxesRunTime.boxToInteger((int)this.size)}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        Log4Error$.MODULE$.unKnowExceptionError(tgtOffset >= 0 && tgtOffset + length <= tensor.nElement(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tgtOffset ", " cannot be negative,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)tgtOffset)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tgtOffset ", " + length ", " should not greater than "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)tgtOffset), BoxesRunTime.boxToInteger((int)length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tensor.nElement() ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)tensor.nElement())}))).toString(), Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
        int splitSize = this.size / this.buffers.length;
        int extraSize = this.size % this.buffers.length;
        for (int i = 0; i < this.buffers.length; ++i) {
            BoxedUnit boxedUnit;
            Some some;
            Tuple2 tuple2;
            int curLength;
            int start2 = splitSize * i + package$.MODULE$.min(extraSize, i);
            Option<Tuple2<Object, Object>> option = this.overlap(start2, curLength = splitSize + (i < extraSize ? 1 : 0), srcOffset, length);
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).x()) != null) {
                BoxedUnit boxedUnit2;
                int splitOffset = tuple2._1$mcI$sp();
                int overlapLength = tuple2._2$mcI$sp();
                ClassTag classTag = scala.reflect.package$.MODULE$.classTag(this.evidence$1);
                ClassTag classTag2 = scala.reflect.package$.MODULE$.classTag(ClassTag$.MODULE$.Double());
                if (!(classTag != null ? !classTag.equals(classTag2) : classTag2 != null)) {
                    double[] tdata = (double[])tensor.storage().array();
                    int toffset = tensor.storageOffset() - 1 + tgtOffset;
                    FP16CompressedTensor$.MODULE$.fromFP16(this.buffers[i], splitOffset * 2, overlapLength * 2, tdata, toffset + start2);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    ClassTag classTag3 = scala.reflect.package$.MODULE$.classTag(this.evidence$1);
                    ClassTag classTag4 = scala.reflect.package$.MODULE$.classTag(ClassTag$.MODULE$.Float());
                    if (!(classTag3 != null ? !classTag3.equals(classTag4) : classTag4 != null)) {
                        float[] tdata = (float[])tensor.storage().array();
                        int toffset = tensor.storageOffset() - 1 + tgtOffset;
                        FP16CompressedTensor$.MODULE$.fromFP16(this.buffers[i], splitOffset * 2, overlapLength * 2, tdata, toffset + start2);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        Log4Error$.MODULE$.invalidInputError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scala.reflect.package$.MODULE$.classTag(this.evidence$1)})), "only support Float and Double");
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                }
                boxedUnit = boxedUnit2;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void deCompress(Tensor<T> tensor) {
        this.deCompress(0, tensor, 0, tensor.nElement());
    }

    @Override
    public ByteBuffer bytes(int offset, int length) {
        int splitSize = this.size / this.buffers.length;
        int extraSize = this.size % this.buffers.length;
        for (int i = 0; i < this.buffers.length; ++i) {
            int start2 = splitSize * i + package$.MODULE$.min(extraSize, i);
            int curLength = splitSize + (i < extraSize ? 1 : 0);
            if (start2 != offset || curLength != length) continue;
            Log4Error$.MODULE$.unKnowExceptionError(this.buffers[i] != null, "split has not been inited", Log4Error$.MODULE$.unKnowExceptionError$default$3(), Log4Error$.MODULE$.unKnowExceptionError$default$4());
            return ByteBuffer.wrap(this.buffers[i]);
        }
        Log4Error$.MODULE$.invalidOperationError(false, "Offset and length not match", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        return null;
    }

    @Override
    public ByteBuffer bytes() {
        return this.bytes(0, this.size);
    }

    @Override
    public FP16SplitsCompressedTensor<T> add(ByteBuffer data2, int offset, int length) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public FP16SplitsCompressedTensor<T> add(ByteBuffer data2) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public FP16SplitsCompressedTensor<T> parAdd(ByteBuffer data2, int offset, int length) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public FP16SplitsCompressedTensor<T> parAdd(ByteBuffer data2) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public FP16SplitsCompressedTensor(byte[][] buffers, int size, ClassTag<T> evidence$1) {
        this.buffers = buffers;
        this.size = size;
        this.evidence$1 = evidence$1;
    }

    public FP16SplitsCompressedTensor(Tensor<T> tensor, int splitsNum, ClassTag<T> evidence$2) {
        this(new byte[splitsNum][], tensor.nElement(), evidence$2);
        this.compress((Tensor)tensor);
    }

    public FP16SplitsCompressedTensor(int length, int splitsNum, ClassTag<T> evidence$3) {
        this(new byte[splitsNum][], length, evidence$3);
    }
}

