/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.optim;

import com.intel.analytics.bigdl.dllib.feature.dataset.AbstractDataSet;
import com.intel.analytics.bigdl.dllib.feature.dataset.DataSet$;
import com.intel.analytics.bigdl.dllib.feature.dataset.DistributedDataSet;
import com.intel.analytics.bigdl.dllib.feature.dataset.LocalDataSet;
import com.intel.analytics.bigdl.dllib.feature.dataset.MiniBatch;
import com.intel.analytics.bigdl.dllib.feature.dataset.PaddingParam;
import com.intel.analytics.bigdl.dllib.feature.dataset.Sample;
import com.intel.analytics.bigdl.dllib.feature.dataset.SampleToMiniBatch$;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.AbstractCriterion;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.AbstractModule;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.Activity;
import com.intel.analytics.bigdl.dllib.optim.DistriOptimizer;
import com.intel.analytics.bigdl.dllib.optim.DistriOptimizerV2;
import com.intel.analytics.bigdl.dllib.optim.LocalOptimizer;
import com.intel.analytics.bigdl.dllib.optim.OptimMethod;
import com.intel.analytics.bigdl.dllib.optim.Optimizer;
import com.intel.analytics.bigdl.dllib.optim.parameters.ParameterProcessor;
import com.intel.analytics.bigdl.dllib.tensor.Storage;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.utils.Engine$;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.OptimizerV1$;
import com.intel.analytics.bigdl.dllib.utils.OptimizerV2$;
import com.intel.analytics.bigdl.dllib.utils.OptimizerVersion;
import com.intel.analytics.bigdl.dllib.utils.Table;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

public final class Optimizer$ {
    public static final Optimizer$ MODULE$;
    private final Logger com$intel$analytics$bigdl$dllib$optim$Optimizer$$logger;

    static {
        new Optimizer$();
    }

    public Logger com$intel$analytics$bigdl$dllib$optim$Optimizer$$logger() {
        return this.com$intel$analytics$bigdl$dllib$optim$Optimizer$$logger;
    }

    public String header(int epoch, int count2, long total, int iter, long wallClockTime) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Epoch ", " ", "/", "][Iteration ", "][Wall Clock ", "s]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)epoch), BoxesRunTime.boxToInteger((int)count2), BoxesRunTime.boxToLong((long)total), BoxesRunTime.boxToInteger((int)iter), BoxesRunTime.boxToDouble((double)((double)wallClockTime / 1.0E9))}));
    }

    public <T> void checkSubModules(AbstractModule<Activity, Activity, T> model, Seq<String> subModuleNames, ClassTag<T> evidence$2, TensorNumericMath.TensorNumeric<T> ev) {
        Tuple2<Tensor<T>, Tensor<T>> modelParameters = model.getParameters();
        Tuple2[] p = (Tuple2[])((TraversableOnce)subModuleNames.map((Function1)new Serializable(model, modelParameters){
            public static final long serialVersionUID = 0L;
            private final AbstractModule model$1;
            private final Tuple2 modelParameters$1;

            public final Tuple2<String, Tensor<T>> apply(String subModuleName) {
                Option<AbstractModule<Activity, Activity, T>> subModule = this.model$1.apply(subModuleName);
                Log4Error$.MODULE$.invalidOperationError(subModule.isDefined(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Optimizer: couldn't find ", " in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{subModuleName, this.model$1})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                Tensor subModuleWeights = (Tensor)((AbstractModule)subModule.get()).getParameters()._1();
                Log4Error$.MODULE$.invalidInputError(subModuleWeights.nElement() > 0, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Optimizer: ", " doesn't have"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{subModuleName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" any trainable parameters, please check your model and optimMethods."})).s((Seq)Nil$.MODULE$)).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
                Storage<T> storage = ((Tensor)this.modelParameters$1._1()).storage();
                Storage<T> storage2 = subModuleWeights.storage();
                Log4Error$.MODULE$.invalidOperationError(!(storage != null ? !storage.equals(storage2) : storage2 != null), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Optimizer: ", "'s parameter is not contiguous."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{subModuleName})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                return new Tuple2((Object)subModuleName, (Object)subModuleWeights);
            }
            {
                this.model$1 = model$1;
                this.modelParameters$1 = modelParameters$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        if (p.length != 1) {
            Tuple2[] sortedWeights = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])p).sortWith((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, Tensor<T>> a, Tuple2<String, Tensor<T>> b) {
                    return ((Tensor)a._2()).storageOffset() < ((Tensor)b._2()).storageOffset();
                }
            });
            for (int i = 0; i < sortedWeights.length - 1; ++i) {
                Tuple2 current = sortedWeights[i];
                Tuple2 next2 = sortedWeights[i + 1];
                Log4Error$.MODULE$.invalidOperationError(((Tensor)current._2()).storageOffset() + ((Tensor)current._2()).nElement() <= ((Tensor)next2._2()).storageOffset(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Optimizer: ", " and ", "'s parameters are duplicated."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{current._1(), next2._1()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Please check your model and optimMethods."})).s((Seq)Nil$.MODULE$)).toString(), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            }
        }
    }

    public String getHyperParameterLog(Map<String, OptimMethod<?>> optimMethods) {
        return (String)((TraversableOnce)optimMethods.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, OptimMethod<?>> x0$2) {
                Tuple2<String, OptimMethod<?>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String moduleName = (String)tuple2._1();
                    OptimMethod optimMethod = (OptimMethod)tuple2._2();
                    String log2 = optimMethod.getHyperParameter();
                    String string = log2.isEmpty() ? log2 : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "'s hyper parameters: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{moduleName, log2}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1, String x$2) {
                return new StringBuilder().append((Object)x$1).append((Object)x$2).toString();
            }
        });
    }

    public <T> void saveModel(AbstractModule<Activity, Activity, T> model, Option<String> checkpointPath, boolean overWrite, String postfix) {
        if (checkpointPath.isDefined()) {
            model.save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/model", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{checkpointPath.get(), postfix})), overWrite);
        }
    }

    public <T> String saveModel$default$4() {
        return "";
    }

    public void saveState(Table state, Option<String> checkpointPath, boolean overWrite, String postfix) {
        if (checkpointPath.isDefined()) {
            state.save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/state", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{checkpointPath.get(), postfix})), overWrite);
        }
    }

    public String saveState$default$4() {
        return "";
    }

    public <T> void saveOptimMethod(OptimMethod<T> optimMethod, Option<String> checkpointPath, boolean overWrite, String postfix, ClassTag<T> evidence$3) {
        if (checkpointPath.isDefined()) {
            optimMethod.save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/optimMethod", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{checkpointPath.get(), postfix})), overWrite);
        }
    }

    public <T> String saveOptimMethod$default$4() {
        return "";
    }

    public <T> Optimizer<T, MiniBatch<T>> apply(AbstractModule<Activity, Activity, T> model, RDD<Sample<T>> sampleRDD, AbstractCriterion<Activity, Activity, T> criterion, int batchSize, PaddingParam<T> featurePaddingParam, PaddingParam<T> labelPaddingParam, ClassTag<T> evidence$4, TensorNumericMath.TensorNumeric<T> ev) {
        OptimizerVersion optimizerVersion;
        block4: {
            Optimizer optimizer;
            block3: {
                None$ _labelPaddingParam;
                None$ _featurePaddingParam;
                block2: {
                    _featurePaddingParam = featurePaddingParam == null ? None$.MODULE$ : new Some(featurePaddingParam);
                    _labelPaddingParam = labelPaddingParam == null ? None$.MODULE$ : new Some(labelPaddingParam);
                    optimizerVersion = Engine$.MODULE$.getOptimizerVersion();
                    if (!OptimizerV1$.MODULE$.equals(optimizerVersion)) break block2;
                    optimizer = new DistriOptimizer<T>(model, DataSet$.MODULE$.rdd(sampleRDD, DataSet$.MODULE$.rdd$default$2(), DataSet$.MODULE$.rdd$default$3(), DataSet$.MODULE$.rdd$default$4(), ClassTag$.MODULE$.apply(Sample.class)).$minus$greater(SampleToMiniBatch$.MODULE$.apply(batchSize, _featurePaddingParam, _labelPaddingParam, SampleToMiniBatch$.MODULE$.apply$default$4(), SampleToMiniBatch$.MODULE$.apply$default$5(), evidence$4, ev), ClassTag$.MODULE$.apply(MiniBatch.class)).toDistributed(), criterion, evidence$4, ev);
                    break block3;
                }
                if (!OptimizerV2$.MODULE$.equals(optimizerVersion)) break block4;
                optimizer = new DistriOptimizerV2<T>(model, DataSet$.MODULE$.rdd(sampleRDD, DataSet$.MODULE$.rdd$default$2(), DataSet$.MODULE$.rdd$default$3(), DataSet$.MODULE$.rdd$default$4(), ClassTag$.MODULE$.apply(Sample.class)).$minus$greater(SampleToMiniBatch$.MODULE$.apply(batchSize, _featurePaddingParam, _labelPaddingParam, SampleToMiniBatch$.MODULE$.apply$default$4(), SampleToMiniBatch$.MODULE$.apply$default$5(), evidence$4, ev), ClassTag$.MODULE$.apply(MiniBatch.class)).toDistributed(), criterion, evidence$4, ev);
            }
            return optimizer;
        }
        throw new MatchError((Object)optimizerVersion);
    }

    public <T> Optimizer<T, MiniBatch<T>> apply(AbstractModule<Activity, Activity, T> model, RDD<Sample<T>> sampleRDD, AbstractCriterion<Activity, Activity, T> criterion, int batchSize, MiniBatch<T> miniBatchImpl, ClassTag<T> evidence$5, TensorNumericMath.TensorNumeric<T> ev) {
        OptimizerVersion optimizerVersion;
        block4: {
            Optimizer optimizer;
            block3: {
                block2: {
                    optimizerVersion = Engine$.MODULE$.getOptimizerVersion();
                    if (!OptimizerV1$.MODULE$.equals(optimizerVersion)) break block2;
                    optimizer = new DistriOptimizer<T>(model, DataSet$.MODULE$.rdd(sampleRDD, DataSet$.MODULE$.rdd$default$2(), DataSet$.MODULE$.rdd$default$3(), DataSet$.MODULE$.rdd$default$4(), ClassTag$.MODULE$.apply(Sample.class)).$minus$greater(SampleToMiniBatch$.MODULE$.apply(miniBatchImpl, batchSize, (Option<Object>)None$.MODULE$, evidence$5, ev), ClassTag$.MODULE$.apply(MiniBatch.class)).toDistributed(), criterion, evidence$5, ev);
                    break block3;
                }
                if (!OptimizerV2$.MODULE$.equals(optimizerVersion)) break block4;
                optimizer = new DistriOptimizerV2<T>(model, DataSet$.MODULE$.rdd(sampleRDD, DataSet$.MODULE$.rdd$default$2(), DataSet$.MODULE$.rdd$default$3(), DataSet$.MODULE$.rdd$default$4(), ClassTag$.MODULE$.apply(Sample.class)).$minus$greater(SampleToMiniBatch$.MODULE$.apply(miniBatchImpl, batchSize, (Option<Object>)None$.MODULE$, evidence$5, ev), ClassTag$.MODULE$.apply(MiniBatch.class)).toDistributed(), criterion, evidence$5, ev);
            }
            return optimizer;
        }
        throw new MatchError((Object)optimizerVersion);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T, D> Optimizer<T, D> apply(AbstractModule<Activity, Activity, T> model, AbstractDataSet<D, ?> dataset, AbstractCriterion<Activity, Activity, T> criterion, ClassTag<T> evidence$6, TensorNumericMath.TensorNumeric<T> ev) {
        void var8_15;
        AbstractDataSet<D, ?> abstractDataSet = dataset;
        if (abstractDataSet instanceof DistributedDataSet) {
            void var10_11;
            DistributedDataSet distributedDataSet = (DistributedDataSet)abstractDataSet;
            OptimizerVersion optimizerVersion = Engine$.MODULE$.getOptimizerVersion();
            if (OptimizerV1$.MODULE$.equals(optimizerVersion)) {
                DistriOptimizer<T> distriOptimizer = new DistriOptimizer<T>(model, distributedDataSet.toDistributed(), criterion, evidence$6, ev);
            } else {
                if (!OptimizerV2$.MODULE$.equals(optimizerVersion)) throw new MatchError((Object)optimizerVersion);
                DistriOptimizerV2<T> distriOptimizerV2 = new DistriOptimizerV2<T>(model, distributedDataSet.toDistributed(), criterion, evidence$6, ev);
            }
            void var8_12 = var10_11;
            return var8_15;
        } else if (abstractDataSet instanceof LocalDataSet) {
            LocalDataSet localDataSet = (LocalDataSet)abstractDataSet;
            LocalOptimizer<T> localOptimizer = new LocalOptimizer<T>(model, localDataSet.toLocal(), criterion, evidence$6, ev);
            return var8_15;
        } else {
            Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpected type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataset})), "only support DistributedDataSet and  LocalDataSet", Log4Error$.MODULE$.invalidOperationError$default$4());
            return var8_15;
        }
    }

    public <T> Null$ apply$default$5() {
        return null;
    }

    public <T> Null$ apply$default$6() {
        return null;
    }

    public <T extends ParameterProcessor> int findIndex(ArrayBuffer<ParameterProcessor> parameterProcessors, ClassTag<T> evidence$7) {
        for (int i = 0; i < parameterProcessors.size(); ++i) {
            if (!package$.MODULE$.classTag(evidence$7).runtimeClass().isInstance(parameterProcessors.apply(i))) continue;
            return i;
        }
        return -1;
    }

    private Optimizer$() {
        MODULE$ = this;
        this.com$intel$analytics$bigdl$dllib$optim$Optimizer$$logger = LogManager.getLogger(this.getClass());
    }
}

