/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.optim;

import com.intel.analytics.bigdl.dllib.feature.dataset.segmentation.RLEMasks;
import com.intel.analytics.bigdl.dllib.feature.transform.vision.image.RoiImageInfo$;
import com.intel.analytics.bigdl.dllib.optim.GroundTruthBBox;
import com.intel.analytics.bigdl.dllib.optim.GroundTruthRLE;
import com.intel.analytics.bigdl.dllib.optim.GroundTruthRegion;
import com.intel.analytics.bigdl.dllib.optim.MAPUtil$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.Table;
import scala.Function1;
import scala.Function2;
import scala.Function7;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public final class MAPUtil$ {
    public static final MAPUtil$ MODULE$;

    static {
        new MAPUtil$();
    }

    public Tuple2<Object, Object>[] findTopK(int k, float[][] arr, int column) {
        PriorityQueue q = (PriorityQueue)PriorityQueue$.MODULE$.apply((Seq)Nil$.MODULE$, package$.MODULE$.Ordering().by((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply(Tuple2<Object, Object> x$2) {
                return BoxesRunTime.unboxToFloat((Object)x$2._2());
            }
        }, (Ordering)Ordering.Float$.MODULE$));
        Predef$.MODULE$.refArrayOps((Object[])arr).indices().foreach$mVc$sp((Function1)new Serializable(arr, column, q){
            public static final long serialVersionUID = 0L;
            private final float[][] arr$1;
            private final int column$1;
            private final PriorityQueue q$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.q$1.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToFloat((float)this.arr$1[i][this.column$1]))}));
            }
            {
                this.arr$1 = arr$1;
                this.column$1 = column$1;
                this.q$1 = q$1;
            }
        });
        int end = Math.min(k, q.size());
        return (Tuple2[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), end).map((Function1)new Serializable(q){
            public static final long serialVersionUID = 0L;
            private final PriorityQueue q$1;

            public final Tuple2<Object, Object> apply(int x$3) {
                return (Tuple2)this.q$1.dequeue();
            }
            {
                this.q$1 = q$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Tuple2<ArrayBuffer<GroundTruthRegion>[], int[]> gtTablesToGroundTruthRegions(Table gtTable, int classes, int numIOU, boolean isCOCO, boolean isSegmentation) {
        int[] gtCntByClass = new int[classes];
        ArrayBuffer[] gtImages = (ArrayBuffer[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), gtTable.length()).map((Function1)new Serializable(gtTable, classes, numIOU, isCOCO, isSegmentation, gtCntByClass){
            public static final long serialVersionUID = 0L;
            private final Table gtTable$1;
            public final int classes$1;
            public final int numIOU$1;
            public final boolean isCOCO$1;
            public final boolean isSegmentation$1;
            public final int[] gtCntByClass$1;

            /*
             * WARNING - void declaration
             */
            public final ArrayBuffer<GroundTruthRegion> apply(int i) {
                void var2_2;
                ArrayBuffer gtImage = new ArrayBuffer();
                Table roiLabel = (Table)this.gtTable$1.apply(BoxesRunTime.boxToInteger((int)i));
                if (roiLabel.length() > 0) {
                    Tensor<Object> bbox = RoiImageInfo$.MODULE$.getBBoxes(roiLabel);
                    Tensor<Object> tclasses = RoiImageInfo$.MODULE$.getClasses(roiLabel);
                    Tensor<Object> isCrowd = RoiImageInfo$.MODULE$.getIsCrowd(roiLabel);
                    RLEMasks[] masks = this.isSegmentation$1 ? RoiImageInfo$.MODULE$.getMasks(roiLabel) : null;
                    int bboxCnt = bbox.size(1);
                    Log4Error$.MODULE$.invalidInputError(bboxCnt == tclasses.size(1), "CLASSES of target tables should have thesame size of the bbox counts", Log4Error$.MODULE$.invalidInputError$default$3());
                    Log4Error$.MODULE$.invalidInputError(bboxCnt == isCrowd.nElement(), "ISCROWD of target tables should have thesame size of the bbox counts", Log4Error$.MODULE$.invalidInputError$default$3());
                    Log4Error$.MODULE$.invalidInputError(masks == null || bboxCnt == masks.length, "MASKS of target tables should have thesame size of the bbox counts", Log4Error$.MODULE$.invalidInputError$default$3());
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), bboxCnt).foreach$mVc$sp((Function1)new Serializable(this, gtImage, bbox, tclasses, isCrowd, masks){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.7 $outer;
                        private final ArrayBuffer gtImage$1;
                        private final Tensor bbox$1;
                        private final Tensor tclasses$1;
                        private final Tensor isCrowd$1;
                        private final RLEMasks[] masks$1;

                        public final void apply(int j) {
                            this.apply$mcVI$sp(j);
                        }

                        public void apply$mcVI$sp(int j) {
                            Tuple2 tuple2;
                            Tuple2 tuple22 = tuple2 = this.tclasses$1.dim() == 2 ? new Tuple2((Object)BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToFloat(this.tclasses$1.valueAt(1, j)))), this.tclasses$1.valueAt(2, j)) : new Tuple2((Object)BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToFloat(this.tclasses$1.valueAt(j)))), (Object)BoxesRunTime.boxToFloat((float)0.0f));
                            if (tuple2 != null) {
                                Tuple2 tuple23;
                                int label = tuple2._1$mcI$sp();
                                float _diff = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                                Tuple2 tuple24 = tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)label), (Object)BoxesRunTime.boxToFloat((float)_diff));
                                int label2 = tuple24._1$mcI$sp();
                                float _diff2 = BoxesRunTime.unboxToFloat((Object)tuple24._2());
                                float diff = BoxesRunTime.unboxToFloat(this.isCrowd$1.valueAt(j)) != 0.0f || _diff2 != 0.0f ? 1.0f : 0.0f;
                                GroundTruthRegion newGt = this.$outer.isSegmentation$1 ? new GroundTruthRLE(this.$outer.numIOU$1, label2, diff, this.masks$1[j - 1]) : new GroundTruthBBox(this.$outer.isCOCO$1, this.$outer.numIOU$1, label2, diff, BoxesRunTime.unboxToFloat(this.bbox$1.valueAt(j, 1)), BoxesRunTime.unboxToFloat(this.bbox$1.valueAt(j, 2)), BoxesRunTime.unboxToFloat(this.bbox$1.valueAt(j, 3)), BoxesRunTime.unboxToFloat(this.bbox$1.valueAt(j, 4)));
                                this.gtImage$1.$plus$eq((Object)newGt);
                                Log4Error$.MODULE$.invalidInputError(label2 >= 0 && label2 < this.$outer.classes$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bad label id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)label2)})), Log4Error$.MODULE$.invalidInputError$default$3());
                                if (diff == 0.0f) {
                                    this.$outer.gtCntByClass$1[label2] = this.$outer.gtCntByClass$1[label2] + 1;
                                }
                                return;
                            }
                            throw new MatchError((Object)tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.gtImage$1 = gtImage$1;
                            this.bbox$1 = bbox$1;
                            this.tclasses$1 = tclasses$1;
                            this.isCrowd$1 = isCrowd$1;
                            this.masks$1 = masks$1;
                        }
                    });
                }
                return var2_2;
            }
            {
                this.gtTable$1 = gtTable$1;
                this.classes$1 = classes$1;
                this.numIOU$1 = numIOU$1;
                this.isCOCO$1 = isCOCO$1;
                this.isSegmentation$1 = isSegmentation$1;
                this.gtCntByClass$1 = gtCntByClass$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ArrayBuffer.class));
        return new Tuple2((Object)gtImages, (Object)gtCntByClass);
    }

    public void parseDetection(ArrayBuffer<GroundTruthRegion> gtBbox, int label, float score, float x1, float y1, float x2, float y2, RLEMasks mask, int classes, float[] iou, ArrayBuffer<Tuple2<Object, Object>>[][] predictByClasses) {
        Log4Error$.MODULE$.invalidInputError(label >= 0 && label < classes, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bad label id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)label)})), Log4Error$.MODULE$.invalidInputError$default$3());
        Predef$.MODULE$.floatArrayOps(iou).indices().foreach$mVc$sp((Function1)new Serializable(gtBbox, label, score, x1, y1, x2, y2, mask, iou, predictByClasses){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer gtBbox$1;
            public final int label$1;
            private final float score$1;
            public final float x1$1;
            public final float y1$1;
            public final float x2$1;
            public final float y2$1;
            public final RLEMasks mask$1;
            public final float[] iou$1;
            private final ArrayBuffer[][] predictByClasses$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Option matchedGt = this.gtBbox$1.toIterator().filter((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.parseDetection.1 $outer;
                    private final int i$1;

                    public final boolean apply(GroundTruthRegion gt) {
                        return this.$outer.label$1 == gt.label() && gt.canOccupy(this.i$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                }).flatMap((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.parseDetection.1 $outer;
                    private final int i$1;

                    public final Iterator<Tuple2<GroundTruthRegion, Object>> apply(GroundTruthRegion gt) {
                        float iouRate = gt.getIOURate(this.$outer.x1$1, this.$outer.y1$1, this.$outer.x2$1, this.$outer.y2$1, this.$outer.mask$1);
                        return iouRate >= this.$outer.iou$1[this.i$1] ? package$.MODULE$.Iterator().single((Object)new Tuple2((Object)gt, (Object)BoxesRunTime.boxToFloat((float)iouRate))) : package$.MODULE$.Iterator().empty();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                }).reduceOption((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<GroundTruthRegion, Object> apply(Tuple2<GroundTruthRegion, Object> gtArea1, Tuple2<GroundTruthRegion, Object> gtArea2) {
                        return ((GroundTruthRegion)gtArea1._1()).diff() != ((GroundTruthRegion)gtArea2._1()).diff() ? (((GroundTruthRegion)gtArea1._1()).diff() > ((GroundTruthRegion)gtArea2._1()).diff() ? gtArea2 : gtArea1) : (BoxesRunTime.unboxToFloat((Object)gtArea1._2()) > BoxesRunTime.unboxToFloat((Object)gtArea2._2()) ? gtArea1 : gtArea2);
                    }
                }).map((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final int i$1;

                    public final GroundTruthRegion apply(Tuple2<GroundTruthRegion, Object> bbox) {
                        ((GroundTruthRegion)bbox._1()).occupy(this.i$1);
                        return (GroundTruthRegion)bbox._1();
                    }
                    {
                        this.i$1 = i$1;
                    }
                });
                if (matchedGt.isEmpty() || ((GroundTruthRegion)matchedGt.get()).diff() == 0.0f) {
                    this.predictByClasses$1[i][this.label$1].append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToFloat((float)this.score$1), (Object)BoxesRunTime.boxToBoolean((boolean)matchedGt.isDefined()))}));
                }
            }
            {
                this.gtBbox$1 = gtBbox$1;
                this.label$1 = label$1;
                this.score$1 = score$1;
                this.x1$1 = x1$1;
                this.y1$1 = y1$1;
                this.x2$1 = x2$1;
                this.y2$1 = y2$1;
                this.mask$1 = mask$1;
                this.iou$1 = iou$1;
                this.predictByClasses$1 = predictByClasses$1;
            }
        });
    }

    public void parseSegmentationTensorResult(Tensor<Object> outTensor, Function7<Object, Object, Object, Object, Object, Object, Object, BoxedUnit> func) {
        Log4Error$.MODULE$.invalidInputError(outTensor.dim() == 2, "the output tensor should have 2 dimensions", Log4Error$.MODULE$.invalidInputError$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), outTensor.size(1)).foreach$mVc$sp((Function1)new Serializable(outTensor, func){
            public static final long serialVersionUID = 0L;
            private final Tensor outTensor$1;
            public final Function7 func$1;

            public final void apply(int imgId) {
                this.apply$mcVI$sp(imgId);
            }

            public void apply$mcVI$sp(int imgId) {
                Tensor<T> batch = this.outTensor$1.select(1, imgId + 1);
                int batchSize = (int)BoxesRunTime.unboxToFloat(batch.valueAt(1));
                IntRef offset = IntRef.create((int)2);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), batchSize).foreach$mVc$sp((Function1)new Serializable(this, batch, offset, imgId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.parseSegmentationTensorResult.1 $outer;
                    private final Tensor batch$1;
                    private final IntRef offset$1;
                    private final int imgId$1;

                    public final void apply(int bboxIdx) {
                        this.apply$mcVI$sp(bboxIdx);
                    }

                    public void apply$mcVI$sp(int bboxIdx) {
                        int label = (int)BoxesRunTime.unboxToFloat(this.batch$1.valueAt(this.offset$1.elem));
                        float score = BoxesRunTime.unboxToFloat(this.batch$1.valueAt(this.offset$1.elem + 1));
                        float x1 = BoxesRunTime.unboxToFloat(this.batch$1.valueAt(this.offset$1.elem + 2));
                        float y1 = BoxesRunTime.unboxToFloat(this.batch$1.valueAt(this.offset$1.elem + 3));
                        float x2 = BoxesRunTime.unboxToFloat(this.batch$1.valueAt(this.offset$1.elem + 4));
                        float y2 = BoxesRunTime.unboxToFloat(this.batch$1.valueAt(this.offset$1.elem + 5));
                        this.$outer.func$1.apply((Object)BoxesRunTime.boxToInteger((int)this.imgId$1), (Object)BoxesRunTime.boxToInteger((int)label), (Object)BoxesRunTime.boxToFloat((float)score), (Object)BoxesRunTime.boxToFloat((float)x1), (Object)BoxesRunTime.boxToFloat((float)y1), (Object)BoxesRunTime.boxToFloat((float)x2), (Object)BoxesRunTime.boxToFloat((float)y2));
                        this.offset$1.elem += 6;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.batch$1 = batch$1;
                        this.offset$1 = offset$1;
                        this.imgId$1 = imgId$1;
                    }
                });
            }
            {
                this.outTensor$1 = outTensor$1;
                this.func$1 = func$1;
            }
        });
    }

    private MAPUtil$() {
        MODULE$ = this;
    }
}

