/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.optim;

import com.intel.analytics.bigdl.dllib.feature.dataset.AbstractDataSet;
import com.intel.analytics.bigdl.dllib.feature.dataset.DistributedDataSet;
import com.intel.analytics.bigdl.dllib.feature.dataset.MiniBatch;
import com.intel.analytics.bigdl.dllib.models.utils.ModelBroadcast;
import com.intel.analytics.bigdl.dllib.models.utils.ModelBroadcast$;
import com.intel.analytics.bigdl.dllib.nn.Container;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.AbstractCriterion;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.AbstractModule;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.Activity;
import com.intel.analytics.bigdl.dllib.optim.AGGREGATE_GRADIENT_TIME$;
import com.intel.analytics.bigdl.dllib.optim.AGGREGATE_PARTITION_GRADIENT$;
import com.intel.analytics.bigdl.dllib.optim.AbstractOptimizer;
import com.intel.analytics.bigdl.dllib.optim.COMPUTE_WEIGHT_AVERAGE$;
import com.intel.analytics.bigdl.dllib.optim.COMPUTING_TIME_AVERAGE$;
import com.intel.analytics.bigdl.dllib.optim.COMPUTING_TIME_EACH_NODE$;
import com.intel.analytics.bigdl.dllib.optim.DistriOptimizer;
import com.intel.analytics.bigdl.dllib.optim.DistriOptimizerV2;
import com.intel.analytics.bigdl.dllib.optim.DistriOptimizerV2$;
import com.intel.analytics.bigdl.dllib.optim.DistriOptimizerV2$$anonfun$com$intel$analytics$bigdl$dllib$optim$DistriOptimizerV2$;
import com.intel.analytics.bigdl.dllib.optim.DistriOptimizerV2$$anonfun$iteration$1$;
import com.intel.analytics.bigdl.dllib.optim.DistriOptimizerV2$TrainingConfig$4$;
import com.intel.analytics.bigdl.dllib.optim.GET_WEIGHTS_AVERAGE$;
import com.intel.analytics.bigdl.dllib.optim.GET_WEIGHTS_EACH_NODE$;
import com.intel.analytics.bigdl.dllib.optim.LossWithElapsedTime;
import com.intel.analytics.bigdl.dllib.optim.MasterCache;
import com.intel.analytics.bigdl.dllib.optim.MetricEntry;
import com.intel.analytics.bigdl.dllib.optim.Metrics;
import com.intel.analytics.bigdl.dllib.optim.OptimMethod;
import com.intel.analytics.bigdl.dllib.optim.Optimizer$;
import com.intel.analytics.bigdl.dllib.optim.PUT_GRADIENT$;
import com.intel.analytics.bigdl.dllib.optim.ParamSegments;
import com.intel.analytics.bigdl.dllib.optim.Replica;
import com.intel.analytics.bigdl.dllib.optim.SEND_WEIGHTS_AVERAGE$;
import com.intel.analytics.bigdl.dllib.optim.StateEntry$;
import com.intel.analytics.bigdl.dllib.optim.TrainingContext;
import com.intel.analytics.bigdl.dllib.optim.TrainingTrace;
import com.intel.analytics.bigdl.dllib.optim.TrainingTrace$;
import com.intel.analytics.bigdl.dllib.optim.Trigger;
import com.intel.analytics.bigdl.dllib.optim.ValidationMethod;
import com.intel.analytics.bigdl.dllib.optim.parameters.AllReduceParameter;
import com.intel.analytics.bigdl.dllib.optim.parameters.FutureResult;
import com.intel.analytics.bigdl.dllib.optim.parameters.ParameterProcessor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.utils.Engine$;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.Table;
import com.intel.analytics.bigdl.dllib.utils.intermediate.ConversionUtils$;
import com.intel.analytics.bigdl.dllib.visualization.TrainSummary;
import com.intel.analytics.bigdl.dllib.visualization.ValidationSummary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.DoubleAccumulator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileObjectRef;

public final class DistriOptimizerV2$
extends AbstractOptimizer {
    public static final DistriOptimizerV2$ MODULE$;
    private final Logger logger;

    static {
        new DistriOptimizerV2$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DistriOptimizerV2$TrainingConfig$4$ TrainingConfig$2$lzycompute(VolatileObjectRef x$1) {
        DistriOptimizerV2$ distriOptimizerV2$ = this;
        synchronized (distriOptimizerV2$) {
            if (x$1.elem != null) return (DistriOptimizerV2$TrainingConfig$4$)x$1.elem;
            x$1.elem = new DistriOptimizerV2$TrainingConfig$4$();
            return (DistriOptimizerV2$TrainingConfig$4$)x$1.elem;
        }
    }

    public Logger logger() {
        return this.logger;
    }

    public <T> void optimize(MasterCache<T> cacheOfMaster, RDD<DistriOptimizerV2.Cache<T>> cacheOfSlave, DistributedDataSet<MiniBatch<T>> dataset, Trigger endWhen, Option<Trigger> validationTrigger, Option<AbstractDataSet<MiniBatch<T>, ?>> validationDataSet, Option<ValidationMethod<T>[]> validationMethods, Option<Trigger> cacheTrigger, Option<String> cachePath, Option<TrainSummary> trainSummary, Option<ValidationSummary> validationSummary, boolean isOverWrite, TrainingContext<T> context, ClassTag<T> evidence$1, TensorNumericMath.TensorNumeric<T> ev) {
        OptimMethod headOptimMethod = (OptimMethod)cacheOfMaster.optimMethods().values().head();
        context.loadState(headOptimMethod.state());
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"config ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{context.state()})));
        if (BoxesRunTime.unboxToInt(headOptimMethod.state().apply(StateEntry$.MODULE$.RECORDS_PROCESSED())) == 0) {
            long shuffleBefore = System.nanoTime();
            this.logger().info("Shuffle data");
            dataset.shuffle();
            long shuffleEnd = System.nanoTime();
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Shuffle data complete. Takes ", "s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)(shuffleEnd - shuffleBefore) / 1.0E9))})));
        }
        SparkContext sc = dataset.originRDD().sparkContext();
        RDD trainingDataSet = (RDD)dataset.data(true);
        TrainingTrace trainingTrace = TrainingTrace$.MODULE$.apply(headOptimMethod.state());
        while (!endWhen.apply(context.state())) {
            this.iteration(sc, trainingDataSet, cacheOfSlave, cacheOfMaster, context, trainingTrace, evidence$1, ev);
            if (context.hasCompleteAllSamples(trainingTrace.recordsOfEpoch(), cacheOfMaster.model())) {
                dataset.shuffle();
                trainingDataSet = (RDD)dataset.data(true);
            }
            String _header = Optimizer$.MODULE$.header(trainingTrace.epochs() - 1, trainingTrace.recordsOfEpoch(), context.numSamples(), trainingTrace.iterations(), trainingTrace.trainingTakes());
            this.validate(validationTrigger, validationDataSet, validationMethods, context.subModelNumber(), cacheOfSlave, context.state(), validationSummary, _header, cacheOfMaster.parameter());
            this.checkpoint(cacheTrigger, cachePath, isOverWrite, trainingTrace.trainingTakes(), cacheOfSlave, context.state(), cacheOfMaster.parameter(), cacheOfMaster.optimMethods(), cacheOfMaster.model(), evidence$1, ev);
            trainSummary.foreach((Function1)new Serializable(cacheOfMaster, cacheOfSlave, context, evidence$1, ev){
                public static final long serialVersionUID = 0L;
                private final MasterCache cacheOfMaster$1;
                private final RDD cacheOfSlave$1;
                private final TrainingContext context$1;
                private final ClassTag evidence$1$1;
                private final TensorNumericMath.TensorNumeric ev$1;

                public final void apply(TrainSummary summary2) {
                    DistriOptimizerV2$.MODULE$.saveSummary(summary2, this.cacheOfSlave$1, this.context$1.state(), this.cacheOfMaster$1.parameter(), this.cacheOfMaster$1.model(), this.evidence$1$1, this.ev$1);
                }
                {
                    this.cacheOfMaster$1 = cacheOfMaster$1;
                    this.cacheOfSlave$1 = cacheOfSlave$1;
                    this.context$1 = context$1;
                    this.evidence$1$1 = evidence$1$1;
                    this.ev$1 = ev$1;
                }
            });
        }
        return;
    }

    private void initMetrics(SparkContext sc, Metrics metrics, int partitionNum) {
        metrics.set(COMPUTING_TIME_EACH_NODE$.MODULE$.value(), (ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)), sc);
        metrics.set(GET_WEIGHTS_EACH_NODE$.MODULE$.value(), (ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)), sc);
        metrics.set(COMPUTING_TIME_AVERAGE$.MODULE$.value(), 0.0, sc, partitionNum);
        metrics.set(AGGREGATE_GRADIENT_TIME$.MODULE$.value(), 0.0, sc, partitionNum);
        metrics.set(GET_WEIGHTS_AVERAGE$.MODULE$.value(), 0.0, sc, partitionNum);
        metrics.set(PUT_GRADIENT$.MODULE$.value(), 0.0, sc, Engine$.MODULE$.nodeNumber());
        metrics.set(AGGREGATE_PARTITION_GRADIENT$.MODULE$.value(), 0.0, sc, Engine$.MODULE$.nodeNumber());
        metrics.set(COMPUTE_WEIGHT_AVERAGE$.MODULE$.value(), 0.0, sc, Engine$.MODULE$.nodeNumber());
        metrics.set(SEND_WEIGHTS_AVERAGE$.MODULE$.value(), 0.0, sc, Engine$.MODULE$.nodeNumber());
    }

    private <T> void iteration(SparkContext sc, RDD<MiniBatch<T>> dataRDD, RDD<DistriOptimizerV2.Cache<T>> models, MasterCache<T> cacheOfMaster, TrainingContext<T> context, TrainingTrace trainingTrace, ClassTag<T> evidence$2, TensorNumericMath.TensorNumeric<T> ev) {
        DoubleAccumulator lossSum = sc.doubleAccumulator("loss sum");
        DoubleAccumulator recordsNum = sc.doubleAccumulator("record number");
        Metrics metrics = cacheOfMaster.metrics();
        int partitionNum = cacheOfMaster.partitionNum();
        this.initMetrics(sc, metrics, partitionNum);
        trainingTrace.traceIteration(new Serializable(dataRDD, models, cacheOfMaster, context, evidence$2, ev, lossSum, recordsNum, metrics){
            public static final long serialVersionUID = 0L;
            private final RDD dataRDD$1;
            private final RDD models$1;
            private final MasterCache cacheOfMaster$2;
            public final TrainingContext context$3;
            public final ClassTag evidence$2$1;
            public final TensorNumericMath.TensorNumeric ev$3;
            public final DoubleAccumulator lossSum$1;
            public final DoubleAccumulator recordsNum$1;
            public final Metrics metrics$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int successModels = BoxesRunTime.unboxToInt((Object)this.dataRDD$1.zipPartitions(this.models$1, true, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.iteration.1 $outer;

                    public final Iterator<Object> apply(Iterator<MiniBatch<T>> data2, Iterator<DistriOptimizerV2.Cache<T>> iter) {
                        DistriOptimizerV2.Cache cached = (DistriOptimizerV2.Cache)iter.next();
                        int offset = cached.parameter().paramOffset();
                        int size = cached.parameter().size();
                        Tensor<T> weights = ((Tensor)Predef$.MODULE$.refArrayOps((Object[])cached.modelWeights()).head()).narrow(1, offset, size);
                        MiniBatch[] miniBatchBuffer = (MiniBatch[])TrainingTrace$.MODULE$.time(new Serializable(this, cached, weights, data2){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$iteration$1$$anonfun$3 $outer;
                            private final DistriOptimizerV2.Cache cached$2;
                            private final Tensor weights$1;
                            private final Iterator data$3;

                            /*
                             * WARNING - void declaration
                             */
                            public final MiniBatch<T>[] apply() {
                                void var2_2;
                                FutureResult<Object> weightsResults = this.cached$2.parameter().getWeights(this.weights$1);
                                MiniBatch<T>[] batch = this.$outer.com$intel$analytics$bigdl$dllib$optim$DistriOptimizerV2$$anonfun$$anonfun$$$outer().context$3.fetchBatch(this.data$3, this.$outer.com$intel$analytics$bigdl$dllib$optim$DistriOptimizerV2$$anonfun$$anonfun$$$outer().evidence$2$1);
                                weightsResults.waitResult();
                                return var2_2;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.cached$2 = cached$2;
                                this.weights$1 = weights$1;
                                this.data$3 = data$3;
                            }
                        }, this.$outer.metrics$1, (MetricEntry[])((Object[])new MetricEntry[]{GET_WEIGHTS_AVERAGE$.MODULE$, GET_WEIGHTS_EACH_NODE$.MODULE$}));
                        DistriOptimizerV2.TrainingResults results = DistriOptimizerV2$.MODULE$.com$intel$analytics$bigdl$dllib$optim$DistriOptimizerV2$$train(cached, miniBatchBuffer, this.$outer.context$3, this.$outer.metrics$1, this.$outer.evidence$2$1, this.$outer.ev$3);
                        this.$outer.lossSum$1.add(results.loss());
                        this.$outer.recordsNum$1.add((double)results.records());
                        return scala.package$.MODULE$.Iterator().single((Object)BoxesRunTime.boxToInteger((int)results.successed()));
                    }

                    public /* synthetic */ anonfun.iteration.1 com$intel$analytics$bigdl$dllib$optim$DistriOptimizerV2$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(DistriOptimizerV2.Cache.class), ClassTag$.MODULE$.Int()).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int x$1, int x$2) {
                        return this.apply$mcIII$sp(x$1, x$2);
                    }

                    public int apply$mcIII$sp(int x$1, int x$2) {
                        return x$1 + x$2;
                    }
                }));
                DistriOptimizerV2$.MODULE$.com$intel$analytics$bigdl$dllib$optim$DistriOptimizerV2$$parameterSync(Predef$.MODULE$.Double2double(this.lossSum$1.value()), successModels, this.cacheOfMaster$2, this.models$1, this.context$3, this.evidence$2$1, this.ev$3);
            }
            {
                this.dataRDD$1 = dataRDD$1;
                this.models$1 = models$1;
                this.cacheOfMaster$2 = cacheOfMaster$2;
                this.context$3 = context$3;
                this.evidence$2$1 = evidence$2$1;
                this.ev$3 = ev$3;
                this.lossSum$1 = lossSum$1;
                this.recordsNum$1 = recordsNum$1;
                this.metrics$1 = metrics$1;
            }
        });
        this.driverStatesUpdate(cacheOfMaster, (int)Predef$.MODULE$.Double2double(recordsNum.value()), context, trainingTrace, metrics, evidence$2, ev);
    }

    public <T> Tuple2<RDD<DistriOptimizerV2.Cache<T>>, ModelBroadcast<T>> com$intel$analytics$bigdl$dllib$optim$DistriOptimizerV2$$initCacheOfSlave(MasterCache<T> cacheOfMaster, DistributedDataSet<MiniBatch<T>> dataset, TrainingContext<T> context, ClassTag<T> evidence$3, TensorNumericMath.TensorNumeric<T> ev) {
        VolatileObjectRef TrainingConfig$module = VolatileObjectRef.zero();
        Com_intel_analytics_bigdl_dllib_optim_DistriOptimizerV2$TrainingConfig$3<T> config = this.TrainingConfig$2(TrainingConfig$module).apply(cacheOfMaster.criterion(), cacheOfMaster.validationMethods(), cacheOfMaster.optimMethods(), cacheOfMaster.parameterSplits(), cacheOfMaster.parameterProcessers());
        SparkContext sc = dataset.originRDD().sparkContext();
        public class Com_intel_analytics_bigdl_dllib_optim_DistriOptimizerV2$TrainingConfig$3<T>
        implements Product,
        Serializable {
            private final AbstractCriterion<Activity, Activity, T> criterion;
            private final Option<ValidationMethod<T>[]> validationMethods;
            private final Map<String, OptimMethod<T>> optimMethods;
            private final Map<String, Tuple2<Object, Object>> parameterSplits;
            private final ParameterProcessor[] parameterProcessers;

            public AbstractCriterion<Activity, Activity, T> criterion() {
                return this.criterion;
            }

            public Option<ValidationMethod<T>[]> validationMethods() {
                return this.validationMethods;
            }

            public Map<String, OptimMethod<T>> optimMethods() {
                return this.optimMethods;
            }

            public Map<String, Tuple2<Object, Object>> parameterSplits() {
                return this.parameterSplits;
            }

            public ParameterProcessor[] parameterProcessers() {
                return this.parameterProcessers;
            }

            public <T> Com_intel_analytics_bigdl_dllib_optim_DistriOptimizerV2$TrainingConfig$3<T> copy(AbstractCriterion<Activity, Activity, T> criterion, Option<ValidationMethod<T>[]> validationMethods, Map<String, OptimMethod<T>> optimMethods, Map<String, Tuple2<Object, Object>> parameterSplits, ParameterProcessor[] parameterProcessers) {
                return new Com_intel_analytics_bigdl_dllib_optim_DistriOptimizerV2$TrainingConfig$3<T><T>(criterion, validationMethods, optimMethods, parameterSplits, parameterProcessers);
            }

            public <T> AbstractCriterion<Activity, Activity, T> copy$default$1() {
                return this.criterion();
            }

            public <T> Option<ValidationMethod<T>[]> copy$default$2() {
                return this.validationMethods();
            }

            public <T> Map<String, OptimMethod<T>> copy$default$3() {
                return this.optimMethods();
            }

            public <T> Map<String, Tuple2<Object, Object>> copy$default$4() {
                return this.parameterSplits();
            }

            public <T> ParameterProcessor[] copy$default$5() {
                return this.parameterProcessers();
            }

            public String productPrefix() {
                return "TrainingConfig";
            }

            public int productArity() {
                return 5;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 4: {
                        object = this.parameterProcessers();
                        break;
                    }
                    case 3: {
                        object = this.parameterSplits();
                        break;
                    }
                    case 2: {
                        object = this.optimMethods();
                        break;
                    }
                    case 1: {
                        object = this.validationMethods();
                        break;
                    }
                    case 0: {
                        object = this.criterion();
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Com_intel_analytics_bigdl_dllib_optim_DistriOptimizerV2$TrainingConfig$3;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Com_intel_analytics_bigdl_dllib_optim_DistriOptimizerV2$TrainingConfig$3)) return false;
                boolean bl = true;
                if (!bl) return false;
                Com_intel_analytics_bigdl_dllib_optim_DistriOptimizerV2$TrainingConfig$3 var4_4 = (Com_intel_analytics_bigdl_dllib_optim_DistriOptimizerV2$TrainingConfig$3)x$1;
                AbstractCriterion<Activity, Activity, T> abstractCriterion = this.criterion();
                AbstractCriterion<Activity, Activity, T> abstractCriterion2 = var4_4.criterion();
                if (abstractCriterion == null) {
                    if (abstractCriterion2 != null) {
                        return false;
                    }
                } else if (!((Object)abstractCriterion).equals(abstractCriterion2)) return false;
                Option<ValidationMethod<T>[]> option = this.validationMethods();
                Option<ValidationMethod<T>[]> option2 = var4_4.validationMethods();
                if (option == null) {
                    if (option2 != null) {
                        return false;
                    }
                } else if (!option.equals(option2)) return false;
                Map<String, OptimMethod<T>> map = this.optimMethods();
                Map<String, OptimMethod<T>> map2 = var4_4.optimMethods();
                if (map == null) {
                    if (map2 != null) {
                        return false;
                    }
                } else if (!map.equals(map2)) return false;
                Map<String, Tuple2<Object, Object>> map3 = this.parameterSplits();
                Map<String, Tuple2<Object, Object>> map4 = var4_4.parameterSplits();
                if (map3 == null) {
                    if (map4 != null) {
                        return false;
                    }
                } else if (!map3.equals(map4)) return false;
                if (this.parameterProcessers() != var4_4.parameterProcessers()) return false;
                if (!var4_4.canEqual(this)) return false;
                return true;
            }

            public Com_intel_analytics_bigdl_dllib_optim_DistriOptimizerV2$TrainingConfig$3(AbstractCriterion<Activity, Activity, T> criterion, Option<ValidationMethod<T>[]> validationMethods, Map<String, OptimMethod<T>> optimMethods, Map<String, Tuple2<Object, Object>> parameterSplits, ParameterProcessor[] parameterProcessers) {
                this.criterion = criterion;
                this.validationMethods = validationMethods;
                this.optimMethods = optimMethods;
                this.parameterSplits = parameterSplits;
                this.parameterProcessers = parameterProcessers;
                Product.class.$init$((Product)this);
            }
        }
        Broadcast broadcast = sc.broadcast(config, ClassTag$.MODULE$.apply(Com_intel_analytics_bigdl_dllib_optim_DistriOptimizerV2$TrainingConfig$3.class));
        AbstractModule<Activity, Activity, T> model = ConversionUtils$.MODULE$.convert(cacheOfMaster.model(), evidence$3);
        model.getParameters();
        ModelBroadcast<T> modelBroadcast = ModelBroadcast$.MODULE$.apply(evidence$3, ev).broadcast(sc, model);
        int nExecutor = Engine$.MODULE$.nodeNumber();
        int executorCores = Engine$.MODULE$.coreNumber();
        AllReduceParameter<T> allReduceParameter = cacheOfMaster.parameter();
        int subModelNumber = context.subModelNumber();
        Table state = context.state();
        RDD<?> qual$1 = dataset.originRDD();
        Serializable x$28 = new Serializable(evidence$3, ev, broadcast, modelBroadcast, allReduceParameter, subModelNumber, state){
            public static final long serialVersionUID = 0L;
            public final ClassTag evidence$3$1;
            private final TensorNumericMath.TensorNumeric ev$5;
            private final Broadcast broadcast$1;
            public final ModelBroadcast modelBroadcast$1;
            private final AllReduceParameter allReduceParameter$1;
            private final int subModelNumber$1;
            public final Table state$1;

            public final Iterator<DistriOptimizerV2.Cache<T>> apply(Iterator<Object> x$3) {
                int partitionId = TaskContext$.MODULE$.getPartitionId();
                Com_intel_analytics_bigdl_dllib_optim_DistriOptimizerV2$TrainingConfig$3 config = (Com_intel_analytics_bigdl_dllib_optim_DistriOptimizerV2$TrainingConfig$3)this.broadcast$1.value();
                Replica[] replicas = (Replica[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.subModelNumber$1).map((Function1)new Serializable(this, partitionId, config){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.5 $outer;
                    private final int partitionId$1;
                    private final Com_intel_analytics_bigdl_dllib_optim_DistriOptimizerV2$TrainingConfig$3 config$1;

                    public final Replica<T> apply(int x$4) {
                        AbstractModule<Activity, Activity, T> localModel = this.$outer.modelBroadcast$1.value(true, this.$outer.modelBroadcast$1.value$default$2());
                        AbstractCriterion<Activity, Activity, T> localCriterion = this.config$1.criterion().cloneCriterion();
                        Table localState = this.$outer.state$1.clone();
                        None$ localMethod = this.config$1.validationMethods().isDefined() ? new Some(Predef$.MODULE$.refArrayOps((Object[])this.config$1.validationMethods().get()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final ValidationMethod<T> apply(ValidationMethod<T> x$5) {
                                return x$5.clone();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ValidationMethod.class)))) : None$.MODULE$;
                        Tuple2<Tensor<T>, Tensor<T>> tuple2 = localModel.getParameters();
                        if (tuple2 != null) {
                            Tuple2 tuple22;
                            Tensor weights = (Tensor)tuple2._1();
                            Tensor grads = (Tensor)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)weights, (Object)grads);
                            Tensor weights2 = (Tensor)tuple23._1();
                            Tensor grads2 = (Tensor)tuple23._2();
                            DistriOptimizerV2$.MODULE$.com$intel$analytics$bigdl$dllib$optim$DistriOptimizerV2$$setModelId(localModel, this.partitionId$1, this.$outer.evidence$3$1);
                            return new Replica<T>(localModel, weights2, grads2, localCriterion, localState, (Option<ValidationMethod<T>[]>)localMethod);
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.partitionId$1 = partitionId$1;
                        this.config$1 = config$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Replica.class));
                DistriOptimizerV2$.MODULE$.logger().info(new StringBuilder().append((Object)"model thread pool size is ").append((Object)BoxesRunTime.boxToInteger((int)Engine$.MODULE$.model().getPoolSize())).toString());
                int offset = this.allReduceParameter$1.paramOffset();
                int size = this.allReduceParameter$1.size();
                this.allReduceParameter$1.init(((Replica)Predef$.MODULE$.refArrayOps((Object[])replicas).head()).weights().narrow(1, offset, size), this.ev$5);
                return scala.package$.MODULE$.Iterator().single(new DistriOptimizerV2.Cache<T>((AbstractModule[])Predef$.MODULE$.refArrayOps((Object[])replicas).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final AbstractModule<Activity, Activity, T> apply(Replica<T> x$7) {
                        return x$7.model();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AbstractModule.class))), (Tensor[])Predef$.MODULE$.refArrayOps((Object[])replicas).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tensor<T> apply(Replica<T> x$8) {
                        return x$8.weights();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tensor.class))), (Tensor[])Predef$.MODULE$.refArrayOps((Object[])replicas).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tensor<T> apply(Replica<T> x$9) {
                        return x$9.gradients();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tensor.class))), (AbstractCriterion[])Predef$.MODULE$.refArrayOps((Object[])replicas).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final AbstractCriterion<Activity, Activity, T> apply(Replica<T> x$10) {
                        return x$10.criterion();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AbstractCriterion.class))), (Table[])Predef$.MODULE$.refArrayOps((Object[])replicas).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Table apply(Replica<T> x$11) {
                        return x$11.state();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Table.class))), new long[this.subModelNumber$1], (Option[])Predef$.MODULE$.refArrayOps((Object[])replicas).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<ValidationMethod<T>[]> apply(Replica<T> x$12) {
                        return x$12.validationMethods();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Option.class))), (Map)config.optimMethods().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, OptimMethod<T>> apply(Tuple2<String, OptimMethod<T>> v) {
                        return new Tuple2(v._1(), ((OptimMethod)v._2()).clone());
                    }
                }, Map$.MODULE$.canBuildFrom()), null, this.allReduceParameter$1, config.parameterSplits(), config.parameterProcessers()));
            }
            {
                this.evidence$3$1 = evidence$3$1;
                this.ev$5 = ev$5;
                this.broadcast$1 = broadcast$1;
                this.modelBroadcast$1 = modelBroadcast$1;
                this.allReduceParameter$1 = allReduceParameter$1;
                this.subModelNumber$1 = subModelNumber$1;
                this.state$1 = state$1;
            }
        };
        boolean x$29 = qual$1.mapPartitions$default$2();
        RDD cache = qual$1.mapPartitions((Function1)x$28, x$29, ClassTag$.MODULE$.apply(DistriOptimizerV2.Cache.class)).persist();
        cache.setName("Thread Model RDD");
        this.logger().info("Cache thread models...");
        cache.count();
        this.logger().info("Cache thread models... done");
        return new Tuple2((Object)cache, modelBroadcast);
    }

    public <T> void com$intel$analytics$bigdl$dllib$optim$DistriOptimizerV2$$setModelId(AbstractModule<Activity, Activity, T> model, int partitionId, ClassTag<T> evidence$4) {
        model.setId(partitionId);
        if (model instanceof Container) {
            ((Container)model).modules().foreach((Function1)new Serializable(partitionId, evidence$4){
                public static final long serialVersionUID = 0L;
                private final int partitionId$2;
                private final ClassTag evidence$4$1;

                public final void apply(AbstractModule<Activity, Activity, T> sub2) {
                    DistriOptimizerV2$.MODULE$.com$intel$analytics$bigdl$dllib$optim$DistriOptimizerV2$$setModelId(sub2, this.partitionId$2, this.evidence$4$1);
                }
                {
                    this.partitionId$2 = partitionId$2;
                    this.evidence$4$1 = evidence$4$1;
                }
            });
        }
    }

    @Override
    public <T> AbstractModule<Activity, Activity, T> getModel(RDD<DistriOptimizer.Cache<T>> models, AllReduceParameter<T> parameters2, AbstractModule<Activity, Activity, T> trainingModel, ClassTag<T> evidence$5, TensorNumericMath.TensorNumeric<T> ev) {
        int partitionNum = models.partitions().length;
        Tensor[] extraState = (Tensor[])models.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tensor<T>[] apply(DistriOptimizer.Cache<T> x$13) {
                return ((AbstractModule)Predef$.MODULE$.refArrayOps((Object[])x$13.localModels()).head()).getExtraParameter();
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tensor.class))).first();
        trainingModel.setExtraParameter(extraState);
        Tuple2<Tensor<T>[], Tensor<T>[]> parameterArray = trainingModel.parameters();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ((Tensor[])parameterArray._2()).length).foreach((Function1)new Serializable(parameterArray){
            public static final long serialVersionUID = 0L;
            private final Tuple2 parameterArray$1;

            public final Tensor<T> apply(int i) {
                return ((Tensor[])this.parameterArray$1._2())[i].resizeAs(((Tensor[])this.parameterArray$1._1())[i]);
            }
            {
                this.parameterArray$1 = parameterArray$1;
            }
        });
        Tuple2<Tensor<T>, Tensor<T>> tuple2 = trainingModel.getParameters();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Tensor parameter = (Tensor)tuple2._1();
            Tensor gradientParameter = (Tensor)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)parameter, (Object)gradientParameter);
            Tensor parameter2 = (Tensor)tuple23._1();
            Tensor gradientParameter2 = (Tensor)tuple23._2();
            Tuple2 tuple24 = (Tuple2)models.mapPartitions((Function1)new Serializable(parameters2){
                public static final long serialVersionUID = 0L;
                private final AllReduceParameter parameters$1;

                public final Iterator<Tuple2<Map<Object, Tensor<T>>, Map<Object, Tensor<T>>>> apply(Iterator<DistriOptimizer.Cache<T>> iter) {
                    DistriOptimizer.Cache cached = (DistriOptimizer.Cache)iter.next();
                    int curPartitionId = TaskContext$.MODULE$.getPartitionId();
                    return scala.package$.MODULE$.Iterator().single((Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)curPartitionId)), this.parameters$1.weightPartition())})), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)curPartitionId)), this.parameters$1.gradientPartition())}))));
                }
                {
                    this.parameters$1 = parameters$1;
                }
            }, models.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)).reduce((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Map<Object, Tensor<T>>, Map<Object, Tensor<T>>> apply(Tuple2<Map<Object, Tensor<T>>, Map<Object, Tensor<T>>> a, Tuple2<Map<Object, Tensor<T>>, Map<Object, Tensor<T>>> b) {
                    return new Tuple2((Object)((MapLike)a._1()).$plus$plus((GenTraversableOnce)b._1()), (Object)((MapLike)a._2()).$plus$plus((GenTraversableOnce)b._2()));
                }
            });
            if (tuple24 != null) {
                Tuple2 tuple25;
                Map weights = (Map)tuple24._1();
                Map gradients = (Map)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)weights, (Object)gradients);
                Map weights2 = (Map)tuple26._1();
                Map gradients2 = (Map)tuple26._2();
                int taskSize = parameters2.size() / partitionNum;
                Log4Error$.MODULE$.invalidOperationError(taskSize != 0, "parameter length should not less than partition number", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                int extraSize = parameters2.size() % partitionNum;
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).map((Function1)new Serializable(parameters2, parameter2, gradientParameter2, weights2, gradients2, taskSize, extraSize){
                    public static final long serialVersionUID = 0L;
                    private final AllReduceParameter parameters$1;
                    private final Tensor parameter$1;
                    private final Tensor gradientParameter$1;
                    private final Map weights$2;
                    private final Map gradients$1;
                    private final int taskSize$1;
                    private final int extraSize$1;

                    public final Tensor<T> apply(int pid) {
                        int start2 = this.parameters$1.paramOffset() + pid * this.taskSize$1 + package$.MODULE$.min(pid, this.extraSize$1);
                        int length = this.taskSize$1 + (pid < this.extraSize$1 ? 1 : 0);
                        this.parameter$1.narrow(1, start2, length).copy((Tensor)this.weights$2.apply((Object)BoxesRunTime.boxToInteger((int)pid)));
                        return this.gradientParameter$1.narrow(1, start2, length).copy((Tensor)this.gradients$1.apply((Object)BoxesRunTime.boxToInteger((int)pid)));
                    }
                    {
                        this.parameters$1 = parameters$1;
                        this.parameter$1 = parameter$1;
                        this.gradientParameter$1 = gradientParameter$1;
                        this.weights$2 = weights$2;
                        this.gradients$1 = gradients$1;
                        this.taskSize$1 = taskSize$1;
                        this.extraSize$1 = extraSize$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                return trainingModel;
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError(tuple2);
    }

    public <T> DistriOptimizerV2.TrainingResults com$intel$analytics$bigdl$dllib$optim$DistriOptimizerV2$$train(DistriOptimizerV2.Cache<T> cached, MiniBatch<T>[] data2, TrainingContext<T> context, Metrics metrics, ClassTag<T> evidence$6, TensorNumericMath.TensorNumeric<T> ev) {
        int stackSize = ((MiniBatch)Predef$.MODULE$.refArrayOps((Object[])data2).head()).size();
        ArrayBuffer tasks = new ArrayBuffer();
        Seq modelsResult = (Seq)TrainingTrace$.MODULE$.time(new Serializable(cached, data2, context, evidence$6, ev){
            public static final long serialVersionUID = 0L;
            private final DistriOptimizerV2.Cache cached$1;
            private final MiniBatch[] data$1;
            private final TrainingContext context$2;
            private final ClassTag evidence$6$1;
            private final TensorNumericMath.TensorNumeric ev$2;

            public final Seq<LossWithElapsedTime> apply() {
                return this.context$2.train(this.data$1, this.cached$1.localModels(), this.cached$1.localCriterions(), this.evidence$6$1, this.ev$2);
            }
            {
                this.cached$1 = cached$1;
                this.data$1 = data$1;
                this.context$2 = context$2;
                this.evidence$6$1 = evidence$6$1;
                this.ev$2 = ev$2;
            }
        }, metrics, (MetricEntry[])((Object[])new MetricEntry[]{COMPUTING_TIME_EACH_NODE$.MODULE$, COMPUTING_TIME_AVERAGE$.MODULE$}));
        double lossSum = 0.0;
        for (int i = 0; i < modelsResult.size(); ++i) {
            lossSum += ((LossWithElapsedTime)modelsResult.apply(i)).loss();
            cached.moduleTimeList()[i] = ((LossWithElapsedTime)modelsResult.apply(i)).elapsed();
        }
        Tensor gradients = (Tensor)TrainingTrace$.MODULE$.time(new Serializable(cached, context, evidence$6, modelsResult){
            public static final long serialVersionUID = 0L;
            public final DistriOptimizerV2.Cache cached$1;
            private final TrainingContext context$2;
            private final ClassTag evidence$6$1;
            private final Seq modelsResult$1;

            public final Tensor<T> apply() {
                Tensor<T> tensor;
                if (this.modelsResult$1.nonEmpty()) {
                    Tensor[] successedGradients = (Tensor[])((TraversableOnce)this.modelsResult$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.12 $outer;

                        public final Tensor<T> apply(LossWithElapsedTime result2) {
                            return this.$outer.cached$1.modelGradients()[result2.index()];
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tensor.class));
                    tensor = this.context$2.aggregate(successedGradients, this.evidence$6$1);
                } else {
                    this.cached$1.modelGradients()[0].zero();
                    tensor = this.cached$1.modelGradients()[0];
                }
                return tensor;
            }
            {
                this.cached$1 = cached$1;
                this.context$2 = context$2;
                this.evidence$6$1 = evidence$6$1;
                this.modelsResult$1 = modelsResult$1;
            }
        }, metrics, (MetricEntry[])((Object[])new MetricEntry[]{AGGREGATE_GRADIENT_TIME$.MODULE$}));
        TrainingTrace$.MODULE$.time(new Serializable(cached, gradients){
            public static final long serialVersionUID = 0L;
            private final DistriOptimizerV2.Cache cached$1;
            private final Tensor gradients$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cached$1.parameter().putGradients(this.gradients$2);
            }
            {
                this.cached$1 = cached$1;
                this.gradients$2 = gradients$2;
            }
        }, metrics, (MetricEntry[])((Object[])new MetricEntry[]{PUT_GRADIENT$.MODULE$}));
        tasks.$plus$plus$eq(Engine$.MODULE$.default().invoke((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), context.subModelNumber()).map((Function1)new Serializable(cached){
            public static final long serialVersionUID = 0L;
            public final DistriOptimizerV2.Cache cached$1;

            public final Function0<BoxedUnit> apply(int i) {
                return new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$com$intel$analytics$bigdl$dllib$optim$DistriOptimizerV2$$train$2 $outer;
                    private final int i$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.cached$1.localModels()[this.i$1].training();
                        this.$outer.cached$1.localModels()[this.i$1].zeroGradParameters();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                };
            }
            {
                this.cached$1 = cached$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())));
        return new DistriOptimizerV2.TrainingResults(modelsResult.size(), lossSum, modelsResult.size() * stackSize);
    }

    public <T> void com$intel$analytics$bigdl$dllib$optim$DistriOptimizerV2$$updateStates(Map<String, OptimMethod<T>> optimMethods, Table state, boolean updateScore) {
        optimMethods.map((Function1)new Serializable(state, updateScore){
            public static final long serialVersionUID = 0L;
            private final Table state$2;
            private final boolean updateScore$1;

            public final Object apply(Tuple2<String, OptimMethod<T>> x0$1) {
                Tuple2<String, OptimMethod<T>> tuple2 = x0$1;
                if (tuple2 != null) {
                    OptimMethod optimMethod = (OptimMethod)tuple2._2();
                    optimMethod.state().update(StateEntry$.MODULE$.EPOCH(), this.state$2.apply(StateEntry$.MODULE$.EPOCH()));
                    optimMethod.state().update(StateEntry$.MODULE$.NEVAL(), this.state$2.apply(StateEntry$.MODULE$.NEVAL()));
                    optimMethod.state().update(StateEntry$.MODULE$.LOSS(), this.state$2.apply(StateEntry$.MODULE$.LOSS()));
                    Object object = this.updateScore$1 ? optimMethod.state().update(StateEntry$.MODULE$.SCORE(), this.state$2.apply(StateEntry$.MODULE$.SCORE())) : BoxedUnit.UNIT;
                    BoxedUnit boxedUnit = optimMethod.state().keySet().contains((Object)StateEntry$.MODULE$.RECORDS_PROCESSED()) ? optimMethod.state().update(StateEntry$.MODULE$.RECORDS_PROCESSED(), this.state$2.apply(StateEntry$.MODULE$.RECORDS_PROCESSED())) : BoxedUnit.UNIT;
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                this.state$2 = state$2;
                this.updateScore$1 = updateScore$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private <T> void driverStatesUpdate(MasterCache<T> cacheOfMaster, int recordsNum, TrainingContext<T> context, TrainingTrace trainingTrace, Metrics metrics, ClassTag<T> evidence$7, TensorNumericMath.TensorNumeric<T> ev) {
        Map<String, OptimMethod<T>> optimMethods = cacheOfMaster.optimMethods();
        boolean updateScore = cacheOfMaster.validationMethods().isDefined();
        optimMethods.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, OptimMethod<T>> v) {
                ((OptimMethod)v._2()).updateHyperParameter();
            }
        });
        long trainingTakes = trainingTrace.trainingTakes();
        long iterationTakes = trainingTrace.iterationTakes();
        float throughput = (float)recordsNum / (float)((double)iterationTakes / 1.0E9);
        int records = trainingTrace.updateRecords(recordsNum).recordsOfEpoch();
        String _header = Optimizer$.MODULE$.header(trainingTrace.epochs(), records, context.numSamples(), trainingTrace.iterations(), trainingTakes);
        float loss2 = BoxesRunTime.unboxToFloat(context.state().apply(StateEntry$.MODULE$.LOSS()));
        this.logger().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Trained ", " records in ", " seconds. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{_header, BoxesRunTime.boxToInteger((int)recordsNum), BoxesRunTime.boxToFloat((float)((float)((double)iterationTakes / 1.0E9)))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Throughput is ", " records/second. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)throughput)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loss is ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)loss2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Optimizer$.MODULE$.getHyperParameterLog(optimMethods)}))).toString());
        this.logger().debug(new StringBuilder().append((Object)"\n").append((Object)metrics.summary(metrics.summary$default$1(), metrics.summary$default$2())).toString());
        context.state().update(StateEntry$.MODULE$.THROUGHPUT(), BoxesRunTime.boxToFloat((float)((float)recordsNum / (float)((double)iterationTakes / 1.0E9))));
        context.state().update(StateEntry$.MODULE$.NEVAL(), BoxesRunTime.boxToInteger((int)(trainingTrace.iterations() + 1)));
        context.state().update(StateEntry$.MODULE$.LEARNING_RATE(), BoxesRunTime.boxToFloat((float)((float)((OptimMethod)((Tuple2)optimMethods.head())._2()).getLearningRate())));
        if (context.hasCompleteAllSamples(trainingTrace.recordsOfEpoch(), cacheOfMaster.model())) {
            trainingTrace.startNewEpoch();
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Epoch finished. Wall clock time is ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{_header, BoxesRunTime.boxToDouble((double)((double)trainingTakes / 1000000.0))})));
        }
        context.state().update(StateEntry$.MODULE$.EPOCH(), BoxesRunTime.boxToInteger((int)trainingTrace.epochs()));
        context.state().update(StateEntry$.MODULE$.RECORDS_PROCESSED(), BoxesRunTime.boxToInteger((int)trainingTrace.recordsOfEpoch()));
        this.com$intel$analytics$bigdl$dllib$optim$DistriOptimizerV2$$updateStates(optimMethods, context.state(), updateScore);
    }

    public <T> void com$intel$analytics$bigdl$dllib$optim$DistriOptimizerV2$$parameterSync(double lossSum, int successedModels, MasterCache<T> cacheOfMaster, RDD<DistriOptimizerV2.Cache<T>> cacheOfSlave, TrainingContext<T> context, ClassTag<T> evidence$8, TensorNumericMath.TensorNumeric<T> ev) {
        Metrics metrics = cacheOfMaster.metrics();
        AllReduceParameter<T> parameter = cacheOfMaster.parameter();
        boolean updateScore = cacheOfMaster.validationMethods().isDefined();
        context.state().update(StateEntry$.MODULE$.NUM_FINISHED_MODELS(), BoxesRunTime.boxToInteger((int)successedModels));
        context.state().update(StateEntry$.MODULE$.IS_GRADIENT_UPDATED(), BoxesRunTime.boxToBoolean((boolean)false));
        Predef$.MODULE$.refArrayOps((Object[])cacheOfMaster.parameterProcessers()).foreach((Function1)new Serializable(cacheOfSlave, context, ev, metrics, parameter){
            public static final long serialVersionUID = 0L;
            private final RDD cacheOfSlave$2;
            private final TrainingContext context$4;
            private final TensorNumericMath.TensorNumeric ev$4;
            private final Metrics metrics$2;
            private final AllReduceParameter parameter$2;

            public final void apply(ParameterProcessor processer) {
                processer.collectGlobalData(this.cacheOfSlave$2, this.parameter$2, this.metrics$2, this.context$4.state(), this.ev$4);
            }
            {
                this.cacheOfSlave$2 = cacheOfSlave$2;
                this.context$4 = context$4;
                this.ev$4 = ev$4;
                this.metrics$2 = metrics$2;
                this.parameter$2 = parameter$2;
            }
        });
        boolean isGradientUpdated = BoxesRunTime.unboxToBoolean(context.state().apply(StateEntry$.MODULE$.IS_GRADIENT_UPDATED()));
        cacheOfSlave.mapPartitions((Function1)new Serializable(lossSum, successedModels, context, evidence$8, ev, metrics, parameter, updateScore, isGradientUpdated){
            public static final long serialVersionUID = 0L;
            private final double lossSum$2;
            public final int successedModels$1;
            public final TrainingContext context$4;
            public final ClassTag evidence$8$1;
            public final TensorNumericMath.TensorNumeric ev$4;
            private final Metrics metrics$2;
            public final AllReduceParameter parameter$2;
            private final boolean updateScore$2;
            private final boolean isGradientUpdated$1;

            public final Iterator<Nothing$> apply(Iterator<DistriOptimizerV2.Cache<T>> iter) {
                DistriOptimizerV2.Cache cache = (DistriOptimizerV2.Cache)iter.next();
                Map<String, OptimMethod<T>> localOptimMethods = cache.optimMethods();
                ParameterProcessor[] parameterProcessers = cache.parameterProcessers();
                Map<String, Tuple2<Object, Object>> parameterSplits = cache.parameterSplits();
                Tuple2<Object, Object> tuple2 = cache.parameter().localPartitionRange();
                if (tuple2 != null) {
                    Tuple2.mcII.sp sp2;
                    int paramLocalStart = tuple2._1$mcI$sp();
                    int paramLocalLen = tuple2._2$mcI$sp();
                    Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(paramLocalStart, paramLocalLen);
                    int paramLocalStart2 = sp3._1$mcI$sp();
                    int paramLocalLen2 = sp3._2$mcI$sp();
                    Object object = this.isGradientUpdated$1 ? BoxedUnit.UNIT : TrainingTrace$.MODULE$.time(new Serializable(this, cache){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun$com$intel$analytics$bigdl$dllib$optim$DistriOptimizerV2$$parameterSync$2 $outer;
                        private final DistriOptimizerV2.Cache cache$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.cache$1.parameter().aggregateGradientPartition(this.$outer.successedModels$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.cache$1 = cache$1;
                        }
                    }, this.metrics$2, (MetricEntry[])((Object[])new MetricEntry[]{AGGREGATE_PARTITION_GRADIENT$.MODULE$}));
                    Predef$.MODULE$.refArrayOps((Object[])parameterProcessers).foreach((Function1)new Serializable(this, cache){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun$com$intel$analytics$bigdl$dllib$optim$DistriOptimizerV2$$parameterSync$2 $outer;
                        private final DistriOptimizerV2.Cache cache$1;

                        public final void apply(ParameterProcessor x$17) {
                            x$17.processParameters(this.$outer.parameter$2, this.cache$1, this.$outer.context$4.state(), this.$outer.ev$4);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.cache$1 = cache$1;
                        }
                    });
                    DistriOptimizerV2$.MODULE$.com$intel$analytics$bigdl$dllib$optim$DistriOptimizerV2$$updateStates(localOptimMethods, this.context$4.state(), this.updateScore$2);
                    Map optimSegments = (Map)localOptimMethods.map((Function1)new Serializable(this, parameterSplits, paramLocalStart2, paramLocalLen2){
                        public static final long serialVersionUID = 0L;
                        private final Map parameterSplits$1;
                        private final int paramLocalStart$1;
                        private final int paramLocalLen$1;

                        public final Tuple2<String, ParamSegments<T>> apply(Tuple2<String, OptimMethod<T>> x0$2) {
                            Tuple2<String, OptimMethod<T>> tuple2 = x0$2;
                            if (tuple2 != null) {
                                String name = (String)tuple2._1();
                                OptimMethod method = (OptimMethod)tuple2._2();
                                Tuple2 p = (Tuple2)this.parameterSplits$1.apply((Object)name);
                                int startIdx = Math.max(this.paramLocalStart$1, p._1$mcI$sp());
                                int endIdx = Math.min(this.paramLocalLen$1 + this.paramLocalStart$1, p._1$mcI$sp() + p._2$mcI$sp());
                                Tuple2 tuple22 = new Tuple2((Object)name, new ParamSegments<T>(startIdx - this.paramLocalStart$1 + 1, endIdx - startIdx, method));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.parameterSplits$1 = parameterSplits$1;
                            this.paramLocalStart$1 = paramLocalStart$1;
                            this.paramLocalLen$1 = paramLocalLen$1;
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    Tensor<T> weights = cache.parameter().weightPartition();
                    Tensor<T> gradients = cache.parameter().gradientPartition();
                    double loss2 = this.lossSum$2 / (double)this.successedModels$1;
                    TrainingTrace$.MODULE$.time(new Serializable(this, optimSegments, weights, gradients, loss2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun$com$intel$analytics$bigdl$dllib$optim$DistriOptimizerV2$$parameterSync$2 $outer;
                        private final Map optimSegments$1;
                        private final Tensor weights$3;
                        private final Tensor gradients$4;
                        private final double loss$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.context$4.update(this.optimSegments$1, this.weights$3, this.gradients$4, this.loss$1, this.$outer.evidence$8$1, this.$outer.ev$4);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.optimSegments$1 = optimSegments$1;
                            this.weights$3 = weights$3;
                            this.gradients$4 = gradients$4;
                            this.loss$1 = loss$1;
                        }
                    }, this.metrics$2, (MetricEntry[])((Object[])new MetricEntry[]{COMPUTE_WEIGHT_AVERAGE$.MODULE$}));
                    TrainingTrace$.MODULE$.time(new Serializable(this, cache){
                        public static final long serialVersionUID = 0L;
                        private final DistriOptimizerV2.Cache cache$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.cache$1.parameter().sendWeightPartition();
                        }
                        {
                            this.cache$1 = cache$1;
                        }
                    }, this.metrics$2, (MetricEntry[])((Object[])new MetricEntry[]{SEND_WEIGHTS_AVERAGE$.MODULE$}));
                    return scala.package$.MODULE$.Iterator().empty();
                }
                throw new MatchError(tuple2);
            }
            {
                this.lossSum$2 = lossSum$2;
                this.successedModels$1 = successedModels$1;
                this.context$4 = context$4;
                this.evidence$8$1 = evidence$8$1;
                this.ev$4 = ev$4;
                this.metrics$2 = metrics$2;
                this.parameter$2 = parameter$2;
                this.updateScore$2 = updateScore$2;
                this.isGradientUpdated$1 = isGradientUpdated$1;
            }
        }, cacheOfSlave.mapPartitions$default$2(), evidence$8).count();
        context.state().update(StateEntry$.MODULE$.IS_GRADIENT_UPDATED(), BoxesRunTime.boxToBoolean((boolean)true));
        context.state().update(StateEntry$.MODULE$.LOSS(), BoxesRunTime.boxToFloat((float)((float)lossSum / (float)successedModels)));
    }

    private final DistriOptimizerV2$TrainingConfig$4$ TrainingConfig$2(VolatileObjectRef TrainingConfig$module$1) {
        return TrainingConfig$module$1.elem == null ? this.TrainingConfig$2$lzycompute(TrainingConfig$module$1) : (DistriOptimizerV2$TrainingConfig$4$)TrainingConfig$module$1.elem;
    }

    private DistriOptimizerV2$() {
        MODULE$ = this;
        this.logger = LogManager.getLogger(this.getClass());
    }
}

