/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.nnframes;

import com.intel.analytics.bigdl.dllib.feature.transform.vision.image.ImageFeature;
import com.intel.analytics.bigdl.dllib.feature.transform.vision.image.ImageFeature$;
import com.intel.analytics.bigdl.dllib.feature.transform.vision.image.opencv.OpenCVMat;
import com.intel.analytics.bigdl.dllib.feature.transform.vision.image.opencv.OpenCVMat$;
import com.intel.analytics.bigdl.dllib.nnframes.NNImageSchema$;
import com.intel.analytics.bigdl.dllib.tensor.Storage$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericFloat$;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.opencv.core.CvType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class NNImageSchema$ {
    public static final NNImageSchema$ MODULE$;
    private final StructType byteSchema;
    private final StructType floatSchema;

    static {
        new NNImageSchema$();
    }

    public StructType byteSchema() {
        return this.byteSchema;
    }

    public StructType floatSchema() {
        return this.floatSchema;
    }

    public Row imf2Row(ImageFeature imf) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        if (imf.contains(ImageFeature$.MODULE$.imageTensor())) {
            int n;
            float[] floatData = (float[])((Tensor)imf.apply(ImageFeature$.MODULE$.imageTensor())).storage().array();
            int n2 = imf.getChannel();
            switch (n2) {
                default: {
                    Log4Error$.MODULE$.invalidOperationError(false, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported number of channels:"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " in ", ". Only 1, 3 and 4 are supported."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n2), imf.uri()}))).toString(), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                    n = CvType.CV_32FC4;
                    break;
                }
                case 4: {
                    n = CvType.CV_32FC4;
                    break;
                }
                case 3: {
                    n = CvType.CV_32FC3;
                    break;
                }
                case 1: {
                    n = CvType.CV_32FC1;
                }
            }
            int cvType = n;
            tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)cvType), (Object)floatData);
        } else if (imf.contains(ImageFeature$.MODULE$.mat())) {
            OpenCVMat mat = imf.opencvMat();
            int cvType = mat.type();
            byte[] bytesData = (byte[])OpenCVMat$.MODULE$.toBytePixels(mat, OpenCVMat$.MODULE$.toBytePixels$default$2())._1();
            tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)cvType), (Object)bytesData);
        } else {
            Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ImageFeature should have imageTensor or mat."})).s((Seq)Nil$.MODULE$), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            tuple22 = tuple2 = BoxedUnit.UNIT;
        }
        if (tuple2 instanceof Tuple2) {
            Tuple2 tuple23;
            Tuple2 tuple24 = tuple2;
            Object mode = tuple24._1();
            Object data2 = tuple24._2();
            Tuple2 tuple25 = tuple23 = new Tuple2(mode, data2);
            Object mode2 = tuple25._1();
            Object data3 = tuple25._2();
            return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{imf.uri(), BoxesRunTime.boxToInteger((int)imf.getHeight()), BoxesRunTime.boxToInteger((int)imf.getWidth()), BoxesRunTime.boxToInteger((int)imf.getChannel()), mode2, data3}));
        }
        throw new MatchError((Object)tuple2);
    }

    public ImageFeature row2IMF(Row row) {
        Tuple4 tuple4 = new Tuple4((Object)row.getString(0), (Object)BoxesRunTime.boxToInteger((int)row.getInt(1)), (Object)BoxesRunTime.boxToInteger((int)row.getInt(2)), (Object)BoxesRunTime.boxToInteger((int)row.getInt(3)));
        if (tuple4 != null) {
            int storageType;
            Tuple4 tuple42;
            String origin = (String)tuple4._1();
            int h2 = BoxesRunTime.unboxToInt((Object)tuple4._2());
            int w = BoxesRunTime.unboxToInt((Object)tuple4._3());
            int c = BoxesRunTime.unboxToInt((Object)tuple4._4());
            Tuple4 tuple43 = tuple42 = new Tuple4((Object)origin, (Object)BoxesRunTime.boxToInteger((int)h2), (Object)BoxesRunTime.boxToInteger((int)w), (Object)BoxesRunTime.boxToInteger((int)c));
            String origin2 = (String)tuple43._1();
            int h3 = BoxesRunTime.unboxToInt((Object)tuple43._2());
            int w2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
            int c2 = BoxesRunTime.unboxToInt((Object)tuple43._4());
            ImageFeature imf = ImageFeature$.MODULE$.apply();
            imf.update(ImageFeature$.MODULE$.uri(), origin2);
            imf.update(ImageFeature$.MODULE$.size(), new Tuple3((Object)BoxesRunTime.boxToInteger((int)h3), (Object)BoxesRunTime.boxToInteger((int)w2), (Object)BoxesRunTime.boxToInteger((int)c2)));
            int n = storageType = row.getInt(4);
            boolean bl = CvType.CV_8UC3 == n ? true : (CvType.CV_8UC1 == n ? true : CvType.CV_8UC4 == n);
            if (bl) {
                byte[] bytesData = (byte[])row.getAs(5);
                OpenCVMat opencvMat = OpenCVMat$.MODULE$.fromPixelsBytes(bytesData, h3, w2, c2);
                imf.update(ImageFeature$.MODULE$.mat(), (Object)opencvMat);
                imf.update(ImageFeature$.MODULE$.originalSize(), opencvMat.shape());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl2 = CvType.CV_32FC3 == n ? true : (CvType.CV_32FC1 == n ? true : CvType.CV_32FC4 == n);
                if (bl2) {
                    float[] data2 = (float[])row.getSeq(5).toArray(ClassTag$.MODULE$.Float());
                    int[] size = new int[]{h3, w2, c2};
                    Tensor<Object> qual$1 = Tensor$.MODULE$.apply$mFc$sp(Storage$.MODULE$.apply$mFc$sp(data2, (ClassTag<Object>)ClassTag$.MODULE$.Float()), (ClassTag<Object>)ClassTag$.MODULE$.Float(), (TensorNumericMath.TensorNumeric<Object>)TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
                    int[] x$16 = size;
                    int[] x$17 = qual$1.resize$default$2();
                    Tensor<Object> ten = qual$1.resize(x$16, x$17);
                    imf.update(ImageFeature$.MODULE$.imageTensor(), ten);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported data type in imageColumn: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)storageType)})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            return imf;
        }
        throw new MatchError((Object)tuple4);
    }

    public String getOrigin(Row row) {
        return row.getString(0);
    }

    public Dataset<Row> withOriginColumn(Dataset<Row> imageDF, String imageColumn, String originColumn) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Com_intel_analytics_bigdl_dllib_nnframes_NNImageSchema$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Com_intel_analytics_bigdl_dllib_nnframes_NNImageSchema$$typecreator1$1() {
            }
        }
        public final class Com_intel_analytics_bigdl_dllib_nnframes_NNImageSchema$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.Row").asType().toTypeConstructor();
            }

            public Com_intel_analytics_bigdl_dllib_nnframes_NNImageSchema$$typecreator2$1() {
            }
        }
        UserDefinedFunction getPathUDF = functions$.MODULE$.udf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row row) {
                return NNImageSchema$.MODULE$.getOrigin(row);
            }
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_intel_analytics_bigdl_dllib_nnframes_NNImageSchema$$typecreator1$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Com_intel_analytics_bigdl_dllib_nnframes_NNImageSchema$$typecreator2$1()));
        return imageDF.withColumn(originColumn, getPathUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(imageColumn)})));
    }

    public String withOriginColumn$default$2() {
        return "image";
    }

    public String withOriginColumn$default$3() {
        return "origin";
    }

    private NNImageSchema$() {
        MODULE$ = this;
        StructField structField = new StructField("origin", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("height", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("width", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("nChannels", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField5 = new StructField("mode", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("data", (DataType)BinaryType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.byteSchema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6).$colon$colon((Object)structField5).$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
        StructField structField7 = new StructField("origin", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField8 = new StructField("height", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField9 = new StructField("width", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField10 = new StructField("nChannels", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField11 = new StructField("mode", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField12 = new StructField("data", (DataType)new ArrayType((DataType)FloatType$.MODULE$, false), false, StructField$.MODULE$.apply$default$4());
        this.floatSchema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField12).$colon$colon((Object)structField11).$colon$colon((Object)structField10).$colon$colon((Object)structField9).$colon$colon((Object)structField8).$colon$colon((Object)structField7));
    }
}

