/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.nn.tf;

import com.intel.analytics.bigdl.dllib.nn.abstractnn.Activity;
import com.intel.analytics.bigdl.dllib.nn.ops.Operation;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericDouble$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericFloat$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericInt$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericLong$;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.shaded.protobuf_v_3_5_1.ByteString;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.tensorflow.framework.DataType;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ed!B\u0001\u0003\u0001!\u0001\"!\u0003#fG>$WMU1x\u0015\t\u0019A!\u0001\u0002uM*\u0011QAB\u0001\u0003]:T!a\u0002\u0005\u0002\u000b\u0011dG.\u001b2\u000b\u0005%Q\u0011!\u00022jO\u0012d'BA\u0006\r\u0003%\tg.\u00197zi&\u001c7O\u0003\u0002\u000e\u001d\u0005)\u0011N\u001c;fY*\tq\"A\u0002d_6,\"!\u0005\u0018\u0014\u0005\u0001\u0011\u0002#B\n\u00171\u0019bS\"\u0001\u000b\u000b\u0005U!\u0011aA8qg&\u0011q\u0003\u0006\u0002\n\u001fB,'/\u0019;j_:\u00042!\u0007\u000f\u001f\u001b\u0005Q\"BA\u000e\u0007\u0003\u0019!XM\\:pe&\u0011QD\u0007\u0002\u0007)\u0016t7o\u001c:\u0011\u0005}!S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013\u0001\u00039s_R|'-\u001e4\u000b\u0005\rr\u0011AB4p_\u001edW-\u0003\u0002&A\tQ!)\u001f;f'R\u0014\u0018N\\4\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%\"\u0011AC1cgR\u0014\u0018m\u0019;o]&\u00111\u0006\u000b\u0002\t\u0003\u000e$\u0018N^5usB\u0011QF\f\u0007\u0001\t\u0015y\u0003A1\u00012\u0005\u0005!6\u0001A\t\u0003ea\u0002\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012qAT8uQ&tw\r\u0005\u00024s%\u0011!\b\u000e\u0002\u0004\u0003:L\b\u0002\u0003\u001f\u0001\u0005\u000b\u0007I\u0011A\u001f\u0002\u000f=,H\u000fV=qKV\ta\b\u0005\u0002@\r6\t\u0001I\u0003\u0002B\u0005\u0006IaM]1nK^|'o\u001b\u0006\u0003\u0007\u0012\u000b!\u0002^3og>\u0014h\r\\8x\u0015\u0005)\u0015aA8sO&\u0011q\t\u0011\u0002\t\t\u0006$\u0018\rV=qK\"A\u0011\n\u0001B\u0001B\u0003%a(\u0001\u0005pkR$\u0016\u0010]3!\u0011!Y\u0005A!b\u0001\n\u0003a\u0015\u0001\u00047jiRdW-\u00128eS\u0006tW#A'\u0011\u0005Mr\u0015BA(5\u0005\u001d\u0011un\u001c7fC:D\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006I!T\u0001\u000eY&$H\u000f\\3F]\u0012L\u0017M\u001c\u0011\t\u0011M\u0003!1!Q\u0001\fQ\u000b!\"\u001a<jI\u0016t7-\u001a\u00137!\r)\u0006\fL\u0007\u0002-*\u0011q\u000bN\u0001\be\u00164G.Z2u\u0013\tIfK\u0001\u0005DY\u0006\u001c8\u000fV1h\u0011!Y\u0006A!A!\u0002\u0017a\u0016AA3w!\riv\u000e\f\b\u0003=6t!a\u00187\u000f\u0005\u0001\\gBA1k\u001d\t\u0011\u0017N\u0004\u0002dQ:\u0011AmZ\u0007\u0002K*\u0011a\rM\u0001\u0007yI|w\u000e\u001e \n\u0003=I!!\u0004\b\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u001c\r%\u0011aNG\u0001\u0012)\u0016t7o\u001c:Ok6,'/[2NCRD\u0017B\u00019r\u00055!VM\\:pe:+X.\u001a:jG*\u0011aN\u0007\u0005\u0006g\u0002!\t\u0001^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007UT8\u0010F\u0002wqf\u00042a\u001e\u0001-\u001b\u0005\u0011\u0001\"B*s\u0001\b!\u0006\"B.s\u0001\ba\u0006\"\u0002\u001fs\u0001\u0004q\u0004\"B&s\u0001\u0004i\u0005\"B?\u0001\t\u0003r\u0018\u0001D;qI\u0006$XmT;uaV$HC\u0001\u0014\u0000\u0011\u0019\t\t\u0001 a\u00011\u0005)\u0011N\u001c9vi\"9\u0011Q\u0001\u0001\u0005\n\u0005\u001d\u0011\u0001\u00043fG>$W\rR8vE2,GCBA\u0005\u0003\u001f\t\t\u0002E\u00024\u0003\u0017I1!!\u00045\u0005\u0011)f.\u001b;\t\u000f\u0005\u0005\u00111\u0001a\u00011!A\u00111CA\u0002\u0001\u0004\t)\"A\u0006gK\u0006$XO]3TSj,\u0007cA\u001a\u0002\u0018%\u0019\u0011\u0011\u0004\u001b\u0003\u0007%sG\u000fC\u0004\u0002\u001e\u0001!I!a\b\u0002\u0017\u0011,7m\u001c3f\r2|\u0017\r\u001e\u000b\u0007\u0003\u0013\t\t#a\t\t\u000f\u0005\u0005\u00111\u0004a\u00011!A\u00111CA\u000e\u0001\u0004\t)\u0002C\u0004\u0002(\u0001!I!!\u000b\u0002\u0017\u0011,7m\u001c3f\u0013:$8G\r\u000b\u0007\u0003\u0013\tY#!\f\t\u000f\u0005\u0005\u0011Q\u0005a\u00011!A\u00111CA\u0013\u0001\u0004\t)\u0002C\u0004\u00022\u0001!I!a\r\u0002\u0017\u0011,7m\u001c3f\u0013:$h\u0007\u000e\u000b\u0007\u0003\u0013\t)$a\u000e\t\u000f\u0005\u0005\u0011q\u0006a\u00011!A\u00111CA\u0018\u0001\u0004\t)\u0002C\u0004\u0002<\u0001!I!!\u0010\u0002\u0017\u0011,7m\u001c3f\u0013:$\u0018G\u000e\u000b\u0007\u0003\u0013\ty$!\u0011\t\u000f\u0005\u0005\u0011\u0011\ba\u00011!A\u00111CA\u001d\u0001\u0004\t)\u0002C\u0004\u0002F\u0001!I!a\u0012\u0002\u0015\u0011,7m\u001c3f\u0013:$\b\b\u0006\u0004\u0002\n\u0005%\u00131\n\u0005\b\u0003\u0003\t\u0019\u00051\u0001\u0019\u0011!\t\u0019\"a\u0011A\u0002\u0005U\u0001bBA(\u0001\u0011%\u0011\u0011K\u0001\fI\u0016\u001cw\u000eZ3VS:$\b\b\u0006\u0004\u0002\n\u0005M\u0013Q\u000b\u0005\b\u0003\u0003\ti\u00051\u0001\u0019\u0011!\t\u0019\"!\u0014A\u0002\u0005U\u0001\"CA-\u0001\t\u0007I\u0011BA.\u0003%\u0011\u0017\u0010^3Pe\u0012,'/\u0006\u0002\u0002^A!\u0011qLA5\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014a\u00018j_*\u0011\u0011qM\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002l\u0005\u0005$!\u0003\"zi\u0016|%\u000fZ3s\u0011!\ty\u0007\u0001Q\u0001\n\u0005u\u0013A\u00032zi\u0016|%\u000fZ3sA!\"\u0011QNA:!\r\u0019\u0014QO\u0005\u0004\u0003o\"$!\u0003;sC:\u001c\u0018.\u001a8u\u0001")
public class DecodeRaw<T>
extends Operation<Tensor<ByteString>, Activity, T> {
    private final DataType outType;
    private final boolean littleEndian;
    private final transient ByteOrder byteOrder;

    public DataType outType() {
        return this.outType;
    }

    public boolean littleEndian() {
        return this.littleEndian;
    }

    private ByteOrder byteOrder() {
        return this.byteOrder;
    }

    @Override
    public Activity updateOutput(Tensor<ByteString> input) {
        Log4Error$.MODULE$.invalidInputError(input.isContiguous(), "only support contiguous input", Log4Error$.MODULE$.invalidInputError$default$3());
        int offset = input.storageOffset() - 1;
        ByteString[] data2 = (ByteString[])input.storage().array();
        ByteString firstElem = data2[offset];
        ByteBuffer buffer = ByteBuffer.wrap(firstElem.toByteArray());
        buffer.order(this.byteOrder());
        DataType dataType = this.outType();
        if (DataType.DT_UINT8.equals(dataType)) {
            this.decodeUint8(input, buffer.array().length);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DataType.DT_INT8.equals(dataType)) {
            this.decodeInt8(input, buffer.array().length);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DataType.DT_INT16.equals(dataType)) {
            this.decodeInt16(input, buffer.asShortBuffer().capacity());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DataType.DT_INT32.equals(dataType)) {
            this.decodeInt32(input, buffer.asIntBuffer().capacity());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DataType.DT_INT64.equals(dataType)) {
            this.decodeInt64(input, buffer.asLongBuffer().capacity());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DataType.DT_FLOAT.equals(dataType)) {
            this.decodeFloat(input, buffer.asFloatBuffer().capacity());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DataType.DT_DOUBLE.equals(dataType)) {
            this.decodeDouble(input, buffer.asDoubleBuffer().capacity());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " are not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.outType()})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return this.output();
    }

    private void decodeDouble(Tensor<ByteString> input, int featureSize) {
        Tensor typedOutput = (Tensor)this.output();
        Seq size = (Seq)Predef$.MODULE$.intArrayOps(input.size()).toSeq().$colon$plus((Object)BoxesRunTime.boxToInteger((int)featureSize), Seq$.MODULE$.canBuildFrom());
        typedOutput.resize((int[])size.toArray(ClassTag$.MODULE$.Int()), typedOutput.resize$default$2());
        double[] outputData = (double[])typedOutput.storage().array();
        int outputOffset = typedOutput.storageOffset() - 1;
        ByteString[] inputData = (ByteString[])input.storage().array();
        int inputOffset = input.storageOffset() - 1;
        int dataSize = input.nElement();
        for (int i = 0; i < dataSize; ++i) {
            byte[] bytes = inputData[inputOffset + i].toByteArray();
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.order(this.byteOrder());
            DoubleBuffer typedInputData = buffer.asDoubleBuffer();
            for (int j = 0; j < featureSize; ++j) {
                outputData[outputOffset + i * featureSize + j] = typedInputData.get(j);
            }
        }
    }

    private void decodeFloat(Tensor<ByteString> input, int featureSize) {
        Tensor typedOutput = (Tensor)this.output();
        Seq size = (Seq)Predef$.MODULE$.intArrayOps(input.size()).toSeq().$colon$plus((Object)BoxesRunTime.boxToInteger((int)featureSize), Seq$.MODULE$.canBuildFrom());
        typedOutput.resize((int[])size.toArray(ClassTag$.MODULE$.Int()), typedOutput.resize$default$2());
        float[] outputData = (float[])typedOutput.storage().array();
        int outputOffset = typedOutput.storageOffset() - 1;
        ByteString[] inputData = (ByteString[])input.storage().array();
        int inputOffset = input.storageOffset() - 1;
        int dataSize = input.nElement();
        for (int i = 0; i < dataSize; ++i) {
            byte[] bytes = inputData[inputOffset + i].toByteArray();
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.order(this.byteOrder());
            FloatBuffer typedInputData = buffer.asFloatBuffer();
            for (int j = 0; j < featureSize; ++j) {
                outputData[outputOffset + i * featureSize + j] = typedInputData.get(j);
            }
        }
    }

    private void decodeInt32(Tensor<ByteString> input, int featureSize) {
        Tensor typedOutput = (Tensor)this.output();
        Seq size = (Seq)Predef$.MODULE$.intArrayOps(input.size()).toSeq().$colon$plus((Object)BoxesRunTime.boxToInteger((int)featureSize), Seq$.MODULE$.canBuildFrom());
        typedOutput.resize((int[])size.toArray(ClassTag$.MODULE$.Int()), typedOutput.resize$default$2());
        int[] outputData = (int[])typedOutput.storage().array();
        int outputOffset = typedOutput.storageOffset() - 1;
        ByteString[] inputData = (ByteString[])input.storage().array();
        int inputOffset = input.storageOffset() - 1;
        int dataSize = input.nElement();
        for (int i = 0; i < dataSize; ++i) {
            byte[] bytes = inputData[inputOffset + i].toByteArray();
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.order(this.byteOrder());
            IntBuffer typedInputData = buffer.asIntBuffer();
            for (int j = 0; j < featureSize; ++j) {
                outputData[outputOffset + i * featureSize + j] = typedInputData.get(j);
            }
        }
    }

    private void decodeInt64(Tensor<ByteString> input, int featureSize) {
        Tensor typedOutput = (Tensor)this.output();
        Seq size = (Seq)Predef$.MODULE$.intArrayOps(input.size()).toSeq().$colon$plus((Object)BoxesRunTime.boxToInteger((int)featureSize), Seq$.MODULE$.canBuildFrom());
        typedOutput.resize((int[])size.toArray(ClassTag$.MODULE$.Int()), typedOutput.resize$default$2());
        long[] outputData = (long[])typedOutput.storage().array();
        int outputOffset = typedOutput.storageOffset() - 1;
        ByteString[] inputData = (ByteString[])input.storage().array();
        int inputOffset = input.storageOffset() - 1;
        int dataSize = input.nElement();
        for (int i = 0; i < dataSize; ++i) {
            byte[] bytes = inputData[inputOffset + i].toByteArray();
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.order(this.byteOrder());
            LongBuffer typedInputData = buffer.asLongBuffer();
            for (int j = 0; j < featureSize; ++j) {
                outputData[outputOffset + i * featureSize + j] = typedInputData.get(j);
            }
        }
    }

    private void decodeInt16(Tensor<ByteString> input, int featureSize) {
        Tensor typedOutput = (Tensor)this.output();
        Seq size = (Seq)Predef$.MODULE$.intArrayOps(input.size()).toSeq().$colon$plus((Object)BoxesRunTime.boxToInteger((int)featureSize), Seq$.MODULE$.canBuildFrom());
        typedOutput.resize((int[])size.toArray(ClassTag$.MODULE$.Int()), typedOutput.resize$default$2());
        int[] outputData = (int[])typedOutput.storage().array();
        int outputOffset = typedOutput.storageOffset() - 1;
        ByteString[] inputData = (ByteString[])input.storage().array();
        int inputOffset = input.storageOffset() - 1;
        int dataSize = input.nElement();
        for (int i = 0; i < dataSize; ++i) {
            byte[] bytes = inputData[inputOffset + i].toByteArray();
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.order(this.byteOrder());
            ShortBuffer typedInputData = buffer.asShortBuffer();
            for (int j = 0; j < featureSize; ++j) {
                outputData[outputOffset + i * featureSize + j] = typedInputData.get(j);
            }
        }
    }

    private void decodeInt8(Tensor<ByteString> input, int featureSize) {
        Tensor typedOutput = (Tensor)this.output();
        Seq size = (Seq)Predef$.MODULE$.intArrayOps(input.size()).toSeq().$colon$plus((Object)BoxesRunTime.boxToInteger((int)featureSize), Seq$.MODULE$.canBuildFrom());
        typedOutput.resize((int[])size.toArray(ClassTag$.MODULE$.Int()), typedOutput.resize$default$2());
        int[] outputData = (int[])typedOutput.storage().array();
        int outputOffset = typedOutput.storageOffset() - 1;
        ByteString[] inputData = (ByteString[])input.storage().array();
        int inputOffset = input.storageOffset() - 1;
        int dataSize = input.nElement();
        for (int i = 0; i < dataSize; ++i) {
            byte[] bytes = inputData[inputOffset + i].toByteArray();
            byte[] typedInputData = bytes;
            Log4Error$.MODULE$.invalidInputError(typedInputData.length == featureSize, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"each element should have the same size, first elem size: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)featureSize)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "th elem size: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)typedInputData.length)}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
            for (int j = 0; j < featureSize; ++j) {
                outputData[outputOffset + i * featureSize + j] = typedInputData[j];
            }
        }
    }

    private void decodeUint8(Tensor<ByteString> input, int featureSize) {
        Tensor typedOutput = (Tensor)this.output();
        Seq size = (Seq)Predef$.MODULE$.intArrayOps(input.size()).toSeq().$colon$plus((Object)BoxesRunTime.boxToInteger((int)featureSize), Seq$.MODULE$.canBuildFrom());
        typedOutput.resize((int[])size.toArray(ClassTag$.MODULE$.Int()), typedOutput.resize$default$2());
        int[] outputData = (int[])typedOutput.storage().array();
        int outputOffset = typedOutput.storageOffset() - 1;
        ByteString[] inputData = (ByteString[])input.storage().array();
        int inputOffset = input.storageOffset() - 1;
        int dataSize = input.nElement();
        for (int i = 0; i < dataSize; ++i) {
            byte[] bytes = inputData[inputOffset + i].toByteArray();
            byte[] typedInputData = bytes;
            Log4Error$.MODULE$.invalidInputError(typedInputData.length == featureSize, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"each element should have the same size, first elem size: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)featureSize)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "th elem size: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)typedInputData.length)}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
            for (int j = 0; j < featureSize; ++j) {
                outputData[outputOffset + i * featureSize + j] = (short)(typedInputData[j] & (short)255);
            }
        }
    }

    public DecodeRaw(DataType outType, boolean littleEndian, ClassTag<T> evidence$6, TensorNumericMath.TensorNumeric<T> ev) {
        Tensor<Object> tensor;
        this.outType = outType;
        this.littleEndian = littleEndian;
        super(ClassTag$.MODULE$.apply(Tensor.class), ClassTag$.MODULE$.apply(Activity.class), evidence$6, ev);
        DataType dataType = outType;
        if (DataType.DT_UINT8.equals(dataType)) {
            tensor = Tensor$.MODULE$.apply(ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$);
        } else if (DataType.DT_INT16.equals(dataType)) {
            tensor = Tensor$.MODULE$.apply(ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$);
        } else if (DataType.DT_INT32.equals(dataType)) {
            tensor = Tensor$.MODULE$.apply(ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$);
        } else if (DataType.DT_INT8.equals(dataType)) {
            tensor = Tensor$.MODULE$.apply(ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$);
        } else if (DataType.DT_INT64.equals(dataType)) {
            tensor = Tensor$.MODULE$.apply(ClassTag$.MODULE$.Long(), TensorNumericMath$TensorNumeric$NumericLong$.MODULE$);
        } else if (DataType.DT_FLOAT.equals(dataType)) {
            tensor = Tensor$.MODULE$.apply(ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
        } else if (DataType.DT_DOUBLE.equals(dataType)) {
            tensor = Tensor$.MODULE$.apply(ClassTag$.MODULE$.Double(), TensorNumericMath$TensorNumeric$NumericDouble$.MODULE$);
        } else {
            Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " are not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outType})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            tensor = null;
        }
        this.output_$eq(tensor);
        this.byteOrder = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

