/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.nn.tf;

import com.intel.analytics.bigdl.dllib.nn.ops.Operation;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericInt$;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.shaded.protobuf_v_3_5_1.ByteString;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%b!B\u0001\u0003\u0001!\u0001\"a\u0003#fG>$W-S7bO\u0016T!a\u0001\u0003\u0002\u0005Q4'BA\u0003\u0007\u0003\tqgN\u0003\u0002\b\u0011\u0005)A\r\u001c7jE*\u0011\u0011BC\u0001\u0006E&<G\r\u001c\u0006\u0003\u00171\t\u0011\"\u00198bYf$\u0018nY:\u000b\u00055q\u0011!B5oi\u0016d'\"A\b\u0002\u0007\r|W.\u0006\u0002\u0012_M\u0011\u0001A\u0005\t\u0006'YAb%L\u0007\u0002))\u0011Q\u0003B\u0001\u0004_B\u001c\u0018BA\f\u0015\u0005%y\u0005/\u001a:bi&|g\u000eE\u0002\u001a9yi\u0011A\u0007\u0006\u00037\u0019\ta\u0001^3og>\u0014\u0018BA\u000f\u001b\u0005\u0019!VM\\:peB\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\taJ|Go\u001c2vM*\u00111ED\u0001\u0007O>|w\r\\3\n\u0005\u0015\u0002#A\u0003\"zi\u0016\u001cFO]5oOB\u0019\u0011\u0004H\u0014\u0011\u0005!ZS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0003\u0007%sG\u000f\u0005\u0002/_1\u0001A!\u0002\u0019\u0001\u0005\u0004\u0011$!\u0001+\u0004\u0001E\u00111G\u000e\t\u0003QQJ!!N\u0015\u0003\u000f9{G\u000f[5oOB\u0011\u0001fN\u0005\u0003q%\u00121!\u00118z\u0011!Q\u0004A!b\u0001\n\u0003Y\u0014\u0001C2iC:tW\r\\:\u0016\u0003\u001dB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IaJ\u0001\nG\"\fgN\\3mg\u0002B\u0001b\u0010\u0001\u0003\u0004\u0003\u0006Y\u0001Q\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004cA!E[5\t!I\u0003\u0002DS\u00059!/\u001a4mK\u000e$\u0018BA#C\u0005!\u0019E.Y:t)\u0006<\u0007\u0002C$\u0001\u0005\u0003\u0005\u000b1\u0002%\u0002\u0005\u00154\bcA%\\[9\u0011!*\u0017\b\u0003\u0017bs!\u0001T,\u000f\u000553fB\u0001(V\u001d\tyEK\u0004\u0002Q'6\t\u0011K\u0003\u0002Sc\u00051AH]8pizJ\u0011aD\u0005\u0003\u001b9I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\tYb!\u0003\u0002[5\u0005\tB+\u001a8t_JtU/\\3sS\u000el\u0015\r\u001e5\n\u0005qk&!\u0004+f]N|'OT;nKJL7M\u0003\u0002[5!)q\f\u0001C\u0001A\u00061A(\u001b8jiz\"\"!\u00194\u0015\u0007\t$W\rE\u0002d\u00015j\u0011A\u0001\u0005\u0006\u007fy\u0003\u001d\u0001\u0011\u0005\u0006\u000fz\u0003\u001d\u0001\u0013\u0005\u0006uy\u0003\ra\n\u0005\u0006Q\u0002!\t%[\u0001\rkB$\u0017\r^3PkR\u0004X\u000f\u001e\u000b\u0003M)DQa[4A\u0002a\tQ!\u001b8qkRDQ!\u001c\u0001\u0005\u00129\fQbY8qs&k\u0017mZ3ECR\fGcB8s{\u0006\u0015\u0011\u0011\u0002\t\u0003QAL!!]\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0006g2\u0004\r\u0001^\u0001\u0006S6\fw-\u001a\t\u0003knl\u0011A\u001e\u0006\u0003g^T!\u0001_=\u0002\u0007\u0005<HOC\u0001{\u0003\u0011Q\u0017M^1\n\u0005q4(!\u0004\"vM\u001a,'/\u001a3J[\u0006<W\rC\u0003\u007fY\u0002\u0007q0\u0001\u0006pkR\u0004X\u000f\u001e#bi\u0006\u0004B\u0001KA\u0001O%\u0019\u00111A\u0015\u0003\u000b\u0005\u0013(/Y=\t\r\u0005\u001dA\u000e1\u0001(\u0003\u0019ygMZ:fi\"1\u00111\u00027A\u0002\u001d\na\u0001\\3oORD\u0007bBA\b\u0001\u0011%\u0011\u0011C\u0001\fEf$Xm\u001d+p\u0013:$8\u000fF\u0005p\u0003'\ty\"a\t\u0002(!A\u0011QCA\u0007\u0001\u0004\t9\"A\u0003csR,7\u000fE\u0003)\u0003\u0003\tI\u0002E\u0002)\u00037I1!!\b*\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005\u0005\u0012Q\u0002a\u0001\u007f\u0006!\u0011N\u001c;t\u0011\u001d\t)#!\u0004A\u0002\u001d\nQa\u001d;beRDq!a\u0003\u0002\u000e\u0001\u0007q\u0005")
public class DecodeImage<T>
extends Operation<Tensor<ByteString>, Tensor<Object>, T> {
    private final int channels;

    public int channels() {
        return this.channels;
    }

    @Override
    public Tensor<Object> updateOutput(Tensor<ByteString> input) {
        int n;
        Log4Error$.MODULE$.invalidInputError(input.isScalar(), "only support ByteString scalar", Log4Error$.MODULE$.invalidInputError$default$3());
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(input.value().toByteArray()));
        Log4Error$.MODULE$.invalidInputError(image != null, "Can't decode image", Log4Error$.MODULE$.invalidInputError$default$3());
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (this.channels() == 0) {
            n = image.getColorModel().getNumComponents();
        } else {
            Log4Error$.MODULE$.invalidInputError(this.channels() == image.getColorModel().getNumComponents(), "Only support inputs channels equal to desired channels", Log4Error$.MODULE$.invalidInputError$default$3());
            n = this.channels();
        }
        int expectedChannels = n;
        ((Tensor)this.output()).resize(imageHeight, imageWidth, expectedChannels);
        int[] outputData = (int[])((Tensor)this.output()).storage().array();
        int offset = ((Tensor)this.output()).storageOffset() - 1;
        int length = imageHeight * imageWidth * expectedChannels;
        this.copyImageData(image, outputData, offset, length);
        return (Tensor)this.output();
    }

    public void copyImageData(BufferedImage image, int[] outputData, int offset, int length) {
        byte[] data2 = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        this.bytesToInts(data2, outputData, offset, length);
    }

    private void bytesToInts(byte[] bytes, int[] ints, int start2, int length) {
        if (bytes.length == length) {
            for (int i = 0; i < length; ++i) {
                ints[i + start2] = bytes[i] & 0xFF;
            }
        } else if (bytes.length * 3 == length) {
            for (int i = 0; i < length; ++i) {
                int index = i / 3;
                ints[i + start2] = bytes[index] & 0xFF;
            }
        } else {
            Log4Error$.MODULE$.invalidOperationError(false, "image data is not equal to output buffer", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        }
    }

    public DecodeImage(int channels, ClassTag<T> evidence$1, TensorNumericMath.TensorNumeric<T> ev) {
        this.channels = channels;
        super(ClassTag$.MODULE$.apply(Tensor.class), ClassTag$.MODULE$.apply(Tensor.class), evidence$1, ev);
        this.output_$eq(Tensor$.MODULE$.apply(ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$));
    }
}

