/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.nn.ops;

import com.intel.analytics.bigdl.dllib.nn.Utils$;
import com.intel.analytics.bigdl.dllib.nn.ops.Operation;
import com.intel.analytics.bigdl.dllib.tensor.DoubleType$;
import com.intel.analytics.bigdl.dllib.tensor.FloatType$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorDataType;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.Table;
import scala.Double$;
import scala.Float$;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg!B\u0001\u0003\u0001!\u0001\"\u0001\u0007#jY\u0006$\u0018n\u001c83\t\n\u000b7m\u001b9s_B4\u0015\u000e\u001c;fe*\u00111\u0001B\u0001\u0004_B\u001c(BA\u0003\u0007\u0003\tqgN\u0003\u0002\b\u0011\u0005)A\r\u001c7jE*\u0011\u0011BC\u0001\u0006E&<G\r\u001c\u0006\u0003\u00171\t\u0011\"\u00198bYf$\u0018nY:\u000b\u00055q\u0011!B5oi\u0016d'\"A\b\u0002\u0007\r|W.F\u0002\u0012e\u0011\u001a\"\u0001\u0001\n\u0011\u000bM!b\u0003H\u0019\u000e\u0003\tI!!\u0006\u0002\u0003\u0013=\u0003XM]1uS>t\u0007CA\f\u001b\u001b\u0005A\"BA\r\u0007\u0003\u0015)H/\u001b7t\u0013\tY\u0002DA\u0003UC\ndW\rE\u0002\u001eA\tj\u0011A\b\u0006\u0003?\u0019\ta\u0001^3og>\u0014\u0018BA\u0011\u001f\u0005\u0019!VM\\:peB\u00111\u0005\n\u0007\u0001\t\u0015)\u0003A1\u0001(\u0005\u0005!5\u0001A\t\u0003Q9\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012qAT8uQ&tw\r\u0005\u0002*_%\u0011\u0001G\u000b\u0002\u0004\u0003:L\bCA\u00123\t\u0015\u0019\u0004A1\u0001(\u0005\u0005!\u0006\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\u0002\u000fM$(/\u001b3fgB\u0019\u0011fN\u001d\n\u0005aR#!B!se\u0006L\bCA\u0015;\u0013\tY$FA\u0002J]RD\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IAN\u0001\u0006e\u0006$Xm\u001d\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\u00069\u0001/\u00193eS:<\u0007CA!E\u001d\tI#)\u0003\u0002DU\u00051\u0001K]3eK\u001aL!!\u0012$\u0003\rM#(/\u001b8h\u0015\t\u0019%\u0006\u0003\u0005I\u0001\t\r\t\u0015a\u0003J\u0003))g/\u001b3f]\u000e,G%\u000e\t\u0004\u00156\u000bT\"A&\u000b\u00051S\u0013a\u0002:fM2,7\r^\u0005\u0003\u001d.\u0013\u0001b\u00117bgN$\u0016m\u001a\u0005\t!\u0002\u0011\u0019\u0011)A\u0006#\u0006QQM^5eK:\u001cW\r\n\u001c\u0011\u0007)k%\u0005\u0003\u0005T\u0001\t\u0005\t\u0015a\u0003U\u0003\t)g\u000fE\u0002VOFr!AV3\u000f\u0005]#gB\u0001-d\u001d\tI&M\u0004\u0002[C:\u00111\f\u0019\b\u00039~k\u0011!\u0018\u0006\u0003=\u001a\na\u0001\u0010:p_Rt\u0014\"A\b\n\u00055q\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011qDB\u0005\u0003Mz\t\u0011\u0003V3og>\u0014h*^7fe&\u001cW*\u0019;i\u0013\tA\u0017NA\u0007UK:\u001cxN\u001d(v[\u0016\u0014\u0018n\u0019\u0006\u0003MzA\u0001b\u001b\u0001\u0003\u0002\u0003\u0006Y\u0001\\\u0001\u0004KZ\u0014\u0004cA+hE!)a\u000e\u0001C\u0001_\u00061A(\u001b8jiz\"B\u0001\u001d<xqR)\u0011O]:ukB!1\u0003A\u0019#\u0011\u0015AU\u000eq\u0001J\u0011\u0015\u0001V\u000eq\u0001R\u0011\u0015\u0019V\u000eq\u0001U\u0011\u0015YW\u000eq\u0001m\u0011\u0015)T\u000e1\u00017\u0011\u0015iT\u000e1\u00017\u0011\u0015yT\u000e1\u0001A\u0011\u0015Q\b\u0001\"\u0003|\u0003u!\u0017\u000e\\1uS>t'\u0007\u0012\"bG.\u0004(o\u001c9GS2$XM\u001d$m_\u0006$H\u0003\u0005?\u0000\u0003\u0017\ty!a\u0005\u0002\u0018\u0005m\u0011qDA\u0012!\tIS0\u0003\u0002\u007fU\t!QK\\5u\u0011\u001d\t\t!\u001fa\u0001\u0003\u0007\tQ!\u001b8qkR\u0004B!\b\u0011\u0002\u0006A\u0019\u0011&a\u0002\n\u0007\u0005%!FA\u0003GY>\fG\u000fC\u0004\u0002\u000ee\u0004\r!a\u0001\u0002\r\u0019LG\u000e^3s\u0011\u001d\t\t\"\u001fa\u0001\u0003\u0007\t1b\\;u\u0005\u0006\u001c7\u000e\u001d:pa\"9\u0011QC=A\u0002\u0005\r\u0011A\u00044jYR,'OQ1dWB\u0014x\u000e\u001d\u0005\u0007\u00033I\b\u0019A\u001d\u0002\u0015M$(/\u001b3f%><8\u000f\u0003\u0004\u0002\u001ee\u0004\r!O\u0001\u000bgR\u0014\u0018\u000eZ3D_2\u001c\bBBA\u0011s\u0002\u0007\u0011(\u0001\u0005sCR,'k\\<t\u0011\u0019\t)#\u001fa\u0001s\u0005A!/\u0019;f\u0007>d7\u000fC\u0004\u0002*\u0001!I!a\u000b\u0002=\u0011LG.\u0019;j_:\u0014DIQ1dWB\u0014x\u000e\u001d$jYR,'\u000fR8vE2,G#\u0005?\u0002.\u0005]\u0012\u0011HA\u001e\u0003{\ty$!\u0011\u0002D!A\u0011\u0011AA\u0014\u0001\u0004\ty\u0003\u0005\u0003\u001eA\u0005E\u0002cA\u0015\u00024%\u0019\u0011Q\u0007\u0016\u0003\r\u0011{WO\u00197f\u0011!\ti!a\nA\u0002\u0005=\u0002\u0002CA\t\u0003O\u0001\r!a\f\t\u0011\u0005U\u0011q\u0005a\u0001\u0003_Aq!!\u0007\u0002(\u0001\u0007\u0011\bC\u0004\u0002\u001e\u0005\u001d\u0002\u0019A\u001d\t\u000f\u0005\u0005\u0012q\u0005a\u0001s!9\u0011QEA\u0014\u0001\u0004I\u0004bBA$\u0001\u0011\u0005\u0013\u0011J\u0001\rkB$\u0017\r^3PkR\u0004X\u000f\u001e\u000b\u00049\u0005-\u0003bBA'\u0003\u000b\u0002\rAF\u0001\u0007S:\u0004X\u000f^:\t\u000f\u0005E\u0003\u0001\"\u0011\u0002T\u0005\u0019r-\u001a;DY\u0006\u001c8\u000fV1h\u001dVlWM]5dgR\u0011\u0011Q\u000b\t\bS\u0005]\u00131LA4\u0013\r\tIF\u000b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t%:\u0014Q\f\u0019\u0005\u0003?\n\u0019\u0007\u0005\u0003K\u001b\u0006\u0005\u0004cA\u0012\u0002d\u0011Y\u0011QMA(\u0003\u0003\u0005\tQ!\u0001(\u0005\ryFe\r\t\u0005S]\nI\u0007\r\u0003\u0002l\u0005=\u0004\u0003B+h\u0003[\u00022aIA8\t-\t\t(a\u0014\u0002\u0002\u0003\u0005)\u0011A\u0014\u0003\u0007}#Cg\u0002\u0005\u0002v\tA\t\u0001CA<\u0003a!\u0015\u000e\\1uS>t'\u0007\u0012\"bG.\u0004(o\u001c9GS2$XM\u001d\t\u0004'\u0005edaB\u0001\u0003\u0011\u0003A\u00111P\n\u0007\u0003s\ni(a!\u0011\u0007%\ny(C\u0002\u0002\u0002*\u0012a!\u00118z%\u00164\u0007cA\u0015\u0002\u0006&\u0019\u0011q\u0011\u0016\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000f9\fI\b\"\u0001\u0002\fR\u0011\u0011q\u000f\u0005\t\u0003\u001f\u000bI\b\"\u0001\u0002\u0012\u0006)\u0011\r\u001d9msV1\u00111SAN\u0003?#\u0002\"!&\u00026\u0006]\u0016\u0011\u0018\u000b\u000b\u0003/\u000b\t+a*\u0002.\u0006E\u0006CB\n\u0001\u00033\u000bi\nE\u0002$\u00037#aaMAG\u0005\u00049\u0003cA\u0012\u0002 \u00121Q%!$C\u0002\u001dB!\"a)\u0002\u000e\u0006\u0005\t9AAS\u0003))g/\u001b3f]\u000e,Ge\u000e\t\u0005\u00156\u000bI\n\u0003\u0006\u0002*\u00065\u0015\u0011!a\u0002\u0003W\u000b!\"\u001a<jI\u0016t7-\u001a\u00139!\u0011QU*!(\t\u000fM\u000bi\tq\u0001\u00020B!QkZAM\u0011\u001dY\u0017Q\u0012a\u0002\u0003g\u0003B!V4\u0002\u001e\"1Q'!$A\u0002YBa!PAG\u0001\u00041\u0004BB \u0002\u000e\u0002\u0007\u0001\t\u0003\u0006\u0002>\u0006e\u0014\u0011!C\u0005\u0003\u007f\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0019\t\u0005\u0003\u0007\fi-\u0004\u0002\u0002F*!\u0011qYAe\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0017\u0001\u00026bm\u0006LA!a4\u0002F\n1qJ\u00196fGR\u0004")
public class Dilation2DBackpropFilter<T, D>
extends Operation<Table, Tensor<D>, T> {
    private final int[] strides;
    private final int[] rates;
    private final String padding;
    private final ClassTag<T> evidence$5;
    private final ClassTag<D> evidence$6;
    private final TensorNumericMath.TensorNumeric<T> ev;
    private final TensorNumericMath.TensorNumeric<D> ev2;

    private void dilation2DBackpropFilterFloat(Tensor<Object> input, Tensor<Object> filter, Tensor<Object> outBackprop, Tensor<Object> filterBackprop, int strideRows, int strideCols, int rateRows, int rateCols) {
        int batch = input.size(1);
        int inputRows = input.size(2);
        int inputCols = input.size(3);
        int depth = input.size(4);
        int filterRows = filter.size(1);
        int filterCols = filter.size(2);
        int filterRowsEff = filterRows + (filterRows - 1) * (rateRows - 1);
        int filterColsEff = filterCols + (filterCols - 1) * (rateCols - 1);
        Tuple3<Object, Object, Object> tuple3 = Utils$.MODULE$.getOutputSize(inputRows, filterRowsEff, strideRows, this.padding);
        if (tuple3 != null) {
            Tuple2.mcII.sp sp2;
            int outputRows = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int padTop = BoxesRunTime.unboxToInt((Object)tuple3._2());
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(outputRows, padTop);
            int outputRows2 = sp3._1$mcI$sp();
            int padTop2 = sp3._2$mcI$sp();
            Tuple3<Object, Object, Object> tuple32 = Utils$.MODULE$.getOutputSize(inputCols, filterColsEff, strideCols, this.padding);
            if (tuple32 != null) {
                Tuple2.mcII.sp sp4;
                int outputCols = BoxesRunTime.unboxToInt((Object)tuple32._1());
                int padLeft = BoxesRunTime.unboxToInt((Object)tuple32._2());
                Tuple2.mcII.sp sp5 = sp4 = new Tuple2.mcII.sp(outputCols, padLeft);
                int outputCols2 = sp5._1$mcI$sp();
                int padLeft2 = sp5._2$mcI$sp();
                filterBackprop.resizeAs(filter);
                float[] inputData = (float[])input.storage().array();
                int inputDataOffset = input.storageOffset() - 1;
                float[] filterData = (float[])filter.storage().array();
                int filterDataOffset = filter.storageOffset() - 1;
                float[] outBackpropData = (float[])outBackprop.storage().array();
                int outBackpropDataOffset = outBackprop.storageOffset() - 1;
                float[] filterBackpropData = (float[])filterBackprop.storage().array();
                int filterBackpropDataOffset = filterBackprop.storageOffset() - 1;
                for (int b = 0; b < batch; ++b) {
                    for (int h_out = 0; h_out < outputRows2; ++h_out) {
                        int h_beg = h_out * strideRows - padTop2;
                        for (int w_out = 0; w_out < outputCols2; ++w_out) {
                            int w_beg = w_out * strideCols - padLeft2;
                            for (int d = 0; d < depth; ++d) {
                                float cur_val = Float$.MODULE$.MinValue();
                                int h_max = 0;
                                int w_max = 0;
                                for (int h2 = 0; h2 < filterRows; ++h2) {
                                    int h_in = h_beg + h2 * rateRows;
                                    if (h_in < 0 || h_in >= inputRows) continue;
                                    for (int w = 0; w < filterCols; ++w) {
                                        int filterIndex;
                                        float filterValue;
                                        int inputIndex;
                                        float inputValue;
                                        float value2;
                                        int w_in = w_beg + w * rateCols;
                                        if (w_in < 0 || w_in >= inputCols || !((value2 = (inputValue = inputData[inputDataOffset + (inputIndex = ((b * inputRows + h_in) * inputCols + w_in) * depth + d)]) + (filterValue = filterData[filterDataOffset + (filterIndex = (h2 * filterCols + w) * depth + d)])) > cur_val)) continue;
                                        cur_val = value2;
                                        h_max = h2;
                                        w_max = w;
                                    }
                                }
                                int filterBackPropIndex = (h_max * filterCols + w_max) * depth + d;
                                int outputBackPropIndex = ((b * outputRows2 + h_out) * outputCols2 + w_out) * depth + d;
                                int n = filterBackpropDataOffset + filterBackPropIndex;
                                filterBackpropData[n] = filterBackpropData[n] + outBackpropData[outBackpropDataOffset + outputBackPropIndex];
                            }
                        }
                    }
                }
                return;
            }
            throw new MatchError(tuple32);
        }
        throw new MatchError(tuple3);
    }

    private void dilation2DBackpropFilterDouble(Tensor<Object> input, Tensor<Object> filter, Tensor<Object> outBackprop, Tensor<Object> filterBackprop, int strideRows, int strideCols, int rateRows, int rateCols) {
        int batch = input.size(1);
        int inputRows = input.size(2);
        int inputCols = input.size(3);
        int depth = input.size(4);
        int filterRows = filter.size(1);
        int filterCols = filter.size(2);
        int filterRowsEff = filterRows + (filterRows - 1) * (rateRows - 1);
        int filterColsEff = filterCols + (filterCols - 1) * (rateCols - 1);
        Tuple3<Object, Object, Object> tuple3 = Utils$.MODULE$.getOutputSize(inputRows, filterRowsEff, strideRows, this.padding);
        if (tuple3 != null) {
            Tuple2.mcII.sp sp2;
            int outputRows = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int padTop = BoxesRunTime.unboxToInt((Object)tuple3._2());
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(outputRows, padTop);
            int outputRows2 = sp3._1$mcI$sp();
            int padTop2 = sp3._2$mcI$sp();
            Tuple3<Object, Object, Object> tuple32 = Utils$.MODULE$.getOutputSize(inputCols, filterColsEff, strideCols, this.padding);
            if (tuple32 != null) {
                Tuple2.mcII.sp sp4;
                int outputCols = BoxesRunTime.unboxToInt((Object)tuple32._1());
                int padLeft = BoxesRunTime.unboxToInt((Object)tuple32._2());
                Tuple2.mcII.sp sp5 = sp4 = new Tuple2.mcII.sp(outputCols, padLeft);
                int outputCols2 = sp5._1$mcI$sp();
                int padLeft2 = sp5._2$mcI$sp();
                filterBackprop.resizeAs(filter);
                double[] inputData = (double[])input.storage().array();
                int inputDataOffset = input.storageOffset() - 1;
                double[] filterData = (double[])filter.storage().array();
                int filterDataOffset = filter.storageOffset() - 1;
                double[] outBackpropData = (double[])outBackprop.storage().array();
                int outBackpropDataOffset = outBackprop.storageOffset() - 1;
                double[] filterBackpropData = (double[])filterBackprop.storage().array();
                int filterBackpropDataOffset = filterBackprop.storageOffset() - 1;
                for (int b = 0; b < batch; ++b) {
                    for (int h_out = 0; h_out < outputRows2; ++h_out) {
                        int h_beg = h_out * strideRows - padTop2;
                        for (int w_out = 0; w_out < outputCols2; ++w_out) {
                            int w_beg = w_out * strideCols - padLeft2;
                            for (int d = 0; d < depth; ++d) {
                                double cur_val = Double$.MODULE$.MinValue();
                                int h_max = 0;
                                int w_max = 0;
                                for (int h2 = 0; h2 < filterRows; ++h2) {
                                    int h_in = h_beg + h2 * rateRows;
                                    if (h_in < 0 || h_in >= inputRows) continue;
                                    for (int w = 0; w < filterCols; ++w) {
                                        int filterIndex;
                                        double filterValue;
                                        int inputIndex;
                                        double inputValue;
                                        double value2;
                                        int w_in = w_beg + w * rateCols;
                                        if (w_in < 0 || w_in >= inputCols || !((value2 = (inputValue = inputData[inputDataOffset + (inputIndex = ((b * inputRows + h_in) * inputCols + w_in) * depth + d)]) + (filterValue = filterData[filterDataOffset + (filterIndex = (h2 * filterCols + w) * depth + d)])) > cur_val)) continue;
                                        cur_val = value2;
                                        h_max = h2;
                                        w_max = w;
                                    }
                                }
                                int filterBackPropIndex = (h_max * filterCols + w_max) * depth + d;
                                int outputBackPropIndex = ((b * outputRows2 + h_out) * outputCols2 + w_out) * depth + d;
                                int n = filterBackpropDataOffset + filterBackPropIndex;
                                filterBackpropData[n] = filterBackpropData[n] + outBackpropData[outBackpropDataOffset + outputBackPropIndex];
                            }
                        }
                    }
                }
                return;
            }
            throw new MatchError(tuple32);
        }
        throw new MatchError(tuple3);
    }

    @Override
    public Tensor<D> updateOutput(Table inputs2) {
        Tensor input = (Tensor)inputs2.apply(BoxesRunTime.boxToInteger((int)1));
        Tensor filter = (Tensor)inputs2.apply(BoxesRunTime.boxToInteger((int)2));
        Tensor outBackprop = (Tensor)inputs2.apply(BoxesRunTime.boxToInteger((int)3));
        Log4Error$.MODULE$.invalidInputError(input.dim() == 4, "input must have 4 dims", Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(filter.dim() == 3, "filter must have 3 dims", Log4Error$.MODULE$.invalidInputError$default$3());
        int strideRows = this.strides[1];
        int strideCols = this.strides[2];
        int rateRows = this.rates[1];
        int rateCols = this.rates[2];
        TensorDataType tensorDataType = this.ev2.getType();
        FloatType$ floatType$ = FloatType$.MODULE$;
        if (!(tensorDataType != null ? !tensorDataType.equals(floatType$) : floatType$ != null)) {
            Tensor inputTensor = input;
            Tensor filterTensor = filter;
            Tensor outBackpropTensor = outBackprop;
            Tensor outputTensor = (Tensor)this.output();
            this.dilation2DBackpropFilterFloat(inputTensor, filterTensor, outBackpropTensor, outputTensor, strideRows, strideCols, rateRows, rateCols);
        } else {
            TensorDataType tensorDataType2 = this.ev2.getType();
            DoubleType$ doubleType$ = DoubleType$.MODULE$;
            if (!(tensorDataType2 != null ? !tensorDataType2.equals(doubleType$) : doubleType$ != null)) {
                Tensor inputTensor = input;
                Tensor filterTensor = filter;
                Tensor outBackpropTensor = (Tensor)this.output();
                Tensor outputTensor = (Tensor)this.output();
                this.dilation2DBackpropFilterDouble(inputTensor, filterTensor, outBackpropTensor, outputTensor, strideRows, strideCols, rateRows, rateCols);
            } else {
                Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not support datatype ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ev2.getType()})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            }
        }
        return (Tensor)this.output();
    }

    @Override
    public Tuple2<ClassTag<?>[], TensorNumericMath.TensorNumeric<?>[]> getClassTagNumerics() {
        return new Tuple2((Object)new ClassTag[]{package$.MODULE$.classTag(this.evidence$5), package$.MODULE$.classTag(this.evidence$6)}, (Object)new TensorNumericMath.TensorNumeric[]{this.ev, this.ev2});
    }

    public Dilation2DBackpropFilter(int[] strides, int[] rates, String padding, ClassTag<T> evidence$5, ClassTag<D> evidence$6, TensorNumericMath.TensorNumeric<T> ev, TensorNumericMath.TensorNumeric<D> ev2) {
        this.strides = strides;
        this.rates = rates;
        this.padding = padding;
        this.evidence$5 = evidence$5;
        this.evidence$6 = evidence$6;
        this.ev = ev;
        this.ev2 = ev2;
        super(ClassTag$.MODULE$.apply(Table.class), ClassTag$.MODULE$.apply(Tensor.class), evidence$5, ev);
        this.output_$eq(Tensor$.MODULE$.apply(evidence$6, ev2));
    }
}

