/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.nn.ops;

import com.intel.analytics.bigdl.dllib.nn.ops.BatchMatMul$;
import com.intel.analytics.bigdl.dllib.nn.ops.Operation;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorMath;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.T$;
import com.intel.analytics.bigdl.dllib.utils.Table;
import scala.Array$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001B\u0001\u0003\u0001E\u00111BQ1uG\"l\u0015\r^'vY*\u00111\u0001B\u0001\u0004_B\u001c(BA\u0003\u0007\u0003\tqgN\u0003\u0002\b\u0011\u0005)A\r\u001c7jE*\u0011\u0011BC\u0001\u0006E&<G\r\u001c\u0006\u0003\u00171\t\u0011\"\u00198bYf$\u0018nY:\u000b\u00055q\u0011!B5oi\u0016d'\"A\b\u0002\u0007\r|Wn\u0001\u0001\u0016\u0007I\u0011Te\u0005\u0002\u0001'A)A#F\f\u001ec5\t!!\u0003\u0002\u0017\u0005\tIq\n]3sCRLwN\u001c\t\u00031mi\u0011!\u0007\u0006\u00035\u0019\tQ!\u001e;jYNL!\u0001H\r\u0003\u000bQ\u000b'\r\\3\u0011\u0007y\t3%D\u0001 \u0015\t\u0001c!\u0001\u0004uK:\u001cxN]\u0005\u0003E}\u0011a\u0001V3og>\u0014\bC\u0001\u0013&\u0019\u0001!QA\n\u0001C\u0002\u001d\u0012\u0011\u0001R\t\u0003Q9\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012qAT8uQ&tw\r\u0005\u0002*_%\u0011\u0001G\u000b\u0002\u0004\u0003:L\bC\u0001\u00133\t\u0015\u0019\u0004A1\u0001(\u0005\u0005!\u0006\u0002C\u001b\u0001\u0005\u000b\u0007I\u0011\u0001\u001c\u0002\t\u0005$'\u000eW\u000b\u0002oA\u0011\u0011\u0006O\u0005\u0003s)\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005<\u0001\t\u0005\t\u0015!\u00038\u0003\u0015\tGM\u001b-!\u0011!i\u0004A!b\u0001\n\u00031\u0014\u0001B1eUfC\u0001b\u0010\u0001\u0003\u0002\u0003\u0006IaN\u0001\u0006C\u0012T\u0017\f\t\u0005\t\u0003\u0002\u0011\u0019\u0011)A\u0006\u0005\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u0007\r3\u0015'D\u0001E\u0015\t)%&A\u0004sK\u001adWm\u0019;\n\u0005\u001d#%\u0001C\"mCN\u001cH+Y4\t\u0011%\u0003!1!Q\u0001\f)\u000b!\"\u001a<jI\u0016t7-\u001a\u00133!\r\u0019ei\t\u0005\t\u0019\u0002\u0011\t\u0011)A\u0006\u001b\u0006\u0011QM\u001e\t\u0004\u001d\u0002\fdBA(_\u001d\t\u0001VL\u0004\u0002R9:\u0011!k\u0017\b\u0003'js!\u0001V-\u000f\u0005UCV\"\u0001,\u000b\u0005]\u0003\u0012A\u0002\u001fs_>$h(C\u0001\u0010\u0013\tia\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!\u0001\t\u0004\n\u0005}{\u0012!\u0005+f]N|'OT;nKJL7-T1uQ&\u0011\u0011M\u0019\u0002\u000e)\u0016t7o\u001c:Ok6,'/[2\u000b\u0005}{\u0002\u0002\u00033\u0001\u0005\u0003\u0005\u000b1B3\u0002\u0007\u00154(\u0007E\u0002OA\u000eBQa\u001a\u0001\u0005\u0002!\fa\u0001P5oSRtDcA5paR)!n\u001b7n]B!A\u0003A\u0019$\u0011\u0015\te\rq\u0001C\u0011\u0015Ie\rq\u0001K\u0011\u0015ae\rq\u0001N\u0011\u0015!g\rq\u0001f\u0011\u001d)d\r%AA\u0002]Bq!\u00104\u0011\u0002\u0003\u0007q\u0007C\u0003s\u0001\u0011\u00053/\u0001\u0007va\u0012\fG/Z(viB,H\u000f\u0006\u0002\u001ei\")Q/\u001da\u0001/\u0005)\u0011N\u001c9vi\")q\u000f\u0001C!q\u0006\u0019r-\u001a;DY\u0006\u001c8\u000fV1h\u001dVlWM]5dgR\t\u0011\u0010E\u0003*ur\fI!\u0003\u0002|U\t1A+\u001e9mKJ\u00022!K?\u0000\u0013\tq(FA\u0003BeJ\f\u0017\u0010\r\u0003\u0002\u0002\u0005\u0015\u0001\u0003B\"G\u0003\u0007\u00012\u0001JA\u0003\t)\t9A^A\u0001\u0002\u0003\u0015\ta\n\u0002\u0004?\u0012\n\u0004\u0003B\u0015~\u0003\u0017\u0001D!!\u0004\u0002\u0012A!a\nYA\b!\r!\u0013\u0011\u0003\u0003\u000b\u0003'1\u0018\u0011!A\u0001\u0006\u00039#aA0%e\u001d9\u0011q\u0003\u0002\t\u0002\u0005e\u0011a\u0003\"bi\u000eDW*\u0019;Nk2\u00042\u0001FA\u000e\r\u0019\t!\u0001#\u0001\u0002\u001eM1\u00111DA\u0010\u0003K\u00012!KA\u0011\u0013\r\t\u0019C\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0007%\n9#C\u0002\u0002*)\u0012AbU3sS\u0006d\u0017N_1cY\u0016DqaZA\u000e\t\u0003\ti\u0003\u0006\u0002\u0002\u001a!A\u0011\u0011GA\u000e\t\u0003\t\u0019$A\u0003baBd\u00170\u0006\u0004\u00026\u0005u\u0012\u0011\r\u000b\u0007\u0003o\t9(!\u001f\u0015\u0015\u0005e\u00121MA5\u0003_\n\u0019\b\u0005\u0004\u0015\u0001\u0005m\u0012q\f\t\u0004I\u0005uBAC\u001a\u00020\u0001\u0006\t\u0011!b\u0001O!B\u0011QHA!\u0003\u000f\n)\u0006E\u0002*\u0003\u0007J1!!\u0012+\u0005-\u0019\b/Z2jC2L'0\u001a32\u0013\r\nI%a\u0013\u0002P\u00055cbA\u0015\u0002L%\u0019\u0011Q\n\u0016\u0002\u000b\u0019cw.\u0019;2\r\u0011\n\t&a\u0015,\u001d\r)\u00161K\u0005\u0002WEJ1%a\u0016\u0002Z\u0005u\u00131\f\b\u0004S\u0005e\u0013bAA.U\u00051Ai\\;cY\u0016\fd\u0001JA)\u0003'Z\u0003c\u0001\u0013\u0002b\u00111a%a\fC\u0002\u001dB!\"!\u001a\u00020\u0005\u0005\t9AA4\u0003))g/\u001b3f]\u000e,Ge\r\t\u0005\u0007\u001a\u000bY\u0004\u0003\u0006\u0002l\u0005=\u0012\u0011!a\u0002\u0003[\n!\"\u001a<jI\u0016t7-\u001a\u00135!\u0011\u0019e)a\u0018\t\u000f1\u000by\u0003q\u0001\u0002rA!a\nYA\u001e\u0011\u001d!\u0017q\u0006a\u0002\u0003k\u0002BA\u00141\u0002`!AQ'a\f\u0011\u0002\u0003\u0007q\u0007\u0003\u0005>\u0003_\u0001\n\u00111\u00018\u0011)\ti(a\u0007\u0012\u0002\u0013\u0005\u0011qP\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%cU1\u0011\u0011QAL\u0003G+\"!a!+\u0007]\n)i\u000b\u0002\u0002\bB!\u0011\u0011RAJ\u001b\t\tYI\u0003\u0003\u0002\u000e\u0006=\u0015!C;oG\",7m[3e\u0015\r\t\tJK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAK\u0003\u0017\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t)\u0019\u00141\u0010Q\u0001\u0002\u0003\u0015\ra\n\u0015\t\u0003/\u000b\t%a'\u0002 FJ1%!\u0013\u0002L\u0005u\u0015QJ\u0019\u0007I\u0005E\u00131K\u00162\u0013\r\n9&!\u0017\u0002\"\u0006m\u0013G\u0002\u0013\u0002R\u0005M3\u0006\u0002\u0004'\u0003w\u0012\ra\n\u0005\u000b\u0003O\u000bY\"%A\u0005\u0002\u0005%\u0016aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0016\r\u0005\u0005\u00151VA\\\t)\u0019\u0014Q\u0015Q\u0001\u0002\u0003\u0015\ra\n\u0015\t\u0003W\u000b\t%a,\u00024FJ1%!\u0013\u0002L\u0005E\u0016QJ\u0019\u0007I\u0005E\u00131K\u00162\u0013\r\n9&!\u0017\u00026\u0006m\u0013G\u0002\u0013\u0002R\u0005M3\u0006\u0002\u0004'\u0003K\u0013\ra\n\u0005\u000b\u0003w\u000bY\"%A\u0005\u0002\u0005u\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'\u0006\u0004\u0002\u0002\u0006}\u0016\u0011\u0019\u0003\u0007g\u0005e&\u0019A\u0014\u0005\r\u0019\nIL1\u0001(\u0011)\t)-a\u0007\u0012\u0002\u0013\u0005\u0011qY\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\r\u0005\u0005\u0015\u0011ZAf\t\u0019\u0019\u00141\u0019b\u0001O\u00111a%a1C\u0002\u001dB!\"a4\u0002\u001c\u0005\u0005I\u0011BAi\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005M\u0007\u0003BAk\u0003?l!!a6\u000b\t\u0005e\u00171\\\u0001\u0005Y\u0006twM\u0003\u0002\u0002^\u0006!!.\u0019<b\u0013\u0011\t\t/a6\u0003\r=\u0013'.Z2u\u0001")
public class BatchMatMul<T, D>
extends Operation<Table, Tensor<D>, T> {
    private final boolean adjX;
    private final boolean adjY;
    private final ClassTag<T> evidence$1;
    private final ClassTag<D> evidence$2;
    private final TensorNumericMath.TensorNumeric<T> ev;
    private final TensorNumericMath.TensorNumeric<D> ev2;

    public static <T, D> boolean $lessinit$greater$default$2() {
        return BatchMatMul$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T, D> boolean $lessinit$greater$default$1() {
        return BatchMatMul$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T, D> boolean apply$default$2() {
        return BatchMatMul$.MODULE$.apply$default$2();
    }

    public static <T, D> boolean apply$default$1() {
        return BatchMatMul$.MODULE$.apply$default$1();
    }

    public boolean adjX() {
        return this.adjX;
    }

    public boolean adjY() {
        return this.adjY;
    }

    @Override
    public Tensor<D> updateOutput(Table input) {
        Tensor tensor;
        Tensor x = (Tensor)input.apply(BoxesRunTime.boxToInteger((int)1));
        Tensor y = (Tensor)input.apply(BoxesRunTime.boxToInteger((int)2));
        Log4Error$.MODULE$.invalidInputError(x.dim() == y.dim(), "tensor x and tensor y must have the same number of dims", Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(x.dim() >= 2, "tensor dim num must be at least 2", Log4Error$.MODULE$.invalidInputError$default$3());
        if (x.dim() == 2) {
            Log4Error$.MODULE$.invalidInputError(y.dim() == 2, new StringBuilder().append((Object)"second input tensor must be 2D").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"second input dim ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)y.dim())}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
            if (this.adjX()) {
                x = x.t();
            }
            if (this.adjY()) {
                y = y.t();
            }
            Log4Error$.MODULE$.invalidInputError(x.size(2) == y.size(1), new StringBuilder().append((Object)"matrix sizes do not match").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The sizes are ", " and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.size(2)), BoxesRunTime.boxToInteger((int)y.size(1))}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
            ((Tensor)this.output()).resize(x.size(1), y.size(2));
            tensor = ((TensorMath)this.output()).mm(x, y);
        } else {
            Log4Error$.MODULE$.invalidInputError(x.size(1) == y.size(1), new StringBuilder().append((Object)"inputs must contain the same number of minibatches").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The minibatces of each are ", " and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.size(1)), BoxesRunTime.boxToInteger((int)y.size(1))}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
            int dimNum = x.dim();
            int batchSize = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(x.size()).slice(0, dimNum - 2)).product((Numeric)Numeric.IntIsIntegral$.MODULE$));
            Tensor reshapedX = x.view(new int[]{batchSize, x.size(dimNum - 1), x.size(dimNum)});
            Tensor reshapedY = y.view(new int[]{batchSize, y.size(dimNum - 1), y.size(dimNum)});
            if (this.adjX()) {
                reshapedX = reshapedX.transpose(2, 3);
            }
            if (this.adjY()) {
                reshapedY = reshapedY.transpose(2, 3);
            }
            Log4Error$.MODULE$.invalidInputError(reshapedX.size(3) == reshapedY.size(2), new StringBuilder().append((Object)"matrix sizes do not match").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the matrix sizes are ", " and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)reshapedX.size(2)), BoxesRunTime.boxToInteger((int)reshapedY.size(3))}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
            ((Tensor)this.output()).resize(batchSize, reshapedX.size(2), reshapedY.size(3));
            ((TensorMath)this.output()).bmm(reshapedX, reshapedY);
            int[] outputSize = (int[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(x.size()).slice(0, dimNum - 2)).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(new int[]{reshapedX.size(2), reshapedY.size(3)}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            Tensor qual$1 = (Tensor)this.output();
            int[] x$1 = outputSize;
            int[] x$2 = qual$1.resize$default$2();
            tensor = qual$1.resize(x$1, x$2);
        }
        return (Tensor)this.output();
    }

    @Override
    public Tuple2<ClassTag<?>[], TensorNumericMath.TensorNumeric<?>[]> getClassTagNumerics() {
        return new Tuple2((Object)new ClassTag[]{package$.MODULE$.classTag(this.evidence$1), package$.MODULE$.classTag(this.evidence$2)}, (Object)new TensorNumericMath.TensorNumeric[]{this.ev, this.ev2});
    }

    public BatchMatMul(boolean adjX, boolean adjY, ClassTag<T> evidence$1, ClassTag<D> evidence$2, TensorNumericMath.TensorNumeric<T> ev, TensorNumericMath.TensorNumeric<D> ev2) {
        this.adjX = adjX;
        this.adjY = adjY;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        this.ev = ev;
        this.ev2 = ev2;
        super(ClassTag$.MODULE$.apply(Table.class), ClassTag$.MODULE$.apply(Tensor.class), evidence$1, ev);
        this.gradInput_$eq(T$.MODULE$.apply(Tensor$.MODULE$.apply(evidence$2, ev2), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Tensor$.MODULE$.apply(evidence$2, ev2)})));
        this.output_$eq(Tensor$.MODULE$.apply(evidence$2, ev2));
    }
}

