/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.nn.mkldnn;

import com.intel.analytics.bigdl.dllib.nn.abstractnn.Activity;
import com.intel.analytics.bigdl.dllib.nn.mkldnn.HeapData;
import com.intel.analytics.bigdl.dllib.nn.mkldnn.MemoryData;
import com.intel.analytics.bigdl.dllib.nn.mkldnn.MemoryOwner;
import com.intel.analytics.bigdl.dllib.nn.mkldnn.MklDnnModuleHelper;
import com.intel.analytics.bigdl.dllib.nn.mkldnn.NativeData;
import com.intel.analytics.bigdl.dllib.tensor.DnnTensor;
import com.intel.analytics.bigdl.dllib.tensor.DnnTensor$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericByte$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericFloat$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericInt$;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.T$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class MklDnnModuleHelper$class {
    public static MemoryOwner _this(MklDnnModuleHelper $this) {
        return $this;
    }

    public static Activity initActivity(MklDnnModuleHelper $this, MemoryData[] formats) {
        return formats.length == 1 ? $this.initTensor(formats[0]) : T$.MODULE$.array(Predef$.MODULE$.refArrayOps((Object[])formats).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MklDnnModuleHelper $outer;

            public final Tensor<?> apply(MemoryData x$1) {
                return this.$outer.initTensor(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tensor.class))));
    }

    public static Tensor initTensor(MklDnnModuleHelper $this, MemoryData format2) {
        Tensor<Object> tensor;
        int[] paddingShape = format2.getPaddingShape();
        long realSize = format2.getRealSize();
        MemoryData memoryData = format2;
        if (memoryData instanceof NativeData) {
            DnnTensor<Object> dnnTensor;
            NativeData nativeData2 = (NativeData)memoryData;
            int n = nativeData2.dataType();
            switch (n) {
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
                case 1: {
                    dnnTensor = DnnTensor$.MODULE$.apply(paddingShape, realSize, ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$, $this._this());
                    break;
                }
                case 2: {
                    dnnTensor = DnnTensor$.MODULE$.apply(paddingShape, realSize, ClassTag$.MODULE$.Int(), TensorNumericMath$TensorNumeric$NumericInt$.MODULE$, $this._this());
                    break;
                }
                case 6: {
                    dnnTensor = DnnTensor$.MODULE$.apply(paddingShape, realSize, ClassTag$.MODULE$.Byte(), TensorNumericMath$TensorNumeric$NumericByte$.MODULE$, $this._this());
                    break;
                }
                case 5: {
                    dnnTensor = DnnTensor$.MODULE$.apply(paddingShape, realSize, ClassTag$.MODULE$.Byte(), TensorNumericMath$TensorNumeric$NumericByte$.MODULE$, $this._this());
                }
            }
            tensor = dnnTensor;
        } else if (memoryData instanceof HeapData) {
            tensor = Tensor$.MODULE$.apply(paddingShape, ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$);
        } else {
            Log4Error$.MODULE$.invalidInputError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory format ", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{format2})), "only support NativeData and HeapData");
            tensor = null;
        }
        return tensor;
    }

    public static MemoryData[] singleNativeData(MklDnnModuleHelper $this, MemoryData[] formats) {
        Log4Error$.MODULE$.invalidInputError(formats.length == 1, "Only accept one tensor as input", Log4Error$.MODULE$.invalidInputError$default$3());
        return $this.nativeData(formats);
    }

    public static MemoryData[] nativeData(MklDnnModuleHelper $this, MemoryData[] formats) {
        return (MemoryData[])Predef$.MODULE$.refArrayOps((Object[])formats).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final NativeData apply(MemoryData f) {
                NativeData nativeData2;
                MemoryData memoryData = f;
                if (memoryData instanceof NativeData) {
                    NativeData nativeData3;
                    nativeData2 = nativeData3 = (NativeData)memoryData;
                } else if (memoryData instanceof HeapData) {
                    HeapData heapData = (HeapData)memoryData;
                    nativeData2 = heapData.toNative();
                } else {
                    Log4Error$.MODULE$.invalidInputError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory format ", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f})), "only support NativeData and HeapData");
                    nativeData2 = null;
                }
                return nativeData2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MemoryData.class)));
    }

    public static void $init$(MklDnnModuleHelper $this) {
    }
}

