/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.nn;

import com.intel.analytics.bigdl.dllib.nn.NNPrimitive$;
import com.intel.analytics.bigdl.dllib.nn.Utils$;
import com.intel.analytics.bigdl.dllib.nn.VolumetricConvolution;
import com.intel.analytics.bigdl.dllib.optim.Regularizer;
import com.intel.analytics.bigdl.dllib.tensor.ConvertableFrom$ConvertableFromDouble$;
import com.intel.analytics.bigdl.dllib.tensor.DoubleType$;
import com.intel.analytics.bigdl.dllib.tensor.FloatType$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.TensorDataType;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

public final class VolumetricConvolution$
implements Serializable {
    public static final VolumetricConvolution$ MODULE$;

    static {
        new VolumetricConvolution$();
    }

    public <T> VolumetricConvolution<T> apply(int nInputPlane, int nOutputPlane, int kT, int kW, int kH, int dT, int dW, int dH, int padT, int padW, int padH, boolean withBias, Regularizer<T> wRegularizer, Regularizer<T> bRegularizer, ClassTag<T> evidence$2, TensorNumericMath.TensorNumeric<T> ev) {
        return new VolumetricConvolution<T>(nInputPlane, nOutputPlane, kT, kW, kH, dT, dW, dH, padT, padW, padH, withBias, wRegularizer, bRegularizer, evidence$2, ev);
    }

    public <T> int apply$default$6() {
        return 1;
    }

    public <T> int apply$default$7() {
        return 1;
    }

    public <T> int apply$default$8() {
        return 1;
    }

    public <T> int apply$default$9() {
        return 0;
    }

    public <T> int apply$default$10() {
        return 0;
    }

    public <T> int apply$default$11() {
        return 0;
    }

    public <T> boolean apply$default$12() {
        return true;
    }

    public <T> Null$ apply$default$13() {
        return null;
    }

    public <T> Null$ apply$default$14() {
        return null;
    }

    public <T> void conv3d(Tensor<T> input, Tensor<T> output, Tensor<T> weightMM, Tensor<T> bias, Tensor<T> onesBias, Tensor<T> fInput, int nInputPlane, int nOutputPlane, boolean withBias, int kT, int kW, int kH, int dT, int dW, int dH, int padT, int padW, int padH, TensorNumericMath.TensorNumeric<T> ev) {
        int[] nArray;
        int dimDepth = input.dim() == 4 ? 2 : 3;
        int dimWidth = input.dim() == 4 ? 4 : 5;
        int dimHeight = input.dim() == 4 ? 3 : 4;
        int inputWidth = input.size(dimWidth);
        int inputHeight = input.size(dimHeight);
        int inputDepth = input.size(dimDepth);
        if (padW == -1 && padH == -1 && padT == -1) {
            nArray = Utils$.MODULE$.getSAMEOutSizeAndPadding(inputHeight, inputWidth, dH, dW, kH, kW, inputDepth, dT, kT);
        } else {
            int x$18 = inputHeight;
            int x$19 = inputWidth;
            int x$20 = dH;
            int x$21 = dW;
            int x$22 = kH;
            int x$23 = kW;
            int x$24 = padH;
            int x$25 = padW;
            boolean x$26 = false;
            int x$27 = inputDepth;
            int x$28 = dT;
            int x$29 = kT;
            int x$30 = padT;
            int x$31 = Utils$.MODULE$.getOutSizeAndPadding$default$10();
            int x$32 = Utils$.MODULE$.getOutSizeAndPadding$default$11();
            int x$33 = Utils$.MODULE$.getOutSizeAndPadding$default$16();
            nArray = Utils$.MODULE$.getOutSizeAndPadding(x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$31, x$32, x$27, x$28, x$29, x$30, x$33);
        }
        int[] sizes = nArray;
        int padFront = sizes[0];
        int padBack = sizes[1];
        int padLeft = sizes[4];
        int padRight = sizes[5];
        int padTop = sizes[2];
        int padBottom = sizes[3];
        int outputDepth = sizes[6];
        int outputHeight = sizes[7];
        int outputWidth = sizes[8];
        Log4Error$.MODULE$.invalidInputError(outputWidth >= 1 && outputDepth >= 1 && outputHeight >= 1, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Given input size: (", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(input.size()).mkString("x")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Calculated output size:"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" (", "x", "x", "x", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nOutputPlane), BoxesRunTime.boxToInteger((int)outputDepth), BoxesRunTime.boxToInteger((int)outputHeight), BoxesRunTime.boxToInteger((int)outputWidth)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Output size is too small"})).s((Seq)Nil$.MODULE$)).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
        Object object = withBias && (onesBias.dim() != 1 || onesBias.size(1) != outputHeight * outputWidth * outputDepth) ? onesBias.resize(new int[]{outputHeight * outputWidth * outputDepth}, onesBias.resize$default$2()).fill(ev.one()) : BoxedUnit.UNIT;
        if (input.dim() == 4) {
            fInput.resize(kT * kW * kH * nInputPlane, outputDepth * outputHeight * outputWidth);
            output.resize(nOutputPlane, outputDepth, outputHeight, outputWidth);
            this.updateOutputFrame(input, output, weightMM, bias, fInput, kT, kW, kH, dT, dW, dH, padFront, padLeft, padTop, padBack, padRight, padBottom, nInputPlane, inputDepth, inputWidth, inputHeight, nOutputPlane, outputDepth, outputWidth, outputHeight, withBias, onesBias, ev);
        } else {
            fInput.resize(input.size(1), kT * kW * kH * nInputPlane, outputDepth * outputHeight * outputWidth);
            output.resize(input.size(1), nOutputPlane, outputDepth, outputHeight, outputWidth);
            for (int t2 = 1; t2 <= input.size(1); ++t2) {
                Tensor<T> inputT = input.select(1, t2);
                Tensor<T> outputT = output.select(1, t2);
                Tensor<T> fInputT = fInput.select(1, t2);
                this.updateOutputFrame(inputT, outputT, weightMM, bias, fInputT, kT, kW, kH, dT, dW, dH, padFront, padLeft, padTop, padBack, padRight, padBottom, nInputPlane, inputDepth, inputWidth, inputHeight, nOutputPlane, outputDepth, outputWidth, outputHeight, withBias, onesBias, ev);
            }
        }
    }

    private <T> void updateOutputFrame(Tensor<T> input, Tensor<T> output, Tensor<T> weight, Tensor<T> bias, Tensor<T> fInput, int kT, int kW, int kH, int dT, int dW, int dH, int padFront, int padLeft, int padTop, int padBack, int padRight, int padBottom, int nInputPlane, int inputDepth, int inputWidth, int inputHeight, int nOutputPlane, int outputDepth, int outputWidth, int outputHeight, boolean withBias, Tensor<T> onesBias, TensorNumericMath.TensorNumeric<T> ev) {
        Tensor<Object> output2d = output.view((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{nOutputPlane, outputDepth * outputHeight * outputWidth}));
        TensorDataType tensorDataType = ev.getType();
        if (DoubleType$.MODULE$.equals(tensorDataType)) {
            NNPrimitive$.MODULE$.unfoldedCopyVolDouble(fInput, input, kT, kW, kH, dT, dW, dH, padFront, padLeft, padTop, padBack, padRight, padBottom, nInputPlane, inputDepth, inputWidth, inputHeight, outputDepth, outputWidth, outputHeight);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (FloatType$.MODULE$.equals(tensorDataType)) {
            NNPrimitive$.MODULE$.unfoldedCopyVolFloat(fInput, input, kT, kW, kH, dT, dW, dH, padFront, padLeft, padTop, padBack, padRight, padBottom, nInputPlane, inputDepth, inputWidth, inputHeight, outputDepth, outputWidth, outputHeight);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Log4Error$.MODULE$.invalidInputError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.getType()})), "only support FloatType and DoubleType");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        output2d.addmm(ev.zero(), output2d, ev.one(), weight, fInput);
        if (withBias) {
            output2d.addr(ev.one(), bias, onesBias);
        }
    }

    public <T> void conv3DBackpropInput(int[] inputSize, Tensor<T> gradInput, Tensor<T> gradOutput, Tensor<T> weightMM, Tensor<T> fGradInput, int kT, int kW, int kH, int dT, int dW, int dH, int padT, int padW, int padH, TensorNumericMath.TensorNumeric<T> ev) {
        int[] nArray;
        int dimChannel = inputSize.length == 4 ? 1 : 2;
        int dimDepth = inputSize.length == 4 ? 2 : 3;
        int dimWidth = inputSize.length == 4 ? 4 : 5;
        int dimHeight = inputSize.length == 4 ? 3 : 4;
        int nInputPlane = inputSize[dimChannel - 1];
        int inputWidth = inputSize[dimWidth - 1];
        int inputHeight = inputSize[dimHeight - 1];
        int inputDepth = inputSize[dimDepth - 1];
        int outputDepth = gradOutput.size(dimDepth);
        int outputHeight = gradOutput.size(dimHeight);
        int outputWidth = gradOutput.size(dimWidth);
        if (padW == -1 && padH == -1 && padT == -1) {
            nArray = Utils$.MODULE$.getSAMEOutSizeAndPadding(inputHeight, inputWidth, dH, dW, kH, kW, inputDepth, dT, kT);
        } else {
            int x$34 = inputHeight;
            int x$35 = inputWidth;
            int x$36 = dH;
            int x$37 = dW;
            int x$38 = kH;
            int x$39 = kW;
            int x$40 = padH;
            int x$41 = padW;
            boolean x$42 = false;
            int x$43 = inputDepth;
            int x$44 = dT;
            int x$45 = kT;
            int x$46 = padT;
            int x$47 = Utils$.MODULE$.getOutSizeAndPadding$default$10();
            int x$48 = Utils$.MODULE$.getOutSizeAndPadding$default$11();
            int x$49 = Utils$.MODULE$.getOutSizeAndPadding$default$16();
            nArray = Utils$.MODULE$.getOutSizeAndPadding(x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$47, x$48, x$43, x$44, x$45, x$46, x$49);
        }
        int[] sizes = nArray;
        int padFront = sizes[0];
        int padBack = sizes[1];
        int padLeft = sizes[4];
        int padRight = sizes[5];
        int padTop = sizes[2];
        int padBottom = sizes[3];
        gradInput.resize(inputSize, gradInput.resize$default$2());
        if (inputSize.length == 4) {
            fGradInput.resize(kT * kW * kH * nInputPlane, outputDepth * outputHeight * outputWidth);
            Log4Error$.MODULE$.invalidInputError(gradOutput.isContiguous(), "gradOutput should be contiguous", Log4Error$.MODULE$.invalidInputError$default$3());
            this.updateGradInputFrame(gradInput, gradOutput, weightMM.transpose(1, 2), fGradInput, kT, kW, kH, dT, dW, dH, padFront, padLeft, padTop, padBack, padRight, padBottom, ev);
        } else {
            fGradInput.resize(inputSize[0], kT * kW * kH * nInputPlane, outputDepth * outputHeight * outputWidth);
            for (int t2 = 1; t2 <= inputSize[0]; ++t2) {
                Tensor<T> gradInputT = gradInput.select(1, t2);
                Tensor<T> gradOutputT = gradOutput.select(1, t2);
                Tensor<T> fGradInputT = fGradInput.select(1, t2);
                Log4Error$.MODULE$.invalidInputError(gradOutputT.isContiguous(), "each batch of gradOutput should be contiguous", Log4Error$.MODULE$.invalidInputError$default$3());
                this.updateGradInputFrame(gradInputT, gradOutputT, weightMM.transpose(1, 2), fGradInputT, kT, kW, kH, dT, dW, dH, padFront, padLeft, padTop, padBack, padRight, padBottom, ev);
            }
        }
    }

    public <T> void conv3DBackpropInput(Tensor<T> input, Tensor<T> gradInput, Tensor<T> gradOutput, Tensor<T> weightMM, Tensor<T> fGradInput, int kT, int kW, int kH, int dT, int dW, int dH, int padT, int padW, int padH, TensorNumericMath.TensorNumeric<T> ev) {
        this.conv3DBackpropInput(input.size(), gradInput, gradOutput, weightMM, fGradInput, kT, kW, kH, dT, dW, dH, padT, padW, padH, ev);
    }

    private <T> void updateGradInputFrame(Tensor<T> gradInput, Tensor<T> gradOutput, Tensor<T> weight, Tensor<T> fGradInput, int kT, int kW, int kH, int dT, int dW, int dH, int padFront, int padLeft, int padTop, int padBack, int padRight, int padBottom, TensorNumericMath.TensorNumeric<T> ev) {
        Tensor<T> gradOutput2d = gradOutput.view((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{gradOutput.size(1), gradOutput.size(2) * gradOutput.size(3) * gradOutput.size(4)}));
        fGradInput.addmm(ev.zero(), fGradInput, ev.one(), weight, gradOutput2d);
        gradInput.zero();
        TensorDataType tensorDataType = ev.getType();
        if (DoubleType$.MODULE$.equals(tensorDataType)) {
            NNPrimitive$.MODULE$.unfoldedAccVolDouble(fGradInput, gradInput, kT, kW, kH, dT, dW, dH, padFront, padLeft, padTop, padBack, padRight, padBottom, gradInput.size(1), gradInput.size(2), gradInput.size(4), gradInput.size(3), gradOutput.size(2), gradOutput.size(4), gradOutput.size(3));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (FloatType$.MODULE$.equals(tensorDataType)) {
            NNPrimitive$.MODULE$.unfoldedAccVolFloat(fGradInput, gradInput, kT, kW, kH, dT, dW, dH, padFront, padLeft, padTop, padBack, padRight, padBottom, gradInput.size(1), gradInput.size(2), gradInput.size(4), gradInput.size(3), gradOutput.size(2), gradOutput.size(4), gradOutput.size(3));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Log4Error$.MODULE$.invalidInputError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.getType()})), "only support FloatType and DoubleType");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public <T> void populateFInput(Tensor<T> input, Tensor<T> fInput, int nInputPlane, int nOutputPlane, int kT, int kW, int kH, int dT, int dW, int dH, int padT, int padW, int padH, TensorNumericMath.TensorNumeric<T> ev) {
        int[] nArray;
        int dimDepth = input.dim() == 4 ? 2 : 3;
        int dimWidth = input.dim() == 4 ? 4 : 5;
        int dimHeight = input.dim() == 4 ? 3 : 4;
        int inputWidth = input.size(dimWidth);
        int inputHeight = input.size(dimHeight);
        int inputDepth = input.size(dimDepth);
        if (padW == -1 && padH == -1 && padT == -1) {
            nArray = Utils$.MODULE$.getSAMEOutSizeAndPadding(inputHeight, inputWidth, dH, dW, kH, kW, inputDepth, dT, kT);
        } else {
            int x$50 = inputHeight;
            int x$51 = inputWidth;
            int x$52 = dH;
            int x$53 = dW;
            int x$54 = kH;
            int x$55 = kW;
            int x$56 = padH;
            int x$57 = padW;
            boolean x$58 = false;
            int x$59 = inputDepth;
            int x$60 = dT;
            int x$61 = kT;
            int x$62 = padT;
            int x$63 = Utils$.MODULE$.getOutSizeAndPadding$default$10();
            int x$64 = Utils$.MODULE$.getOutSizeAndPadding$default$11();
            int x$65 = Utils$.MODULE$.getOutSizeAndPadding$default$16();
            nArray = Utils$.MODULE$.getOutSizeAndPadding(x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$63, x$64, x$59, x$60, x$61, x$62, x$65);
        }
        int[] sizes = nArray;
        int padFront = sizes[0];
        int padBack = sizes[1];
        int padLeft = sizes[4];
        int padRight = sizes[5];
        int padTop = sizes[2];
        int padBottom = sizes[3];
        int outputDepth = sizes[6];
        int outputHeight = sizes[7];
        int outputWidth = sizes[8];
        Log4Error$.MODULE$.invalidInputError(outputWidth >= 1 && outputDepth >= 1 && outputHeight >= 1, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Given input size: (", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(input.size()).mkString("x")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Calculated output size:"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" (", "x", "x", "x", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nOutputPlane), BoxesRunTime.boxToInteger((int)outputDepth), BoxesRunTime.boxToInteger((int)outputHeight), BoxesRunTime.boxToInteger((int)outputWidth)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Output size is too small"})).s((Seq)Nil$.MODULE$)).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
        if (input.dim() == 4) {
            fInput.resize(kT * kW * kH * nInputPlane, outputDepth * outputHeight * outputWidth);
            this.im2colWrapper(input, fInput, kT, kW, kH, dT, dW, dH, padFront, padLeft, padTop, padBack, padRight, padBottom, nInputPlane, inputDepth, inputWidth, inputHeight, nOutputPlane, outputDepth, outputWidth, outputHeight, ev);
        } else {
            fInput.resize(input.size(1), kT * kW * kH * nInputPlane, outputDepth * outputHeight * outputWidth);
            for (int t2 = 1; t2 <= input.size(1); ++t2) {
                Tensor<T> inputT = input.select(1, t2);
                Tensor<T> fInputT = fInput.select(1, t2);
                this.im2colWrapper(inputT, fInputT, kT, kW, kH, dT, dW, dH, padFront, padLeft, padTop, padBack, padRight, padBottom, nInputPlane, inputDepth, inputWidth, inputHeight, nOutputPlane, outputDepth, outputWidth, outputHeight, ev);
            }
        }
    }

    private <T> void im2colWrapper(Tensor<T> input, Tensor<T> fInput, int kT, int kW, int kH, int dT, int dW, int dH, int padFront, int padLeft, int padTop, int padBack, int padRight, int padBottom, int nInputPlane, int inputDepth, int inputWidth, int inputHeight, int nOutputPlane, int outputDepth, int outputWidth, int outputHeight, TensorNumericMath.TensorNumeric<T> ev) {
        TensorDataType tensorDataType = ev.getType();
        if (DoubleType$.MODULE$.equals(tensorDataType)) {
            NNPrimitive$.MODULE$.unfoldedCopyVolDouble(fInput, input, kT, kW, kH, dT, dW, dH, padFront, padLeft, padTop, padBack, padRight, padBottom, nInputPlane, inputDepth, inputWidth, inputHeight, outputDepth, outputWidth, outputHeight);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (FloatType$.MODULE$.equals(tensorDataType)) {
            NNPrimitive$.MODULE$.unfoldedCopyVolFloat(fInput, input, kT, kW, kH, dT, dW, dH, padFront, padLeft, padTop, padBack, padRight, padBottom, nInputPlane, inputDepth, inputWidth, inputHeight, outputDepth, outputWidth, outputHeight);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Log4Error$.MODULE$.invalidInputError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.getType()})), "only support FloatType and DoubleType");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public <T> void conv3DBackpropFilter(Tensor<T> input, Tensor<T> gradOutput, Tensor<T> gradWeightMM, Tensor<T> gradBias, Tensor<T> fInput, double scaleW, double scaleB, boolean withBias, TensorNumericMath.TensorNumeric<T> ev) {
        if (input.dim() == 4) {
            this.accGradParametersFrame(gradOutput, gradWeightMM, gradBias, fInput, ev.fromType(BoxesRunTime.boxToDouble((double)scaleW), ConvertableFrom$ConvertableFromDouble$.MODULE$), ev.fromType(BoxesRunTime.boxToDouble((double)scaleB), ConvertableFrom$ConvertableFromDouble$.MODULE$), withBias, ev);
        } else {
            for (int t2 = 1; t2 <= input.size(1); ++t2) {
                Tensor<T> gradOutputT = gradOutput.select(1, t2);
                Tensor<T> fInputT = fInput.select(1, t2);
                this.accGradParametersFrame(gradOutputT, gradWeightMM, gradBias, fInputT, ev.fromType(BoxesRunTime.boxToDouble((double)scaleW), ConvertableFrom$ConvertableFromDouble$.MODULE$), ev.fromType(BoxesRunTime.boxToDouble((double)scaleB), ConvertableFrom$ConvertableFromDouble$.MODULE$), withBias, ev);
            }
        }
    }

    private <T> void accGradParametersFrame(Tensor<T> gradOutput, Tensor<T> gradWeight, Tensor<T> gradBias, Tensor<T> fInput, T scaleW, T scaleB, boolean withBias, TensorNumericMath.TensorNumeric<T> ev) {
        Tensor<T> gradOutput2d = gradOutput.view((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{gradOutput.size(1), gradOutput.size(2) * gradOutput.size(3) * gradOutput.size(4)}));
        Tensor<T> fInputT = fInput.transpose(1, 2);
        Object object = BoxesRunTime.equals(scaleW, (Object)BoxesRunTime.boxToInteger((int)0)) ? BoxedUnit.UNIT : gradWeight.addmm(ev.one(), gradWeight, scaleW, gradOutput2d, fInputT);
        if (withBias && !BoxesRunTime.equals(scaleB, (Object)BoxesRunTime.boxToInteger((int)0))) {
            for (int i = 0; i < gradBias.size(1); ++i) {
                Object sum2 = ev.zero();
                Object data2 = gradOutput2d.storage().array();
                int offset = gradOutput2d.storageOffset() - 1 + i * gradOutput2d.stride(1);
                for (int k = 0; k < gradOutput2d.size(2); ++k) {
                    sum2 = ev.plus(sum2, ScalaRunTime$.MODULE$.array_apply(data2, k + offset));
                }
                gradBias.setValue(i + 1, ev.plus(gradBias.valueAt(i + 1), ev.times(scaleB, sum2)));
            }
        }
    }

    public <T> int $lessinit$greater$default$6() {
        return 1;
    }

    public <T> int $lessinit$greater$default$7() {
        return 1;
    }

    public <T> int $lessinit$greater$default$8() {
        return 1;
    }

    public <T> int $lessinit$greater$default$9() {
        return 0;
    }

    public <T> int $lessinit$greater$default$10() {
        return 0;
    }

    public <T> int $lessinit$greater$default$11() {
        return 0;
    }

    public <T> boolean $lessinit$greater$default$12() {
        return true;
    }

    public <T> Null$ $lessinit$greater$default$13() {
        return null;
    }

    public <T> Null$ $lessinit$greater$default$14() {
        return null;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public VolumetricConvolution<Object> apply$mDc$sp(int nInputPlane, int nOutputPlane, int kT, int kW, int kH, int dT, int dW, int dH, int padT, int padW, int padH, boolean withBias, Regularizer<Object> wRegularizer, Regularizer<Object> bRegularizer, ClassTag<Object> evidence$2, TensorNumericMath.TensorNumeric<Object> ev) {
        return new VolumetricConvolution<Object>(nInputPlane, nOutputPlane, kT, kW, kH, dT, dW, dH, padT, padW, padH, withBias, wRegularizer, bRegularizer, evidence$2, ev);
    }

    public VolumetricConvolution<Object> apply$mFc$sp(int nInputPlane, int nOutputPlane, int kT, int kW, int kH, int dT, int dW, int dH, int padT, int padW, int padH, boolean withBias, Regularizer<Object> wRegularizer, Regularizer<Object> bRegularizer, ClassTag<Object> evidence$2, TensorNumericMath.TensorNumeric<Object> ev) {
        return new VolumetricConvolution<Object>(nInputPlane, nOutputPlane, kT, kW, kH, dT, dW, dH, padT, padW, padH, withBias, wRegularizer, bRegularizer, evidence$2, ev);
    }

    private VolumetricConvolution$() {
        MODULE$ = this;
    }
}

