/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.nn;

import com.intel.analytics.bigdl.dllib.nn.Container;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.AbstractModule;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.Activity;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.DataFormat;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.DataFormat$NCHW$;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.DataFormat$NHWC$;
import com.intel.analytics.bigdl.dllib.tensor.ConvertableFrom$ConvertableFromDouble$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.T$;
import com.intel.analytics.bigdl.dllib.utils.Table;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class Utils$ {
    public static final Utils$ MODULE$;

    static {
        new Utils$();
    }

    public <T> Table zeroTableCopy(Table t1, Table t2, ClassTag<T> evidence$1, TensorNumericMath.TensorNumeric<T> ev) {
        t2.foreach(new Serializable(t1, t2, evidence$1, ev){
            public static final long serialVersionUID = 0L;
            private final Table t1$1;
            private final Table t2$1;
            private final ClassTag evidence$1$1;
            private final TensorNumericMath.TensorNumeric ev$3;

            public final Activity apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    if (k instanceof Object) {
                        Object object = k;
                        if (v instanceof Object) {
                            Activity activity;
                            Object object2 = v;
                            if (object2 instanceof Table) {
                                activity = this.t1$1.update(object, Utils$.MODULE$.zeroTableCopy(this.t1$1.contains(object) ? (Table)this.t1$1.apply(object) : T$.MODULE$.apply(), (Table)this.t2$1.apply(object), this.evidence$1$1, this.ev$3));
                            } else {
                                Log4Error$.MODULE$.invalidInputError(object2 instanceof Tensor, "Input can only consist of Tensor or Table", Log4Error$.MODULE$.invalidInputError$default$3());
                                Tensor tensorV = (Tensor)object2;
                                if (this.t1$1.contains(object)) {
                                    ((Tensor)this.t1$1.apply(object)).resizeAs(tensorV);
                                    activity = ((Tensor)this.t1$1.apply(object)).zero();
                                } else {
                                    activity = this.t1$1.update(object, tensorV.clone().zero());
                                }
                            }
                            Table table = activity;
                            return table;
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.t1$1 = t1$1;
                this.t2$1 = t2$1;
                this.evidence$1$1 = evidence$1$1;
                this.ev$3 = ev$3;
            }
        });
        t1.foreach(new Serializable(t1, t2){
            public static final long serialVersionUID = 0L;
            private final Table t1$1;
            private final Table t2$1;

            public final Object apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    if (k instanceof Object) {
                        Object object = k;
                        if (v instanceof Object) {
                            BoxedUnit boxedUnit = this.t2$1.contains(object) ? BoxedUnit.UNIT : this.t1$1.update(object, null);
                            return boxedUnit;
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.t1$1 = t1$1;
                this.t2$1 = t2$1;
            }
        });
        return t1;
    }

    public <T> Activity recursiveResizeAs(Activity target, Activity src, ClassTag<T> evidence$2, TensorNumericMath.TensorNumeric<T> ev) {
        Object object;
        Activity result2 = null;
        if (src instanceof Table) {
            int i;
            Table srcTable = src.toTable();
            result2 = target == null ? T$.MODULE$.apply() : (target instanceof Tensor ? T$.MODULE$.apply(target, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0])) : target);
            Table resultTable = result2.toTable();
            for (i = 1; i <= src.toTable().length(); ++i) {
                Table table = resultTable.contains(BoxesRunTime.boxToInteger((int)i)) ? resultTable.update(BoxesRunTime.boxToInteger((int)i), this.recursiveResizeAs((Activity)resultTable.apply(BoxesRunTime.boxToInteger((int)i)), (Activity)srcTable.apply(BoxesRunTime.boxToInteger((int)i)), evidence$2, ev)) : resultTable.update(BoxesRunTime.boxToInteger((int)i), this.recursiveResizeAs(null, (Activity)srcTable.apply(BoxesRunTime.boxToInteger((int)i)), evidence$2, ev));
            }
            while (i <= resultTable.length()) {
                resultTable.remove(i);
                ++i;
            }
            object = BoxedUnit.UNIT;
        } else if (src instanceof Tensor) {
            result2 = target instanceof Tensor ? target : Tensor$.MODULE$.apply(evidence$2, ev);
            object = result2.toTensor(ev).resizeAs(src.toTensor(ev));
        } else {
            object = BoxedUnit.UNIT;
        }
        return result2;
    }

    public <T> void recursiveTensorApply1(Activity x, Function1<Tensor<T>, Tensor<T>> func, TensorNumericMath.TensorNumeric<T> ev) {
        Log4Error$.MODULE$.invalidInputError(x instanceof Activity, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expecting tensors or tables thereof. Got ", " instead"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x})), Log4Error$.MODULE$.invalidInputError$default$3());
        if (x instanceof Table) {
            for (int i = 1; i <= x.toTable().length(); ++i) {
                this.recursiveTensorApply1((Activity)x.toTable().apply(BoxesRunTime.boxToInteger((int)i)), func, ev);
            }
        } else {
            func.apply(x.toTensor(ev));
        }
    }

    public <T> Activity recursiveTensorApply2(Activity x, Activity y, Function2<Tensor<T>, Tensor<T>, Tensor<T>> func, TensorNumericMath.TensorNumeric<T> ev) {
        Object object;
        if (y instanceof Tensor && x instanceof Tensor) {
            Log4Error$.MODULE$.invalidInputError(x.toTensor(ev).nElement() == y.toTensor(ev).nElement(), new StringBuilder().append((Object)"x, y should have the same size").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x size ", ", y size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.toTensor(ev).nElement()), BoxesRunTime.boxToInteger((int)y.toTensor(ev).nElement())}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
            object = func.apply(x.toTensor(ev), y.toTensor(ev));
        } else {
            Log4Error$.MODULE$.invalidInputError(x instanceof Table && y instanceof Table, "x, y should have the same size", Log4Error$.MODULE$.invalidInputError$default$3());
            Log4Error$.MODULE$.invalidInputError(x.toTable().length() == y.toTable().length(), new StringBuilder().append((Object)"x, y should have the same size").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x size ", ", y size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.toTable().length()), BoxesRunTime.boxToInteger((int)y.toTable().length())}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
            for (int i = 1; i <= x.toTable().length(); ++i) {
                this.recursiveTensorApply2((Activity)x.toTable().apply(BoxesRunTime.boxToInteger((int)i)), (Activity)y.toTable().apply(BoxesRunTime.boxToInteger((int)i)), func, ev);
            }
            object = BoxedUnit.UNIT;
        }
        return x;
    }

    public <T> Activity recursiveAdd(Activity y, double alpha, Activity x, TensorNumericMath.TensorNumeric<T> ev) {
        this.recursiveTensorApply2(y, x, (Function2<Tensor<T>, Tensor<T>, Tensor<T>>)new Serializable(alpha, ev){
            public static final long serialVersionUID = 0L;
            private final double alpha$1;
            private final TensorNumericMath.TensorNumeric ev$2;

            public final Tensor<T> apply(Tensor<T> t1, Tensor<T> t2) {
                return t1.add(this.ev$2.fromType(BoxesRunTime.boxToDouble((double)this.alpha$1), ConvertableFrom$ConvertableFromDouble$.MODULE$), t2);
            }
            {
                this.alpha$1 = alpha$1;
                this.ev$2 = ev$2;
            }
        }, ev);
        return y;
    }

    public <T> double recursiveAdd$default$2() {
        return 1.0;
    }

    public <T> Activity recursiveCopy(Activity y, Activity x, TensorNumericMath.TensorNumeric<T> ev) {
        this.recursiveTensorApply2(y, x, (Function2<Tensor<T>, Tensor<T>, Tensor<T>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tensor<T> apply(Tensor<T> t1, Tensor<T> t2) {
                return t1.copy(t2);
            }
        }, ev);
        return y;
    }

    public <T> void recursiveFill(Activity x, double value2, TensorNumericMath.TensorNumeric<T> ev) {
        this.recursiveTensorApply1(x, (Function1<Tensor<T>, Tensor<T>>)new Serializable(value2, ev){
            public static final long serialVersionUID = 0L;
            private final double value$1;
            private final TensorNumericMath.TensorNumeric ev$1;

            public final Tensor<T> apply(Tensor<T> t2) {
                return t2.fill(this.ev$1.fromType(BoxesRunTime.boxToDouble((double)this.value$1), ConvertableFrom$ConvertableFromDouble$.MODULE$));
            }
            {
                this.value$1 = value$1;
                this.ev$1 = ev$1;
            }
        }, ev);
    }

    public <T> Map<String, AbstractModule<Activity, Activity, T>> getNamedModules(AbstractModule<Activity, Activity, T> model) {
        ObjectRef namedModules = ObjectRef.create((Object)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        this.com$intel$analytics$bigdl$dllib$nn$Utils$$getModules$1(model, namedModules);
        return (Map)namedModules.elem;
    }

    public <T> AbstractModule<Activity, Activity, T> copyModule(AbstractModule<Activity, Activity, T> src, AbstractModule<Activity, Activity, T> dst) {
        Tensor srcParameters = (Tensor)src.getParameters()._1();
        Tensor dstParameters = (Tensor)dst.getParameters()._1();
        Log4Error$.MODULE$.invalidInputError(srcParameters.size(1) == dstParameters.size(1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " and ", " is not the same type."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{src, dst})), Log4Error$.MODULE$.invalidInputError$default$3());
        dstParameters.copy(srcParameters);
        dst.setExtraParameter(src.getExtraParameter());
        return dst;
    }

    public <T> boolean isLayerwiseScaled(AbstractModule<Activity, Activity, T> model) {
        AbstractModule<Activity, Activity, T> abstractModule;
        block5: {
            boolean bl;
            block4: {
                block3: {
                    abstractModule = model;
                    if (!(abstractModule instanceof Container)) break block3;
                    Container container = (Container)abstractModule;
                    for (int i = 0; i < container.modules().length(); ++i) {
                        if (!this.isLayerwiseScaled((AbstractModule)container.modules().apply(i))) continue;
                        return true;
                    }
                    bl = false;
                    break block4;
                }
                if (abstractModule == null) break block5;
                AbstractModule<Activity, Activity, T> abstractModule2 = abstractModule;
                bl = abstractModule2.getScaleB() != 1.0 || abstractModule2.getScaleW() != 1.0;
            }
            return bl;
        }
        throw new MatchError(abstractModule);
    }

    public <T> Tuple2<Object, Object> getInnerOuterNum(int pivotDim, Tensor<T> data2) {
        int k;
        int outerNum = 1;
        for (k = 1; k < pivotDim; ++k) {
            outerNum *= data2.size(k);
        }
        int innerNum = 1;
        for (k = pivotDim + 1; k <= data2.dim(); ++k) {
            innerNum *= data2.size(k);
        }
        return new Tuple2.mcII.sp(innerNum, outerNum);
    }

    public int getOnlyDimGtOne(int[] size) {
        int count2 = 0;
        int pivot = 0;
        for (int i = 0; i < size.length; ++i) {
            if (size[i] <= 1) continue;
            ++count2;
            pivot = i + 1;
        }
        return count2 == 1 ? pivot : -1;
    }

    public int[] getSAMEOutSizeAndPadding(int inputHeight, int inputWidth, int dH, int dW, int kH, int kW, int inputDepth, int dT, int kT) {
        int oW = (int)Math.ceil((float)inputWidth / (float)dW);
        int oH = (int)Math.ceil((float)inputHeight / (float)dH);
        int padAlongWidth = Math.max(0, (oW - 1) * dW + kW - inputWidth);
        int padAlongHeight = Math.max(0, (oH - 1) * dH + kH - inputHeight);
        if (inputDepth != -1) {
            Log4Error$.MODULE$.invalidInputError(dT > 0 && kT > 0, "kernel size and strideSize cannot be smaller than 0", Log4Error$.MODULE$.invalidInputError$default$3());
            int oT = (int)Math.ceil((float)inputDepth / (float)dT);
            int padAlongDepth = Math.max(0, (oT - 1) * dT + kT - inputDepth);
            return new int[]{padAlongDepth / 2, padAlongDepth - padAlongDepth / 2, padAlongHeight / 2, padAlongHeight - padAlongHeight / 2, padAlongWidth / 2, padAlongWidth - padAlongWidth / 2, oT, oH, oW};
        }
        return new int[]{padAlongHeight / 2, padAlongHeight - padAlongHeight / 2, padAlongWidth / 2, padAlongWidth - padAlongWidth / 2, oH, oW};
    }

    public int getSAMEOutSizeAndPadding$default$7() {
        return -1;
    }

    public int getSAMEOutSizeAndPadding$default$8() {
        return -1;
    }

    public int getSAMEOutSizeAndPadding$default$9() {
        return -1;
    }

    public int[] getOutSizeAndPadding(int inputHeight, int inputWidth, int dH, int dW, int kH, int kW, int padH, int padW, boolean ceilMode, int dilationHeight, int dilationWidth, int inputdepth, int dt, int kt, int padt, int dilationDepth) {
        int dilationKernelDepth;
        int oheight = 0;
        int owidth = 0;
        int odepth = 0;
        int dilationKernelHeight = dilationHeight * (kH - 1) + 1;
        int dilationKernelWidth = dilationWidth * (kW - 1) + 1;
        int n = dilationKernelDepth = inputdepth > 0 ? dilationDepth * (kt - 1) + 1 : kt;
        if (ceilMode) {
            oheight = (int)package$.MODULE$.ceil(1.0 * (double)(inputHeight - dilationKernelHeight + 2 * padH) / (double)dH) + 1;
            owidth = (int)package$.MODULE$.ceil(1.0 * (double)(inputWidth - dilationKernelWidth + 2 * padW) / (double)dW) + 1;
            if (inputdepth > 0) {
                Log4Error$.MODULE$.invalidInputError(dt > 0 && kt > 0 && padt >= 0, "kernel size, stride size, padding size cannot be smaller than 0", Log4Error$.MODULE$.invalidInputError$default$3());
                odepth = (int)package$.MODULE$.ceil(1.0 * (double)(inputdepth - dilationKernelDepth + 2 * padt) / (double)dt) + 1;
            }
        } else {
            oheight = (int)package$.MODULE$.floor(1.0 * (double)(inputHeight - dilationKernelHeight + 2 * padH) / (double)dH) + 1;
            owidth = (int)package$.MODULE$.floor(1.0 * (double)(inputWidth - dilationKernelWidth + 2 * padW) / (double)dW) + 1;
            if (inputdepth > 0) {
                Log4Error$.MODULE$.invalidInputError(dt > 0 && kt > 0 && padt >= 0, "kernel size, stride size, padding size cannot be smaller than 0", Log4Error$.MODULE$.invalidInputError$default$3());
                odepth = (int)package$.MODULE$.floor(1.0 * (double)(inputdepth - dilationKernelDepth + 2 * padt) / (double)dt) + 1;
            }
        }
        if (padH != 0 || padW != 0 || padt != 0) {
            if ((oheight - 1) * dH >= inputHeight + padH) {
                --oheight;
            }
            if ((owidth - 1) * dW >= inputWidth + padW) {
                --owidth;
            }
            if (inputdepth > 0) {
                if ((odepth - 1) * dt >= inputdepth + padt) {
                    // empty if block
                }
                return new int[]{padt, padt, padH, padH, padW, padW, --odepth, oheight, owidth};
            }
        } else if (inputdepth > 0) {
            return new int[]{padt, padt, padH, padH, padW, padW, odepth, oheight, owidth};
        }
        return new int[]{padH, padH, padW, padW, oheight, owidth};
    }

    public int getOutSizeAndPadding$default$10() {
        return 1;
    }

    public int getOutSizeAndPadding$default$11() {
        return 1;
    }

    public int getOutSizeAndPadding$default$12() {
        return -1;
    }

    public int getOutSizeAndPadding$default$13() {
        return -1;
    }

    public int getOutSizeAndPadding$default$14() {
        return -1;
    }

    public int getOutSizeAndPadding$default$15() {
        return 0;
    }

    public int getOutSizeAndPadding$default$16() {
        return 1;
    }

    public int[] getOutSizeAndPaddingForDNN(int inputHeight, int inputWidth, int dH, int dW, int kH, int kW, int padH, int padW, boolean ceilMode, int dilationHeight, int dilationWidth, int inputdepth, int dt, int kt, int padt, int dilationDepth) {
        int pad_t = padH;
        int pad_b = padH;
        int pad_l = padW;
        int pad_r = padW;
        int oheight = 0;
        int owidth = 0;
        boolean odepth = false;
        int dilationKernelHeight = dilationHeight * (kH - 1) + 1;
        int dilationKernelWidth = dilationWidth * (kW - 1) + 1;
        oheight = (int)package$.MODULE$.ceil(1.0 * (double)(inputHeight - dilationKernelHeight + 2 * padH) / (double)dH) + 1;
        owidth = (int)package$.MODULE$.ceil(1.0 * (double)(inputWidth - dilationKernelWidth + 2 * padW) / (double)dW) + 1;
        if (padH != 0 || padW != 0 || padt != 0 || kH == 1 || kW == 1) {
            if ((oheight - 1) * dH >= inputHeight + padH) {
                --oheight;
            }
            if ((owidth - 1) * dW >= inputWidth + padW) {
                --owidth;
            }
        }
        int h2 = inputHeight + pad_t;
        while (h2 + pad_b < dH * (oheight - 1) + kH) {
            ++pad_b;
        }
        int w = inputWidth + pad_l;
        while (w + pad_r < dW * (owidth - 1) + kW) {
            ++pad_r;
        }
        return new int[]{pad_t, pad_b, pad_l, pad_r, oheight, owidth};
    }

    public int getOutSizeAndPaddingForDNN$default$10() {
        return 1;
    }

    public int getOutSizeAndPaddingForDNN$default$11() {
        return 1;
    }

    public int getOutSizeAndPaddingForDNN$default$12() {
        return -1;
    }

    public int getOutSizeAndPaddingForDNN$default$13() {
        return -1;
    }

    public int getOutSizeAndPaddingForDNN$default$14() {
        return -1;
    }

    public int getOutSizeAndPaddingForDNN$default$15() {
        return 0;
    }

    public int getOutSizeAndPaddingForDNN$default$16() {
        return 1;
    }

    public int[] getOutputShape(int outputHeight, int outputWidth, int nOutputPlane, int batchSize, DataFormat format2) {
        DataFormat dataFormat;
        block9: {
            int[] nArray;
            block8: {
                int[] nArray2;
                block7: {
                    int[] nArray3;
                    dataFormat = format2;
                    if (!DataFormat$NCHW$.MODULE$.equals(dataFormat)) break block7;
                    if (batchSize == -1) {
                        int[] nArray4 = new int[3];
                        nArray4[0] = nOutputPlane;
                        nArray4[1] = outputHeight;
                        nArray3 = nArray4;
                        nArray4[2] = outputWidth;
                    } else {
                        int[] nArray5 = new int[4];
                        nArray5[0] = batchSize;
                        nArray5[1] = nOutputPlane;
                        nArray5[2] = outputHeight;
                        nArray3 = nArray5;
                        nArray5[3] = outputWidth;
                    }
                    nArray = nArray3;
                    break block8;
                }
                if (!DataFormat$NHWC$.MODULE$.equals(dataFormat)) break block9;
                if (batchSize == -1) {
                    int[] nArray6 = new int[3];
                    nArray6[0] = outputHeight;
                    nArray6[1] = outputWidth;
                    nArray2 = nArray6;
                    nArray6[2] = nOutputPlane;
                } else {
                    int[] nArray7 = new int[4];
                    nArray7[0] = batchSize;
                    nArray7[1] = outputHeight;
                    nArray7[2] = outputWidth;
                    nArray2 = nArray7;
                    nArray7[3] = nOutputPlane;
                }
                nArray = nArray2;
            }
            return nArray;
        }
        throw new MatchError((Object)dataFormat);
    }

    public int getOutputShape$default$4() {
        return -1;
    }

    public Tuple3<Object, Object, Object> getOutputSize(int inputSize, int filterSize, int stride, String padding) {
        String string;
        block4: {
            Tuple3 tuple3;
            block3: {
                block2: {
                    string = padding.toLowerCase();
                    if (!"valid".equals(string)) break block2;
                    int outputSize = (inputSize - filterSize + stride) / stride;
                    tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)outputSize), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0));
                    break block3;
                }
                if (!"same".equals(string)) break block4;
                int outputSize = (inputSize + stride - 1) / stride;
                int paddingNeeded = package$.MODULE$.max(0, (outputSize - 1) * stride + filterSize - inputSize);
                int padBefore = paddingNeeded / 2;
                int padAfter = paddingNeeded - padBefore;
                tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)outputSize), (Object)BoxesRunTime.boxToInteger((int)padBefore), (Object)BoxesRunTime.boxToInteger((int)padAfter));
            }
            return tuple3;
        }
        throw new MatchError((Object)string);
    }

    public <T> Tensor<T> shuffle(Tensor<T> src, int[] permutation, Tensor<T> buffer, ClassTag<T> evidence$3, TensorNumericMath.TensorNumeric<T> ev) {
        int i;
        Log4Error$.MODULE$.invalidInputError(permutation.length == src.nDimension(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"permutation length should be same as tensor dimension"})).s((Seq)Nil$.MODULE$), Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(permutation).min((Ordering)Ordering.Int$.MODULE$)) >= 0 && BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(permutation).max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(src.size()).max((Ordering)Ordering.Int$.MODULE$)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"permutation min value should be between 0 and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(src.size()).max((Ordering)Ordering.Int$.MODULE$)})), Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(permutation).distinct()).size() == src.nDimension(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"permutation has duplicated input"})).s((Seq)Nil$.MODULE$), Log4Error$.MODULE$.invalidInputError$default$3());
        int[] outSize = new int[src.nDimension()];
        for (i = 0; i < permutation.length; ++i) {
            outSize[i] = src.size(permutation[i]);
        }
        Tensor<T> out = buffer == null ? Tensor$.MODULE$.apply(evidence$3, ev) : buffer;
        out.resize(outSize, out.resize$default$2());
        int numOfElements = src.nElement();
        for (i = 0; i < numOfElements; ++i) {
            int srcIndex = 0;
            int tmp = i;
            for (int j = 1; j <= src.nDimension(); ++j) {
                int curDim = tmp / out.stride(j);
                tmp %= out.stride(j);
                srcIndex += curDim * src.stride(permutation[j - 1]);
            }
            ScalaRunTime$.MODULE$.array_update(out.storage().array(), i, ScalaRunTime$.MODULE$.array_apply(src.storage().array(), srcIndex));
        }
        return out;
    }

    public <T> Null$ shuffle$default$3() {
        return null;
    }

    public Tuple6<Object, Object, Object, Object, Object, Object> getPaddingAndOutputSize(int inputHeight, int inputWidth, int dH, int dW, int kH, int kW, int padH, int padW, boolean ceilMode) {
        int pad_t = padH;
        int pad_b = padH;
        int pad_l = padW;
        int pad_r = padW;
        int oheight = 0;
        int owidth = 0;
        boolean odepth = false;
        if (ceilMode) {
            oheight = (int)package$.MODULE$.ceil(1.0 * (double)(inputHeight - kH + 2 * padH) / (double)dH) + 1;
            owidth = (int)package$.MODULE$.ceil(1.0 * (double)(inputWidth - kW + 2 * padW) / (double)dW) + 1;
        } else {
            oheight = (int)package$.MODULE$.floor(1.0 * (double)(inputHeight - kH + 2 * padH) / (double)dH) + 1;
            owidth = (int)package$.MODULE$.floor(1.0 * (double)(inputWidth - kW + 2 * padW) / (double)dW) + 1;
        }
        if (padH != 0 || padW != 0 || kH == 1 || kW == 1) {
            if ((oheight - 1) * dH >= inputHeight + padH) {
                --oheight;
            }
            if ((owidth - 1) * dW >= inputWidth + padW) {
                --owidth;
            }
        }
        int h2 = inputHeight + pad_t;
        while (h2 + pad_b < dH * (oheight - 1) + kH) {
            ++pad_b;
        }
        int w = inputWidth + pad_l;
        while (w + pad_r < dW * (owidth - 1) + kW) {
            ++pad_r;
        }
        return new Tuple6((Object)BoxesRunTime.boxToInteger((int)pad_t), (Object)BoxesRunTime.boxToInteger((int)pad_b), (Object)BoxesRunTime.boxToInteger((int)pad_l), (Object)BoxesRunTime.boxToInteger((int)pad_r), (Object)BoxesRunTime.boxToInteger((int)oheight), (Object)BoxesRunTime.boxToInteger((int)owidth));
    }

    public boolean getPaddingAndOutputSize$default$9() {
        return false;
    }

    public <T> Tuple2<Object, Object> calculateFwdBwdTime(Tuple3<AbstractModule<? extends Activity, ? extends Activity, T>, Object, Object>[] times, ClassTag<T> evidence$4) {
        return (Tuple2)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])times).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple3<AbstractModule<? extends Activity, ? extends Activity, T>, Object, Object> t2) {
                return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)t2._2()), BoxesRunTime.unboxToLong((Object)t2._3()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> a, Tuple2<Object, Object> b) {
                return new Tuple2.mcJJ.sp(a._1$mcJ$sp() + b._1$mcJ$sp(), a._2$mcJ$sp() + b._2$mcJ$sp());
            }
        });
    }

    public float[] calcScales(Tensor<Object> tensor, int mask) {
        Log4Error$.MODULE$.invalidInputError(RichInt$.MODULE$.toBinaryString$extension(Predef$.MODULE$.intWrapper(mask)).length() <= tensor.size().length, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.maskInterval$1(tensor)})), Log4Error$.MODULE$.invalidInputError$default$3());
        ListBuffer result2 = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.com$intel$analytics$bigdl$dllib$nn$Utils$$calcScalesHelper$1(tensor, (String)new StringOps(Predef$.MODULE$.augmentString(RichInt$.MODULE$.toBinaryString$extension(Predef$.MODULE$.intWrapper(mask)))).reverse(), result2, 0);
        return (float[])result2.toArray(ClassTag$.MODULE$.Float());
    }

    public final void com$intel$analytics$bigdl$dllib$nn$Utils$$getModules$1(AbstractModule module, ObjectRef namedModules$1) {
        AbstractModule abstractModule = module;
        if (abstractModule instanceof Container) {
            namedModules$1.elem = ((Map)namedModules$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)module.getName()), (Object)module));
            ((Container)module).modules().foreach((Function1)new Serializable(namedModules$1){
                public static final long serialVersionUID = 0L;
                private final ObjectRef namedModules$1;

                public final void apply(AbstractModule<Activity, Activity, T> m3) {
                    Utils$.MODULE$.com$intel$analytics$bigdl$dllib$nn$Utils$$getModules$1(m3, this.namedModules$1);
                }
                {
                    this.namedModules$1 = namedModules$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            namedModules$1.elem = ((Map)namedModules$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)module.getName()), (Object)module));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public final void com$intel$analytics$bigdl$dllib$nn$Utils$$calcScalesHelper$1(Tensor tensor, String maskStr, ListBuffer result2, int index) {
        block2: {
            BoxedUnit boxedUnit;
            while (index < maskStr.length()) {
                if (RichChar$.MODULE$.asDigit$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(maskStr), index))) == 1) {
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), tensor.size(index + 1)).foreach$mVc$sp((Function1)new Serializable(tensor, maskStr, result2, index){
                        public static final long serialVersionUID = 0L;
                        private final Tensor tensor$2;
                        private final String maskStr$1;
                        private final ListBuffer result$1;
                        private final int index$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            Utils$.MODULE$.com$intel$analytics$bigdl$dllib$nn$Utils$$calcScalesHelper$1(this.tensor$2.narrow(this.index$1 + 1, i, 1), this.maskStr$1, this.result$1, this.index$1 + 1);
                        }
                        {
                            this.tensor$2 = tensor$2;
                            this.maskStr$1 = maskStr$1;
                            this.result$1 = result$1;
                            this.index$1 = index$1;
                        }
                    });
                    boxedUnit = BoxedUnit.UNIT;
                    break block2;
                }
                ++index;
            }
            result2.append((Seq)Predef$.MODULE$.wrapFloatArray(new float[]{BoxesRunTime.unboxToFloat(tensor.clone().abs().max())}));
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final String maskInterval$1(Tensor tensor$1) {
        int start2 = 0;
        int end = (int)(package$.MODULE$.pow(2.0, (double)tensor$1.size().length) - 1.0);
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mask should between [", ", ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)start2), BoxesRunTime.boxToInteger((int)end)}));
    }

    private Utils$() {
        MODULE$ = this;
    }
}

