/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.nn;

import com.intel.analytics.bigdl.dllib.nn.UpSampling2D;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.DataFormat;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.DataFormat$NCHW$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import scala.Serializable;
import scala.reflect.ClassTag;
import scala.runtime.ScalaRunTime$;

public final class UpSampling2D$
implements Serializable {
    public static final UpSampling2D$ MODULE$;

    static {
        new UpSampling2D$();
    }

    public <T> UpSampling2D<T> apply(int[] size, DataFormat format2, ClassTag<T> evidence$2, TensorNumericMath.TensorNumeric<T> ev) {
        return new UpSampling2D<T>(size, format2, evidence$2, ev);
    }

    public <T> DataFormat apply$default$2() {
        return DataFormat$NCHW$.MODULE$;
    }

    public <T> Tensor<T> updateOutputNchw(Tensor<T> input, Tensor<T> output, int[] size, ClassTag<T> evidence$3, TensorNumericMath.TensorNumeric<T> ev) {
        int inputHeight = input.size(3);
        int inputWeight = input.size(4);
        int outputHeight = inputHeight * size[0];
        int outputWeight = inputWeight * size[1];
        output.resize(input.size(1), input.size(2), outputHeight, outputWeight);
        Object inputData = input.storage().array();
        int inputOffset = input.storageOffset() - 1;
        Object outputData = output.storage().array();
        int outputOffset = output.storageOffset() - 1;
        for (int i = 0; i < input.size(1) * input.size(2); ++i) {
            for (int rowIndex = 0; rowIndex < input.size(3); ++rowIndex) {
                for (int columnIndex = 0; columnIndex < input.size(4); ++columnIndex) {
                    for (int colReplicate = 0; colReplicate < size[1]; ++colReplicate) {
                        ScalaRunTime$.MODULE$.array_update(outputData, outputOffset, ScalaRunTime$.MODULE$.array_apply(inputData, inputOffset));
                        ++outputOffset;
                    }
                    ++inputOffset;
                }
                for (int rowReplicate = 1; rowReplicate < size[0]; ++rowReplicate) {
                    ev.arraycopy(outputData, outputOffset - outputWeight, outputData, outputOffset + (rowReplicate - 1) * outputWeight, outputWeight);
                }
                outputOffset += outputWeight * (size[0] - 1);
            }
        }
        return output;
    }

    public <T> Tensor<T> updateOutputNhwc(Tensor<T> input, Tensor<T> output, int[] size, ClassTag<T> evidence$4, TensorNumericMath.TensorNumeric<T> ev) {
        int inputHeight = input.size(2);
        int inputWeight = input.size(3);
        int outputHeight = inputHeight * size[0];
        int outputWeight = inputWeight * size[1];
        output.resize(input.size(1), outputHeight, outputWeight, input.size(4));
        int channel = input.size(4);
        int owc = outputWeight * channel;
        Object inputData = input.storage().array();
        int inputOffset = input.storageOffset() - 1;
        Object outputData = output.storage().array();
        int outputOffset = output.storageOffset() - 1;
        for (int i = 0; i < input.size(1); ++i) {
            for (int rowIndex = 0; rowIndex < input.size(2); ++rowIndex) {
                for (int columnIndex = 0; columnIndex < input.size(3); ++columnIndex) {
                    for (int colReplicate = 0; colReplicate < size[1]; ++colReplicate) {
                        ev.arraycopy(inputData, inputOffset, outputData, outputOffset + colReplicate * channel, channel);
                    }
                    outputOffset += channel * size[1];
                    inputOffset += channel;
                }
                for (int rowReplicate = 1; rowReplicate < size[0]; ++rowReplicate) {
                    ev.arraycopy(outputData, outputOffset - owc, outputData, outputOffset + (rowReplicate - 1) * owc, owc);
                }
                outputOffset += owc * (size[0] - 1);
            }
        }
        return output;
    }

    public <T> Tensor<T> updateGradInputNhwc(Tensor<T> gradInput, Tensor<T> gradOutput, int[] size, ClassTag<T> evidence$5, TensorNumericMath.TensorNumeric<T> ev) {
        Object gradInputData = gradInput.storage().array();
        int gradInputOffset = gradInput.storageOffset() - 1;
        Object gradOutputData = gradOutput.storage().array();
        int gradOutputOffset = gradOutput.storageOffset() - 1;
        int gradInputWidth = gradInput.size(4);
        int gradOutputWidth = gradOutput.size(4);
        int channel = gradInput.size(4);
        int ocw = gradOutput.size(3) * gradOutput.size(4);
        for (int i = 0; i < gradInput.size(1); ++i) {
            for (int rowIndex = 0; rowIndex < gradInput.size(2); ++rowIndex) {
                for (int colIndex = 0; colIndex < gradInput.size(3); ++colIndex) {
                    for (int rowReplicate = 0; rowReplicate < size[0]; ++rowReplicate) {
                        for (int colReplicate = 0; colReplicate < size[1]; ++colReplicate) {
                            ev.axpy(channel, ev.one(), gradOutputData, gradOutputOffset + channel * colReplicate + rowReplicate * ocw, 1, gradInputData, gradInputOffset, 1);
                        }
                    }
                    gradInputOffset += channel;
                    gradOutputOffset += size[1] * channel;
                }
                gradOutputOffset += (size[0] - 1) * ocw;
            }
        }
        return gradInput;
    }

    public <T> Tensor<T> updateGradInputNchw(Tensor<T> gradInput, Tensor<T> gradOutput, int[] size, ClassTag<T> evidence$6, TensorNumericMath.TensorNumeric<T> ev) {
        Object gradInputData = gradInput.storage().array();
        int gradInputOffset = gradInput.storageOffset() - 1;
        Object gradOutputData = gradOutput.storage().array();
        int gradOutputOffset = gradOutput.storageOffset() - 1;
        int gradInputWidth = gradInput.size(4);
        int gradOutputWidth = gradOutput.size(4);
        for (int i = 0; i < gradInput.size(1) * gradInput.size(2) * gradInput.size(3); ++i) {
            for (int row = 0; row < size[0]; ++row) {
                for (int col = 0; col < size[1]; ++col) {
                    ev.axpy(gradInputWidth, ev.one(), gradOutputData, gradOutputOffset + col, size[1], gradInputData, gradInputOffset, 1);
                }
                gradOutputOffset += gradOutputWidth;
            }
            gradInputOffset += gradInputWidth;
        }
        return gradInput;
    }

    public <T> DataFormat $lessinit$greater$default$2() {
        return DataFormat$NCHW$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private UpSampling2D$() {
        MODULE$ = this;
    }
}

