/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.nn;

import com.intel.analytics.bigdl.dllib.nn.abstractnn.TensorModule;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.Shape;
import com.intel.analytics.bigdl.dllib.utils.Shape$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0001\u0003\u0001=\u0011A\"\u00169TC6\u0004H.\u001b8hc\u0011S!a\u0001\u0003\u0002\u00059t'BA\u0003\u0007\u0003\u0015!G\u000e\\5c\u0015\t9\u0001\"A\u0003cS\u001e$GN\u0003\u0002\n\u0015\u0005I\u0011M\\1msRL7m\u001d\u0006\u0003\u00171\tQ!\u001b8uK2T\u0011!D\u0001\u0004G>l7\u0001A\u000b\u0003!e\u0019\"\u0001A\t\u0011\u0007I)r#D\u0001\u0014\u0015\t!\"!\u0001\u0006bEN$(/Y2u]:L!AF\n\u0003\u0019Q+gn]8s\u001b>$W\u000f\\3\u0011\u0005aIB\u0002\u0001\u0003\u00065\u0001\u0011\ra\u0007\u0002\u0002)F\u0011AD\t\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\b\u001d>$\b.\u001b8h!\ti2%\u0003\u0002%=\t\u0019\u0011I\\=\t\u0011\u0019\u0002!Q1A\u0005\u0002\u001d\na\u0001\\3oORDW#\u0001\u0015\u0011\u0005uI\u0013B\u0001\u0016\u001f\u0005\rIe\u000e\u001e\u0005\tY\u0001\u0011\t\u0011)A\u0005Q\u00059A.\u001a8hi\"\u0004\u0003\u0002\u0003\u0018\u0001\u0005\u0007\u0005\u000b1B\u0018\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u00021g]i\u0011!\r\u0006\u0003ey\tqA]3gY\u0016\u001cG/\u0003\u00025c\tA1\t\\1tgR\u000bw\r\u0003\u00057\u0001\t\u0005\t\u0015a\u00038\u0003\t)g\u000fE\u00029\u0019^q!!O%\u000f\u0005i:eBA\u001eG\u001d\taTI\u0004\u0002>\t:\u0011ah\u0011\b\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003:\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u0011\u0001\nB\u0001\u0007i\u0016t7o\u001c:\n\u0005)[\u0015!\u0005+f]N|'OT;nKJL7-T1uQ*\u0011\u0001\nB\u0005\u0003\u001b:\u0013Q\u0002V3og>\u0014h*^7fe&\u001c'B\u0001&L\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0003\u0019a\u0014N\\5u}Q\u0011!k\u0016\u000b\u0004'V3\u0006c\u0001+\u0001/5\t!\u0001C\u0003/\u001f\u0002\u000fq\u0006C\u00037\u001f\u0002\u000fq\u0007C\u0003'\u001f\u0002\u0007\u0001\u0006C\u0003Z\u0001\u0011\u0005#,\u0001\nd_6\u0004X\u000f^3PkR\u0004X\u000f^*iCB,GCA.b!\tav,D\u0001^\u0015\tqF!A\u0003vi&d7/\u0003\u0002a;\n)1\u000b[1qK\")!\r\u0017a\u00017\u0006Q\u0011N\u001c9viNC\u0017\r]3\t\u000b\u0011\u0004A\u0011I3\u0002\u0019U\u0004H-\u0019;f\u001fV$\b/\u001e;\u0015\u0005\u0019T\u0007cA4i/5\t1*\u0003\u0002j\u0017\n1A+\u001a8t_JDQa[2A\u0002\u0019\fQ!\u001b8qkRDQ!\u001c\u0001\u0005B9\fq\"\u001e9eCR,wI]1e\u0013:\u0004X\u000f\u001e\u000b\u0004M>\u0004\b\"B6m\u0001\u00041\u0007\"B9m\u0001\u00041\u0017AC4sC\u0012|U\u000f\u001e9vi\u001e)1O\u0001E\u0001i\u0006aQ\u000b]*b[Bd\u0017N\\42\tB\u0011A+\u001e\u0004\u0006\u0003\tA\tA^\n\u0004k^T\bCA\u000fy\u0013\tIhD\u0001\u0004B]f\u0014VM\u001a\t\u0003;mL!\u0001 \u0010\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000bA+H\u0011\u0001@\u0015\u0003QDq!!\u0001v\t\u0003\t\u0019!A\u0003baBd\u00170\u0006\u0003\u0002\u0006\u00055A\u0003BA\u0004\u00033!b!!\u0003\u0002\u0010\u0005U\u0001\u0003\u0002+\u0001\u0003\u0017\u00012\u0001GA\u0007\t\u0015QrP1\u0001\u001c\u0011%\t\tb`A\u0001\u0002\b\t\u0019\"\u0001\u0006fm&$WM\\2fII\u0002B\u0001M\u001a\u0002\f!1ag a\u0002\u0003/\u0001B\u0001\u000f'\u0002\f!)ae a\u0001Q!I\u0011QD;\u0002\u0002\u0013%\u0011qD\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\"A!\u00111EA\u0017\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012\u0001\u00027b]\u001eT!!a\u000b\u0002\t)\fg/Y\u0005\u0005\u0003_\t)C\u0001\u0004PE*,7\r\u001e")
public class UpSampling1D<T>
extends TensorModule<T> {
    private final int length;
    private final TensorNumericMath.TensorNumeric<T> ev;

    public int length() {
        return this.length;
    }

    @Override
    public Shape computeOutputShape(Shape inputShape) {
        int[] input = (int[])inputShape.toSingle().toArray(ClassTag$.MODULE$.Int());
        Log4Error$.MODULE$.invalidInputError(input.length == 3, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UpSampling1D requires 3D input, but got input dim ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)input.length)})), Log4Error$.MODULE$.invalidInputError$default$3());
        return Shape$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{input[0], input[1] * this.length(), input[2]}));
    }

    @Override
    public Tensor<T> updateOutput(Tensor<T> input) {
        Log4Error$.MODULE$.invalidInputError(input.dim() == 3, "UpSampling1D only supports 3D input", Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(input.isContiguous(), "input should be contiguous", Log4Error$.MODULE$.invalidInputError$default$3());
        int inputLength = input.size(3);
        int outputLength = inputLength * this.length();
        ((Tensor)this.output()).resize(input.size(1), input.size(2) * this.length(), input.size(3));
        Object inputData = input.storage().array();
        int inputOffset = input.storageOffset() - 1;
        Object outputData = ((Tensor)this.output()).storage().array();
        int outputOffset = ((Tensor)this.output()).storageOffset() - 1;
        for (int i = 0; i < input.size(1) * input.size(2); ++i) {
            for (int j = 0; j < this.length(); ++j) {
                this.ev.arraycopy(inputData, inputOffset + i * inputLength, outputData, outputOffset + i * outputLength + inputLength * j, inputLength);
            }
        }
        return (Tensor)this.output();
    }

    @Override
    public Tensor<T> updateGradInput(Tensor<T> input, Tensor<T> gradOutput) {
        Log4Error$.MODULE$.invalidInputError(gradOutput.dim() == 3, "UpSampling1D only supports 3D input", Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(gradOutput.isContiguous(), "gradOutput should be contiguous", Log4Error$.MODULE$.invalidInputError$default$3());
        ((Tensor)this.gradInput()).resizeAs(input).zero();
        Object gradInputData = ((Tensor)this.gradInput()).storage().array();
        int gradInputOffset = ((Tensor)this.gradInput()).storageOffset() - 1;
        Object gradOutputData = gradOutput.storage().array();
        int gradOutputOffset = gradOutput.storageOffset() - 1;
        int gradInputLength = ((Tensor)this.gradInput()).size(3);
        int gradOutputLength = gradInputLength * this.length();
        for (int i = 0; i < input.size(1) * input.size(2); ++i) {
            for (int j = 0; j < this.length(); ++j) {
                this.ev.axpy(gradInputLength, this.ev.one(), gradOutputData, gradOutputOffset + i * gradOutputLength + gradInputLength * j, 1, gradInputData, gradInputOffset + i * gradInputLength, 1);
            }
        }
        return (Tensor)this.gradInput();
    }

    public UpSampling1D(int length, ClassTag<T> evidence$1, TensorNumericMath.TensorNumeric<T> ev) {
        this.length = length;
        this.ev = ev;
        super(evidence$1, ev);
        Log4Error$.MODULE$.invalidInputError(length > 0, new StringBuilder().append((Object)"UpSampling1D's length should be bigger than 0,").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)length)}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
    }
}

