/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.nn;

import com.intel.analytics.bigdl.dllib.nn.NNPrimitive$;
import com.intel.analytics.bigdl.dllib.nn.TemporalMaxPooling$;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.TensorModule;
import com.intel.analytics.bigdl.dllib.tensor.DoubleType$;
import com.intel.analytics.bigdl.dllib.tensor.FloatType$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorDataType;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\u0001\u0003\u0001=\u0011!\u0003V3na>\u0014\u0018\r\\'bqB{w\u000e\\5oO*\u00111\u0001B\u0001\u0003]:T!!\u0002\u0004\u0002\u000b\u0011dG.\u001b2\u000b\u0005\u001dA\u0011!\u00022jO\u0012d'BA\u0005\u000b\u0003%\tg.\u00197zi&\u001c7O\u0003\u0002\f\u0019\u0005)\u0011N\u001c;fY*\tQ\"A\u0002d_6\u001c\u0001!\u0006\u0002\u00113M\u0011\u0001!\u0005\t\u0004%U9R\"A\n\u000b\u0005Q\u0011\u0011AC1cgR\u0014\u0018m\u0019;o]&\u0011ac\u0005\u0002\r)\u0016t7o\u001c:N_\u0012,H.\u001a\t\u00031ea\u0001\u0001B\u0003\u001b\u0001\t\u00071DA\u0001U#\ta\"\u0005\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcDA\u0004O_RD\u0017N\\4\u0011\u0005u\u0019\u0013B\u0001\u0013\u001f\u0005\r\te.\u001f\u0005\tM\u0001\u0011)\u0019!C\u0001O\u0005\u00111nV\u000b\u0002QA\u0011Q$K\u0005\u0003Uy\u00111!\u00138u\u0011!a\u0003A!A!\u0002\u0013A\u0013aA6XA!Aa\u0006\u0001BA\u0002\u0013\u0005q%\u0001\u0002e/\"A\u0001\u0007\u0001BA\u0002\u0013\u0005\u0011'\u0001\u0004e/~#S-\u001d\u000b\u0003eU\u0002\"!H\u001a\n\u0005Qr\"\u0001B+oSRDqAN\u0018\u0002\u0002\u0003\u0007\u0001&A\u0002yIEB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006K\u0001K\u0001\u0004I^\u0003\u0003\u0002\u0003\u001e\u0001\u0005\u0007\u0005\u000b1B\u001e\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002=\u007f]i\u0011!\u0010\u0006\u0003}y\tqA]3gY\u0016\u001cG/\u0003\u0002A{\tA1\t\\1tgR\u000bw\r\u0003\u0005C\u0001\t\u0005\t\u0015a\u0003D\u0003\t)g\u000fE\u0002E1^q!!R+\u000f\u0005\u0019\u001bfBA$S\u001d\tA\u0015K\u0004\u0002J!:\u0011!j\u0014\b\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b:\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u0011A\u000bB\u0001\u0007i\u0016t7o\u001c:\n\u0005Y;\u0016!\u0005+f]N|'OT;nKJL7-T1uQ*\u0011A\u000bB\u0005\u00033j\u0013Q\u0002V3og>\u0014h*^7fe&\u001c'B\u0001,X\u0011\u0015a\u0006\u0001\"\u0001^\u0003\u0019a\u0014N\\5u}Q\u0019al\u00193\u0015\u0007}\u000b'\rE\u0002a\u0001]i\u0011A\u0001\u0005\u0006um\u0003\u001da\u000f\u0005\u0006\u0005n\u0003\u001da\u0011\u0005\u0006Mm\u0003\r\u0001\u000b\u0005\b]m\u0003\n\u00111\u0001)\u0011\u001d1\u0007A1A\u0005\n\u001d\fq!\u001b8eS\u000e,7/F\u0001i!\rI'nF\u0007\u0002/&\u00111n\u0016\u0002\u0007)\u0016t7o\u001c:\t\r5\u0004\u0001\u0015!\u0003i\u0003!Ig\u000eZ5dKN\u0004\u0003bB8\u0001\u0005\u0004%IaZ\u0001\u0007S:\u0004X\u000f^\"\t\rE\u0004\u0001\u0015!\u0003i\u0003\u001dIg\u000e];u\u0007\u0002Bqa\u001d\u0001C\u0002\u0013%q-A\u0006he\u0006$w*\u001e;qkR\u001c\u0005BB;\u0001A\u0003%\u0001.\u0001\u0007he\u0006$w*\u001e;qkR\u001c\u0005\u0005C\u0003x\u0001\u0011%\u00010\u0001\u0006tQ\u0006\u0004Xm\u00115fG.$bAM=|{z|\b\"\u0002>w\u0001\u0004A\u0017!B5oaV$\b\"\u0002?w\u0001\u0004A\u0017AC4sC\u0012|U\u000f\u001e9vi\")aM\u001ea\u0001Q\")aE\u001ea\u0001Q!)aF\u001ea\u0001Q!9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0011\u0001D;qI\u0006$XmT;uaV$Hc\u00015\u0002\b!1!0!\u0001A\u0002!Dq!a\u0003\u0001\t\u0003\ti!A\bva\u0012\fG/Z$sC\u0012Le\u000e];u)\u0015A\u0017qBA\t\u0011\u0019Q\u0018\u0011\u0002a\u0001Q\"1A0!\u0003A\u0002!Dq!!\u0006\u0001\t\u0003\n9\"\u0001\u0005dC:,\u0015/^1m)\u0011\tI\"a\b\u0011\u0007u\tY\"C\u0002\u0002\u001ey\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\"\u0005M\u0001\u0019\u0001\u0012\u0002\u000b=$\b.\u001a:\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(\u00051Q-];bYN$B!!\u0007\u0002*!9\u0011\u0011EA\u0012\u0001\u0004\u0011\u0003bBA\u0017\u0001\u0011\u0005\u0013qF\u0001\tQ\u0006\u001c\bnQ8eKR\t\u0001\u0006C\u0004\u00024\u0001!\t%!\u000e\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u000e\u0011\t\u0005e\u0012q\b\b\u0004;\u0005m\u0012bAA\u001f=\u00051\u0001K]3eK\u001aLA!!\u0011\u0002D\t11\u000b\u001e:j]\u001eT1!!\u0010\u001f\u0011\u001d\t9\u0005\u0001C!\u0003\u0013\n!b\u00197fCJ\u001cF/\u0019;f)\t\tY%D\u0001\u0001\u000f\u001d\tyE\u0001E\u0001\u0003#\n!\u0003V3na>\u0014\u0018\r\\'bqB{w\u000e\\5oOB\u0019\u0001-a\u0015\u0007\r\u0005\u0011\u0001\u0012AA+'\u0019\t\u0019&a\u0016\u0002^A\u0019Q$!\u0017\n\u0007\u0005mcD\u0001\u0004B]f\u0014VM\u001a\t\u0004;\u0005}\u0013bAA1=\ta1+\u001a:jC2L'0\u00192mK\"9A,a\u0015\u0005\u0002\u0005\u0015DCAA)\u0011!\tI'a\u0015\u0005\u0002\u0005-\u0014!B1qa2LX\u0003BA7\u0003k\"b!a\u001c\u0002\"\u0006\rFCBA9\u0003/\u000bi\n\u0005\u0003a\u0001\u0005M\u0004c\u0001\r\u0002v\u0011Q!$a\u001a!\u0002\u0003\u0005)\u0019A\u000e)\u0011\u0005U\u0014\u0011PA@\u0003\u001b\u00032!HA>\u0013\r\tiH\b\u0002\fgB,7-[1mSj,G-M\u0005$\u0003\u0003\u000b\u0019)a\"\u0002\u0006:\u0019Q$a!\n\u0007\u0005\u0015e$A\u0003GY>\fG/\r\u0004%\u0003\u0013\u000bYi\b\b\u0004\u0017\u0006-\u0015\"A\u00102\u0013\r\ny)!%\u0002\u0016\u0006MebA\u000f\u0002\u0012&\u0019\u00111\u0013\u0010\u0002\r\u0011{WO\u00197fc\u0019!\u0013\u0011RAF?!Q\u0011\u0011TA4\u0003\u0003\u0005\u001d!a'\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007\u0005\u0003=\u007f\u0005M\u0004b\u0002\"\u0002h\u0001\u000f\u0011q\u0014\t\u0005\tb\u000b\u0019\b\u0003\u0004'\u0003O\u0002\r\u0001\u000b\u0005\t]\u0005\u001d\u0004\u0013!a\u0001Q!Q\u0011qUA*#\u0003%\t!!+\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII*B!a+\u0002BV\u0011\u0011Q\u0016\u0016\u0004Q\u0005=6FAAY!\u0011\t\u0019,!0\u000e\u0005\u0005U&\u0002BA\\\u0003s\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005mf$\u0001\u0006b]:|G/\u0019;j_:LA!a0\u00026\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u0015i\t)\u000b)A\u0001\u0002\u000b\u00071\u0004\u000b\u0005\u0002B\u0006e\u0014QYAec%\u0019\u0013\u0011QAB\u0003\u000f\f))\r\u0004%\u0003\u0013\u000bYiH\u0019\nG\u0005=\u0015\u0011SAf\u0003'\u000bd\u0001JAE\u0003\u0017{\u0002BCAh\u0003'\n\n\u0011\"\u0001\u0002R\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*B!a+\u0002T\u00121!$!4C\u0002mA!\"a6\u0002T\u0005\u0005I\u0011BAm\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005m\u0007\u0003BAo\u0003Ol!!a8\u000b\t\u0005\u0005\u00181]\u0001\u0005Y\u0006twM\u0003\u0002\u0002f\u0006!!.\u0019<b\u0013\u0011\tI/a8\u0003\r=\u0013'.Z2u\u0001")
public class TemporalMaxPooling<T>
extends TensorModule<T> {
    private final int kW;
    private int dW;
    private final TensorNumericMath.TensorNumeric<T> ev;
    private final Tensor<T> indices;
    private final Tensor<T> inputC;
    private final Tensor<T> gradOutputC;

    public static <T> int $lessinit$greater$default$2() {
        return TemporalMaxPooling$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> int apply$default$2() {
        return TemporalMaxPooling$.MODULE$.apply$default$2();
    }

    public int kW() {
        return this.kW;
    }

    public int dW() {
        return this.dW;
    }

    public void dW_$eq(int x$1) {
        this.dW = x$1;
    }

    private Tensor<T> indices() {
        return this.indices;
    }

    private Tensor<T> inputC() {
        return this.inputC;
    }

    private Tensor<T> gradOutputC() {
        return this.gradOutputC;
    }

    private void shapeCheck(Tensor<T> input, Tensor<T> gradOutput, Tensor<T> indices, int kW, int dW) {
        int dimS = 1;
        int dimF = 2;
        int ndims = input.nDimension();
        if (input.nDimension() == 3) {
            dimS = 2;
            dimF = 3;
        }
        int niframe = input.size(dimS);
        int framesize = input.size(dimF);
        int noframe = (niframe - kW) / dW + 1;
        Log4Error$.MODULE$.invalidInputError(kW > 0, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"kernel size should be greater than zero, but got kW: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)kW)})), Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(dW > 0, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stride should be greater than zero, but got dW: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dW)})), Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(input.nDimension() == 2 || input.nDimension() == 3, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2D or 3D (batch mode) tensor expected for input, but got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)input.nDimension())})), Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(input.size(dimS) >= kW, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input sequence smaller than kernel size. Got: ", ", Expected: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)input.size(dimS)), BoxesRunTime.boxToInteger((int)kW)})), Log4Error$.MODULE$.invalidInputError$default$3());
        if (gradOutput != null) {
            Log4Error$.MODULE$.invalidInputError(gradOutput.nDimension() == ndims, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gradOuput should have ", " dimension, but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ndims), BoxesRunTime.boxToInteger((int)gradOutput.nDimension())})), Log4Error$.MODULE$.invalidInputError$default$3());
            Log4Error$.MODULE$.invalidInputError(gradOutput.size(dimS) == noframe, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gradOutput's ", " dimension expects ", " size,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dimS), BoxesRunTime.boxToInteger((int)noframe)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" but got ", " dimension"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)gradOutput.size(dimS))}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
            Log4Error$.MODULE$.invalidInputError(gradOutput.size(dimF) == framesize, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gradOutput's ", " dimension expects ", " size,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dimF), BoxesRunTime.boxToInteger((int)framesize)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" but got ", " dimension"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)gradOutput.size(dimF))}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
        }
        if (indices != null) {
            Log4Error$.MODULE$.invalidInputError(indices.nDimension() == ndims, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"indices should have ", " dimension, but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ndims), BoxesRunTime.boxToInteger((int)indices.nDimension())})), Log4Error$.MODULE$.invalidInputError$default$3());
            Log4Error$.MODULE$.invalidInputError(indices.size(dimS) == noframe, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"indices's ", " dimension expects ", " size,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dimS), BoxesRunTime.boxToInteger((int)noframe)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" but got ", " dimension"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)gradOutput.size(dimS))}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
            Log4Error$.MODULE$.invalidInputError(indices.size(dimF) == framesize, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"indices's ", " dimension expects ", " size,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dimF), BoxesRunTime.boxToInteger((int)framesize)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" but got ", " dimension"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)gradOutput.size(dimF))}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
        }
    }

    @Override
    public Tensor<T> updateOutput(Tensor<T> input) {
        int nIFrame = 0;
        int nOFrame = 0;
        int frameSize = 0;
        int dimS = 1;
        int dimF = 2;
        this.shapeCheck(input, null, null, this.kW(), this.dW());
        if (input.nDimension() == 3) {
            dimS = 2;
            dimF = 3;
        }
        nIFrame = input.size(dimS);
        frameSize = input.size(dimF);
        nOFrame = (nIFrame - this.kW()) / this.dW() + 1;
        this.inputC().resizeAs(input).copy(input);
        if (this.inputC().nDimension() == 2) {
            ((Tensor)this.output()).resize(nOFrame, frameSize);
            this.indices().resize(nOFrame, frameSize);
            TensorDataType tensorDataType = this.ev.getType();
            if (DoubleType$.MODULE$.equals(tensorDataType)) {
                NNPrimitive$.MODULE$.temporalMaxPoolingForwardDouble((double[])this.inputC().storage().array(), this.inputC().storageOffset() - 1, (double[])((Tensor)this.output()).storage().array(), ((Tensor)this.output()).storageOffset() - 1, (double[])this.indices().storage().array(), this.indices().storageOffset() - 1, nOFrame, frameSize, this.kW(), this.dW());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (FloatType$.MODULE$.equals(tensorDataType)) {
                NNPrimitive$.MODULE$.temporalMaxPoolingForwardFloat((float[])this.inputC().storage().array(), this.inputC().storageOffset() - 1, (float[])((Tensor)this.output()).storage().array(), ((Tensor)this.output()).storageOffset() - 1, (float[])this.indices().storage().array(), this.indices().storageOffset() - 1, nOFrame, frameSize, this.kW(), this.dW());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Log4Error$.MODULE$.invalidInputError(false, "TemporalMaxPooling: only Float/Double type supported", Log4Error$.MODULE$.invalidInputError$default$3());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            int nbFrame = input.size(1);
            ((Tensor)this.output()).resize(nbFrame, nOFrame, frameSize);
            this.indices().resize(nbFrame, nOFrame, frameSize);
            for (int i = 1; i <= nbFrame; ++i) {
                BoxedUnit boxedUnit;
                Tensor<T> curInput = this.inputC().apply(i);
                Tensor curOutput = ((Tensor)this.output()).apply(i);
                Tensor<T> curIndices = this.indices().apply(i);
                TensorDataType tensorDataType = this.ev.getType();
                if (DoubleType$.MODULE$.equals(tensorDataType)) {
                    NNPrimitive$.MODULE$.temporalMaxPoolingForwardDouble((double[])curInput.storage().array(), curInput.storageOffset() - 1, (double[])curOutput.storage().array(), curOutput.storageOffset() - 1, (double[])curIndices.storage().array(), curIndices.storageOffset() - 1, nOFrame, frameSize, this.kW(), this.dW());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (FloatType$.MODULE$.equals(tensorDataType)) {
                    NNPrimitive$.MODULE$.temporalMaxPoolingForwardFloat((float[])curInput.storage().array(), curInput.storageOffset() - 1, (float[])curOutput.storage().array(), curOutput.storageOffset() - 1, (float[])curIndices.storage().array(), curIndices.storageOffset() - 1, nOFrame, frameSize, this.kW(), this.dW());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                Log4Error$.MODULE$.invalidInputError(false, "TemporalMaxPooling: only Float/Double type supported", Log4Error$.MODULE$.invalidInputError$default$3());
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        return (Tensor)this.output();
    }

    @Override
    public Tensor<T> updateGradInput(Tensor<T> input, Tensor<T> gradOutput) {
        this.shapeCheck(input, gradOutput, this.indices(), this.kW(), this.dW());
        this.gradOutputC().resizeAs(gradOutput).copy(gradOutput);
        ((Tensor)this.gradInput()).resizeAs(input);
        ((Tensor)this.gradInput()).zero();
        int dimS = 1;
        int dimF = 2;
        if (input.nDimension() == 3) {
            dimS = 2;
            dimF = 3;
        }
        int nOFrame = this.gradOutputC().size(dimS);
        int frameSize = this.gradOutputC().size(dimF);
        if (input.dim() == 2) {
            TensorDataType tensorDataType = this.ev.getType();
            if (DoubleType$.MODULE$.equals(tensorDataType)) {
                NNPrimitive$.MODULE$.temporalMaxPoolingBackwardDouble((double[])((Tensor)this.gradInput()).storage().array(), ((Tensor)this.gradInput()).storageOffset() - 1, (double[])this.gradOutputC().storage().array(), this.gradOutputC().storageOffset() - 1, (double[])this.indices().storage().array(), this.indices().storageOffset() - 1, nOFrame, frameSize, this.kW(), this.dW());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (FloatType$.MODULE$.equals(tensorDataType)) {
                NNPrimitive$.MODULE$.temporalMaxPoolingBackwardFloat((float[])((Tensor)this.gradInput()).storage().array(), ((Tensor)this.gradInput()).storageOffset() - 1, (float[])this.gradOutputC().storage().array(), this.gradOutputC().storageOffset() - 1, (float[])this.indices().storage().array(), this.indices().storageOffset() - 1, nOFrame, frameSize, this.kW(), this.dW());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Log4Error$.MODULE$.invalidInputError(false, "TemporalMaxPooling: only Float/Double type supported", Log4Error$.MODULE$.invalidInputError$default$3());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            int nBFrame = input.size(1);
            for (int i = 1; i <= nBFrame; ++i) {
                BoxedUnit boxedUnit;
                Tensor curGradInput = ((Tensor)this.gradInput()).apply(i);
                Tensor<T> curGradOutput = this.gradOutputC().apply(i);
                Tensor<T> curIndices = this.indices().apply(i);
                TensorDataType tensorDataType = this.ev.getType();
                if (DoubleType$.MODULE$.equals(tensorDataType)) {
                    NNPrimitive$.MODULE$.temporalMaxPoolingBackwardDouble((double[])curGradInput.storage().array(), curGradInput.storageOffset() - 1, (double[])curGradOutput.storage().array(), curGradOutput.storageOffset() - 1, (double[])curIndices.storage().array(), curIndices.storageOffset() - 1, nOFrame, frameSize, this.kW(), this.dW());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (FloatType$.MODULE$.equals(tensorDataType)) {
                    NNPrimitive$.MODULE$.temporalMaxPoolingBackwardFloat((float[])curGradInput.storage().array(), curGradInput.storageOffset() - 1, (float[])curGradOutput.storage().array(), curGradOutput.storageOffset() - 1, (float[])curIndices.storage().array(), curIndices.storageOffset() - 1, nOFrame, frameSize, this.kW(), this.dW());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                Log4Error$.MODULE$.invalidInputError(false, "TemporalMaxPooling: only Float/Double type supported", Log4Error$.MODULE$.invalidInputError$default$3());
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        return (Tensor)this.gradInput();
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof TemporalMaxPooling;
    }

    @Override
    public boolean equals(Object other) {
        TemporalMaxPooling temporalMaxPooling;
        Object object = other;
        boolean bl = object instanceof TemporalMaxPooling ? super.equals(temporalMaxPooling = (TemporalMaxPooling)object) && temporalMaxPooling.canEqual(this) && this.kW() == temporalMaxPooling.kW() && this.dW() == temporalMaxPooling.dW() : false;
        return bl;
    }

    @Override
    public int hashCode() {
        Seq state = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{super.hashCode(), this.kW(), this.dW()}));
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)state.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TemporalMaxPooling $outer;

            public final int apply(Object a) {
                return this.$outer.com$intel$analytics$bigdl$dllib$nn$TemporalMaxPooling$$getHashCode$1(a);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int a, int b) {
                return this.apply$mcIII$sp(a, b);
            }

            public int apply$mcIII$sp(int a, int b) {
                return 31 * a + b;
            }
        }));
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getPrintName(), BoxesRunTime.boxToInteger((int)this.kW()), BoxesRunTime.boxToInteger((int)this.dW())}));
    }

    public TemporalMaxPooling<T> clearState() {
        super.clearState();
        this.indices().set();
        this.inputC().set();
        this.gradOutputC().set();
        return this;
    }

    public final int com$intel$analytics$bigdl$dllib$nn$TemporalMaxPooling$$getHashCode$1(Object a) {
        return a == null ? 0 : a.hashCode();
    }

    public TemporalMaxPooling(int kW, int dW, ClassTag<T> evidence$1, TensorNumericMath.TensorNumeric<T> ev) {
        this.kW = kW;
        this.dW = dW;
        this.ev = ev;
        super(evidence$1, ev);
        this.indices = Tensor$.MODULE$.apply(evidence$1, ev);
        this.inputC = Tensor$.MODULE$.apply(evidence$1, ev);
        this.gradOutputC = Tensor$.MODULE$.apply(evidence$1, ev);
        if (this.dW() == -1) {
            this.dW_$eq(kW);
        }
    }
}

