/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.nn;

import com.intel.analytics.bigdl.dllib.nn.SpatialCrossMapLRN;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.DataFormat;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.DataFormat$NCHW$;
import com.intel.analytics.bigdl.dllib.tensor.ConvertableFrom$ConvertableFromDouble$;
import com.intel.analytics.bigdl.dllib.tensor.ConvertableFrom$ConvertableFromInt$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import scala.Serializable;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SpatialCrossMapLRN$
implements Serializable {
    public static final SpatialCrossMapLRN$ MODULE$;

    static {
        new SpatialCrossMapLRN$();
    }

    public <T> SpatialCrossMapLRN<T> apply(int size, double alpha, double beta, double k, DataFormat format2, ClassTag<T> evidence$2, TensorNumericMath.TensorNumeric<T> ev) {
        return new SpatialCrossMapLRN<T>(size, alpha, beta, k, format2, evidence$2, ev);
    }

    public <T> int apply$default$1() {
        return 5;
    }

    public <T> double apply$default$2() {
        return 1.0;
    }

    public <T> double apply$default$3() {
        return 0.75;
    }

    public <T> double apply$default$4() {
        return 1.0;
    }

    public <T> DataFormat apply$default$5() {
        return DataFormat$NCHW$.MODULE$;
    }

    public <T> void forwardFrameNCHW(Tensor<T> input, Tensor<T> output, Tensor<T> scale, double alpha, int size, double beta, double k, TensorNumericMath.TensorNumeric<T> ev) {
        int c;
        int channels = input.size(1);
        Tensor<T> inputSquare = output;
        inputSquare.pow(input, ev.fromType(BoxesRunTime.boxToInteger((int)2), ConvertableFrom$ConvertableFromInt$.MODULE$));
        int prePad = (size - 1) / 2 + 1;
        int prePadCrop = prePad > channels ? channels : prePad;
        Tensor<Tensor<T>> scaleFirst = scale.select(1, 1).zero();
        for (c = 1; c <= prePadCrop; ++c) {
            scaleFirst.add(inputSquare.select(1, c));
        }
        for (c = 2; c <= channels; ++c) {
            Object object;
            Object object2;
            Tensor<T> scalePrevious = scale.select(1, c - 1);
            Tensor<T> scaleCurrent = scale.select(1, c);
            scaleCurrent.copy(scalePrevious);
            if (c < channels - prePad + 2) {
                Tensor<T> squareNext = inputSquare.select(1, c + prePad - 1);
                object2 = scaleCurrent.add(ev.fromType(BoxesRunTime.boxToInteger((int)1), ConvertableFrom$ConvertableFromInt$.MODULE$), squareNext);
            } else {
                object2 = BoxedUnit.UNIT;
            }
            if (c > prePad) {
                Tensor<T> squarePrevious = inputSquare.select(1, c - prePad);
                object = scaleCurrent.add(ev.fromType(BoxesRunTime.boxToInteger((int)-1), ConvertableFrom$ConvertableFromInt$.MODULE$), squarePrevious);
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        scale.mul(ev.fromType(BoxesRunTime.boxToDouble((double)(alpha / (double)size)), ConvertableFrom$ConvertableFromDouble$.MODULE$)).add(ev.fromType(BoxesRunTime.boxToDouble((double)k), ConvertableFrom$ConvertableFromDouble$.MODULE$));
        output.pow(scale, ev.fromType(BoxesRunTime.boxToDouble((double)(-beta)), ConvertableFrom$ConvertableFromDouble$.MODULE$));
        output.cmul(input);
    }

    public void forwardFrameNHWCFloat(Tensor<Object> input, Tensor<Object> output, double alpha, int size, double beta, double k) {
        Log4Error$.MODULE$.invalidInputError(input.isContiguous(), "input of LRN for NHWC should be contiguous", Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(output.isContiguous(), "output of LRN for NHWC should be contiguous", Log4Error$.MODULE$.invalidInputError$default$3());
        int channel = input.size(3);
        int inputOffset = input.storageOffset() - 1;
        float[] inputArray = (float[])input.storage().array();
        int outputOffset = output.storageOffset() - 1;
        float[] outputArray = (float[])output.storage().array();
        int nElement = output.nElement();
        float l2sum = 0.0f;
        for (int i = 0; i < nElement; ++i) {
            int p = i % channel;
            if (p == 0) {
                l2sum = 0.0f;
                int depth = Math.min((size - 1) / 2 + 1, channel);
                for (int c = 0; c < depth; ++c) {
                    float x = inputArray[inputOffset + i + c];
                    l2sum += x * x;
                }
            } else {
                if (p + (size - 1) / 2 < channel) {
                    float x = inputArray[inputOffset + i + (size - 1) / 2];
                    l2sum += x * x;
                }
                if (p - (size - 1) / 2 > 0) {
                    float x = inputArray[inputOffset + i - (size - 1) / 2 - 1];
                    l2sum -= x * x;
                }
            }
            outputArray[outputOffset + i] = inputArray[inputOffset + i] * (float)Math.pow(k + alpha / (double)size * (double)l2sum, -beta);
        }
    }

    public <T> void com$intel$analytics$bigdl$dllib$nn$SpatialCrossMapLRN$$backwardFrameNCHW(Tensor<T> input, Tensor<T> output, Tensor<T> scale, Tensor<T> gradOutput, Tensor<T> gradInput, Tensor<T> paddedRatio, Tensor<T> accumRatio, double alpha, int size, double beta, TensorNumericMath.TensorNumeric<T> ev) {
        int channels = input.size(1);
        int inversePrePad = size - (size - 1) / 2;
        T cacheRatioValue = ev.fromType(BoxesRunTime.boxToDouble((double)((double)-2 * alpha * beta / (double)size)), ConvertableFrom$ConvertableFromDouble$.MODULE$);
        gradInput.pow(scale, ev.fromType(BoxesRunTime.boxToDouble((double)(-beta)), ConvertableFrom$ConvertableFromDouble$.MODULE$)).cmul(gradOutput);
        paddedRatio.zero();
        Tensor<T> paddedRatioCenter = paddedRatio.narrow(1, inversePrePad, channels);
        paddedRatioCenter.cmul(gradOutput, output).cdiv(scale);
        accumRatio.sum(paddedRatio.narrow(1, 1, size - 1), 1);
        for (int c = 1; c <= channels; ++c) {
            accumRatio.add(paddedRatio.select(1, c + size - 1));
            gradInput.select(1, c).addcmul((Tensor<T>)cacheRatioValue, (Tensor<Tensor<T>>)input.select(1, c), accumRatio);
            accumRatio.add((Tensor<T>)ev.fromType(BoxesRunTime.boxToInteger((int)-1), ConvertableFrom$ConvertableFromInt$.MODULE$), (Tensor<Tensor<T>>)paddedRatio.select(1, c));
        }
    }

    public void backwardFrameNHWCFloat(Tensor<Object> gradOutput, Tensor<Object> input, Tensor<Object> gradInput, Tensor<Object> output, double alpha, int size, double beta, double k) {
        gradInput.copy(input);
        int channel = input.size(3);
        int inputOffset = input.storageOffset() - 1;
        float[] inputArray = (float[])input.storage().array();
        int outputOffset = output.storageOffset() - 1;
        float[] outputArray = (float[])output.storage().array();
        int gradOutputOffset = gradOutput.storageOffset() - 1;
        float[] gradOutputArray = (float[])gradOutput.storage().array();
        int gradInputOffset = gradInput.storageOffset() - 1;
        float[] gradInputArray = (float[])gradInput.storage().array();
        int nElement = gradInput.nElement();
        float glsum = 0.0f;
        for (int i = 0; i < nElement; ++i) {
            int p = i % channel;
            if (p == 0) {
                glsum = 0.0f;
                int depth = Math.min((size - 1) / 2 + 1, channel);
                for (int c = 0; c < depth; ++c) {
                    float x = inputArray[inputOffset + i + c];
                    float g2 = gradOutputArray[gradOutputOffset + i + c];
                    float o = outputArray[outputOffset + i + c];
                    glsum += g2 * (float)Math.pow(o / x, (beta + 1.0) / beta) * x;
                }
            } else {
                if (p + (size - 1) / 2 < channel) {
                    float x = inputArray[inputOffset + i + (size - 1) / 2];
                    float g3 = gradOutputArray[gradOutputOffset + i + (size - 1) / 2];
                    float o = outputArray[outputOffset + i + (size - 1) / 2];
                    glsum += g3 * (float)Math.pow(o / x, (beta + 1.0) / beta) * x;
                }
                if (p - (size - 1) / 2 - 1 >= 0) {
                    float x = inputArray[inputOffset + i - (size - 1) / 2 - 1];
                    float g4 = gradOutputArray[gradOutputOffset + i - (size - 1) / 2 - 1];
                    float o = outputArray[outputOffset + i - (size - 1) / 2 - 1];
                    glsum -= g4 * (float)Math.pow(o / x, (beta + 1.0) / beta) * x;
                }
            }
            float x = inputArray[inputOffset + i];
            float g5 = gradOutputArray[gradOutputOffset + i];
            float o = outputArray[outputOffset + i];
            gradInputArray[gradInputOffset + i] = (float)((double)(o / x * g5) - (double)2 * beta * alpha / (double)size * (double)x * (double)glsum);
        }
    }

    public <T> int $lessinit$greater$default$1() {
        return 5;
    }

    public <T> double $lessinit$greater$default$2() {
        return 1.0;
    }

    public <T> double $lessinit$greater$default$3() {
        return 0.75;
    }

    public <T> double $lessinit$greater$default$4() {
        return 1.0;
    }

    public <T> DataFormat $lessinit$greater$default$5() {
        return DataFormat$NCHW$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public SpatialCrossMapLRN<Object> apply$mDc$sp(int size, double alpha, double beta, double k, DataFormat format2, ClassTag<Object> evidence$2, TensorNumericMath.TensorNumeric<Object> ev) {
        return new SpatialCrossMapLRN<Object>(size, alpha, beta, k, format2, evidence$2, ev);
    }

    public SpatialCrossMapLRN<Object> apply$mFc$sp(int size, double alpha, double beta, double k, DataFormat format2, ClassTag<Object> evidence$2, TensorNumericMath.TensorNumeric<Object> ev) {
        return new SpatialCrossMapLRN<Object>(size, alpha, beta, k, format2, evidence$2, ev);
    }

    private SpatialCrossMapLRN$() {
        MODULE$ = this;
    }
}

