/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.nn;

import com.intel.analytics.bigdl.dllib.nn.ResizeBilinear;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.DataFormat;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.DataFormat$NCHW$;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ClassTag;

public final class ResizeBilinear$
implements Serializable {
    public static final ResizeBilinear$ MODULE$;

    static {
        new ResizeBilinear$();
    }

    public <T> ResizeBilinear<T> apply(int outputHeight, int outputWidth, boolean alignCorners, DataFormat dataFormat, ClassTag<T> evidence$2, TensorNumericMath.TensorNumeric<T> ev) {
        return new ResizeBilinear<T>(outputHeight, outputWidth, alignCorners, dataFormat, evidence$2, ev);
    }

    public <T> boolean apply$default$3() {
        return false;
    }

    public <T> DataFormat apply$default$4() {
        return DataFormat$NCHW$.MODULE$;
    }

    public float com$intel$analytics$bigdl$dllib$nn$ResizeBilinear$$computeLERP(float topLeft, float topRight, float bottomLeft, float bottomRight, float xLERP, float yLERP) {
        float top = topLeft + (topRight - topLeft) * xLERP;
        float bottom = bottomLeft + (bottomRight - bottomLeft) * xLERP;
        return top + (bottom - top) * yLERP;
    }

    public void com$intel$analytics$bigdl$dllib$nn$ResizeBilinear$$computeInterpolationWeights(int outSize, int inSize, float scale, ResizeBilinear.InterpolationWeight[] interpolation) {
        interpolation[outSize].lower_$eq(0);
        interpolation[outSize].upper_$eq(0);
        for (int i = outSize - 1; i >= 0; --i) {
            float in = (float)i * scale;
            interpolation[i].lower_$eq((int)in);
            interpolation[i].upper_$eq(Math.min(interpolation[i].lower() + 1, inSize - 1));
            interpolation[i].lerp_$eq(in - (float)interpolation[i].lower());
        }
    }

    public void com$intel$analytics$bigdl$dllib$nn$ResizeBilinear$$resizeImage(float[] image, int imageOffset, int batchSize, int inHeight, int inWidth, int outHeight, int outWidth, int channels, ResizeBilinear.InterpolationWeight[] xs, ResizeBilinear.InterpolationWeight[] ys, float[] output, int outputOffset) {
        int inRowSize = inWidth * channels;
        int inBatchNumber = inHeight * inRowSize;
        int outRowSize = outWidth * channels;
        int _imageOffset = imageOffset;
        int _outputOffset = outputOffset;
        for (int b = 0; b < batchSize; ++b) {
            for (int y = 0; y < outHeight; ++y) {
                float ysLERP = ys[y].lerp();
                for (int x = 0; x < outWidth; ++x) {
                    int xsLower = xs[x].lower();
                    int xsUpper = xs[x].upper();
                    float xsLERP = xs[x].lerp();
                    for (int c = 0; c < channels; ++c) {
                        float topLeft = image[_imageOffset + ys[y].lower() * inRowSize + xsLower + c];
                        float topRight = image[_imageOffset + ys[y].lower() * inRowSize + xsUpper + c];
                        float bottomLeft = image[_imageOffset + ys[y].upper() * inRowSize + xsLower + c];
                        float bottomRight = image[_imageOffset + ys[y].upper() * inRowSize + xsUpper + c];
                        output[_outputOffset + x * channels + c] = this.com$intel$analytics$bigdl$dllib$nn$ResizeBilinear$$computeLERP(topLeft, topRight, bottomLeft, bottomRight, xsLERP, ysLERP);
                    }
                }
                _outputOffset += outRowSize;
            }
            _imageOffset += inBatchNumber;
        }
    }

    public void com$intel$analytics$bigdl$dllib$nn$ResizeBilinear$$resizeImageBackprop(int batchSize, int channels, int inHeight, int inWidth, int outputHeight, int outputWidth, float heightScale, float widthScale, float[] gradInputData, int gradInputOffset, float[] gradOutputData, int gradOutputOffset) {
        int inRowSize = inWidth * channels;
        int inBatchNum = inHeight * inRowSize;
        int outRowSize = outputWidth * channels;
        int outBatchNum = outputHeight * outRowSize;
        for (int b = 0; b < batchSize; ++b) {
            for (int y = 0; y < outputHeight; ++y) {
                float inY = (float)y * heightScale;
                int topY = (int)inY;
                int bottomY = package$.MODULE$.min((int)package$.MODULE$.ceil((double)inY), inHeight - 1);
                float yLERP = inY - (float)topY;
                float inverseYLERP = 1.0f - yLERP;
                for (int x = 0; x < outputWidth; ++x) {
                    float inX = (float)x * widthScale;
                    int leftX = (int)inX;
                    int rightX = package$.MODULE$.min((int)package$.MODULE$.ceil((double)inX), inWidth - 1);
                    float xLERP = inX - (float)leftX;
                    float inverseXLERP = 1.0f - xLERP;
                    for (int c = 0; c < channels; ++c) {
                        int n = gradInputOffset + b * inBatchNum + topY * inRowSize + leftX * channels + c;
                        gradInputData[n] = gradInputData[n] + gradOutputData[gradOutputOffset + b * outBatchNum + y * outRowSize + x * channels + c] * inverseYLERP * inverseXLERP;
                        int n2 = gradInputOffset + b * inBatchNum + topY * inRowSize + rightX * channels + c;
                        gradInputData[n2] = gradInputData[n2] + gradOutputData[gradOutputOffset + b * outBatchNum + y * outRowSize + x * channels + c] * inverseYLERP * xLERP;
                        int n3 = gradInputOffset + b * inBatchNum + bottomY * inRowSize + leftX * channels + c;
                        gradInputData[n3] = gradInputData[n3] + gradOutputData[gradOutputOffset + b * outBatchNum + y * outRowSize + x * channels + c] * yLERP * inverseXLERP;
                        int n4 = gradInputOffset + b * inBatchNum + bottomY * inRowSize + rightX * channels + c;
                        gradInputData[n4] = gradInputData[n4] + gradOutputData[gradOutputOffset + b * outBatchNum + y * outRowSize + x * channels + c] * yLERP * xLERP;
                    }
                }
            }
        }
    }

    public float com$intel$analytics$bigdl$dllib$nn$ResizeBilinear$$calculateResizeScale(int inSize, int outSize, boolean alignCorners) {
        return alignCorners && outSize > 1 ? (float)(inSize - 1) / (float)(outSize - 1) : (float)inSize / (float)outSize;
    }

    public <T> DataFormat $lessinit$greater$default$4() {
        return DataFormat$NCHW$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ResizeBilinear$() {
        MODULE$ = this;
    }
}

