/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.nn;

import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import java.util.Arrays;
import scala.Double$;
import scala.Float$;
import scala.Function1;
import scala.Serializable;
import scala.collection.Iterator;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class NNPrimitive$ {
    public static final NNPrimitive$ MODULE$;

    static {
        new NNPrimitive$();
    }

    public void im2colDouble(Tensor<Object> fInput, Tensor<Object> input, int kW, int kH, int dW, int dH, int padLeft, int padTop, int padRight, int padBottom, int outputWidth, int outputHeight) {
        int nInputPlane = input.size(1);
        int inputHeight = input.size(2);
        int inputWidth = input.size(3);
        double[] inputData = (double[])input.storage().array();
        double[] fInputData = (double[])fInput.storage().array();
        for (int k = 0; k < nInputPlane * kH * kW; ++k) {
            int nip = k / (kH * kW);
            int rest = k % (kH * kW);
            int kh = rest / kW;
            int kw = rest % kW;
            int dstOffset = k * outputHeight * outputWidth + fInput.storageOffset() - 1;
            int srcOffset = nip * inputWidth * inputHeight + input.storageOffset() - 1;
            if (padLeft > 0 || padRight > 0 || padTop > 0 || padBottom > 0) {
                for (int y = 0; y < outputHeight; ++y) {
                    int iy = y * dH - padTop + kh;
                    if (iy < 0 || iy >= inputHeight) {
                        Arrays.fill(fInputData, dstOffset + y * outputWidth, dstOffset + (y + 1) * outputWidth, 0.0);
                        continue;
                    }
                    if (dW == 1) {
                        int ix = 0 - padLeft + kw;
                        int lpad = Math.max(0, padLeft - kw);
                        int rpad = Math.max(0, padRight - (kW - kw - 1));
                        if (outputWidth - rpad - lpad <= 0) {
                            Arrays.fill(fInputData, dstOffset + y * outputWidth, dstOffset + (y + 1) * outputWidth, 0.0);
                            continue;
                        }
                        if (lpad > 0) {
                            Arrays.fill(fInputData, dstOffset + y * outputWidth, dstOffset + y * outputWidth + lpad, 0.0);
                        }
                        System.arraycopy(inputData, srcOffset + iy * inputWidth + ix + lpad, fInputData, dstOffset + y * outputWidth + lpad, outputWidth - rpad - lpad);
                        if (rpad <= 0) continue;
                        Arrays.fill(fInputData, dstOffset + (y + 1) * outputWidth - rpad, dstOffset + (y + 1) * outputWidth, 0.0);
                        continue;
                    }
                    for (int x = 0; x < outputWidth; ++x) {
                        int ix = x * dW - padLeft + kw;
                        fInputData[dstOffset + y * outputWidth + x] = ix < 0 || ix >= inputWidth ? 0.0 : inputData[srcOffset + iy * inputWidth + ix];
                    }
                }
                continue;
            }
            for (int y = 0; y < outputHeight; ++y) {
                int iy = y * dH + kh;
                int ix = 0 + kw;
                if (dW == 1) {
                    System.arraycopy(inputData, srcOffset + iy * inputWidth + ix, fInputData, dstOffset + y * outputWidth, outputWidth);
                    continue;
                }
                for (int x = 0; x < outputWidth; ++x) {
                    fInputData[dstOffset + y * outputWidth + x] = inputData[srcOffset + iy * inputWidth + ix + x * dW];
                }
            }
        }
    }

    public void im2colFloat(Tensor<Object> fInput, Tensor<Object> input, int kW, int kH, int dW, int dH, int padLeft, int padTop, int padRight, int padBottom, int outputWidth, int outputHeight) {
        int nInputPlane = input.size(1);
        int inputHeight = input.size(2);
        int inputWidth = input.size(3);
        float[] inputData = (float[])input.storage().array();
        float[] fInputData = (float[])fInput.storage().array();
        for (int k = 0; k < nInputPlane * kH * kW; ++k) {
            int nip = k / (kH * kW);
            int rest = k % (kH * kW);
            int kh = rest / kW;
            int kw = rest % kW;
            int dstOffset = k * outputHeight * outputWidth + fInput.storageOffset() - 1;
            int srcOffset = nip * inputWidth * inputHeight + input.storageOffset() - 1;
            if (padLeft > 0 || padRight > 0 || padTop > 0 || padBottom > 0) {
                for (int y = 0; y < outputHeight; ++y) {
                    int iy = y * dH - padTop + kh;
                    if (iy < 0 || iy >= inputHeight) {
                        Arrays.fill(fInputData, dstOffset + y * outputWidth, dstOffset + (y + 1) * outputWidth, 0.0f);
                        continue;
                    }
                    if (dW == 1) {
                        int ix = 0 - padLeft + kw;
                        int lpad = Math.max(0, padLeft - kw);
                        int rpad = Math.max(0, padRight - (kW - kw - 1));
                        if (outputWidth - rpad - lpad <= 0) {
                            Arrays.fill(fInputData, dstOffset + y * outputWidth, dstOffset + (y + 1) * outputWidth, 0.0f);
                            continue;
                        }
                        if (lpad > 0) {
                            Arrays.fill(fInputData, dstOffset + y * outputWidth, dstOffset + y * outputWidth + lpad, 0.0f);
                        }
                        System.arraycopy(inputData, srcOffset + iy * inputWidth + ix + lpad, fInputData, dstOffset + y * outputWidth + lpad, outputWidth - rpad - lpad);
                        if (rpad <= 0) continue;
                        Arrays.fill(fInputData, dstOffset + (y + 1) * outputWidth - rpad, dstOffset + (y + 1) * outputWidth, 0.0f);
                        continue;
                    }
                    for (int x = 0; x < outputWidth; ++x) {
                        int ix = x * dW - padLeft + kw;
                        fInputData[dstOffset + y * outputWidth + x] = ix < 0 || ix >= inputWidth ? 0.0f : inputData[srcOffset + iy * inputWidth + ix];
                    }
                }
                continue;
            }
            for (int y = 0; y < outputHeight; ++y) {
                int iy = y * dH + kh;
                int ix = 0 + kw;
                if (dW == 1) {
                    System.arraycopy(inputData, srcOffset + iy * inputWidth + ix, fInputData, dstOffset + y * outputWidth, outputWidth);
                    continue;
                }
                for (int x = 0; x < outputWidth; ++x) {
                    fInputData[dstOffset + y * outputWidth + x] = inputData[srcOffset + iy * inputWidth + ix + x * dW];
                }
            }
        }
    }

    public void col2imDouble(Tensor<Object> fInput, Tensor<Object> input, int kW, int kH, int dW, int dH, int padLeft, int padTop, int padRight, int padBottom, int outputWidth, int outputHeight) {
        int nInputPlane = input.size(1);
        int inputHeight = input.size(2);
        int inputWidth = input.size(3);
        double[] inputData = (double[])input.storage().array();
        double[] fInputData = (double[])fInput.storage().array();
        for (int nPlane = 0; nPlane < nInputPlane; ++nPlane) {
            for (int kh = 0; kh < kH; ++kh) {
                for (int kw = 0; kw < kW; ++kw) {
                    int srcOffset = nPlane * (kH * kW * outputHeight * outputWidth) + kh * (kW * outputHeight * outputWidth) + kw * (outputHeight * outputWidth) + fInput.storageOffset() - 1;
                    int dstOffset = nPlane * (inputHeight * inputWidth) + input.storageOffset() - 1;
                    if (padLeft > 0 || padRight > 0 || padTop > 0 || padBottom > 0) {
                        for (int y = 0; y < outputHeight; ++y) {
                            int iy = y * dH - padTop + kh;
                            if (iy < 0 || iy >= inputHeight) continue;
                            if (dW == 1) {
                                int ix = 0 - padLeft + kw;
                                int lPad = Math.max(0, padLeft - kw);
                                int rPad = Math.max(0, padRight - (kW - kw - 1));
                                int inputDataOffset = dstOffset + iy * inputWidth + ix + lPad;
                                int fInputDataOffset = srcOffset + y * outputWidth + lPad;
                                int n = outputWidth - lPad - rPad;
                                for (int i = 0; i < n; ++i) {
                                    int n2 = inputDataOffset + i;
                                    inputData[n2] = inputData[n2] + fInputData[fInputDataOffset + i];
                                }
                                continue;
                            }
                            for (int x = 0; x < outputWidth; ++x) {
                                int ix = x * dW - padLeft + kw;
                                if (ix < 0 || ix >= inputWidth) continue;
                                int n = dstOffset + iy * inputWidth + ix;
                                inputData[n] = inputData[n] + fInputData[srcOffset + y * outputWidth + x];
                            }
                        }
                        continue;
                    }
                    for (int y = 0; y < outputHeight; ++y) {
                        int iy = y * dH + kh;
                        int ix = 0 + kw;
                        if (dW == 1) {
                            int inputDataOffset = dstOffset + iy * inputWidth + ix;
                            int fInputDataOffset = srcOffset + y * outputWidth;
                            for (int i = 0; i < outputWidth; ++i) {
                                int n = inputDataOffset + i;
                                inputData[n] = inputData[n] + fInputData[fInputDataOffset + i];
                            }
                            continue;
                        }
                        for (int x = 0; x < outputWidth; ++x) {
                            int n = dstOffset + iy * inputWidth + ix + x * dW;
                            inputData[n] = inputData[n] + fInputData[srcOffset + y * outputWidth + x];
                        }
                    }
                }
            }
        }
    }

    public void col2imFloat(Tensor<Object> fInput, Tensor<Object> input, int kW, int kH, int dW, int dH, int padLeft, int padTop, int padRight, int padBottom, int outputWidth, int outputHeight) {
        int nInputPlane = input.size(1);
        int inputHeight = input.size(2);
        int inputWidth = input.size(3);
        float[] inputData = (float[])input.storage().array();
        float[] fInputData = (float[])fInput.storage().array();
        for (int nPlane = 0; nPlane < nInputPlane; ++nPlane) {
            for (int kh = 0; kh < kH; ++kh) {
                for (int kw = 0; kw < kW; ++kw) {
                    int srcOffset = nPlane * (kH * kW * outputHeight * outputWidth) + kh * (kW * outputHeight * outputWidth) + kw * (outputHeight * outputWidth) + fInput.storageOffset() - 1;
                    int dstOffset = nPlane * (inputHeight * inputWidth) + input.storageOffset() - 1;
                    if (padLeft > 0 || padRight > 0 || padTop > 0 || padBottom > 0) {
                        for (int y = 0; y < outputHeight; ++y) {
                            int iy = y * dH - padTop + kh;
                            if (iy < 0 || iy >= inputHeight) continue;
                            if (dW == 1) {
                                int ix = 0 - padLeft + kw;
                                int lPad = Math.max(0, padLeft - kw);
                                int rPad = Math.max(0, padRight - (kW - kw - 1));
                                int inputDataOffset = dstOffset + iy * inputWidth + ix + lPad;
                                int fInputDataOffset = srcOffset + y * outputWidth + lPad;
                                int n = outputWidth - lPad - rPad;
                                for (int i = 0; i < n; ++i) {
                                    int n2 = inputDataOffset + i;
                                    inputData[n2] = inputData[n2] + fInputData[fInputDataOffset + i];
                                }
                                continue;
                            }
                            for (int x = 0; x < outputWidth; ++x) {
                                int ix = x * dW - padLeft + kw;
                                if (ix < 0 || ix >= inputWidth) continue;
                                int n = dstOffset + iy * inputWidth + ix;
                                inputData[n] = inputData[n] + fInputData[srcOffset + y * outputWidth + x];
                            }
                        }
                        continue;
                    }
                    for (int y = 0; y < outputHeight; ++y) {
                        int iy = y * dH + kh;
                        int ix = 0 + kw;
                        if (dW == 1) {
                            int inputDataOffset = dstOffset + iy * inputWidth + ix;
                            int fInputDataOffset = srcOffset + y * outputWidth;
                            for (int i = 0; i < outputWidth; ++i) {
                                int n = inputDataOffset + i;
                                inputData[n] = inputData[n] + fInputData[fInputDataOffset + i];
                            }
                            continue;
                        }
                        for (int x = 0; x < outputWidth; ++x) {
                            int n = dstOffset + iy * inputWidth + ix + x * dW;
                            inputData[n] = inputData[n] + fInputData[srcOffset + y * outputWidth + x];
                        }
                    }
                }
            }
        }
    }

    public void im2colDoubleNHWC(Tensor<Object> fInput, Tensor<Object> input, int kW, int kH, int dW, int dH, int padLeft, int padTop, int padRight, int padBottom, int outputWidth, int outputHeight) {
        int nInputPlane = input.size(3);
        int inputHeight = input.size(1);
        int inputWidth = input.size(2);
        double[] inputData = (double[])input.storage().array();
        double[] fInputData = (double[])fInput.storage().array();
        int srcOffset = input.storageOffset() - 1;
        int destOffset = fInput.storageOffset() - 1;
        int hPad = -padTop;
        int fInputCount = 0;
        int h2 = 0;
        while (h2 < outputHeight) {
            int wPad = -padLeft;
            int w = 0;
            while (w < outputWidth) {
                for (int ih = hPad; ih < hPad + kH; ++ih) {
                    int iw = wPad;
                    while (iw < wPad + kW) {
                        if (ih >= 0 && ih < inputHeight && iw >= 0 && iw < inputWidth) {
                            int src = srcOffset + (ih * inputWidth + iw) * nInputPlane;
                            int dest = destOffset + fInputCount;
                            int n = Math.min(inputWidth, wPad + kW) - iw;
                            System.arraycopy(inputData, src, fInputData, dest, nInputPlane * n);
                            fInputCount += nInputPlane * n;
                            iw += n;
                            continue;
                        }
                        int n = ih < 0 || ih >= inputHeight || iw >= inputWidth ? wPad + kW - iw : 0 - iw;
                        int fromIndex = destOffset + fInputCount;
                        int toIndex = fromIndex + nInputPlane * n;
                        Arrays.fill(fInputData, fromIndex, toIndex, 0.0);
                        fInputCount += nInputPlane * n;
                        iw += n;
                    }
                }
                ++w;
                wPad += dW;
            }
            ++h2;
            hPad += dH;
        }
    }

    public void im2colFloatNHWC(Tensor<Object> fInput, Tensor<Object> input, int kW, int kH, int dW, int dH, int padLeft, int padTop, int padRight, int padBottom, int outputWidth, int outputHeight) {
        int nInputPlane = input.size(3);
        int inputHeight = input.size(1);
        int inputWidth = input.size(2);
        float[] inputData = (float[])input.storage().array();
        float[] fInputData = (float[])fInput.storage().array();
        int srcOffset = input.storageOffset() - 1;
        int destOffset = fInput.storageOffset() - 1;
        int hPad = -padTop;
        int fInputCount = 0;
        int h2 = 0;
        while (h2 < outputHeight) {
            int wPad = -padLeft;
            int w = 0;
            while (w < outputWidth) {
                for (int ih = hPad; ih < hPad + kH; ++ih) {
                    int iw = wPad;
                    while (iw < wPad + kW) {
                        if (ih >= 0 && ih < inputHeight && iw >= 0 && iw < inputWidth) {
                            int src = srcOffset + (ih * inputWidth + iw) * nInputPlane;
                            int dest = destOffset + fInputCount;
                            int n = Math.min(inputWidth, wPad + kW) - iw;
                            System.arraycopy(inputData, src, fInputData, dest, nInputPlane * n);
                            fInputCount += nInputPlane * n;
                            iw += n;
                            continue;
                        }
                        int n = ih < 0 || ih >= inputHeight || iw >= inputWidth ? wPad + kW - iw : 0 - iw;
                        int fromIndex = destOffset + fInputCount;
                        int toIndex = fromIndex + nInputPlane * n;
                        Arrays.fill(fInputData, fromIndex, toIndex, 0.0f);
                        fInputCount += nInputPlane * n;
                        iw += n;
                    }
                }
                ++w;
                wPad += dW;
            }
            ++h2;
            hPad += dH;
        }
    }

    public void col2imDoubleNHWC(Tensor<Object> fInput, Tensor<Object> input, int kW, int kH, int dW, int dH, int padLeft, int padTop, int padRight, int padBottom, int outputWidth, int outputHeight) {
        int nInputPlane = input.size(3);
        int inputHeight = input.size(1);
        int inputWidth = input.size(2);
        double[] inputData = (double[])input.storage().array();
        int inputOffset = input.storageOffset() - 1;
        double[] fInputData = (double[])fInput.storage().array();
        int fInputOffset = fInput.storageOffset() - 1;
        int hPad = -padTop;
        int h2 = 0;
        int fInputCount = 0;
        while (h2 < outputHeight) {
            int wPad = -padLeft;
            int w = 0;
            while (w < outputWidth) {
                for (int ih = hPad; ih < hPad + kH; ++ih) {
                    for (int iw = wPad; iw < wPad + kW; ++iw) {
                        if (ih >= 0 && ih < inputHeight && iw >= 0 && iw < inputWidth) {
                            int dataImPatch = inputOffset + (ih * inputWidth + iw) * nInputPlane;
                            for (int i = 0; i < nInputPlane; ++i) {
                                int n = dataImPatch + i;
                                inputData[n] = inputData[n] + fInputData[fInputOffset + fInputCount];
                                ++fInputCount;
                            }
                            continue;
                        }
                        fInputCount += nInputPlane;
                    }
                }
                ++w;
                wPad += dW;
            }
            ++h2;
            hPad += dH;
        }
    }

    public void col2imFloatNHWC(Tensor<Object> fInput, Tensor<Object> input, int kW, int kH, int dW, int dH, int padLeft, int padTop, int padRight, int padBottom, int outputWidth, int outputHeight) {
        int nInputPlane = input.size(3);
        int inputHeight = input.size(1);
        int inputWidth = input.size(2);
        float[] inputData = (float[])input.storage().array();
        int inputOffset = input.storageOffset() - 1;
        float[] fInputData = (float[])fInput.storage().array();
        int fInputOffset = fInput.storageOffset() - 1;
        int hPad = -padTop;
        int h2 = 0;
        int fInputCount = 0;
        while (h2 < outputHeight) {
            int wPad = -padLeft;
            int w = 0;
            while (w < outputWidth) {
                for (int ih = hPad; ih < hPad + kH; ++ih) {
                    for (int iw = wPad; iw < wPad + kW; ++iw) {
                        if (ih >= 0 && ih < inputHeight && iw >= 0 && iw < inputWidth) {
                            int dataImPatch = inputOffset + (ih * inputWidth + iw) * nInputPlane;
                            for (int i = 0; i < nInputPlane; ++i) {
                                int n = dataImPatch + i;
                                inputData[n] = inputData[n] + fInputData[fInputOffset + fInputCount];
                                ++fInputCount;
                            }
                            continue;
                        }
                        fInputCount += nInputPlane;
                    }
                }
                ++w;
                wPad += dW;
            }
            ++h2;
            hPad += dH;
        }
    }

    public void maxPoolingForwardDouble(Tensor<Object> inputTensor, Tensor<Object> outputTensor, Tensor<Object> indicesTensor, int oWidth, int oHeight, int kW, int kH, int dW, int dH, int padW, int padH) {
        int nSlices = inputTensor.size(1);
        int iHeight = inputTensor.size(2);
        int iWidth = inputTensor.size(3);
        double[] input = (double[])inputTensor.storage().array();
        int inputOffset = inputTensor.storageOffset() - 1;
        double[] output = (double[])outputTensor.storage().array();
        int outputOffset = outputTensor.storageOffset() - 1;
        double[] indices = (double[])indicesTensor.storage().array();
        int indicesOffset = indicesTensor.storageOffset() - 1;
        Iterator slices = scala.package$.MODULE$.Range().apply(0, nSlices).iterator();
        while (slices.hasNext()) {
            int k = BoxesRunTime.unboxToInt((Object)slices.next());
            for (int i = 0; i < oHeight; ++i) {
                for (int j = 0; j < oWidth; ++j) {
                    int hstart = i * dH - padH;
                    int wstart = j * dW - padW;
                    int hend = package$.MODULE$.min(hstart + kH, iHeight);
                    int wend = package$.MODULE$.min(wstart + kW, iWidth);
                    hstart = package$.MODULE$.max(hstart, 0);
                    wstart = package$.MODULE$.max(wstart, 0);
                    int maxindex = 0;
                    double maxval = Double$.MODULE$.MinValue();
                    int tcntr = 0;
                    for (int y = hstart; y < hend; ++y) {
                        for (int x = wstart; x < wend; ++x) {
                            tcntr = y * iWidth + x;
                            double value2 = input[tcntr + inputOffset + k * iWidth * iHeight];
                            if (!(value2 > maxval)) continue;
                            maxval = value2;
                            maxindex = tcntr;
                        }
                    }
                    output[outputOffset + k * oWidth * oHeight + i * oWidth + j] = maxval;
                    indices[indicesOffset + k * oWidth * oHeight + i * oWidth + j] = maxindex + 1;
                }
            }
        }
    }

    public void maxPoolingForwardFloat(Tensor<Object> inputTensor, Tensor<Object> outputTensor, Tensor<Object> indicesTensor, int oWidth, int oHeight, int kW, int kH, int dW, int dH, int padW, int padH) {
        int nSlices = inputTensor.size(1);
        int iHeight = inputTensor.size(2);
        int iWidth = inputTensor.size(3);
        float[] input = (float[])inputTensor.storage().array();
        int inputOffset = inputTensor.storageOffset() - 1;
        float[] output = (float[])outputTensor.storage().array();
        int outputOffset = outputTensor.storageOffset() - 1;
        float[] indices = (float[])indicesTensor.storage().array();
        int indicesOffset = indicesTensor.storageOffset() - 1;
        Iterator slices = scala.package$.MODULE$.Range().apply(0, nSlices).iterator();
        while (slices.hasNext()) {
            int k = BoxesRunTime.unboxToInt((Object)slices.next());
            for (int i = 0; i < oHeight; ++i) {
                for (int j = 0; j < oWidth; ++j) {
                    int hstart = i * dH - padH;
                    int wstart = j * dW - padW;
                    int hend = package$.MODULE$.min(hstart + kH, iHeight);
                    int wend = package$.MODULE$.min(wstart + kW, iWidth);
                    hstart = package$.MODULE$.max(hstart, 0);
                    wstart = package$.MODULE$.max(wstart, 0);
                    int maxindex = 0;
                    float maxval = Float$.MODULE$.MinValue();
                    int tcntr = 0;
                    for (int y = hstart; y < hend; ++y) {
                        for (int x = wstart; x < wend; ++x) {
                            tcntr = y * iWidth + x;
                            float value2 = input[tcntr + inputOffset + k * iWidth * iHeight];
                            if (!(value2 > maxval)) continue;
                            maxval = value2;
                            maxindex = tcntr;
                        }
                    }
                    output[outputOffset + k * oWidth * oHeight + i * oWidth + j] = maxval;
                    indices[indicesOffset + k * oWidth * oHeight + i * oWidth + j] = maxindex + 1;
                }
            }
        }
    }

    public void maxPoolingBackwardFloat(Tensor<Object> gradInputTensor, Tensor<Object> gradOutputTensor, Tensor<Object> indicesTensor, int owidth, int oheight) {
        int nSlices = gradInputTensor.size(1);
        int iHeight = gradInputTensor.size(2);
        int iWidth = gradInputTensor.size(3);
        float[] gradInput = (float[])gradInputTensor.storage().array();
        int gradInputOffset = gradInputTensor.storageOffset() - 1;
        float[] gradOutput = (float[])gradOutputTensor.storage().array();
        int gradOutputOffset = gradOutputTensor.storageOffset() - 1;
        float[] indices = (float[])indicesTensor.storage().array();
        int indicesOffset = indicesTensor.storageOffset() - 1;
        Iterator slices = scala.package$.MODULE$.Range().apply(0, nSlices).iterator();
        while (slices.hasNext()) {
            int k = BoxesRunTime.unboxToInt((Object)slices.next());
            for (int i = 0; i < oheight; ++i) {
                for (int j = 0; j < owidth; ++j) {
                    int maxp = (int)indices[i * owidth + j + indicesOffset + k * owidth * oheight] - 1;
                    int n = maxp + k * iWidth * iHeight + gradInputOffset;
                    gradInput[n] = gradInput[n] + gradOutput[gradOutputOffset + k * owidth * oheight + i * owidth + j];
                }
            }
        }
    }

    public void maxPoolingBackwardDouble(Tensor<Object> gradInputTensor, Tensor<Object> gradOutputTensor, Tensor<Object> indicesTensor, int owidth, int oheight) {
        int nSlices = gradInputTensor.size(1);
        int iHeight = gradInputTensor.size(2);
        int iWidth = gradInputTensor.size(3);
        double[] gradInput = (double[])gradInputTensor.storage().array();
        int gradInputOffset = gradInputTensor.storageOffset() - 1;
        double[] gradOutput = (double[])gradOutputTensor.storage().array();
        int gradOutputOffset = gradOutputTensor.storageOffset() - 1;
        double[] indices = (double[])indicesTensor.storage().array();
        int indicesOffset = indicesTensor.storageOffset() - 1;
        Iterator slices = scala.package$.MODULE$.Range().apply(0, nSlices).iterator();
        while (slices.hasNext()) {
            int k = BoxesRunTime.unboxToInt((Object)slices.next());
            for (int i = 0; i < oheight; ++i) {
                for (int j = 0; j < owidth; ++j) {
                    int maxp = (int)indices[i * owidth + j + indicesOffset + k * owidth * oheight] - 1;
                    int n = maxp + k * iWidth * iHeight + gradInputOffset;
                    gradInput[n] = gradInput[n] + gradOutput[gradOutputOffset + k * owidth * oheight + i * owidth + j];
                }
            }
        }
    }

    public void maxPoolingForwardDoubleNHWC(Tensor<Object> inputTensor, Tensor<Object> outputTensor, Tensor<Object> indicesTensor, int oWidth, int oHeight, int kW, int kH, int dW, int dH, int padW, int padH) {
        int nSlices = inputTensor.size(3);
        int iHeight = inputTensor.size(1);
        int iWidth = inputTensor.size(2);
        double[] input = (double[])inputTensor.storage().array();
        int inputOffset = inputTensor.storageOffset() - 1;
        double[] output = (double[])outputTensor.storage().array();
        int outputOffset = outputTensor.storageOffset() - 1;
        double[] indices = (double[])indicesTensor.storage().array();
        int indicesOffset = indicesTensor.storageOffset() - 1;
        for (int i = 0; i < oHeight; ++i) {
            int hstart = i * dH - padH;
            int hend = package$.MODULE$.min(hstart + kH, iHeight);
            hstart = package$.MODULE$.max(hstart, 0);
            for (int j = 0; j < oWidth; ++j) {
                int wstart = j * dW - padW;
                int wend = package$.MODULE$.min(wstart + kW, iWidth);
                wstart = package$.MODULE$.max(wstart, 0);
                int currOutLocStart = outputOffset + (i * oWidth + j) * nSlices;
                int currOutLocEnd = currOutLocStart + nSlices;
                int currIndicesLocStart = indicesOffset + (i * oWidth + j) * nSlices;
                int currIndicesLocEnd = currIndicesLocStart + nSlices;
                Arrays.fill(output, currOutLocStart, currOutLocEnd, Double$.MODULE$.MinValue());
                Arrays.fill(indices, currIndicesLocStart, currIndicesLocEnd, 0.0);
                for (int y = hstart; y < hend; ++y) {
                    for (int x = wstart; x < wend; ++x) {
                        int tcntr = y * iWidth + x;
                        int currInLocStart = inputOffset + tcntr * nSlices;
                        for (int n = 0; n < nSlices; ++n) {
                            double value2 = input[currInLocStart + n];
                            if (!(value2 > output[currOutLocStart + n])) continue;
                            output[currOutLocStart + n] = value2;
                            indices[currOutLocStart + n] = tcntr + 1;
                        }
                    }
                }
            }
        }
    }

    public void maxPoolingForwardFloatNHWC(Tensor<Object> inputTensor, Tensor<Object> outputTensor, Tensor<Object> indicesTensor, int oWidth, int oHeight, int kW, int kH, int dW, int dH, int padW, int padH) {
        int nSlices = inputTensor.size(3);
        int iHeight = inputTensor.size(1);
        int iWidth = inputTensor.size(2);
        float[] input = (float[])inputTensor.storage().array();
        int inputOffset = inputTensor.storageOffset() - 1;
        float[] output = (float[])outputTensor.storage().array();
        int outputOffset = outputTensor.storageOffset() - 1;
        float[] indices = (float[])indicesTensor.storage().array();
        int indicesOffset = indicesTensor.storageOffset() - 1;
        for (int i = 0; i < oHeight; ++i) {
            int hstart = i * dH - padH;
            int hend = package$.MODULE$.min(hstart + kH, iHeight);
            hstart = package$.MODULE$.max(hstart, 0);
            for (int j = 0; j < oWidth; ++j) {
                int wstart = j * dW - padW;
                int wend = package$.MODULE$.min(wstart + kW, iWidth);
                wstart = package$.MODULE$.max(wstart, 0);
                int currOutLocStart = outputOffset + (i * oWidth + j) * nSlices;
                int currOutLocEnd = currOutLocStart + nSlices;
                int currIndicesLocStart = indicesOffset + (i * oWidth + j) * nSlices;
                int currIndicesLocEnd = currIndicesLocStart + nSlices;
                Arrays.fill(output, currOutLocStart, currOutLocEnd, Float$.MODULE$.MinValue());
                Arrays.fill(indices, currIndicesLocStart, currIndicesLocEnd, 0.0f);
                for (int y = hstart; y < hend; ++y) {
                    for (int x = wstart; x < wend; ++x) {
                        int tcntr = y * iWidth + x;
                        int currInLocStart = inputOffset + tcntr * nSlices;
                        for (int n = 0; n < nSlices; ++n) {
                            float value2 = input[currInLocStart + n];
                            if (!(value2 > output[currOutLocStart + n])) continue;
                            output[currOutLocStart + n] = value2;
                            indices[currOutLocStart + n] = tcntr + 1;
                        }
                    }
                }
            }
        }
    }

    public void maxPoolingBackwardDoubleNHWC(Tensor<Object> gradInputTensor, Tensor<Object> gradOutputTensor, Tensor<Object> indicesTensor, int oWidth, int oHeight) {
        int nSlices = gradInputTensor.size(3);
        int iHeight = gradInputTensor.size(1);
        int iWidth = gradInputTensor.size(2);
        double[] gradInput = (double[])gradInputTensor.storage().array();
        int gradInputOffset = gradInputTensor.storageOffset() - 1;
        double[] gradOutput = (double[])gradOutputTensor.storage().array();
        int gradOutputOffset = gradOutputTensor.storageOffset() - 1;
        double[] indices = (double[])indicesTensor.storage().array();
        int indicesOffset = indicesTensor.storageOffset() - 1;
        for (int i = 0; i < oHeight; ++i) {
            for (int j = 0; j < oWidth; ++j) {
                int currOutLocStart = gradOutputOffset + (i * oWidth + j) * nSlices;
                int currIndicesLocStart = indicesOffset + (i * oWidth + j) * nSlices;
                for (int n = 0; n < nSlices; ++n) {
                    int maxIndex = (int)indices[currIndicesLocStart + n] - 1;
                    double grad = gradOutput[currOutLocStart + n];
                    int n2 = gradInputOffset + maxIndex * nSlices + n;
                    gradInput[n2] = gradInput[n2] + grad;
                }
            }
        }
    }

    public void maxPoolingBackwardFloatNHWC(Tensor<Object> gradInputTensor, Tensor<Object> gradOutputTensor, Tensor<Object> indicesTensor, int oWidth, int oHeight) {
        int nSlices = gradInputTensor.size(3);
        int iHeight = gradInputTensor.size(1);
        int iWidth = gradInputTensor.size(2);
        float[] gradInput = (float[])gradInputTensor.storage().array();
        int gradInputOffset = gradInputTensor.storageOffset() - 1;
        float[] gradOutput = (float[])gradOutputTensor.storage().array();
        int gradOutputOffset = gradOutputTensor.storageOffset() - 1;
        float[] indices = (float[])indicesTensor.storage().array();
        int indicesOffset = indicesTensor.storageOffset() - 1;
        for (int i = 0; i < oHeight; ++i) {
            for (int j = 0; j < oWidth; ++j) {
                int currOutLocStart = gradOutputOffset + (i * oWidth + j) * nSlices;
                int currIndicesLocStart = indicesOffset + (i * oWidth + j) * nSlices;
                for (int n = 0; n < nSlices; ++n) {
                    int maxIndex = (int)indices[currIndicesLocStart + n] - 1;
                    float grad = gradOutput[currOutLocStart + n];
                    int n2 = gradInputOffset + maxIndex * nSlices + n;
                    gradInput[n2] = gradInput[n2] + grad;
                }
            }
        }
    }

    public void temporalMaxPoolingBackwardDouble(double[] gradInput, int gradInputOffset, double[] gradOutput, int gradOutputOffset, double[] indices, int indicesOffset, int nSlices, int frameSize, int kW, int dW) {
        scala.package$.MODULE$.Range().apply(0, nSlices).foreach$mVc$sp((Function1)new Serializable(gradInput, gradInputOffset, gradOutput, gradOutputOffset, indices, indicesOffset, frameSize, dW){
            public static final long serialVersionUID = 0L;
            private final double[] gradInput$1;
            private final int gradInputOffset$1;
            private final double[] gradOutput$1;
            private final int gradOutputOffset$1;
            private final double[] indices$1;
            private final int indicesOffset$1;
            private final int frameSize$1;
            private final int dW$1;

            public final void apply(int t2) {
                this.apply$mcVI$sp(t2);
            }

            public void apply$mcVI$sp(int t2) {
                int gip = this.gradInputOffset$1 + t2 * this.frameSize$1 * this.dW$1;
                int gop = this.gradOutputOffset$1 + t2 * this.frameSize$1;
                int xp = this.indicesOffset$1 + t2 * this.frameSize$1;
                for (int y = 0; y < this.frameSize$1; ++y) {
                    int maxIndex = (int)this.indices$1[xp + y] - 1;
                    if (maxIndex == -1) continue;
                    int n = gip + maxIndex * this.frameSize$1 + y;
                    this.gradInput$1[n] = this.gradInput$1[n] + this.gradOutput$1[gop + y];
                }
            }
            {
                this.gradInput$1 = gradInput$1;
                this.gradInputOffset$1 = gradInputOffset$1;
                this.gradOutput$1 = gradOutput$1;
                this.gradOutputOffset$1 = gradOutputOffset$1;
                this.indices$1 = indices$1;
                this.indicesOffset$1 = indicesOffset$1;
                this.frameSize$1 = frameSize$1;
                this.dW$1 = dW$1;
            }
        });
    }

    public void temporalMaxPoolingBackwardFloat(float[] gradInput, int gradInputOffset, float[] gradOutput, int gradOutputOffset, float[] indices, int indicesOffset, int nSlices, int frameSize, int kW, int dW) {
        scala.package$.MODULE$.Range().apply(0, nSlices).foreach$mVc$sp((Function1)new Serializable(gradInput, gradInputOffset, gradOutput, gradOutputOffset, indices, indicesOffset, frameSize, dW){
            public static final long serialVersionUID = 0L;
            private final float[] gradInput$2;
            private final int gradInputOffset$2;
            private final float[] gradOutput$2;
            private final int gradOutputOffset$2;
            private final float[] indices$2;
            private final int indicesOffset$2;
            private final int frameSize$2;
            private final int dW$2;

            public final void apply(int t2) {
                this.apply$mcVI$sp(t2);
            }

            public void apply$mcVI$sp(int t2) {
                int gip = this.gradInputOffset$2 + t2 * this.frameSize$2 * this.dW$2;
                int gop = this.gradOutputOffset$2 + t2 * this.frameSize$2;
                int xp = this.indicesOffset$2 + t2 * this.frameSize$2;
                for (int y = 0; y < this.frameSize$2; ++y) {
                    int maxIndex = (int)this.indices$2[xp + y] - 1;
                    if (maxIndex == -1) continue;
                    int n = gip + maxIndex * this.frameSize$2 + y;
                    this.gradInput$2[n] = this.gradInput$2[n] + this.gradOutput$2[gop + y];
                }
            }
            {
                this.gradInput$2 = gradInput$2;
                this.gradInputOffset$2 = gradInputOffset$2;
                this.gradOutput$2 = gradOutput$2;
                this.gradOutputOffset$2 = gradOutputOffset$2;
                this.indices$2 = indices$2;
                this.indicesOffset$2 = indicesOffset$2;
                this.frameSize$2 = frameSize$2;
                this.dW$2 = dW$2;
            }
        });
    }

    public void temporalMaxPoolingForwardDouble(double[] input, int inputOffset, double[] output, int outputOffset, double[] indices, int indicesOffset, int nSlices, int frameSize, int kW, int dW) {
        Iterator slices = scala.package$.MODULE$.Range().apply(0, nSlices).iterator();
        while (slices.hasNext()) {
            int t2 = BoxesRunTime.unboxToInt((Object)slices.next());
            int ip = inputOffset + t2 * frameSize * dW;
            int op = outputOffset + t2 * frameSize;
            int xp = indicesOffset + t2 * frameSize;
            for (int y = 0; y < frameSize; ++y) {
                int maxindex = 0;
                double maxval = Double$.MODULE$.MinValue();
                for (int x = 0; x < kW; ++x) {
                    double value2 = input[ip + x * frameSize + y];
                    if (!(value2 > maxval)) continue;
                    maxval = value2;
                    maxindex = x;
                }
                output[op + y] = maxval;
                indices[xp + y] = maxindex + 1;
            }
        }
    }

    public void temporalMaxPoolingForwardFloat(float[] input, int inputOffset, float[] output, int outputOffset, float[] indices, int indicesOffset, int nSlices, int frameSize, int kW, int dW) {
        Iterator slices = scala.package$.MODULE$.Range().apply(0, nSlices).iterator();
        while (slices.hasNext()) {
            int t2 = BoxesRunTime.unboxToInt((Object)slices.next());
            int ip = inputOffset + t2 * frameSize * dW;
            int op = outputOffset + t2 * frameSize;
            int xp = indicesOffset + t2 * frameSize;
            for (int y = 0; y < frameSize; ++y) {
                int maxindex = 0;
                float maxval = Float$.MODULE$.MinValue();
                for (int x = 0; x < kW; ++x) {
                    float value2 = input[ip + x * frameSize + y];
                    if (!(value2 > maxval)) continue;
                    maxval = value2;
                    maxindex = x;
                }
                output[op + y] = maxval;
                indices[xp + y] = maxindex + 1;
            }
        }
    }

    public void col2imWithDilationDouble(Tensor<Object> columns, Tensor<Object> image, int channels, int height, int width, int kernelH, int kernelW, int padH, int padW, int strideH, int strideW, int dilationH, int dilationW) {
        double[] dataIm = (double[])image.storage().array();
        int dataImOffset = image.storageOffset() - 1;
        double[] dataCol = (double[])columns.storage().array();
        int dataColOffset = columns.storageOffset() - 1;
        int heightCol = (height + 2 * padH - (dilationH * (kernelH - 1) + 1)) / strideH + 1;
        int widthCol = (width + 2 * padW - (dilationW * (kernelW - 1) + 1)) / strideW + 1;
        int channelsCol = channels * kernelH * kernelW;
        for (int cCol = 0; cCol < channelsCol; ++cCol) {
            int wOffset = cCol % kernelW;
            int hOffset = cCol / kernelW % kernelH;
            int cIm = cCol / kernelH / kernelW;
            for (int hCol = 0; hCol < heightCol; ++hCol) {
                for (int wCol = 0; wCol < widthCol; ++wCol) {
                    int hIm = hCol * strideH - padH + hOffset * dilationH;
                    int wIm = wCol * strideW - padW + wOffset * dilationW;
                    if (hIm < 0 || hIm >= height || wIm < 0 || wIm >= width) continue;
                    int n = (cIm * height + hIm) * width + wIm + dataImOffset;
                    dataIm[n] = dataIm[n] + dataCol[(cCol * heightCol + hCol) * widthCol + wCol + dataColOffset];
                }
            }
        }
    }

    public void col2imWithDilationFloat(Tensor<Object> columns, Tensor<Object> image, int channels, int height, int width, int kernelH, int kernelW, int padH, int padW, int strideH, int strideW, int dilationH, int dilationW) {
        float[] dataIm = (float[])image.storage().array();
        int dataImOffset = image.storageOffset() - 1;
        float[] dataCol = (float[])columns.storage().array();
        int dataColOffset = columns.storageOffset() - 1;
        int heightCol = (height + 2 * padH - (dilationH * (kernelH - 1) + 1)) / strideH + 1;
        int widthCol = (width + 2 * padW - (dilationW * (kernelW - 1) + 1)) / strideW + 1;
        int channelsCol = channels * kernelH * kernelW;
        for (int cCol = 0; cCol < channelsCol; ++cCol) {
            int wOffset = cCol % kernelW;
            int hOffset = cCol / kernelW % kernelH;
            int cIm = cCol / kernelH / kernelW;
            for (int hCol = 0; hCol < heightCol; ++hCol) {
                for (int wCol = 0; wCol < widthCol; ++wCol) {
                    int hIm = hCol * strideH - padH + hOffset * dilationH;
                    int wIm = wCol * strideW - padW + wOffset * dilationW;
                    if (hIm < 0 || hIm >= height || wIm < 0 || wIm >= width) continue;
                    int n = (cIm * height + hIm) * width + wIm + dataImOffset;
                    dataIm[n] = dataIm[n] + dataCol[(cCol * heightCol + hCol) * widthCol + wCol + dataColOffset];
                }
            }
        }
    }

    public void im2colWithDilationDouble(Tensor<Object> image, Tensor<Object> columns, int channels, int height, int width, int kernelH, int kernelW, int padH, int padW, int strideH, int strideW, int dilationH, int dilationW) {
        double[] dataIm = (double[])image.storage().array();
        int dataImOffset = image.storageOffset() - 1;
        double[] dataCol = (double[])columns.storage().array();
        int dataColOffset = columns.storageOffset() - 1;
        int heightCol = (height + 2 * padH - (dilationH * (kernelH - 1) + 1)) / strideH + 1;
        int widthCol = (width + 2 * padW - (dilationW * (kernelW - 1) + 1)) / strideW + 1;
        int channelsCol = channels * kernelH * kernelW;
        for (int cCol = 0; cCol < channelsCol; ++cCol) {
            int wOffset = cCol % kernelW;
            int hOffset = cCol / kernelW % kernelH;
            int cIm = cCol / kernelH / kernelW;
            for (int hCol = 0; hCol < heightCol; ++hCol) {
                for (int wCol = 0; wCol < widthCol; ++wCol) {
                    int hIm = hCol * strideH - padH + hOffset * dilationH;
                    int wIm = wCol * strideW - padW + wOffset * dilationW;
                    dataCol[(cCol * heightCol + hCol) * widthCol + wCol + dataColOffset] = hIm >= 0 && wIm >= 0 && hIm < height && wIm < width ? dataIm[(cIm * height + hIm) * width + wIm + dataImOffset] : 0.0;
                }
            }
        }
    }

    public void im2colWithDilationFloat(Tensor<Object> image, Tensor<Object> columns, int channels, int height, int width, int kernelH, int kernelW, int padH, int padW, int strideH, int strideW, int dilationH, int dilationW) {
        float[] dataIm = (float[])image.storage().array();
        int dataImOffset = image.storageOffset() - 1;
        float[] dataCol = (float[])columns.storage().array();
        int dataColOffset = columns.storageOffset() - 1;
        int heightCol = (height + 2 * padH - (dilationH * (kernelH - 1) + 1)) / strideH + 1;
        int widthCol = (width + 2 * padW - (dilationW * (kernelW - 1) + 1)) / strideW + 1;
        int channelsCol = channels * kernelH * kernelW;
        for (int cCol = 0; cCol < channelsCol; ++cCol) {
            int wOffset = cCol % kernelW;
            int hOffset = cCol / kernelW % kernelH;
            int cIm = cCol / kernelH / kernelW;
            for (int hCol = 0; hCol < heightCol; ++hCol) {
                for (int wCol = 0; wCol < widthCol; ++wCol) {
                    int hIm = hCol * strideH - padH + hOffset * dilationH;
                    int wIm = wCol * strideW - padW + wOffset * dilationW;
                    dataCol[(cCol * heightCol + hCol) * widthCol + wCol + dataColOffset] = hIm >= 0 && wIm >= 0 && hIm < height && wIm < width ? dataIm[(cIm * height + hIm) * width + wIm + dataImOffset] : 0.0f;
                }
            }
        }
    }

    public void unfoldedCopyVolDouble(Tensor<Object> fInput, Tensor<Object> input, int kT, int kW, int kH, int dT, int dW, int dH, int padFront, int padLeft, int padTop, int padBack, int padRight, int padBottom, int nInputPlane, int inputDepth, int inputWidth, int inputHeight, int outputDepth, int outputWidth, int outputHeight) {
        double[] inputData = (double[])input.storage().array();
        double[] fInputData = (double[])fInput.storage().array();
        for (int k = 0; k < nInputPlane * kT * kH * kW; ++k) {
            int nip = k / (kT * kH * kW);
            int rest = k % (kT * kH * kW);
            int kt = rest / (kH * kW);
            int kh = (rest %= kH * kW) / kW;
            int kw = rest % kW;
            int t2 = 0;
            int x = 0;
            int y = 0;
            int it = 0;
            int ix = 0;
            int iy = 0;
            int dstOffset = nip * (kT * kH * kW * outputDepth * outputHeight * outputWidth) + kt * (kH * kW * outputDepth * outputHeight * outputWidth) + kh * (kW * outputDepth * outputHeight * outputWidth) + kw * (outputDepth * outputHeight * outputWidth) + fInput.storageOffset() - 1;
            int srcOffset = nip * (inputDepth * inputHeight * inputWidth) + input.storageOffset() - 1;
            if (padFront > 0 || padBack > 0 || padLeft > 0 || padRight > 0 || padBottom > 0 || padTop > 0) {
                for (t2 = 0; t2 < outputDepth; ++t2) {
                    it = t2 * dT - padFront + kt;
                    for (int y2 = 0; y2 < outputHeight; ++y2) {
                        iy = y2 * dH - padTop + kh;
                        for (x = 0; x < outputWidth; ++x) {
                            ix = x * dW - padLeft + kw;
                            fInputData[dstOffset + t2 * outputHeight * outputWidth + y2 * outputWidth + x] = it < 0 || it >= inputDepth || iy < 0 || iy >= inputHeight || ix < 0 || ix >= inputWidth ? 0.0 : inputData[srcOffset + it * inputHeight * inputWidth + iy * inputWidth + ix];
                        }
                    }
                }
                continue;
            }
            for (t2 = 0; t2 < outputDepth; ++t2) {
                it = t2 * dT + kt;
                for (y = 0; y < outputHeight; ++y) {
                    iy = y * dH + kh;
                    for (x = 0; x < outputWidth; ++x) {
                        ix = x * dW + kw;
                        fInputData[dstOffset + t2 * outputHeight * outputWidth + y * outputWidth + x] = inputData[srcOffset + it * inputHeight * inputWidth + iy * inputWidth + ix];
                    }
                }
            }
        }
    }

    public void unfoldedCopyVolFloat(Tensor<Object> fInput, Tensor<Object> input, int kT, int kW, int kH, int dT, int dW, int dH, int padFront, int padLeft, int padTop, int padBack, int padRight, int padBottom, int nInputPlane, int inputDepth, int inputWidth, int inputHeight, int outputDepth, int outputWidth, int outputHeight) {
        float[] inputData = (float[])input.storage().array();
        float[] fInputData = (float[])fInput.storage().array();
        for (int k = 0; k < nInputPlane * kT * kH * kW; ++k) {
            int nip = k / (kT * kH * kW);
            int rest = k % (kT * kH * kW);
            int kt = rest / (kH * kW);
            int kh = (rest %= kH * kW) / kW;
            int kw = rest % kW;
            int t2 = 0;
            int x = 0;
            int y = 0;
            int it = 0;
            int ix = 0;
            int iy = 0;
            int dstOffset = nip * (kT * kH * kW * outputDepth * outputHeight * outputWidth) + kt * (kH * kW * outputDepth * outputHeight * outputWidth) + kh * (kW * outputDepth * outputHeight * outputWidth) + kw * (outputDepth * outputHeight * outputWidth) + fInput.storageOffset() - 1;
            int srcOffset = nip * (inputDepth * inputHeight * inputWidth) + input.storageOffset() - 1;
            if (padFront > 0 || padLeft > 0 || padTop > 0 || padBack > 0 || padRight > 0 || padBottom > 0) {
                for (t2 = 0; t2 < outputDepth; ++t2) {
                    it = t2 * dT - padFront + kt;
                    for (int y2 = 0; y2 < outputHeight; ++y2) {
                        iy = y2 * dH - padTop + kh;
                        for (x = 0; x < outputWidth; ++x) {
                            ix = x * dW - padLeft + kw;
                            fInputData[dstOffset + t2 * outputHeight * outputWidth + y2 * outputWidth + x] = it < 0 || it >= inputDepth || iy < 0 || iy >= inputHeight || ix < 0 || ix >= inputWidth ? 0.0f : inputData[srcOffset + it * inputHeight * inputWidth + iy * inputWidth + ix];
                        }
                    }
                }
                continue;
            }
            for (t2 = 0; t2 < outputDepth; ++t2) {
                it = t2 * dT + kt;
                for (y = 0; y < outputHeight; ++y) {
                    iy = y * dH + kh;
                    for (x = 0; x < outputWidth; ++x) {
                        ix = x * dW + kw;
                        fInputData[dstOffset + t2 * outputHeight * outputWidth + y * outputWidth + x] = inputData[srcOffset + it * inputHeight * inputWidth + iy * inputWidth + ix];
                    }
                }
            }
        }
    }

    public void unfoldedAccVolDouble(Tensor<Object> fInput, Tensor<Object> input, int kT, int kW, int kH, int dT, int dW, int dH, int padFront, int padLeft, int padTop, int padBack, int padRight, int padBottom, int nInputPlane, int inputDepth, int inputWidth, int inputHeight, int outputDepth, int outputWidth, int outputHeight) {
        int nip = 0;
        int kt = 0;
        int kw = 0;
        int kh = 0;
        int t2 = 0;
        int y = 0;
        int x = 0;
        int it = 0;
        int ix = 0;
        int iy = 0;
        double[] inputData = (double[])input.storage().array();
        double[] fInputData = (double[])fInput.storage().array();
        for (nip = 0; nip < nInputPlane; ++nip) {
            for (kt = 0; kt < kT; ++kt) {
                for (kh = 0; kh < kH; ++kh) {
                    for (kw = 0; kw < kW; ++kw) {
                        int srcOffset = nip * (kT * kH * kW * outputDepth * outputHeight * outputWidth) + kt * (kH * kW * outputDepth * outputHeight * outputWidth) + kh * (kW * outputDepth * outputHeight * outputWidth) + kw * (outputDepth * outputHeight * outputWidth) + fInput.storageOffset() - 1;
                        int dstOffset = nip * (inputDepth * inputHeight * inputWidth) + input.storageOffset() - 1;
                        if (padFront > 0 || padLeft > 0 || padTop > 0 || padBack > 0 || padRight > 0 || padBottom > 0) {
                            for (t2 = 0; t2 < outputDepth; ++t2) {
                                it = t2 * dT - padFront + kt;
                                for (y = 0; y < outputHeight; ++y) {
                                    iy = y * dH - padTop + kh;
                                    for (x = 0; x < outputWidth; ++x) {
                                        ix = x * dW - padLeft + kw;
                                        if (it < 0 || it >= inputDepth || iy < 0 || iy >= inputHeight || ix < 0 || ix >= inputWidth) continue;
                                        int n = dstOffset + it * inputHeight * inputWidth + iy * inputWidth + ix;
                                        inputData[n] = inputData[n] + fInputData[srcOffset + t2 * outputHeight * outputWidth + y * outputWidth + x];
                                    }
                                }
                            }
                            continue;
                        }
                        for (t2 = 0; t2 < outputDepth; ++t2) {
                            it = t2 * dT + kt;
                            for (y = 0; y < outputHeight; ++y) {
                                iy = y * dH + kh;
                                for (x = 0; x < outputWidth; ++x) {
                                    ix = x * dW + kw;
                                    int n = dstOffset + it * inputHeight * inputWidth + iy * inputWidth + ix;
                                    inputData[n] = inputData[n] + fInputData[srcOffset + t2 * outputHeight * outputWidth + y * outputWidth + x];
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void unfoldedAccVolFloat(Tensor<Object> fInput, Tensor<Object> input, int kT, int kW, int kH, int dT, int dW, int dH, int padFront, int padLeft, int padTop, int padBack, int padRight, int padBottom, int nInputPlane, int inputDepth, int inputWidth, int inputHeight, int outputDepth, int outputWidth, int outputHeight) {
        int nip = 0;
        int kt = 0;
        int kw = 0;
        int kh = 0;
        int t2 = 0;
        int y = 0;
        int x = 0;
        int it = 0;
        int ix = 0;
        int iy = 0;
        float[] inputData = (float[])input.storage().array();
        float[] fInputData = (float[])fInput.storage().array();
        for (nip = 0; nip < nInputPlane; ++nip) {
            for (kt = 0; kt < kT; ++kt) {
                for (kh = 0; kh < kH; ++kh) {
                    for (kw = 0; kw < kW; ++kw) {
                        int srcOffset = nip * (kT * kH * kW * outputDepth * outputHeight * outputWidth) + kt * (kH * kW * outputDepth * outputHeight * outputWidth) + kh * (kW * outputDepth * outputHeight * outputWidth) + kw * (outputDepth * outputHeight * outputWidth) + fInput.storageOffset() - 1;
                        int dstOffset = nip * (inputDepth * inputHeight * inputWidth) + input.storageOffset() - 1;
                        if (padFront > 0 || padLeft > 0 || padTop > 0 || padBack > 0 || padRight > 0 || padBottom > 0) {
                            for (t2 = 0; t2 < outputDepth; ++t2) {
                                it = t2 * dT - padFront + kt;
                                for (y = 0; y < outputHeight; ++y) {
                                    iy = y * dH - padTop + kh;
                                    for (x = 0; x < outputWidth; ++x) {
                                        ix = x * dW - padLeft + kw;
                                        if (it < 0 || it >= inputDepth || iy < 0 || iy >= inputHeight || ix < 0 || ix >= inputWidth) continue;
                                        int n = dstOffset + it * inputHeight * inputWidth + iy * inputWidth + ix;
                                        inputData[n] = inputData[n] + fInputData[srcOffset + t2 * outputHeight * outputWidth + y * outputWidth + x];
                                    }
                                }
                            }
                            continue;
                        }
                        for (t2 = 0; t2 < outputDepth; ++t2) {
                            it = t2 * dT + kt;
                            for (y = 0; y < outputHeight; ++y) {
                                iy = y * dH + kh;
                                for (x = 0; x < outputWidth; ++x) {
                                    ix = x * dW + kw;
                                    int n = dstOffset + it * inputHeight * inputWidth + iy * inputWidth + ix;
                                    inputData[n] = inputData[n] + fInputData[srcOffset + t2 * outputHeight * outputWidth + y * outputWidth + x];
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void vol2colDouble(Tensor<Object> vol, int channels, int depth, int height, int width, int kT, int kH, int kW, int pT, int pH, int pW, int dT, int dH, int dW, int dilationT, int dilationH, int dilationW, Tensor<Object> col) {
        double[] colData = (double[])col.storage().array();
        int colDataOffset = col.storageOffset() - 1;
        double[] volData = (double[])vol.storage().array();
        int volDataOffset = vol.storageOffset() - 1;
        int depthCol = (depth + 2 * pT - (dilationT * (kT - 1) + 1)) / dT + 1;
        int widthCol = (width + 2 * pW - (dilationW * (kW - 1) + 1)) / dW + 1;
        int heightCol = (height + 2 * pH - (dilationH * (kH - 1) + 1)) / dH + 1;
        int channelsCol = channels * kT * kW * kH;
        for (int c = 0; c < channelsCol; ++c) {
            int wOffset = c % kW;
            int hOffset = c / kW % kH;
            int tOffset = c / kW / kH % kT;
            int cVol = c / kT / kH / kW;
            for (int t2 = 0; t2 < depthCol; ++t2) {
                for (int h2 = 0; h2 < heightCol; ++h2) {
                    for (int w = 0; w < widthCol; ++w) {
                        int tPad = t2 * dT - pT + tOffset * dilationT;
                        int hPad = h2 * dH - pH + hOffset * dilationH;
                        int wPad = w * dW - pW + wOffset * dilationW;
                        colData[((c * depthCol + t2) * heightCol + h2) * widthCol + w + colDataOffset] = tPad >= 0 && tPad < depth && hPad >= 0 && hPad < height && wPad >= 0 && wPad < width ? volData[((cVol * depth + tPad) * height + hPad) * width + wPad + volDataOffset] : 0.0;
                    }
                }
            }
        }
    }

    public void vol2colFloat(Tensor<Object> vol, int channels, int depth, int height, int width, int kT, int kH, int kW, int pT, int pH, int pW, int dT, int dH, int dW, int dilationT, int dilationH, int dilationW, Tensor<Object> col) {
        float[] colData = (float[])col.storage().array();
        int colDataOffset = col.storageOffset() - 1;
        float[] volData = (float[])vol.storage().array();
        int volDataOffset = vol.storageOffset() - 1;
        int depthCol = (depth + 2 * pT - (dilationT * (kT - 1) + 1)) / dT + 1;
        int widthCol = (width + 2 * pW - (dilationW * (kW - 1) + 1)) / dW + 1;
        int heightCol = (height + 2 * pH - (dilationH * (kH - 1) + 1)) / dH + 1;
        int channelsCol = channels * kT * kW * kH;
        for (int c = 0; c < channelsCol; ++c) {
            int wOffset = c % kW;
            int hOffset = c / kW % kH;
            int tOffset = c / kW / kH % kT;
            int cVol = c / kT / kH / kW;
            for (int t2 = 0; t2 < depthCol; ++t2) {
                for (int h2 = 0; h2 < heightCol; ++h2) {
                    for (int w = 0; w < widthCol; ++w) {
                        int tPad = t2 * dT - pT + tOffset * dilationT;
                        int hPad = h2 * dH - pH + hOffset * dilationH;
                        int wPad = w * dW - pW + wOffset * dilationW;
                        colData[((c * depthCol + t2) * heightCol + h2) * widthCol + w + colDataOffset] = tPad >= 0 && tPad < depth && hPad >= 0 && hPad < height && wPad >= 0 && wPad < width ? volData[((cVol * depth + tPad) * height + hPad) * width + wPad + volDataOffset] : 0.0f;
                    }
                }
            }
        }
    }

    public void col2volDouble(Tensor<Object> col, int channels, int depth, int height, int width, int kT, int kH, int kW, int pT, int pH, int pW, int dT, int dH, int dW, int dilationT, int dilationH, int dilationW, Tensor<Object> vol) {
        double[] colData = (double[])col.storage().array();
        int colDataOffset = col.storageOffset() - 1;
        double[] volData = (double[])vol.storage().array();
        int volDataOffset = vol.storageOffset() - 1;
        int depthCol = (depth + 2 * pT - (dilationT * (kT - 1) + 1)) / dT + 1;
        int heightCol = (height + 2 * pH - (dilationH * (kH - 1) + 1)) / dH + 1;
        int widthCol = (width + 2 * pW - (dilationW * (kW - 1) + 1)) / dW + 1;
        int channelsCol = channels * kT * kW * kH;
        for (int c = 0; c < channelsCol; ++c) {
            int wOffset = c % kW;
            int hOffset = c / kW % kH;
            int tOffset = c / kW / kH % kT;
            int cVol = c / kT / kH / kW;
            for (int t2 = 0; t2 < depthCol; ++t2) {
                for (int h2 = 0; h2 < heightCol; ++h2) {
                    for (int w = 0; w < widthCol; ++w) {
                        int tPad = t2 * dT - pT + tOffset * dilationT;
                        int hPad = h2 * dH - pH + hOffset * dilationH;
                        int wPad = w * dW - pW + wOffset * dilationW;
                        if (tPad < 0 || tPad >= depth || hPad < 0 || hPad >= height || wPad < 0 || wPad >= width) continue;
                        int n = ((cVol * depth + tPad) * height + hPad) * width + wPad + volDataOffset;
                        volData[n] = volData[n] + colData[((c * depthCol + t2) * heightCol + h2) * widthCol + w + colDataOffset];
                    }
                }
            }
        }
    }

    public void col2volFloat(Tensor<Object> col, int channels, int depth, int width, int height, int kT, int kW, int kH, int pT, int pW, int pH, int dT, int dW, int dH, int dilationT, int dilationW, int dilationH, Tensor<Object> vol) {
        float[] colData = (float[])col.storage().array();
        int colDataOffset = col.storageOffset() - 1;
        float[] volData = (float[])vol.storage().array();
        int volDataOffset = vol.storageOffset() - 1;
        int depthCol = (depth + 2 * pT - (dilationT * (kT - 1) + 1)) / dT + 1;
        int heightCol = (height + 2 * pH - (dilationH * (kH - 1) + 1)) / dH + 1;
        int widthCol = (width + 2 * pW - (dilationW * (kW - 1) + 1)) / dW + 1;
        int channelsCol = channels * kT * kW * kH;
        for (int c = 0; c < channelsCol; ++c) {
            int wOffset = c % kW;
            int hOffset = c / kW % kH;
            int tOffset = c / kW / kH % kT;
            int cVol = c / kT / kH / kW;
            for (int t2 = 0; t2 < depthCol; ++t2) {
                for (int h2 = 0; h2 < heightCol; ++h2) {
                    for (int w = 0; w < widthCol; ++w) {
                        int tPad = t2 * dT - pT + tOffset * dilationT;
                        int hPad = h2 * dH - pH + hOffset * dilationH;
                        int wPad = w * dW - pW + wOffset * dilationW;
                        if (tPad < 0 || tPad >= depth || hPad < 0 || hPad >= height || wPad < 0 || wPad >= width) continue;
                        int n = ((cVol * depth + tPad) * height + hPad) * width + wPad + volDataOffset;
                        volData[n] = volData[n] + colData[((c * depthCol + t2) * heightCol + h2) * widthCol + w + colDataOffset];
                    }
                }
            }
        }
    }

    private NNPrimitive$() {
        MODULE$ = this;
    }
}

