/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.nn;

import breeze.generic.UFunc;
import breeze.numerics.package;
import com.intel.analytics.bigdl.dllib.nn.ErrorInfo$;
import com.intel.analytics.bigdl.dllib.nn.InitializationMethod;
import com.intel.analytics.bigdl.dllib.nn.LookupTable$;
import com.intel.analytics.bigdl.dllib.nn.RandomNormal;
import com.intel.analytics.bigdl.dllib.nn.VariableFormat$Default$;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.Initializable;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.Initializable$class;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.TensorModule;
import com.intel.analytics.bigdl.dllib.optim.Regularizer;
import com.intel.analytics.bigdl.dllib.tensor.ConvertableFrom$ConvertableFromDouble$;
import com.intel.analytics.bigdl.dllib.tensor.ConvertableFrom$ConvertableFromInt$;
import com.intel.analytics.bigdl.dllib.tensor.ConvertableTo$ConvertableToDouble$;
import com.intel.analytics.bigdl.dllib.tensor.ConvertableTo$ConvertableToInt$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorMath;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.Shape;
import com.intel.analytics.bigdl.dllib.utils.Shape$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.util.Sorting$;

@ScalaSignature(bytes="\u0006\u0001\r=d\u0001B\u0001\u0003\u0001=\u00111\u0002T8pWV\u0004H+\u00192mK*\u00111\u0001B\u0001\u0003]:T!!\u0002\u0004\u0002\u000b\u0011dG.\u001b2\u000b\u0005\u001dA\u0011!\u00022jO\u0012d'BA\u0005\u000b\u0003%\tg.\u00197zi&\u001c7O\u0003\u0002\f\u0019\u0005)\u0011N\u001c;fY*\tQ\"A\u0002d_6\u001c\u0001!\u0006\u0002\u00113M\u0019\u0001!E\u0013\u0011\u0007I)r#D\u0001\u0014\u0015\t!\"!\u0001\u0006bEN$(/Y2u]:L!AF\n\u0003\u0019Q+gn]8s\u001b>$W\u000f\\3\u0011\u0005aIB\u0002\u0001\u0003\u00065\u0001\u0011\ra\u0007\u0002\u0002)F\u0011AD\t\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\b\u001d>$\b.\u001b8h!\ti2%\u0003\u0002%=\t\u0019\u0011I\\=\u0011\u0005I1\u0013BA\u0014\u0014\u00055Ie.\u001b;jC2L'0\u00192mK\"A\u0011\u0006\u0001BC\u0002\u0013\u0005!&\u0001\u0004o\u0013:$W\r_\u000b\u0002WA\u0011Q\u0004L\u0005\u0003[y\u00111!\u00138u\u0011!y\u0003A!A!\u0002\u0013Y\u0013a\u00028J]\u0012,\u0007\u0010\t\u0005\tc\u0001\u0011)\u0019!C\u0001U\u00059anT;uaV$\b\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u00119|U\u000f\u001e9vi\u0002B\u0001\"\u000e\u0001\u0003\u0006\u0004%\tAN\u0001\ra\u0006$G-\u001b8h-\u0006dW/Z\u000b\u0002oA\u0011Q\u0004O\u0005\u0003sy\u0011a\u0001R8vE2,\u0007\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002\u001bA\fG\rZ5oOZ\u000bG.^3!\u0011!i\u0004A!b\u0001\n\u00031\u0014aB7bq:{'/\u001c\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005o\u0005AQ.\u0019=O_Jl\u0007\u0005\u0003\u0005B\u0001\t\u0015\r\u0011\"\u00017\u0003!qwN]7UsB,\u0007\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002\u00139|'/\u001c+za\u0016\u0004\u0003\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\u0002+MDw.\u001e7e'\u000e\fG.Z$sC\u0012\u0014\u0015P\u0012:fcB\u0011QdR\u0005\u0003\u0011z\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005K\u0001\t\u0005\r\u0011\"\u0001L\u000319(+Z4vY\u0006\u0014\u0018N_3s+\u0005a\u0005cA'Q/5\taJ\u0003\u0002P\t\u0005)q\u000e\u001d;j[&\u0011\u0011K\u0014\u0002\f%\u0016<W\u000f\\1sSj,'\u000f\u0003\u0005T\u0001\t\u0005\r\u0011\"\u0001U\u0003A9(+Z4vY\u0006\u0014\u0018N_3s?\u0012*\u0017\u000f\u0006\u0002V1B\u0011QDV\u0005\u0003/z\u0011A!\u00168ji\"9\u0011LUA\u0001\u0002\u0004a\u0015a\u0001=%c!A1\f\u0001B\u0001B\u0003&A*A\u0007x%\u0016<W\u000f\\1sSj,'\u000f\t\u0005\t;\u0002\u0011)\u0019!C\u0001=\u0006AQ.Y:l5\u0016\u0014x.F\u0001G\u0011!\u0001\u0007A!A!\u0002\u00131\u0015!C7bg.TVM]8!\u0011!\u0011\u0007AaA!\u0002\u0017\u0019\u0017AC3wS\u0012,gnY3%cA\u0019AmZ\f\u000e\u0003\u0015T!A\u001a\u0010\u0002\u000fI,g\r\\3di&\u0011\u0001.\u001a\u0002\t\u00072\f7o\u001d+bO\"A!\u000e\u0001B\u0001B\u0003-1.\u0001\u0002fmB!A.!\u0001\u0018\u001d\tiWP\u0004\u0002ow:\u0011qN\u001f\b\u0003aft!!\u001d=\u000f\u0005I<hBA:w\u001b\u0005!(BA;\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005q$\u0011A\u0002;f]N|'/\u0003\u0002\u007f\u007f\u0006\tB+\u001a8t_JtU/\\3sS\u000el\u0015\r\u001e5\u000b\u0005q$\u0011\u0002BA\u0002\u0003\u000b\u0011Q\u0002V3og>\u0014h*^7fe&\u001c'B\u0001@\u0000\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017\ta\u0001P5oSRtDCEA\u0007\u0003/\tI\"a\u0007\u0002\u001e\u0005}\u0011\u0011EA\u0012\u0003K!b!a\u0004\u0002\u0014\u0005U\u0001\u0003BA\t\u0001]i\u0011A\u0001\u0005\u0007E\u0006\u001d\u00019A2\t\r)\f9\u0001q\u0001l\u0011\u0019I\u0013q\u0001a\u0001W!1\u0011'a\u0002A\u0002-B\u0001\"NA\u0004!\u0003\u0005\ra\u000e\u0005\t{\u0005\u001d\u0001\u0013!a\u0001o!A\u0011)a\u0002\u0011\u0002\u0003\u0007q\u0007\u0003\u0005F\u0003\u000f\u0001\n\u00111\u0001G\u0011!Q\u0015q\u0001I\u0001\u0002\u0004a\u0005\u0002C/\u0002\bA\u0005\t\u0019\u0001$\t\u0013\u0005%\u0002\u00011A\u0005\u0002\u0005-\u0012AB<fS\u001eDG/\u0006\u0002\u0002.A)\u0011qFA\u0019/5\tq0C\u0002\u00024}\u0014a\u0001V3og>\u0014\b\"CA\u001c\u0001\u0001\u0007I\u0011AA\u001d\u0003)9X-[4ii~#S-\u001d\u000b\u0004+\u0006m\u0002\"C-\u00026\u0005\u0005\t\u0019AA\u0017\u0011!\ty\u0004\u0001Q!\n\u00055\u0012aB<fS\u001eDG\u000f\t\u0005\n\u0003\u0007\u0002\u0001\u0019!C\u0001\u0003W\t!b\u001a:bI^+\u0017n\u001a5u\u0011%\t9\u0005\u0001a\u0001\n\u0003\tI%\u0001\bhe\u0006$w+Z5hQR|F%Z9\u0015\u0007U\u000bY\u0005C\u0005Z\u0003\u000b\n\t\u00111\u0001\u0002.!A\u0011q\n\u0001!B\u0013\ti#A\u0006he\u0006$w+Z5hQR\u0004\u0003\"CA*\u0001\u0001\u0007I\u0011BA\u0016\u0003-Ig\u000e];u\u0005V4g-\u001a:\t\u0013\u0005]\u0003\u00011A\u0005\n\u0005e\u0013aD5oaV$()\u001e4gKJ|F%Z9\u0015\u0007U\u000bY\u0006C\u0005Z\u0003+\n\t\u00111\u0001\u0002.!A\u0011q\f\u0001!B\u0013\ti#\u0001\u0007j]B,HOQ;gM\u0016\u0014\b\u0005C\u0005\u0002d\u0001\u0001\r\u0011\"\u0003\u0002,\u0005Qan\u001c:n\u0005V4g-\u001a:\t\u0013\u0005\u001d\u0004\u00011A\u0005\n\u0005%\u0014A\u00048pe6\u0014UO\u001a4fe~#S-\u001d\u000b\u0004+\u0006-\u0004\"C-\u0002f\u0005\u0005\t\u0019AA\u0017\u0011!\ty\u0007\u0001Q!\n\u00055\u0012a\u00038pe6\u0014UO\u001a4fe\u0002B\u0011\"a\u001d\u0001\u0005\u0004%I!a\u000b\u0002\u0017\r|WO\u001c;Ck\u001a4WM\u001d\u0005\t\u0003o\u0002\u0001\u0015!\u0003\u0002.\u0005a1m\\;oi\n+hMZ3sA!9\u00111\u0010\u0001\u0005B\u0005u\u0014!\u0002:fg\u0016$H#A+\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\u00061!/\u001a8pe6$2!VAC\u0011!\t9)a A\u0002\u00055\u0012!B5oaV$\bbBAF\u0001\u0011%\u0011QR\u0001\ne\u0016twN]7S_^$2\"VAH\u00033\u000bi*!)\u0002$\"A\u0011\u0011SAE\u0001\u0004\t\u0019*\u0001\u0005s_^|F-\u0019;b!\u0011i\u0012QS\f\n\u0007\u0005]eDA\u0003BeJ\f\u0017\u0010C\u0004\u0002\u001c\u0006%\u0005\u0019A\u0016\u0002\r=4gm]3u\u0011\u001d\ty*!#A\u0002-\naa\u001d;sS\u0012,\u0007BB\u001f\u0002\n\u0002\u0007q\u0007\u0003\u0004B\u0003\u0013\u0003\ra\u000e\u0005\b\u0003O\u0003A\u0011BAU\u0003)\u0011Xm]3u\u0007>,h\u000e\u001e\u000b\u0006+\u0006-\u0016q\u0016\u0005\t\u0003[\u000b)\u000b1\u0001\u0002.\u0005)1m\\;oi\"A\u0011qQAS\u0001\u0004\ti\u0003C\u0004\u00024\u0002!\t%!.\u0002\u0019U\u0004H-\u0019;f\u001fV$\b/\u001e;\u0015\t\u00055\u0012q\u0017\u0005\t\u0003\u000f\u000b\t\f1\u0001\u0002.!9\u00111\u0018\u0001\u0005B\u0005u\u0016aD;qI\u0006$Xm\u0012:bI&s\u0007/\u001e;\u0015\r\u00055\u0012qXAa\u0011!\t9)!/A\u0002\u00055\u0002\u0002CAb\u0003s\u0003\r!!\f\u0002\u0015\u001d\u0014\u0018\rZ(viB,H\u000fC\u0004\u0002H\u0002!\t%!3\u0002#\u0005\u001c7m\u0012:bIB\u000b'/Y7fi\u0016\u00148\u000fF\u0003V\u0003\u0017\fi\r\u0003\u0005\u0002\b\u0006\u0015\u0007\u0019AA\u0017\u0011!\t\u0019-!2A\u0002\u00055\u0002bBAi\u0001\u0011\u0005\u00131[\u0001\ti>\u001cFO]5oOR\u0011\u0011Q\u001b\t\u0005\u0003/\fiND\u0002\u001e\u00033L1!a7\u001f\u0003\u0019\u0001&/\u001a3fM&!\u0011q\\Aq\u0005\u0019\u0019FO]5oO*\u0019\u00111\u001c\u0010\t\u000f\u0005\u0015\b\u0001\"\u0011\u0002h\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0015\u0005\u0005%\bcB\u000f\u0002l\u0006=\u0018q^\u0005\u0004\u0003[t\"A\u0002+va2,'\u0007E\u0003\u001e\u0003+\u000bi\u0003C\u0004\u0002t\u0002!\t%!>\u0002\u0015\rdW-\u0019:Ti\u0006$X\r\u0006\u0002\u0002x6\t\u0001\u0001C\u0004\u0002|\u0002!\t%!@\u0002\u0011\r\fg.R9vC2$2ARA\u0000\u0011\u001d\u0011\t!!?A\u0002\t\nQa\u001c;iKJDqA!\u0002\u0001\t\u0003\u00129!\u0001\u0004fcV\fGn\u001d\u000b\u0004\r\n%\u0001b\u0002B\u0001\u0005\u0007\u0001\rA\t\u0005\b\u0005\u001b\u0001A\u0011\tB\b\u0003!A\u0017m\u001d5D_\u0012,G#A\u0016\t\u000f\tM\u0001\u0001\"\u0011\u0003\u0016\u0005\u00112m\\7qkR,w*\u001e;qkR\u001c\u0006.\u00199f)\u0011\u00119Ba\t\u0011\t\te!qD\u0007\u0003\u00057Q1A!\b\u0005\u0003\u0015)H/\u001b7t\u0013\u0011\u0011\tCa\u0007\u0003\u000bMC\u0017\r]3\t\u0011\t\u0015\"\u0011\u0003a\u0001\u0005/\t!\"\u001b8qkR\u001c\u0006.\u00199fQ\u001d\u0001!\u0011\u0006B\u0018\u0005c\u00012!\bB\u0016\u0013\r\u0011iC\b\u0002\u0011'\u0016\u0014\u0018.\u00197WKJ\u001c\u0018n\u001c8V\u0013\u0012\u000bQA^1mk\u0016t\u0002\u00020y.LhR\u0018h~\u0004\b\u0005k\u0011\u0001\u0012\u0001B\u001c\u0003-aun\\6vaR\u000b'\r\\3\u0011\t\u0005E!\u0011\b\u0004\u0007\u0003\tA\tAa\u000f\u0014\r\te\"Q\bB\"!\ri\"qH\u0005\u0004\u0005\u0003r\"AB!osJ+g\rE\u0002\u001e\u0005\u000bJ1Aa\u0012\u001f\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\tIA!\u000f\u0005\u0002\t-CC\u0001B\u001c\u0011!\u0011yE!\u000f\u0005\u0002\tE\u0013!B1qa2LX\u0003\u0002B*\u00057\"\"C!\u0016\u0003\b\n%%1\u0012BG\u0005\u001f\u0013\tJa%\u0003\u0018R1!q\u000bB?\u0005\u0007\u0003R!!\u0005\u0001\u00053\u00022\u0001\u0007B.\t)Q\"Q\nQ\u0001\u0002\u0003\u0015\ra\u0007\u0015\t\u00057\u0012yF!\u001a\u0003tA\u0019QD!\u0019\n\u0007\t\rdDA\u0006ta\u0016\u001c\u0017.\u00197ju\u0016$\u0017'C\u0012\u0003h\t%$Q\u000eB6\u001d\ri\"\u0011N\u0005\u0004\u0005Wr\u0012!\u0002$m_\u0006$\u0018G\u0002\u0013\u0003p\tEtDD\u0002t\u0005cJ\u0011aH\u0019\nG\tU$q\u000fB>\u0005sr1!\bB<\u0013\r\u0011IHH\u0001\u0007\t>,(\r\\32\r\u0011\u0012yG!\u001d \u0011)\u0011yH!\u0014\u0002\u0002\u0003\u000f!\u0011Q\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004\u0003\u00023h\u00053BqA\u001bB'\u0001\b\u0011)\tE\u0003m\u0003\u0003\u0011I\u0006\u0003\u0004*\u0005\u001b\u0002\ra\u000b\u0005\u0007c\t5\u0003\u0019A\u0016\t\u0011U\u0012i\u0005%AA\u0002]B\u0001\"\u0010B'!\u0003\u0005\ra\u000e\u0005\t\u0003\n5\u0003\u0013!a\u0001o!AQI!\u0014\u0011\u0002\u0003\u0007a\tC\u0005K\u0005\u001b\u0002\n\u00111\u0001\u0003\u0016B!Q\n\u0015B-\u0011!i&Q\nI\u0001\u0002\u00041\u0005B\u0003BN\u0005s\t\n\u0011\"\u0001\u0003\u001e\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'\u0006\u0003\u0003 \nUVC\u0001BQU\r9$1U\u0016\u0003\u0005K\u0003BAa*\u000326\u0011!\u0011\u0016\u0006\u0005\u0005W\u0013i+A\u0005v]\u000eDWmY6fI*\u0019!q\u0016\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00034\n%&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012Q!D!'!\u0002\u0003\u0005)\u0019A\u000e)\u0011\tU&q\fB]\u0005{\u000b\u0014b\tB4\u0005S\u0012YLa\u001b2\r\u0011\u0012yG!\u001d c%\u0019#Q\u000fB<\u0005\u007f\u0013I(\r\u0004%\u0005_\u0012\th\b\u0005\u000b\u0005\u0007\u0014I$%A\u0005\u0002\t\u0015\u0017aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0016\t\t}%q\u0019\u0003\u000b5\t\u0005\u0007\u0015!A\u0001\u0006\u0004Y\u0002\u0006\u0003Bd\u0005?\u0012YMa42\u0013\r\u00129G!\u001b\u0003N\n-\u0014G\u0002\u0013\u0003p\tEt$M\u0005$\u0005k\u00129H!5\u0003zE2AEa\u001c\u0003r}A!B!6\u0003:E\u0005I\u0011\u0001Bl\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012*T\u0003\u0002BP\u00053$!B\u0007BjA\u0003\u0005\tQ1\u0001\u001cQ!\u0011INa\u0018\u0003^\n\u0005\u0018'C\u0012\u0003h\t%$q\u001cB6c\u0019!#q\u000eB9?EJ1E!\u001e\u0003x\t\r(\u0011P\u0019\u0007I\t=$\u0011O\u0010\t\u0015\t\u001d(\u0011HI\u0001\n\u0003\u0011I/A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00137+\u0011\u0011YOa<\u0016\u0005\t5(f\u0001$\u0003$\u0012Q!D!:!\u0002\u0003\u0005)\u0019A\u000e)\u0011\t=(q\fBz\u0005o\f\u0014b\tB4\u0005S\u0012)Pa\u001b2\r\u0011\u0012yG!\u001d c%\u0019#Q\u000fB<\u0005s\u0014I(\r\u0004%\u0005_\u0012\th\b\u0005\u000b\u0005{\u0014I$%A\u0005\u0002\t}\u0018aD1qa2LH\u0005Z3gCVdG\u000fJ\u001c\u0016\t\r\u000511B\u000b\u0003\u0007\u0007QCa!\u0002\u0003$B\u0019Qda\u0002\n\u0007\r%aD\u0001\u0003Ok2dGA\u0003\u000e\u0003|\u0002\u0006\t\u0011!b\u00017!B11\u0002B0\u0007\u001f\u0019\u0019\"M\u0005$\u0005O\u0012Ig!\u0005\u0003lE2AEa\u001c\u0003r}\t\u0014b\tB;\u0005o\u001a)B!\u001f2\r\u0011\u0012yG!\u001d \u0011)\u0019IB!\u000f\u0012\u0002\u0013\u000511D\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%qU!!1^B\u000f\t)Q2q\u0003Q\u0001\u0002\u0003\u0015\ra\u0007\u0015\t\u0007;\u0011yf!\t\u0004&EJ1Ea\u001a\u0003j\r\r\"1N\u0019\u0007I\t=$\u0011O\u00102\u0013\r\u0012)Ha\u001e\u0004(\te\u0014G\u0002\u0013\u0003p\tEt\u0004\u0003\u0006\u0004,\te\u0012\u0013!C\u0001\u0007[\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aT\u0003\u0002BP\u0007_!aAGB\u0015\u0005\u0004Y\u0002BCB\u001a\u0005s\t\n\u0011\"\u0001\u00046\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*BAa(\u00048\u00111!d!\rC\u0002mA!ba\u000f\u0003:E\u0005I\u0011AB\u001f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU!!qTB \t\u0019Q2\u0011\bb\u00017!Q11\tB\u001d#\u0003%\ta!\u0012\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\u0011\u0011Yoa\u0012\u0005\ri\u0019\tE1\u0001\u001c\u0011)\u0019YE!\u000f\u0012\u0002\u0013\u00051QJ\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\t\r\u00051q\n\u0003\u00075\r%#\u0019A\u000e\t\u0015\rM#\u0011HI\u0001\n\u0003\u0019)&A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005O\u000b\u0005\u0005W\u001c9\u0006\u0002\u0004\u001b\u0007#\u0012\ra\u0007\u0005\u000b\u00077\u0012I$!A\u0005\n\ru\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"aa\u0018\u0011\t\r\u000541N\u0007\u0003\u0007GRAa!\u001a\u0004h\u0005!A.\u00198h\u0015\t\u0019I'\u0001\u0003kCZ\f\u0017\u0002BB7\u0007G\u0012aa\u00142kK\u000e$\b")
public class LookupTable<T>
extends TensorModule<T>
implements Initializable {
    public static final long serialVersionUID = -4832171200145114633L;
    private final int nIndex;
    private final int nOutput;
    private final double paddingValue;
    private final double maxNorm;
    private final double normType;
    private final boolean shouldScaleGradByFreq;
    private Regularizer<T> wRegularizer;
    private final boolean maskZero;
    public final TensorNumericMath.TensorNumeric<T> com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev;
    private Tensor<T> weight;
    private Tensor<T> gradWeight;
    private Tensor<T> inputBuffer;
    private Tensor<T> normBuffer;
    private final Tensor<T> countBuffer;
    private InitializationMethod weightInitMethod;
    private InitializationMethod biasInitMethod;

    public static <T> boolean $lessinit$greater$default$8() {
        return LookupTable$.MODULE$.$lessinit$greater$default$8();
    }

    public static <T> Null$ $lessinit$greater$default$7() {
        return LookupTable$.MODULE$.$lessinit$greater$default$7();
    }

    public static <T> boolean $lessinit$greater$default$6() {
        return LookupTable$.MODULE$.$lessinit$greater$default$6();
    }

    public static <T> double $lessinit$greater$default$5() {
        return LookupTable$.MODULE$.$lessinit$greater$default$5();
    }

    public static <T> double $lessinit$greater$default$4() {
        return LookupTable$.MODULE$.$lessinit$greater$default$4();
    }

    public static <T> double $lessinit$greater$default$3() {
        return LookupTable$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T> boolean apply$default$8() {
        return LookupTable$.MODULE$.apply$default$8();
    }

    public static <T> Null$ apply$default$7() {
        return LookupTable$.MODULE$.apply$default$7();
    }

    public static <T> boolean apply$default$6() {
        return LookupTable$.MODULE$.apply$default$6();
    }

    public static <T> double apply$default$5() {
        return LookupTable$.MODULE$.apply$default$5();
    }

    public static <T> double apply$default$4() {
        return LookupTable$.MODULE$.apply$default$4();
    }

    public static <T> double apply$default$3() {
        return LookupTable$.MODULE$.apply$default$3();
    }

    @Override
    public InitializationMethod weightInitMethod() {
        return this.weightInitMethod;
    }

    @Override
    public void weightInitMethod_$eq(InitializationMethod x$1) {
        this.weightInitMethod = x$1;
    }

    @Override
    public InitializationMethod biasInitMethod() {
        return this.biasInitMethod;
    }

    @Override
    public void biasInitMethod_$eq(InitializationMethod x$1) {
        this.biasInitMethod = x$1;
    }

    @Override
    public Initializable setInitMethod(InitializationMethod weightInitMethod, InitializationMethod biasInitMethod) {
        return Initializable$class.setInitMethod(this, weightInitMethod, biasInitMethod);
    }

    @Override
    public Initializable setInitMethod(InitializationMethod[] initMethod) {
        return Initializable$class.setInitMethod(this, initMethod);
    }

    @Override
    public InitializationMethod setInitMethod$default$1() {
        return Initializable$class.setInitMethod$default$1(this);
    }

    @Override
    public InitializationMethod setInitMethod$default$2() {
        return Initializable$class.setInitMethod$default$2(this);
    }

    public int nIndex() {
        return this.nIndex;
    }

    public int nOutput() {
        return this.nOutput;
    }

    public double paddingValue() {
        return this.paddingValue;
    }

    public double maxNorm() {
        return this.maxNorm;
    }

    public double normType() {
        return this.normType;
    }

    public Regularizer<T> wRegularizer() {
        return this.wRegularizer;
    }

    public void wRegularizer_$eq(Regularizer<T> x$1) {
        this.wRegularizer = x$1;
    }

    public boolean maskZero() {
        return this.maskZero;
    }

    public Tensor<T> weight() {
        return this.weight;
    }

    public void weight_$eq(Tensor<T> x$1) {
        this.weight = x$1;
    }

    public Tensor<T> gradWeight() {
        return this.gradWeight;
    }

    public void gradWeight_$eq(Tensor<T> x$1) {
        this.gradWeight = x$1;
    }

    private Tensor<T> inputBuffer() {
        return this.inputBuffer;
    }

    private void inputBuffer_$eq(Tensor<T> x$1) {
        this.inputBuffer = x$1;
    }

    private Tensor<T> normBuffer() {
        return this.normBuffer;
    }

    private void normBuffer_$eq(Tensor<T> x$1) {
        this.normBuffer = x$1;
    }

    private Tensor<T> countBuffer() {
        return this.countBuffer;
    }

    @Override
    public void reset() {
        this.weightInitMethod().init(this.weight(), VariableFormat$Default$.MODULE$, this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev);
    }

    private void renorm(Tensor<T> input) {
        int i;
        if (Double.MAX_VALUE == this.maxNorm()) {
            return;
        }
        Tensor<T> qual$1 = this.normBuffer();
        int[] x$1 = input.size();
        int[] x$2 = qual$1.resize$default$2();
        qual$1.resize(x$1, x$2).copy(input);
        if (this.normBuffer().dim() == 2) {
            this.normBuffer_$eq(this.normBuffer().view((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{this.normBuffer().nElement()})));
        }
        Log4Error$.MODULE$.invalidInputError(this.weight().isContiguous(), "LookupTable: weight must be contiguous", Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(this.normBuffer().isContiguous(), "LookupTable: input must be contiguous", Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(this.normBuffer().nDimension() == 1, "LookupTable: idx must be a vector", Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(this.normType() > 0.0, "LookupTable: non-positive-norm not supported", Log4Error$.MODULE$.invalidInputError$default$3());
        Object rowIdx = this.normBuffer().storage().array();
        int rowOffset = this.normBuffer().storageOffset() - 1;
        int numEle = this.normBuffer().nElement();
        int stride = this.weight().stride(1);
        Object gw = this.weight().storage().array();
        int gw_offset = this.weight().storageOffset() - 1;
        for (i = 0; i < numEle; ++i) {
            Log4Error$.MODULE$.invalidInputError(this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.isGreater(this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.fromType(BoxesRunTime.boxToInteger((int)(this.weight().size(1) + 1)), ConvertableFrom$ConvertableFromInt$.MODULE$), ScalaRunTime$.MODULE$.array_apply(rowIdx, i + rowOffset)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LookupTable: elements of input should be little than or equal to ", " + 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.nIndex())})), Log4Error$.MODULE$.invalidInputError$default$3());
            Log4Error$.MODULE$.invalidInputError(this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.isGreaterEq(ScalaRunTime$.MODULE$.array_apply(rowIdx, i + rowOffset), this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.one()), "LookupTable: elements of input should be greater than or equal to 1", Log4Error$.MODULE$.invalidInputError$default$3());
        }
        Ordering ord = package$.MODULE$.Ordering().fromLessThan((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LookupTable $outer;

            public final boolean apply(T e1, T e2) {
                return this.$outer.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.isGreater(e1, e2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Sorting$.MODULE$.quickSort(rowIdx, ord);
        int ptr = 0;
        for (i = 0; i < numEle; ++i) {
            if (i != 0 && BoxesRunTime.equals((Object)ScalaRunTime$.MODULE$.array_apply(rowIdx, i + rowOffset), (Object)ScalaRunTime$.MODULE$.array_apply(rowIdx, i - 1 + rowOffset))) continue;
            ScalaRunTime$.MODULE$.array_update(rowIdx, ptr + rowOffset, ScalaRunTime$.MODULE$.array_apply(rowIdx, i + rowOffset));
            ++ptr;
        }
        numEle = ptr;
        for (i = 0; i < numEle; ++i) {
            int k = BoxesRunTime.unboxToInt((Object)this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.toType(ScalaRunTime$.MODULE$.array_apply(rowIdx, i + rowOffset), ConvertableTo$ConvertableToInt$.MODULE$)) - 1;
            this.renormRow(gw, k * stride + gw_offset, stride, this.maxNorm(), this.normType());
        }
    }

    private void renormRow(Object row_data, int offset, int stride, double maxNorm, double normType) {
        int j;
        double norm2 = 0.0;
        for (j = 0; j < stride; ++j) {
            if (normType == 1.0) {
                norm2 += BoxesRunTime.unboxToDouble((Object)this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.toType(this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.abs(ScalaRunTime$.MODULE$.array_apply(row_data, j + offset)), ConvertableTo$ConvertableToDouble$.MODULE$));
                continue;
            }
            if (normType == (double)2) {
                norm2 += BoxesRunTime.unboxToDouble((Object)this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.toType(this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.times(ScalaRunTime$.MODULE$.array_apply(row_data, j + offset), ScalaRunTime$.MODULE$.array_apply(row_data, j + offset)), ConvertableTo$ConvertableToDouble$.MODULE$));
                continue;
            }
            norm2 += scala.math.package$.MODULE$.pow(package.abs$.MODULE$.apply$mDDc$sp(BoxesRunTime.unboxToDouble((Object)this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.toType(ScalaRunTime$.MODULE$.array_apply(row_data, j + offset), ConvertableTo$ConvertableToDouble$.MODULE$)), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$), normType);
        }
        if ((norm2 = package.pow$.MODULE$.apply$mDDDc$sp(norm2, 1.0 / normType, (UFunc.UImpl2)package.pow$.powDoubleDoubleImpl$.MODULE$)) > maxNorm) {
            double new_norm = maxNorm / (norm2 + 1.0E-7);
            for (j = 0; j < stride; ++j) {
                ScalaRunTime$.MODULE$.array_update(row_data, j + offset, this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.times(ScalaRunTime$.MODULE$.array_apply(row_data, j + offset), this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.fromType(BoxesRunTime.boxToDouble((double)new_norm), ConvertableFrom$ConvertableFromDouble$.MODULE$)));
            }
        }
    }

    private void resetCount(Tensor<T> count2, Tensor<T> input) {
        int i;
        int numEle = input.nElement();
        for (i = 1; i <= numEle; ++i) {
            int k = BoxesRunTime.unboxToInt((Object)this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.toType(input.valueAt(i), ConvertableTo$ConvertableToInt$.MODULE$));
            count2.update(k, this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.zero());
        }
        for (i = 1; i <= numEle; ++i) {
            int k = BoxesRunTime.unboxToInt((Object)this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.toType(input.valueAt(i), ConvertableTo$ConvertableToInt$.MODULE$));
            count2.update(k, this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.plus(count2.valueAt(k), this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.one()));
        }
    }

    @Override
    public Tensor<T> updateOutput(Tensor<T> input) {
        Object object;
        Object object2 = this.maskZero() && this.paddingValue() != 0.0 ? this.weight().select(1, (int)this.paddingValue()).zero() : BoxedUnit.UNIT;
        Log4Error$.MODULE$.invalidInputError(input.dim() == 1 || input.dim() == 2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LookupTable: ", ", input dim [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ErrorInfo$.MODULE$.constrainInputAsVectorOrBatch(), BoxesRunTime.boxToInteger((int)input.dim())})), Log4Error$.MODULE$.invalidInputError$default$3());
        this.renorm(input);
        this.inputBuffer_$eq(input.contiguous());
        try {
            if (this.inputBuffer().dim() == 1) {
                object = ((TensorMath)this.output()).index(1, this.inputBuffer(), this.weight());
            } else {
                if (this.inputBuffer().dim() == 2) {
                    ((TensorMath)this.output()).index(1, this.inputBuffer().view((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{this.inputBuffer().nElement()})), this.weight());
                    this.output_$eq(((Tensor)this.output()).view((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{this.inputBuffer().size(1), this.inputBuffer().size(2), this.weight().size(2)})));
                }
                object = BoxedUnit.UNIT;
            }
        }
        catch (Exception exception) {
            boolean x$3 = false;
            String x$4 = exception.getMessage();
            Exception x$5 = exception;
            String x$6 = Log4Error$.MODULE$.unKnowExceptionError$default$3();
            Log4Error$.MODULE$.unKnowExceptionError(x$3, x$4, x$6, x$5);
            object = BoxedUnit.UNIT;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log4Error$.MODULE$.invalidInputError(false, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LookupTable updateOutput get exception:", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{illegalArgumentException.getMessage()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"please ensure elements of your input will not exceed ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.nIndex())}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
            object = BoxedUnit.UNIT;
        }
        return (Tensor)this.output();
    }

    @Override
    public Tensor<T> updateGradInput(Tensor<T> input, Tensor<T> gradOutput) {
        Object object = ((Tensor)this.gradInput()).isSameSizeAs(input) ? BoxedUnit.UNIT : ((Tensor)this.gradInput()).resizeAs(input).zero();
        return (Tensor)this.gradInput();
    }

    @Override
    public void accGradParameters(Tensor<T> input, Tensor<T> gradOutput) {
        int i;
        this.inputBuffer_$eq(input.contiguous());
        Log4Error$.MODULE$.invalidInputError(this.gradWeight().isContiguous(), "LookupTable: gradWeight must be contiguous", Log4Error$.MODULE$.invalidInputError$default$3());
        Log4Error$.MODULE$.invalidInputError(this.inputBuffer().dim() == 1 || this.inputBuffer().dim() == 2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LookupTable: input must be a vector or matrix, input dim ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.inputBuffer().dim())})), Log4Error$.MODULE$.invalidInputError$default$3());
        Object object = this.inputBuffer().dim() == 2 ? this.inputBuffer().view((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{this.inputBuffer().nElement()})) : BoxedUnit.UNIT;
        Tensor<T> _gradOutput = gradOutput.contiguous();
        Object count_data = null;
        if (this.shouldScaleGradByFreq) {
            this.countBuffer().resize(this.gradWeight().size(1));
            this.resetCount(this.countBuffer(), this.inputBuffer());
            count_data = this.countBuffer().storage().array();
        }
        Object input_data = this.inputBuffer().storage().array();
        int input_offset = this.inputBuffer().storageOffset() - 1;
        int numEle = this.inputBuffer().nElement();
        for (i = 0; i < numEle; ++i) {
            Log4Error$.MODULE$.invalidInputError(this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.isGreater(this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.fromType(BoxesRunTime.boxToInteger((int)(this.gradWeight().size(1) + 1)), ConvertableFrom$ConvertableFromInt$.MODULE$), ScalaRunTime$.MODULE$.array_apply(input_data, i + input_offset)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LookupTable: elements of input should be little than or equal to ", " + 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.nIndex())})), Log4Error$.MODULE$.invalidInputError$default$3());
            Log4Error$.MODULE$.invalidInputError(this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.isGreaterEq(ScalaRunTime$.MODULE$.array_apply(input_data, i + input_offset), this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.one()), "LookupTable: elements of input should be greater than or equal to 1", Log4Error$.MODULE$.invalidInputError$default$3());
        }
        if (this.scaleW() != 0.0) {
            Object gw = this.gradWeight().storage().array();
            Object go = _gradOutput.storage().array();
            int stride = this.gradWeight().stride(1);
            for (i = 0; i < numEle; ++i) {
                if (BoxesRunTime.equals((Object)ScalaRunTime$.MODULE$.array_apply(input_data, i + input_offset), (Object)BoxesRunTime.boxToDouble((double)this.paddingValue()))) continue;
                int k = BoxesRunTime.unboxToInt((Object)this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.toType(ScalaRunTime$.MODULE$.array_apply(input_data, i + input_offset), ConvertableTo$ConvertableToInt$.MODULE$)) - 1;
                double scale_ = count_data == null ? this.scaleW() : this.scaleW() / BoxesRunTime.unboxToDouble((Object)this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.toType(ScalaRunTime$.MODULE$.array_apply(count_data, k), ConvertableTo$ConvertableToDouble$.MODULE$));
                this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.axpy(stride, this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev.fromType(BoxesRunTime.boxToDouble((double)scale_), ConvertableFrom$ConvertableFromDouble$.MODULE$), go, i * stride + _gradOutput.storageOffset() - 1, 1, gw, k * stride + this.gradWeight().storageOffset() - 1, 1);
            }
            if (this.wRegularizer() != null) {
                this.wRegularizer().accRegularization(this.weight(), this.gradWeight(), this.scaleW());
            }
        }
    }

    @Override
    public String toString() {
        String s2 = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getPrintName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(nIndex=", ",nOutput=", ",paddingValue=", ",normType=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.nIndex()), BoxesRunTime.boxToInteger((int)this.nOutput()), BoxesRunTime.boxToDouble((double)this.paddingValue()), BoxesRunTime.boxToDouble((double)this.normType())}))).toString();
        return this.maxNorm() == Double.MAX_VALUE ? new StringBuilder().append((Object)s2).append((Object)")").toString() : new StringBuilder().append((Object)s2).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ,maxNorm=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.maxNorm())}))).toString();
    }

    @Override
    public Tuple2<Tensor<T>[], Tensor<T>[]> parameters() {
        return new Tuple2((Object)new Tensor[]{this.weight()}, (Object)new Tensor[]{this.gradWeight()});
    }

    public LookupTable<T> clearState() {
        super.clearState();
        this.inputBuffer().set();
        this.countBuffer().set();
        this.normBuffer().set();
        return this;
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof LookupTable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof LookupTable)) return false;
        LookupTable lookupTable = (LookupTable)object;
        if (!super.equals(lookupTable)) return false;
        if (!lookupTable.canEqual(this)) return false;
        Tensor<T> tensor = this.weight();
        Tensor<T> tensor2 = lookupTable.weight();
        if (tensor == null) {
            if (tensor2 != null) {
                return false;
            }
        } else if (!tensor.equals(tensor2)) return false;
        Tensor<T> tensor3 = this.gradWeight();
        Tensor<T> tensor4 = lookupTable.gradWeight();
        if (tensor3 == null) {
            if (tensor4 != null) {
                return false;
            }
        } else if (!tensor3.equals(tensor4)) return false;
        if (this.nIndex() != lookupTable.nIndex()) return false;
        if (this.nOutput() != lookupTable.nOutput()) return false;
        if (this.paddingValue() != lookupTable.paddingValue()) return false;
        if (this.maxNorm() != lookupTable.maxNorm()) return false;
        if (this.normType() != lookupTable.normType()) return false;
        return true;
    }

    @Override
    public int hashCode() {
        Seq state = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)super.hashCode()), this.weight(), this.gradWeight(), BoxesRunTime.boxToInteger((int)this.nIndex()), BoxesRunTime.boxToInteger((int)this.nOutput()), BoxesRunTime.boxToDouble((double)this.paddingValue()), BoxesRunTime.boxToDouble((double)this.maxNorm()), BoxesRunTime.boxToDouble((double)this.normType())}));
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)state.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LookupTable $outer;

            public final int apply(Object a) {
                return this.$outer.com$intel$analytics$bigdl$dllib$nn$LookupTable$$getHashCode$1(a);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int a, int b) {
                return this.apply$mcIII$sp(a, b);
            }

            public int apply$mcIII$sp(int a, int b) {
                return 31 * a + b;
            }
        }));
    }

    @Override
    public Shape computeOutputShape(Shape inputShape) {
        int[] _inputSize = (int[])inputShape.toSingle().toArray(ClassTag$.MODULE$.Int());
        return _inputSize.length == 2 ? Shape$.MODULE$.apply(new int[]{_inputSize[0], _inputSize[1], this.nOutput()}) : Shape$.MODULE$.apply(new int[]{_inputSize[0], this.nOutput()});
    }

    public final int com$intel$analytics$bigdl$dllib$nn$LookupTable$$getHashCode$1(Object a) {
        return a == null ? 0 : a.hashCode();
    }

    public LookupTable(int nIndex, int nOutput, double paddingValue, double maxNorm, double normType, boolean shouldScaleGradByFreq, Regularizer<T> wRegularizer, boolean maskZero, ClassTag<T> evidence$1, TensorNumericMath.TensorNumeric<T> ev) {
        this.nIndex = nIndex;
        this.nOutput = nOutput;
        this.paddingValue = paddingValue;
        this.maxNorm = maxNorm;
        this.normType = normType;
        this.shouldScaleGradByFreq = shouldScaleGradByFreq;
        this.wRegularizer = wRegularizer;
        this.maskZero = maskZero;
        this.com$intel$analytics$bigdl$dllib$nn$LookupTable$$ev = ev;
        super(evidence$1, ev);
        Initializable$class.$init$(this);
        this.weight = Tensor$.MODULE$.apply(nIndex, nOutput, evidence$1, ev);
        this.gradWeight = Tensor$.MODULE$.apply(nIndex, nOutput, evidence$1, ev).zero();
        this.inputBuffer = Tensor$.MODULE$.apply(evidence$1, ev);
        this.normBuffer = Tensor$.MODULE$.apply(evidence$1, ev);
        this.countBuffer = Tensor$.MODULE$.apply(evidence$1, ev);
        RandomNormal wInit = new RandomNormal(0.0, 1.0);
        this.setInitMethod(wInit, this.setInitMethod$default$2());
    }
}

