/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.nn;

import com.intel.analytics.bigdl.dllib.nn.abstractnn.TensorModule;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorMath;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u0001=\u0011qbR1vgNL\u0017M\u001c#s_B|W\u000f\u001e\u0006\u0003\u0007\u0011\t!A\u001c8\u000b\u0005\u00151\u0011!\u00023mY&\u0014'BA\u0004\t\u0003\u0015\u0011\u0017n\u001a3m\u0015\tI!\"A\u0005b]\u0006d\u0017\u0010^5dg*\u00111\u0002D\u0001\u0006S:$X\r\u001c\u0006\u0002\u001b\u0005\u00191m\\7\u0004\u0001U\u0011\u0001#G\n\u0003\u0001E\u00012AE\u000b\u0018\u001b\u0005\u0019\"B\u0001\u000b\u0003\u0003)\t'm\u001d;sC\u000e$hN\\\u0005\u0003-M\u0011A\u0002V3og>\u0014Xj\u001c3vY\u0016\u0004\"\u0001G\r\r\u0001\u0011)!\u0004\u0001b\u00017\t\tA+\u0005\u0002\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t9aj\u001c;iS:<\u0007CA\u000f$\u0013\t!cDA\u0002B]fD\u0001B\n\u0001\u0003\u0006\u0004%\taJ\u0001\u0005e\u0006$X-F\u0001)!\ti\u0012&\u0003\u0002+=\t1Ai\\;cY\u0016D\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0006e\u0006$X\r\t\u0005\t]\u0001\u0011\u0019\u0011)A\u0006_\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\u0007A\u001at#D\u00012\u0015\t\u0011d$A\u0004sK\u001adWm\u0019;\n\u0005Q\n$\u0001C\"mCN\u001cH+Y4\t\u0011Y\u0002!\u0011!Q\u0001\f]\n!!\u001a<\u0011\u0007abuC\u0004\u0002:\u0013:\u0011!h\u0012\b\u0003w\u0019s!\u0001P#\u000f\u0005u\"eB\u0001 D\u001d\ty$)D\u0001A\u0015\t\te\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011B\u0001%\u0005\u0003\u0019!XM\\:pe&\u0011!jS\u0001\u0012)\u0016t7o\u001c:Ok6,'/[2NCRD'B\u0001%\u0005\u0013\tieJA\u0007UK:\u001cxN\u001d(v[\u0016\u0014\u0018n\u0019\u0006\u0003\u0015.CQ\u0001\u0015\u0001\u0005\u0002E\u000ba\u0001P5oSRtDC\u0001*X)\r\u0019VK\u0016\t\u0004)\u00029R\"\u0001\u0002\t\u000b9z\u00059A\u0018\t\u000bYz\u00059A\u001c\t\u000b\u0019z\u0005\u0019\u0001\u0015\t\u000fe\u0003!\u0019!C\u0001O\u000511\u000f\u001e3eKZDaa\u0017\u0001!\u0002\u0013A\u0013aB:uI\u0012,g\u000f\t\u0005\u0006;\u0002!\tEX\u0001\rkB$\u0017\r^3PkR\u0004X\u000f\u001e\u000b\u0003?\u000e\u00042\u0001Y1\u0018\u001b\u0005Y\u0015B\u00012L\u0005\u0019!VM\\:pe\")A\r\u0018a\u0001?\u0006)\u0011N\u001c9vi\")a\r\u0001C!O\u0006yQ\u000f\u001d3bi\u0016<%/\u00193J]B,H\u000fF\u0002`Q&DQ\u0001Z3A\u0002}CQA[3A\u0002}\u000b!b\u001a:bI>+H\u000f];u\u0011\u0015a\u0007\u0001\"\u0011n\u0003!!xn\u0015;sS:<G#\u00018\u0011\u0005=\u0014hBA\u000fq\u0013\t\th$\u0001\u0004Qe\u0016$WMZ\u0005\u0003gR\u0014aa\u0015;sS:<'BA9\u001fQ\u0011\u0001a/\u001f>\u0011\u0005u9\u0018B\u0001=\u001f\u0005A\u0019VM]5bYZ+'o]5p]VKE)A\u0003wC2,XM\b\u0005kDI\u0016{?M40\u000f\u0015a(\u0001#\u0001~\u0003=9\u0015-^:tS\u0006tGI]8q_V$\bC\u0001+\u007f\r\u0015\t!\u0001#\u0001\u0000'\u0015q\u0018\u0011AA\u0004!\ri\u00121A\u0005\u0004\u0003\u000bq\"AB!osJ+g\rE\u0002\u001e\u0003\u0013I1!a\u0003\u001f\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0019\u0001f\u0010\"\u0001\u0002\u0010Q\tQ\u0010C\u0004\u0002\u0014y$\t!!\u0006\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\u0005]\u0011q\u0004\u000b\u0005\u00033\tY\u0005\u0006\u0004\u0002\u001c\u0005\u0005\u0013q\t\t\u0005)\u0002\ti\u0002E\u0002\u0019\u0003?!!BGA\tA\u0003\u0005\tQ1\u0001\u001cQ!\ty\"a\t\u0002*\u0005]\u0002cA\u000f\u0002&%\u0019\u0011q\u0005\u0010\u0003\u0017M\u0004XmY5bY&TX\rZ\u0019\nG\u0005-\u0012QFA\u0019\u0003_q1!HA\u0017\u0013\r\tyCH\u0001\u0006\r2|\u0017\r^\u0019\u0007I\u0005M\u0012QG\u0010\u000f\u0007}\n)$C\u0001 c%\u0019\u0013\u0011HA\u001e\u0003\u007f\tiDD\u0002\u001e\u0003wI1!!\u0010\u001f\u0003\u0019!u.\u001e2mKF2A%a\r\u00026}A!\"a\u0011\u0002\u0012\u0005\u0005\t9AA#\u0003))g/\u001b3f]\u000e,GE\r\t\u0005aM\ni\u0002C\u00047\u0003#\u0001\u001d!!\u0013\u0011\tab\u0015Q\u0004\u0005\u0007M\u0005E\u0001\u0019\u0001\u0015\t\u0013\u0005=c0!A\u0005\n\u0005E\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u0015\u0011\t\u0005U\u0013qL\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005!A.\u00198h\u0015\t\ti&\u0001\u0003kCZ\f\u0017\u0002BA1\u0003/\u0012aa\u00142kK\u000e$\b")
public class GaussianDropout<T>
extends TensorModule<T> {
    public static final long serialVersionUID = -1575781981601306833L;
    private final double rate;
    private final ClassTag<T> evidence$1;
    private final TensorNumericMath.TensorNumeric<T> ev;
    private final double stddev;

    public double rate() {
        return this.rate;
    }

    public double stddev() {
        return this.stddev;
    }

    @Override
    public Tensor<T> updateOutput(Tensor<T> input) {
        Tensor<T> tensor;
        ((Tensor)this.output()).resizeAs(input).copy(input);
        if (this.train()) {
            Tensor<T> noise = Tensor$.MODULE$.apply(this.evidence$1, this.ev);
            noise.resizeAs(input);
            noise.randn(1.0, this.stddev());
            tensor = ((TensorMath)this.output()).cmul(noise);
        } else {
            tensor = (Tensor<T>)this.output();
        }
        return tensor;
    }

    @Override
    public Tensor<T> updateGradInput(Tensor<T> input, Tensor<T> gradOutput) {
        Object object;
        ((Tensor)this.gradInput()).resizeAs(gradOutput).copy(gradOutput);
        if (this.train()) {
            Tensor<T> noise = Tensor$.MODULE$.apply(this.evidence$1, this.ev);
            noise.resizeAs(gradOutput);
            noise.randn(1.0, this.stddev());
            object = ((TensorMath)this.gradInput()).cmul(noise);
        } else {
            Log4Error$.MODULE$.invalidOperationError(false, "GaussianDropout: backprop only defined while training", Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
            object = BoxedUnit.UNIT;
        }
        return (Tensor)this.gradInput();
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getPrintName(), BoxesRunTime.boxToDouble((double)this.rate())}));
    }

    public GaussianDropout(double rate, ClassTag<T> evidence$1, TensorNumericMath.TensorNumeric<T> ev) {
        this.rate = rate;
        this.evidence$1 = evidence$1;
        this.ev = ev;
        super(evidence$1, ev);
        Log4Error$.MODULE$.invalidInputError(rate < 1.0 && rate >= 0.0, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rate should be in range [0,1)"})).s((Seq)Nil$.MODULE$), Log4Error$.MODULE$.invalidInputError$default$3());
        this.stddev = Math.sqrt(rate / (1.0 - rate));
    }
}

