/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.nn;

import com.intel.analytics.bigdl.dllib.nn.CMul$;
import com.intel.analytics.bigdl.dllib.nn.InitializationMethod;
import com.intel.analytics.bigdl.dllib.nn.RandomUniform;
import com.intel.analytics.bigdl.dllib.nn.Utils$;
import com.intel.analytics.bigdl.dllib.nn.VariableFormat$ONE_D$;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.Initializable;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.Initializable$class;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.TensorModule;
import com.intel.analytics.bigdl.dllib.optim.Regularizer;
import com.intel.analytics.bigdl.dllib.tensor.ConvertableFrom$ConvertableFromDouble$;
import com.intel.analytics.bigdl.dllib.tensor.ConvertableFrom$ConvertableFromInt$;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.Tensor$;
import com.intel.analytics.bigdl.dllib.tensor.TensorMath;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.Shape;
import java.util.Arrays;
import scala.Array$;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t=c\u0001B\u0001\u0003\u0001=\u0011AaQ'vY*\u00111\u0001B\u0001\u0003]:T!!\u0002\u0004\u0002\u000b\u0011dG.\u001b2\u000b\u0005\u001dA\u0011!\u00022jO\u0012d'BA\u0005\u000b\u0003%\tg.\u00197zi&\u001c7O\u0003\u0002\f\u0019\u0005)\u0011N\u001c;fY*\tQ\"A\u0002d_6\u001c\u0001!\u0006\u0002\u00113M\u0019\u0001!E\u0013\u0011\u0007I)r#D\u0001\u0014\u0015\t!\"!\u0001\u0006bEN$(/Y2u]:L!AF\n\u0003\u0019Q+gn]8s\u001b>$W\u000f\\3\u0011\u0005aIB\u0002\u0001\u0003\u00065\u0001\u0011\ra\u0007\u0002\u0002)F\u0011AD\t\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\b\u001d>$\b.\u001b8h!\ti2%\u0003\u0002%=\t\u0019\u0011I\\=\u0011\u0005I1\u0013BA\u0014\u0014\u00055Ie.\u001b;jC2L'0\u00192mK\"A\u0011\u0006\u0001BC\u0002\u0013\u0005!&\u0001\u0003tSj,W#A\u0016\u0011\u0007uac&\u0003\u0002.=\t)\u0011I\u001d:bsB\u0011QdL\u0005\u0003ay\u00111!\u00138u\u0011!\u0011\u0004A!A!\u0002\u0013Y\u0013!B:ju\u0016\u0004\u0003\u0002\u0003\u001b\u0001\u0005\u0003\u0007I\u0011A\u001b\u0002\u0019]\u0014VmZ;mCJL'0\u001a:\u0016\u0003Y\u00022a\u000e\u001e\u0018\u001b\u0005A$BA\u001d\u0005\u0003\u0015y\u0007\u000f^5n\u0013\tY\u0004HA\u0006SK\u001e,H.\u0019:ju\u0016\u0014\b\u0002C\u001f\u0001\u0005\u0003\u0007I\u0011\u0001 \u0002!]\u0014VmZ;mCJL'0\u001a:`I\u0015\fHCA C!\ti\u0002)\u0003\u0002B=\t!QK\\5u\u0011\u001d\u0019E(!AA\u0002Y\n1\u0001\u001f\u00132\u0011!)\u0005A!A!B\u00131\u0014!D<SK\u001e,H.\u0019:ju\u0016\u0014\b\u0005\u0003\u0005H\u0001\t\r\t\u0015a\u0003I\u0003))g/\u001b3f]\u000e,G%\r\t\u0004\u00132;R\"\u0001&\u000b\u0005-s\u0012a\u0002:fM2,7\r^\u0005\u0003\u001b*\u0013\u0001b\u00117bgN$\u0016m\u001a\u0005\t\u001f\u0002\u0011\t\u0011)A\u0006!\u0006\u0011QM\u001e\t\u0004#\u0016<bB\u0001*c\u001d\t\u0019\u0006M\u0004\u0002U?:\u0011QK\u0018\b\u0003-vs!a\u0016/\u000f\u0005a[V\"A-\u000b\u0005is\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!!\u0019\u0003\u0002\rQ,gn]8s\u0013\t\u0019G-A\tUK:\u001cxN\u001d(v[\u0016\u0014\u0018nY'bi\"T!!\u0019\u0003\n\u0005\u0019<'!\u0004+f]N|'OT;nKJL7M\u0003\u0002dI\")\u0011\u000e\u0001C\u0001U\u00061A(\u001b8jiz\"2a\u001b9r)\ragn\u001c\t\u0004[\u00029R\"\u0001\u0002\t\u000b\u001dC\u00079\u0001%\t\u000b=C\u00079\u0001)\t\u000b%B\u0007\u0019A\u0016\t\u000fQB\u0007\u0013!a\u0001m!91\u000f\u0001b\u0001\n\u0003!\u0018AB<fS\u001eDG/F\u0001v!\r1xoF\u0007\u0002I&\u0011\u0001\u0010\u001a\u0002\u0007)\u0016t7o\u001c:\t\ri\u0004\u0001\u0015!\u0003v\u0003\u001d9X-[4ii\u0002Bq\u0001 \u0001C\u0002\u0013\u0005A/\u0001\u0006he\u0006$w+Z5hQRDaA \u0001!\u0002\u0013)\u0018aC4sC\u0012<V-[4ii\u0002B\u0001\"!\u0001\u0001\u0005\u0004%I\u0001^\u0001\u0005?N,X\u000eC\u0004\u0002\u0006\u0001\u0001\u000b\u0011B;\u0002\u000b}\u001bX/\u001c\u0011\t\u0011\u0005%\u0001A1A\u0005\nQ\fqa\u0018:fa\u0016\fG\u000fC\u0004\u0002\u000e\u0001\u0001\u000b\u0011B;\u0002\u0011}\u0013X\r]3bi\u0002Bq!!\u0005\u0001\t\u0003\n\u0019\"A\u0003sKN,G\u000fF\u0001@\u0011\u001d\t9\u0002\u0001C!\u00033\tA\"\u001e9eCR,w*\u001e;qkR$2!^A\u000e\u0011\u001d\ti\"!\u0006A\u0002U\fQ!\u001b8qkRDq!!\t\u0001\t\u0013\t\u0019#A\bnk2|e.\u001a#j[^+\u0017n\u001a5u)\u001dy\u0014QEA\u0015\u0003[Aq!a\n\u0002 \u0001\u0007a&A\u0002eS6Dq!a\u000b\u0002 \u0001\u0007Q/\u0001\u0004fqB\fg\u000e\u001a\u0005\b\u0003_\ty\u00021\u0001v\u0003\u0019yW\u000f\u001e9vi\"9\u00111\u0007\u0001\u0005B\u0005U\u0012aD;qI\u0006$Xm\u0012:bI&s\u0007/\u001e;\u0015\u000bU\f9$!\u000f\t\u000f\u0005u\u0011\u0011\u0007a\u0001k\"9\u00111HA\u0019\u0001\u0004)\u0018AC4sC\u0012|U\u000f\u001e9vi\"9\u0011q\b\u0001\u0005B\u0005\u0005\u0013!E1dG\u001e\u0013\u0018\r\u001a)be\u0006lW\r^3sgR)q(a\u0011\u0002F!9\u0011QDA\u001f\u0001\u0004)\bbBA\u001e\u0003{\u0001\r!\u001e\u0005\b\u0003\u0013\u0002A\u0011IA&\u0003)\u0001\u0018M]1nKR,'o\u001d\u000b\u0003\u0003\u001b\u0002r!HA(\u0003'\n\u0019&C\u0002\u0002Ry\u0011a\u0001V;qY\u0016\u0014\u0004cA\u000f-k\"9\u0011q\u000b\u0001\u0005B\u0005e\u0013AC2mK\u0006\u00148\u000b^1uKR\u0011\u00111L\u0007\u0002\u0001!9\u0011q\f\u0001\u0005B\u0005\u0005\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002d\u0005%\u0004cA\u000f\u0002f%\u0019\u0011q\r\u0010\u0003\u000f\t{w\u000e\\3b]\"9\u00111NA/\u0001\u0004\u0011\u0013aA8cU\"9\u0011q\u000e\u0001\u0005B\u0005E\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u00039Bq!!\u001e\u0001\t\u0003\n9(\u0001\u0005u_N#(/\u001b8h)\t\tI\b\u0005\u0003\u0002|\u0005\u0005ebA\u000f\u0002~%\u0019\u0011q\u0010\u0010\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019)!\"\u0003\rM#(/\u001b8h\u0015\r\tyH\b\u0005\b\u0003\u0013\u0003A\u0011IAF\u0003I\u0019w.\u001c9vi\u0016|U\u000f\u001e9viNC\u0017\r]3\u0015\t\u00055\u0015\u0011\u0014\t\u0005\u0003\u001f\u000b)*\u0004\u0002\u0002\u0012*\u0019\u00111\u0013\u0003\u0002\u000bU$\u0018\u000e\\:\n\t\u0005]\u0015\u0011\u0013\u0002\u0006'\"\f\u0007/\u001a\u0005\t\u00037\u000b9\t1\u0001\u0002\u000e\u0006Q\u0011N\u001c9viNC\u0017\r]3)\u000f\u0001\ty*!*\u0002(B\u0019Q$!)\n\u0007\u0005\rfD\u0001\tTKJL\u0017\r\u001c,feNLwN\\+J\t\u0006)a/\u00197vKzA10\u0017\u0006g^\u0010L\u0018}B\u0004\u0002,\nA\t!!,\u0002\t\rkU\u000f\u001c\t\u0004[\u0006=fAB\u0001\u0003\u0011\u0003\t\tl\u0005\u0004\u00020\u0006M\u0016\u0011\u0018\t\u0004;\u0005U\u0016bAA\\=\t1\u0011I\\=SK\u001a\u00042!HA^\u0013\r\tiL\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\bS\u0006=F\u0011AAa)\t\ti\u000b\u0003\u0005\u0002F\u0006=F\u0011AAd\u0003\u0015\t\u0007\u000f\u001d7z+\u0011\tI-!5\u0015\r\u0005-\u0017Q`A\u0000)\u0019\ti-a=\u0002zB!Q\u000eAAh!\rA\u0012\u0011\u001b\u0003\u000b5\u0005\r\u0007\u0015!A\u0001\u0006\u0004Y\u0002\u0006CAi\u0003+\fY.!;\u0011\u0007u\t9.C\u0002\u0002Zz\u00111b\u001d9fG&\fG.\u001b>fIFJ1%!8\u0002`\u0006\r\u0018\u0011\u001d\b\u0004;\u0005}\u0017bAAq=\u0005)a\t\\8biF2A%!:\u0002h~q1\u0001WAt\u0013\u0005y\u0012'C\u0012\u0002l\u00065\u0018\u0011_Ax\u001d\ri\u0012Q^\u0005\u0004\u0003_t\u0012A\u0002#pk\ndW-\r\u0004%\u0003K\f9o\b\u0005\u000b\u0003k\f\u0019-!AA\u0004\u0005]\u0018AC3wS\u0012,gnY3%eA!\u0011\nTAh\u0011\u001dy\u00151\u0019a\u0002\u0003w\u0004B!U3\u0002P\"1\u0011&a1A\u0002-B\u0011\u0002NAb!\u0003\u0005\rA!\u0001\u0011\t]R\u0014q\u001a\u0005\u000b\u0005\u000b\ty+%A\u0005\u0002\t\u001d\u0011aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0016\t\t%!QE\u000b\u0003\u0005\u0017QCA!\u0004\u0003\u0014A\u0019QDa\u0004\n\u0007\tEaD\u0001\u0003Ok2d7F\u0001B\u000b!\u0011\u00119B!\t\u000e\u0005\te!\u0002\u0002B\u000e\u0005;\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t}a$\u0001\u0006b]:|G/\u0019;j_:LAAa\t\u0003\u001a\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u0015i\u0011\u0019\u0001)A\u0001\u0002\u000b\u00071\u0004\u000b\u0005\u0003&\u0005U'\u0011\u0006B\u0017c%\u0019\u0013Q\\Ap\u0005W\t\t/\r\u0004%\u0003K\f9oH\u0019\nG\u0005-\u0018Q\u001eB\u0018\u0003_\fd\u0001JAs\u0003O|\u0002B\u0003B\u001a\u0003_\u000b\n\u0011\"\u0001\u00036\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*BA!\u0003\u00038\u00111!D!\rC\u0002mA!Ba\u000f\u00020\u0006\u0005I\u0011\u0002B\u001f\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t}\u0002\u0003\u0002B!\u0005\u0017j!Aa\u0011\u000b\t\t\u0015#qI\u0001\u0005Y\u0006twM\u0003\u0002\u0003J\u0005!!.\u0019<b\u0013\u0011\u0011iEa\u0011\u0003\r=\u0013'.Z2u\u0001")
public class CMul<T>
extends TensorModule<T>
implements Initializable {
    public static final long serialVersionUID = 8888147326550637025L;
    private final int[] size;
    private Regularizer<T> wRegularizer;
    private final TensorNumericMath.TensorNumeric<T> ev;
    private final Tensor<T> weight;
    private final Tensor<T> gradWeight;
    private final Tensor<T> _sum;
    private final Tensor<T> _repeat;
    private InitializationMethod weightInitMethod;
    private InitializationMethod biasInitMethod;

    public static <T> Null$ $lessinit$greater$default$2() {
        return CMul$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> Null$ apply$default$2() {
        return CMul$.MODULE$.apply$default$2();
    }

    @Override
    public InitializationMethod weightInitMethod() {
        return this.weightInitMethod;
    }

    @Override
    public void weightInitMethod_$eq(InitializationMethod x$1) {
        this.weightInitMethod = x$1;
    }

    @Override
    public InitializationMethod biasInitMethod() {
        return this.biasInitMethod;
    }

    @Override
    public void biasInitMethod_$eq(InitializationMethod x$1) {
        this.biasInitMethod = x$1;
    }

    @Override
    public Initializable setInitMethod(InitializationMethod weightInitMethod, InitializationMethod biasInitMethod) {
        return Initializable$class.setInitMethod(this, weightInitMethod, biasInitMethod);
    }

    @Override
    public Initializable setInitMethod(InitializationMethod[] initMethod) {
        return Initializable$class.setInitMethod(this, initMethod);
    }

    @Override
    public InitializationMethod setInitMethod$default$1() {
        return Initializable$class.setInitMethod$default$1(this);
    }

    @Override
    public InitializationMethod setInitMethod$default$2() {
        return Initializable$class.setInitMethod$default$2(this);
    }

    public int[] size() {
        return this.size;
    }

    public Regularizer<T> wRegularizer() {
        return this.wRegularizer;
    }

    public void wRegularizer_$eq(Regularizer<T> x$1) {
        this.wRegularizer = x$1;
    }

    public Tensor<T> weight() {
        return this.weight;
    }

    public Tensor<T> gradWeight() {
        return this.gradWeight;
    }

    private Tensor<T> _sum() {
        return this._sum;
    }

    private Tensor<T> _repeat() {
        return this._repeat;
    }

    @Override
    public void reset() {
        this.weightInitMethod().init(this.weight(), VariableFormat$ONE_D$.MODULE$, this.ev);
        this.zeroGradParameters();
    }

    @Override
    public Tensor<T> updateOutput(Tensor<T> input) {
        Object object;
        ((Tensor)this.output()).resizeAs(input).copy(input);
        if (input.nElement() == this.weight().nElement()) {
            object = ((TensorMath)this.output()).cmul(this.weight());
        } else {
            Tensor<T> expand = this.weight().dim() == input.dim() ? this.weight().view(this.weight().size()) : this.weight().view((int[])Predef$.MODULE$.intArrayOps(new int[]{1}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(this.weight().size()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
            int pivotDim = Utils$.MODULE$.getOnlyDimGtOne(expand.size());
            if (pivotDim > 0) {
                this.mulOneDimWeight(pivotDim, expand, (Tensor)this.output());
                object = BoxedUnit.UNIT;
            } else {
                expand.expandAs((Tensor)this.output());
                object = ((TensorMath)this.output()).cmul(expand);
            }
        }
        return (Tensor)this.output();
    }

    private void mulOneDimWeight(int dim, Tensor<T> expand, Tensor<T> output) {
        int outputDim = dim;
        if (expand.dim() > output.dim()) {
            int multiplyDimSize = expand.size(dim);
            int dimTemp = 1;
            while (output.size(dimTemp) != multiplyDimSize) {
                Log4Error$.MODULE$.invalidInputError(++dimTemp <= output.dim(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OutOfBound : "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output does not have a dimension of ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)multiplyDimSize)}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
            }
            outputDim = dimTemp;
        } else {
            Log4Error$.MODULE$.invalidInputError(output.size(dim) == expand.size(dim), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OutOfBound : "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output does not have a dimension of ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expand.size(dim))}))).toString(), Log4Error$.MODULE$.invalidInputError$default$3());
        }
        Tuple2<Object, Object> tuple2 = Utils$.MODULE$.getInnerOuterNum(outputDim, output);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int innerNum = tuple2._1$mcI$sp();
            int outerNum = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(innerNum, outerNum);
            int innerNum2 = sp3._1$mcI$sp();
            int outerNum2 = sp3._2$mcI$sp();
            Object weightData = expand.storage().array();
            int weightOffset = expand.storageOffset() - 1;
            int offset = output.storageOffset() - 1;
            for (int outer = 0; outer < outerNum2; ++outer) {
                for (int k = 0; k < expand.nElement(); ++k) {
                    this.ev.scal(innerNum2, ScalaRunTime$.MODULE$.array_apply(weightData, k + weightOffset), output.storage().array(), offset, 1);
                    offset += innerNum2;
                }
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    @Override
    public Tensor<T> updateGradInput(Tensor<T> input, Tensor<T> gradOutput) {
        BoxedUnit boxedUnit;
        ((Tensor)this.gradInput()).resizeAs(input).zero();
        if (this.weight().nElement() == gradOutput.nElement()) {
            boxedUnit = ((TensorMath)this.gradInput()).addcmul(this.ev.fromType(BoxesRunTime.boxToInteger((int)1), ConvertableFrom$ConvertableFromInt$.MODULE$), this.weight(), gradOutput);
        } else {
            Tensor<T> expand = this.weight().dim() == gradOutput.dim() ? this.weight().view(this.weight().size()) : this.weight().view((int[])Predef$.MODULE$.intArrayOps(new int[]{1}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(this.weight().size()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
            int pivotDim = Utils$.MODULE$.getOnlyDimGtOne(expand.size());
            if (pivotDim > 0) {
                ((Tensor)this.gradInput()).copy(gradOutput);
                this.mulOneDimWeight(pivotDim, expand, (Tensor)this.gradInput());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                expand.expandAs(gradOutput);
                boxedUnit = ((TensorMath)this.gradInput()).cmul(expand, gradOutput);
            }
        }
        return (Tensor)this.gradInput();
    }

    @Override
    public void accGradParameters(Tensor<T> input, Tensor<T> gradOutput) {
        Tensor<T> tensor;
        if (this.scaleW() == 0.0) {
            return;
        }
        if (this.weight().nElement() == gradOutput.nElement()) {
            tensor = this.gradWeight().addcmul(this.ev.fromType(BoxesRunTime.boxToDouble((double)this.scaleW()), ConvertableFrom$ConvertableFromDouble$.MODULE$), input, gradOutput);
        } else if (this.weight().dim() == input.dim()) {
            this._repeat().resizeAs(input).cmul(input, gradOutput);
            Tensor<T> sumFrom = this._repeat();
            Tensor<T> sumInto = this._sum();
            for (int i = 1; i <= this.weight().dim(); ++i) {
                if (this.weight().size(i) == input.size(i)) continue;
                sumInto.sum(sumFrom, i);
                sumInto = sumFrom;
                Tensor<T> tensor2 = sumFrom;
                Tensor<T> tensor3 = this._repeat();
                sumFrom = !(tensor2 != null ? !tensor2.equals(tensor3) : tensor3 != null) ? this._sum() : this._repeat();
            }
            tensor = this.gradWeight().add(this.ev.fromType(BoxesRunTime.boxToDouble((double)this.scaleW()), ConvertableFrom$ConvertableFromDouble$.MODULE$), sumFrom);
        } else {
            this._repeat().resizeAs(input).cmul(input, gradOutput);
            this._sum().sum(this._repeat(), 1);
            tensor = this.gradWeight().add(this.ev.fromType(BoxesRunTime.boxToDouble((double)this.scaleW()), ConvertableFrom$ConvertableFromDouble$.MODULE$), this._sum());
        }
        if (this.wRegularizer() != null && this.scaleW() != 0.0) {
            this.wRegularizer().accRegularization(this.weight(), this.gradWeight(), this.scaleW());
        }
    }

    @Override
    public Tuple2<Tensor<T>[], Tensor<T>[]> parameters() {
        return new Tuple2((Object)new Tensor[]{this.weight()}, (Object)new Tensor[]{this.gradWeight()});
    }

    public CMul<T> clearState() {
        super.clearState();
        this._repeat().set();
        this._sum().set();
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) return false;
        if (!(obj instanceof CMul)) return false;
        CMul other = (CMul)obj;
        if (this == other) {
            return true;
        }
        if (this.size() != other.size()) return false;
        Tensor<T> tensor = this.gradWeight();
        Tensor<T> tensor2 = other.gradWeight();
        if (tensor == null) {
            if (tensor2 != null) {
                return false;
            }
        } else if (!tensor.equals(tensor2)) return false;
        Tensor<T> tensor3 = this.weight();
        Tensor<T> tensor4 = other.weight();
        if (tensor3 == null) {
            if (tensor4 == null) return true;
            return false;
        } else {
            if (!tensor3.equals(tensor4)) return false;
            return true;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var2_2;
        int seed = 37;
        int hash2 = super.hashCode();
        hash2 = hash2 * seed + this.size().hashCode();
        hash2 = hash2 * seed + this.gradWeight().hashCode();
        hash2 = hash2 * seed + this.weight().hashCode();
        return (int)var2_2;
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getPrintName(), Arrays.toString(this.size())}));
    }

    @Override
    public Shape computeOutputShape(Shape inputShape) {
        return inputShape;
    }

    public CMul(int[] size, Regularizer<T> wRegularizer, ClassTag<T> evidence$1, TensorNumericMath.TensorNumeric<T> ev) {
        this.size = size;
        this.wRegularizer = wRegularizer;
        this.ev = ev;
        super(evidence$1, ev);
        Initializable$class.$init$(this);
        this.weight = Tensor$.MODULE$.apply(size, evidence$1, ev);
        this.gradWeight = Tensor$.MODULE$.apply(size, evidence$1, ev);
        this._sum = Tensor$.MODULE$.apply(evidence$1, ev);
        this._repeat = Tensor$.MODULE$.apply(evidence$1, ev);
        double stdv = 1.0 / package$.MODULE$.sqrt((double)this.weight().nElement());
        RandomUniform wInit = new RandomUniform(-stdv, stdv);
        this.setInitMethod(wInit, this.setInitMethod$default$2());
    }
}

