/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.net;

import com.intel.analytics.bigdl.dllib.keras.layers.utils.KerasUtils$;
import com.intel.analytics.bigdl.dllib.net.Meta;
import com.intel.analytics.bigdl.dllib.nn.Graph;
import com.intel.analytics.bigdl.dllib.nn.Graph$;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.AbstractModule;
import com.intel.analytics.bigdl.dllib.nn.abstractnn.Activity;
import com.intel.analytics.bigdl.dllib.tensor.Tensor;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericFloat$;
import com.intel.analytics.bigdl.dllib.utils.Log4Error$;
import com.intel.analytics.bigdl.dllib.utils.Node;
import org.apache.spark.utils.SparkUtils$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.jackson.JsonMethods$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirrors;
import scala.reflect.api.Names;
import scala.reflect.api.Symbols;
import scala.reflect.io.Path;
import scala.reflect.io.Path$;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public final class NetUtils$ {
    public static final NetUtils$ MODULE$;
    private final DefaultFormats$ formats;

    static {
        new NetUtils$();
    }

    public <T> Seq<Node<AbstractModule<Activity, Activity, T>>> getGraphOutputs(Graph<T> graph) {
        return (Seq)KerasUtils$.MODULE$.invokeMethod(graph, "outputs", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[0]));
    }

    public <T> Option<Tuple2<Tensor<T>[], Tensor<T>[]>> getGraphVariables(Graph<T> graph) {
        return (Option)KerasUtils$.MODULE$.invokeMethod(graph, "variables", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[0]));
    }

    public <T> boolean getGenerateBackward(Graph<T> graph) {
        return BoxesRunTime.unboxToBoolean((Object)KerasUtils$.MODULE$.invokeMethod(graph, "generateBackward", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[0])));
    }

    public <T> Graph<T> dynamic(Node<AbstractModule<Activity, Activity, T>>[] input, Node<AbstractModule<Activity, Activity, T>>[] output, Option<Tuple2<Tensor<T>[], Tensor<T>[]>> variables, boolean generateBackward, TensorNumericMath.TensorNumeric<T> ev, ClassTag<T> ev2) {
        JavaUniverse.JavaMirror m3 = package$.MODULE$.universe().runtimeMirror(Graph$.MODULE$.getClass().getClassLoader());
        Mirrors.InstanceMirror mirror = m3.reflect((Object)Graph$.MODULE$, ClassTag$.MODULE$.apply(Graph$.class));
        Symbols.SymbolApi dynamic = mirror.symbol().typeSignature().member((Names.NameApi)((Names)package$.MODULE$.universe()).newTermName("dynamic")).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Symbols.SymbolApi x$3) {
                return ((LinearSeqOptimized)x$3.asMethod().paramss().flatten((Function1)Predef$.MODULE$.$conforms())).length() == 6;
            }
        });
        Object result2 = mirror.reflectMethod(dynamic.asMethod()).apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input, output, variables, BoxesRunTime.boxToBoolean((boolean)generateBackward), ev2, ev}));
        return (Graph)result2;
    }

    public <T> None$ dynamic$default$3() {
        return None$.MODULE$;
    }

    public <T> boolean dynamic$default$4() {
        return true;
    }

    public DefaultFormats$ formats() {
        return this.formats;
    }

    public Tuple2<String, Meta> processTFFolder(String folder) {
        Path metaPath;
        Path modelPath;
        Path folderPath = Path$.MODULE$.apply(folder);
        if (!folderPath.exists()) {
            Log4Error$.MODULE$.invalidInputError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folder})), Log4Error$.MODULE$.invalidInputError$default$3());
        }
        if (!(modelPath = folderPath.$div(Path$.MODULE$.apply("frozen_inference_graph.pb"))).exists()) {
            Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelPath.path()})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        }
        if (!(metaPath = folderPath.$div(Path$.MODULE$.apply("graph_meta.json"))).exists()) {
            Log4Error$.MODULE$.invalidOperationError(false, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metaPath.path()})), Log4Error$.MODULE$.invalidOperationError$default$3(), Log4Error$.MODULE$.invalidOperationError$default$4());
        }
        String jsonStr = Source$.MODULE$.fromFile(metaPath.jfile(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
        Meta meta = (Meta)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(JsonMethods$.MODULE$.parse(org.json4s.package$.MODULE$.string2JsonInput(jsonStr), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).camelizeKeys()).extract((Formats)this.formats(), ManifestFactory$.MODULE$.classType(Meta.class));
        return new Tuple2((Object)modelPath.toString(), (Object)meta);
    }

    public Seq<String> removePort(Seq<String> nodes2) {
        return (Seq)nodes2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String node) {
                return node.contains(":") ? node.split(":")[0] : node;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public boolean isDriver() {
        boolean bl;
        try {
            bl = SparkUtils$.MODULE$.isDriver();
        }
        catch (NullPointerException nullPointerException) {
            bl = true;
        }
        return bl;
    }

    public void generateZeroGrad(Activity input, Activity grad) {
        if (grad.isTable()) {
            for (int i = 0; i < grad.toTable().length(); ++i) {
                ((Tensor)grad.toTable().apply(BoxesRunTime.boxToInteger((int)(i + 1)))).resizeAs((Tensor)input.toTable().apply(BoxesRunTime.boxToInteger((int)(i + 1))));
            }
        } else {
            grad.toTensor(TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$).resizeAs(input.toTensor(TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$));
        }
    }

    private NetUtils$() {
        MODULE$ = this;
        this.formats = DefaultFormats$.MODULE$;
    }
}

