/*
 * Decompiled with CFR 0.152.
 */
package com.intel.analytics.bigdl.dllib.models.vgg;

import com.intel.analytics.bigdl.dllib.feature.dataset.AbstractDataSet;
import com.intel.analytics.bigdl.dllib.feature.dataset.ByteRecord;
import com.intel.analytics.bigdl.dllib.feature.dataset.DataSet$SeqFileFolder$;
import com.intel.analytics.bigdl.dllib.feature.dataset.MiniBatch;
import com.intel.analytics.bigdl.dllib.feature.dataset.image.CropCenter$;
import com.intel.analytics.bigdl.dllib.feature.dataset.image.CropRandom$;
import com.intel.analytics.bigdl.dllib.feature.transform.vision.image.MTImageFeatureToBatch$;
import com.intel.analytics.bigdl.dllib.feature.transform.vision.image.MatToTensor$;
import com.intel.analytics.bigdl.dllib.feature.transform.vision.image.PixelBytesToMat$;
import com.intel.analytics.bigdl.dllib.feature.transform.vision.image.augmentation.ChannelScaledNormalizer$;
import com.intel.analytics.bigdl.dllib.feature.transform.vision.image.augmentation.RandomCropper$;
import com.intel.analytics.bigdl.dllib.feature.transform.vision.image.augmentation.RandomResize$;
import com.intel.analytics.bigdl.dllib.models.vgg.Utils;
import com.intel.analytics.bigdl.dllib.tensor.TensorNumericMath$TensorNumeric$NumericFloat$;
import com.intel.analytics.bigdl.dllib.utils.File$;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.spark.SparkContext;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scopt.OptionParser;
import scopt.Read$;

public final class Utils$ {
    public static final Utils$ MODULE$;
    private final Tuple3<Object, Object, Object> trainMean;
    private final Tuple3<Object, Object, Object> trainStd;
    private final Tuple3<Object, Object, Object> testMean;
    private final Tuple3<Object, Object, Object> testStd;
    private final OptionParser<Utils.TrainParams> trainParser;
    private final OptionParser<Utils.TestParams> testParser;

    static {
        new Utils$();
    }

    public Tuple3<Object, Object, Object> trainMean() {
        return this.trainMean;
    }

    public Tuple3<Object, Object, Object> trainStd() {
        return this.trainStd;
    }

    public Tuple3<Object, Object, Object> testMean() {
        return this.testMean;
    }

    public Tuple3<Object, Object, Object> testStd() {
        return this.testStd;
    }

    public OptionParser<Utils.TrainParams> trainParser() {
        return this.trainParser;
    }

    public OptionParser<Utils.TestParams> testParser() {
        return this.testParser;
    }

    public ByteRecord[] loadTrain(String dataFile) {
        String[] allFiles = (String[])((Object[])new String[]{new StringBuilder().append((Object)dataFile).append((Object)"/data_batch_1.bin").toString(), new StringBuilder().append((Object)dataFile).append((Object)"/data_batch_2.bin").toString(), new StringBuilder().append((Object)dataFile).append((Object)"/data_batch_3.bin").toString(), new StringBuilder().append((Object)dataFile).append((Object)"/data_batch_4.bin").toString(), new StringBuilder().append((Object)dataFile).append((Object)"/data_batch_5.bin").toString()});
        ArrayBuffer result2 = new ArrayBuffer();
        Predef$.MODULE$.refArrayOps((Object[])allFiles).foreach((Function1)new Serializable(result2){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer result$1;

            public final void apply(String x$2) {
                Utils$.MODULE$.load(x$2, (ArrayBuffer<ByteRecord>)this.result$1);
            }
            {
                this.result$1 = result$1;
            }
        });
        return (ByteRecord[])result2.toArray(ClassTag$.MODULE$.apply(ByteRecord.class));
    }

    public ByteRecord[] loadTest(String dataFile) {
        ArrayBuffer result2 = new ArrayBuffer();
        String testFile = new StringBuilder().append((Object)dataFile).append((Object)"/test_batch.bin").toString();
        this.load(testFile, (ArrayBuffer<ByteRecord>)result2);
        return (ByteRecord[])result2.toArray(ClassTag$.MODULE$.apply(ByteRecord.class));
    }

    public void load(String featureFile, ArrayBuffer<ByteRecord> result2) {
        int rowNum = 32;
        int colNum = 32;
        int imageOffset = rowNum * colNum * 3 + 1;
        int channelOffset = rowNum * colNum;
        int bufferOffset = 8;
        ByteBuffer featureBuffer = featureFile.startsWith(File$.MODULE$.hdfsPrefix()) ? ByteBuffer.wrap(File$.MODULE$.readHdfsByte(featureFile)) : ByteBuffer.wrap(Files.readAllBytes(Paths.get(featureFile, new String[0])));
        byte[] featureArray = featureBuffer.array();
        int featureCount = featureArray.length / (rowNum * colNum * 3 + 1);
        for (int i = 0; i < featureCount; ++i) {
            byte[] img = new byte[rowNum * colNum * 3 + bufferOffset];
            ByteBuffer byteBuffer = ByteBuffer.wrap(img);
            byteBuffer.putInt(rowNum);
            byteBuffer.putInt(colNum);
            float label = featureArray[i * imageOffset];
            int start2 = i * imageOffset + 1;
            for (int y = 0; y < rowNum; ++y) {
                for (int x = 0; x < colNum; ++x) {
                    img[(x + y * colNum) * 3 + 2 + bufferOffset] = featureArray[start2 + x + y * colNum];
                    img[(x + y * colNum) * 3 + 1 + bufferOffset] = featureArray[start2 + x + y * colNum + channelOffset];
                    img[(x + y * colNum) * 3 + bufferOffset] = featureArray[start2 + x + y * colNum + 2 * channelOffset];
                }
            }
            result2.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ByteRecord[]{new ByteRecord(img, label + 1.0f)}));
        }
    }

    public AbstractDataSet<MiniBatch<Object>, ?> valDataSet(String path, SparkContext sc, int imageSize, int batchSize) {
        return DataSet$SeqFileFolder$.MODULE$.filesToImageFeatureDataset(path, sc, 1000, DataSet$SeqFileFolder$.MODULE$.filesToImageFeatureDataset$default$4()).transform(MTImageFeatureToBatch$.MODULE$.apply(imageSize, imageSize, batchSize, PixelBytesToMat$.MODULE$.apply(PixelBytesToMat$.MODULE$.apply$default$1()).$minus$greater(RandomResize$.MODULE$.apply(256, 256)).$minus$greater(RandomCropper$.MODULE$.apply(224, 224, false, CropCenter$.MODULE$, RandomCropper$.MODULE$.apply$default$5())).$minus$greater(ChannelScaledNormalizer$.MODULE$.apply(104, 117, 124, 1.0)).$minus$greater(MatToTensor$.MODULE$.apply(MatToTensor$.MODULE$.apply$default$1(), MatToTensor$.MODULE$.apply$default$2(), MatToTensor$.MODULE$.apply$default$3(), MatToTensor$.MODULE$.apply$default$4(), ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$)), false), ClassTag$.MODULE$.apply(MiniBatch.class));
    }

    public AbstractDataSet<MiniBatch<Object>, ?> trainDataSet(String path, SparkContext sc, int imageSize, int batchSize) {
        return DataSet$SeqFileFolder$.MODULE$.filesToImageFeatureDataset(path, sc, 1000, DataSet$SeqFileFolder$.MODULE$.filesToImageFeatureDataset$default$4()).transform(MTImageFeatureToBatch$.MODULE$.apply(imageSize, imageSize, batchSize, PixelBytesToMat$.MODULE$.apply(PixelBytesToMat$.MODULE$.apply$default$1()).$minus$greater(RandomResize$.MODULE$.apply(256, 256)).$minus$greater(RandomCropper$.MODULE$.apply(224, 224, true, CropRandom$.MODULE$, RandomCropper$.MODULE$.apply$default$5())).$minus$greater(ChannelScaledNormalizer$.MODULE$.apply(104, 117, 124, 1.0)).$minus$greater(MatToTensor$.MODULE$.apply(MatToTensor$.MODULE$.apply$default$1(), MatToTensor$.MODULE$.apply$default$2(), MatToTensor$.MODULE$.apply$default$3(), MatToTensor$.MODULE$.apply$default$4(), ClassTag$.MODULE$.Float(), TensorNumericMath$TensorNumeric$NumericFloat$.MODULE$)), false), ClassTag$.MODULE$.apply(MiniBatch.class));
    }

    private Utils$() {
        MODULE$ = this;
        this.trainMean = new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.4913996898739353), (Object)BoxesRunTime.boxToDouble((double)0.4821584196221302), (Object)BoxesRunTime.boxToDouble((double)0.44653092422369434));
        this.trainStd = new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.24703223517429462), (Object)BoxesRunTime.boxToDouble((double)0.2434851308749409), (Object)BoxesRunTime.boxToDouble((double)0.26158784442034005));
        this.testMean = new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.4942142913295297), (Object)BoxesRunTime.boxToDouble((double)0.4851314002725445), (Object)BoxesRunTime.boxToDouble((double)0.45040910258647154));
        this.testStd = new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.2466525177466614), (Object)BoxesRunTime.boxToDouble((double)0.2428922662655766), (Object)BoxesRunTime.boxToDouble((double)0.26159238066790275));
        this.trainParser = new OptionParser<Utils.TrainParams>(){
            {
                this.opt('f', "folder", Read$.MODULE$.stringRead()).text("where you put the Cifar10 data").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13(), c.copy$default$14(), c.copy$default$15(), c.copy$default$16(), c.copy$default$17(), c.copy$default$18(), c.copy$default$19(), c.copy$default$20(), c.copy$default$21(), c.copy$default$22());
                    }
                });
                this.opt("model", Read$.MODULE$.stringRead()).text("model snapshot location").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$9 = new Some((Object)x);
                        String x$10 = c.copy$default$1();
                        Option<String> x$11 = c.copy$default$2();
                        Option<String> x$12 = c.copy$default$4();
                        Option<String> x$13 = c.copy$default$5();
                        int x$14 = c.copy$default$6();
                        int x$15 = c.copy$default$7();
                        boolean x$16 = c.copy$default$8();
                        double x$17 = c.copy$default$9();
                        double x$18 = c.copy$default$10();
                        boolean x$19 = c.copy$default$11();
                        int x$20 = c.copy$default$12();
                        double x$21 = c.copy$default$13();
                        double x$22 = c.copy$default$14();
                        boolean x$23 = c.copy$default$15();
                        int x$24 = c.copy$default$16();
                        String x$25 = c.copy$default$17();
                        int x$26 = c.copy$default$18();
                        double x$27 = c.copy$default$19();
                        Option<Object> x$28 = c.copy$default$20();
                        Option<Object> x$29 = c.copy$default$21();
                        Option<String> x$30 = c.copy$default$22();
                        return c.copy(x$10, x$11, (Option<String>)x$9, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30);
                    }
                });
                this.opt("state", Read$.MODULE$.stringRead()).text("state snapshot location").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$31 = new Some((Object)x);
                        String x$32 = c.copy$default$1();
                        Option<String> x$33 = c.copy$default$2();
                        Option<String> x$34 = c.copy$default$3();
                        Option<String> x$35 = c.copy$default$5();
                        int x$36 = c.copy$default$6();
                        int x$37 = c.copy$default$7();
                        boolean x$38 = c.copy$default$8();
                        double x$39 = c.copy$default$9();
                        double x$40 = c.copy$default$10();
                        boolean x$41 = c.copy$default$11();
                        int x$42 = c.copy$default$12();
                        double x$43 = c.copy$default$13();
                        double x$44 = c.copy$default$14();
                        boolean x$45 = c.copy$default$15();
                        int x$46 = c.copy$default$16();
                        String x$47 = c.copy$default$17();
                        int x$48 = c.copy$default$18();
                        double x$49 = c.copy$default$19();
                        Option<Object> x$50 = c.copy$default$20();
                        Option<Object> x$51 = c.copy$default$21();
                        Option<String> x$52 = c.copy$default$22();
                        return c.copy(x$32, x$33, x$34, (Option<String>)x$31, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52);
                    }
                });
                this.opt("checkpoint", Read$.MODULE$.stringRead()).text("where to cache the model and state").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$53 = new Some((Object)x);
                        String x$54 = c.copy$default$1();
                        Option<String> x$55 = c.copy$default$3();
                        Option<String> x$56 = c.copy$default$4();
                        Option<String> x$57 = c.copy$default$5();
                        int x$58 = c.copy$default$6();
                        int x$59 = c.copy$default$7();
                        boolean x$60 = c.copy$default$8();
                        double x$61 = c.copy$default$9();
                        double x$62 = c.copy$default$10();
                        boolean x$63 = c.copy$default$11();
                        int x$64 = c.copy$default$12();
                        double x$65 = c.copy$default$13();
                        double x$66 = c.copy$default$14();
                        boolean x$67 = c.copy$default$15();
                        int x$68 = c.copy$default$16();
                        String x$69 = c.copy$default$17();
                        int x$70 = c.copy$default$18();
                        double x$71 = c.copy$default$19();
                        Option<Object> x$72 = c.copy$default$20();
                        Option<Object> x$73 = c.copy$default$21();
                        Option<String> x$74 = c.copy$default$22();
                        return c.copy(x$54, (Option<String>)x$53, x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74);
                    }
                });
                this.opt("summary", Read$.MODULE$.stringRead()).text("where to store the training summary").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$75 = new Some((Object)x);
                        String x$76 = c.copy$default$1();
                        Option<String> x$77 = c.copy$default$2();
                        Option<String> x$78 = c.copy$default$3();
                        Option<String> x$79 = c.copy$default$4();
                        int x$80 = c.copy$default$6();
                        int x$81 = c.copy$default$7();
                        boolean x$82 = c.copy$default$8();
                        double x$83 = c.copy$default$9();
                        double x$84 = c.copy$default$10();
                        boolean x$85 = c.copy$default$11();
                        int x$86 = c.copy$default$12();
                        double x$87 = c.copy$default$13();
                        double x$88 = c.copy$default$14();
                        boolean x$89 = c.copy$default$15();
                        int x$90 = c.copy$default$16();
                        String x$91 = c.copy$default$17();
                        int x$92 = c.copy$default$18();
                        double x$93 = c.copy$default$19();
                        Option<Object> x$94 = c.copy$default$20();
                        Option<Object> x$95 = c.copy$default$21();
                        Option<String> x$96 = c.copy$default$22();
                        return c.copy(x$76, x$77, x$78, x$79, (Option<String>)x$75, x$80, x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95, x$96);
                    }
                });
                this.opt('e', "maxEpoch", Read$.MODULE$.intRead()).text("epoch numbers").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        int x$97 = x;
                        String x$98 = c.copy$default$1();
                        Option<String> x$99 = c.copy$default$2();
                        Option<String> x$100 = c.copy$default$3();
                        Option<String> x$101 = c.copy$default$4();
                        Option<String> x$102 = c.copy$default$5();
                        int x$103 = c.copy$default$6();
                        boolean x$104 = c.copy$default$8();
                        double x$105 = c.copy$default$9();
                        double x$106 = c.copy$default$10();
                        boolean x$107 = c.copy$default$11();
                        int x$108 = c.copy$default$12();
                        double x$109 = c.copy$default$13();
                        double x$110 = c.copy$default$14();
                        boolean x$111 = c.copy$default$15();
                        int x$112 = c.copy$default$16();
                        String x$113 = c.copy$default$17();
                        int x$114 = c.copy$default$18();
                        double x$115 = c.copy$default$19();
                        Option<Object> x$116 = c.copy$default$20();
                        Option<Object> x$117 = c.copy$default$21();
                        Option<String> x$118 = c.copy$default$22();
                        return c.copy(x$98, x$99, x$100, x$101, x$102, x$103, x$97, x$104, x$105, x$106, x$107, x$108, x$109, x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118);
                    }
                });
                this.opt('b', "batchSize", Read$.MODULE$.intRead()).text("batch size").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        int x$119 = x;
                        String x$120 = c.copy$default$1();
                        Option<String> x$121 = c.copy$default$2();
                        Option<String> x$122 = c.copy$default$3();
                        Option<String> x$123 = c.copy$default$4();
                        Option<String> x$124 = c.copy$default$5();
                        int x$125 = c.copy$default$7();
                        boolean x$126 = c.copy$default$8();
                        double x$127 = c.copy$default$9();
                        double x$128 = c.copy$default$10();
                        boolean x$129 = c.copy$default$11();
                        int x$130 = c.copy$default$12();
                        double x$131 = c.copy$default$13();
                        double x$132 = c.copy$default$14();
                        boolean x$133 = c.copy$default$15();
                        int x$134 = c.copy$default$16();
                        String x$135 = c.copy$default$17();
                        int x$136 = c.copy$default$18();
                        double x$137 = c.copy$default$19();
                        Option<Object> x$138 = c.copy$default$20();
                        Option<Object> x$139 = c.copy$default$21();
                        Option<String> x$140 = c.copy$default$22();
                        return c.copy(x$120, x$121, x$122, x$123, x$124, x$119, x$125, x$126, x$127, x$128, x$129, x$130, x$131, x$132, x$133, x$134, x$135, x$136, x$137, x$138, x$139, x$140);
                    }
                });
                this.opt("overWrite", Read$.MODULE$.unitRead()).text("overwrite checkpoint files").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(BoxedUnit x$1, Utils.TrainParams c) {
                        boolean x$141 = true;
                        String x$142 = c.copy$default$1();
                        Option<String> x$143 = c.copy$default$2();
                        Option<String> x$144 = c.copy$default$3();
                        Option<String> x$145 = c.copy$default$4();
                        Option<String> x$146 = c.copy$default$5();
                        int x$147 = c.copy$default$6();
                        int x$148 = c.copy$default$7();
                        double x$149 = c.copy$default$9();
                        double x$150 = c.copy$default$10();
                        boolean x$151 = c.copy$default$11();
                        int x$152 = c.copy$default$12();
                        double x$153 = c.copy$default$13();
                        double x$154 = c.copy$default$14();
                        boolean x$155 = c.copy$default$15();
                        int x$156 = c.copy$default$16();
                        String x$157 = c.copy$default$17();
                        int x$158 = c.copy$default$18();
                        double x$159 = c.copy$default$19();
                        Option<Object> x$160 = c.copy$default$20();
                        Option<Object> x$161 = c.copy$default$21();
                        Option<String> x$162 = c.copy$default$22();
                        return c.copy(x$142, x$143, x$144, x$145, x$146, x$147, x$148, x$141, x$149, x$150, x$151, x$152, x$153, x$154, x$155, x$156, x$157, x$158, x$159, x$160, x$161, x$162);
                    }
                });
                this.opt("weightDecay", Read$.MODULE$.doubleRead()).text("weight decay").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(double x, Utils.TrainParams c) {
                        double x$163 = x;
                        String x$164 = c.copy$default$1();
                        Option<String> x$165 = c.copy$default$2();
                        Option<String> x$166 = c.copy$default$3();
                        Option<String> x$167 = c.copy$default$4();
                        Option<String> x$168 = c.copy$default$5();
                        int x$169 = c.copy$default$6();
                        int x$170 = c.copy$default$7();
                        boolean x$171 = c.copy$default$8();
                        double x$172 = c.copy$default$9();
                        boolean x$173 = c.copy$default$11();
                        int x$174 = c.copy$default$12();
                        double x$175 = c.copy$default$13();
                        double x$176 = c.copy$default$14();
                        boolean x$177 = c.copy$default$15();
                        int x$178 = c.copy$default$16();
                        String x$179 = c.copy$default$17();
                        int x$180 = c.copy$default$18();
                        double x$181 = c.copy$default$19();
                        Option<Object> x$182 = c.copy$default$20();
                        Option<Object> x$183 = c.copy$default$21();
                        Option<String> x$184 = c.copy$default$22();
                        return c.copy(x$164, x$165, x$166, x$167, x$168, x$169, x$170, x$171, x$172, x$163, x$173, x$174, x$175, x$176, x$177, x$178, x$179, x$180, x$181, x$182, x$183, x$184);
                    }
                });
                this.opt('l', "learningRate", Read$.MODULE$.doubleRead()).text("inital learning rate").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(double x, Utils.TrainParams c) {
                        double x$185 = x;
                        String x$186 = c.copy$default$1();
                        Option<String> x$187 = c.copy$default$2();
                        Option<String> x$188 = c.copy$default$3();
                        Option<String> x$189 = c.copy$default$4();
                        Option<String> x$190 = c.copy$default$5();
                        int x$191 = c.copy$default$6();
                        int x$192 = c.copy$default$7();
                        boolean x$193 = c.copy$default$8();
                        double x$194 = c.copy$default$10();
                        boolean x$195 = c.copy$default$11();
                        int x$196 = c.copy$default$12();
                        double x$197 = c.copy$default$13();
                        double x$198 = c.copy$default$14();
                        boolean x$199 = c.copy$default$15();
                        int x$200 = c.copy$default$16();
                        String x$201 = c.copy$default$17();
                        int x$202 = c.copy$default$18();
                        double x$203 = c.copy$default$19();
                        Option<Object> x$204 = c.copy$default$20();
                        Option<Object> x$205 = c.copy$default$21();
                        Option<String> x$206 = c.copy$default$22();
                        return c.copy(x$186, x$187, x$188, x$189, x$190, x$191, x$192, x$193, x$185, x$194, x$195, x$196, x$197, x$198, x$199, x$200, x$201, x$202, x$203, x$204, x$205, x$206);
                    }
                });
                this.opt('g', "graphModel", Read$.MODULE$.unitRead()).text("use graph model").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(BoxedUnit x, Utils.TrainParams c) {
                        boolean x$207 = true;
                        String x$208 = c.copy$default$1();
                        Option<String> x$209 = c.copy$default$2();
                        Option<String> x$210 = c.copy$default$3();
                        Option<String> x$211 = c.copy$default$4();
                        Option<String> x$212 = c.copy$default$5();
                        int x$213 = c.copy$default$6();
                        int x$214 = c.copy$default$7();
                        boolean x$215 = c.copy$default$8();
                        double x$216 = c.copy$default$9();
                        double x$217 = c.copy$default$10();
                        int x$218 = c.copy$default$12();
                        double x$219 = c.copy$default$13();
                        double x$220 = c.copy$default$14();
                        boolean x$221 = c.copy$default$15();
                        int x$222 = c.copy$default$16();
                        String x$223 = c.copy$default$17();
                        int x$224 = c.copy$default$18();
                        double x$225 = c.copy$default$19();
                        Option<Object> x$226 = c.copy$default$20();
                        Option<Object> x$227 = c.copy$default$21();
                        Option<String> x$228 = c.copy$default$22();
                        return c.copy(x$208, x$209, x$210, x$211, x$212, x$213, x$214, x$215, x$216, x$217, x$207, x$218, x$219, x$220, x$221, x$222, x$223, x$224, x$225, x$226, x$227, x$228);
                    }
                });
                this.opt('i', "maxIteration", Read$.MODULE$.intRead()).text("iteration numbers").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        int x$229 = x;
                        String x$230 = c.copy$default$1();
                        Option<String> x$231 = c.copy$default$2();
                        Option<String> x$232 = c.copy$default$3();
                        Option<String> x$233 = c.copy$default$4();
                        Option<String> x$234 = c.copy$default$5();
                        int x$235 = c.copy$default$6();
                        int x$236 = c.copy$default$7();
                        boolean x$237 = c.copy$default$8();
                        double x$238 = c.copy$default$9();
                        double x$239 = c.copy$default$10();
                        boolean x$240 = c.copy$default$11();
                        double x$241 = c.copy$default$13();
                        double x$242 = c.copy$default$14();
                        boolean x$243 = c.copy$default$15();
                        int x$244 = c.copy$default$16();
                        String x$245 = c.copy$default$17();
                        int x$246 = c.copy$default$18();
                        double x$247 = c.copy$default$19();
                        Option<Object> x$248 = c.copy$default$20();
                        Option<Object> x$249 = c.copy$default$21();
                        Option<String> x$250 = c.copy$default$22();
                        return c.copy(x$230, x$231, x$232, x$233, x$234, x$235, x$236, x$237, x$238, x$239, x$240, x$229, x$241, x$242, x$243, x$244, x$245, x$246, x$247, x$248, x$249, x$250);
                    }
                });
                this.opt("classNum", Read$.MODULE$.intRead()).text("class number").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        int x$251 = x;
                        String x$252 = c.copy$default$1();
                        Option<String> x$253 = c.copy$default$2();
                        Option<String> x$254 = c.copy$default$3();
                        Option<String> x$255 = c.copy$default$4();
                        Option<String> x$256 = c.copy$default$5();
                        int x$257 = c.copy$default$6();
                        int x$258 = c.copy$default$7();
                        boolean x$259 = c.copy$default$8();
                        double x$260 = c.copy$default$9();
                        double x$261 = c.copy$default$10();
                        boolean x$262 = c.copy$default$11();
                        int x$263 = c.copy$default$12();
                        double x$264 = c.copy$default$13();
                        double x$265 = c.copy$default$14();
                        boolean x$266 = c.copy$default$15();
                        String x$267 = c.copy$default$17();
                        int x$268 = c.copy$default$18();
                        double x$269 = c.copy$default$19();
                        Option<Object> x$270 = c.copy$default$20();
                        Option<Object> x$271 = c.copy$default$21();
                        Option<String> x$272 = c.copy$default$22();
                        return c.copy(x$252, x$253, x$254, x$255, x$256, x$257, x$258, x$259, x$260, x$261, x$262, x$263, x$264, x$265, x$266, x$251, x$267, x$268, x$269, x$270, x$271, x$272);
                    }
                });
                this.opt("checkpointIteration", Read$.MODULE$.intRead()).text("checkpoint interval of iterations").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        int x$273 = x;
                        String x$274 = c.copy$default$1();
                        Option<String> x$275 = c.copy$default$2();
                        Option<String> x$276 = c.copy$default$3();
                        Option<String> x$277 = c.copy$default$4();
                        Option<String> x$278 = c.copy$default$5();
                        int x$279 = c.copy$default$6();
                        int x$280 = c.copy$default$7();
                        boolean x$281 = c.copy$default$8();
                        double x$282 = c.copy$default$9();
                        double x$283 = c.copy$default$10();
                        boolean x$284 = c.copy$default$11();
                        int x$285 = c.copy$default$12();
                        double x$286 = c.copy$default$13();
                        double x$287 = c.copy$default$14();
                        boolean x$288 = c.copy$default$15();
                        int x$289 = c.copy$default$16();
                        String x$290 = c.copy$default$17();
                        double x$291 = c.copy$default$19();
                        Option<Object> x$292 = c.copy$default$20();
                        Option<Object> x$293 = c.copy$default$21();
                        Option<String> x$294 = c.copy$default$22();
                        return c.copy(x$274, x$275, x$276, x$277, x$278, x$279, x$280, x$281, x$282, x$283, x$284, x$285, x$286, x$287, x$288, x$289, x$290, x$273, x$291, x$292, x$293, x$294);
                    }
                });
                this.opt("weightDecay", Read$.MODULE$.doubleRead()).text("weight decay").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(double x, Utils.TrainParams c) {
                        double x$295 = x;
                        String x$296 = c.copy$default$1();
                        Option<String> x$297 = c.copy$default$2();
                        Option<String> x$298 = c.copy$default$3();
                        Option<String> x$299 = c.copy$default$4();
                        Option<String> x$300 = c.copy$default$5();
                        int x$301 = c.copy$default$6();
                        int x$302 = c.copy$default$7();
                        boolean x$303 = c.copy$default$8();
                        double x$304 = c.copy$default$9();
                        boolean x$305 = c.copy$default$11();
                        int x$306 = c.copy$default$12();
                        double x$307 = c.copy$default$13();
                        double x$308 = c.copy$default$14();
                        boolean x$309 = c.copy$default$15();
                        int x$310 = c.copy$default$16();
                        String x$311 = c.copy$default$17();
                        int x$312 = c.copy$default$18();
                        double x$313 = c.copy$default$19();
                        Option<Object> x$314 = c.copy$default$20();
                        Option<Object> x$315 = c.copy$default$21();
                        Option<String> x$316 = c.copy$default$22();
                        return c.copy(x$296, x$297, x$298, x$299, x$300, x$301, x$302, x$303, x$304, x$295, x$305, x$306, x$307, x$308, x$309, x$310, x$311, x$312, x$313, x$314, x$315, x$316);
                    }
                });
                this.opt("maxLr", Read$.MODULE$.doubleRead()).text("max Lr after warm up").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(double x, Utils.TrainParams c) {
                        double x$317 = x;
                        String x$318 = c.copy$default$1();
                        Option<String> x$319 = c.copy$default$2();
                        Option<String> x$320 = c.copy$default$3();
                        Option<String> x$321 = c.copy$default$4();
                        Option<String> x$322 = c.copy$default$5();
                        int x$323 = c.copy$default$6();
                        int x$324 = c.copy$default$7();
                        boolean x$325 = c.copy$default$8();
                        double x$326 = c.copy$default$9();
                        double x$327 = c.copy$default$10();
                        boolean x$328 = c.copy$default$11();
                        int x$329 = c.copy$default$12();
                        double x$330 = c.copy$default$13();
                        double x$331 = c.copy$default$14();
                        boolean x$332 = c.copy$default$15();
                        int x$333 = c.copy$default$16();
                        String x$334 = c.copy$default$17();
                        int x$335 = c.copy$default$18();
                        Option<Object> x$336 = c.copy$default$20();
                        Option<Object> x$337 = c.copy$default$21();
                        Option<String> x$338 = c.copy$default$22();
                        return c.copy(x$318, x$319, x$320, x$321, x$322, x$323, x$324, x$325, x$326, x$327, x$328, x$329, x$330, x$331, x$332, x$333, x$334, x$335, x$317, x$336, x$337, x$338);
                    }
                });
                this.opt("warmupEpoch", Read$.MODULE$.intRead()).text("warm up epoch numbers").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(int x, Utils.TrainParams c) {
                        Some x$339 = new Some((Object)BoxesRunTime.boxToInteger((int)x));
                        String x$340 = c.copy$default$1();
                        Option<String> x$341 = c.copy$default$2();
                        Option<String> x$342 = c.copy$default$3();
                        Option<String> x$343 = c.copy$default$4();
                        Option<String> x$344 = c.copy$default$5();
                        int x$345 = c.copy$default$6();
                        int x$346 = c.copy$default$7();
                        boolean x$347 = c.copy$default$8();
                        double x$348 = c.copy$default$9();
                        double x$349 = c.copy$default$10();
                        boolean x$350 = c.copy$default$11();
                        int x$351 = c.copy$default$12();
                        double x$352 = c.copy$default$13();
                        double x$353 = c.copy$default$14();
                        boolean x$354 = c.copy$default$15();
                        int x$355 = c.copy$default$16();
                        String x$356 = c.copy$default$17();
                        int x$357 = c.copy$default$18();
                        double x$358 = c.copy$default$19();
                        Option<Object> x$359 = c.copy$default$21();
                        Option<String> x$360 = c.copy$default$22();
                        return c.copy(x$340, x$341, x$342, x$343, x$344, x$345, x$346, x$347, x$348, x$349, x$350, x$351, x$352, x$353, x$354, x$355, x$356, x$357, x$358, (Option<Object>)x$339, x$359, x$360);
                    }
                });
                this.opt("gradientL2NormThreshold", Read$.MODULE$.doubleRead()).text("gradient L2-Norm threshold").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(double x, Utils.TrainParams c) {
                        Some x$361 = new Some((Object)BoxesRunTime.boxToDouble((double)x));
                        String x$362 = c.copy$default$1();
                        Option<String> x$363 = c.copy$default$2();
                        Option<String> x$364 = c.copy$default$3();
                        Option<String> x$365 = c.copy$default$4();
                        Option<String> x$366 = c.copy$default$5();
                        int x$367 = c.copy$default$6();
                        int x$368 = c.copy$default$7();
                        boolean x$369 = c.copy$default$8();
                        double x$370 = c.copy$default$9();
                        double x$371 = c.copy$default$10();
                        boolean x$372 = c.copy$default$11();
                        int x$373 = c.copy$default$12();
                        double x$374 = c.copy$default$13();
                        double x$375 = c.copy$default$14();
                        boolean x$376 = c.copy$default$15();
                        int x$377 = c.copy$default$16();
                        String x$378 = c.copy$default$17();
                        int x$379 = c.copy$default$18();
                        double x$380 = c.copy$default$19();
                        Option<Object> x$381 = c.copy$default$20();
                        Option<String> x$382 = c.copy$default$22();
                        return c.copy(x$362, x$363, x$364, x$365, x$366, x$367, x$368, x$369, x$370, x$371, x$372, x$373, x$374, x$375, x$376, x$377, x$378, x$379, x$380, x$381, (Option<Object>)x$361, x$382);
                    }
                });
                this.opt("optimizerVersion", Read$.MODULE$.stringRead()).text("state optimizer version").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TrainParams apply(String x, Utils.TrainParams c) {
                        Some x$383 = new Some((Object)x);
                        String x$384 = c.copy$default$1();
                        Option<String> x$385 = c.copy$default$2();
                        Option<String> x$386 = c.copy$default$3();
                        Option<String> x$387 = c.copy$default$4();
                        Option<String> x$388 = c.copy$default$5();
                        int x$389 = c.copy$default$6();
                        int x$390 = c.copy$default$7();
                        boolean x$391 = c.copy$default$8();
                        double x$392 = c.copy$default$9();
                        double x$393 = c.copy$default$10();
                        boolean x$394 = c.copy$default$11();
                        int x$395 = c.copy$default$12();
                        double x$396 = c.copy$default$13();
                        double x$397 = c.copy$default$14();
                        boolean x$398 = c.copy$default$15();
                        int x$399 = c.copy$default$16();
                        String x$400 = c.copy$default$17();
                        int x$401 = c.copy$default$18();
                        double x$402 = c.copy$default$19();
                        Option<Object> x$403 = c.copy$default$20();
                        Option<Object> x$404 = c.copy$default$21();
                        return c.copy(x$384, x$385, x$386, x$387, x$388, x$389, x$390, x$391, x$392, x$393, x$394, x$395, x$396, x$397, x$398, x$399, x$400, x$401, x$402, x$403, x$404, (Option<String>)x$383);
                    }
                });
            }
        };
        this.testParser = new OptionParser<Utils.TestParams>(){
            {
                this.opt('f', "folder", Read$.MODULE$.stringRead()).text("where you put the Cifar10 data").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TestParams apply(String x, Utils.TestParams c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3());
                    }
                });
                this.opt("model", Read$.MODULE$.stringRead()).text("model snapshot location").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TestParams apply(String x, Utils.TestParams c) {
                        String x$3 = x;
                        String x$4 = c.copy$default$1();
                        int x$5 = c.copy$default$3();
                        return c.copy(x$4, x$3, x$5);
                    }
                }).required();
                this.opt('b', "batchSize", Read$.MODULE$.intRead()).text("batch size").action(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Utils.TestParams apply(int x, Utils.TestParams c) {
                        int x$6 = x;
                        String x$7 = c.copy$default$1();
                        String x$8 = c.copy$default$2();
                        return c.copy(x$7, x$8, x$6);
                    }
                });
            }
        };
    }
}

